/*! For license information please see access.js.LICENSE.txt */
(()=>{var e={50667:e=>{function t(e){var t=new Error("Cannot find module '"+e+"'");throw t.code="MODULE_NOT_FOUND",t}t.keys=()=>[],t.resolve=t,t.id=50667,e.exports=t},58730:e=>{function t(e){var t=new Error("Cannot find module '"+e+"'");throw t.code="MODULE_NOT_FOUND",t}t.keys=()=>[],t.resolve=t,t.id=58730,e.exports=t},70879:(e,t,r)=>{e=r.nmd(e);try{process.dlopen(e,__dirname+r(71017).sep+r.p+"2bd24d287d25a7c5cb5f2b57057c9dbf.node")}catch(e){throw new Error("node-loader:\n"+e)}},58186:(e,t,r)=>{"use strict";r.d(t,{Z:()=>n});const n='/***********************************************************************\n\n  A JavaScript tokenizer / parser / beautifier / compressor.\n  https://github.com/mishoo/UglifyJS\n\n  -------------------------------- (C) ---------------------------------\n\n                           Author: Mihai Bazon\n                         <mihai.bazon@gmail.com>\n                       http://mihai.bazon.net/blog\n\n  Distributed under the BSD license:\n\n    Copyright 2012 (c) Mihai Bazon <mihai.bazon@gmail.com>\n\n    Redistribution and use in source and binary forms, with or without\n    modification, are permitted provided that the following conditions\n    are met:\n\n        * Redistributions of source code must retain the above\n          copyright notice, this list of conditions and the following\n          disclaimer.\n\n        * Redistributions in binary form must reproduce the above\n          copyright notice, this list of conditions and the following\n          disclaimer in the documentation and/or other materials\n          provided with the distribution.\n\n    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY\n    EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE\n    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,\n    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR\n    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF\n    THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n    SUCH DAMAGE.\n\n ***********************************************************************/\n\n"use strict";\n\nfunction DEFNODE(type, props, methods, base) {\n    if (typeof base === "undefined") base = AST_Node;\n    props = props ? props.split(/\\s+/) : [];\n    var self_props = props;\n    if (base && base.PROPS) props = props.concat(base.PROPS);\n    var code = [\n        "return function AST_", type, "(props){",\n        // not essential, but speeds up compress by a few percent\n        "this._bits=0;",\n        "if(props){",\n    ];\n    props.forEach(function(prop) {\n        code.push("this.", prop, "=props.", prop, ";");\n    });\n    code.push("}");\n    var proto = Object.create(base && base.prototype);\n    if (methods.initialize || proto.initialize) code.push("this.initialize();");\n    code.push("};");\n    var ctor = new Function(code.join(""))();\n    ctor.prototype = proto;\n    ctor.prototype.CTOR = ctor;\n    ctor.prototype.TYPE = ctor.TYPE = type;\n    if (base) {\n        ctor.BASE = base;\n        base.SUBCLASSES.push(ctor);\n    }\n    ctor.DEFMETHOD = function(name, method) {\n        this.prototype[name] = method;\n    };\n    ctor.PROPS = props;\n    ctor.SELF_PROPS = self_props;\n    ctor.SUBCLASSES = [];\n    for (var name in methods) if (HOP(methods, name)) {\n        if (/^\\$/.test(name)) {\n            ctor[name.substr(1)] = methods[name];\n        } else {\n            ctor.DEFMETHOD(name, methods[name]);\n        }\n    }\n    if (typeof exports !== "undefined") exports["AST_" + type] = ctor;\n    return ctor;\n}\n\nvar AST_Token = DEFNODE("Token", "type value line col pos endline endcol endpos nlb comments_before comments_after file raw", {\n}, null);\n\nvar AST_Node = DEFNODE("Node", "start end", {\n    _clone: function(deep) {\n        if (deep) {\n            var self = this.clone();\n            return self.transform(new TreeTransformer(function(node) {\n                if (node !== self) {\n                    return node.clone(true);\n                }\n            }));\n        }\n        return new this.CTOR(this);\n    },\n    clone: function(deep) {\n        return this._clone(deep);\n    },\n    $documentation: "Base class of all AST nodes",\n    $propdoc: {\n        start: "[AST_Token] The first token of this node",\n        end: "[AST_Token] The last token of this node"\n    },\n    equals: function(node) {\n        return this.TYPE == node.TYPE && this._equals(node);\n    },\n    walk: function(visitor) {\n        visitor.visit(this);\n    },\n    _validate: function() {\n        if (this.TYPE == "Node") throw new Error("should not instantiate AST_Node");\n    },\n    validate: function() {\n        var ctor = this.CTOR;\n        do {\n            ctor.prototype._validate.call(this);\n        } while (ctor = ctor.BASE);\n    },\n    validate_ast: function() {\n        var marker = {};\n        this.walk(new TreeWalker(function(node) {\n            if (node.validate_visited === marker) {\n                throw new Error(string_template("cannot reuse AST_{TYPE} from [{start}]", node));\n            }\n            node.validate_visited = marker;\n        }));\n    },\n}, null);\n\nDEF_BITPROPS(AST_Node, [\n    // AST_Node\n    "_optimized",\n    "_squeezed",\n    // AST_Call\n    "call_only",\n    // AST_Lambda\n    "collapse_scanning",\n    // AST_SymbolRef\n    "defined",\n    "evaluating",\n    "falsy",\n    // AST_SymbolRef\n    "in_arg",\n    // AST_Return\n    "in_bool",\n    // AST_SymbolRef\n    "is_undefined",\n    // AST_LambdaExpression\n    // AST_LambdaDefinition\n    "inlined",\n    // AST_Lambda\n    "length_read",\n    // AST_Yield\n    "nested",\n    // AST_Lambda\n    "new",\n    // AST_Call\n    // AST_PropAccess\n    "optional",\n    // AST_ClassProperty\n    "private",\n    // AST_Call\n    "pure",\n    // AST_Node\n    "single_use",\n    // AST_ClassProperty\n    "static",\n    // AST_Call\n    // AST_PropAccess\n    "terminal",\n    "truthy",\n    // AST_Scope\n    "uses_eval",\n    // AST_Scope\n    "uses_with",\n]);\n\n(AST_Node.log_function = function(fn, verbose) {\n    if (typeof fn != "function") {\n        AST_Node.info = AST_Node.warn = noop;\n        return;\n    }\n    var printed = Object.create(null);\n    AST_Node.info = verbose ? function(text, props) {\n        log("INFO: " + string_template(text, props));\n    } : noop;\n    AST_Node.warn = function(text, props) {\n        log("WARN: " + string_template(text, props));\n    };\n\n    function log(msg) {\n        if (printed[msg]) return;\n        printed[msg] = true;\n        fn(msg);\n    }\n})();\n\nvar restore_transforms = [];\nAST_Node.enable_validation = function() {\n    AST_Node.disable_validation();\n    (function validate_transform(ctor) {\n        ctor.SUBCLASSES.forEach(validate_transform);\n        if (!HOP(ctor.prototype, "transform")) return;\n        var transform = ctor.prototype.transform;\n        ctor.prototype.transform = function(tw, in_list) {\n            var node = transform.call(this, tw, in_list);\n            if (node instanceof AST_Node) {\n                node.validate();\n            } else if (!(node === null || in_list && List.is_op(node))) {\n                throw new Error("invalid transformed value: " + node);\n            }\n            return node;\n        };\n        restore_transforms.push(function() {\n            ctor.prototype.transform = transform;\n        });\n    })(this);\n};\n\nAST_Node.disable_validation = function() {\n    var restore;\n    while (restore = restore_transforms.pop()) restore();\n};\n\nfunction all_equals(k, l) {\n    return k.length == l.length && all(k, function(m, i) {\n        return m.equals(l[i]);\n    });\n}\n\nfunction list_equals(s, t) {\n    return s.length == t.length && all(s, function(u, i) {\n        return u == t[i];\n    });\n}\n\nfunction prop_equals(u, v) {\n    if (u === v) return true;\n    if (u == null) return v == null;\n    return u instanceof AST_Node && v instanceof AST_Node && u.equals(v);\n}\n\n/* -----[ statements ]----- */\n\nvar AST_Statement = DEFNODE("Statement", null, {\n    $documentation: "Base class of all statements",\n    _validate: function() {\n        if (this.TYPE == "Statement") throw new Error("should not instantiate AST_Statement");\n    },\n});\n\nvar AST_Debugger = DEFNODE("Debugger", null, {\n    $documentation: "Represents a debugger statement",\n    _equals: return_true,\n}, AST_Statement);\n\nvar AST_Directive = DEFNODE("Directive", "quote value", {\n    $documentation: "Represents a directive, like \\"use strict\\";",\n    $propdoc: {\n        quote: "[string?] the original quote character",\n        value: "[string] The value of this directive as a plain string (it\'s not an AST_String!)",\n    },\n    _equals: function(node) {\n        return this.value == node.value;\n    },\n    _validate: function() {\n        if (this.quote != null) {\n            if (typeof this.quote != "string") throw new Error("quote must be string");\n            if (!/^["\']$/.test(this.quote)) throw new Error("invalid quote: " + this.quote);\n        }\n        if (typeof this.value != "string") throw new Error("value must be string");\n    },\n}, AST_Statement);\n\nvar AST_EmptyStatement = DEFNODE("EmptyStatement", null, {\n    $documentation: "The empty statement (empty block or simply a semicolon)",\n    _equals: return_true,\n}, AST_Statement);\n\nfunction is_statement(node) {\n    return node instanceof AST_Statement\n        && !(node instanceof AST_ClassExpression)\n        && !(node instanceof AST_LambdaExpression);\n}\n\nfunction validate_expression(value, prop, multiple, allow_spread, allow_hole) {\n    multiple = multiple ? "contain" : "be";\n    if (!(value instanceof AST_Node)) throw new Error(prop + " must " + multiple + " AST_Node");\n    if (value instanceof AST_DefaultValue) throw new Error(prop + " cannot " + multiple + " AST_DefaultValue");\n    if (value instanceof AST_Destructured) throw new Error(prop + " cannot " + multiple + " AST_Destructured");\n    if (value instanceof AST_Hole && !allow_hole) throw new Error(prop + " cannot " + multiple + " AST_Hole");\n    if (value instanceof AST_Spread && !allow_spread) throw new Error(prop + " cannot " + multiple + " AST_Spread");\n    if (is_statement(value)) throw new Error(prop + " cannot " + multiple + " AST_Statement");\n    if (value instanceof AST_SymbolDeclaration) {\n        throw new Error(prop + " cannot " + multiple + " AST_SymbolDeclaration");\n    }\n}\n\nfunction must_be_expression(node, prop) {\n    validate_expression(node[prop], prop);\n}\n\nvar AST_SimpleStatement = DEFNODE("SimpleStatement", "body", {\n    $documentation: "A statement consisting of an expression, i.e. a = 1 + 2",\n    $propdoc: {\n        body: "[AST_Node] an expression node (should not be instanceof AST_Statement)",\n    },\n    _equals: function(node) {\n        return this.body.equals(node.body);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.body.walk(visitor);\n        });\n    },\n    _validate: function() {\n        must_be_expression(this, "body");\n    },\n}, AST_Statement);\n\nvar AST_BlockScope = DEFNODE("BlockScope", "_var_names enclosed functions make_def parent_scope variables", {\n    $documentation: "Base class for all statements introducing a lexical scope",\n    $propdoc: {\n        enclosed: "[SymbolDef*/S] a list of all symbol definitions that are accessed from this scope or any inner scopes",\n        functions: "[Dictionary/S] like `variables`, but only lists function declarations",\n        parent_scope: "[AST_Scope?/S] link to the parent scope",\n        variables: "[Dictionary/S] a map of name ---\x3e SymbolDef for all variables/functions defined in this scope",\n    },\n    clone: function(deep) {\n        var node = this._clone(deep);\n        if (this.enclosed) node.enclosed = this.enclosed.slice();\n        if (this.functions) node.functions = this.functions.clone();\n        if (this.variables) node.variables = this.variables.clone();\n        return node;\n    },\n    pinned: function() {\n        return this.resolve().pinned();\n    },\n    resolve: function() {\n        return this.parent_scope.resolve();\n    },\n    _validate: function() {\n        if (this.TYPE == "BlockScope") throw new Error("should not instantiate AST_BlockScope");\n        if (this.parent_scope == null) return;\n        if (!(this.parent_scope instanceof AST_BlockScope)) throw new Error("parent_scope must be AST_BlockScope");\n        if (!(this.resolve() instanceof AST_Scope)) throw new Error("must be contained within AST_Scope");\n    },\n}, AST_Statement);\n\nfunction walk_body(node, visitor) {\n    node.body.forEach(function(node) {\n        node.walk(visitor);\n    });\n}\n\nvar AST_Block = DEFNODE("Block", "body", {\n    $documentation: "A body of statements (usually braced)",\n    $propdoc: {\n        body: "[AST_Statement*] an array of statements"\n    },\n    _equals: function(node) {\n        return all_equals(this.body, node.body);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            walk_body(node, visitor);\n        });\n    },\n    _validate: function() {\n        if (this.TYPE == "Block") throw new Error("should not instantiate AST_Block");\n        this.body.forEach(function(node) {\n            if (!is_statement(node)) throw new Error("body must contain AST_Statement");\n        });\n    },\n}, AST_BlockScope);\n\nvar AST_BlockStatement = DEFNODE("BlockStatement", null, {\n    $documentation: "A block statement",\n}, AST_Block);\n\nvar AST_StatementWithBody = DEFNODE("StatementWithBody", "body", {\n    $documentation: "Base class for all statements that contain one nested body: `For`, `ForIn`, `Do`, `While`, `With`",\n    $propdoc: {\n        body: "[AST_Statement] the body; this should always be present, even if it\'s an AST_EmptyStatement"\n    },\n    _validate: function() {\n        if (this.TYPE == "StatementWithBody") throw new Error("should not instantiate AST_StatementWithBody");\n        if (!is_statement(this.body)) throw new Error("body must be AST_Statement");\n    },\n}, AST_BlockScope);\n\nvar AST_LabeledStatement = DEFNODE("LabeledStatement", "label", {\n    $documentation: "Statement with a label",\n    $propdoc: {\n        label: "[AST_Label] a label definition"\n    },\n    _equals: function(node) {\n        return this.label.equals(node.label)\n            && this.body.equals(node.body);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.label.walk(visitor);\n            node.body.walk(visitor);\n        });\n    },\n    clone: function(deep) {\n        var node = this._clone(deep);\n        if (deep) {\n            var label = node.label;\n            var def = this.label;\n            node.walk(new TreeWalker(function(node) {\n                if (node instanceof AST_LoopControl) {\n                    if (!node.label || node.label.thedef !== def) return;\n                    node.label.thedef = label;\n                    label.references.push(node);\n                    return true;\n                }\n                if (node instanceof AST_Scope) return true;\n            }));\n        }\n        return node;\n    },\n    _validate: function() {\n        if (!(this.label instanceof AST_Label)) throw new Error("label must be AST_Label");\n    },\n}, AST_StatementWithBody);\n\nvar AST_IterationStatement = DEFNODE("IterationStatement", null, {\n    $documentation: "Internal class.  All loops inherit from it.",\n    _validate: function() {\n        if (this.TYPE == "IterationStatement") throw new Error("should not instantiate AST_IterationStatement");\n    },\n}, AST_StatementWithBody);\n\nvar AST_DWLoop = DEFNODE("DWLoop", "condition", {\n    $documentation: "Base class for do/while statements",\n    $propdoc: {\n        condition: "[AST_Node] the loop condition.  Should not be instanceof AST_Statement"\n    },\n    _equals: function(node) {\n        return this.body.equals(node.body)\n            && this.condition.equals(node.condition);\n    },\n    _validate: function() {\n        if (this.TYPE == "DWLoop") throw new Error("should not instantiate AST_DWLoop");\n        must_be_expression(this, "condition");\n    },\n}, AST_IterationStatement);\n\nvar AST_Do = DEFNODE("Do", null, {\n    $documentation: "A `do` statement",\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.body.walk(visitor);\n            node.condition.walk(visitor);\n        });\n    },\n}, AST_DWLoop);\n\nvar AST_While = DEFNODE("While", null, {\n    $documentation: "A `while` statement",\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.condition.walk(visitor);\n            node.body.walk(visitor);\n        });\n    },\n}, AST_DWLoop);\n\nvar AST_For = DEFNODE("For", "init condition step", {\n    $documentation: "A `for` statement",\n    $propdoc: {\n        init: "[AST_Node?] the `for` initialization code, or null if empty",\n        condition: "[AST_Node?] the `for` termination clause, or null if empty",\n        step: "[AST_Node?] the `for` update clause, or null if empty"\n    },\n    _equals: function(node) {\n        return prop_equals(this.init, node.init)\n            && prop_equals(this.condition, node.condition)\n            && prop_equals(this.step, node.step)\n            && this.body.equals(node.body);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            if (node.init) node.init.walk(visitor);\n            if (node.condition) node.condition.walk(visitor);\n            if (node.step) node.step.walk(visitor);\n            node.body.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (this.init != null) {\n            if (!(this.init instanceof AST_Node)) throw new Error("init must be AST_Node");\n            if (is_statement(this.init) && !(this.init instanceof AST_Definitions)) {\n                throw new Error("init cannot be AST_Statement");\n            }\n        }\n        if (this.condition != null) must_be_expression(this, "condition");\n        if (this.step != null) must_be_expression(this, "step");\n    },\n}, AST_IterationStatement);\n\nvar AST_ForEnumeration = DEFNODE("ForEnumeration", "init object", {\n    $documentation: "Base class for enumeration loops, i.e. `for ... in`, `for ... of` & `for await ... of`",\n    $propdoc: {\n        init: "[AST_Node] the assignment target during iteration",\n        object: "[AST_Node] the object to iterate over"\n    },\n    _equals: function(node) {\n        return this.init.equals(node.init)\n            && this.object.equals(node.object)\n            && this.body.equals(node.body);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.init.walk(visitor);\n            node.object.walk(visitor);\n            node.body.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (this.TYPE == "ForEnumeration") throw new Error("should not instantiate AST_ForEnumeration");\n        if (this.init instanceof AST_Definitions) {\n            if (this.init.definitions.length != 1) throw new Error("init must have single declaration");\n        } else {\n            validate_destructured(this.init, function(node) {\n                if (!(node instanceof AST_PropAccess || node instanceof AST_SymbolRef)) {\n                    throw new Error("init must be assignable: " + node.TYPE);\n                }\n            });\n        }\n        must_be_expression(this, "object");\n    },\n}, AST_IterationStatement);\n\nvar AST_ForIn = DEFNODE("ForIn", null, {\n    $documentation: "A `for ... in` statement",\n}, AST_ForEnumeration);\n\nvar AST_ForOf = DEFNODE("ForOf", null, {\n    $documentation: "A `for ... of` statement",\n}, AST_ForEnumeration);\n\nvar AST_ForAwaitOf = DEFNODE("ForAwaitOf", null, {\n    $documentation: "A `for await ... of` statement",\n}, AST_ForOf);\n\nvar AST_With = DEFNODE("With", "expression", {\n    $documentation: "A `with` statement",\n    $propdoc: {\n        expression: "[AST_Node] the `with` expression"\n    },\n    _equals: function(node) {\n        return this.expression.equals(node.expression)\n            && this.body.equals(node.body);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.expression.walk(visitor);\n            node.body.walk(visitor);\n        });\n    },\n    _validate: function() {\n        must_be_expression(this, "expression");\n    },\n}, AST_StatementWithBody);\n\n/* -----[ scope and functions ]----- */\n\nvar AST_Scope = DEFNODE("Scope", "fn_defs may_call_this uses_eval uses_with", {\n    $documentation: "Base class for all statements introducing a lambda scope",\n    $propdoc: {\n        uses_eval: "[boolean/S] tells whether this scope contains a direct call to the global `eval`",\n        uses_with: "[boolean/S] tells whether this scope uses the `with` statement",\n    },\n    pinned: function() {\n        return this.uses_eval || this.uses_with;\n    },\n    resolve: return_this,\n    _validate: function() {\n        if (this.TYPE == "Scope") throw new Error("should not instantiate AST_Scope");\n    },\n}, AST_Block);\n\nvar AST_Toplevel = DEFNODE("Toplevel", "globals", {\n    $documentation: "The toplevel scope",\n    $propdoc: {\n        globals: "[Dictionary/S] a map of name ---\x3e SymbolDef for all undeclared names",\n    },\n    wrap: function(name) {\n        var body = this.body;\n        return parse([\n            "(function(exports){\'$ORIG\';})(typeof ",\n            name,\n            "==\'undefined\'?(",\n            name,\n            "={}):",\n            name,\n            ");"\n        ].join(""), {\n            filename: "wrap=" + JSON.stringify(name)\n        }).transform(new TreeTransformer(function(node) {\n            if (node instanceof AST_Directive && node.value == "$ORIG") {\n                return List.splice(body);\n            }\n        }));\n    },\n    enclose: function(args_values) {\n        if (typeof args_values != "string") args_values = "";\n        var index = args_values.indexOf(":");\n        if (index < 0) index = args_values.length;\n        var body = this.body;\n        return parse([\n            "(function(",\n            args_values.slice(0, index),\n            \'){"$ORIG"})(\',\n            args_values.slice(index + 1),\n            ")"\n        ].join(""), {\n            filename: "enclose=" + JSON.stringify(args_values)\n        }).transform(new TreeTransformer(function(node) {\n            if (node instanceof AST_Directive && node.value == "$ORIG") {\n                return List.splice(body);\n            }\n        }));\n    }\n}, AST_Scope);\n\nvar AST_ClassInitBlock = DEFNODE("ClassInitBlock", null, {\n    $documentation: "Value for `class` static initialization blocks",\n}, AST_Scope);\n\nvar AST_Lambda = DEFNODE("Lambda", "argnames length_read rest safe_ids uses_arguments", {\n    $documentation: "Base class for functions",\n    $propdoc: {\n        argnames: "[(AST_DefaultValue|AST_Destructured|AST_SymbolFunarg)*] array of function arguments and/or destructured literals",\n        length_read: "[boolean/S] whether length property of this function is accessed",\n        rest: "[(AST_Destructured|AST_SymbolFunarg)?] rest parameter, or null if absent",\n        uses_arguments: "[boolean|number/S] whether this function accesses the arguments array",\n    },\n    each_argname: function(visit) {\n        var tw = new TreeWalker(function(node) {\n            if (node instanceof AST_DefaultValue) {\n                node.name.walk(tw);\n                return true;\n            }\n            if (node instanceof AST_DestructuredKeyVal) {\n                node.value.walk(tw);\n                return true;\n            }\n            if (node instanceof AST_SymbolFunarg) visit(node);\n        });\n        this.argnames.forEach(function(argname) {\n            argname.walk(tw);\n        });\n        if (this.rest) this.rest.walk(tw);\n    },\n    _equals: function(node) {\n        return prop_equals(this.rest, node.rest)\n            && prop_equals(this.name, node.name)\n            && prop_equals(this.value, node.value)\n            && all_equals(this.argnames, node.argnames)\n            && all_equals(this.body, node.body);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            if (node.name) node.name.walk(visitor);\n            node.argnames.forEach(function(argname) {\n                argname.walk(visitor);\n            });\n            if (node.rest) node.rest.walk(visitor);\n            walk_body(node, visitor);\n        });\n    },\n    _validate: function() {\n        if (this.TYPE == "Lambda") throw new Error("should not instantiate AST_Lambda");\n        this.argnames.forEach(function(node) {\n            validate_destructured(node, function(node) {\n                if (!(node instanceof AST_SymbolFunarg)) throw new Error("argnames must be AST_SymbolFunarg[]");\n            }, true);\n        });\n        if (this.rest != null) validate_destructured(this.rest, function(node) {\n            if (!(node instanceof AST_SymbolFunarg)) throw new Error("rest must be AST_SymbolFunarg");\n        });\n    },\n}, AST_Scope);\n\nvar AST_Accessor = DEFNODE("Accessor", null, {\n    $documentation: "A getter/setter function",\n    _validate: function() {\n        if (this.name != null) throw new Error("name must be null");\n    },\n}, AST_Lambda);\n\nvar AST_LambdaExpression = DEFNODE("LambdaExpression", "inlined", {\n    $documentation: "Base class for function expressions",\n    $propdoc: {\n        inlined: "[boolean/S] whether this function has been inlined",\n    },\n    _validate: function() {\n        if (this.TYPE == "LambdaExpression") throw new Error("should not instantiate AST_LambdaExpression");\n    },\n}, AST_Lambda);\n\nfunction is_arrow(node) {\n    return node instanceof AST_Arrow || node instanceof AST_AsyncArrow;\n}\n\nfunction is_async(node) {\n    return node instanceof AST_AsyncArrow\n        || node instanceof AST_AsyncDefun\n        || node instanceof AST_AsyncFunction\n        || node instanceof AST_AsyncGeneratorDefun\n        || node instanceof AST_AsyncGeneratorFunction;\n}\n\nfunction is_generator(node) {\n    return node instanceof AST_AsyncGeneratorDefun\n        || node instanceof AST_AsyncGeneratorFunction\n        || node instanceof AST_GeneratorDefun\n        || node instanceof AST_GeneratorFunction;\n}\n\nfunction walk_lambda(node, tw) {\n    if (is_arrow(node) && node.value) {\n        node.value.walk(tw);\n    } else {\n        walk_body(node, tw);\n    }\n}\n\nvar AST_Arrow = DEFNODE("Arrow", "value", {\n    $documentation: "An arrow function expression",\n    $propdoc: {\n        value: "[AST_Node?] simple return expression, or null if using function body.",\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.argnames.forEach(function(argname) {\n                argname.walk(visitor);\n            });\n            if (node.rest) node.rest.walk(visitor);\n            if (node.value) {\n                node.value.walk(visitor);\n            } else {\n                walk_body(node, visitor);\n            }\n        });\n    },\n    _validate: function() {\n        if (this.name != null) throw new Error("name must be null");\n        if (this.uses_arguments) throw new Error("uses_arguments must be false");\n        if (this.value != null) {\n            must_be_expression(this, "value");\n            if (this.body.length) throw new Error("body must be empty if value exists");\n        }\n    },\n}, AST_LambdaExpression);\n\nvar AST_AsyncArrow = DEFNODE("AsyncArrow", "value", {\n    $documentation: "An asynchronous arrow function expression",\n    $propdoc: {\n        value: "[AST_Node?] simple return expression, or null if using function body.",\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.argnames.forEach(function(argname) {\n                argname.walk(visitor);\n            });\n            if (node.rest) node.rest.walk(visitor);\n            if (node.value) {\n                node.value.walk(visitor);\n            } else {\n                walk_body(node, visitor);\n            }\n        });\n    },\n    _validate: function() {\n        if (this.name != null) throw new Error("name must be null");\n        if (this.uses_arguments) throw new Error("uses_arguments must be false");\n        if (this.value != null) {\n            must_be_expression(this, "value");\n            if (this.body.length) throw new Error("body must be empty if value exists");\n        }\n    },\n}, AST_LambdaExpression);\n\nvar AST_AsyncFunction = DEFNODE("AsyncFunction", "name", {\n    $documentation: "An asynchronous function expression",\n    $propdoc: {\n        name: "[AST_SymbolLambda?] the name of this function, or null if not specified",\n    },\n    _validate: function() {\n        if (this.name != null) {\n            if (!(this.name instanceof AST_SymbolLambda)) throw new Error("name must be AST_SymbolLambda");\n        }\n    },\n}, AST_LambdaExpression);\n\nvar AST_AsyncGeneratorFunction = DEFNODE("AsyncGeneratorFunction", "name", {\n    $documentation: "An asynchronous generator function expression",\n    $propdoc: {\n        name: "[AST_SymbolLambda?] the name of this function, or null if not specified",\n    },\n    _validate: function() {\n        if (this.name != null) {\n            if (!(this.name instanceof AST_SymbolLambda)) throw new Error("name must be AST_SymbolLambda");\n        }\n    },\n}, AST_LambdaExpression);\n\nvar AST_Function = DEFNODE("Function", "name", {\n    $documentation: "A function expression",\n    $propdoc: {\n        name: "[AST_SymbolLambda?] the name of this function, or null if not specified",\n    },\n    _validate: function() {\n        if (this.name != null) {\n            if (!(this.name instanceof AST_SymbolLambda)) throw new Error("name must be AST_SymbolLambda");\n        }\n    },\n}, AST_LambdaExpression);\n\nvar AST_GeneratorFunction = DEFNODE("GeneratorFunction", "name", {\n    $documentation: "A generator function expression",\n    $propdoc: {\n        name: "[AST_SymbolLambda?] the name of this function, or null if not specified",\n    },\n    _validate: function() {\n        if (this.name != null) {\n            if (!(this.name instanceof AST_SymbolLambda)) throw new Error("name must be AST_SymbolLambda");\n        }\n    },\n}, AST_LambdaExpression);\n\nvar AST_LambdaDefinition = DEFNODE("LambdaDefinition", "inlined name", {\n    $documentation: "Base class for function definitions",\n    $propdoc: {\n        inlined: "[boolean/S] whether this function has been inlined",\n        name: "[AST_SymbolDefun] the name of this function",\n    },\n    _validate: function() {\n        if (this.TYPE == "LambdaDefinition") throw new Error("should not instantiate AST_LambdaDefinition");\n        if (!(this.name instanceof AST_SymbolDefun)) throw new Error("name must be AST_SymbolDefun");\n    },\n}, AST_Lambda);\n\nvar AST_AsyncDefun = DEFNODE("AsyncDefun", null, {\n    $documentation: "An asynchronous function definition",\n}, AST_LambdaDefinition);\n\nvar AST_AsyncGeneratorDefun = DEFNODE("AsyncGeneratorDefun", null, {\n    $documentation: "An asynchronous generator function definition",\n}, AST_LambdaDefinition);\n\nvar AST_Defun = DEFNODE("Defun", null, {\n    $documentation: "A function definition",\n}, AST_LambdaDefinition);\n\nvar AST_GeneratorDefun = DEFNODE("GeneratorDefun", null, {\n    $documentation: "A generator function definition",\n}, AST_LambdaDefinition);\n\n/* -----[ classes ]----- */\n\nvar AST_Class = DEFNODE("Class", "extends name properties", {\n    $documentation: "Base class for class literals",\n    $propdoc: {\n        extends: "[AST_Node?] the super class, or null if not specified",\n        properties: "[AST_ClassProperty*] array of class properties",\n    },\n    _equals: function(node) {\n        return prop_equals(this.name, node.name)\n            && prop_equals(this.extends, node.extends)\n            && all_equals(this.properties, node.properties);\n    },\n    resolve: function(def_class) {\n        return def_class ? this : this.parent_scope.resolve();\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            if (node.name) node.name.walk(visitor);\n            if (node.extends) node.extends.walk(visitor);\n            node.properties.forEach(function(prop) {\n                prop.walk(visitor);\n            });\n        });\n    },\n    _validate: function() {\n        if (this.TYPE == "Class") throw new Error("should not instantiate AST_Class");\n        if (this.extends != null) must_be_expression(this, "extends");\n        this.properties.forEach(function(node) {\n            if (!(node instanceof AST_ClassProperty)) throw new Error("properties must contain AST_ClassProperty");\n        });\n    },\n}, AST_BlockScope);\n\nvar AST_DefClass = DEFNODE("DefClass", null, {\n    $documentation: "A class definition",\n    $propdoc: {\n        name: "[AST_SymbolDefClass] the name of this class",\n    },\n    _validate: function() {\n        if (!(this.name instanceof AST_SymbolDefClass)) throw new Error("name must be AST_SymbolDefClass");\n    },\n}, AST_Class);\n\nvar AST_ClassExpression = DEFNODE("ClassExpression", null, {\n    $documentation: "A class expression",\n    $propdoc: {\n        name: "[AST_SymbolClass?] the name of this class, or null if not specified",\n    },\n    _validate: function() {\n        if (this.name != null) {\n            if (!(this.name instanceof AST_SymbolClass)) throw new Error("name must be AST_SymbolClass");\n        }\n    },\n}, AST_Class);\n\nvar AST_ClassProperty = DEFNODE("ClassProperty", "key private static value", {\n    $documentation: "Base class for `class` properties",\n    $propdoc: {\n        key: "[string|AST_Node?] property name (AST_Node for computed property, null for initialization block)",\n        private: "[boolean] whether this is a private property",\n        static: "[boolean] whether this is a static property",\n        value: "[AST_Node?] property value (AST_Accessor for getters/setters, AST_LambdaExpression for methods, null if not specified for fields)",\n    },\n    _equals: function(node) {\n        return !this.private == !node.private\n            && !this.static == !node.static\n            && prop_equals(this.key, node.key)\n            && prop_equals(this.value, node.value);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            if (node.key instanceof AST_Node) node.key.walk(visitor);\n            if (node.value) node.value.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (this.TYPE == "ClassProperty") throw new Error("should not instantiate AST_ClassProperty");\n        if (this instanceof AST_ClassInit) {\n            if (this.key != null) throw new Error("key must be null");\n        } else if (typeof this.key != "string") {\n            if (!(this.key instanceof AST_Node)) throw new Error("key must be string or AST_Node");\n            if (this.private) throw new Error("computed key cannot be private");\n            must_be_expression(this, "key");\n        } else if (this.private) {\n            if (!/^#/.test(this.key)) throw new Error("private key must prefix with #");\n        }\n        if (this.value != null) {\n            if (!(this.value instanceof AST_Node)) throw new Error("value must be AST_Node");\n        }\n    },\n});\n\nvar AST_ClassField = DEFNODE("ClassField", null, {\n    $documentation: "A `class` field",\n    _validate: function() {\n        if (this.value != null) must_be_expression(this, "value");\n    },\n}, AST_ClassProperty);\n\nvar AST_ClassGetter = DEFNODE("ClassGetter", null, {\n    $documentation: "A `class` getter",\n    _validate: function() {\n        if (!(this.value instanceof AST_Accessor)) throw new Error("value must be AST_Accessor");\n    },\n}, AST_ClassProperty);\n\nvar AST_ClassSetter = DEFNODE("ClassSetter", null, {\n    $documentation: "A `class` setter",\n    _validate: function() {\n        if (!(this.value instanceof AST_Accessor)) throw new Error("value must be AST_Accessor");\n    },\n}, AST_ClassProperty);\n\nvar AST_ClassMethod = DEFNODE("ClassMethod", null, {\n    $documentation: "A `class` method",\n    _validate: function() {\n        if (!(this.value instanceof AST_LambdaExpression)) throw new Error("value must be AST_LambdaExpression");\n        if (is_arrow(this.value)) throw new Error("value cannot be AST_Arrow or AST_AsyncArrow");\n        if (this.value.name != null) throw new Error("name of class method\'s lambda must be null");\n    },\n}, AST_ClassProperty);\n\nvar AST_ClassInit = DEFNODE("ClassInit", null, {\n    $documentation: "A `class` static initialization block",\n    _validate: function() {\n        if (!this.static) throw new Error("static must be true");\n        if (!(this.value instanceof AST_ClassInitBlock)) throw new Error("value must be AST_ClassInitBlock");\n    },\n    initialize: function() {\n        this.static = true;\n    },\n}, AST_ClassProperty);\n\n/* -----[ JUMPS ]----- */\n\nvar AST_Jump = DEFNODE("Jump", null, {\n    $documentation: "Base class for “jumps” (for now that\'s `return`, `throw`, `break` and `continue`)",\n    _validate: function() {\n        if (this.TYPE == "Jump") throw new Error("should not instantiate AST_Jump");\n    },\n}, AST_Statement);\n\nvar AST_Exit = DEFNODE("Exit", "value", {\n    $documentation: "Base class for “exits” (`return` and `throw`)",\n    $propdoc: {\n        value: "[AST_Node?] the value returned or thrown by this statement; could be null for AST_Return"\n    },\n    _equals: function(node) {\n        return prop_equals(this.value, node.value);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            if (node.value) node.value.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (this.TYPE == "Exit") throw new Error("should not instantiate AST_Exit");\n    },\n}, AST_Jump);\n\nvar AST_Return = DEFNODE("Return", null, {\n    $documentation: "A `return` statement",\n    _validate: function() {\n        if (this.value != null) must_be_expression(this, "value");\n    },\n}, AST_Exit);\n\nvar AST_Throw = DEFNODE("Throw", null, {\n    $documentation: "A `throw` statement",\n    _validate: function() {\n        must_be_expression(this, "value");\n    },\n}, AST_Exit);\n\nvar AST_LoopControl = DEFNODE("LoopControl", "label", {\n    $documentation: "Base class for loop control statements (`break` and `continue`)",\n    $propdoc: {\n        label: "[AST_LabelRef?] the label, or null if none",\n    },\n    _equals: function(node) {\n        return prop_equals(this.label, node.label);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            if (node.label) node.label.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (this.TYPE == "LoopControl") throw new Error("should not instantiate AST_LoopControl");\n        if (this.label != null) {\n            if (!(this.label instanceof AST_LabelRef)) throw new Error("label must be AST_LabelRef");\n        }\n    },\n}, AST_Jump);\n\nvar AST_Break = DEFNODE("Break", null, {\n    $documentation: "A `break` statement"\n}, AST_LoopControl);\n\nvar AST_Continue = DEFNODE("Continue", null, {\n    $documentation: "A `continue` statement"\n}, AST_LoopControl);\n\n/* -----[ IF ]----- */\n\nvar AST_If = DEFNODE("If", "condition alternative", {\n    $documentation: "A `if` statement",\n    $propdoc: {\n        condition: "[AST_Node] the `if` condition",\n        alternative: "[AST_Statement?] the `else` part, or null if not present"\n    },\n    _equals: function(node) {\n        return this.body.equals(node.body)\n            && this.condition.equals(node.condition)\n            && prop_equals(this.alternative, node.alternative);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.condition.walk(visitor);\n            node.body.walk(visitor);\n            if (node.alternative) node.alternative.walk(visitor);\n        });\n    },\n    _validate: function() {\n        must_be_expression(this, "condition");\n        if (this.alternative != null) {\n            if (!is_statement(this.alternative)) throw new Error("alternative must be AST_Statement");\n        }\n    },\n}, AST_StatementWithBody);\n\n/* -----[ SWITCH ]----- */\n\nvar AST_Switch = DEFNODE("Switch", "expression", {\n    $documentation: "A `switch` statement",\n    $propdoc: {\n        expression: "[AST_Node] the `switch` “discriminant”"\n    },\n    _equals: function(node) {\n        return this.expression.equals(node.expression)\n            && all_equals(this.body, node.body);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.expression.walk(visitor);\n            walk_body(node, visitor);\n        });\n    },\n    _validate: function() {\n        must_be_expression(this, "expression");\n        this.body.forEach(function(node) {\n            if (!(node instanceof AST_SwitchBranch)) throw new Error("body must be AST_SwitchBranch[]");\n        });\n    },\n}, AST_Block);\n\nvar AST_SwitchBranch = DEFNODE("SwitchBranch", null, {\n    $documentation: "Base class for `switch` branches",\n    _validate: function() {\n        if (this.TYPE == "SwitchBranch") throw new Error("should not instantiate AST_SwitchBranch");\n    },\n}, AST_Block);\n\nvar AST_Default = DEFNODE("Default", null, {\n    $documentation: "A `default` switch branch",\n}, AST_SwitchBranch);\n\nvar AST_Case = DEFNODE("Case", "expression", {\n    $documentation: "A `case` switch branch",\n    $propdoc: {\n        expression: "[AST_Node] the `case` expression"\n    },\n    _equals: function(node) {\n        return this.expression.equals(node.expression)\n            && all_equals(this.body, node.body);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.expression.walk(visitor);\n            walk_body(node, visitor);\n        });\n    },\n    _validate: function() {\n        must_be_expression(this, "expression");\n    },\n}, AST_SwitchBranch);\n\n/* -----[ EXCEPTIONS ]----- */\n\nvar AST_Try = DEFNODE("Try", "bcatch bfinally", {\n    $documentation: "A `try` statement",\n    $propdoc: {\n        bcatch: "[AST_Catch?] the catch block, or null if not present",\n        bfinally: "[AST_Finally?] the finally block, or null if not present"\n    },\n    _equals: function(node) {\n        return all_equals(this.body, node.body)\n            && prop_equals(this.bcatch, node.bcatch)\n            && prop_equals(this.bfinally, node.bfinally);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            walk_body(node, visitor);\n            if (node.bcatch) node.bcatch.walk(visitor);\n            if (node.bfinally) node.bfinally.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (this.bcatch != null) {\n            if (!(this.bcatch instanceof AST_Catch)) throw new Error("bcatch must be AST_Catch");\n        }\n        if (this.bfinally != null) {\n            if (!(this.bfinally instanceof AST_Finally)) throw new Error("bfinally must be AST_Finally");\n        }\n    },\n}, AST_Block);\n\nvar AST_Catch = DEFNODE("Catch", "argname", {\n    $documentation: "A `catch` node; only makes sense as part of a `try` statement",\n    $propdoc: {\n        argname: "[(AST_Destructured|AST_SymbolCatch)?] symbol for the exception, or null if not present",\n    },\n    _equals: function(node) {\n        return prop_equals(this.argname, node.argname)\n            && all_equals(this.body, node.body);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            if (node.argname) node.argname.walk(visitor);\n            walk_body(node, visitor);\n        });\n    },\n    _validate: function() {\n        if (this.argname != null) validate_destructured(this.argname, function(node) {\n            if (!(node instanceof AST_SymbolCatch)) throw new Error("argname must be AST_SymbolCatch");\n        });\n    },\n}, AST_Block);\n\nvar AST_Finally = DEFNODE("Finally", null, {\n    $documentation: "A `finally` node; only makes sense as part of a `try` statement"\n}, AST_Block);\n\n/* -----[ VAR ]----- */\n\nvar AST_Definitions = DEFNODE("Definitions", "definitions", {\n    $documentation: "Base class for `var` nodes (variable declarations/initializations)",\n    $propdoc: {\n        definitions: "[AST_VarDef*] array of variable definitions"\n    },\n    _equals: function(node) {\n        return all_equals(this.definitions, node.definitions);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.definitions.forEach(function(defn) {\n                defn.walk(visitor);\n            });\n        });\n    },\n    _validate: function() {\n        if (this.TYPE == "Definitions") throw new Error("should not instantiate AST_Definitions");\n        if (this.definitions.length < 1) throw new Error("must have at least one definition");\n    },\n}, AST_Statement);\n\nvar AST_Const = DEFNODE("Const", null, {\n    $documentation: "A `const` statement",\n    _validate: function() {\n        this.definitions.forEach(function(node) {\n            if (!(node instanceof AST_VarDef)) throw new Error("definitions must be AST_VarDef[]");\n            validate_destructured(node.name, function(node) {\n                if (!(node instanceof AST_SymbolConst)) throw new Error("name must be AST_SymbolConst");\n            });\n        });\n    },\n}, AST_Definitions);\n\nvar AST_Let = DEFNODE("Let", null, {\n    $documentation: "A `let` statement",\n    _validate: function() {\n        this.definitions.forEach(function(node) {\n            if (!(node instanceof AST_VarDef)) throw new Error("definitions must be AST_VarDef[]");\n            validate_destructured(node.name, function(node) {\n                if (!(node instanceof AST_SymbolLet)) throw new Error("name must be AST_SymbolLet");\n            });\n        });\n    },\n}, AST_Definitions);\n\nvar AST_Var = DEFNODE("Var", null, {\n    $documentation: "A `var` statement",\n    _validate: function() {\n        this.definitions.forEach(function(node) {\n            if (!(node instanceof AST_VarDef)) throw new Error("definitions must be AST_VarDef[]");\n            validate_destructured(node.name, function(node) {\n                if (!(node instanceof AST_SymbolVar)) throw new Error("name must be AST_SymbolVar");\n            });\n        });\n    },\n}, AST_Definitions);\n\nvar AST_VarDef = DEFNODE("VarDef", "name value", {\n    $documentation: "A variable declaration; only appears in a AST_Definitions node",\n    $propdoc: {\n        name: "[AST_Destructured|AST_SymbolVar] name of the variable",\n        value: "[AST_Node?] initializer, or null of there\'s no initializer",\n    },\n    _equals: function(node) {\n        return this.name.equals(node.name)\n            && prop_equals(this.value, node.value);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.name.walk(visitor);\n            if (node.value) node.value.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (this.value != null) must_be_expression(this, "value");\n    },\n});\n\n/* -----[ OTHER ]----- */\n\nvar AST_ExportDeclaration = DEFNODE("ExportDeclaration", "body", {\n    $documentation: "An `export` statement",\n    $propdoc: {\n        body: "[AST_DefClass|AST_Definitions|AST_LambdaDefinition] the statement to export",\n    },\n    _equals: function(node) {\n        return this.body.equals(node.body);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.body.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (!(this.body instanceof AST_DefClass\n            || this.body instanceof AST_Definitions\n            || this.body instanceof AST_LambdaDefinition)) {\n            throw new Error("body must be AST_DefClass, AST_Definitions or AST_LambdaDefinition");\n        }\n    },\n}, AST_Statement);\n\nvar AST_ExportDefault = DEFNODE("ExportDefault", "body", {\n    $documentation: "An `export default` statement",\n    $propdoc: {\n        body: "[AST_Node] the default export",\n    },\n    _equals: function(node) {\n        return this.body.equals(node.body);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.body.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (!(this.body instanceof AST_DefClass || this.body instanceof AST_LambdaDefinition)) {\n            must_be_expression(this, "body");\n        }\n    },\n}, AST_Statement);\n\nvar AST_ExportForeign = DEFNODE("ExportForeign", "aliases keys path", {\n    $documentation: "An `export ... from \'...\'` statement",\n    $propdoc: {\n        aliases: "[AST_String*] array of aliases to export",\n        keys: "[AST_String*] array of keys to import",\n        path: "[AST_String] the path to import module",\n    },\n    _equals: function(node) {\n        return this.path.equals(node.path)\n            && all_equals(this.aliases, node.aliases)\n            && all_equals(this.keys, node.keys);\n    },\n    _validate: function() {\n        if (this.aliases.length != this.keys.length) {\n            throw new Error("aliases:key length mismatch: " + this.aliases.length + " != " + this.keys.length);\n        }\n        this.aliases.forEach(function(name) {\n            if (!(name instanceof AST_String)) throw new Error("aliases must contain AST_String");\n        });\n        this.keys.forEach(function(name) {\n            if (!(name instanceof AST_String)) throw new Error("keys must contain AST_String");\n        });\n        if (!(this.path instanceof AST_String)) throw new Error("path must be AST_String");\n    },\n}, AST_Statement);\n\nvar AST_ExportReferences = DEFNODE("ExportReferences", "properties", {\n    $documentation: "An `export { ... }` statement",\n    $propdoc: {\n        properties: "[AST_SymbolExport*] array of aliases to export",\n    },\n    _equals: function(node) {\n        return all_equals(this.properties, node.properties);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.properties.forEach(function(prop) {\n                prop.walk(visitor);\n            });\n        });\n    },\n    _validate: function() {\n        this.properties.forEach(function(prop) {\n            if (!(prop instanceof AST_SymbolExport)) throw new Error("properties must contain AST_SymbolExport");\n        });\n    },\n}, AST_Statement);\n\nvar AST_Import = DEFNODE("Import", "all default path properties", {\n    $documentation: "An `import` statement",\n    $propdoc: {\n        all: "[AST_SymbolImport?] the imported namespace, or null if not specified",\n        default: "[AST_SymbolImport?] the alias for default `export`, or null if not specified",\n        path: "[AST_String] the path to import module",\n        properties: "[(AST_SymbolImport*)?] array of aliases, or null if not specified",\n    },\n    _equals: function(node) {\n        return this.path.equals(node.path)\n            && prop_equals(this.all, node.all)\n            && prop_equals(this.default, node.default)\n            && !this.properties == !node.properties\n            && (!this.properties || all_equals(this.properties, node.properties));\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            if (node.all) node.all.walk(visitor);\n            if (node.default) node.default.walk(visitor);\n            if (node.properties) node.properties.forEach(function(prop) {\n                prop.walk(visitor);\n            });\n        });\n    },\n    _validate: function() {\n        if (this.all != null) {\n            if (!(this.all instanceof AST_SymbolImport)) throw new Error("all must be AST_SymbolImport");\n            if (this.properties != null) throw new Error("cannot import both * and {} in the same statement");\n        }\n        if (this.default != null) {\n            if (!(this.default instanceof AST_SymbolImport)) throw new Error("default must be AST_SymbolImport");\n            if (this.default.key.value !== "") throw new Error("invalid default key: " + this.default.key.value);\n        }\n        if (!(this.path instanceof AST_String)) throw new Error("path must be AST_String");\n        if (this.properties != null) this.properties.forEach(function(node) {\n            if (!(node instanceof AST_SymbolImport)) throw new Error("properties must contain AST_SymbolImport");\n        });\n    },\n}, AST_Statement);\n\nvar AST_DefaultValue = DEFNODE("DefaultValue", "name value", {\n    $documentation: "A default value declaration",\n    $propdoc: {\n        name: "[AST_Destructured|AST_SymbolDeclaration] name of the variable",\n        value: "[AST_Node] value to assign if variable is `undefined`",\n    },\n    _equals: function(node) {\n        return this.name.equals(node.name)\n            && this.value.equals(node.value);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.name.walk(visitor);\n            node.value.walk(visitor);\n        });\n    },\n    _validate: function() {\n        must_be_expression(this, "value");\n    },\n});\n\nfunction must_be_expressions(node, prop, allow_spread, allow_hole) {\n    node[prop].forEach(function(node) {\n        validate_expression(node, prop, true, allow_spread, allow_hole);\n    });\n}\n\nvar AST_Call = DEFNODE("Call", "args expression optional pure terminal", {\n    $documentation: "A function call expression",\n    $propdoc: {\n        args: "[AST_Node*] array of arguments",\n        expression: "[AST_Node] expression to invoke as function",\n        optional: "[boolean] whether the expression is optional chaining",\n        pure: "[boolean/S] marker for side-effect-free call expression",\n        terminal: "[boolean] whether the chain has ended",\n    },\n    _equals: function(node) {\n        return !this.optional == !node.optional\n            && this.expression.equals(node.expression)\n            && all_equals(this.args, node.args);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.expression.walk(visitor);\n            node.args.forEach(function(arg) {\n                arg.walk(visitor);\n            });\n        });\n    },\n    _validate: function() {\n        must_be_expression(this, "expression");\n        must_be_expressions(this, "args", true);\n    },\n});\n\nvar AST_New = DEFNODE("New", null, {\n    $documentation: "An object instantiation.  Derives from a function call since it has exactly the same properties",\n    _validate: function() {\n        if (this.optional) throw new Error("optional must be false");\n        if (this.terminal) throw new Error("terminal must be false");\n    },\n}, AST_Call);\n\nvar AST_Sequence = DEFNODE("Sequence", "expressions", {\n    $documentation: "A sequence expression (comma-separated expressions)",\n    $propdoc: {\n        expressions: "[AST_Node*] array of expressions (at least two)",\n    },\n    _equals: function(node) {\n        return all_equals(this.expressions, node.expressions);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.expressions.forEach(function(expr) {\n                expr.walk(visitor);\n            });\n        });\n    },\n    _validate: function() {\n        if (this.expressions.length < 2) throw new Error("expressions must contain multiple elements");\n        must_be_expressions(this, "expressions");\n    },\n});\n\nfunction root_expr(prop) {\n    while (prop instanceof AST_PropAccess) prop = prop.expression;\n    return prop;\n}\n\nvar AST_PropAccess = DEFNODE("PropAccess", "expression optional property terminal", {\n    $documentation: "Base class for property access expressions, i.e. `a.foo` or `a[\\"foo\\"]`",\n    $propdoc: {\n        expression: "[AST_Node] the “container” expression",\n        optional: "[boolean] whether the expression is optional chaining",\n        property: "[AST_Node|string] the property to access.  For AST_Dot this is always a plain string, while for AST_Sub it\'s an arbitrary AST_Node",\n        terminal: "[boolean] whether the chain has ended",\n    },\n    _equals: function(node) {\n        return !this.optional == !node.optional\n            && prop_equals(this.property, node.property)\n            && this.expression.equals(node.expression);\n    },\n    get_property: function() {\n        var p = this.property;\n        if (p instanceof AST_Constant) return p.value;\n        if (p instanceof AST_UnaryPrefix && p.operator == "void" && p.expression instanceof AST_Constant) return;\n        return p;\n    },\n    _validate: function() {\n        if (this.TYPE == "PropAccess") throw new Error("should not instantiate AST_PropAccess");\n        must_be_expression(this, "expression");\n    },\n});\n\nvar AST_Dot = DEFNODE("Dot", "quoted", {\n    $documentation: "A dotted property access expression",\n    $propdoc: {\n        quoted: "[boolean] whether property is transformed from a quoted string",\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.expression.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (typeof this.property != "string") throw new Error("property must be string");\n    },\n}, AST_PropAccess);\n\nvar AST_Sub = DEFNODE("Sub", null, {\n    $documentation: "Index-style property access, i.e. `a[\\"foo\\"]`",\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.expression.walk(visitor);\n            node.property.walk(visitor);\n        });\n    },\n    _validate: function() {\n        must_be_expression(this, "property");\n    },\n}, AST_PropAccess);\n\nvar AST_Spread = DEFNODE("Spread", "expression", {\n    $documentation: "Spread expression in array/object literals or function calls",\n    $propdoc: {\n        expression: "[AST_Node] expression to be expanded",\n    },\n    _equals: function(node) {\n        return this.expression.equals(node.expression);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.expression.walk(visitor);\n        });\n    },\n    _validate: function() {\n        must_be_expression(this, "expression");\n    },\n});\n\nvar AST_Unary = DEFNODE("Unary", "operator expression", {\n    $documentation: "Base class for unary expressions",\n    $propdoc: {\n        operator: "[string] the operator",\n        expression: "[AST_Node] expression that this unary operator applies to",\n    },\n    _equals: function(node) {\n        return this.operator == node.operator\n            && this.expression.equals(node.expression);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.expression.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (this.TYPE == "Unary") throw new Error("should not instantiate AST_Unary");\n        if (typeof this.operator != "string") throw new Error("operator must be string");\n        must_be_expression(this, "expression");\n    },\n});\n\nvar AST_UnaryPrefix = DEFNODE("UnaryPrefix", null, {\n    $documentation: "Unary prefix expression, i.e. `typeof i` or `++i`"\n}, AST_Unary);\n\nvar AST_UnaryPostfix = DEFNODE("UnaryPostfix", null, {\n    $documentation: "Unary postfix expression, i.e. `i++`"\n}, AST_Unary);\n\nvar AST_Binary = DEFNODE("Binary", "operator left right", {\n    $documentation: "Binary expression, i.e. `a + b`",\n    $propdoc: {\n        left: "[AST_Node] left-hand side expression",\n        operator: "[string] the operator",\n        right: "[AST_Node] right-hand side expression"\n    },\n    _equals: function(node) {\n        return this.operator == node.operator\n            && this.left.equals(node.left)\n            && this.right.equals(node.right);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.left.walk(visitor);\n            node.right.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (!(this instanceof AST_Assign)) must_be_expression(this, "left");\n        if (typeof this.operator != "string") throw new Error("operator must be string");\n        must_be_expression(this, "right");\n    },\n});\n\nvar AST_Conditional = DEFNODE("Conditional", "condition consequent alternative", {\n    $documentation: "Conditional expression using the ternary operator, i.e. `a ? b : c`",\n    $propdoc: {\n        condition: "[AST_Node]",\n        consequent: "[AST_Node]",\n        alternative: "[AST_Node]"\n    },\n    _equals: function(node) {\n        return this.condition.equals(node.condition)\n            && this.consequent.equals(node.consequent)\n            && this.alternative.equals(node.alternative);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.condition.walk(visitor);\n            node.consequent.walk(visitor);\n            node.alternative.walk(visitor);\n        });\n    },\n    _validate: function() {\n        must_be_expression(this, "condition");\n        must_be_expression(this, "consequent");\n        must_be_expression(this, "alternative");\n    },\n});\n\nvar AST_Assign = DEFNODE("Assign", null, {\n    $documentation: "An assignment expression — `a = b + 5`",\n    _validate: function() {\n        if (this.operator.indexOf("=") < 0) throw new Error(\'operator must contain "="\');\n        if (this.left instanceof AST_Destructured) {\n            if (this.operator != "=") throw new Error("invalid destructuring operator: " + this.operator);\n            validate_destructured(this.left, function(node) {\n                if (!(node instanceof AST_PropAccess || node instanceof AST_SymbolRef)) {\n                    throw new Error("left must be assignable: " + node.TYPE);\n                }\n            });\n        } else if (!(this.left instanceof AST_Infinity\n            || this.left instanceof AST_NaN\n            || this.left instanceof AST_PropAccess && !this.left.optional\n            || this.left instanceof AST_SymbolRef\n            || this.left instanceof AST_Undefined)) {\n            throw new Error("left must be assignable");\n        }\n    },\n}, AST_Binary);\n\nvar AST_Await = DEFNODE("Await", "expression", {\n    $documentation: "An await expression",\n    $propdoc: {\n        expression: "[AST_Node] expression with Promise to resolve on",\n    },\n    _equals: function(node) {\n        return this.expression.equals(node.expression);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.expression.walk(visitor);\n        });\n    },\n    _validate: function() {\n        must_be_expression(this, "expression");\n    },\n});\n\nvar AST_Yield = DEFNODE("Yield", "expression nested", {\n    $documentation: "A yield expression",\n    $propdoc: {\n        expression: "[AST_Node?] return value for iterator, or null if undefined",\n        nested: "[boolean] whether to iterate over expression as generator",\n    },\n    _equals: function(node) {\n        return !this.nested == !node.nested\n            && prop_equals(this.expression, node.expression);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            if (node.expression) node.expression.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (this.expression != null) {\n            must_be_expression(this, "expression");\n        } else if (this.nested) {\n            throw new Error("yield* must contain expression");\n        }\n    },\n});\n\n/* -----[ LITERALS ]----- */\n\nvar AST_Array = DEFNODE("Array", "elements", {\n    $documentation: "An array literal",\n    $propdoc: {\n        elements: "[AST_Node*] array of elements"\n    },\n    _equals: function(node) {\n        return all_equals(this.elements, node.elements);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.elements.forEach(function(element) {\n                element.walk(visitor);\n            });\n        });\n    },\n    _validate: function() {\n        must_be_expressions(this, "elements", true, true);\n    },\n});\n\nvar AST_Destructured = DEFNODE("Destructured", "rest", {\n    $documentation: "Base class for destructured literal",\n    $propdoc: {\n        rest: "[(AST_Destructured|AST_SymbolDeclaration|AST_SymbolRef)?] rest parameter, or null if absent",\n    },\n    _validate: function() {\n        if (this.TYPE == "Destructured") throw new Error("should not instantiate AST_Destructured");\n    },\n});\n\nfunction validate_destructured(node, check, allow_default) {\n    if (node instanceof AST_DefaultValue && allow_default) return validate_destructured(node.name, check);\n    if (node instanceof AST_Destructured) {\n        if (node.rest != null) validate_destructured(node.rest, check);\n        if (node instanceof AST_DestructuredArray) return node.elements.forEach(function(node) {\n            if (!(node instanceof AST_Hole)) validate_destructured(node, check, true);\n        });\n        if (node instanceof AST_DestructuredObject) return node.properties.forEach(function(prop) {\n            validate_destructured(prop.value, check, true);\n        });\n    }\n    check(node);\n}\n\nvar AST_DestructuredArray = DEFNODE("DestructuredArray", "elements", {\n    $documentation: "A destructured array literal",\n    $propdoc: {\n        elements: "[(AST_DefaultValue|AST_Destructured|AST_SymbolDeclaration|AST_SymbolRef)*] array of elements",\n    },\n    _equals: function(node) {\n        return prop_equals(this.rest, node.rest)\n            && all_equals(this.elements, node.elements);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.elements.forEach(function(element) {\n                element.walk(visitor);\n            });\n            if (node.rest) node.rest.walk(visitor);\n        });\n    },\n}, AST_Destructured);\n\nvar AST_DestructuredKeyVal = DEFNODE("DestructuredKeyVal", "key value", {\n    $documentation: "A key: value destructured property",\n    $propdoc: {\n        key: "[string|AST_Node] property name.  For computed property this is an AST_Node.",\n        value: "[AST_DefaultValue|AST_Destructured|AST_SymbolDeclaration|AST_SymbolRef] property value",\n    },\n    _equals: function(node) {\n        return prop_equals(this.key, node.key)\n            && this.value.equals(node.value);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            if (node.key instanceof AST_Node) node.key.walk(visitor);\n            node.value.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (typeof this.key != "string") {\n            if (!(this.key instanceof AST_Node)) throw new Error("key must be string or AST_Node");\n            must_be_expression(this, "key");\n        }\n        if (!(this.value instanceof AST_Node)) throw new Error("value must be AST_Node");\n    },\n});\n\nvar AST_DestructuredObject = DEFNODE("DestructuredObject", "properties", {\n    $documentation: "A destructured object literal",\n    $propdoc: {\n        properties: "[AST_DestructuredKeyVal*] array of properties",\n    },\n    _equals: function(node) {\n        return prop_equals(this.rest, node.rest)\n            && all_equals(this.properties, node.properties);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.properties.forEach(function(prop) {\n                prop.walk(visitor);\n            });\n            if (node.rest) node.rest.walk(visitor);\n        });\n    },\n    _validate: function() {\n        this.properties.forEach(function(node) {\n            if (!(node instanceof AST_DestructuredKeyVal)) throw new Error("properties must be AST_DestructuredKeyVal[]");\n        });\n    },\n}, AST_Destructured);\n\nvar AST_Object = DEFNODE("Object", "properties", {\n    $documentation: "An object literal",\n    $propdoc: {\n        properties: "[(AST_ObjectProperty|AST_Spread)*] array of properties"\n    },\n    _equals: function(node) {\n        return all_equals(this.properties, node.properties);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            node.properties.forEach(function(prop) {\n                prop.walk(visitor);\n            });\n        });\n    },\n    _validate: function() {\n        this.properties.forEach(function(node) {\n            if (!(node instanceof AST_ObjectProperty || node instanceof AST_Spread)) {\n                throw new Error("properties must contain AST_ObjectProperty and/or AST_Spread only");\n            }\n        });\n    },\n});\n\nvar AST_ObjectProperty = DEFNODE("ObjectProperty", "key value", {\n    $documentation: "Base class for literal object properties",\n    $propdoc: {\n        key: "[string|AST_Node] property name.  For computed property this is an AST_Node.",\n        value: "[AST_Node] property value.  For getters and setters this is an AST_Accessor.",\n    },\n    _equals: function(node) {\n        return prop_equals(this.key, node.key)\n            && this.value.equals(node.value);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            if (node.key instanceof AST_Node) node.key.walk(visitor);\n            node.value.walk(visitor);\n        });\n    },\n    _validate: function() {\n        if (this.TYPE == "ObjectProperty") throw new Error("should not instantiate AST_ObjectProperty");\n        if (typeof this.key != "string") {\n            if (!(this.key instanceof AST_Node)) throw new Error("key must be string or AST_Node");\n            must_be_expression(this, "key");\n        }\n        if (!(this.value instanceof AST_Node)) throw new Error("value must be AST_Node");\n    },\n});\n\nvar AST_ObjectKeyVal = DEFNODE("ObjectKeyVal", null, {\n    $documentation: "A key: value object property",\n    _validate: function() {\n        must_be_expression(this, "value");\n    },\n}, AST_ObjectProperty);\n\nvar AST_ObjectMethod = DEFNODE("ObjectMethod", null, {\n    $documentation: "A key(){} object property",\n    _validate: function() {\n        if (!(this.value instanceof AST_LambdaExpression)) throw new Error("value must be AST_LambdaExpression");\n        if (is_arrow(this.value)) throw new Error("value cannot be AST_Arrow or AST_AsyncArrow");\n        if (this.value.name != null) throw new Error("name of object method\'s lambda must be null");\n    },\n}, AST_ObjectKeyVal);\n\nvar AST_ObjectSetter = DEFNODE("ObjectSetter", null, {\n    $documentation: "An object setter property",\n    _validate: function() {\n        if (!(this.value instanceof AST_Accessor)) throw new Error("value must be AST_Accessor");\n    },\n}, AST_ObjectProperty);\n\nvar AST_ObjectGetter = DEFNODE("ObjectGetter", null, {\n    $documentation: "An object getter property",\n    _validate: function() {\n        if (!(this.value instanceof AST_Accessor)) throw new Error("value must be AST_Accessor");\n    },\n}, AST_ObjectProperty);\n\nvar AST_Symbol = DEFNODE("Symbol", "scope name thedef", {\n    $documentation: "Base class for all symbols",\n    $propdoc: {\n        name: "[string] name of this symbol",\n        scope: "[AST_Scope/S] the current scope (not necessarily the definition scope)",\n        thedef: "[SymbolDef/S] the definition of this symbol"\n    },\n    _equals: function(node) {\n        return this.thedef ? this.thedef === node.thedef : this.name == node.name;\n    },\n    _validate: function() {\n        if (this.TYPE == "Symbol") throw new Error("should not instantiate AST_Symbol");\n        if (typeof this.name != "string") throw new Error("name must be string");\n    },\n});\n\nvar AST_SymbolDeclaration = DEFNODE("SymbolDeclaration", "init", {\n    $documentation: "A declaration symbol (symbol in var, function name or argument, symbol in catch)",\n}, AST_Symbol);\n\nvar AST_SymbolConst = DEFNODE("SymbolConst", null, {\n    $documentation: "Symbol defining a constant",\n}, AST_SymbolDeclaration);\n\nvar AST_SymbolImport = DEFNODE("SymbolImport", "key", {\n    $documentation: "Symbol defined by an `import` statement",\n    $propdoc: {\n        key: "[AST_String] the original `export` name",\n    },\n    _equals: function(node) {\n        return this.name == node.name\n            && this.key.equals(node.key);\n    },\n    _validate: function() {\n        if (!(this.key instanceof AST_String)) throw new Error("key must be AST_String");\n    },\n}, AST_SymbolConst);\n\nvar AST_SymbolLet = DEFNODE("SymbolLet", null, {\n    $documentation: "Symbol defining a lexical-scoped variable",\n}, AST_SymbolDeclaration);\n\nvar AST_SymbolVar = DEFNODE("SymbolVar", null, {\n    $documentation: "Symbol defining a variable",\n}, AST_SymbolDeclaration);\n\nvar AST_SymbolFunarg = DEFNODE("SymbolFunarg", "unused", {\n    $documentation: "Symbol naming a function argument",\n}, AST_SymbolVar);\n\nvar AST_SymbolDefun = DEFNODE("SymbolDefun", null, {\n    $documentation: "Symbol defining a function",\n}, AST_SymbolDeclaration);\n\nvar AST_SymbolLambda = DEFNODE("SymbolLambda", null, {\n    $documentation: "Symbol naming a function expression",\n}, AST_SymbolDeclaration);\n\nvar AST_SymbolDefClass = DEFNODE("SymbolDefClass", null, {\n    $documentation: "Symbol defining a class",\n}, AST_SymbolConst);\n\nvar AST_SymbolClass = DEFNODE("SymbolClass", null, {\n    $documentation: "Symbol naming a class expression",\n}, AST_SymbolConst);\n\nvar AST_SymbolCatch = DEFNODE("SymbolCatch", null, {\n    $documentation: "Symbol naming the exception in catch",\n}, AST_SymbolDeclaration);\n\nvar AST_Label = DEFNODE("Label", "references", {\n    $documentation: "Symbol naming a label (declaration)",\n    $propdoc: {\n        references: "[AST_LoopControl*] a list of nodes referring to this label"\n    },\n    initialize: function() {\n        this.references = [];\n        this.thedef = this;\n    },\n}, AST_Symbol);\n\nvar AST_SymbolRef = DEFNODE("SymbolRef", "fixed in_arg redef", {\n    $documentation: "Reference to some symbol (not definition/declaration)",\n}, AST_Symbol);\n\nvar AST_SymbolExport = DEFNODE("SymbolExport", "alias", {\n    $documentation: "Reference in an `export` statement",\n    $propdoc: {\n        alias: "[AST_String] the `export` alias",\n    },\n    _equals: function(node) {\n        return this.name == node.name\n            && this.alias.equals(node.alias);\n    },\n    _validate: function() {\n        if (!(this.alias instanceof AST_String)) throw new Error("alias must be AST_String");\n    },\n}, AST_SymbolRef);\n\nvar AST_LabelRef = DEFNODE("LabelRef", null, {\n    $documentation: "Reference to a label symbol",\n}, AST_Symbol);\n\nvar AST_ObjectIdentity = DEFNODE("ObjectIdentity", null, {\n    $documentation: "Base class for `super` & `this`",\n    _equals: return_true,\n    _validate: function() {\n        if (this.TYPE == "ObjectIdentity") throw new Error("should not instantiate AST_ObjectIdentity");\n    },\n}, AST_Symbol);\n\nvar AST_Super = DEFNODE("Super", null, {\n    $documentation: "The `super` symbol",\n    _validate: function() {\n        if (this.name !== "super") throw new Error(\'name must be "super"\');\n    },\n}, AST_ObjectIdentity);\n\nvar AST_This = DEFNODE("This", null, {\n    $documentation: "The `this` symbol",\n    _validate: function() {\n        if (this.TYPE == "This" && this.name !== "this") throw new Error(\'name must be "this"\');\n    },\n}, AST_ObjectIdentity);\n\nvar AST_NewTarget = DEFNODE("NewTarget", null, {\n    $documentation: "The `new.target` symbol",\n    initialize: function() {\n        this.name = "new.target";\n    },\n    _validate: function() {\n        if (this.name !== "new.target") throw new Error(\'name must be "new.target": \' + this.name);\n    },\n}, AST_This);\n\nvar AST_Template = DEFNODE("Template", "expressions strings tag", {\n    $documentation: "A template literal, i.e. tag`str1${expr1}...strN${exprN}strN+1`",\n    $propdoc: {\n        expressions: "[AST_Node*] the placeholder expressions",\n        strings: "[string*] the raw text segments",\n        tag: "[AST_Node?] tag function, or null if absent",\n    },\n    _equals: function(node) {\n        return prop_equals(this.tag, node.tag)\n            && list_equals(this.strings, node.strings)\n            && all_equals(this.expressions, node.expressions);\n    },\n    walk: function(visitor) {\n        var node = this;\n        visitor.visit(node, function() {\n            if (node.tag) node.tag.walk(visitor);\n            node.expressions.forEach(function(expr) {\n                expr.walk(visitor);\n            });\n        });\n    },\n    _validate: function() {\n        if (this.expressions.length + 1 != this.strings.length) {\n            throw new Error("malformed template with " + this.expressions.length + " placeholder(s) but " + this.strings.length + " text segment(s)");\n        }\n        must_be_expressions(this, "expressions");\n        this.strings.forEach(function(string) {\n            if (typeof string != "string") throw new Error("strings must contain string");\n        });\n        if (this.tag != null) must_be_expression(this, "tag");\n    },\n});\n\nvar AST_Constant = DEFNODE("Constant", null, {\n    $documentation: "Base class for all constants",\n    _equals: function(node) {\n        return this.value === node.value;\n    },\n    _validate: function() {\n        if (this.TYPE == "Constant") throw new Error("should not instantiate AST_Constant");\n    },\n});\n\nvar AST_String = DEFNODE("String", "quote value", {\n    $documentation: "A string literal",\n    $propdoc: {\n        quote: "[string?] the original quote character",\n        value: "[string] the contents of this string",\n    },\n    _validate: function() {\n        if (this.quote != null) {\n            if (typeof this.quote != "string") throw new Error("quote must be string");\n            if (!/^["\']$/.test(this.quote)) throw new Error("invalid quote: " + this.quote);\n        }\n        if (typeof this.value != "string") throw new Error("value must be string");\n    },\n}, AST_Constant);\n\nvar AST_Number = DEFNODE("Number", "value", {\n    $documentation: "A number literal",\n    $propdoc: {\n        value: "[number] the numeric value",\n    },\n    _validate: function() {\n        if (typeof this.value != "number") throw new Error("value must be number");\n        if (!isFinite(this.value)) throw new Error("value must be finite");\n        if (this.value < 0) throw new Error("value cannot be negative");\n    },\n}, AST_Constant);\n\nvar AST_BigInt = DEFNODE("BigInt", "value", {\n    $documentation: "A BigInt literal",\n    $propdoc: {\n        value: "[string] the numeric representation",\n    },\n    _validate: function() {\n        if (typeof this.value != "string") throw new Error("value must be string");\n        if (this.value[0] == "-") throw new Error("value cannot be negative");\n    },\n}, AST_Constant);\n\nvar AST_RegExp = DEFNODE("RegExp", "value", {\n    $documentation: "A regexp literal",\n    $propdoc: {\n        value: "[RegExp] the actual regexp"\n    },\n    _equals: function(node) {\n        return "" + this.value == "" + node.value;\n    },\n    _validate: function() {\n        if (!(this.value instanceof RegExp)) throw new Error("value must be RegExp");\n    },\n}, AST_Constant);\n\nvar AST_Atom = DEFNODE("Atom", null, {\n    $documentation: "Base class for atoms",\n    _equals: return_true,\n    _validate: function() {\n        if (this.TYPE == "Atom") throw new Error("should not instantiate AST_Atom");\n    },\n}, AST_Constant);\n\nvar AST_Null = DEFNODE("Null", null, {\n    $documentation: "The `null` atom",\n    value: null,\n}, AST_Atom);\n\nvar AST_NaN = DEFNODE("NaN", null, {\n    $documentation: "The impossible value",\n    value: 0/0,\n}, AST_Atom);\n\nvar AST_Undefined = DEFNODE("Undefined", null, {\n    $documentation: "The `undefined` value",\n    value: function(){}(),\n}, AST_Atom);\n\nvar AST_Hole = DEFNODE("Hole", null, {\n    $documentation: "A hole in an array",\n    value: function(){}(),\n}, AST_Atom);\n\nvar AST_Infinity = DEFNODE("Infinity", null, {\n    $documentation: "The `Infinity` value",\n    value: 1/0,\n}, AST_Atom);\n\nvar AST_Boolean = DEFNODE("Boolean", null, {\n    $documentation: "Base class for booleans",\n    _validate: function() {\n        if (this.TYPE == "Boolean") throw new Error("should not instantiate AST_Boolean");\n    },\n}, AST_Atom);\n\nvar AST_False = DEFNODE("False", null, {\n    $documentation: "The `false` atom",\n    value: false,\n}, AST_Boolean);\n\nvar AST_True = DEFNODE("True", null, {\n    $documentation: "The `true` atom",\n    value: true,\n}, AST_Boolean);\n\n/* -----[ TreeWalker ]----- */\n\nfunction TreeWalker(callback) {\n    this.callback = callback;\n    this.directives = Object.create(null);\n    this.stack = [];\n}\nTreeWalker.prototype = {\n    visit: function(node, descend) {\n        this.push(node);\n        var done = this.callback(node, descend || noop);\n        if (!done && descend) descend();\n        this.pop();\n    },\n    parent: function(n) {\n        return this.stack[this.stack.length - 2 - (n || 0)];\n    },\n    push: function(node) {\n        var value;\n        if (node instanceof AST_Class) {\n            this.directives = Object.create(this.directives);\n            value = "use strict";\n        } else if (node instanceof AST_Directive) {\n            value = node.value;\n        } else if (node instanceof AST_Lambda) {\n            this.directives = Object.create(this.directives);\n        }\n        if (value && !this.directives[value]) this.directives[value] = node;\n        this.stack.push(node);\n    },\n    pop: function() {\n        var node = this.stack.pop();\n        if (node instanceof AST_Class || node instanceof AST_Lambda) {\n            this.directives = Object.getPrototypeOf(this.directives);\n        }\n    },\n    self: function() {\n        return this.stack[this.stack.length - 1];\n    },\n    find_parent: function(type) {\n        var stack = this.stack;\n        for (var i = stack.length - 1; --i >= 0;) {\n            var x = stack[i];\n            if (x instanceof type) return x;\n        }\n    },\n    has_directive: function(type) {\n        var dir = this.directives[type];\n        if (dir) return dir;\n        var node = this.stack[this.stack.length - 1];\n        if (node instanceof AST_Scope) {\n            for (var i = 0; i < node.body.length; ++i) {\n                var st = node.body[i];\n                if (!(st instanceof AST_Directive)) break;\n                if (st.value == type) return st;\n            }\n        }\n    },\n    loopcontrol_target: function(node) {\n        var stack = this.stack;\n        if (node.label) for (var i = stack.length; --i >= 0;) {\n            var x = stack[i];\n            if (x instanceof AST_LabeledStatement && x.label.name == node.label.name)\n                return x.body;\n        } else for (var i = stack.length; --i >= 0;) {\n            var x = stack[i];\n            if (x instanceof AST_IterationStatement\n                || node instanceof AST_Break && x instanceof AST_Switch)\n                return x;\n        }\n    },\n    in_boolean_context: function() {\n        for (var drop = true, level = 0, parent, self = this.self(); parent = this.parent(level++); self = parent) {\n            if (parent instanceof AST_Binary) switch (parent.operator) {\n              case "&&":\n              case "||":\n                if (parent.left === self) drop = false;\n                continue;\n              default:\n                return false;\n            }\n            if (parent instanceof AST_Conditional) {\n                if (parent.condition === self) return true;\n                continue;\n            }\n            if (parent instanceof AST_DWLoop) return parent.condition === self;\n            if (parent instanceof AST_For) return parent.condition === self;\n            if (parent instanceof AST_If) return parent.condition === self;\n            if (parent instanceof AST_Return) {\n                if (parent.in_bool) return true;\n                while (parent = this.parent(level++)) {\n                    if (parent instanceof AST_Lambda) {\n                        if (parent.name) return false;\n                        parent = this.parent(level++);\n                        if (parent.TYPE != "Call") return false;\n                        break;\n                    }\n                }\n            }\n            if (parent instanceof AST_Sequence) {\n                if (parent.tail_node() === self) continue;\n                return drop ? "d" : true;\n            }\n            if (parent instanceof AST_SimpleStatement) return drop ? "d" : true;\n            if (parent instanceof AST_UnaryPrefix) return parent.operator == "!";\n            return false;\n        }\n    }\n};\n'},74474:(e,t,r)=>{"use strict";r.d(t,{Z:()=>n});const n='/***********************************************************************\n\n  A JavaScript tokenizer / parser / beautifier / compressor.\n  https://github.com/mishoo/UglifyJS\n\n  -------------------------------- (C) ---------------------------------\n\n                           Author: Mihai Bazon\n                         <mihai.bazon@gmail.com>\n                       http://mihai.bazon.net/blog\n\n  Distributed under the BSD license:\n\n    Copyright 2012 (c) Mihai Bazon <mihai.bazon@gmail.com>\n\n    Redistribution and use in source and binary forms, with or without\n    modification, are permitted provided that the following conditions\n    are met:\n\n        * Redistributions of source code must retain the above\n          copyright notice, this list of conditions and the following\n          disclaimer.\n\n        * Redistributions in binary form must reproduce the above\n          copyright notice, this list of conditions and the following\n          disclaimer in the documentation and/or other materials\n          provided with the distribution.\n\n    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY\n    EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE\n    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,\n    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR\n    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF\n    THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n    SUCH DAMAGE.\n\n ***********************************************************************/\n\n"use strict";\n\nfunction Compressor(options, false_by_default) {\n    if (!(this instanceof Compressor))\n        return new Compressor(options, false_by_default);\n    TreeTransformer.call(this, this.before, this.after);\n    this.options = defaults(options, {\n        annotations     : !false_by_default,\n        arguments       : !false_by_default,\n        arrows          : !false_by_default,\n        assignments     : !false_by_default,\n        awaits          : !false_by_default,\n        booleans        : !false_by_default,\n        collapse_vars   : !false_by_default,\n        comparisons     : !false_by_default,\n        conditionals    : !false_by_default,\n        dead_code       : !false_by_default,\n        default_values  : !false_by_default,\n        directives      : !false_by_default,\n        drop_console    : false,\n        drop_debugger   : !false_by_default,\n        evaluate        : !false_by_default,\n        expression      : false,\n        functions       : !false_by_default,\n        global_defs     : false,\n        hoist_exports   : !false_by_default,\n        hoist_funs      : false,\n        hoist_props     : !false_by_default,\n        hoist_vars      : false,\n        ie              : false,\n        if_return       : !false_by_default,\n        imports         : !false_by_default,\n        inline          : !false_by_default,\n        join_vars       : !false_by_default,\n        keep_fargs      : false_by_default,\n        keep_fnames     : false,\n        keep_infinity   : false,\n        loops           : !false_by_default,\n        merge_vars      : !false_by_default,\n        module          : false,\n        negate_iife     : !false_by_default,\n        objects         : !false_by_default,\n        optional_chains : !false_by_default,\n        passes          : 1,\n        properties      : !false_by_default,\n        pure_funcs      : null,\n        pure_getters    : !false_by_default && "strict",\n        reduce_funcs    : !false_by_default,\n        reduce_vars     : !false_by_default,\n        rests           : !false_by_default,\n        sequences       : !false_by_default,\n        side_effects    : !false_by_default,\n        spreads         : !false_by_default,\n        strings         : !false_by_default,\n        switches        : !false_by_default,\n        templates       : !false_by_default,\n        top_retain      : null,\n        toplevel        : !!(options && !options["expression"] && options["top_retain"]),\n        typeofs         : !false_by_default,\n        unsafe          : false,\n        unsafe_comps    : false,\n        unsafe_Function : false,\n        unsafe_math     : false,\n        unsafe_proto    : false,\n        unsafe_regexp   : false,\n        unsafe_undefined: false,\n        unused          : !false_by_default,\n        varify          : !false_by_default,\n        webkit          : false,\n        yields          : !false_by_default,\n    }, true);\n    var evaluate = this.options["evaluate"];\n    this.eval_threshold = /eager/.test(evaluate) ? 1 / 0 : +evaluate;\n    var global_defs = this.options["global_defs"];\n    if (typeof global_defs == "object") for (var key in global_defs) {\n        if (/^@/.test(key) && HOP(global_defs, key)) {\n            global_defs[key.slice(1)] = parse(global_defs[key], { expression: true });\n        }\n    }\n    if (this.options["inline"] === true) this.options["inline"] = 4;\n    this.drop_fargs = this.options["keep_fargs"] ? return_false : function(lambda, parent) {\n        if (lambda.length_read) return false;\n        var name = lambda.name;\n        if (!name) return parent && parent.TYPE == "Call" && parent.expression === lambda;\n        if (name.fixed_value() !== lambda) return false;\n        var def = name.definition();\n        if (def.direct_access) return false;\n        var escaped = def.escaped;\n        return escaped && escaped.depth != 1;\n    };\n    if (this.options["module"]) this.directives["use strict"] = true;\n    var pure_funcs = this.options["pure_funcs"];\n    if (typeof pure_funcs == "function") {\n        this.pure_funcs = pure_funcs;\n    } else if (typeof pure_funcs == "string") {\n        this.pure_funcs = function(node) {\n            var expr;\n            if (node instanceof AST_Call) {\n                expr = node.expression;\n            } else if (node instanceof AST_Template) {\n                expr = node.tag;\n            }\n            return !(expr && pure_funcs === expr.print_to_string());\n        };\n    } else if (Array.isArray(pure_funcs)) {\n        this.pure_funcs = function(node) {\n            var expr;\n            if (node instanceof AST_Call) {\n                expr = node.expression;\n            } else if (node instanceof AST_Template) {\n                expr = node.tag;\n            }\n            return !(expr && member(expr.print_to_string(), pure_funcs));\n        };\n    } else {\n        this.pure_funcs = return_true;\n    }\n    var sequences = this.options["sequences"];\n    this.sequences_limit = sequences == 1 ? 800 : sequences | 0;\n    var top_retain = this.options["top_retain"];\n    if (top_retain instanceof RegExp) {\n        this.top_retain = function(def) {\n            return top_retain.test(def.name);\n        };\n    } else if (typeof top_retain == "function") {\n        this.top_retain = top_retain;\n    } else if (top_retain) {\n        if (typeof top_retain == "string") {\n            top_retain = top_retain.split(/,/);\n        }\n        this.top_retain = function(def) {\n            return member(def.name, top_retain);\n        };\n    }\n    var toplevel = this.options["toplevel"];\n    this.toplevel = typeof toplevel == "string" ? {\n        funcs: /funcs/.test(toplevel),\n        vars: /vars/.test(toplevel)\n    } : {\n        funcs: toplevel,\n        vars: toplevel\n    };\n}\n\nCompressor.prototype = new TreeTransformer(function(node, descend) {\n    if (node._squeezed) return node;\n    var is_scope = node instanceof AST_Scope;\n    if (is_scope) {\n        if (this.option("arrows") && is_arrow(node) && node.value) {\n            node.body = [ node.first_statement() ];\n            node.value = null;\n        }\n        node.hoist_properties(this);\n        node.hoist_declarations(this);\n        node.process_returns(this);\n    }\n    // Before https://github.com/mishoo/UglifyJS/pull/1602 AST_Node.optimize()\n    // would call AST_Node.transform() if a different instance of AST_Node is\n    // produced after OPT().\n    // This corrupts TreeWalker.stack, which cause AST look-ups to malfunction.\n    // Migrate and defer all children\'s AST_Node.transform() to below, which\n    // will now happen after this parent AST_Node has been properly substituted\n    // thus gives a consistent AST snapshot.\n    descend(node, this);\n    // Existing code relies on how AST_Node.optimize() worked, and omitting the\n    // following replacement call would result in degraded efficiency of both\n    // output and performance.\n    descend(node, this);\n    var opt = node.optimize(this);\n    if (is_scope) {\n        if (opt === node && !this.has_directive("use asm") && !opt.pinned()) {\n            opt.drop_unused(this);\n            if (opt.merge_variables(this)) opt.drop_unused(this);\n            descend(opt, this);\n        }\n        if (this.option("arrows") && is_arrow(opt) && opt.body.length == 1) {\n            var stat = opt.body[0];\n            if (stat instanceof AST_Return) {\n                opt.body.length = 0;\n                opt.value = stat.value;\n            }\n        }\n    }\n    if (opt === node) opt._squeezed = true;\n    return opt;\n});\nCompressor.prototype.option = function(key) {\n    return this.options[key];\n};\nCompressor.prototype.exposed = function(def) {\n    if (def.exported) return true;\n    if (def.undeclared) return true;\n    if (!(def.global || def.scope.resolve() instanceof AST_Toplevel)) return false;\n    var toplevel = this.toplevel;\n    return !all(def.orig, function(sym) {\n        return toplevel[sym instanceof AST_SymbolDefun ? "funcs" : "vars"];\n    });\n};\nCompressor.prototype.compress = function(node) {\n    node = node.resolve_defines(this);\n    node.hoist_exports(this);\n    if (this.option("expression")) node.process_expression(true);\n    var merge_vars = this.options.merge_vars;\n    var passes = +this.options.passes || 1;\n    var min_count = 1 / 0;\n    var stopping = false;\n    var mangle = { ie: this.option("ie") };\n    for (var pass = 0; pass < passes; pass++) {\n        node.figure_out_scope(mangle);\n        if (pass > 0 || this.option("reduce_vars"))\n            node.reset_opt_flags(this);\n        this.options.merge_vars = merge_vars && (stopping || pass == passes - 1);\n        node = node.transform(this);\n        if (passes > 1) {\n            var count = 0;\n            node.walk(new TreeWalker(function() {\n                count++;\n            }));\n            AST_Node.info("pass {pass}: last_count: {min_count}, count: {count}", {\n                pass: pass,\n                min_count: min_count,\n                count: count,\n            });\n            if (count < min_count) {\n                min_count = count;\n                stopping = false;\n            } else if (stopping) {\n                break;\n            } else {\n                stopping = true;\n            }\n        }\n    }\n    if (this.option("expression")) node.process_expression(false);\n    return node;\n};\n\n(function(OPT) {\n    OPT(AST_Node, function(self) {\n        return self;\n    });\n\n    AST_Toplevel.DEFMETHOD("hoist_exports", function(compressor) {\n        if (!compressor.option("hoist_exports")) return;\n        var body = this.body, props = [];\n        for (var i = 0; i < body.length; i++) {\n            var stat = body[i];\n            if (stat instanceof AST_ExportDeclaration) {\n                body[i] = stat = stat.body;\n                if (stat instanceof AST_Definitions) {\n                    stat.definitions.forEach(function(defn) {\n                        defn.name.match_symbol(export_symbol, true);\n                    });\n                } else {\n                    export_symbol(stat.name);\n                }\n            } else if (stat instanceof AST_ExportReferences) {\n                body.splice(i--, 1);\n                [].push.apply(props, stat.properties);\n            }\n        }\n        if (props.length) body.push(make_node(AST_ExportReferences, this, { properties: props }));\n\n        function export_symbol(sym) {\n            if (!(sym instanceof AST_SymbolDeclaration)) return;\n            var node = make_node(AST_SymbolExport, sym);\n            node.alias = make_node(AST_String, node, { value: node.name });\n            props.push(node);\n        }\n    });\n\n    AST_Scope.DEFMETHOD("process_expression", function(insert, transform) {\n        var self = this;\n        var tt = new TreeTransformer(function(node) {\n            if (insert) {\n                if (node instanceof AST_Directive) node = make_node(AST_SimpleStatement, node, {\n                    body: make_node(AST_String, node),\n                });\n                if (node instanceof AST_SimpleStatement) {\n                    return transform ? transform(node) : make_node(AST_Return, node, { value: node.body });\n                }\n            } else if (node instanceof AST_Return) {\n                if (transform) return transform(node);\n                var value = node.value;\n                if (value instanceof AST_String) return make_node(AST_Directive, value);\n                return make_node(AST_SimpleStatement, node, {\n                    body: value || make_node(AST_UnaryPrefix, node, {\n                        operator: "void",\n                        expression: make_node(AST_Number, node, { value: 0 }),\n                    }),\n                });\n            }\n            if (node instanceof AST_Block) {\n                if (node instanceof AST_Lambda) {\n                    if (node !== self) return node;\n                } else if (insert === "awaits" && node instanceof AST_Try) {\n                    if (node.bfinally) return node;\n                }\n                for (var index = node.body.length; --index >= 0;) {\n                    var stat = node.body[index];\n                    if (!is_declaration(stat, true)) {\n                        node.body[index] = stat.transform(tt);\n                        break;\n                    }\n                }\n            } else if (node instanceof AST_If) {\n                node.body = node.body.transform(tt);\n                if (node.alternative) node.alternative = node.alternative.transform(tt);\n            } else if (node instanceof AST_With) {\n                node.body = node.body.transform(tt);\n            }\n            return node;\n        });\n        self.transform(tt);\n    });\n    AST_Toplevel.DEFMETHOD("unwrap_expression", function() {\n        var self = this;\n        switch (self.body.length) {\n          case 0:\n            return make_node(AST_UnaryPrefix, self, {\n                operator: "void",\n                expression: make_node(AST_Number, self, { value: 0 }),\n            });\n          case 1:\n            var stat = self.body[0];\n            if (stat instanceof AST_Directive) return make_node(AST_String, stat);\n            if (stat instanceof AST_SimpleStatement) return stat.body;\n          default:\n            return make_node(AST_Call, self, {\n                expression: make_node(AST_Function, self, {\n                    argnames: [],\n                    body: self.body,\n                }).init_vars(self, self),\n                args: [],\n            });\n        }\n    });\n    AST_Node.DEFMETHOD("wrap_expression", function() {\n        var self = this;\n        if (!is_statement(self)) self = make_node(AST_SimpleStatement, self, { body: self });\n        if (!(self instanceof AST_Toplevel)) self = make_node(AST_Toplevel, self, { body: [ self ] });\n        return self;\n    });\n\n    function read_property(obj, node) {\n        var key = node.get_property();\n        if (key instanceof AST_Node) return;\n        var value;\n        if (obj instanceof AST_Array) {\n            var elements = obj.elements;\n            if (key == "length") return make_node_from_constant(elements.length, obj);\n            if (typeof key == "number" && key in elements) value = elements[key];\n        } else if (obj instanceof AST_Lambda) {\n            if (key == "length") {\n                obj.length_read = true;\n                return make_node_from_constant(obj.argnames.length, obj);\n            }\n        } else if (obj instanceof AST_Object) {\n            key = "" + key;\n            var props = obj.properties;\n            for (var i = props.length; --i >= 0;) {\n                var prop = props[i];\n                if (!can_hoist_property(prop)) return;\n                if (!value && props[i].key === key) value = props[i].value;\n            }\n        }\n        return value instanceof AST_SymbolRef && value.fixed_value() || value;\n    }\n\n    function is_read_only_fn(value, name) {\n        if (value instanceof AST_Boolean) return native_fns.Boolean[name];\n        if (value instanceof AST_Number) return native_fns.Number[name];\n        if (value instanceof AST_String) return native_fns.String[name];\n        if (name == "valueOf") return false;\n        if (value instanceof AST_Array) return native_fns.Array[name];\n        if (value instanceof AST_Lambda) return native_fns.Function[name];\n        if (value instanceof AST_Object) return native_fns.Object[name];\n        if (value instanceof AST_RegExp) return native_fns.RegExp[name] && !value.value.global;\n    }\n\n    function is_modified(compressor, tw, node, value, level, immutable, recursive) {\n        var parent = tw.parent(level);\n        if (compressor.option("unsafe") && parent instanceof AST_Dot && is_read_only_fn(value, parent.property)) {\n            return;\n        }\n        var lhs = is_lhs(node, parent);\n        if (lhs) return lhs;\n        if (level == 0 && value && value.is_constant()) return;\n        if (parent instanceof AST_Array) return is_modified(compressor, tw, parent, parent, level + 1);\n        if (parent instanceof AST_Assign) switch (parent.operator) {\n          case "=":\n            return is_modified(compressor, tw, parent, value, level + 1, immutable, recursive);\n          case "&&=":\n          case "||=":\n          case "??=":\n            return is_modified(compressor, tw, parent, parent, level + 1);\n          default:\n            return;\n        }\n        if (parent instanceof AST_Binary) {\n            if (!lazy_op[parent.operator]) return;\n            return is_modified(compressor, tw, parent, parent, level + 1);\n        }\n        if (parent instanceof AST_Call) {\n            return !immutable\n                && parent.expression === node\n                && !parent.is_expr_pure(compressor)\n                && (!(value instanceof AST_LambdaExpression) || !(parent instanceof AST_New) && value.contains_this());\n        }\n        if (parent instanceof AST_Conditional) {\n            if (parent.condition === node) return;\n            return is_modified(compressor, tw, parent, parent, level + 1);\n        }\n        if (parent instanceof AST_ForEnumeration) return parent.init === node;\n        if (parent instanceof AST_ObjectKeyVal) {\n            if (parent.value !== node) return;\n            var obj = tw.parent(level + 1);\n            return is_modified(compressor, tw, obj, obj, level + 2);\n        }\n        if (parent instanceof AST_PropAccess) {\n            if (parent.expression !== node) return;\n            var prop = read_property(value, parent);\n            return (!immutable || recursive) && is_modified(compressor, tw, parent, prop, level + 1);\n        }\n        if (parent instanceof AST_Sequence) {\n            if (parent.tail_node() !== node) return;\n            return is_modified(compressor, tw, parent, value, level + 1, immutable, recursive);\n        }\n    }\n\n    function is_lambda(node) {\n        return node instanceof AST_Class || node instanceof AST_Lambda;\n    }\n\n    function safe_for_extends(node) {\n        return node instanceof AST_Class || node instanceof AST_Defun || node instanceof AST_Function;\n    }\n\n    function is_arguments(def) {\n        return def.name == "arguments" && def.scope.uses_arguments;\n    }\n\n    function cross_scope(def, sym) {\n        do {\n            if (def === sym) return false;\n            if (sym instanceof AST_Scope) return true;\n        } while (sym = sym.parent_scope);\n    }\n\n    function can_drop_symbol(ref, compressor, keep_lambda) {\n        var def = ref.redef || ref.definition();\n        if (ref.in_arg && is_funarg(def)) return false;\n        return all(def.orig, function(sym) {\n            if (sym instanceof AST_SymbolConst || sym instanceof AST_SymbolLet) {\n                if (sym instanceof AST_SymbolImport) return true;\n                return compressor && safe_from_tdz(compressor, sym);\n            }\n            return !(keep_lambda && sym instanceof AST_SymbolLambda);\n        });\n    }\n\n    function has_escaped(d, scope, node, parent) {\n        if (parent instanceof AST_Assign) return parent.operator == "=" && parent.right === node;\n        if (parent instanceof AST_Call) return parent.expression !== node || parent instanceof AST_New;\n        if (parent instanceof AST_ClassField) return parent.value === node && !parent.static;\n        if (parent instanceof AST_Exit) return parent.value === node && scope.resolve() !== d.scope.resolve();\n        if (parent instanceof AST_VarDef) return parent.value === node;\n    }\n\n    function make_ref(ref, fixed) {\n        var node = make_node(AST_SymbolRef, ref);\n        node.fixed = fixed || make_node(AST_Undefined, ref);\n        return node;\n    }\n\n    function replace_ref(resolve, fixed) {\n        return function(node) {\n            var ref = resolve(node);\n            var node = make_ref(ref, fixed);\n            var def = ref.definition();\n            def.references.push(node);\n            def.replaced++;\n            return node;\n        };\n    }\n\n    var RE_POSITIVE_INTEGER = /^(0|[1-9][0-9]*)$/;\n    (function(def) {\n        def(AST_Node, noop);\n\n        function reset_def(tw, compressor, def) {\n            def.assignments = 0;\n            def.bool_return = 0;\n            def.cross_loop = false;\n            def.direct_access = false;\n            def.drop_return = 0;\n            def.escaped = [];\n            def.first_decl = null;\n            def.fixed = !def.const_redefs\n                && !def.scope.pinned()\n                && !compressor.exposed(def)\n                && !(def.init instanceof AST_LambdaExpression && def.init !== def.scope)\n                && def.init;\n            def.reassigned = 0;\n            def.recursive_refs = 0;\n            def.references = [];\n            def.single_use = undefined;\n        }\n\n        function reset_block_variables(tw, compressor, scope) {\n            scope.variables.each(function(def) {\n                reset_def(tw, compressor, def);\n            });\n        }\n\n        function reset_variables(tw, compressor, scope) {\n            scope.fn_defs = [];\n            scope.variables.each(function(def) {\n                reset_def(tw, compressor, def);\n                var init = def.init;\n                if (init instanceof AST_LambdaDefinition) {\n                    scope.fn_defs.push(init);\n                    init.safe_ids = null;\n                }\n                if (def.fixed === null) {\n                    def.safe_ids = tw.safe_ids;\n                    mark(tw, def);\n                } else if (def.fixed) {\n                    tw.loop_ids[def.id] = tw.in_loop;\n                    mark(tw, def);\n                }\n            });\n            scope.may_call_this = function() {\n                scope.may_call_this = scope.contains_this() ? return_true : return_false;\n            };\n            if (scope.uses_arguments) scope.each_argname(function(node) {\n                node.definition().last_ref = false;\n            });\n            if (compressor.option("ie")) scope.variables.each(function(def) {\n                var d = def.orig[0].definition();\n                if (d !== def) d.fixed = false;\n            });\n        }\n\n        function safe_to_visit(tw, fn) {\n            var marker = fn.safe_ids;\n            return marker === undefined || marker === tw.safe_ids;\n        }\n\n        function walk_fn_def(tw, fn) {\n            var was_scanning = tw.fn_scanning;\n            tw.fn_scanning = fn;\n            fn.walk(tw);\n            tw.fn_scanning = was_scanning;\n        }\n\n        function revisit_fn_def(tw, fn) {\n            fn.enclosed.forEach(function(d) {\n                if (fn.variables.get(d.name) === d) return;\n                if (safe_to_read(tw, d)) return;\n                d.single_use = false;\n                var fixed = d.fixed;\n                if (typeof fixed == "function") fixed = fixed();\n                if (fixed instanceof AST_Lambda) {\n                    var safe_ids = fixed.safe_ids;\n                    switch (safe_ids) {\n                      case null:\n                      case false:\n                        return;\n                      default:\n                        if (safe_ids && safe_ids.seq !== tw.safe_ids.seq) return;\n                    }\n                }\n                d.fixed = false;\n            });\n        }\n\n        function mark_fn_def(tw, def, fn) {\n            var marker = fn.safe_ids;\n            if (marker === undefined) return;\n            if (marker === false) return;\n            if (fn.parent_scope.resolve().may_call_this === return_true) {\n                if (member(fn, tw.fn_visited)) revisit_fn_def(tw, fn);\n            } else if (marker) {\n                var visited = member(fn, tw.fn_visited);\n                if (marker === tw.safe_ids) {\n                    if (!visited) walk_fn_def(tw, fn);\n                } else if (visited) {\n                    revisit_fn_def(tw, fn);\n                } else {\n                    fn.safe_ids = false;\n                }\n            } else if (tw.fn_scanning && tw.fn_scanning !== def.scope.resolve()) {\n                fn.safe_ids = false;\n            } else {\n                fn.safe_ids = tw.safe_ids;\n                walk_fn_def(tw, fn);\n            }\n        }\n\n        function pop_scope(tw, scope) {\n            pop(tw);\n            var fn_defs = scope.fn_defs;\n            fn_defs.forEach(function(fn) {\n                fn.safe_ids = tw.safe_ids;\n                walk_fn_def(tw, fn);\n            });\n            fn_defs.forEach(function(fn) {\n                fn.safe_ids = undefined;\n            });\n            scope.fn_defs = undefined;\n            scope.may_call_this = undefined;\n        }\n\n        function push(tw, sequential, conditional) {\n            var defined_ids = Object.create(tw.defined_ids);\n            if (!sequential || conditional) defined_ids.seq = Object.create(null);\n            tw.defined_ids = defined_ids;\n            var safe_ids = Object.create(tw.safe_ids);\n            if (!sequential) safe_ids.seq = {};\n            if (conditional) safe_ids.cond = true;\n            tw.safe_ids = safe_ids;\n        }\n\n        function pop(tw) {\n            tw.defined_ids = Object.getPrototypeOf(tw.defined_ids);\n            tw.safe_ids = Object.getPrototypeOf(tw.safe_ids);\n        }\n\n        function access(tw, def) {\n            var seq = tw.defined_ids.seq;\n            tw.defined_ids[def.id] = seq;\n            seq[def.id] = true;\n        }\n\n        function assign(tw, def) {\n            var seq = tw.defined_ids.seq;\n            tw.assigned_ids[def.id] = seq;\n            seq[def.id] = false;\n        }\n\n        function safe_to_access(tw, def) {\n            var seq = tw.defined_ids.seq;\n            var defined = tw.defined_ids[def.id];\n            if (defined !== seq) return false;\n            if (!defined[def.id]) return false;\n            var assigned = tw.assigned_ids[def.id];\n            return !assigned || assigned === seq;\n        }\n\n        function mark(tw, def) {\n            tw.safe_ids[def.id] = {};\n        }\n\n        function push_ref(def, ref) {\n            def.references.push(ref);\n            if (def.last_ref !== false) def.last_ref = ref;\n        }\n\n        function safe_to_read(tw, def) {\n            if (def.single_use == "m") return false;\n            var safe = tw.safe_ids[def.id];\n            if (safe) {\n                var in_order = HOP(tw.safe_ids, def.id);\n                if (!in_order) {\n                    var seq = tw.safe_ids.seq;\n                    if (!safe.read) {\n                        safe.read = seq;\n                    } else if (safe.read !== seq) {\n                        safe.read = true;\n                    }\n                }\n                if (def.fixed == null) {\n                    if (is_arguments(def)) return false;\n                    if (def.global && def.name == "arguments") return false;\n                    tw.loop_ids[def.id] = null;\n                    def.fixed = make_node(AST_Undefined, def.orig[0]);\n                    if (in_order) def.safe_ids = undefined;\n                    return true;\n                }\n                return !safe.assign || safe.assign === tw.safe_ids;\n            }\n            return def.fixed instanceof AST_LambdaDefinition;\n        }\n\n        function safe_to_assign(tw, def, declare) {\n            if (!declare) {\n                if (is_funarg(def) && def.scope.uses_arguments && !tw.has_directive("use strict")) return false;\n                if (!all(def.orig, function(sym) {\n                    return !(sym instanceof AST_SymbolConst);\n                })) return false;\n            }\n            if (def.fixed === undefined) return declare || all(def.orig, function(sym) {\n                return !(sym instanceof AST_SymbolLet);\n            });\n            if (def.fixed === false || def.fixed === 0) return false;\n            var safe = tw.safe_ids[def.id];\n            if (def.safe_ids) {\n                def.safe_ids[def.id] = false;\n                def.safe_ids = undefined;\n                return def.fixed === null || HOP(tw.safe_ids, def.id) && !safe.read;\n            }\n            if (!HOP(tw.safe_ids, def.id)) {\n                if (!safe) return false;\n                if (safe.read || tw.in_loop) {\n                    var scope = tw.find_parent(AST_BlockScope);\n                    if (scope instanceof AST_Class) return false;\n                    if (def.scope.resolve() !== scope.resolve()) return false;\n                }\n                safe.assign = safe.assign && safe.assign !== tw.safe_ids ? true : tw.safe_ids;\n            }\n            if (def.fixed != null && safe.read) {\n                if (safe.read !== tw.safe_ids.seq) return false;\n                if (tw.loop_ids[def.id] !== tw.in_loop) return false;\n            }\n            return safe_to_read(tw, def) && all(def.orig, function(sym) {\n                return !(sym instanceof AST_SymbolLambda);\n            });\n        }\n\n        function ref_once(compressor, def) {\n            return compressor.option("unused")\n                && !def.scope.pinned()\n                && def.single_use !== false\n                && def.references.length - def.recursive_refs == 1\n                && !(is_funarg(def) && def.scope.uses_arguments);\n        }\n\n        function is_immutable(value) {\n            if (!value) return false;\n            if (value instanceof AST_Assign) {\n                var op = value.operator;\n                return op == "=" ? is_immutable(value.right) : !lazy_op[op.slice(0, -1)];\n            }\n            if (value instanceof AST_Sequence) return is_immutable(value.tail_node());\n            return value.is_constant() || is_lambda(value) || value instanceof AST_ObjectIdentity;\n        }\n\n        function value_in_use(node, parent) {\n            if (parent instanceof AST_Array) return true;\n            if (parent instanceof AST_Binary) return lazy_op[parent.operator];\n            if (parent instanceof AST_Conditional) return parent.condition !== node;\n            if (parent instanceof AST_Sequence) return parent.tail_node() === node;\n            if (parent instanceof AST_Spread) return true;\n        }\n\n        function mark_escaped(tw, d, scope, node, value, level, depth) {\n            var parent = tw.parent(level);\n            if (value && value.is_constant()) return;\n            if (has_escaped(d, scope, node, parent)) {\n                d.escaped.push(parent);\n                if (depth > 1 && !(value && value.is_constant_expression(scope))) depth = 1;\n                if (!d.escaped.depth || d.escaped.depth > depth) d.escaped.depth = depth;\n                if (d.scope.resolve() !== scope.resolve()) d.escaped.cross_scope = true;\n                if (d.fixed) d.fixed.escaped = d.escaped;\n                return;\n            } else if (value_in_use(node, parent)) {\n                mark_escaped(tw, d, scope, parent, parent, level + 1, depth);\n            } else if (parent instanceof AST_ObjectKeyVal && parent.value === node) {\n                var obj = tw.parent(level + 1);\n                mark_escaped(tw, d, scope, obj, obj, level + 2, depth);\n            } else if (parent instanceof AST_PropAccess && parent.expression === node) {\n                value = read_property(value, parent);\n                mark_escaped(tw, d, scope, parent, value, level + 1, depth + 1);\n                if (value) return;\n            }\n            if (level > 0) return;\n            if (parent instanceof AST_Call && parent.expression === node) return;\n            if (parent instanceof AST_Sequence && parent.tail_node() !== node) return;\n            if (parent instanceof AST_SimpleStatement) return;\n            if (parent instanceof AST_Unary && !unary_side_effects[parent.operator]) return;\n            d.direct_access = true;\n            if (d.fixed) d.fixed.direct_access = true;\n        }\n\n        function mark_assignment_to_arguments(node) {\n            if (!(node instanceof AST_Sub)) return;\n            var expr = node.expression;\n            if (!(expr instanceof AST_SymbolRef)) return;\n            var def = expr.definition();\n            if (!is_arguments(def)) return;\n            var key = node.property;\n            if (key.is_constant()) key = key.value;\n            if (!(key instanceof AST_Node) && !RE_POSITIVE_INTEGER.test(key)) return;\n            def.reassigned++;\n            (key instanceof AST_Node ? def.scope.argnames : [ def.scope.argnames[key] ]).forEach(function(argname) {\n                if (argname instanceof AST_SymbolFunarg) argname.definition().fixed = false;\n            });\n        }\n\n        function make_fixed(save, fn) {\n            var prev_save, prev_value;\n            return function() {\n                var current = save();\n                if (prev_save !== current) {\n                    prev_save = current;\n                    prev_value = fn(current);\n                }\n                return prev_value;\n            };\n        }\n\n        function make_fixed_default(compressor, node, save) {\n            var prev_save, prev_seq;\n            return function() {\n                if (prev_seq === node) return node;\n                var current = save();\n                var ev = fuzzy_eval(compressor, current, true);\n                if (ev instanceof AST_Node) {\n                    prev_seq = node;\n                } else if (prev_save !== current) {\n                    prev_save = current;\n                    prev_seq = ev === undefined ? make_sequence(node, [ current, node.value ]) : current;\n                }\n                return prev_seq;\n            };\n        }\n\n        function scan_declaration(tw, compressor, lhs, fixed, visit) {\n            var scanner = new TreeWalker(function(node) {\n                if (node instanceof AST_DefaultValue) {\n                    reset_flags(node);\n                    push(tw, true, true);\n                    node.value.walk(tw);\n                    pop(tw);\n                    var save = fixed;\n                    if (save) fixed = make_fixed_default(compressor, node, save);\n                    node.name.walk(scanner);\n                    fixed = save;\n                    return true;\n                }\n                if (node instanceof AST_DestructuredArray) {\n                    reset_flags(node);\n                    var save = fixed;\n                    node.elements.forEach(function(node, index) {\n                        if (node instanceof AST_Hole) return reset_flags(node);\n                        if (save) fixed = make_fixed(save, function(value) {\n                            return make_node(AST_Sub, node, {\n                                expression: value,\n                                property: make_node(AST_Number, node, { value: index }),\n                            });\n                        });\n                        node.walk(scanner);\n                    });\n                    if (node.rest) {\n                        var fixed_node;\n                        if (save) fixed = compressor.option("rests") && make_fixed(save, function(value) {\n                            if (!(value instanceof AST_Array)) return node;\n                            for (var i = 0, len = node.elements.length; i < len; i++) {\n                                if (value.elements[i] instanceof AST_Spread) return node;\n                            }\n                            if (!fixed_node) fixed_node = make_node(AST_Array, node, {});\n                            fixed_node.elements = value.elements.slice(len);\n                            return fixed_node;\n                        });\n                        node.rest.walk(scanner);\n                    }\n                    fixed = save;\n                    return true;\n                }\n                if (node instanceof AST_DestructuredObject) {\n                    reset_flags(node);\n                    var save = fixed;\n                    node.properties.forEach(function(node) {\n                        reset_flags(node);\n                        if (node.key instanceof AST_Node) {\n                            push(tw);\n                            node.key.walk(tw);\n                            pop(tw);\n                        }\n                        if (save) fixed = make_fixed(save, function(value) {\n                            var key = node.key;\n                            var type = AST_Sub;\n                            if (typeof key == "string") {\n                                if (is_identifier_string(key)) {\n                                    type = AST_Dot;\n                                } else {\n                                    key = make_node_from_constant(key, node);\n                                }\n                            }\n                            return make_node(type, node, {\n                                expression: value,\n                                property: key,\n                            });\n                        });\n                        node.value.walk(scanner);\n                    });\n                    if (node.rest) {\n                        fixed = false;\n                        node.rest.walk(scanner);\n                    }\n                    fixed = save;\n                    return true;\n                }\n                visit(node, fixed, function() {\n                    var save_len = tw.stack.length;\n                    for (var i = 0, len = scanner.stack.length - 1; i < len; i++) {\n                        tw.stack.push(scanner.stack[i]);\n                    }\n                    node.walk(tw);\n                    tw.stack.length = save_len;\n                });\n                return true;\n            });\n            lhs.walk(scanner);\n        }\n\n        function reduce_iife(tw, descend, compressor) {\n            var fn = this;\n            fn.inlined = false;\n            var iife = tw.parent();\n            var sequential = !is_async(fn) && !is_generator(fn);\n            var hit = !sequential;\n            var aborts = false;\n            fn.walk(new TreeWalker(function(node) {\n                if (hit) return aborts = true;\n                if (node instanceof AST_Return) return hit = true;\n                if (node instanceof AST_Scope && node !== fn) return true;\n            }));\n            if (aborts) push(tw, sequential);\n            reset_variables(tw, compressor, fn);\n            // Virtually turn IIFE parameters into variable definitions:\n            //   (function(a,b) {...})(c,d) ---\x3e (function() {var a=c,b=d; ...})()\n            // So existing transformation rules can work on them.\n            var safe = !fn.uses_arguments || tw.has_directive("use strict");\n            fn.argnames.forEach(function(argname, i) {\n                var value = iife.args[i];\n                scan_declaration(tw, compressor, argname, function() {\n                    var j = fn.argnames.indexOf(argname);\n                    var arg = j < 0 ? value : iife.args[j];\n                    if (arg instanceof AST_Sequence && arg.expressions.length < 2) arg = arg.expressions[0];\n                    return arg || make_node(AST_Undefined, iife);\n                }, visit);\n            });\n            var rest = fn.rest, fixed_node;\n            if (rest) scan_declaration(tw, compressor, rest, compressor.option("rests") && function() {\n                if (fn.rest !== rest) return rest;\n                if (!fixed_node) fixed_node = make_node(AST_Array, fn, {});\n                fixed_node.elements = iife.args.slice(fn.argnames.length);\n                return fixed_node;\n            }, visit);\n            walk_lambda(fn, tw);\n            var defined_ids = tw.defined_ids;\n            var safe_ids = tw.safe_ids;\n            pop_scope(tw, fn);\n            if (!aborts) {\n                tw.defined_ids = defined_ids;\n                tw.safe_ids = safe_ids;\n            }\n            return true;\n\n            function visit(node, fixed) {\n                var d = node.definition();\n                if (!d.first_decl && d.references.length == 0) d.first_decl = node;\n                if (fixed && safe && d.fixed === undefined) {\n                    mark(tw, d);\n                    tw.loop_ids[d.id] = tw.in_loop;\n                    d.fixed = fixed;\n                    d.fixed.assigns = [ node ];\n                } else {\n                    d.fixed = false;\n                }\n            }\n        }\n\n        def(AST_Assign, function(tw, descend, compressor) {\n            var node = this;\n            var left = node.left;\n            var right = node.right;\n            var ld = left instanceof AST_SymbolRef && left.definition();\n            var scan = ld || left instanceof AST_Destructured;\n            switch (node.operator) {\n              case "=":\n                if (left.equals(right) && !left.has_side_effects(compressor)) {\n                    right.walk(tw);\n                    walk_prop(left);\n                    return true;\n                }\n                if (ld && right instanceof AST_LambdaExpression) {\n                    walk_assign();\n                    right.parent_scope.resolve().fn_defs.push(right);\n                    right.safe_ids = null;\n                    if (!ld.fixed || !node.write_only || tw.safe_ids.cond) mark_fn_def(tw, ld, right);\n                    return true;\n                }\n                if (scan) {\n                    right.walk(tw);\n                    walk_assign();\n                    return true;\n                }\n                mark_assignment_to_arguments(left);\n                return;\n              case "&&=":\n              case "||=":\n              case "??=":\n                var lazy = true;\n              default:\n                if (!scan) {\n                    mark_assignment_to_arguments(left);\n                    return walk_lazy();\n                }\n                assign(tw, ld);\n                ld.assignments++;\n                var fixed = ld.fixed;\n                if (is_modified(compressor, tw, node, node, 0)) {\n                    ld.fixed = false;\n                    return walk_lazy();\n                }\n                var safe = safe_to_read(tw, ld);\n                if (lazy) push(tw, true, true);\n                right.walk(tw);\n                if (lazy) pop(tw);\n                if (safe && !left.in_arg && safe_to_assign(tw, ld)) {\n                    push_ref(ld, left);\n                    mark(tw, ld);\n                    if (ld.single_use) ld.single_use = false;\n                    left.fixed = ld.fixed = function() {\n                        return make_node(AST_Binary, node, {\n                            operator: node.operator.slice(0, -1),\n                            left: make_ref(left, fixed),\n                            right: node.right,\n                        });\n                    };\n                    left.fixed.assigns = !fixed || !fixed.assigns ? [ ld.orig[0] ] : fixed.assigns.slice();\n                    left.fixed.assigns.push(node);\n                    left.fixed.to_binary = replace_ref(function(node) {\n                        return node.left;\n                    }, fixed);\n                } else {\n                    left.walk(tw);\n                    ld.fixed = false;\n                }\n                return true;\n            }\n\n            function walk_prop(lhs) {\n                reset_flags(lhs);\n                if (lhs instanceof AST_Dot) {\n                    walk_prop(lhs.expression);\n                } else if (lhs instanceof AST_Sub) {\n                    walk_prop(lhs.expression);\n                    lhs.property.walk(tw);\n                } else if (lhs instanceof AST_SymbolRef) {\n                    var d = lhs.definition();\n                    push_ref(d, lhs);\n                    if (d.fixed) {\n                        lhs.fixed = d.fixed;\n                        if (lhs.fixed.assigns) {\n                            lhs.fixed.assigns.push(node);\n                        } else {\n                            lhs.fixed.assigns = [ node ];\n                        }\n                    }\n                } else {\n                    lhs.walk(tw);\n                }\n            }\n\n            function walk_assign() {\n                var recursive = ld && recursive_ref(tw, ld);\n                var modified = is_modified(compressor, tw, node, right, 0, is_immutable(right), recursive);\n                scan_declaration(tw, compressor, left, function() {\n                    return node.right;\n                }, function(sym, fixed, walk) {\n                    if (!(sym instanceof AST_SymbolRef)) {\n                        mark_assignment_to_arguments(sym);\n                        walk();\n                        return;\n                    }\n                    var d = sym.definition();\n                    assign(tw, d);\n                    d.assignments++;\n                    if (!fixed || sym.in_arg || !safe_to_assign(tw, d)) {\n                        walk();\n                        d.fixed = false;\n                    } else {\n                        push_ref(d, sym);\n                        mark(tw, d);\n                        if (left instanceof AST_Destructured\n                            || d.orig.length == 1 && d.orig[0] instanceof AST_SymbolDefun) {\n                            d.single_use = false;\n                        }\n                        tw.loop_ids[d.id] = tw.in_loop;\n                        d.fixed = modified ? 0 : fixed;\n                        sym.fixed = fixed;\n                        sym.fixed.assigns = [ node ];\n                        mark_escaped(tw, d, sym.scope, node, right, 0, 1);\n                    }\n                });\n            }\n\n            function walk_lazy() {\n                if (!lazy) return;\n                left.walk(tw);\n                push(tw, true, true);\n                right.walk(tw);\n                pop(tw);\n                return true;\n            }\n        });\n        def(AST_Binary, function(tw) {\n            if (!lazy_op[this.operator]) return;\n            this.left.walk(tw);\n            push(tw, true, true);\n            this.right.walk(tw);\n            pop(tw);\n            return true;\n        });\n        def(AST_BlockScope, function(tw, descend, compressor) {\n            reset_block_variables(tw, compressor, this);\n        });\n        def(AST_Call, function(tw) {\n            var node = this;\n            var exp = node.expression;\n            if (exp instanceof AST_LambdaExpression) {\n                var iife = is_iife_single(node);\n                node.args.forEach(function(arg) {\n                    arg.walk(tw);\n                    if (arg instanceof AST_Spread) iife = false;\n                });\n                if (iife) exp.reduce_vars = reduce_iife;\n                exp.walk(tw);\n                if (iife) delete exp.reduce_vars;\n                return true;\n            }\n            if (node.TYPE == "Call") switch (tw.in_boolean_context()) {\n              case "d":\n                var drop = true;\n              case true:\n                mark_refs(exp, drop);\n            }\n            exp.walk(tw);\n            var optional = node.optional;\n            if (optional) push(tw, true, true);\n            node.args.forEach(function(arg) {\n                arg.walk(tw);\n            });\n            if (optional) pop(tw);\n            var fixed = exp instanceof AST_SymbolRef && exp.fixed_value();\n            if (fixed instanceof AST_Lambda) {\n                mark_fn_def(tw, exp.definition(), fixed);\n            } else {\n                tw.defined_ids.seq = {};\n                tw.find_parent(AST_Scope).may_call_this();\n            }\n            return true;\n\n            function mark_refs(node, drop) {\n                if (node instanceof AST_Assign) {\n                    if (node.operator != "=") return;\n                    mark_refs(node.left, drop);\n                    mark_refs(node.right, drop);\n                } else if (node instanceof AST_Binary) {\n                    if (!lazy_op[node.operator]) return;\n                    mark_refs(node.left, drop);\n                    mark_refs(node.right, drop);\n                } else if (node instanceof AST_Conditional) {\n                    mark_refs(node.consequent, drop);\n                    mark_refs(node.alternative, drop);\n                } else if (node instanceof AST_SymbolRef) {\n                    var def = node.definition();\n                    def.bool_return++;\n                    if (drop) def.drop_return++;\n                }\n            }\n        });\n        def(AST_Class, function(tw, descend, compressor) {\n            var node = this;\n            reset_block_variables(tw, compressor, node);\n            if (node.extends) node.extends.walk(tw);\n            var props = node.properties.filter(function(prop) {\n                reset_flags(prop);\n                if (prop.key instanceof AST_Node) {\n                    tw.push(prop);\n                    prop.key.walk(tw);\n                    tw.pop();\n                }\n                return prop.value;\n            });\n            if (node.name) {\n                var d = node.name.definition();\n                var parent = tw.parent();\n                if (parent instanceof AST_ExportDeclaration || parent instanceof AST_ExportDefault) d.single_use = false;\n                if (safe_to_assign(tw, d, true)) {\n                    mark(tw, d);\n                    tw.loop_ids[d.id] = tw.in_loop;\n                    d.fixed = function() {\n                        return node;\n                    };\n                    d.fixed.assigns = [ node ];\n                    if (!is_safe_lexical(d)) d.single_use = false;\n                } else {\n                    d.fixed = false;\n                }\n            }\n            props.forEach(function(prop) {\n                tw.push(prop);\n                if (!prop.static || is_static_field_or_init(prop) && prop.value.contains_this()) {\n                    push(tw);\n                    prop.value.walk(tw);\n                    pop(tw);\n                } else {\n                    prop.value.walk(tw);\n                }\n                tw.pop();\n            });\n            return true;\n        });\n        def(AST_ClassInitBlock, function(tw, descend, compressor) {\n            var node = this;\n            push(tw, true);\n            reset_variables(tw, compressor, node);\n            descend();\n            pop_scope(tw, node);\n            return true;\n        });\n        def(AST_Conditional, function(tw) {\n            this.condition.walk(tw);\n            push(tw, true, true);\n            this.consequent.walk(tw);\n            pop(tw);\n            push(tw, true, true);\n            this.alternative.walk(tw);\n            pop(tw);\n            return true;\n        });\n        def(AST_DefaultValue, function(tw) {\n            push(tw, true, true);\n            this.value.walk(tw);\n            pop(tw);\n            this.name.walk(tw);\n            return true;\n        });\n        def(AST_Do, function(tw) {\n            var save_loop = tw.in_loop;\n            tw.in_loop = this;\n            push(tw);\n            this.body.walk(tw);\n            if (has_loop_control(this, tw.parent())) {\n                pop(tw);\n                push(tw);\n            }\n            this.condition.walk(tw);\n            pop(tw);\n            tw.in_loop = save_loop;\n            return true;\n        });\n        def(AST_Dot, function(tw, descend) {\n            descend();\n            var node = this;\n            var expr = node.expression;\n            if (!node.optional) {\n                while (expr instanceof AST_Assign && expr.operator == "=") {\n                    var lhs = expr.left;\n                    if (lhs instanceof AST_SymbolRef) access(tw, lhs.definition());\n                    expr = expr.right;\n                }\n                if (expr instanceof AST_SymbolRef) access(tw, expr.definition());\n            }\n            return true;\n        });\n        def(AST_For, function(tw, descend, compressor) {\n            var node = this;\n            reset_block_variables(tw, compressor, node);\n            if (node.init) node.init.walk(tw);\n            var save_loop = tw.in_loop;\n            tw.in_loop = node;\n            push(tw);\n            if (node.condition) node.condition.walk(tw);\n            node.body.walk(tw);\n            if (node.step) {\n                if (has_loop_control(node, tw.parent())) {\n                    pop(tw);\n                    push(tw);\n                }\n                node.step.walk(tw);\n            }\n            pop(tw);\n            tw.in_loop = save_loop;\n            return true;\n        });\n        def(AST_ForEnumeration, function(tw, descend, compressor) {\n            var node = this;\n            reset_block_variables(tw, compressor, node);\n            node.object.walk(tw);\n            var save_loop = tw.in_loop;\n            tw.in_loop = node;\n            push(tw);\n            var init = node.init;\n            if (init instanceof AST_Definitions) {\n                init.definitions[0].name.mark_symbol(function(node) {\n                    if (node instanceof AST_SymbolDeclaration) {\n                        var def = node.definition();\n                        def.assignments++;\n                        def.fixed = false;\n                    }\n                }, tw);\n            } else if (init instanceof AST_Destructured || init instanceof AST_SymbolRef) {\n                init.mark_symbol(function(node) {\n                    if (node instanceof AST_SymbolRef) {\n                        var def = node.definition();\n                        push_ref(def, node);\n                        def.assignments++;\n                        if (!node.is_immutable()) def.fixed = false;\n                    }\n                }, tw);\n            } else {\n                init.walk(tw);\n            }\n            node.body.walk(tw);\n            pop(tw);\n            tw.in_loop = save_loop;\n            return true;\n        });\n        def(AST_If, function(tw) {\n            this.condition.walk(tw);\n            push(tw, true, true);\n            this.body.walk(tw);\n            pop(tw);\n            if (this.alternative) {\n                push(tw, true, true);\n                this.alternative.walk(tw);\n                pop(tw);\n            }\n            return true;\n        });\n        def(AST_LabeledStatement, function(tw) {\n            push(tw, true);\n            this.body.walk(tw);\n            pop(tw);\n            return true;\n        });\n        def(AST_Lambda, function(tw, descend, compressor) {\n            var fn = this;\n            if (!safe_to_visit(tw, fn)) return true;\n            if (!push_uniq(tw.fn_visited, fn)) return true;\n            fn.inlined = false;\n            push(tw);\n            reset_variables(tw, compressor, fn);\n            descend();\n            pop_scope(tw, fn);\n            if (fn.name) mark_escaped(tw, fn.name.definition(), fn, fn.name, fn, 0, 1);\n            return true;\n        });\n        def(AST_LambdaDefinition, function(tw, descend, compressor) {\n            var fn = this;\n            var def = fn.name.definition();\n            if (!safe_to_trim(fn)) def.fixed = false;\n            var parent = tw.parent();\n            if (parent instanceof AST_ExportDeclaration || parent instanceof AST_ExportDefault) def.single_use = false;\n            if (!safe_to_visit(tw, fn)) return true;\n            if (!push_uniq(tw.fn_visited, fn)) return true;\n            fn.inlined = false;\n            push(tw);\n            reset_variables(tw, compressor, fn);\n            descend();\n            pop_scope(tw, fn);\n            return true;\n        });\n        def(AST_Sub, function(tw, descend) {\n            var node = this;\n            var expr = node.expression;\n            if (node.optional) {\n                expr.walk(tw);\n                push(tw, true, true);\n                node.property.walk(tw);\n                pop(tw);\n            } else {\n                descend();\n                while (expr instanceof AST_Assign && expr.operator == "=") {\n                    var lhs = expr.left;\n                    if (lhs instanceof AST_SymbolRef) access(tw, lhs.definition());\n                    expr = expr.right;\n                }\n                if (expr instanceof AST_SymbolRef) access(tw, expr.definition());\n            }\n            return true;\n        });\n        def(AST_Switch, function(tw, descend, compressor) {\n            var node = this;\n            reset_block_variables(tw, compressor, node);\n            node.expression.walk(tw);\n            var first = true;\n            node.body.forEach(function(branch) {\n                if (branch instanceof AST_Default) return;\n                branch.expression.walk(tw);\n                if (first) {\n                    first = false;\n                    push(tw, true, true);\n                }\n            });\n            if (!first) pop(tw);\n            walk_body(node, tw);\n            return true;\n        });\n        def(AST_SwitchBranch, function(tw) {\n            push(tw, true, true);\n            walk_body(this, tw);\n            pop(tw);\n            return true;\n        });\n        def(AST_SymbolCatch, function() {\n            var d = this.definition();\n            if (!d.first_decl && d.references.length == 0) d.first_decl = this;\n            d.fixed = false;\n        });\n        def(AST_SymbolDeclaration, function() {\n            var d = this.definition();\n            if (!d.first_decl && d.references.length == 0) d.first_decl = this;\n        });\n        def(AST_SymbolDefun, function() {\n            var d = this.definition();\n            if (!d.first_decl && d.references.length == 0) d.first_decl = this;\n            if (d.orig.length > 1 && d.scope.resolve() !== this.scope) d.fixed = false;\n        });\n        def(AST_SymbolImport, function() {\n            var d = this.definition();\n            d.first_decl = this;\n            d.fixed = false;\n        });\n        def(AST_SymbolRef, function(tw, descend, compressor) {\n            var ref = this;\n            var d = ref.definition();\n            var fixed = d.fixed || d.last_ref && d.last_ref.fixed;\n            push_ref(d, ref);\n            if (safe_to_access(tw, d)) ref.defined = true;\n            if (d.references.length == 1 && !d.fixed && d.orig[0] instanceof AST_SymbolDefun) {\n                tw.loop_ids[d.id] = tw.in_loop;\n            }\n            var recursive = recursive_ref(tw, d);\n            if (recursive) recursive.enclosed.forEach(function(def) {\n                if (d === def) return;\n                if (def.scope.resolve() === recursive) return;\n                var assigns = def.fixed && def.fixed.assigns;\n                if (!assigns) return;\n                if (assigns[assigns.length - 1] instanceof AST_VarDef) return;\n                var safe = tw.safe_ids[def.id];\n                if (!safe) return;\n                safe.assign = true;\n            });\n            if (d.single_use == "m" && d.fixed) {\n                d.fixed = 0;\n                d.single_use = false;\n            }\n            switch (d.fixed) {\n              case 0:\n                if (!safe_to_read(tw, d)) d.fixed = false;\n              case false:\n                var redef = d.redefined();\n                if (redef && cross_scope(d.scope, ref.scope)) redef.single_use = false;\n                break;\n              case undefined:\n                d.fixed = false;\n                break;\n              default:\n                if (!safe_to_read(tw, d)) {\n                    d.fixed = false;\n                    break;\n                }\n                if (ref.in_arg && d.orig[0] instanceof AST_SymbolLambda) ref.fixed = d.scope;\n                var value = ref.fixed_value();\n                if (recursive) {\n                    d.recursive_refs++;\n                } else if (value && ref_once(compressor, d)) {\n                    d.in_loop = tw.loop_ids[d.id] !== tw.in_loop;\n                    d.single_use = is_lambda(value)\n                            && !value.pinned()\n                            && (!d.in_loop || tw.parent() instanceof AST_Call)\n                        || !d.in_loop\n                            && d.scope === ref.scope.resolve()\n                            && value.is_constant_expression();\n                } else {\n                    d.single_use = false;\n                }\n                if (is_modified(compressor, tw, ref, value, 0, is_immutable(value), recursive)) {\n                    if (d.single_use) {\n                        d.single_use = "m";\n                    } else {\n                        d.fixed = 0;\n                    }\n                }\n                if (d.fixed && tw.loop_ids[d.id] !== tw.in_loop) d.cross_loop = true;\n                mark_escaped(tw, d, ref.scope, ref, value, 0, 1);\n                break;\n            }\n            if (!ref.fixed) ref.fixed = d.fixed === 0 ? fixed : d.fixed;\n            if (!value && fixed) value = fixed instanceof AST_Node ? fixed : fixed();\n            if (!(value instanceof AST_Lambda)) return;\n            if (d.fixed) {\n                var parent = tw.parent();\n                if (parent instanceof AST_Call && parent.expression === ref) return;\n            }\n            mark_fn_def(tw, d, value);\n        });\n        def(AST_Template, function(tw) {\n            var node = this;\n            var tag = node.tag;\n            if (!tag) return;\n            if (tag instanceof AST_LambdaExpression) {\n                node.expressions.forEach(function(exp) {\n                    exp.walk(tw);\n                });\n                tag.walk(tw);\n                return true;\n            }\n            tag.walk(tw);\n            node.expressions.forEach(function(exp) {\n                exp.walk(tw);\n            });\n            var fixed = tag instanceof AST_SymbolRef && tag.fixed_value();\n            if (fixed instanceof AST_Lambda) {\n                mark_fn_def(tw, tag.definition(), fixed);\n            } else {\n                tw.find_parent(AST_Scope).may_call_this();\n            }\n            return true;\n        });\n        def(AST_Toplevel, function(tw, descend, compressor) {\n            var node = this;\n            node.globals.each(function(def) {\n                reset_def(tw, compressor, def);\n            });\n            push(tw, true);\n            reset_variables(tw, compressor, node);\n            descend();\n            pop_scope(tw, node);\n            return true;\n        });\n        def(AST_Try, function(tw, descend, compressor) {\n            var node = this;\n            reset_block_variables(tw, compressor, node);\n            push(tw, true);\n            walk_body(node, tw);\n            pop(tw);\n            if (node.bcatch) {\n                push(tw, true, true);\n                node.bcatch.walk(tw);\n                pop(tw);\n            }\n            if (node.bfinally) node.bfinally.walk(tw);\n            return true;\n        });\n        def(AST_Unary, function(tw) {\n            var node = this;\n            if (!UNARY_POSTFIX[node.operator]) return;\n            var exp = node.expression;\n            if (!(exp instanceof AST_SymbolRef)) {\n                mark_assignment_to_arguments(exp);\n                return;\n            }\n            var d = exp.definition();\n            d.assignments++;\n            var fixed = d.fixed;\n            if (safe_to_read(tw, d) && !exp.in_arg && safe_to_assign(tw, d)) {\n                push_ref(d, exp);\n                mark(tw, d);\n                if (d.single_use) d.single_use = false;\n                d.fixed = function() {\n                    return make_node(AST_Binary, node, {\n                        operator: node.operator.slice(0, -1),\n                        left: make_node(AST_UnaryPrefix, node, {\n                            operator: "+",\n                            expression: make_ref(exp, fixed),\n                        }),\n                        right: make_node(AST_Number, node, { value: 1 }),\n                    });\n                };\n                d.fixed.assigns = fixed && fixed.assigns ? fixed.assigns.slice() : [];\n                d.fixed.assigns.push(node);\n                if (node instanceof AST_UnaryPrefix) {\n                    exp.fixed = d.fixed;\n                } else {\n                    exp.fixed = function() {\n                        return make_node(AST_UnaryPrefix, node, {\n                            operator: "+",\n                            expression: make_ref(exp, fixed),\n                        });\n                    };\n                    exp.fixed.assigns = fixed && fixed.assigns;\n                    exp.fixed.to_prefix = replace_ref(function(node) {\n                        return node.expression;\n                    }, d.fixed);\n                }\n            } else {\n                exp.walk(tw);\n                d.fixed = false;\n            }\n            return true;\n        });\n        def(AST_VarDef, function(tw, descend, compressor) {\n            var node = this;\n            var value = node.value;\n            if (value instanceof AST_LambdaExpression && node.name instanceof AST_SymbolDeclaration) {\n                walk_defn();\n                value.parent_scope.resolve().fn_defs.push(value);\n                value.safe_ids = null;\n                var ld = node.name.definition();\n                if (!ld.fixed) mark_fn_def(tw, ld, value);\n            } else if (value) {\n                value.walk(tw);\n                walk_defn();\n            } else if (tw.parent() instanceof AST_Let) {\n                walk_defn();\n            } else {\n                node.name.walk(tw);\n            }\n            return true;\n\n            function walk_defn() {\n                scan_declaration(tw, compressor, node.name, function() {\n                    return node.value || make_node(AST_Undefined, node);\n                }, function(name, fixed) {\n                    var d = name.definition();\n                    assign(tw, d);\n                    if (!d.first_decl && d.references.length == 0) d.first_decl = name;\n                    if (fixed && safe_to_assign(tw, d, true)) {\n                        mark(tw, d);\n                        tw.loop_ids[d.id] = tw.in_loop;\n                        d.fixed = fixed;\n                        d.fixed.assigns = [ node ];\n                        if (name instanceof AST_SymbolConst && d.redefined()\n                            || !(can_drop_symbol(name) || is_safe_lexical(d))) {\n                            d.single_use = false;\n                        }\n                    } else {\n                        d.fixed = false;\n                    }\n                });\n            }\n        });\n        def(AST_While, function(tw, descend) {\n            var save_loop = tw.in_loop;\n            tw.in_loop = this;\n            push(tw);\n            descend();\n            pop(tw);\n            tw.in_loop = save_loop;\n            return true;\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("reduce_vars", func);\n    });\n\n    function reset_flags(node) {\n        node._squeezed = false;\n        node._optimized = false;\n        node.single_use = false;\n        if (node instanceof AST_BlockScope) node._var_names = undefined;\n        if (node instanceof AST_SymbolRef) node.fixed = undefined;\n    }\n\n    AST_Toplevel.DEFMETHOD("reset_opt_flags", function(compressor) {\n        var tw = new TreeWalker(compressor.option("reduce_vars") ? function(node, descend) {\n            reset_flags(node);\n            return node.reduce_vars(tw, descend, compressor);\n        } : reset_flags);\n        // Side-effect tracking on sequential property access\n        tw.assigned_ids = Object.create(null);\n        tw.defined_ids = Object.create(null);\n        tw.defined_ids.seq = {};\n        // Flow control for visiting lambda definitions\n        tw.fn_scanning = null;\n        tw.fn_visited = [];\n        // Record the loop body in which `AST_SymbolDeclaration` is first encountered\n        tw.in_loop = null;\n        tw.loop_ids = Object.create(null);\n        // Stack of look-up tables to keep track of whether a `SymbolDef` has been\n        // properly assigned before use:\n        // - `push()` & `pop()` when visiting conditional branches\n        // - backup & restore via `save_ids` when visiting out-of-order sections\n        tw.safe_ids = Object.create(null);\n        tw.safe_ids.seq = {};\n        this.walk(tw);\n    });\n\n    AST_Symbol.DEFMETHOD("fixed_value", function(ref_only) {\n        var def = this.definition();\n        var fixed = def.fixed;\n        if (fixed) {\n            if (this.fixed) fixed = this.fixed;\n            return (fixed instanceof AST_Node ? fixed : fixed()).tail_node();\n        }\n        fixed = fixed === 0 && this.fixed;\n        if (!fixed) return fixed;\n        var value = (fixed instanceof AST_Node ? fixed : fixed()).tail_node();\n        if (ref_only && def.escaped.depth != 1 && is_object(value, true)) return value;\n        if (value.is_constant()) return value;\n    });\n\n    AST_SymbolRef.DEFMETHOD("is_immutable", function() {\n        var def = this.redef || this.definition();\n        if (!(def.orig[0] instanceof AST_SymbolLambda)) return false;\n        if (def.orig.length == 1) return true;\n        if (!this.in_arg) return false;\n        return !(def.orig[1] instanceof AST_SymbolFunarg);\n    });\n\n    AST_Node.DEFMETHOD("convert_symbol", noop);\n    function convert_destructured(type, process) {\n        return this.transform(new TreeTransformer(function(node, descend) {\n            if (node instanceof AST_DefaultValue) {\n                node = node.clone();\n                node.name = node.name.transform(this);\n                return node;\n            }\n            if (node instanceof AST_Destructured) {\n                node = node.clone();\n                descend(node, this);\n                return node;\n            }\n            if (node instanceof AST_DestructuredKeyVal) {\n                node = node.clone();\n                node.value = node.value.transform(this);\n                return node;\n            }\n            return node.convert_symbol(type, process);\n        }));\n    }\n    AST_DefaultValue.DEFMETHOD("convert_symbol", convert_destructured);\n    AST_Destructured.DEFMETHOD("convert_symbol", convert_destructured);\n    function convert_symbol(type, process) {\n        var node = make_node(type, this);\n        return process(node, this) || node;\n    }\n    AST_SymbolDeclaration.DEFMETHOD("convert_symbol", convert_symbol);\n    AST_SymbolRef.DEFMETHOD("convert_symbol", convert_symbol);\n\n    function process_to_assign(ref) {\n        var def = ref.definition();\n        def.assignments++;\n        def.references.push(ref);\n    }\n\n    function mark_destructured(process, tw) {\n        var marker = new TreeWalker(function(node) {\n            if (node instanceof AST_DefaultValue) {\n                node.value.walk(tw);\n                node.name.walk(marker);\n                return true;\n            }\n            if (node instanceof AST_DestructuredKeyVal) {\n                if (node.key instanceof AST_Node) node.key.walk(tw);\n                node.value.walk(marker);\n                return true;\n            }\n            return process(node);\n        });\n        this.walk(marker);\n    }\n    AST_DefaultValue.DEFMETHOD("mark_symbol", mark_destructured);\n    AST_Destructured.DEFMETHOD("mark_symbol", mark_destructured);\n    function mark_symbol(process) {\n        return process(this);\n    }\n    AST_SymbolDeclaration.DEFMETHOD("mark_symbol", mark_symbol);\n    AST_SymbolRef.DEFMETHOD("mark_symbol", mark_symbol);\n\n    AST_Node.DEFMETHOD("match_symbol", function(predicate) {\n        return predicate(this);\n    });\n    function match_destructured(predicate, ignore_side_effects) {\n        var found = false;\n        var tw = new TreeWalker(function(node) {\n            if (found) return true;\n            if (node instanceof AST_DefaultValue) {\n                if (!ignore_side_effects) return found = true;\n                node.name.walk(tw);\n                return true;\n            }\n            if (node instanceof AST_DestructuredKeyVal) {\n                if (!ignore_side_effects && node.key instanceof AST_Node) return found = true;\n                node.value.walk(tw);\n                return true;\n            }\n            if (predicate(node)) return found = true;\n        });\n        this.walk(tw);\n        return found;\n    }\n    AST_DefaultValue.DEFMETHOD("match_symbol", match_destructured);\n    AST_Destructured.DEFMETHOD("match_symbol", match_destructured);\n\n    function in_async_generator(scope) {\n        return scope instanceof AST_AsyncGeneratorDefun || scope instanceof AST_AsyncGeneratorFunction;\n    }\n\n    function find_scope(compressor) {\n        var level = 0, node = compressor.self();\n        do {\n            if (node.variables) return node;\n        } while (node = compressor.parent(level++));\n    }\n\n    function find_try(compressor, level, node, scope, may_throw, sync) {\n        for (var parent; parent = compressor.parent(level++); node = parent) {\n            if (parent === scope) return false;\n            if (sync && parent instanceof AST_Lambda) {\n                if (parent.name || is_async(parent) || is_generator(parent)) return true;\n            } else if (parent instanceof AST_Try) {\n                if (parent.bfinally && parent.bfinally !== node) return true;\n                if (may_throw && parent.bcatch && parent.bcatch !== node) return true;\n            }\n        }\n        return false;\n    }\n\n    var identifier_atom = makePredicate("Infinity NaN undefined");\n    function is_lhs_read_only(lhs, compressor) {\n        if (lhs instanceof AST_Assign) {\n            if (lhs.operator != "=") return true;\n            if (lhs.right.tail_node().is_constant()) return true;\n            return is_lhs_read_only(lhs.left, compressor);\n        }\n        if (lhs instanceof AST_Atom) return true;\n        if (lhs instanceof AST_ObjectIdentity) return true;\n        if (lhs instanceof AST_PropAccess) {\n            if (lhs.property === "__proto__") return true;\n            lhs = lhs.expression;\n            if (lhs instanceof AST_SymbolRef) {\n                if (lhs.is_immutable()) return false;\n                lhs = lhs.fixed_value();\n            }\n            if (!lhs) return true;\n            if (lhs.tail_node().is_constant()) return true;\n            return is_lhs_read_only(lhs, compressor);\n        }\n        if (lhs instanceof AST_SymbolRef) {\n            if (lhs.is_immutable()) return true;\n            var def = lhs.definition();\n            return compressor.exposed(def) && identifier_atom[def.name];\n        }\n        return false;\n    }\n\n    function make_node(ctor, orig, props) {\n        if (props) {\n            props.start = orig.start;\n            props.end = orig.end;\n        } else {\n            props = orig;\n        }\n        return new ctor(props);\n    }\n\n    function make_sequence(orig, expressions) {\n        if (expressions.length == 1) return expressions[0];\n        return make_node(AST_Sequence, orig, { expressions: expressions.reduce(merge_sequence, []) });\n    }\n\n    function make_node_from_constant(val, orig) {\n        switch (typeof val) {\n          case "string":\n            return make_node(AST_String, orig, { value: val });\n          case "number":\n            if (isNaN(val)) return make_node(AST_NaN, orig);\n            if (isFinite(val)) {\n                return 1 / val < 0 ? make_node(AST_UnaryPrefix, orig, {\n                    operator: "-",\n                    expression: make_node(AST_Number, orig, { value: -val }),\n                }) : make_node(AST_Number, orig, { value: val });\n            }\n            return val < 0 ? make_node(AST_UnaryPrefix, orig, {\n                operator: "-",\n                expression: make_node(AST_Infinity, orig),\n            }) : make_node(AST_Infinity, orig);\n          case "boolean":\n            return make_node(val ? AST_True : AST_False, orig);\n          case "undefined":\n            return make_node(AST_Undefined, orig);\n          default:\n            if (val === null) {\n                return make_node(AST_Null, orig);\n            }\n            if (val instanceof RegExp) {\n                return make_node(AST_RegExp, orig, { value: val });\n            }\n            throw new Error(string_template("Can\'t handle constant of type: {type}", { type: typeof val }));\n        }\n    }\n\n    function needs_unbinding(val) {\n        return val instanceof AST_PropAccess\n            || is_undeclared_ref(val) && val.name == "eval";\n    }\n\n    // we shouldn\'t compress (1,func)(something) to\n    // func(something) because that changes the meaning of\n    // the func (becomes lexical instead of global).\n    function maintain_this_binding(parent, orig, val) {\n        var wrap = false;\n        if (parent.TYPE == "Call") {\n            wrap = parent.expression === orig && needs_unbinding(val);\n        } else if (parent instanceof AST_Template) {\n            wrap = parent.tag === orig && needs_unbinding(val);\n        } else if (parent instanceof AST_UnaryPrefix) {\n            wrap = parent.operator == "delete"\n                || parent.operator == "typeof" && is_undeclared_ref(val);\n        }\n        return wrap ? make_sequence(orig, [ make_node(AST_Number, orig, { value: 0 }), val ]) : val;\n    }\n\n    function merge_expression(base, target) {\n        var fixed_by_id = new Dictionary();\n        base.walk(new TreeWalker(function(node) {\n            if (!(node instanceof AST_SymbolRef)) return;\n            var def = node.definition();\n            var fixed = node.fixed;\n            if (!fixed || !fixed_by_id.has(def.id)) {\n                fixed_by_id.set(def.id, fixed);\n            } else if (fixed_by_id.get(def.id) !== fixed) {\n                fixed_by_id.set(def.id, false);\n            }\n        }));\n        if (fixed_by_id.size() > 0) target.walk(new TreeWalker(function(node) {\n            if (!(node instanceof AST_SymbolRef)) return;\n            var def = node.definition();\n            var fixed = node.fixed;\n            if (!fixed || !fixed_by_id.has(def.id)) return;\n            if (fixed_by_id.get(def.id) !== fixed) node.fixed = false;\n        }));\n        return target;\n    }\n\n    function merge_sequence(array, node) {\n        if (node instanceof AST_Sequence) {\n            [].push.apply(array, node.expressions);\n        } else {\n            array.push(node);\n        }\n        return array;\n    }\n\n    function is_lexical_definition(stat) {\n        return stat instanceof AST_Const || stat instanceof AST_DefClass || stat instanceof AST_Let;\n    }\n\n    function safe_to_trim(stat) {\n        if (stat instanceof AST_LambdaDefinition) {\n            var def = stat.name.definition();\n            var scope = stat.name.scope;\n            if (def.orig.length > 1 && def.scope.resolve() !== scope) return false;\n            return def.scope === scope || all(def.references, function(ref) {\n                var s = ref.scope;\n                do {\n                    if (s === scope) return true;\n                } while (s = s.parent_scope);\n            });\n        }\n        return !is_lexical_definition(stat);\n    }\n\n    function as_statement_array(thing) {\n        if (thing === null) return [];\n        if (thing instanceof AST_BlockStatement) return all(thing.body, safe_to_trim) ? thing.body : [ thing ];\n        if (thing instanceof AST_EmptyStatement) return [];\n        if (is_statement(thing)) return [ thing ];\n        throw new Error("Can\'t convert thing to statement array");\n    }\n\n    function is_empty(thing) {\n        if (thing === null) return true;\n        if (thing instanceof AST_EmptyStatement) return true;\n        if (thing instanceof AST_BlockStatement) return thing.body.length == 0;\n        return false;\n    }\n\n    function has_declarations_only(block) {\n        return all(block.body, function(stat) {\n            return is_empty(stat)\n                || stat instanceof AST_Defun\n                || stat instanceof AST_Var && declarations_only(stat);\n        });\n    }\n\n    function loop_body(x) {\n        if (x instanceof AST_IterationStatement) {\n            return x.body instanceof AST_BlockStatement ? x.body : x;\n        }\n        return x;\n    }\n\n    function is_iife_call(node) {\n        if (node.TYPE != "Call") return false;\n        do {\n            node = node.expression;\n        } while (node instanceof AST_PropAccess);\n        return node instanceof AST_LambdaExpression ? !is_arrow(node) : is_iife_call(node);\n    }\n\n    function is_iife_single(call) {\n        var exp = call.expression;\n        if (exp.name) return false;\n        if (!(call instanceof AST_New)) return true;\n        var found = false;\n        exp.walk(new TreeWalker(function(node) {\n            if (found) return true;\n            if (node instanceof AST_NewTarget) return found = true;\n            if (node instanceof AST_Scope && node !== exp) return true;\n        }));\n        return !found;\n    }\n\n    function is_undeclared_ref(node) {\n        return node instanceof AST_SymbolRef && node.definition().undeclared;\n    }\n\n    var global_names = makePredicate("Array Boolean clearInterval clearTimeout console Date decodeURI decodeURIComponent encodeURI encodeURIComponent Error escape eval EvalError Function isFinite isNaN JSON Map Math Number parseFloat parseInt RangeError ReferenceError RegExp Object Set setInterval setTimeout String SyntaxError TypeError unescape URIError WeakMap WeakSet");\n    AST_SymbolRef.DEFMETHOD("is_declared", function(compressor) {\n        return this.defined\n            || !this.definition().undeclared\n            || compressor.option("unsafe") && global_names[this.name];\n    });\n\n    function is_static_field_or_init(prop) {\n        return prop.static && prop.value && (prop instanceof AST_ClassField || prop instanceof AST_ClassInit);\n    }\n\n    function declarations_only(node) {\n        return all(node.definitions, function(var_def) {\n            return !var_def.value;\n        });\n    }\n\n    function is_declaration(stat, lexical) {\n        if (stat instanceof AST_DefClass) return lexical && !stat.extends && all(stat.properties, function(prop) {\n            if (prop.key instanceof AST_Node) return false;\n            return !is_static_field_or_init(prop);\n        });\n        if (stat instanceof AST_Definitions) return (lexical || stat instanceof AST_Var) && declarations_only(stat);\n        if (stat instanceof AST_ExportDeclaration) return is_declaration(stat.body, lexical);\n        if (stat instanceof AST_ExportDefault) return is_declaration(stat.body, lexical);\n        return stat instanceof AST_LambdaDefinition;\n    }\n\n    function is_last_statement(body, stat) {\n        var index = body.lastIndexOf(stat);\n        if (index < 0) return false;\n        while (++index < body.length) {\n            if (!is_declaration(body[index], true)) return false;\n        }\n        return true;\n    }\n\n    // Certain combination of unused name + side effect leads to invalid AST:\n    //    https://github.com/mishoo/UglifyJS/issues/44\n    //    https://github.com/mishoo/UglifyJS/issues/1838\n    //    https://github.com/mishoo/UglifyJS/issues/3371\n    // We fix it at this stage by moving the `var` outside the `for`.\n    function patch_for_init(node, in_list) {\n        var block;\n        if (node.init instanceof AST_BlockStatement) {\n            block = node.init;\n            node.init = block.body.pop();\n            block.body.push(node);\n        }\n        if (node.init instanceof AST_Defun) {\n            if (!block) block = make_node(AST_BlockStatement, node, { body: [ node ] });\n            block.body.splice(-1, 0, node.init);\n            node.init = null;\n        } else if (node.init instanceof AST_SimpleStatement) {\n            node.init = node.init.body;\n        } else if (is_empty(node.init)) {\n            node.init = null;\n        }\n        if (!block) return;\n        return in_list ? List.splice(block.body) : block;\n    }\n\n    function tighten_body(statements, compressor) {\n        var in_lambda = last_of(compressor, function(node) {\n            return node instanceof AST_Lambda;\n        });\n        var block_scope, iife_in_try, in_iife_single, in_loop, in_try, scope;\n        find_loop_scope_try();\n        var changed, last_changed, max_iter = 10;\n        do {\n            last_changed = changed;\n            changed = 0;\n            if (eliminate_spurious_blocks(statements)) changed = 1;\n            if (!changed && last_changed == 1) break;\n            if (compressor.option("dead_code")) {\n                if (eliminate_dead_code(statements, compressor)) changed = 2;\n                if (!changed && last_changed == 2) break;\n            }\n            if (compressor.option("if_return")) {\n                if (handle_if_return(statements, compressor)) changed = 3;\n                if (!changed && last_changed == 3) break;\n            }\n            if (compressor.option("awaits") && compressor.option("side_effects")) {\n                if (trim_awaits(statements, compressor)) changed = 4;\n                if (!changed && last_changed == 4) break;\n            }\n            if (compressor.option("inline") >= 4) {\n                if (inline_iife(statements, compressor)) changed = 5;\n                if (!changed && last_changed == 5) break;\n            }\n            if (compressor.sequences_limit > 0) {\n                if (sequencesize(statements, compressor)) changed = 6;\n                if (!changed && last_changed == 6) break;\n                if (sequencesize_2(statements, compressor)) changed = 7;\n                if (!changed && last_changed == 7) break;\n            }\n            if (compressor.option("join_vars")) {\n                if (join_consecutive_vars(statements)) changed = 8;\n                if (!changed && last_changed == 8) break;\n            }\n            if (compressor.option("collapse_vars")) {\n                if (collapse(statements, compressor)) changed = 9;\n            }\n        } while (changed && max_iter-- > 0);\n        return statements;\n\n        function last_of(compressor, predicate) {\n            var block = compressor.self(), level = 0, stat;\n            do {\n                if (block instanceof AST_Catch) {\n                    block = compressor.parent(level++);\n                } else if (block instanceof AST_LabeledStatement) {\n                    block = block.body;\n                } else if (block instanceof AST_SwitchBranch) {\n                    var branches = compressor.parent(level);\n                    if (branches.body[branches.body.length - 1] === block || has_break(block.body)) {\n                        level++;\n                        block = branches;\n                    }\n                }\n                do {\n                    stat = block;\n                    if (predicate(stat)) return stat;\n                    block = compressor.parent(level++);\n                } while (block instanceof AST_If);\n            } while (stat\n                && (block instanceof AST_BlockStatement\n                    || block instanceof AST_Catch\n                    || block instanceof AST_Scope\n                    || block instanceof AST_SwitchBranch\n                    || block instanceof AST_Try)\n                && is_last_statement(block.body, stat));\n\n            function has_break(stats) {\n                for (var i = stats.length; --i >= 0;) {\n                    if (stats[i] instanceof AST_Break) return true;\n                }\n                return false;\n            }\n        }\n\n        function find_loop_scope_try() {\n            var node = compressor.self(), level = 0;\n            do {\n                if (!block_scope && node.variables) block_scope = node;\n                if (node instanceof AST_Catch) {\n                    if (compressor.parent(level).bfinally) {\n                        if (!in_try) in_try = {};\n                        in_try.bfinally = true;\n                    }\n                    level++;\n                } else if (node instanceof AST_Finally) {\n                    level++;\n                } else if (node instanceof AST_IterationStatement) {\n                    in_loop = true;\n                } else if (node instanceof AST_Scope) {\n                    scope = node;\n                    break;\n                } else if (node instanceof AST_Try) {\n                    if (!in_try) in_try = {};\n                    if (node.bcatch) in_try.bcatch = true;\n                    if (node.bfinally) in_try.bfinally = true;\n                }\n            } while (node = compressor.parent(level++));\n        }\n\n        // Search from right to left for assignment-like expressions:\n        // - `var a = x;`\n        // - `a = x;`\n        // - `++a`\n        // For each candidate, scan from left to right for first usage, then try\n        // to fold assignment into the site for compression.\n        // Will not attempt to collapse assignments into or past code blocks\n        // which are not sequentially executed, e.g. loops and conditionals.\n        function collapse(statements, compressor) {\n            if (scope.pinned()) return;\n            var args;\n            var assignments = new Dictionary();\n            var candidates = [];\n            var changed = false;\n            var declare_only = new Dictionary();\n            var force_single;\n            var stat_index = statements.length;\n            var scanner = new TreeTransformer(function(node, descend) {\n                if (abort) return node;\n                // Skip nodes before `candidate` as quickly as possible\n                if (!hit) {\n                    if (node !== hit_stack[hit_index]) return node;\n                    hit_index++;\n                    if (hit_index < hit_stack.length) return handle_custom_scan_order(node, scanner);\n                    hit = true;\n                    stop_after = (value_def ? find_stop_value : find_stop)(node, 0);\n                    if (stop_after === node) abort = true;\n                    return node;\n                }\n                var parent = scanner.parent();\n                // Stop only if candidate is found within conditional branches\n                if (!stop_if_hit && in_conditional(node, parent)) {\n                    stop_if_hit = parent;\n                }\n                // Cascade compound assignments\n                if (compound && scan_lhs && can_replace && !stop_if_hit\n                    && node instanceof AST_Assign && node.operator != "=" && node.left.equals(lhs)) {\n                    replaced++;\n                    changed = true;\n                    AST_Node.info("Cascading {this} [{start}]", node);\n                    can_replace = false;\n                    lvalues = get_lvalues(lhs);\n                    node.right.transform(scanner);\n                    clear_write_only(candidate);\n                    var folded;\n                    if (abort) {\n                        folded = candidate;\n                    } else {\n                        abort = true;\n                        folded = make_node(AST_Binary, candidate, {\n                            operator: compound,\n                            left: lhs.fixed && lhs.definition().fixed ? lhs.fixed.to_binary(candidate) : lhs,\n                            right: rvalue,\n                        });\n                    }\n                    return make_node(AST_Assign, node, {\n                        operator: "=",\n                        left: node.left,\n                        right: make_node(AST_Binary, node, {\n                            operator: node.operator.slice(0, -1),\n                            left: folded,\n                            right: node.right,\n                        }),\n                    });\n                }\n                // Stop immediately if these node types are encountered\n                if (should_stop(node, parent)) {\n                    abort = true;\n                    return node;\n                }\n                // Skip transient nodes caused by single-use variable replacement\n                if (node.single_use) return node;\n                // Replace variable with assignment when found\n                var hit_rhs;\n                if (!(node instanceof AST_SymbolDeclaration)\n                    && (scan_lhs && lhs.equals(node)\n                        || scan_rhs && (hit_rhs = scan_rhs(node, this)))) {\n                    if (!can_replace || stop_if_hit && (hit_rhs || !lhs_local || !replace_all)) {\n                        if (!hit_rhs && !value_def) abort = true;\n                        return node;\n                    }\n                    if (is_lhs(node, parent)) {\n                        if (value_def && !hit_rhs) assign_used = true;\n                        return node;\n                    }\n                    if (!hit_rhs && verify_ref && node.fixed !== lhs.fixed) {\n                        abort = true;\n                        return node;\n                    }\n                    if (value_def) {\n                        if (stop_if_hit && assign_pos == 0) assign_pos = remaining - replaced;\n                        if (!hit_rhs) replaced++;\n                        return node;\n                    }\n                    replaced++;\n                    changed = abort = true;\n                    AST_Node.info("Collapsing {this} [{start}]", node);\n                    if (candidate.TYPE == "Binary") {\n                        update_symbols(candidate, node);\n                        return make_node(AST_Assign, candidate, {\n                            operator: "=",\n                            left: candidate.right.left,\n                            right: candidate.operator == "&&" ? make_node(AST_Conditional, candidate, {\n                                condition: candidate.left,\n                                consequent: candidate.right.right,\n                                alternative: node,\n                            }) : make_node(AST_Conditional, candidate, {\n                                condition: candidate.left,\n                                consequent: node,\n                                alternative: candidate.right.right,\n                            }),\n                        });\n                    }\n                    if (candidate instanceof AST_UnaryPostfix) return make_node(AST_UnaryPrefix, candidate, {\n                        operator: candidate.operator,\n                        expression: lhs.fixed && lhs.definition().fixed ? lhs.fixed.to_prefix(candidate) : lhs,\n                    });\n                    if (candidate instanceof AST_UnaryPrefix) {\n                        clear_write_only(candidate);\n                        return candidate;\n                    }\n                    update_symbols(rvalue, node);\n                    if (candidate instanceof AST_VarDef) {\n                        var def = candidate.name.definition();\n                        if (def.references.length - def.replaced == 1 && !compressor.exposed(def)) {\n                            def.replaced++;\n                            return maintain_this_binding(parent, node, rvalue);\n                        }\n                        return make_node(AST_Assign, candidate, {\n                            operator: "=",\n                            left: node,\n                            right: rvalue,\n                        });\n                    }\n                    clear_write_only(rvalue);\n                    var assign = candidate.clone();\n                    assign.right = rvalue;\n                    return assign;\n                }\n                // Stop signals related to AST_SymbolRef\n                if (should_stop_ref(node, parent)) {\n                    abort = true;\n                    return node;\n                }\n                // These node types have child nodes that execute sequentially,\n                // but are otherwise not safe to scan into or beyond them.\n                if (is_last_node(node, parent) || may_throw(node)) {\n                    stop_after = node;\n                    if (node instanceof AST_Scope) abort = true;\n                }\n                // Scan but don\'t replace inside getter/setter\n                if (node instanceof AST_Accessor) {\n                    var replace = can_replace;\n                    can_replace = false;\n                    descend(node, scanner);\n                    can_replace = replace;\n                    return signal_abort(node);\n                }\n                // Scan but don\'t replace inside destructuring expression\n                if (node instanceof AST_Destructured) {\n                    var replace = can_replace;\n                    can_replace = false;\n                    descend(node, scanner);\n                    can_replace = replace;\n                    return signal_abort(node);\n                }\n                // Scan but don\'t replace inside default value\n                if (node instanceof AST_DefaultValue) {\n                    node.name = node.name.transform(scanner);\n                    var replace = can_replace;\n                    can_replace = false;\n                    node.value = node.value.transform(scanner);\n                    can_replace = replace;\n                    return signal_abort(node);\n                }\n                // Scan but don\'t replace inside block scope with colliding variable\n                if (node instanceof AST_BlockScope\n                    && !(node instanceof AST_Scope)\n                    && !(node.variables && node.variables.all(function(def) {\n                        return !enclosed.has(def.name) && !lvalues.has(def.name);\n                    }))) {\n                    var replace = can_replace;\n                    can_replace = false;\n                    if (!handle_custom_scan_order(node, scanner)) descend(node, scanner);\n                    can_replace = replace;\n                    return signal_abort(node);\n                }\n                if (handle_custom_scan_order(node, scanner)) return signal_abort(node);\n            }, signal_abort);\n            var multi_replacer = new TreeTransformer(function(node) {\n                if (abort) return node;\n                // Skip nodes before `candidate` as quickly as possible\n                if (!hit) {\n                    if (node !== hit_stack[hit_index]) return node;\n                    hit_index++;\n                    switch (hit_stack.length - hit_index) {\n                      case 0:\n                        hit = true;\n                        if (assign_used) return node;\n                        if (node !== candidate) return node;\n                        if (node instanceof AST_VarDef) return node;\n                        def.replaced++;\n                        var parent = multi_replacer.parent();\n                        if (parent instanceof AST_Sequence && parent.tail_node() !== node) {\n                            value_def.replaced++;\n                            if (rvalue === rhs_value) return List.skip;\n                            return make_sequence(rhs_value, rhs_value.expressions.slice(0, -1));\n                        }\n                        return rvalue;\n                      case 1:\n                        if (!assign_used && node.body === candidate) {\n                            hit = true;\n                            def.replaced++;\n                            value_def.replaced++;\n                            return null;\n                        }\n                      default:\n                        return handle_custom_scan_order(node, multi_replacer);\n                    }\n                }\n                // Replace variable when found\n                if (node instanceof AST_SymbolRef && node.definition() === def) {\n                    if (is_lhs(node, multi_replacer.parent())) return node;\n                    if (!--replaced) abort = true;\n                    AST_Node.info("Replacing {this} [{start}]", node);\n                    var ref = rvalue.clone();\n                    ref.scope = node.scope;\n                    ref.reference();\n                    if (replaced == assign_pos) {\n                        abort = true;\n                        return make_node(AST_Assign, candidate, {\n                            operator: "=",\n                            left: node,\n                            right: ref,\n                        });\n                    }\n                    def.replaced++;\n                    return ref;\n                }\n                // Skip (non-executed) functions and (leading) default case in switch statements\n                if (node instanceof AST_Default || node instanceof AST_Scope) return node;\n            }, function(node) {\n                return patch_sequence(node, multi_replacer);\n            });\n            while (--stat_index >= 0) {\n                // Treat parameters as collapsible in IIFE, i.e.\n                //   function(a, b){ ... }(x());\n                // would be translated into equivalent assignments:\n                //   var a = x(), b = undefined;\n                if (stat_index == 0 && compressor.option("unused")) extract_args();\n                // Find collapsible assignments\n                var hit_stack = [];\n                extract_candidates(statements[stat_index]);\n                while (candidates.length > 0) {\n                    hit_stack = candidates.pop();\n                    var hit_index = 0;\n                    var candidate = hit_stack[hit_stack.length - 1];\n                    var assign_pos = -1;\n                    var assign_used = false;\n                    var verify_ref = false;\n                    var remaining;\n                    var value_def = null;\n                    var stop_after = null;\n                    var stop_if_hit = null;\n                    var lhs = get_lhs(candidate);\n                    var side_effects = lhs && lhs.has_side_effects(compressor);\n                    var scan_lhs = lhs && (!side_effects || lhs instanceof AST_SymbolRef)\n                            && !is_lhs_read_only(lhs, compressor);\n                    var scan_rhs = foldable(candidate);\n                    if (!scan_lhs && !scan_rhs) continue;\n                    var compound = candidate instanceof AST_Assign && candidate.operator.slice(0, -1);\n                    var funarg = candidate.name instanceof AST_SymbolFunarg;\n                    var may_throw = return_false;\n                    if (candidate.may_throw(compressor)) {\n                        if (funarg && is_async(scope)) continue;\n                        may_throw = in_try ? function(node) {\n                            return node.has_side_effects(compressor);\n                        } : side_effects_external;\n                    }\n                    var read_toplevel = false;\n                    var modify_toplevel = false;\n                    var defun_scopes = get_defun_scopes(lhs);\n                    // Locate symbols which may execute code outside of scanning range\n                    var enclosed = new Dictionary();\n                    var well_defined = true;\n                    var lvalues = get_lvalues(candidate);\n                    var lhs_local = is_lhs_local(lhs);\n                    var rhs_value = get_rvalue(candidate);\n                    var rvalue = rhs_value;\n                    if (!side_effects) {\n                        if (!compound && rvalue instanceof AST_Sequence) rvalue = rvalue.tail_node();\n                        side_effects = value_has_side_effects();\n                    }\n                    var check_destructured = in_try || !lhs_local ? function(node) {\n                        return node instanceof AST_Destructured;\n                    } : return_false;\n                    var replace_all = replace_all_symbols(candidate);\n                    var hit = funarg;\n                    var abort = false;\n                    var replaced = 0;\n                    var can_replace = !args || !hit;\n                    if (!can_replace) {\n                        for (var j = candidate.arg_index + 1; !abort && j < args.length; j++) {\n                            if (args[j]) args[j].transform(scanner);\n                        }\n                        can_replace = true;\n                    }\n                    for (var i = stat_index; !abort && i < statements.length; i++) {\n                        statements[i].transform(scanner);\n                    }\n                    if (value_def) {\n                        if (!replaced || remaining > replaced + assign_used) {\n                            candidates.push(hit_stack);\n                            force_single = true;\n                            continue;\n                        }\n                        if (replaced == assign_pos) assign_used = true;\n                        var def = lhs.definition();\n                        abort = false;\n                        hit_index = 0;\n                        hit = funarg;\n                        for (var i = stat_index; !abort && i < statements.length; i++) {\n                            if (!statements[i].transform(multi_replacer)) statements.splice(i--, 1);\n                        }\n                        replaced = candidate instanceof AST_VarDef\n                            && candidate === hit_stack[hit_stack.length - 1]\n                            && def.references.length == def.replaced\n                            && !compressor.exposed(def);\n                        value_def.last_ref = false;\n                        value_def.single_use = false;\n                        changed = true;\n                    }\n                    if (replaced) remove_candidate(candidate);\n                }\n            }\n            return changed;\n\n            function signal_abort(node) {\n                if (abort) return node;\n                if (stop_after === node) abort = true;\n                if (stop_if_hit === node) stop_if_hit = null;\n                return node;\n            }\n\n            function handle_custom_scan_order(node, tt) {\n                if (!(node instanceof AST_BlockScope)) return;\n                // Skip (non-executed) functions\n                if (node instanceof AST_Scope) return node;\n                // Scan computed keys, static fields & initializers in class\n                if (node instanceof AST_Class) {\n                    var replace = can_replace;\n                    can_replace = false;\n                    if (node.name) node.name.transform(tt);\n                    if (!abort && node.extends) node.extends.transform(tt);\n                    var fields = [], stats = [];\n                    for (var i = 0; !abort && i < node.properties.length; i++) {\n                        var prop = node.properties[i];\n                        if (prop.key instanceof AST_Node) prop.key = prop.key.transform(tt);\n                        if (!prop.static) continue;\n                        if (prop instanceof AST_ClassField) {\n                            if (prop.value) fields.push(prop);\n                        } else if (prop instanceof AST_ClassInit) {\n                            [].push.apply(stats, prop.value.body);\n                        }\n                    }\n                    for (var i = 0; !abort && i < stats.length; i++) {\n                        stats[i].transform(tt);\n                    }\n                    for (var i = 0; !abort && i < fields.length; i++) {\n                        fields[i].value.transform(tt);\n                    }\n                    can_replace = replace;\n                    return node;\n                }\n                // Scan object only in a for-in/of statement\n                if (node instanceof AST_ForEnumeration) {\n                    node.object = node.object.transform(tt);\n                    abort = true;\n                    return node;\n                }\n                // Scan first case expression only in a switch statement\n                if (node instanceof AST_Switch) {\n                    node.expression = node.expression.transform(tt);\n                    for (var i = 0; !abort && i < node.body.length; i++) {\n                        var branch = node.body[i];\n                        if (branch instanceof AST_Case) {\n                            if (!hit) {\n                                if (branch !== hit_stack[hit_index]) continue;\n                                hit_index++;\n                            }\n                            branch.expression = branch.expression.transform(tt);\n                            if (!replace_all || verify_ref) break;\n                            scan_rhs = false;\n                        }\n                    }\n                    abort = true;\n                    return node;\n                }\n            }\n\n            function is_direct_assignment(node, parent) {\n                if (parent instanceof AST_Assign) return parent.operator == "=" && parent.left === node;\n                if (parent instanceof AST_DefaultValue) return parent.name === node;\n                if (parent instanceof AST_DestructuredArray) return true;\n                if (parent instanceof AST_DestructuredKeyVal) return parent.value === node;\n            }\n\n            function should_stop(node, parent) {\n                if (node === rvalue) return true;\n                if (parent instanceof AST_For) {\n                    if (node !== parent.init) return true;\n                }\n                if (node instanceof AST_Assign) return node.operator != "=" && lhs.equals(node.left);\n                if (node instanceof AST_BlockStatement) {\n                    return defun_scopes && !all(defun_scopes, function(scope) {\n                        return node !== scope;\n                    });\n                }\n                if (node instanceof AST_Call) {\n                    if (!(lhs instanceof AST_PropAccess)) return false;\n                    if (!lhs.equals(node.expression)) return false;\n                    return !(rvalue instanceof AST_LambdaExpression && !rvalue.contains_this());\n                }\n                if (node instanceof AST_Class) return !compressor.has_directive("use strict");\n                if (node instanceof AST_Debugger) return true;\n                if (node instanceof AST_Defun) return funarg && lhs.name === node.name.name;\n                if (node instanceof AST_DestructuredKeyVal) return node.key instanceof AST_Node;\n                if (node instanceof AST_DWLoop) return true;\n                if (node instanceof AST_LoopControl) return true;\n                if (node instanceof AST_Try) return true;\n                if (node instanceof AST_With) return true;\n                return false;\n            }\n\n            function should_stop_ref(node, parent) {\n                if (!(node instanceof AST_SymbolRef)) return false;\n                if (node.is_declared(compressor)) {\n                    if (node.fixed_value()) return false;\n                    if (can_drop_symbol(node)) {\n                        return !(parent instanceof AST_PropAccess && parent.expression === node)\n                            && is_arguments(node.definition());\n                    }\n                } else if (is_direct_assignment(node, parent)) {\n                    return false;\n                }\n                if (!replace_all) return true;\n                scan_rhs = false;\n                return false;\n            }\n\n            function in_conditional(node, parent) {\n                if (parent instanceof AST_Assign) return parent.left !== node && lazy_op[parent.operator.slice(0, -1)];\n                if (parent instanceof AST_Binary) return parent.left !== node && lazy_op[parent.operator];\n                if (parent instanceof AST_Call) return parent.optional && parent.expression !== node;\n                if (parent instanceof AST_Case) return parent.expression !== node;\n                if (parent instanceof AST_Conditional) return parent.condition !== node;\n                if (parent instanceof AST_If) return parent.condition !== node;\n                if (parent instanceof AST_Sub) return parent.optional && parent.expression !== node;\n            }\n\n            function is_last_node(node, parent) {\n                if (node instanceof AST_Await) return true;\n                if (node.TYPE == "Binary") return !can_drop_op(node, compressor);\n                if (node instanceof AST_Call) {\n                    var def, fn = node.expression;\n                    if (fn instanceof AST_SymbolRef) {\n                        def = fn.definition();\n                        fn = fn.fixed_value();\n                    }\n                    if (!(fn instanceof AST_Lambda)) return !node.is_expr_pure(compressor);\n                    if (def && recursive_ref(compressor, def, fn)) return true;\n                    if (fn.collapse_scanning) return false;\n                    fn.collapse_scanning = true;\n                    var replace = can_replace;\n                    can_replace = false;\n                    var after = stop_after;\n                    var if_hit = stop_if_hit;\n                    for (var i = 0; !abort && i < fn.argnames.length; i++) {\n                        if (arg_may_throw(reject, fn.argnames[i], node.args[i])) abort = true;\n                    }\n                    if (!abort) {\n                        if (fn.rest && arg_may_throw(reject, fn.rest, make_node(AST_Array, node, {\n                            elements: node.args.slice(i),\n                        }))) {\n                            abort = true;\n                        } else if (is_arrow(fn) && fn.value) {\n                            fn.value.transform(scanner);\n                        } else for (var i = 0; !abort && i < fn.body.length; i++) {\n                            var stat = fn.body[i];\n                            if (stat instanceof AST_Return) {\n                                if (stat.value) stat.value.transform(scanner);\n                                break;\n                            }\n                            stat.transform(scanner);\n                        }\n                    }\n                    stop_if_hit = if_hit;\n                    stop_after = after;\n                    can_replace = replace;\n                    fn.collapse_scanning = false;\n                    if (!abort) return false;\n                    abort = false;\n                    return true;\n                }\n                if (node instanceof AST_Class) {\n                    if (!in_try) return false;\n                    var base = node.extends;\n                    if (!base) return false;\n                    if (base instanceof AST_SymbolRef) base = base.fixed_value();\n                    return !safe_for_extends(base);\n                }\n                if (node instanceof AST_Exit) {\n                    if (in_try) {\n                        if (in_try.bfinally) return true;\n                        if (in_try.bcatch && node instanceof AST_Throw) return true;\n                    }\n                    return side_effects || lhs instanceof AST_PropAccess || may_modify(lhs);\n                }\n                if (node instanceof AST_Function) {\n                    return compressor.option("ie") && node.name && lvalues.has(node.name.name);\n                }\n                if (node instanceof AST_ObjectIdentity) return symbol_in_lvalues(node);\n                if (node instanceof AST_PropAccess) {\n                    var exp = node.expression;\n                    if (compressor.option("unsafe")) {\n                        if (is_undeclared_ref(exp) && global_names[exp.name]) return false;\n                        if (is_static_fn(exp)) return false;\n                    }\n                    if (exp instanceof AST_SymbolRef && is_arguments(exp.definition())) return true;\n                    if (side_effects) return true;\n                    if (!well_defined) return true;\n                    if (value_def) return false;\n                    if (!in_try && lhs_local) return false;\n                    if (node.optional) return false;\n                    return exp.may_throw_on_access(compressor);\n                }\n                if (node instanceof AST_Spread) return true;\n                if (node instanceof AST_SymbolRef) {\n                    var assign_direct = symbol_in_lvalues(node);\n                    if (is_undeclared_ref(node) && node.is_declared(compressor)) return false;\n                    if (assign_direct) return !is_direct_assignment(node, parent);\n                    if (side_effects && may_modify(node)) return true;\n                    var def = node.definition();\n                    return (in_try || def.scope.resolve() !== scope) && !can_drop_symbol(node);\n                }\n                if (node instanceof AST_Template) return !node.is_expr_pure(compressor);\n                if (node instanceof AST_VarDef) {\n                    if (check_destructured(node.name)) return true;\n                    return (node.value || parent instanceof AST_Let) && node.name.match_symbol(function(node) {\n                        return node instanceof AST_SymbolDeclaration\n                            && (lvalues.has(node.name) || side_effects && may_modify(node));\n                    }, true);\n                }\n                if (node instanceof AST_Yield) return true;\n                var sym = is_lhs(node.left, node);\n                if (!sym) return false;\n                if (sym instanceof AST_PropAccess) return true;\n                if (check_destructured(sym)) return true;\n                return sym.match_symbol(function(node) {\n                    if (node instanceof AST_PropAccess) return true;\n                    if (node instanceof AST_SymbolRef) {\n                        return lvalues.has(node.name) || read_toplevel && compressor.exposed(node.definition());\n                    }\n                }, true);\n\n                function reject(node) {\n                    node.transform(scanner);\n                    return abort;\n                }\n            }\n\n            function arg_may_throw(reject, node, value) {\n                if (node instanceof AST_DefaultValue) {\n                    return reject(node.value)\n                        || arg_may_throw(reject, node.name, node.value)\n                        || !is_undefined(value) && arg_may_throw(reject, node.name, value);\n                }\n                if (!value) return !(node instanceof AST_Symbol);\n                if (node instanceof AST_Destructured) {\n                    if (node.rest && arg_may_throw(reject, node.rest)) return true;\n                    if (node instanceof AST_DestructuredArray) {\n                        if (value instanceof AST_Array) return !all(node.elements, function(element, index) {\n                            return !arg_may_throw(reject, element, value[index]);\n                        });\n                        if (!value.is_string(compressor)) return true;\n                        return !all(node.elements, function(element) {\n                            return !arg_may_throw(reject, element);\n                        });\n                    }\n                    if (node instanceof AST_DestructuredObject) {\n                        if (value.may_throw_on_access(compressor)) return true;\n                        return !all(node.properties, function(prop) {\n                            if (prop.key instanceof AST_Node && reject(prop.key)) return false;\n                            return !arg_may_throw(reject, prop.value);\n                        });\n                    }\n                }\n            }\n\n            function extract_args() {\n                if (in_iife_single === false) return;\n                var iife = compressor.parent(), fn = compressor.self();\n                if (in_iife_single === undefined) {\n                    if (!(fn instanceof AST_LambdaExpression)\n                        || is_generator(fn)\n                        || fn.uses_arguments\n                        || fn.pinned()\n                        || !(iife instanceof AST_Call)\n                        || iife.expression !== fn\n                        || !all(iife.args, function(arg) {\n                            return !(arg instanceof AST_Spread);\n                        })) {\n                        in_iife_single = false;\n                        return;\n                    }\n                    if (!is_iife_single(iife)) return;\n                    in_iife_single = true;\n                }\n                var fn_strict = fn.in_strict_mode(compressor)\n                    && !fn.parent_scope.resolve(true).in_strict_mode(compressor);\n                var has_await;\n                if (is_async(fn)) {\n                    has_await = function(node) {\n                        return node instanceof AST_Symbol && node.name == "await";\n                    };\n                    iife_in_try = true;\n                } else {\n                    has_await = function(node) {\n                        return node instanceof AST_Await && !tw.find_parent(AST_Scope);\n                    };\n                    if (iife_in_try === undefined) iife_in_try = find_try(compressor, 1, iife, null, true, true);\n                }\n                var arg_scope = null;\n                var tw = new TreeWalker(function(node, descend) {\n                    if (!arg) return true;\n                    if (has_await(node) || node instanceof AST_Yield) {\n                        arg = null;\n                        return true;\n                    }\n                    if (node instanceof AST_ObjectIdentity) {\n                        if (fn_strict || !arg_scope) arg = null;\n                        return true;\n                    }\n                    if (node instanceof AST_SymbolRef) {\n                        var def;\n                        if (node.in_arg && !is_safe_lexical(node.definition())\n                            || (def = fn.variables.get(node.name)) && def !== node.definition()) {\n                            arg = null;\n                        }\n                        return true;\n                    }\n                    if (node instanceof AST_Scope && !is_arrow(node)) {\n                        var save_scope = arg_scope;\n                        arg_scope = node;\n                        descend();\n                        arg_scope = save_scope;\n                        return true;\n                    }\n                });\n                args = iife.args.slice();\n                var len = args.length;\n                var names = new Dictionary();\n                for (var i = fn.argnames.length; --i >= 0;) {\n                    var sym = fn.argnames[i];\n                    var arg = args[i];\n                    var value = null;\n                    if (sym instanceof AST_DefaultValue) {\n                        value = sym.value;\n                        sym = sym.name;\n                        args[len + i] = value;\n                    }\n                    if (sym instanceof AST_Destructured) {\n                        if (iife_in_try && arg_may_throw(function(node) {\n                            return node.has_side_effects(compressor);\n                        }, sym, arg)) {\n                            candidates.length = 0;\n                            break;\n                        }\n                        args[len + i] = fn.argnames[i];\n                        continue;\n                    }\n                    if (names.has(sym.name)) continue;\n                    names.set(sym.name, true);\n                    if (value) arg = is_undefined(arg) ? value : null;\n                    if (!arg && !value) {\n                        arg = make_node(AST_Undefined, sym).transform(compressor);\n                    } else if (arg instanceof AST_Lambda && arg.pinned()) {\n                        arg = null;\n                    } else if (arg) {\n                        arg.walk(tw);\n                    }\n                    if (!arg) continue;\n                    var candidate = make_node(AST_VarDef, sym, {\n                        name: sym,\n                        value: arg,\n                    });\n                    candidate.name_index = i;\n                    candidate.arg_index = value ? len + i : i;\n                    candidates.unshift([ candidate ]);\n                }\n                if (fn.rest) args.push(fn.rest);\n            }\n\n            function extract_candidates(expr, unused) {\n                hit_stack.push(expr);\n                if (expr instanceof AST_Array) {\n                    expr.elements.forEach(function(node) {\n                        extract_candidates(node, unused);\n                    });\n                } else if (expr instanceof AST_Assign) {\n                    var lhs = expr.left;\n                    if (!(lhs instanceof AST_Destructured)) candidates.push(hit_stack.slice());\n                    extract_candidates(lhs);\n                    extract_candidates(expr.right);\n                    if (lhs instanceof AST_SymbolRef && expr.operator == "=") {\n                        assignments.set(lhs.name, (assignments.get(lhs.name) || 0) + 1);\n                    }\n                } else if (expr instanceof AST_Await) {\n                    extract_candidates(expr.expression, unused);\n                } else if (expr instanceof AST_Binary) {\n                    var lazy = lazy_op[expr.operator];\n                    if (unused\n                        && lazy\n                        && expr.operator != "??"\n                        && expr.right instanceof AST_Assign\n                        && expr.right.operator == "="\n                        && !(expr.right.left instanceof AST_Destructured)) {\n                        candidates.push(hit_stack.slice());\n                    }\n                    extract_candidates(expr.left, !lazy && unused);\n                    extract_candidates(expr.right, unused);\n                } else if (expr instanceof AST_Call) {\n                    extract_candidates(expr.expression);\n                    expr.args.forEach(extract_candidates);\n                } else if (expr instanceof AST_Case) {\n                    extract_candidates(expr.expression);\n                } else if (expr instanceof AST_Conditional) {\n                    extract_candidates(expr.condition);\n                    extract_candidates(expr.consequent, unused);\n                    extract_candidates(expr.alternative, unused);\n                } else if (expr instanceof AST_Definitions) {\n                    expr.definitions.forEach(extract_candidates);\n                } else if (expr instanceof AST_Dot) {\n                    extract_candidates(expr.expression);\n                } else if (expr instanceof AST_DWLoop) {\n                    extract_candidates(expr.condition);\n                    if (!(expr.body instanceof AST_Block)) {\n                        extract_candidates(expr.body);\n                    }\n                } else if (expr instanceof AST_Exit) {\n                    if (expr.value) extract_candidates(expr.value);\n                } else if (expr instanceof AST_For) {\n                    if (expr.init) extract_candidates(expr.init, true);\n                    if (expr.condition) extract_candidates(expr.condition);\n                    if (expr.step) extract_candidates(expr.step, true);\n                    if (!(expr.body instanceof AST_Block)) {\n                        extract_candidates(expr.body);\n                    }\n                } else if (expr instanceof AST_ForEnumeration) {\n                    extract_candidates(expr.object);\n                    if (!(expr.body instanceof AST_Block)) {\n                        extract_candidates(expr.body);\n                    }\n                } else if (expr instanceof AST_If) {\n                    extract_candidates(expr.condition);\n                    if (!(expr.body instanceof AST_Block)) {\n                        extract_candidates(expr.body);\n                    }\n                    if (expr.alternative && !(expr.alternative instanceof AST_Block)) {\n                        extract_candidates(expr.alternative);\n                    }\n                } else if (expr instanceof AST_Object) {\n                    expr.properties.forEach(function(prop) {\n                        hit_stack.push(prop);\n                        if (prop.key instanceof AST_Node) extract_candidates(prop.key);\n                        if (prop instanceof AST_ObjectKeyVal) extract_candidates(prop.value, unused);\n                        hit_stack.pop();\n                    });\n                } else if (expr instanceof AST_Sequence) {\n                    var end = expr.expressions.length - (unused ? 0 : 1);\n                    expr.expressions.forEach(function(node, index) {\n                        extract_candidates(node, index < end);\n                    });\n                } else if (expr instanceof AST_SimpleStatement) {\n                    extract_candidates(expr.body, true);\n                } else if (expr instanceof AST_Spread) {\n                    extract_candidates(expr.expression);\n                } else if (expr instanceof AST_Sub) {\n                    extract_candidates(expr.expression);\n                    extract_candidates(expr.property);\n                } else if (expr instanceof AST_Switch) {\n                    extract_candidates(expr.expression);\n                    expr.body.forEach(extract_candidates);\n                } else if (expr instanceof AST_Unary) {\n                    if (UNARY_POSTFIX[expr.operator]) {\n                        candidates.push(hit_stack.slice());\n                    } else {\n                        extract_candidates(expr.expression);\n                    }\n                } else if (expr instanceof AST_VarDef) {\n                    if (expr.name instanceof AST_SymbolVar) {\n                        if (expr.value) {\n                            var def = expr.name.definition();\n                            if (def.references.length > def.replaced) {\n                                candidates.push(hit_stack.slice());\n                            }\n                        } else {\n                            declare_only.set(expr.name.name, (declare_only.get(expr.name.name) || 0) + 1);\n                        }\n                    }\n                    if (expr.value) extract_candidates(expr.value);\n                } else if (expr instanceof AST_Yield) {\n                    if (expr.expression) extract_candidates(expr.expression);\n                }\n                hit_stack.pop();\n            }\n\n            function find_stop(node, level) {\n                var parent = scanner.parent(level);\n                if (parent instanceof AST_Array) return node;\n                if (parent instanceof AST_Assign) return node;\n                if (parent instanceof AST_Await) return node;\n                if (parent instanceof AST_Binary) return node;\n                if (parent instanceof AST_Call) return node;\n                if (parent instanceof AST_Case) return node;\n                if (parent instanceof AST_Conditional) return node;\n                if (parent instanceof AST_Definitions) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_Exit) return node;\n                if (parent instanceof AST_If) return node;\n                if (parent instanceof AST_IterationStatement) return node;\n                if (parent instanceof AST_ObjectProperty) return node;\n                if (parent instanceof AST_PropAccess) return node;\n                if (parent instanceof AST_Sequence) {\n                    return (parent.tail_node() === node ? find_stop : find_stop_unused)(parent, level + 1);\n                }\n                if (parent instanceof AST_SimpleStatement) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_Spread) return node;\n                if (parent instanceof AST_Switch) return node;\n                if (parent instanceof AST_Unary) return node;\n                if (parent instanceof AST_VarDef) return node;\n                if (parent instanceof AST_Yield) return node;\n                return null;\n            }\n\n            function find_stop_logical(parent, op, level) {\n                var node;\n                do {\n                    node = parent;\n                    parent = scanner.parent(++level);\n                } while (parent instanceof AST_Assign && parent.operator.slice(0, -1) == op\n                    || parent instanceof AST_Binary && parent.operator == op);\n                return node;\n            }\n\n            function find_stop_expr(expr, cont, node, parent, level) {\n                var replace = can_replace;\n                can_replace = false;\n                var after = stop_after;\n                var if_hit = stop_if_hit;\n                var stack = scanner.stack;\n                scanner.stack = [ parent ];\n                expr.transform(scanner);\n                scanner.stack = stack;\n                stop_if_hit = if_hit;\n                stop_after = after;\n                can_replace = replace;\n                if (abort) {\n                    abort = false;\n                    return node;\n                }\n                return cont(parent, level + 1);\n            }\n\n            function find_stop_value(node, level) {\n                var parent = scanner.parent(level);\n                if (parent instanceof AST_Array) return find_stop_value(parent, level + 1);\n                if (parent instanceof AST_Assign) {\n                    if (may_throw(parent)) return node;\n                    if (parent.left.match_symbol(function(ref) {\n                        return ref instanceof AST_SymbolRef && (lhs.name == ref.name || value_def.name == ref.name);\n                    })) return node;\n                    var op;\n                    if (parent.left === node || !lazy_op[op = parent.operator.slice(0, -1)]) {\n                        return find_stop_value(parent, level + 1);\n                    }\n                    return find_stop_logical(parent, op, level);\n                }\n                if (parent instanceof AST_Await) return find_stop_value(parent, level + 1);\n                if (parent instanceof AST_Binary) {\n                    var op;\n                    if (parent.left === node || !lazy_op[op = parent.operator]) {\n                        return find_stop_value(parent, level + 1);\n                    }\n                    return find_stop_logical(parent, op, level);\n                }\n                if (parent instanceof AST_Call) return parent;\n                if (parent instanceof AST_Case) {\n                    if (parent.expression !== node) return node;\n                    return find_stop_value(parent, level + 1);\n                }\n                if (parent instanceof AST_Conditional) {\n                    if (parent.condition !== node) return node;\n                    return find_stop_value(parent, level + 1);\n                }\n                if (parent instanceof AST_Definitions) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_Do) return node;\n                if (parent instanceof AST_Exit) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_For) {\n                    if (parent.init !== node && parent.condition !== node) return node;\n                    return find_stop_value(parent, level + 1);\n                }\n                if (parent instanceof AST_ForEnumeration) {\n                    if (parent.init !== node) return node;\n                    return find_stop_value(parent, level + 1);\n                }\n                if (parent instanceof AST_If) {\n                    if (parent.condition !== node) return node;\n                    return find_stop_value(parent, level + 1);\n                }\n                if (parent instanceof AST_ObjectProperty) {\n                    var obj = scanner.parent(level + 1);\n                    return all(obj.properties, function(prop) {\n                        return prop instanceof AST_ObjectKeyVal;\n                    }) ? find_stop_value(obj, level + 2) : obj;\n                }\n                if (parent instanceof AST_PropAccess) {\n                    var exp = parent.expression;\n                    return exp === node ? find_stop_value(parent, level + 1) : node;\n                }\n                if (parent instanceof AST_Sequence) {\n                    return (parent.tail_node() === node ? find_stop_value : find_stop_unused)(parent, level + 1);\n                }\n                if (parent instanceof AST_SimpleStatement) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_Spread) return find_stop_value(parent, level + 1);\n                if (parent instanceof AST_Switch) {\n                    if (parent.expression !== node) return node;\n                    return find_stop_value(parent, level + 1);\n                }\n                if (parent instanceof AST_Unary) {\n                    if (parent.operator == "delete") return node;\n                    return find_stop_value(parent, level + 1);\n                }\n                if (parent instanceof AST_VarDef) return parent.name.match_symbol(function(sym) {\n                    return sym instanceof AST_SymbolDeclaration && (lhs.name == sym.name || value_def.name == sym.name);\n                }) ? node : find_stop_value(parent, level + 1);\n                if (parent instanceof AST_While) {\n                    if (parent.condition !== node) return node;\n                    return find_stop_value(parent, level + 1);\n                }\n                if (parent instanceof AST_Yield) return find_stop_value(parent, level + 1);\n                return null;\n            }\n\n            function find_stop_unused(node, level) {\n                var parent = scanner.parent(level);\n                if (is_last_node(node, parent)) return node;\n                if (in_conditional(node, parent)) return node;\n                if (parent instanceof AST_Array) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_Assign) return check_assignment(parent.left);\n                if (parent instanceof AST_Await) return node;\n                if (parent instanceof AST_Binary) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_Call) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_Case) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_Conditional) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_Definitions) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_Exit) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_If) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_IterationStatement) return node;\n                if (parent instanceof AST_ObjectProperty) {\n                    var obj = scanner.parent(level + 1);\n                    return all(obj.properties, function(prop) {\n                        return prop instanceof AST_ObjectKeyVal;\n                    }) ? find_stop_unused(obj, level + 2) : obj;\n                }\n                if (parent instanceof AST_PropAccess) {\n                    var exp = parent.expression;\n                    if (exp === node) return find_stop_unused(parent, level + 1);\n                    return find_stop_expr(exp, find_stop_unused, node, parent, level);\n                }\n                if (parent instanceof AST_Sequence) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_SimpleStatement) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_Spread) return node;\n                if (parent instanceof AST_Switch) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_Unary) return find_stop_unused(parent, level + 1);\n                if (parent instanceof AST_VarDef) return check_assignment(parent.name);\n                if (parent instanceof AST_Yield) return node;\n                return null;\n\n                function check_assignment(lhs) {\n                    if (may_throw(parent)) return node;\n                    if (lhs !== node && lhs instanceof AST_Destructured) {\n                        return find_stop_expr(lhs, find_stop_unused, node, parent, level);\n                    }\n                    return find_stop_unused(parent, level + 1);\n                }\n            }\n\n            function mangleable_var(rhs) {\n                if (force_single) {\n                    force_single = false;\n                    return;\n                }\n                if (remaining < 1) return;\n                rhs = rhs.tail_node();\n                var value = rhs instanceof AST_Assign && rhs.operator == "=" ? rhs.left : rhs;\n                if (!(value instanceof AST_SymbolRef)) return;\n                var def = value.definition();\n                if (def.undeclared) return;\n                if (is_arguments(def)) return;\n                if (value !== rhs) {\n                    if (is_lhs_read_only(value, compressor)) return;\n                    var referenced = def.references.length - def.replaced;\n                    if (referenced < 2) return;\n                    var expr = candidate.clone();\n                    expr[expr instanceof AST_Assign ? "right" : "value"] = value;\n                    if (candidate.name_index >= 0) {\n                        expr.name_index = candidate.name_index;\n                        expr.arg_index = candidate.arg_index;\n                    }\n                    candidate = expr;\n                }\n                return value_def = def;\n            }\n\n            function remaining_refs(def) {\n                return def.references.length - def.replaced - (assignments.get(def.name) || 0);\n            }\n\n            function get_lhs(expr) {\n                if (expr instanceof AST_Assign) {\n                    var lhs = expr.left;\n                    if (!(lhs instanceof AST_SymbolRef)) return lhs;\n                    var def = lhs.definition();\n                    if (scope.uses_arguments && is_funarg(def)) return lhs;\n                    if (compressor.exposed(def)) return lhs;\n                    remaining = remaining_refs(def);\n                    if (def.fixed && lhs.fixed) {\n                        var matches = def.references.filter(function(ref) {\n                            return ref.fixed === lhs.fixed;\n                        }).length - 1;\n                        if (matches < remaining) {\n                            remaining = matches;\n                            assign_pos = 0;\n                            verify_ref = true;\n                        }\n                    }\n                    if (expr.operator == "=") mangleable_var(expr.right);\n                    return lhs;\n                }\n                if (expr instanceof AST_Binary) return expr.right.left;\n                if (expr instanceof AST_Unary) return expr.expression;\n                if (expr instanceof AST_VarDef) {\n                    var lhs = expr.name;\n                    var def = lhs.definition();\n                    if (def.const_redefs) return;\n                    if (!member(lhs, def.orig)) return;\n                    if (scope.uses_arguments && is_funarg(def)) return;\n                    var declared = def.orig.length - def.eliminated - (declare_only.get(def.name) || 0);\n                    remaining = remaining_refs(def);\n                    if (def.fixed) remaining = Math.min(remaining, def.references.filter(function(ref) {\n                        if (!ref.fixed) return true;\n                        if (!ref.fixed.assigns) return true;\n                        var assign = ref.fixed.assigns[0];\n                        return assign === lhs || get_rvalue(assign) === expr.value;\n                    }).length);\n                    if (declared > 1 && !(lhs instanceof AST_SymbolFunarg)) {\n                        mangleable_var(expr.value);\n                        return make_node(AST_SymbolRef, lhs);\n                    }\n                    if (mangleable_var(expr.value) || remaining == 1 && !compressor.exposed(def)) {\n                        return make_node(AST_SymbolRef, lhs);\n                    }\n                    return;\n                }\n            }\n\n            function get_rvalue(expr) {\n                if (expr instanceof AST_Assign) return expr.right;\n                if (expr instanceof AST_Binary) {\n                    var node = expr.clone();\n                    node.right = expr.right.right;\n                    return node;\n                }\n                if (expr instanceof AST_VarDef) return expr.value;\n            }\n\n            function invariant(expr) {\n                if (expr instanceof AST_Array) return false;\n                if (expr instanceof AST_Binary && lazy_op[expr.operator]) {\n                    return invariant(expr.left) && invariant(expr.right);\n                }\n                if (expr instanceof AST_Call) return false;\n                if (expr instanceof AST_Conditional) {\n                    return invariant(expr.consequent) && invariant(expr.alternative);\n                }\n                if (expr instanceof AST_Object) return false;\n                return !expr.has_side_effects(compressor);\n            }\n\n            function foldable(expr) {\n                if (expr instanceof AST_Assign && expr.right.single_use) return;\n                var lhs_ids = Object.create(null);\n                var marker = new TreeWalker(function(node) {\n                    if (!(node instanceof AST_SymbolRef)) return;\n                    for (var level = 0, parent, child = node; parent = marker.parent(level++); child = parent) {\n                        if (is_direct_assignment(child, parent)) {\n                            if (parent instanceof AST_DestructuredKeyVal) parent = marker.parent(level++);\n                            continue;\n                        }\n                        lhs_ids[node.definition().id] = true;\n                        return;\n                    }\n                    lhs_ids[node.definition().id] = "a";\n                });\n                while (expr instanceof AST_Assign && expr.operator == "=") {\n                    expr.left.walk(marker);\n                    expr = expr.right;\n                }\n                if (expr instanceof AST_ObjectIdentity) return rhs_exact_match;\n                if (expr instanceof AST_SymbolRef) {\n                    if (lhs_ids[expr.definition().id] === "a") return;\n                    var value = expr.evaluate(compressor);\n                    if (value === expr) return rhs_exact_match;\n                    return rhs_fuzzy_match(value, rhs_exact_match);\n                }\n                if (expr.is_truthy()) return rhs_fuzzy_match(true, return_false);\n                if (expr.is_constant()) {\n                    var ev = expr.evaluate(compressor);\n                    if (!(ev instanceof AST_Node)) return rhs_fuzzy_match(ev, rhs_exact_match);\n                }\n                if (!(lhs instanceof AST_SymbolRef)) return false;\n                if (!invariant(expr)) return false;\n                var circular;\n                expr.walk(new TreeWalker(function(node) {\n                    if (circular) return true;\n                    if (node instanceof AST_SymbolRef && lhs_ids[node.definition().id]) circular = true;\n                }));\n                return !circular && rhs_exact_match;\n\n                function rhs_exact_match(node) {\n                    return expr.equals(node);\n                }\n            }\n\n            function rhs_fuzzy_match(value, fallback) {\n                return function(node, tw) {\n                    if (tw.in_boolean_context()) {\n                        if (value && node.is_truthy() && !node.has_side_effects(compressor)) {\n                            return true;\n                        }\n                        if (node.is_constant()) {\n                            var ev = node.evaluate(compressor);\n                            if (!(ev instanceof AST_Node)) return !ev == !value;\n                        }\n                    }\n                    return fallback(node);\n                };\n            }\n\n            function clear_write_only(assign) {\n                while (assign.write_only) {\n                    assign.write_only = false;\n                    if (!(assign instanceof AST_Assign)) break;\n                    assign = assign.right;\n                }\n            }\n\n            function update_symbols(value, node) {\n                var clear_defined = node instanceof AST_SymbolRef && !node.defined;\n                var scope = node.scope || find_scope(scanner) || block_scope;\n                value.walk(new TreeWalker(function(node) {\n                    if (node instanceof AST_BlockScope) return true;\n                    if (node instanceof AST_Symbol) {\n                        if (clear_defined && node instanceof AST_SymbolRef) node.defined = false;\n                        node.scope = scope;\n                    }\n                }));\n            }\n\n            function may_be_global(node) {\n                if (node instanceof AST_SymbolRef) {\n                    node = node.fixed_value();\n                    if (!node) return true;\n                }\n                if (node instanceof AST_Assign) return node.operator == "=" && may_be_global(node.right);\n                return node instanceof AST_PropAccess || node instanceof AST_ObjectIdentity;\n            }\n\n            function get_lvalues(expr) {\n                var lvalues = new Dictionary();\n                if (expr instanceof AST_VarDef) {\n                    if (!expr.name.definition().fixed) well_defined = false;\n                    lvalues.add(expr.name.name, lhs);\n                }\n                var find_arguments = scope.uses_arguments && !compressor.has_directive("use strict");\n                var scan_toplevel = scope instanceof AST_Toplevel;\n                var tw = new TreeWalker(function(node) {\n                    if (node.inlined_node) node.inlined_node.walk(tw);\n                    var value;\n                    if (node instanceof AST_SymbolRef) {\n                        value = node.fixed_value();\n                        if (!value) {\n                            value = node;\n                            var def = node.definition();\n                            var escaped = node.fixed && node.fixed.escaped || def.escaped;\n                            if (!def.undeclared\n                                && (def.assignments || !escaped || escaped.cross_scope)\n                                && (has_escaped(def, node.scope, node, tw.parent()) || !same_scope(def))) {\n                                well_defined = false;\n                            }\n                        }\n                    } else if (node instanceof AST_ObjectIdentity) {\n                        value = node;\n                    }\n                    if (value) {\n                        lvalues.add(node.name, is_modified(compressor, tw, node, value, 0));\n                    } else if (node instanceof AST_Lambda) {\n                        for (var level = 0, parent, child = node; parent = tw.parent(level++); child = parent) {\n                            if (parent instanceof AST_Assign) {\n                                if (parent.left === child) break;\n                                if (parent.operator == "=") continue;\n                                if (lazy_op[parent.operator.slice(0, -1)]) continue;\n                                break;\n                            }\n                            if (parent instanceof AST_Binary) {\n                                if (lazy_op[parent.operator]) continue;\n                                break;\n                            }\n                            if (parent instanceof AST_Call) return;\n                            if (parent instanceof AST_Scope) return;\n                            if (parent instanceof AST_Sequence) {\n                                if (parent.tail_node() === child) continue;\n                                break;\n                            }\n                            if (parent instanceof AST_Template) {\n                                if (parent.tag) return;\n                                break;\n                            }\n                        }\n                        node.enclosed.forEach(function(def) {\n                            if (def.scope !== node) enclosed.set(def.name, true);\n                        });\n                        return true;\n                    } else if (find_arguments && node instanceof AST_Sub) {\n                        scope.each_argname(function(argname) {\n                            if (!compressor.option("reduce_vars") || argname.definition().assignments) {\n                                if (!argname.definition().fixed) well_defined = false;\n                                lvalues.add(argname.name, true);\n                            }\n                        });\n                        find_arguments = false;\n                    }\n                    if (!scan_toplevel) return;\n                    if (node.TYPE == "Call") {\n                        if (modify_toplevel) return;\n                        var exp = node.expression;\n                        if (exp instanceof AST_PropAccess) return;\n                        if (exp instanceof AST_LambdaExpression && !exp.contains_this()) return;\n                        modify_toplevel = true;\n                    } else if (node instanceof AST_PropAccess && may_be_global(node.expression)) {\n                        if (node === lhs && !(expr instanceof AST_Unary)) {\n                            modify_toplevel = true;\n                        } else {\n                            read_toplevel = true;\n                        }\n                    }\n                });\n                expr.walk(tw);\n                return lvalues;\n            }\n\n            function remove_candidate(expr) {\n                var value = rvalue === rhs_value ? null : make_sequence(rhs_value, rhs_value.expressions.slice(0, -1));\n                var index = expr.name_index;\n                if (index >= 0) {\n                    var args, argname = scope.argnames[index];\n                    if (argname instanceof AST_DefaultValue) {\n                        scope.argnames[index] = argname = argname.clone();\n                        argname.value = value || make_node(AST_Number, argname, { value: 0 });\n                    } else if ((args = compressor.parent().args)[index]) {\n                        scope.argnames[index] = argname.clone();\n                        args[index] = value || make_node(AST_Number, args[index], { value: 0 });\n                    }\n                    return;\n                }\n                var end = hit_stack.length - 1;\n                var last = hit_stack[end];\n                if (last instanceof AST_VarDef || hit_stack[end - 1].body === last) end--;\n                var tt = new TreeTransformer(function(node, descend, in_list) {\n                    if (hit) return node;\n                    if (node !== hit_stack[hit_index]) return node;\n                    hit_index++;\n                    if (hit_index <= end) return handle_custom_scan_order(node, tt);\n                    hit = true;\n                    if (node instanceof AST_Definitions) {\n                        declare_only.set(last.name.name, (declare_only.get(last.name.name) || 0) + 1);\n                        if (value_def) value_def.replaced++;\n                        var defns = node.definitions;\n                        var index = defns.indexOf(last);\n                        var defn = last.clone();\n                        defn.value = null;\n                        if (!value) {\n                            node.definitions[index] = defn;\n                            return node;\n                        }\n                        var body = [ make_node(AST_SimpleStatement, value, { body: value }) ];\n                        if (index > 0) {\n                            var head = node.clone();\n                            head.definitions = defns.slice(0, index);\n                            body.unshift(head);\n                            node = node.clone();\n                            node.definitions = defns.slice(index);\n                        }\n                        body.push(node);\n                        node.definitions[0] = defn;\n                        return in_list ? List.splice(body) : make_node(AST_BlockStatement, node, { body: body });\n                    }\n                    if (!value) return in_list ? List.skip : null;\n                    return is_statement(node) ? make_node(AST_SimpleStatement, value, { body: value }) : value;\n                }, function(node, in_list) {\n                    if (node instanceof AST_For) return patch_for_init(node, in_list);\n                    return patch_sequence(node, tt);\n                });\n                abort = false;\n                hit = false;\n                hit_index = 0;\n                if (!(statements[stat_index] = statements[stat_index].transform(tt))) statements.splice(stat_index, 1);\n            }\n\n            function patch_sequence(node, tt) {\n                if (node instanceof AST_Sequence) switch (node.expressions.length) {\n                  case 0: return null;\n                  case 1: return maintain_this_binding(tt.parent(), node, node.expressions[0]);\n                }\n            }\n\n            function get_defun_scopes(lhs) {\n                if (!(lhs instanceof AST_SymbolDeclaration\n                    || lhs instanceof AST_SymbolRef\n                    || lhs instanceof AST_Destructured)) return;\n                var scopes = [];\n                lhs.mark_symbol(function(node) {\n                    if (node instanceof AST_Symbol) {\n                        var def = node.definition();\n                        var scope = def.scope.resolve();\n                        def.orig.forEach(function(sym) {\n                            if (sym instanceof AST_SymbolDefun) {\n                                if (sym.scope !== scope) push_uniq(scopes, sym.scope);\n                            }\n                        });\n                    }\n                });\n                if (scopes.length == 0) return;\n                return scopes;\n            }\n\n            function is_lhs_local(lhs) {\n                var sym = root_expr(lhs);\n                if (!(sym instanceof AST_SymbolRef)) return false;\n                if (sym.definition().scope.resolve() !== scope) return false;\n                if (!in_loop) return true;\n                if (compound) return false;\n                if (candidate instanceof AST_Unary) return false;\n                var lvalue = lvalues.get(sym.name);\n                return !lvalue || lvalue[0] === lhs;\n            }\n\n            function value_has_side_effects() {\n                if (candidate instanceof AST_Unary) return false;\n                return rvalue.has_side_effects(compressor);\n            }\n\n            function replace_all_symbols(expr) {\n                if (expr instanceof AST_Unary) return false;\n                if (side_effects) return false;\n                if (value_def) return true;\n                if (!(lhs instanceof AST_SymbolRef)) return false;\n                var referenced;\n                if (expr instanceof AST_VarDef) {\n                    referenced = 1;\n                } else if (expr.operator == "=") {\n                    referenced = 2;\n                } else {\n                    return false;\n                }\n                var def = lhs.definition();\n                if (def.references.length - def.replaced == referenced) return true;\n                if (!def.fixed) return false;\n                if (!lhs.fixed) return false;\n                var assigns = lhs.fixed.assigns;\n                var matched = 0;\n                if (!all(def.references, function(ref, index) {\n                    var fixed = ref.fixed;\n                    if (!fixed) return false;\n                    if (fixed.to_binary || fixed.to_prefix) return false;\n                    if (fixed === lhs.fixed) {\n                        matched++;\n                        return true;\n                    }\n                    return assigns && fixed.assigns && assigns[0] !== fixed.assigns[0];\n                })) return false;\n                if (matched != referenced) return false;\n                verify_ref = true;\n                return true;\n            }\n\n            function symbol_in_lvalues(sym) {\n                var lvalue = lvalues.get(sym.name);\n                if (!lvalue || all(lvalue, function(lhs) {\n                    return !lhs;\n                })) return;\n                if (lvalue[0] !== lhs) return true;\n                scan_rhs = false;\n            }\n\n            function may_modify(sym) {\n                var def = sym.definition();\n                if (def.orig.length == 1 && def.orig[0] instanceof AST_SymbolDefun) return false;\n                if (def.scope.resolve() !== scope) return true;\n                if (modify_toplevel && compressor.exposed(def)) return true;\n                return !all(def.references, function(ref) {\n                    return ref.scope.resolve(true) === scope;\n                });\n            }\n\n            function side_effects_external(node, lhs) {\n                if (node instanceof AST_Assign) return side_effects_external(node.left, true);\n                if (node instanceof AST_Unary) return side_effects_external(node.expression, true);\n                if (node instanceof AST_VarDef) return node.value && side_effects_external(node.value);\n                if (lhs) {\n                    if (node instanceof AST_Dot) return side_effects_external(node.expression, true);\n                    if (node instanceof AST_Sub) return side_effects_external(node.expression, true);\n                    if (node instanceof AST_SymbolRef) return node.definition().scope.resolve() !== scope;\n                }\n                return false;\n            }\n        }\n\n        function eliminate_spurious_blocks(statements) {\n            var changed = false, seen_dirs = [];\n            for (var i = 0; i < statements.length;) {\n                var stat = statements[i];\n                if (stat instanceof AST_BlockStatement) {\n                    if (all(stat.body, safe_to_trim)) {\n                        changed = true;\n                        eliminate_spurious_blocks(stat.body);\n                        [].splice.apply(statements, [i, 1].concat(stat.body));\n                        i += stat.body.length;\n                        continue;\n                    }\n                }\n                if (stat instanceof AST_Directive) {\n                    if (member(stat.value, seen_dirs)) {\n                        changed = true;\n                        statements.splice(i, 1);\n                        continue;\n                    }\n                    seen_dirs.push(stat.value);\n                }\n                if (stat instanceof AST_EmptyStatement) {\n                    changed = true;\n                    statements.splice(i, 1);\n                    continue;\n                }\n                i++;\n            }\n            return changed;\n        }\n\n        function handle_if_return(statements, compressor) {\n            var changed = false;\n            var parent = compressor.parent();\n            var self = compressor.self();\n            var declare_only, jump, merge_jump;\n            var in_iife = in_lambda && parent && parent.TYPE == "Call" && parent.expression === self;\n            var chain_if_returns = in_lambda && compressor.option("conditionals") && compressor.option("sequences");\n            var drop_return_void = !(in_try && in_try.bfinally && in_async_generator(scope));\n            var multiple_if_returns = has_multiple_if_returns(statements);\n            for (var i = statements.length; --i >= 0;) {\n                var stat = statements[i];\n                var j = next_index(i);\n                var next = statements[j];\n\n                if (in_lambda && declare_only && !next && stat instanceof AST_Return\n                    && drop_return_void && !(self instanceof AST_SwitchBranch)) {\n                    var body = stat.value;\n                    if (!body) {\n                        changed = true;\n                        statements.splice(i, 1);\n                        continue;\n                    }\n                    var tail = body.tail_node();\n                    if (is_undefined(tail)) {\n                        changed = true;\n                        if (body instanceof AST_UnaryPrefix) {\n                            body = body.expression;\n                        } else if (tail instanceof AST_UnaryPrefix) {\n                            body = body.clone();\n                            body.expressions[body.expressions.length - 1] = tail.expression;\n                        }\n                        statements[i] = make_node(AST_SimpleStatement, stat, { body: body });\n                        continue;\n                    }\n                }\n\n                if (stat instanceof AST_If) {\n                    var ab = aborts(stat.body);\n                    // if (foo()) { bar(); return; } else baz(); moo(); ---\x3e if (foo()) bar(); else { baz(); moo(); }\n                    if (can_merge_flow(ab)) {\n                        if (ab.label) remove(ab.label.thedef.references, ab);\n                        changed = true;\n                        stat = stat.clone();\n                        stat.body = make_node(AST_BlockStatement, stat, {\n                            body: as_statement_array_with_return(stat.body, ab),\n                        });\n                        stat.alternative = make_node(AST_BlockStatement, stat, {\n                            body: as_statement_array(stat.alternative).concat(extract_functions(merge_jump, jump)),\n                        });\n                        adjust_refs(ab.value, merge_jump);\n                        statements[i] = stat;\n                        statements[i] = stat.transform(compressor);\n                        continue;\n                    }\n                    // if (foo()) { bar(); return x; } return y; ---\x3e if (!foo()) return y; bar(); return x;\n                    if (ab && !stat.alternative && next instanceof AST_Jump) {\n                        var cond = stat.condition;\n                        var preference = i + 1 == j && stat.body instanceof AST_BlockStatement;\n                        cond = best_of_expression(cond, cond.negate(compressor), preference);\n                        if (cond !== stat.condition) {\n                            changed = true;\n                            stat = stat.clone();\n                            stat.condition = cond;\n                            var body = stat.body;\n                            stat.body = make_node(AST_BlockStatement, next, {\n                                body: extract_functions(true, null, j + 1),\n                            });\n                            statements.splice(i, 1, stat, body);\n                            // proceed further only if `TreeWalker.stack` is in a consistent state\n                            //    https://github.com/mishoo/UglifyJS/issues/5595\n                            //    https://github.com/mishoo/UglifyJS/issues/5597\n                            if (!in_lambda || self instanceof AST_Block && self.body === statements) {\n                                statements[i] = stat.transform(compressor);\n                            }\n                            continue;\n                        }\n                    }\n                    var alt = aborts(stat.alternative);\n                    // if (foo()) bar(); else { baz(); return; } moo(); ---\x3e if (foo()) { bar(); moo(); } else baz();\n                    if (can_merge_flow(alt)) {\n                        if (alt.label) remove(alt.label.thedef.references, alt);\n                        changed = true;\n                        stat = stat.clone();\n                        stat.body = make_node(AST_BlockStatement, stat.body, {\n                            body: as_statement_array(stat.body).concat(extract_functions(merge_jump, jump)),\n                        });\n                        stat.alternative = make_node(AST_BlockStatement, stat.alternative, {\n                            body: as_statement_array_with_return(stat.alternative, alt),\n                        });\n                        adjust_refs(alt.value, merge_jump);\n                        statements[i] = stat;\n                        statements[i] = stat.transform(compressor);\n                        continue;\n                    }\n                    if (compressor.option("typeofs")) {\n                        if (ab && !alt) {\n                            var stats = make_node(AST_BlockStatement, self, { body: statements.slice(i + 1) });\n                            mark_locally_defined(stat.condition, null, stats);\n                        }\n                        if (!ab && alt) {\n                            var stats = make_node(AST_BlockStatement, self, { body: statements.slice(i + 1) });\n                            mark_locally_defined(stat.condition, stats);\n                        }\n                    }\n                }\n\n                if (stat instanceof AST_If && stat.body instanceof AST_Return) {\n                    var value = stat.body.value;\n                    var in_bool = stat.body.in_bool || next instanceof AST_Return && next.in_bool;\n                    // if (foo()) return x; return y; ---\x3e return foo() ? x : y;\n                    if (!stat.alternative && next instanceof AST_Return\n                        && (drop_return_void || !value == !next.value)) {\n                        changed = true;\n                        stat = stat.clone();\n                        stat.alternative = make_node(AST_BlockStatement, next, {\n                            body: extract_functions(true, null, j + 1),\n                        });\n                        statements[i] = stat;\n                        statements[i] = stat.transform(compressor);\n                        continue;\n                    }\n                    // if (foo()) return x; [ return ; ] ---\x3e return foo() ? x : undefined;\n                    // if (foo()) return bar() ? x : void 0; ---\x3e return foo() && bar() ? x : void 0;\n                    // if (foo()) return bar() ? void 0 : x; ---\x3e return !foo() || bar() ? void 0 : x;\n                    if (in_lambda && declare_only && !next && !stat.alternative && (in_bool\n                        || value && multiple_if_returns\n                        || value instanceof AST_Conditional && (is_undefined(value.consequent, compressor)\n                            || is_undefined(value.alternative, compressor)))) {\n                        changed = true;\n                        stat = stat.clone();\n                        stat.alternative = make_node(AST_Return, stat, { value: null });\n                        statements[i] = stat;\n                        statements[i] = stat.transform(compressor);\n                        continue;\n                    }\n                    // if (a) return b; if (c) return d; e; ---\x3e return a ? b : c ? d : void e;\n                    //\n                    // if sequences is not enabled, this can lead to an endless loop (issue #866).\n                    // however, with sequences on this helps producing slightly better output for\n                    // the example code.\n                    var prev, prev_stat;\n                    if (chain_if_returns && !stat.alternative\n                        && (!(prev_stat = statements[prev = prev_index(i)]) && in_iife\n                            || prev_stat instanceof AST_If && prev_stat.body instanceof AST_Return)\n                        && (!next ? !declare_only\n                            : next instanceof AST_SimpleStatement && next_index(j) == statements.length)) {\n                        changed = true;\n                        var exprs = [];\n                        stat = stat.clone();\n                        exprs.push(stat.condition);\n                        stat.condition = make_sequence(stat, exprs);\n                        stat.alternative = make_node(AST_BlockStatement, self, {\n                            body: extract_functions().concat(make_node(AST_Return, self, { value: null })),\n                        });\n                        statements[i] = stat.transform(compressor);\n                        i = prev + 1;\n                        continue;\n                    }\n                }\n\n                if (stat instanceof AST_Break || stat instanceof AST_Exit) {\n                    jump = stat;\n                    continue;\n                }\n\n                if (declare_only && jump && jump === next) eliminate_returns(stat);\n            }\n            return changed;\n\n            function has_multiple_if_returns(statements) {\n                var n = 0;\n                for (var i = statements.length; --i >= 0;) {\n                    var stat = statements[i];\n                    if (stat instanceof AST_If && stat.body instanceof AST_Return) {\n                        if (++n > 1) return true;\n                    }\n                }\n                return false;\n            }\n\n            function match_target(target) {\n                return last_of(compressor, function(node) {\n                    return node === target;\n                });\n            }\n\n            function match_return(ab, exact) {\n                if (!jump) return false;\n                if (jump.TYPE != ab.TYPE) return false;\n                var value = ab.value;\n                if (!value) return false;\n                var equals = jump.equals(ab);\n                if (!equals && value instanceof AST_Sequence) {\n                    value = value.tail_node();\n                    if (jump.value && jump.value.equals(value)) equals = 2;\n                }\n                if (!equals && !exact && jump.value instanceof AST_Sequence) {\n                    if (jump.value.tail_node().equals(value)) equals = 3;\n                }\n                return equals;\n            }\n\n            function can_drop_abort(ab) {\n                if (ab instanceof AST_Exit) {\n                    if (merge_jump = match_return(ab)) return true;\n                    if (!in_lambda) return false;\n                    if (!(ab instanceof AST_Return)) return false;\n                    var value = ab.value;\n                    if (value) {\n                        if (!drop_return_void) return false;\n                        if (!is_undefined(value.tail_node())) return false;\n                    }\n                    if (!(self instanceof AST_SwitchBranch)) return true;\n                    if (!jump) return false;\n                    if (jump instanceof AST_Exit && jump.value) return false;\n                    merge_jump = 4;\n                    return true;\n                }\n                if (!(ab instanceof AST_LoopControl)) return false;\n                if (self instanceof AST_SwitchBranch) {\n                    if (jump instanceof AST_Exit) {\n                        if (!in_lambda) return false;\n                        if (jump.value) return false;\n                        merge_jump = true;\n                    } else if (jump) {\n                        if (compressor.loopcontrol_target(jump) !== parent) return false;\n                        merge_jump = true;\n                    } else if (jump === false) {\n                        return false;\n                    }\n                }\n                var lct = compressor.loopcontrol_target(ab);\n                if (ab instanceof AST_Continue) return match_target(loop_body(lct));\n                if (lct instanceof AST_IterationStatement) return false;\n                return match_target(lct);\n            }\n\n            function can_merge_flow(ab) {\n                merge_jump = false;\n                if (!can_drop_abort(ab)) return false;\n                for (var j = statements.length; --j > i;) {\n                    var stat = statements[j];\n                    if (stat instanceof AST_DefClass) {\n                        if (stat.name.definition().preinit) return false;\n                    } else if (stat instanceof AST_Const || stat instanceof AST_Let) {\n                        if (!all(stat.definitions, function(defn) {\n                            return !defn.name.match_symbol(function(node) {\n                                return node instanceof AST_SymbolDeclaration && node.definition().preinit;\n                            });\n                        })) return false;\n                    }\n                }\n                return true;\n            }\n\n            function extract_functions(mode, stop, end) {\n                var defuns = [];\n                var lexical = false;\n                var start = i + 1;\n                if (!mode) {\n                    end = statements.length;\n                    jump = null;\n                } else if (stop) {\n                    end = statements.lastIndexOf(stop);\n                } else {\n                    stop = statements[end];\n                    if (stop !== jump) jump = false;\n                }\n                var tail = statements.splice(start, end - start).filter(function(stat) {\n                    if (stat instanceof AST_LambdaDefinition) {\n                        defuns.push(stat);\n                        return false;\n                    }\n                    if (is_lexical_definition(stat)) lexical = true;\n                    return true;\n                });\n                if (mode === 3) {\n                    tail.push(make_node(AST_SimpleStatement, stop.value, {\n                        body: make_sequence(stop.value, stop.value.expressions.slice(0, -1)),\n                    }));\n                    stop.value = stop.value.tail_node();\n                }\n                [].push.apply(lexical ? tail : statements, defuns);\n                return tail;\n            }\n\n            function trim_return(value, mode) {\n                if (value) switch (mode) {\n                  case 4:\n                    return value;\n                  case 3:\n                    if (!(value instanceof AST_Sequence)) break;\n                  case 2:\n                    return make_sequence(value, value.expressions.slice(0, -1));\n                }\n            }\n\n            function as_statement_array_with_return(node, ab) {\n                var body = as_statement_array(node);\n                var block = body, last;\n                while ((last = block[block.length - 1]) !== ab) {\n                    block = last.body;\n                }\n                block.pop();\n                var value = ab.value;\n                if (merge_jump) value = trim_return(value, merge_jump);\n                if (value) block.push(make_node(AST_SimpleStatement, value, { body: value }));\n                return body;\n            }\n\n            function adjust_refs(value, mode) {\n                if (!mode) return;\n                if (!value) return;\n                switch (mode) {\n                  case 4:\n                    return;\n                  case 3:\n                  case 2:\n                    value = value.tail_node();\n                }\n                merge_expression(value, jump.value);\n            }\n\n            function next_index(i) {\n                declare_only = true;\n                for (var j = i; ++j < statements.length;) {\n                    var stat = statements[j];\n                    if (is_declaration(stat)) continue;\n                    if (stat instanceof AST_Var) {\n                        declare_only = false;\n                        continue;\n                    }\n                    break;\n                }\n                return j;\n            }\n\n            function prev_index(i) {\n                for (var j = i; --j >= 0;) {\n                    var stat = statements[j];\n                    if (stat instanceof AST_Var) continue;\n                    if (is_declaration(stat)) continue;\n                    break;\n                }\n                return j;\n            }\n\n            function eliminate_returns(stat, keep_throws, in_block) {\n                if (stat instanceof AST_Exit) {\n                    var mode = !(keep_throws && stat instanceof AST_Throw) && match_return(stat, true);\n                    if (mode) {\n                        changed = true;\n                        var value = trim_return(stat.value, mode);\n                        if (value) return make_node(AST_SimpleStatement, value, { body: value });\n                        return in_block ? null : make_node(AST_EmptyStatement, stat);\n                    }\n                } else if (stat instanceof AST_If) {\n                    stat.body = eliminate_returns(stat.body, keep_throws);\n                    if (stat.alternative) stat.alternative = eliminate_returns(stat.alternative, keep_throws);\n                } else if (stat instanceof AST_LabeledStatement) {\n                    stat.body = eliminate_returns(stat.body, keep_throws);\n                } else if (stat instanceof AST_Try) {\n                    if (!stat.bfinally || !jump.value || jump.value.is_constant()) {\n                        if (stat.bcatch) eliminate_returns(stat.bcatch, keep_throws);\n                        var trimmed = eliminate_returns(stat.body.pop(), true, true);\n                        if (trimmed) stat.body.push(trimmed);\n                    }\n                } else if (stat instanceof AST_Block && !(stat instanceof AST_Scope || stat instanceof AST_Switch)) {\n                    var trimmed = eliminate_returns(stat.body.pop(), keep_throws, true);\n                    if (trimmed) stat.body.push(trimmed);\n                }\n                return stat;\n            }\n        }\n\n        function eliminate_dead_code(statements, compressor) {\n            var has_quit;\n            var self = compressor.self();\n            if (self instanceof AST_Catch) {\n                self = compressor.parent();\n            } else if (self instanceof AST_LabeledStatement) {\n                self = self.body;\n            }\n            for (var i = 0, n = 0, len = statements.length; i < len; i++) {\n                var stat = statements[i];\n                if (stat instanceof AST_LoopControl) {\n                    var lct = compressor.loopcontrol_target(stat);\n                    if (loop_body(lct) !== self\n                        || stat instanceof AST_Break && lct instanceof AST_IterationStatement) {\n                        statements[n++] = stat;\n                    } else if (stat.label) {\n                        remove(stat.label.thedef.references, stat);\n                    }\n                } else {\n                    statements[n++] = stat;\n                }\n                if (aborts(stat)) {\n                    has_quit = statements.slice(i + 1);\n                    break;\n                }\n            }\n            statements.length = n;\n            if (has_quit) has_quit.forEach(function(stat) {\n                extract_declarations_from_unreachable_code(compressor, stat, statements);\n            });\n            return statements.length != len;\n        }\n\n        function trim_awaits(statements, compressor) {\n            if (!in_lambda || in_try && in_try.bfinally) return;\n            var changed = false;\n            for (var index = statements.length; --index >= 0;) {\n                var stat = statements[index];\n                if (!(stat instanceof AST_SimpleStatement)) break;\n                var node = stat.body.tail_node();\n                if (!(node instanceof AST_Await)) break;\n                var exp = node.expression;\n                if (!needs_enqueuing(compressor, exp)) break;\n                changed = true;\n                exp = exp.drop_side_effect_free(compressor, true);\n                if (stat.body instanceof AST_Sequence) {\n                    var expressions = stat.body.expressions.slice();\n                    expressions.pop();\n                    if (exp) expressions.push(exp);\n                    stat.body = make_sequence(stat.body, expressions);\n                    break;\n                }\n                if (exp) {\n                    stat.body = exp;\n                    break;\n                }\n            }\n            statements.length = index + 1;\n            return changed;\n        }\n\n        function inline_iife(statements, compressor) {\n            var changed = false;\n            var index = statements.length - 1;\n            if (in_lambda && index >= 0) {\n                var no_return = in_try && in_try.bfinally && in_async_generator(scope);\n                var inlined = statements[index].try_inline(compressor, block_scope, no_return);\n                if (inlined) {\n                    statements[index--] = inlined;\n                    changed = true;\n                }\n            }\n            var loop = in_loop && in_try ? "try" : in_loop;\n            for (; index >= 0; index--) {\n                var inlined = statements[index].try_inline(compressor, block_scope, true, loop);\n                if (!inlined) continue;\n                statements[index] = inlined;\n                changed = true;\n            }\n            return changed;\n        }\n\n        function sequencesize(statements, compressor) {\n            if (statements.length < 2) return;\n            var seq = [], n = 0;\n            function push_seq() {\n                if (!seq.length) return;\n                var body = make_sequence(seq[0], seq);\n                statements[n++] = make_node(AST_SimpleStatement, body, { body: body });\n                seq = [];\n            }\n            for (var i = 0, len = statements.length; i < len; i++) {\n                var stat = statements[i];\n                if (stat instanceof AST_SimpleStatement) {\n                    if (seq.length >= compressor.sequences_limit) push_seq();\n                    merge_sequence(seq, stat.body);\n                } else if (is_declaration(stat)) {\n                    statements[n++] = stat;\n                } else {\n                    push_seq();\n                    statements[n++] = stat;\n                }\n            }\n            push_seq();\n            statements.length = n;\n            return n != len;\n        }\n\n        function to_simple_statement(block, decls) {\n            if (!(block instanceof AST_BlockStatement)) return block;\n            var stat = null;\n            for (var i = 0; i < block.body.length; i++) {\n                var line = block.body[i];\n                if (line instanceof AST_Var && declarations_only(line)) {\n                    decls.push(line);\n                } else if (stat || is_lexical_definition(line)) {\n                    return false;\n                } else {\n                    stat = line;\n                }\n            }\n            return stat;\n        }\n\n        function sequencesize_2(statements, compressor) {\n            var changed = false, n = 0, prev;\n            for (var i = 0; i < statements.length; i++) {\n                var stat = statements[i];\n                if (prev) {\n                    if (stat instanceof AST_Exit) {\n                        if (stat.value || !in_async_generator(scope)) {\n                            stat.value = cons_seq(stat.value || make_node(AST_Undefined, stat)).optimize(compressor);\n                        }\n                    } else if (stat instanceof AST_For) {\n                        if (!(stat.init instanceof AST_Definitions)) {\n                            var abort = false;\n                            prev.body.walk(new TreeWalker(function(node) {\n                                if (abort || node instanceof AST_Scope) return true;\n                                if (node instanceof AST_Binary && node.operator == "in") {\n                                    abort = true;\n                                    return true;\n                                }\n                            }));\n                            if (!abort) {\n                                if (stat.init) stat.init = cons_seq(stat.init);\n                                else {\n                                    stat.init = prev.body;\n                                    n--;\n                                    changed = true;\n                                }\n                            }\n                        }\n                    } else if (stat instanceof AST_ForIn) {\n                        if (!is_lexical_definition(stat.init)) stat.object = cons_seq(stat.object);\n                    } else if (stat instanceof AST_If) {\n                        stat.condition = cons_seq(stat.condition);\n                    } else if (stat instanceof AST_Switch) {\n                        stat.expression = cons_seq(stat.expression);\n                    } else if (stat instanceof AST_With) {\n                        stat.expression = cons_seq(stat.expression);\n                    }\n                }\n                if (compressor.option("conditionals") && stat instanceof AST_If) {\n                    var decls = [];\n                    var body = to_simple_statement(stat.body, decls);\n                    var alt = to_simple_statement(stat.alternative, decls);\n                    if (body !== false && alt !== false && decls.length > 0) {\n                        var len = decls.length;\n                        decls.push(make_node(AST_If, stat, {\n                            condition: stat.condition,\n                            body: body || make_node(AST_EmptyStatement, stat.body),\n                            alternative: alt,\n                        }));\n                        decls.unshift(n, 1);\n                        [].splice.apply(statements, decls);\n                        i += len;\n                        n += len + 1;\n                        prev = null;\n                        changed = true;\n                        continue;\n                    }\n                }\n                statements[n++] = stat;\n                prev = stat instanceof AST_SimpleStatement ? stat : null;\n            }\n            statements.length = n;\n            return changed;\n\n            function cons_seq(right) {\n                n--;\n                changed = true;\n                var left = prev.body;\n                return make_sequence(left, [ left, right ]);\n            }\n        }\n\n        function extract_exprs(body) {\n            if (body instanceof AST_Assign) return [ body ];\n            if (body instanceof AST_Sequence) return body.expressions.slice();\n        }\n\n        function join_assigns(defn, body, keep) {\n            var exprs = extract_exprs(body);\n            if (!exprs) return;\n            keep = keep || 0;\n            var trimmed = false;\n            for (var i = exprs.length - keep; --i >= 0;) {\n                var expr = exprs[i];\n                if (!can_trim(expr)) continue;\n                var tail;\n                if (expr.left instanceof AST_SymbolRef) {\n                    tail = exprs.slice(i + 1);\n                } else if (expr.left instanceof AST_PropAccess && can_trim(expr.left.expression)) {\n                    tail = exprs.slice(i + 1);\n                    var flattened = expr.clone();\n                    expr = expr.left.expression;\n                    flattened.left = flattened.left.clone();\n                    flattened.left.expression = expr.left.clone();\n                    tail.unshift(flattened);\n                } else {\n                    continue;\n                }\n                if (tail.length == 0) continue;\n                if (!trim_assigns(expr.left, expr.right, tail)) continue;\n                trimmed = true;\n                exprs = exprs.slice(0, i).concat(expr, tail);\n            }\n            if (defn instanceof AST_Definitions) {\n                for (var i = defn.definitions.length; --i >= 0;) {\n                    var def = defn.definitions[i];\n                    if (!def.value) continue;\n                    if (trim_assigns(def.name, def.value, exprs)) trimmed = true;\n                    if (merge_conditional_assignments(def, exprs, keep)) trimmed = true;\n                    break;\n                }\n                if (defn instanceof AST_Var && join_var_assign(defn.definitions, exprs, keep)) trimmed = true;\n            }\n            return trimmed && exprs;\n\n            function can_trim(node) {\n                return node instanceof AST_Assign && node.operator == "=";\n            }\n        }\n\n        function merge_assigns(prev, defn) {\n            if (!(prev instanceof AST_SimpleStatement)) return;\n            if (declarations_only(defn)) return;\n            var exprs = extract_exprs(prev.body);\n            if (!exprs) return;\n            var definitions = [];\n            if (!join_var_assign(definitions, exprs.reverse(), 0)) return;\n            defn.definitions = definitions.reverse().concat(defn.definitions);\n            return exprs.reverse();\n        }\n\n        function merge_conditional_assignments(var_def, exprs, keep) {\n            if (!compressor.option("conditionals")) return;\n            if (var_def.name instanceof AST_Destructured) return;\n            var trimmed = false;\n            var def = var_def.name.definition();\n            while (exprs.length > keep) {\n                var cond = to_conditional_assignment(compressor, def, var_def.value, exprs[0]);\n                if (!cond) break;\n                var_def.value = cond;\n                exprs.shift();\n                trimmed = true;\n            }\n            return trimmed;\n        }\n\n        function join_var_assign(definitions, exprs, keep) {\n            var trimmed = false;\n            while (exprs.length > keep) {\n                var expr = exprs[0];\n                if (!(expr instanceof AST_Assign)) break;\n                if (expr.operator != "=") break;\n                var lhs = expr.left;\n                if (!(lhs instanceof AST_SymbolRef)) break;\n                if (is_undeclared_ref(lhs)) break;\n                if (lhs.scope.resolve() !== scope) break;\n                var def = lhs.definition();\n                if (def.scope !== scope) break;\n                if (def.orig.length > def.eliminated + 1) break;\n                if (def.orig[0].TYPE != "SymbolVar") break;\n                var name = make_node(AST_SymbolVar, lhs);\n                definitions.push(make_node(AST_VarDef, expr, {\n                    name: name,\n                    value: expr.right,\n                }));\n                def.orig.push(name);\n                def.replaced++;\n                exprs.shift();\n                trimmed = true;\n            }\n            return trimmed;\n        }\n\n        function trim_assigns(name, value, exprs) {\n            var names = new Dictionary();\n            names.set(name.name, true);\n            while (value instanceof AST_Assign && value.operator == "=") {\n                if (value.left instanceof AST_SymbolRef) names.set(value.left.name, true);\n                value = value.right;\n            }\n            if (value instanceof AST_Array) {\n                var trimmed = false;\n                do {\n                    if (!try_join_array(exprs[0])) break;\n                    exprs.shift();\n                    trimmed = true;\n                } while (exprs.length);\n                return trimmed;\n            } else if (value instanceof AST_Object) {\n                var trimmed = false;\n                do {\n                    if (!try_join_object(exprs[0])) break;\n                    exprs.shift();\n                    trimmed = true;\n                } while (exprs.length);\n                return trimmed;\n            }\n\n            function try_join_array(node) {\n                if (!(node instanceof AST_Assign)) return;\n                if (node.operator != "=") return;\n                if (!(node.left instanceof AST_PropAccess)) return;\n                var sym = node.left.expression;\n                if (!(sym instanceof AST_SymbolRef)) return;\n                if (!names.has(sym.name)) return;\n                if (!node.right.is_constant_expression(scope)) return;\n                var prop = node.left.property;\n                if (prop instanceof AST_Node) {\n                    if (try_join_array(prop)) prop = node.left.property = prop.right.clone();\n                    prop = prop.evaluate(compressor);\n                }\n                if (prop instanceof AST_Node) return;\n                if (!RE_POSITIVE_INTEGER.test("" + prop)) return;\n                prop = +prop;\n                var elements = value.elements;\n                var len = elements.length;\n                if (prop > len + 4) return;\n                for (var i = Math.min(len, prop + 1); --i >= 0;) {\n                    if (elements[i] instanceof AST_Spread) return;\n                }\n                if (prop < len) {\n                    var element = elements[prop].drop_side_effect_free(compressor);\n                    elements[prop] = element ? make_sequence(node, [ element, node.right ]) : node.right;\n                } else {\n                    while (prop > len) elements[len++] = make_node(AST_Hole, value);\n                    elements[prop] = node.right;\n                }\n                return true;\n            }\n\n            function try_join_object(node) {\n                if (!(node instanceof AST_Assign)) return;\n                if (node.operator != "=") return;\n                if (!(node.left instanceof AST_PropAccess)) return;\n                var sym = node.left.expression;\n                if (!(sym instanceof AST_SymbolRef)) return;\n                if (!names.has(sym.name)) return;\n                if (!node.right.is_constant_expression(scope)) return;\n                var prop = node.left.property;\n                if (prop instanceof AST_Node) {\n                    if (try_join_object(prop)) prop = node.left.property = prop.right.clone();\n                    prop = prop.evaluate(compressor);\n                }\n                if (prop instanceof AST_Node) return;\n                prop = "" + prop;\n                var diff = prop == "__proto__" || compressor.has_directive("use strict") ? function(node) {\n                    var key = node.key;\n                    return typeof key == "string" && key != prop && key != "__proto__";\n                } : function(node) {\n                    var key = node.key;\n                    if (node instanceof AST_ObjectGetter || node instanceof AST_ObjectSetter) {\n                        return typeof key == "string" && key != prop;\n                    }\n                    return key !== "__proto__";\n                };\n                if (!all(value.properties, diff)) return;\n                value.properties.push(make_node(AST_ObjectKeyVal, node, {\n                    key: prop,\n                    value: node.right,\n                }));\n                return true;\n            }\n        }\n\n        function join_consecutive_vars(statements) {\n            var changed = false, defs, prev_defs;\n            for (var i = 0, j = -1; i < statements.length; i++) {\n                var stat = statements[i];\n                var prev = statements[j];\n                if (stat instanceof AST_Definitions) {\n                    if (prev && prev.TYPE == stat.TYPE) {\n                        prev.definitions = prev.definitions.concat(stat.definitions);\n                        changed = true;\n                    } else if (stat && prev instanceof AST_Let && stat.can_letify(compressor)) {\n                        prev.definitions = prev.definitions.concat(to_let(stat, block_scope).definitions);\n                        changed = true;\n                    } else if (prev && stat instanceof AST_Let && prev.can_letify(compressor)) {\n                        defs = prev_defs;\n                        statements[j] = prev = to_let(prev, block_scope);\n                        prev.definitions = prev.definitions.concat(stat.definitions);\n                        changed = true;\n                    } else if (defs && defs.TYPE == stat.TYPE && declarations_only(stat)) {\n                        defs.definitions = defs.definitions.concat(stat.definitions);\n                        changed = true;\n                    } else if (stat instanceof AST_Var) {\n                        var exprs = merge_assigns(prev, stat);\n                        if (exprs) {\n                            if (exprs.length) {\n                                prev.body = make_sequence(prev, exprs);\n                                j++;\n                            }\n                            changed = true;\n                        } else {\n                            j++;\n                        }\n                        prev_defs = defs;\n                        statements[j] = defs = stat;\n                    } else {\n                        statements[++j] = stat;\n                    }\n                    continue;\n                } else if (stat instanceof AST_Exit) {\n                    stat.value = join_assigns_expr(stat.value);\n                } else if (stat instanceof AST_For) {\n                    var exprs = join_assigns(prev, stat.init);\n                    if (exprs) {\n                        changed = true;\n                        stat.init = exprs.length ? make_sequence(stat.init, exprs) : null;\n                    } else if (prev instanceof AST_Var && (!stat.init || stat.init.TYPE == prev.TYPE)) {\n                        if (stat.init) {\n                            prev.definitions = prev.definitions.concat(stat.init.definitions);\n                        }\n                        stat = stat.clone();\n                        prev_defs = defs;\n                        defs = stat.init = prev;\n                        statements[j] = merge_defns(stat);\n                        changed = true;\n                        continue;\n                    } else if (defs && stat.init && defs.TYPE == stat.init.TYPE && declarations_only(stat.init)) {\n                        defs.definitions = defs.definitions.concat(stat.init.definitions);\n                        stat.init = null;\n                        changed = true;\n                    } else if (stat.init instanceof AST_Var) {\n                        prev_defs = defs;\n                        defs = stat.init;\n                        exprs = merge_assigns(prev, stat.init);\n                        if (exprs) {\n                            changed = true;\n                            if (exprs.length == 0) {\n                                statements[j] = merge_defns(stat);\n                                continue;\n                            }\n                            prev.body = make_sequence(prev, exprs);\n                        }\n                    }\n                } else if (stat instanceof AST_ForEnumeration) {\n                    if (defs && defs.TYPE == stat.init.TYPE) {\n                        var defns = defs.definitions.slice();\n                        stat.init = stat.init.definitions[0].name.convert_symbol(AST_SymbolRef, function(ref, name) {\n                            defns.push(make_node(AST_VarDef, name, {\n                                name: name,\n                                value: null,\n                            }));\n                            name.definition().references.push(ref);\n                        });\n                        defs.definitions = defns;\n                        changed = true;\n                    }\n                    stat.object = join_assigns_expr(stat.object);\n                } else if (stat instanceof AST_If) {\n                    stat.condition = join_assigns_expr(stat.condition);\n                } else if (stat instanceof AST_SimpleStatement) {\n                    var exprs = join_assigns(prev, stat.body), next;\n                    if (exprs) {\n                        changed = true;\n                        if (!exprs.length) continue;\n                        stat.body = make_sequence(stat.body, exprs);\n                    } else if (prev instanceof AST_Definitions\n                        && (next = statements[i + 1])\n                        && prev.TYPE == next.TYPE\n                        && (next = next.definitions[0]).value) {\n                        changed = true;\n                        next.value = make_sequence(stat, [ stat.body, next.value ]);\n                        continue;\n                    }\n                } else if (stat instanceof AST_Switch) {\n                    stat.expression = join_assigns_expr(stat.expression);\n                } else if (stat instanceof AST_With) {\n                    stat.expression = join_assigns_expr(stat.expression);\n                }\n                statements[++j] = defs ? merge_defns(stat) : stat;\n            }\n            statements.length = j + 1;\n            return changed;\n\n            function join_assigns_expr(value) {\n                var exprs = join_assigns(prev, value, 1);\n                if (!exprs) return value;\n                changed = true;\n                var tail = value.tail_node();\n                if (exprs[exprs.length - 1] !== tail) exprs.push(tail.left);\n                return make_sequence(value, exprs);\n            }\n\n            function merge_defns(stat) {\n                return stat.transform(new TreeTransformer(function(node, descend, in_list) {\n                    if (node instanceof AST_Definitions) {\n                        if (defs === node) return node;\n                        if (defs.TYPE != node.TYPE) return node;\n                        var parent = this.parent();\n                        if (parent instanceof AST_ForEnumeration && parent.init === node) return node;\n                        if (!declarations_only(node)) return node;\n                        defs.definitions = defs.definitions.concat(node.definitions);\n                        changed = true;\n                        if (parent instanceof AST_For && parent.init === node) return null;\n                        return in_list ? List.skip : make_node(AST_EmptyStatement, node);\n                    }\n                    if (node instanceof AST_ExportDeclaration) return node;\n                    if (node instanceof AST_Scope) return node;\n                    if (!is_statement(node)) return node;\n                }));\n            }\n        }\n    }\n\n    function extract_declarations_from_unreachable_code(compressor, stat, target) {\n        var block;\n        var dropped = false;\n        stat.walk(new TreeWalker(function(node, descend) {\n            if (node instanceof AST_DefClass) {\n                node.extends = null;\n                node.properties = [];\n                push(node);\n                return true;\n            }\n            if (node instanceof AST_Definitions) {\n                var defns = [];\n                if (node.remove_initializers(compressor, defns)) {\n                    AST_Node.warn("Dropping initialization in unreachable code [{start}]", node);\n                }\n                if (defns.length > 0) {\n                    node.definitions = defns;\n                    push(node);\n                }\n                return true;\n            }\n            if (node instanceof AST_LambdaDefinition) {\n                push(node);\n                return true;\n            }\n            if (node instanceof AST_Scope) return true;\n            if (node instanceof AST_BlockScope) {\n                var save = block;\n                block = [];\n                descend();\n                if (block.required) {\n                    target.push(make_node(AST_BlockStatement, stat, { body: block }));\n                } else if (block.length) {\n                    [].push.apply(target, block);\n                }\n                block = save;\n                return true;\n            }\n            if (!(node instanceof AST_LoopControl)) dropped = true;\n        }));\n        if (dropped) AST_Node.warn("Dropping unreachable code [{start}]", stat);\n\n        function push(node) {\n            if (block) {\n                block.push(node);\n                if (!safe_to_trim(node)) block.required = true;\n            } else {\n                target.push(node);\n            }\n        }\n    }\n\n    function is_undefined(node, compressor) {\n        return node == null\n            || node.is_undefined\n            || node instanceof AST_Undefined\n            || node instanceof AST_UnaryPrefix\n                && node.operator == "void"\n                && !(compressor && node.expression.has_side_effects(compressor));\n    }\n\n    // in_strict_mode()\n    // return true if scope executes in Strict Mode\n    (function(def) {\n        def(AST_Class, return_true);\n        def(AST_Scope, function(compressor) {\n            var body = this.body;\n            for (var i = 0; i < body.length; i++) {\n                var stat = body[i];\n                if (!(stat instanceof AST_Directive)) break;\n                if (stat.value == "use strict") return true;\n            }\n            var parent = this.parent_scope;\n            if (!parent) return compressor.option("module");\n            return parent.resolve(true).in_strict_mode(compressor);\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("in_strict_mode", func);\n    });\n\n    // is_truthy()\n    // return true if `!!node === true`\n    (function(def) {\n        def(AST_Node, return_false);\n        def(AST_Array, return_true);\n        def(AST_Assign, function() {\n            return this.operator == "=" && this.right.is_truthy();\n        });\n        def(AST_Lambda, return_true);\n        def(AST_Object, return_true);\n        def(AST_RegExp, return_true);\n        def(AST_Sequence, function() {\n            return this.tail_node().is_truthy();\n        });\n        def(AST_SymbolRef, function() {\n            var fixed = this.fixed_value();\n            if (!fixed) return false;\n            this.is_truthy = return_false;\n            var result = fixed.is_truthy();\n            delete this.is_truthy;\n            return result;\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("is_truthy", func);\n    });\n\n    // is_negative_zero()\n    // return true if the node may represent -0\n    (function(def) {\n        def(AST_Node, return_true);\n        def(AST_Array, return_false);\n        function binary(op, left, right) {\n            switch (op) {\n              case "-":\n                return left.is_negative_zero()\n                    && (!(right instanceof AST_Constant) || right.value == 0);\n              case "&&":\n              case "||":\n                return left.is_negative_zero() || right.is_negative_zero();\n              case "*":\n              case "/":\n              case "%":\n              case "**":\n                return true;\n              default:\n                return false;\n            }\n        }\n        def(AST_Assign, function() {\n            var op = this.operator;\n            if (op == "=") return this.right.is_negative_zero();\n            return binary(op.slice(0, -1), this.left, this.right);\n        });\n        def(AST_Binary, function() {\n            return binary(this.operator, this.left, this.right);\n        });\n        def(AST_Constant, function() {\n            return this.value == 0 && 1 / this.value < 0;\n        });\n        def(AST_Lambda, return_false);\n        def(AST_Object, return_false);\n        def(AST_RegExp, return_false);\n        def(AST_Sequence, function() {\n            return this.tail_node().is_negative_zero();\n        });\n        def(AST_SymbolRef, function() {\n            var fixed = this.fixed_value();\n            if (!fixed) return true;\n            this.is_negative_zero = return_true;\n            var result = fixed.is_negative_zero();\n            delete this.is_negative_zero;\n            return result;\n        });\n        def(AST_UnaryPrefix, function() {\n            return this.operator == "+" && this.expression.is_negative_zero()\n                || this.operator == "-";\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("is_negative_zero", func);\n    });\n\n    // may_throw_on_access()\n    // returns true if this node may be null, undefined or contain `AST_Accessor`\n    (function(def) {\n        AST_Node.DEFMETHOD("may_throw_on_access", function(compressor, force) {\n            return !compressor.option("pure_getters") || this._dot_throw(compressor, force);\n        });\n        function is_strict(compressor, force) {\n            return force || /strict/.test(compressor.option("pure_getters"));\n        }\n        def(AST_Node, is_strict);\n        def(AST_Array, return_false);\n        def(AST_Assign, function(compressor) {\n            var op = this.operator;\n            var sym = this.left;\n            var rhs = this.right;\n            if (op != "=") {\n                return lazy_op[op.slice(0, -1)] && (sym._dot_throw(compressor) || rhs._dot_throw(compressor));\n            }\n            if (!rhs._dot_throw(compressor)) return false;\n            if (!(sym instanceof AST_SymbolRef)) return true;\n            if (rhs instanceof AST_Binary && rhs.operator == "||" && sym.name == rhs.left.name) {\n                return rhs.right._dot_throw(compressor);\n            }\n            return true;\n        });\n        def(AST_Binary, function(compressor) {\n            return lazy_op[this.operator] && (this.left._dot_throw(compressor) || this.right._dot_throw(compressor));\n        });\n        def(AST_Class, function(compressor, force) {\n            return is_strict(compressor, force) && !all(this.properties, function(prop) {\n                if (prop.private) return true;\n                if (!prop.static) return true;\n                return !(prop instanceof AST_ClassGetter || prop instanceof AST_ClassSetter);\n            });\n        });\n        def(AST_Conditional, function(compressor) {\n            return this.consequent._dot_throw(compressor) || this.alternative._dot_throw(compressor);\n        });\n        def(AST_Constant, return_false);\n        def(AST_Dot, function(compressor, force) {\n            if (!is_strict(compressor, force)) return false;\n            var exp = this.expression;\n            if (exp instanceof AST_SymbolRef) exp = exp.fixed_value();\n            return !(this.property == "prototype" && is_lambda(exp));\n        });\n        def(AST_Lambda, return_false);\n        def(AST_Null, return_true);\n        def(AST_Object, function(compressor, force) {\n            return is_strict(compressor, force) && !all(this.properties, function(prop) {\n                if (prop instanceof AST_ObjectGetter || prop instanceof AST_ObjectSetter) return false;\n                return !(prop.key === "__proto__" && prop.value._dot_throw(compressor, force));\n            });\n        });\n        def(AST_ObjectIdentity, function(compressor, force) {\n            return is_strict(compressor, force) && !this.scope.resolve().new;\n        });\n        def(AST_Sequence, function(compressor) {\n            return this.tail_node()._dot_throw(compressor);\n        });\n        def(AST_SymbolRef, function(compressor, force) {\n            if (this.defined) return false;\n            if (this.is_undefined) return true;\n            if (!is_strict(compressor, force)) return false;\n            if (is_undeclared_ref(this) && this.is_declared(compressor)) return false;\n            if (this.is_immutable()) return false;\n            var def = this.definition();\n            if (is_arguments(def) && !def.scope.rest && all(def.scope.argnames, function(argname) {\n                return argname instanceof AST_SymbolFunarg;\n            })) return def.scope.uses_arguments > 2;\n            var fixed = this.fixed_value(true);\n            if (!fixed) return true;\n            this._dot_throw = return_true;\n            if (fixed._dot_throw(compressor)) {\n                delete this._dot_throw;\n                return true;\n            }\n            this._dot_throw = return_false;\n            return false;\n        });\n        def(AST_UnaryPrefix, function() {\n            return this.operator == "void";\n        });\n        def(AST_UnaryPostfix, return_false);\n        def(AST_Undefined, return_true);\n    })(function(node, func) {\n        node.DEFMETHOD("_dot_throw", func);\n    });\n\n    (function(def) {\n        def(AST_Node, return_false);\n        def(AST_Array, return_true);\n        function is_binary_defined(compressor, op, node) {\n            switch (op) {\n              case "&&":\n                return node.left.is_defined(compressor) && node.right.is_defined(compressor);\n              case "||":\n                return node.left.is_truthy() || node.right.is_defined(compressor);\n              case "??":\n                return node.left.is_defined(compressor) || node.right.is_defined(compressor);\n              default:\n                return true;\n            }\n        }\n        def(AST_Assign, function(compressor) {\n            var op = this.operator;\n            if (op == "=") return this.right.is_defined(compressor);\n            return is_binary_defined(compressor, op.slice(0, -1), this);\n        });\n        def(AST_Binary, function(compressor) {\n            return is_binary_defined(compressor, this.operator, this);\n        });\n        def(AST_Conditional, function(compressor) {\n            return this.consequent.is_defined(compressor) && this.alternative.is_defined(compressor);\n        });\n        def(AST_Constant, return_true);\n        def(AST_Hole, return_false);\n        def(AST_Lambda, return_true);\n        def(AST_Object, return_true);\n        def(AST_Sequence, function(compressor) {\n            return this.tail_node().is_defined(compressor);\n        });\n        def(AST_SymbolRef, function(compressor) {\n            if (this.is_undefined) return false;\n            if (is_undeclared_ref(this) && this.is_declared(compressor)) return true;\n            if (this.is_immutable()) return true;\n            var fixed = this.fixed_value();\n            if (!fixed) return false;\n            this.is_defined = return_false;\n            var result = fixed.is_defined(compressor);\n            delete this.is_defined;\n            return result;\n        });\n        def(AST_UnaryPrefix, function() {\n            return this.operator != "void";\n        });\n        def(AST_UnaryPostfix, return_true);\n        def(AST_Undefined, return_false);\n    })(function(node, func) {\n        node.DEFMETHOD("is_defined", func);\n    });\n\n    /* -----[ boolean/negation helpers ]----- */\n\n    // methods to determine whether an expression has a boolean result type\n    (function(def) {\n        def(AST_Node, return_false);\n        def(AST_Assign, function(compressor) {\n            return this.operator == "=" && this.right.is_boolean(compressor);\n        });\n        var binary = makePredicate("in instanceof == != === !== < <= >= >");\n        def(AST_Binary, function(compressor) {\n            return binary[this.operator] || lazy_op[this.operator]\n                && this.left.is_boolean(compressor)\n                && this.right.is_boolean(compressor);\n        });\n        def(AST_Boolean, return_true);\n        var fn = makePredicate("every hasOwnProperty isPrototypeOf propertyIsEnumerable some");\n        def(AST_Call, function(compressor) {\n            if (!compressor.option("unsafe")) return false;\n            var exp = this.expression;\n            return exp instanceof AST_Dot && (fn[exp.property]\n                || exp.property == "test" && exp.expression instanceof AST_RegExp);\n        });\n        def(AST_Conditional, function(compressor) {\n            return this.consequent.is_boolean(compressor) && this.alternative.is_boolean(compressor);\n        });\n        def(AST_New, return_false);\n        def(AST_Sequence, function(compressor) {\n            return this.tail_node().is_boolean(compressor);\n        });\n        def(AST_SymbolRef, function(compressor) {\n            var fixed = this.fixed_value();\n            if (!fixed) return false;\n            this.is_boolean = return_false;\n            var result = fixed.is_boolean(compressor);\n            delete this.is_boolean;\n            return result;\n        });\n        var unary = makePredicate("! delete");\n        def(AST_UnaryPrefix, function() {\n            return unary[this.operator];\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("is_boolean", func);\n    });\n\n    // methods to determine if an expression has a numeric result type\n    (function(def) {\n        def(AST_Node, return_false);\n        var binary = makePredicate("- * / % ** & | ^ << >> >>>");\n        def(AST_Assign, function(compressor) {\n            return binary[this.operator.slice(0, -1)]\n                || this.operator == "=" && this.right.is_number(compressor);\n        });\n        def(AST_Binary, function(compressor) {\n            if (binary[this.operator]) return true;\n            if (this.operator != "+") return false;\n            return (this.left.is_boolean(compressor) || this.left.is_number(compressor))\n                && (this.right.is_boolean(compressor) || this.right.is_number(compressor));\n        });\n        var fn = makePredicate([\n            "charCodeAt",\n            "getDate",\n            "getDay",\n            "getFullYear",\n            "getHours",\n            "getMilliseconds",\n            "getMinutes",\n            "getMonth",\n            "getSeconds",\n            "getTime",\n            "getTimezoneOffset",\n            "getUTCDate",\n            "getUTCDay",\n            "getUTCFullYear",\n            "getUTCHours",\n            "getUTCMilliseconds",\n            "getUTCMinutes",\n            "getUTCMonth",\n            "getUTCSeconds",\n            "getYear",\n            "indexOf",\n            "lastIndexOf",\n            "localeCompare",\n            "push",\n            "search",\n            "setDate",\n            "setFullYear",\n            "setHours",\n            "setMilliseconds",\n            "setMinutes",\n            "setMonth",\n            "setSeconds",\n            "setTime",\n            "setUTCDate",\n            "setUTCFullYear",\n            "setUTCHours",\n            "setUTCMilliseconds",\n            "setUTCMinutes",\n            "setUTCMonth",\n            "setUTCSeconds",\n            "setYear",\n        ]);\n        def(AST_Call, function(compressor) {\n            if (!compressor.option("unsafe")) return false;\n            var exp = this.expression;\n            return exp instanceof AST_Dot && (fn[exp.property]\n                || is_undeclared_ref(exp.expression) && exp.expression.name == "Math");\n        });\n        def(AST_Conditional, function(compressor) {\n            return this.consequent.is_number(compressor) && this.alternative.is_number(compressor);\n        });\n        def(AST_New, return_false);\n        def(AST_Number, return_true);\n        def(AST_Sequence, function(compressor) {\n            return this.tail_node().is_number(compressor);\n        });\n        def(AST_SymbolRef, function(compressor, keep_unary) {\n            var fixed = this.fixed_value();\n            if (!fixed) return false;\n            if (keep_unary\n                && fixed instanceof AST_UnaryPrefix\n                && fixed.operator == "+"\n                && fixed.expression.equals(this)) {\n                return false;\n            }\n            this.is_number = return_false;\n            var result = fixed.is_number(compressor);\n            delete this.is_number;\n            return result;\n        });\n        var unary = makePredicate("+ - ~ ++ --");\n        def(AST_Unary, function() {\n            return unary[this.operator];\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("is_number", func);\n    });\n\n    // methods to determine if an expression has a string result type\n    (function(def) {\n        def(AST_Node, return_false);\n        def(AST_Assign, function(compressor) {\n            switch (this.operator) {\n              case "+=":\n                if (this.left.is_string(compressor)) return true;\n              case "=":\n                return this.right.is_string(compressor);\n            }\n        });\n        def(AST_Binary, function(compressor) {\n            return this.operator == "+" &&\n                (this.left.is_string(compressor) || this.right.is_string(compressor));\n        });\n        var fn = makePredicate([\n            "charAt",\n            "substr",\n            "substring",\n            "toExponential",\n            "toFixed",\n            "toLowerCase",\n            "toPrecision",\n            "toString",\n            "toUpperCase",\n            "trim",\n        ]);\n        def(AST_Call, function(compressor) {\n            if (!compressor.option("unsafe")) return false;\n            var exp = this.expression;\n            return exp instanceof AST_Dot && fn[exp.property];\n        });\n        def(AST_Conditional, function(compressor) {\n            return this.consequent.is_string(compressor) && this.alternative.is_string(compressor);\n        });\n        def(AST_Sequence, function(compressor) {\n            return this.tail_node().is_string(compressor);\n        });\n        def(AST_String, return_true);\n        def(AST_SymbolRef, function(compressor) {\n            var fixed = this.fixed_value();\n            if (!fixed) return false;\n            this.is_string = return_false;\n            var result = fixed.is_string(compressor);\n            delete this.is_string;\n            return result;\n        });\n        def(AST_Template, function(compressor) {\n            return !this.tag || is_raw_tag(compressor, this.tag);\n        });\n        def(AST_UnaryPrefix, function() {\n            return this.operator == "typeof";\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("is_string", func);\n    });\n\n    var lazy_op = makePredicate("&& || ??");\n\n    (function(def) {\n        function to_node(value, orig) {\n            if (value instanceof AST_Node) return value.clone(true);\n            if (Array.isArray(value)) return make_node(AST_Array, orig, {\n                elements: value.map(function(value) {\n                    return to_node(value, orig);\n                })\n            });\n            if (value && typeof value == "object") {\n                var props = [];\n                for (var key in value) if (HOP(value, key)) {\n                    props.push(make_node(AST_ObjectKeyVal, orig, {\n                        key: key,\n                        value: to_node(value[key], orig),\n                    }));\n                }\n                return make_node(AST_Object, orig, { properties: props });\n            }\n            return make_node_from_constant(value, orig);\n        }\n\n        function warn(node) {\n            AST_Node.warn("global_defs {this} redefined [{start}]", node);\n        }\n\n        AST_Toplevel.DEFMETHOD("resolve_defines", function(compressor) {\n            if (!compressor.option("global_defs")) return this;\n            this.figure_out_scope({ ie: compressor.option("ie") });\n            return this.transform(new TreeTransformer(function(node) {\n                var def = node._find_defs(compressor, "");\n                if (!def) return;\n                var level = 0, child = node, parent;\n                while (parent = this.parent(level++)) {\n                    if (!(parent instanceof AST_PropAccess)) break;\n                    if (parent.expression !== child) break;\n                    child = parent;\n                }\n                if (is_lhs(child, parent)) {\n                    warn(node);\n                    return;\n                }\n                return def;\n            }));\n        });\n        def(AST_Node, noop);\n        def(AST_Dot, function(compressor, suffix) {\n            return this.expression._find_defs(compressor, "." + this.property + suffix);\n        });\n        def(AST_SymbolDeclaration, function(compressor) {\n            if (!this.definition().global) return;\n            if (HOP(compressor.option("global_defs"), this.name)) warn(this);\n        });\n        def(AST_SymbolRef, function(compressor, suffix) {\n            if (!this.definition().global) return;\n            var defines = compressor.option("global_defs");\n            var name = this.name + suffix;\n            if (HOP(defines, name)) return to_node(defines[name], this);\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("_find_defs", func);\n    });\n\n    function best_of_expression(ast1, ast2, threshold) {\n        var delta = ast2.print_to_string().length - ast1.print_to_string().length;\n        return delta < (threshold || 0) ? ast2 : ast1;\n    }\n\n    function best_of_statement(ast1, ast2, threshold) {\n        return best_of_expression(make_node(AST_SimpleStatement, ast1, {\n            body: ast1,\n        }), make_node(AST_SimpleStatement, ast2, {\n            body: ast2,\n        }), threshold).body;\n    }\n\n    function best_of(compressor, ast1, ast2, threshold) {\n        return (first_in_statement(compressor) ? best_of_statement : best_of_expression)(ast1, ast2, threshold);\n    }\n\n    function convert_to_predicate(obj) {\n        var map = Object.create(null);\n        Object.keys(obj).forEach(function(key) {\n            map[key] = makePredicate(obj[key]);\n        });\n        return map;\n    }\n\n    function skip_directives(body) {\n        for (var i = 0; i < body.length; i++) {\n            var stat = body[i];\n            if (!(stat instanceof AST_Directive)) return stat;\n        }\n    }\n\n    function arrow_first_statement() {\n        if (this.value) return make_node(AST_Return, this.value, { value: this.value });\n        return skip_directives(this.body);\n    }\n    AST_Arrow.DEFMETHOD("first_statement", arrow_first_statement);\n    AST_AsyncArrow.DEFMETHOD("first_statement", arrow_first_statement);\n    AST_Lambda.DEFMETHOD("first_statement", function() {\n        return skip_directives(this.body);\n    });\n\n    AST_Lambda.DEFMETHOD("length", function() {\n        var argnames = this.argnames;\n        for (var i = 0; i < argnames.length; i++) {\n            if (argnames[i] instanceof AST_DefaultValue) break;\n        }\n        return i;\n    });\n\n    function try_evaluate(compressor, node) {\n        var ev = node.evaluate(compressor);\n        if (ev === node) return node;\n        ev = make_node_from_constant(ev, node).optimize(compressor);\n        return best_of(compressor, node, ev, compressor.eval_threshold);\n    }\n\n    var object_fns = [\n        "constructor",\n        "toString",\n        "valueOf",\n    ];\n    var native_fns = convert_to_predicate({\n        Array: [\n            "indexOf",\n            "join",\n            "lastIndexOf",\n            "slice",\n        ].concat(object_fns),\n        Boolean: object_fns,\n        Function: object_fns,\n        Number: [\n            "toExponential",\n            "toFixed",\n            "toPrecision",\n        ].concat(object_fns),\n        Object: object_fns,\n        RegExp: [\n            "exec",\n            "test",\n        ].concat(object_fns),\n        String: [\n            "charAt",\n            "charCodeAt",\n            "concat",\n            "indexOf",\n            "italics",\n            "lastIndexOf",\n            "match",\n            "replace",\n            "search",\n            "slice",\n            "split",\n            "substr",\n            "substring",\n            "toLowerCase",\n            "toUpperCase",\n            "trim",\n        ].concat(object_fns),\n    });\n    var static_fns = convert_to_predicate({\n        Array: [\n            "isArray",\n        ],\n        Math: [\n            "abs",\n            "acos",\n            "asin",\n            "atan",\n            "ceil",\n            "cos",\n            "exp",\n            "floor",\n            "log",\n            "round",\n            "sin",\n            "sqrt",\n            "tan",\n            "atan2",\n            "pow",\n            "max",\n            "min",\n        ],\n        Number: [\n            "isFinite",\n            "isNaN",\n        ],\n        Object: [\n            "create",\n            "getOwnPropertyDescriptor",\n            "getOwnPropertyNames",\n            "getPrototypeOf",\n            "isExtensible",\n            "isFrozen",\n            "isSealed",\n            "keys",\n        ],\n        String: [\n            "fromCharCode",\n            "raw",\n        ],\n    });\n\n    function is_static_fn(node) {\n        if (!(node instanceof AST_Dot)) return false;\n        var expr = node.expression;\n        if (!is_undeclared_ref(expr)) return false;\n        var static_fn = static_fns[expr.name];\n        return static_fn && (static_fn[node.property] || expr.name == "Math" && node.property == "random");\n    }\n\n    // Accommodate when compress option evaluate=false\n    // as well as the common constant expressions !0 and -1\n    (function(def) {\n        def(AST_Node, return_false);\n        def(AST_Constant, return_true);\n        def(AST_RegExp, return_false);\n        var unaryPrefix = makePredicate("! ~ - + void");\n        def(AST_UnaryPrefix, function() {\n            return unaryPrefix[this.operator] && this.expression instanceof AST_Constant;\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("is_constant", func);\n    });\n\n    // methods to evaluate a constant expression\n    (function(def) {\n        // If the node has been successfully reduced to a constant,\n        // then its value is returned; otherwise the element itself\n        // is returned.\n        //\n        // They can be distinguished as constant value is never a\n        // descendant of AST_Node.\n        //\n        // When `ignore_side_effects` is `true`, inspect the constant value\n        // produced without worrying about any side effects caused by said\n        // expression.\n        AST_Node.DEFMETHOD("evaluate", function(compressor, ignore_side_effects) {\n            if (!compressor.option("evaluate")) return this;\n            var cached = [];\n            var val = this._eval(compressor, ignore_side_effects, cached, 1);\n            cached.forEach(function(node) {\n                delete node._eval;\n            });\n            if (ignore_side_effects) return val;\n            if (!val || val instanceof RegExp) return val;\n            if (typeof val == "function" || typeof val == "object") return this;\n            return val;\n        });\n        var scan_modified = new TreeWalker(function(node) {\n            if (node instanceof AST_Assign) modified(node.left);\n            if (node instanceof AST_ForEnumeration) modified(node.init);\n            if (node instanceof AST_Unary && UNARY_POSTFIX[node.operator]) modified(node.expression);\n        });\n        function modified(node) {\n            if (node instanceof AST_DestructuredArray) {\n                node.elements.forEach(modified);\n            } else if (node instanceof AST_DestructuredObject) {\n                node.properties.forEach(function(prop) {\n                    modified(prop.value);\n                });\n            } else if (node instanceof AST_PropAccess) {\n                modified(node.expression);\n            } else if (node instanceof AST_SymbolRef) {\n                node.definition().references.forEach(function(ref) {\n                    delete ref._eval;\n                });\n            }\n        }\n        def(AST_Statement, function() {\n            throw new Error(string_template("Cannot evaluate a statement [{start}]", this));\n        });\n        def(AST_Accessor, return_this);\n        def(AST_BigInt, return_this);\n        def(AST_Class, return_this);\n        def(AST_Node, return_this);\n        def(AST_Constant, function() {\n            return this.value;\n        });\n        def(AST_Assign, function(compressor, ignore_side_effects, cached, depth) {\n            var lhs = this.left;\n            if (!ignore_side_effects) {\n                if (!(lhs instanceof AST_SymbolRef)) return this;\n                if (!HOP(lhs, "_eval")) {\n                    if (!lhs.fixed) return this;\n                    var def = lhs.definition();\n                    if (!def.fixed) return this;\n                    if (def.undeclared) return this;\n                    if (def.last_ref !== lhs) return this;\n                    if (def.single_use == "m") return this;\n                    if (this.right.has_side_effects(compressor)) return this;\n                }\n            }\n            var op = this.operator;\n            var node;\n            if (!HOP(lhs, "_eval") && lhs instanceof AST_SymbolRef && lhs.fixed && lhs.definition().fixed) {\n                node = lhs;\n            } else if (op == "=") {\n                node = this.right;\n            } else {\n                node = make_node(AST_Binary, this, {\n                    operator: op.slice(0, -1),\n                    left: lhs,\n                    right: this.right,\n                });\n            }\n            lhs.walk(scan_modified);\n            var value = node._eval(compressor, ignore_side_effects, cached, depth);\n            if (typeof value == "object") return this;\n            modified(lhs);\n            return value;\n        });\n        def(AST_Sequence, function(compressor, ignore_side_effects, cached, depth) {\n            if (!ignore_side_effects) return this;\n            var exprs = this.expressions;\n            for (var i = 0, last = exprs.length - 1; i < last; i++) {\n                exprs[i].walk(scan_modified);\n            }\n            var tail = exprs[last];\n            var value = tail._eval(compressor, ignore_side_effects, cached, depth);\n            return value === tail ? this : value;\n        });\n        def(AST_Lambda, function(compressor) {\n            if (compressor.option("unsafe")) {\n                var fn = function() {};\n                fn.node = this;\n                fn.toString = function() {\n                    return "function(){}";\n                };\n                return fn;\n            }\n            return this;\n        });\n        def(AST_Array, function(compressor, ignore_side_effects, cached, depth) {\n            if (compressor.option("unsafe")) {\n                var elements = [];\n                for (var i = 0; i < this.elements.length; i++) {\n                    var element = this.elements[i];\n                    if (element instanceof AST_Hole) return this;\n                    var value = element._eval(compressor, ignore_side_effects, cached, depth);\n                    if (element === value) return this;\n                    elements.push(value);\n                }\n                return elements;\n            }\n            return this;\n        });\n        def(AST_Object, function(compressor, ignore_side_effects, cached, depth) {\n            if (compressor.option("unsafe")) {\n                var val = {};\n                for (var i = 0; i < this.properties.length; i++) {\n                    var prop = this.properties[i];\n                    if (!(prop instanceof AST_ObjectKeyVal)) return this;\n                    var key = prop.key;\n                    if (key instanceof AST_Node) {\n                        key = key._eval(compressor, ignore_side_effects, cached, depth);\n                        if (key === prop.key) return this;\n                    }\n                    switch (key) {\n                      case "__proto__":\n                      case "toString":\n                      case "valueOf":\n                        return this;\n                    }\n                    val[key] = prop.value._eval(compressor, ignore_side_effects, cached, depth);\n                    if (val[key] === prop.value) return this;\n                }\n                return val;\n            }\n            return this;\n        });\n        var non_converting_unary = makePredicate("! typeof void");\n        def(AST_UnaryPrefix, function(compressor, ignore_side_effects, cached, depth) {\n            var e = this.expression;\n            var op = this.operator;\n            // Function would be evaluated to an array and so typeof would\n            // incorrectly return "object". Hence making is a special case.\n            if (compressor.option("typeofs")\n                && op == "typeof"\n                && (e instanceof AST_Lambda\n                    || e instanceof AST_SymbolRef\n                        && e.fixed_value() instanceof AST_Lambda)) {\n                return typeof function(){};\n            }\n            var def = e instanceof AST_SymbolRef && e.definition();\n            if (!non_converting_unary[op] && !(def && def.fixed)) depth++;\n            e.walk(scan_modified);\n            var v = e._eval(compressor, ignore_side_effects, cached, depth);\n            if (v === e) {\n                if (ignore_side_effects && op == "void") return;\n                return this;\n            }\n            switch (op) {\n              case "!": return !v;\n              case "typeof":\n                // typeof <RegExp> returns "object" or "function" on different platforms\n                // so cannot evaluate reliably\n                if (v instanceof RegExp) return this;\n                return typeof v;\n              case "void": return;\n              case "~": return ~v;\n              case "-": return -v;\n              case "+": return +v;\n              case "++":\n              case "--":\n                if (!def) return this;\n                if (!ignore_side_effects) {\n                    if (def.undeclared) return this;\n                    if (def.last_ref !== e) return this;\n                }\n                if (HOP(e, "_eval")) v = +(op[0] + 1) + +v;\n                modified(e);\n                return v;\n            }\n            return this;\n        });\n        def(AST_UnaryPostfix, function(compressor, ignore_side_effects, cached, depth) {\n            var e = this.expression;\n            if (!(e instanceof AST_SymbolRef)) {\n                if (!ignore_side_effects) return this;\n            } else if (!HOP(e, "_eval")) {\n                if (!e.fixed) return this;\n                if (!ignore_side_effects) {\n                    var def = e.definition();\n                    if (!def.fixed) return this;\n                    if (def.undeclared) return this;\n                    if (def.last_ref !== e) return this;\n                }\n            }\n            if (!(e instanceof AST_SymbolRef && e.definition().fixed)) depth++;\n            e.walk(scan_modified);\n            var v = e._eval(compressor, ignore_side_effects, cached, depth);\n            if (v === e) return this;\n            modified(e);\n            return +v;\n        });\n        var non_converting_binary = makePredicate("&& || === !==");\n        def(AST_Binary, function(compressor, ignore_side_effects, cached, depth) {\n            if (!non_converting_binary[this.operator]) depth++;\n            var left = this.left._eval(compressor, ignore_side_effects, cached, depth);\n            if (left === this.left) return this;\n            if (this.operator == (left ? "||" : "&&")) return left;\n            var rhs_ignore_side_effects = ignore_side_effects && !(left && typeof left == "object");\n            var right = this.right._eval(compressor, rhs_ignore_side_effects, cached, depth);\n            if (right === this.right) return this;\n            var result;\n            switch (this.operator) {\n              case "&&" : result = left &&  right; break;\n              case "||" : result = left ||  right; break;\n              case "??" :\n                result = left == null ? right : left;\n                break;\n              case "|"  : result = left |   right; break;\n              case "&"  : result = left &   right; break;\n              case "^"  : result = left ^   right; break;\n              case "+"  : result = left +   right; break;\n              case "-"  : result = left -   right; break;\n              case "*"  : result = left *   right; break;\n              case "/"  : result = left /   right; break;\n              case "%"  : result = left %   right; break;\n              case "<<" : result = left <<  right; break;\n              case ">>" : result = left >>  right; break;\n              case ">>>": result = left >>> right; break;\n              case "==" : result = left ==  right; break;\n              case "===": result = left === right; break;\n              case "!=" : result = left !=  right; break;\n              case "!==": result = left !== right; break;\n              case "<"  : result = left <   right; break;\n              case "<=" : result = left <=  right; break;\n              case ">"  : result = left >   right; break;\n              case ">=" : result = left >=  right; break;\n              case "**":\n                result = Math.pow(left, right);\n                break;\n              case "in":\n                if (right && typeof right == "object" && HOP(right, left)) {\n                    result = true;\n                    break;\n                }\n              default:\n                return this;\n            }\n            if (isNaN(result)) return compressor.find_parent(AST_With) ? this : result;\n            if (compressor.option("unsafe_math")\n                && !ignore_side_effects\n                && result\n                && typeof result == "number"\n                && (this.operator == "+" || this.operator == "-")) {\n                var digits = Math.max(0, decimals(left), decimals(right));\n                // 53-bit significand ---\x3e 15.95 decimal places\n                if (digits < 16) return +result.toFixed(digits);\n            }\n            return result;\n\n            function decimals(operand) {\n                var match = /(\\.[0-9]*)?(e[^e]+)?$/.exec(+operand);\n                return (match[1] || ".").length - 1 - (match[2] || "").slice(1);\n            }\n        });\n        def(AST_Conditional, function(compressor, ignore_side_effects, cached, depth) {\n            var condition = this.condition._eval(compressor, ignore_side_effects, cached, depth);\n            if (condition === this.condition) return this;\n            var node = condition ? this.consequent : this.alternative;\n            var value = node._eval(compressor, ignore_side_effects, cached, depth);\n            return value === node ? this : value;\n        });\n        function verify_escaped(ref, depth) {\n            var escaped = ref.definition().escaped;\n            switch (escaped.length) {\n              case 0:\n                return true;\n              case 1:\n                var found = false;\n                escaped[0].walk(new TreeWalker(function(node) {\n                    if (found) return true;\n                    if (node === ref) return found = true;\n                    if (node instanceof AST_Scope) return true;\n                }));\n                return found;\n              default:\n                return depth <= escaped.depth;\n            }\n        }\n        def(AST_SymbolRef, function(compressor, ignore_side_effects, cached, depth) {\n            this._eval = return_this;\n            try {\n                var fixed = this.fixed_value();\n                if (!fixed) return this;\n                var value;\n                if (HOP(fixed, "_eval")) {\n                    value = fixed._eval();\n                } else {\n                    value = fixed._eval(compressor, ignore_side_effects, cached, depth);\n                    if (value === fixed) return this;\n                    fixed._eval = function() {\n                        return value;\n                    };\n                    cached.push(fixed);\n                }\n                return value && typeof value == "object" && !verify_escaped(this, depth) ? this : value;\n            } finally {\n                delete this._eval;\n            }\n        });\n        var global_objs = {\n            Array: Array,\n            Math: Math,\n            Number: Number,\n            Object: Object,\n            String: String,\n        };\n        var static_values = convert_to_predicate({\n            Math: [\n                "E",\n                "LN10",\n                "LN2",\n                "LOG2E",\n                "LOG10E",\n                "PI",\n                "SQRT1_2",\n                "SQRT2",\n            ],\n            Number: [\n                "MAX_VALUE",\n                "MIN_VALUE",\n                "NaN",\n                "NEGATIVE_INFINITY",\n                "POSITIVE_INFINITY",\n            ],\n        });\n        var regexp_props = makePredicate("global ignoreCase multiline source");\n        def(AST_PropAccess, function(compressor, ignore_side_effects, cached, depth) {\n            if (compressor.option("unsafe")) {\n                var val;\n                var exp = this.expression;\n                if (!is_undeclared_ref(exp)) {\n                    val = exp._eval(compressor, ignore_side_effects, cached, depth + 1);\n                    if (val == null || val === exp) return this;\n                }\n                var key = this.property;\n                if (key instanceof AST_Node) {\n                    key = key._eval(compressor, ignore_side_effects, cached, depth);\n                    if (key === this.property) return this;\n                }\n                if (val === undefined) {\n                    var static_value = static_values[exp.name];\n                    if (!static_value || !static_value[key]) return this;\n                    val = global_objs[exp.name];\n                } else if (val instanceof RegExp) {\n                    if (!regexp_props[key]) return this;\n                } else if (typeof val == "object") {\n                    if (!HOP(val, key)) return this;\n                } else if (typeof val == "function") switch (key) {\n                  case "name":\n                    return val.node.name ? val.node.name.name : "";\n                  case "length":\n                    return val.node.length();\n                  default:\n                    return this;\n                }\n                return val[key];\n            }\n            return this;\n        });\n        function eval_all(nodes, compressor, ignore_side_effects, cached, depth) {\n            var values = [];\n            for (var i = 0; i < nodes.length; i++) {\n                var node = nodes[i];\n                var value = node._eval(compressor, ignore_side_effects, cached, depth);\n                if (node === value) return;\n                values.push(value);\n            }\n            return values;\n        }\n        def(AST_Call, function(compressor, ignore_side_effects, cached, depth) {\n            var exp = this.expression;\n            var fn = exp instanceof AST_SymbolRef ? exp.fixed_value() : exp;\n            if (fn instanceof AST_Arrow || fn instanceof AST_Defun || fn instanceof AST_Function) {\n                if (fn.evaluating) return this;\n                if (fn.name && fn.name.definition().recursive_refs > 0) return this;\n                if (this.is_expr_pure(compressor)) return this;\n                var args = eval_all(this.args, compressor, ignore_side_effects, cached, depth);\n                if (!all(fn.argnames, function(sym, index) {\n                    if (sym instanceof AST_DefaultValue) {\n                        if (!args) return false;\n                        if (args[index] === undefined) {\n                            var value = sym.value._eval(compressor, ignore_side_effects, cached, depth);\n                            if (value === sym.value) return false;\n                            args[index] = value;\n                        }\n                        sym = sym.name;\n                    }\n                    return !(sym instanceof AST_Destructured);\n                })) return this;\n                if (fn.rest instanceof AST_Destructured) return this;\n                if (!args && !ignore_side_effects) return this;\n                var stat = fn.first_statement();\n                if (!(stat instanceof AST_Return)) {\n                    if (ignore_side_effects) {\n                        fn.walk(scan_modified);\n                        var found = false;\n                        fn.evaluating = true;\n                        walk_body(fn, new TreeWalker(function(node) {\n                            if (found) return true;\n                            if (node instanceof AST_Return) {\n                                if (node.value && node.value._eval(compressor, true, cached, depth) !== undefined) {\n                                    found = true;\n                                }\n                                return true;\n                            }\n                            if (node instanceof AST_Scope && node !== fn) return true;\n                        }));\n                        fn.evaluating = false;\n                        if (!found) return;\n                    }\n                    return this;\n                }\n                var val = stat.value;\n                if (!val) return;\n                var cached_args = [];\n                if (!args || all(fn.argnames, function(sym, i) {\n                    return assign(sym, args[i]);\n                }) && !(fn.rest && !assign(fn.rest, args.slice(fn.argnames.length))) || ignore_side_effects) {\n                    if (ignore_side_effects) fn.argnames.forEach(function(sym) {\n                        if (sym instanceof AST_DefaultValue) sym.value.walk(scan_modified);\n                    });\n                    fn.evaluating = true;\n                    val = val._eval(compressor, ignore_side_effects, cached, depth);\n                    fn.evaluating = false;\n                }\n                cached_args.forEach(function(node) {\n                    delete node._eval;\n                });\n                return val === stat.value ? this : val;\n            } else if (compressor.option("unsafe") && exp instanceof AST_PropAccess) {\n                var key = exp.property;\n                if (key instanceof AST_Node) {\n                    key = key._eval(compressor, ignore_side_effects, cached, depth);\n                    if (key === exp.property) return this;\n                }\n                var val;\n                var e = exp.expression;\n                if (is_undeclared_ref(e)) {\n                    var static_fn = static_fns[e.name];\n                    if (!static_fn || !static_fn[key]) return this;\n                    val = global_objs[e.name];\n                } else {\n                    val = e._eval(compressor, ignore_side_effects, cached, depth + 1);\n                    if (val == null || val === e) return this;\n                    var native_fn = native_fns[val.constructor.name];\n                    if (!native_fn || !native_fn[key]) return this;\n                    if (val instanceof RegExp && val.global && !(e instanceof AST_RegExp)) return this;\n                }\n                var args = eval_all(this.args, compressor, ignore_side_effects, cached, depth);\n                if (!args) return this;\n                if (key == "replace" && typeof args[1] == "function") return this;\n                try {\n                    return val[key].apply(val, args);\n                } catch (ex) {\n                    AST_Node.warn("Error evaluating {this} [{start}]", this);\n                } finally {\n                    if (val instanceof RegExp) val.lastIndex = 0;\n                }\n            }\n            return this;\n\n            function assign(sym, arg) {\n                if (sym instanceof AST_DefaultValue) sym = sym.name;\n                var def = sym.definition();\n                if (def.orig[def.orig.length - 1] !== sym) return false;\n                var value = arg;\n                def.references.forEach(function(node) {\n                    node._eval = function() {\n                        return value;\n                    };\n                    cached_args.push(node);\n                });\n                return true;\n            }\n        });\n        def(AST_New, return_this);\n        def(AST_Template, function(compressor, ignore_side_effects, cached, depth) {\n            if (!compressor.option("templates")) return this;\n            if (this.tag) {\n                if (!is_raw_tag(compressor, this.tag)) return this;\n                decode = function(str) {\n                    return str;\n                };\n            }\n            var exprs = eval_all(this.expressions, compressor, ignore_side_effects, cached, depth);\n            if (!exprs) return this;\n            var malformed = false;\n            var ret = decode(this.strings[0]);\n            for (var i = 0; i < exprs.length; i++) {\n                ret += exprs[i] + decode(this.strings[i + 1]);\n            }\n            if (!malformed) return ret;\n            this._eval = return_this;\n            return this;\n\n            function decode(str) {\n                str = decode_template(str);\n                if (typeof str != "string") malformed = true;\n                return str;\n            }\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("_eval", func);\n    });\n\n    // method to negate an expression\n    (function(def) {\n        function basic_negation(exp) {\n            return make_node(AST_UnaryPrefix, exp, {\n                operator: "!",\n                expression: exp,\n            });\n        }\n        function best(orig, alt, first_in_statement) {\n            var negated = basic_negation(orig);\n            if (first_in_statement) return best_of_expression(negated, make_node(AST_SimpleStatement, alt, {\n                body: alt,\n            })) === negated ? negated : alt;\n            return best_of_expression(negated, alt);\n        }\n        def(AST_Node, function() {\n            return basic_negation(this);\n        });\n        def(AST_Statement, function() {\n            throw new Error("Cannot negate a statement");\n        });\n        def(AST_Binary, function(compressor, first_in_statement) {\n            var self = this.clone(), op = this.operator;\n            if (compressor.option("unsafe_comps")) {\n                switch (op) {\n                  case "<=" : self.operator = ">"  ; return self;\n                  case "<"  : self.operator = ">=" ; return self;\n                  case ">=" : self.operator = "<"  ; return self;\n                  case ">"  : self.operator = "<=" ; return self;\n                }\n            }\n            switch (op) {\n              case "==" : self.operator = "!="; return self;\n              case "!=" : self.operator = "=="; return self;\n              case "===": self.operator = "!=="; return self;\n              case "!==": self.operator = "==="; return self;\n              case "&&":\n                self.operator = "||";\n                self.left = self.left.negate(compressor, first_in_statement);\n                self.right = self.right.negate(compressor);\n                return best(this, self, first_in_statement);\n              case "||":\n                self.operator = "&&";\n                self.left = self.left.negate(compressor, first_in_statement);\n                self.right = self.right.negate(compressor);\n                return best(this, self, first_in_statement);\n            }\n            return basic_negation(this);\n        });\n        def(AST_ClassExpression, function() {\n            return basic_negation(this);\n        });\n        def(AST_Conditional, function(compressor, first_in_statement) {\n            var self = this.clone();\n            self.consequent = self.consequent.negate(compressor);\n            self.alternative = self.alternative.negate(compressor);\n            return best(this, self, first_in_statement);\n        });\n        def(AST_LambdaExpression, function() {\n            return basic_negation(this);\n        });\n        def(AST_Sequence, function(compressor) {\n            var expressions = this.expressions.slice();\n            expressions.push(expressions.pop().negate(compressor));\n            return make_sequence(this, expressions);\n        });\n        def(AST_UnaryPrefix, function() {\n            if (this.operator == "!")\n                return this.expression;\n            return basic_negation(this);\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("negate", function(compressor, first_in_statement) {\n            return func.call(this, compressor, first_in_statement);\n        });\n    });\n\n    var global_pure_fns = makePredicate("Boolean decodeURI decodeURIComponent Date encodeURI encodeURIComponent Error escape EvalError isFinite isNaN Number Object parseFloat parseInt RangeError ReferenceError String SyntaxError TypeError unescape URIError");\n    var global_pure_constructors = makePredicate("Map Set WeakMap WeakSet");\n    AST_Call.DEFMETHOD("is_expr_pure", function(compressor) {\n        if (compressor.option("unsafe")) {\n            var expr = this.expression;\n            if (is_undeclared_ref(expr)) {\n                if (global_pure_fns[expr.name]) return true;\n                if (this instanceof AST_New && global_pure_constructors[expr.name]) return true;\n            }\n            if (is_static_fn(expr)) return true;\n        }\n        return compressor.option("annotations") && this.pure || !compressor.pure_funcs(this);\n    });\n    AST_Template.DEFMETHOD("is_expr_pure", function(compressor) {\n        var tag = this.tag;\n        if (!tag) return true;\n        if (compressor.option("unsafe")) {\n            if (is_undeclared_ref(tag) && global_pure_fns[tag.name]) return true;\n            if (tag instanceof AST_Dot && is_undeclared_ref(tag.expression)) {\n                var static_fn = static_fns[tag.expression.name];\n                return static_fn && (static_fn[tag.property]\n                    || tag.expression.name == "Math" && tag.property == "random");\n            }\n        }\n        return !compressor.pure_funcs(this);\n    });\n    AST_Node.DEFMETHOD("is_call_pure", return_false);\n    AST_Call.DEFMETHOD("is_call_pure", function(compressor) {\n        if (!compressor.option("unsafe")) return false;\n        var dot = this.expression;\n        if (!(dot instanceof AST_Dot)) return false;\n        var exp = dot.expression;\n        var map;\n        var prop = dot.property;\n        if (exp instanceof AST_Array) {\n            map = native_fns.Array;\n        } else if (exp.is_boolean(compressor)) {\n            map = native_fns.Boolean;\n        } else if (exp.is_number(compressor)) {\n            map = native_fns.Number;\n        } else if (exp instanceof AST_RegExp) {\n            map = native_fns.RegExp;\n        } else if (exp.is_string(compressor)) {\n            map = native_fns.String;\n            if (prop == "replace") {\n                var arg = this.args[1];\n                if (arg && !arg.is_string(compressor)) return false;\n            }\n        } else if (!dot.may_throw_on_access(compressor)) {\n            map = native_fns.Object;\n        }\n        return map && map[prop];\n    });\n\n    // determine if object spread syntax may cause runtime exception\n    (function(def) {\n        def(AST_Node, return_false);\n        def(AST_Array, return_true);\n        def(AST_Assign, function() {\n            switch (this.operator) {\n              case "=":\n                return this.right.safe_to_spread();\n              case "&&=":\n              case "||=":\n              case "??=":\n                return this.left.safe_to_spread() && this.right.safe_to_spread();\n            }\n            return true;\n        });\n        def(AST_Binary, function() {\n            return !lazy_op[this.operator] || this.left.safe_to_spread() && this.right.safe_to_spread();\n        });\n        def(AST_Constant, return_true);\n        def(AST_Lambda, return_true);\n        def(AST_Object, function() {\n            return all(this.properties, function(prop) {\n                return !(prop instanceof AST_ObjectGetter || prop instanceof AST_Spread);\n            });\n        });\n        def(AST_Sequence, function() {\n            return this.tail_node().safe_to_spread();\n        });\n        def(AST_SymbolRef, function() {\n            var fixed = this.fixed_value();\n            return fixed && fixed.safe_to_spread();\n        });\n        def(AST_Unary, return_true);\n    })(function(node, func) {\n        node.DEFMETHOD("safe_to_spread", func);\n    });\n\n    // determine if expression has side effects\n    (function(def) {\n        function any(list, compressor, spread) {\n            return !all(list, spread ? function(node) {\n                return node instanceof AST_Spread ? !spread(node, compressor) : !node.has_side_effects(compressor);\n            } : function(node) {\n                return !node.has_side_effects(compressor);\n            });\n        }\n        function array_spread(node, compressor) {\n            var exp = node.expression;\n            return !exp.is_string(compressor) || exp.has_side_effects(compressor);\n        }\n        def(AST_Node, return_true);\n        def(AST_Array, function(compressor) {\n            return any(this.elements, compressor, array_spread);\n        });\n        def(AST_Assign, function(compressor) {\n            var lhs = this.left;\n            if (!(lhs instanceof AST_PropAccess)) return true;\n            var node = lhs.expression;\n            return !(node instanceof AST_ObjectIdentity)\n                || !node.scope.resolve().new\n                || lhs instanceof AST_Sub && lhs.property.has_side_effects(compressor)\n                || this.right.has_side_effects(compressor);\n        });\n        def(AST_Binary, function(compressor) {\n            return this.left.has_side_effects(compressor)\n                || this.right.has_side_effects(compressor)\n                || !can_drop_op(this, compressor);\n        });\n        def(AST_Block, function(compressor) {\n            return any(this.body, compressor);\n        });\n        def(AST_Call, function(compressor) {\n            if (!this.is_expr_pure(compressor)\n                && (!this.is_call_pure(compressor) || this.expression.has_side_effects(compressor))) {\n                return true;\n            }\n            return any(this.args, compressor, array_spread);\n        });\n        def(AST_Case, function(compressor) {\n            return this.expression.has_side_effects(compressor)\n                || any(this.body, compressor);\n        });\n        def(AST_Class, function(compressor) {\n            var base = this.extends;\n            if (base) {\n                if (base instanceof AST_SymbolRef) base = base.fixed_value();\n                if (!safe_for_extends(base)) return true;\n            }\n            return any(this.properties, compressor);\n        });\n        def(AST_ClassProperty, function(compressor) {\n            return this.key instanceof AST_Node && this.key.has_side_effects(compressor)\n                || this.static && this.value && this.value.has_side_effects(compressor);\n        });\n        def(AST_Conditional, function(compressor) {\n            return this.condition.has_side_effects(compressor)\n                || this.consequent.has_side_effects(compressor)\n                || this.alternative.has_side_effects(compressor);\n        });\n        def(AST_Constant, return_false);\n        def(AST_Definitions, function(compressor) {\n            return any(this.definitions, compressor);\n        });\n        def(AST_DestructuredArray, function(compressor) {\n            return any(this.elements, compressor);\n        });\n        def(AST_DestructuredKeyVal, function(compressor) {\n            return this.key instanceof AST_Node && this.key.has_side_effects(compressor)\n                || this.value.has_side_effects(compressor);\n        });\n        def(AST_DestructuredObject, function(compressor) {\n            return any(this.properties, compressor);\n        });\n        def(AST_Dot, function(compressor) {\n            return this.expression.may_throw_on_access(compressor)\n                || this.expression.has_side_effects(compressor);\n        });\n        def(AST_EmptyStatement, return_false);\n        def(AST_If, function(compressor) {\n            return this.condition.has_side_effects(compressor)\n                || this.body && this.body.has_side_effects(compressor)\n                || this.alternative && this.alternative.has_side_effects(compressor);\n        });\n        def(AST_LabeledStatement, function(compressor) {\n            return this.body.has_side_effects(compressor);\n        });\n        def(AST_Lambda, return_false);\n        def(AST_Object, function(compressor) {\n            return any(this.properties, compressor, function(node, compressor) {\n                var exp = node.expression;\n                return !exp.safe_to_spread() || exp.has_side_effects(compressor);\n            });\n        });\n        def(AST_ObjectIdentity, return_false);\n        def(AST_ObjectProperty, function(compressor) {\n            return this.key instanceof AST_Node && this.key.has_side_effects(compressor)\n                || this.value.has_side_effects(compressor);\n        });\n        def(AST_Sequence, function(compressor) {\n            return any(this.expressions, compressor);\n        });\n        def(AST_SimpleStatement, function(compressor) {\n            return this.body.has_side_effects(compressor);\n        });\n        def(AST_Sub, function(compressor) {\n            return this.expression.may_throw_on_access(compressor)\n                || this.expression.has_side_effects(compressor)\n                || this.property.has_side_effects(compressor);\n        });\n        def(AST_Switch, function(compressor) {\n            return this.expression.has_side_effects(compressor)\n                || any(this.body, compressor);\n        });\n        def(AST_SymbolDeclaration, return_false);\n        def(AST_SymbolRef, function(compressor) {\n            return !this.is_declared(compressor) || !can_drop_symbol(this, compressor);\n        });\n        def(AST_Template, function(compressor) {\n            return !this.is_expr_pure(compressor) || any(this.expressions, compressor);\n        });\n        def(AST_Try, function(compressor) {\n            return any(this.body, compressor)\n                || this.bcatch && this.bcatch.has_side_effects(compressor)\n                || this.bfinally && this.bfinally.has_side_effects(compressor);\n        });\n        def(AST_Unary, function(compressor) {\n            return unary_side_effects[this.operator]\n                || this.expression.has_side_effects(compressor);\n        });\n        def(AST_VarDef, function() {\n            return this.value;\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("has_side_effects", func);\n    });\n\n    // determine if expression may throw\n    (function(def) {\n        def(AST_Node, return_true);\n\n        def(AST_Constant, return_false);\n        def(AST_EmptyStatement, return_false);\n        def(AST_Lambda, return_false);\n        def(AST_ObjectIdentity, return_false);\n        def(AST_SymbolDeclaration, return_false);\n\n        function any(list, compressor) {\n            for (var i = list.length; --i >= 0;)\n                if (list[i].may_throw(compressor))\n                    return true;\n            return false;\n        }\n\n        function call_may_throw(exp, compressor) {\n            if (exp.may_throw(compressor)) return true;\n            if (exp instanceof AST_SymbolRef) exp = exp.fixed_value();\n            if (!(exp instanceof AST_Lambda)) return true;\n            if (any(exp.argnames, compressor)) return true;\n            if (any(exp.body, compressor)) return true;\n            return is_arrow(exp) && exp.value && exp.value.may_throw(compressor);\n        }\n\n        def(AST_Array, function(compressor) {\n            return any(this.elements, compressor);\n        });\n        def(AST_Assign, function(compressor) {\n            if (this.right.may_throw(compressor)) return true;\n            if (!compressor.has_directive("use strict")\n                && this.operator == "="\n                && this.left instanceof AST_SymbolRef) {\n                return false;\n            }\n            return this.left.may_throw(compressor);\n        });\n        def(AST_Await, function(compressor) {\n            return this.expression.may_throw(compressor);\n        });\n        def(AST_Binary, function(compressor) {\n            return this.left.may_throw(compressor)\n                || this.right.may_throw(compressor)\n                || !can_drop_op(this, compressor);\n        });\n        def(AST_Block, function(compressor) {\n            return any(this.body, compressor);\n        });\n        def(AST_Call, function(compressor) {\n            if (any(this.args, compressor)) return true;\n            if (this.is_expr_pure(compressor)) return false;\n            this.may_throw = return_true;\n            var ret = call_may_throw(this.expression, compressor);\n            delete this.may_throw;\n            return ret;\n        });\n        def(AST_Case, function(compressor) {\n            return this.expression.may_throw(compressor)\n                || any(this.body, compressor);\n        });\n        def(AST_Conditional, function(compressor) {\n            return this.condition.may_throw(compressor)\n                || this.consequent.may_throw(compressor)\n                || this.alternative.may_throw(compressor);\n        });\n        def(AST_DefaultValue, function(compressor) {\n            return this.name.may_throw(compressor)\n                || this.value && this.value.may_throw(compressor);\n        });\n        def(AST_Definitions, function(compressor) {\n            return any(this.definitions, compressor);\n        });\n        def(AST_Dot, function(compressor) {\n            return !this.optional && this.expression.may_throw_on_access(compressor)\n                || this.expression.may_throw(compressor);\n        });\n        def(AST_ForEnumeration, function(compressor) {\n            if (this.init.may_throw(compressor)) return true;\n            var obj = this.object;\n            if (obj.may_throw(compressor)) return true;\n            obj = obj.tail_node();\n            if (!(obj instanceof AST_Array || obj.is_string(compressor))) return true;\n            return this.body.may_throw(compressor);\n        });\n        def(AST_If, function(compressor) {\n            return this.condition.may_throw(compressor)\n                || this.body && this.body.may_throw(compressor)\n                || this.alternative && this.alternative.may_throw(compressor);\n        });\n        def(AST_LabeledStatement, function(compressor) {\n            return this.body.may_throw(compressor);\n        });\n        def(AST_Object, function(compressor) {\n            return any(this.properties, compressor);\n        });\n        def(AST_ObjectProperty, function(compressor) {\n            return this.value.may_throw(compressor)\n                || this.key instanceof AST_Node && this.key.may_throw(compressor);\n        });\n        def(AST_Return, function(compressor) {\n            return this.value && this.value.may_throw(compressor);\n        });\n        def(AST_Sequence, function(compressor) {\n            return any(this.expressions, compressor);\n        });\n        def(AST_SimpleStatement, function(compressor) {\n            return this.body.may_throw(compressor);\n        });\n        def(AST_Sub, function(compressor) {\n            return !this.optional && this.expression.may_throw_on_access(compressor)\n                || this.expression.may_throw(compressor)\n                || this.property.may_throw(compressor);\n        });\n        def(AST_Switch, function(compressor) {\n            return this.expression.may_throw(compressor)\n                || any(this.body, compressor);\n        });\n        def(AST_SymbolRef, function(compressor) {\n            return !this.is_declared(compressor) || !can_drop_symbol(this, compressor);\n        });\n        def(AST_Template, function(compressor) {\n            if (any(this.expressions, compressor)) return true;\n            if (this.is_expr_pure(compressor)) return false;\n            if (!this.tag) return false;\n            this.may_throw = return_true;\n            var ret = call_may_throw(this.tag, compressor);\n            delete this.may_throw;\n            return ret;\n        });\n        def(AST_Try, function(compressor) {\n            return (this.bcatch ? this.bcatch.may_throw(compressor) : any(this.body, compressor))\n                || this.bfinally && this.bfinally.may_throw(compressor);\n        });\n        def(AST_Unary, function(compressor) {\n            return this.expression.may_throw(compressor)\n                && !(this.operator == "typeof" && this.expression instanceof AST_SymbolRef);\n        });\n        def(AST_VarDef, function(compressor) {\n            return this.name.may_throw(compressor)\n                || this.value && this.value.may_throw(compressor);\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("may_throw", func);\n    });\n\n    // determine if expression is constant\n    (function(def) {\n        function all_constant(list, scope) {\n            for (var i = list.length; --i >= 0;)\n                if (!list[i].is_constant_expression(scope))\n                    return false;\n            return true;\n        }\n\n        function walk_scoped(self, scope) {\n            var result = true;\n            var scopes = [];\n            self.walk(new TreeWalker(function(node, descend) {\n                if (!result) return true;\n                if (node instanceof AST_BlockScope) {\n                    if (node === self) return;\n                    scopes.push(node);\n                    descend();\n                    scopes.pop();\n                    return true;\n                }\n                if (node instanceof AST_SymbolRef) {\n                    if (self.inlined || node.redef || node.in_arg) {\n                        result = false;\n                        return true;\n                    }\n                    if (self.variables && self.variables.has(node.name)) return true;\n                    var def = node.definition();\n                    if (member(def.scope, scopes)) return true;\n                    if (scope && !def.redefined()) {\n                        var scope_def = scope.find_variable(node.name);\n                        if (scope_def ? scope_def === def : def.undeclared) {\n                            result = "f";\n                            return true;\n                        }\n                    }\n                    result = false;\n                    return true;\n                }\n                if (node instanceof AST_ObjectIdentity) {\n                    if (is_arrow(self) && all(scopes, function(s) {\n                        return !(s instanceof AST_Scope) || is_arrow(s);\n                    })) result = false;\n                    return true;\n                }\n            }));\n            return result;\n        }\n\n        def(AST_Node, return_false);\n        def(AST_Array, function(scope) {\n            return all_constant(this.elements, scope);\n        });\n        def(AST_Binary, function(scope) {\n            return this.left.is_constant_expression(scope)\n                && this.right.is_constant_expression(scope)\n                && can_drop_op(this);\n        });\n        def(AST_Class, function(scope) {\n            var base = this.extends;\n            if (base && !safe_for_extends(base)) return false;\n            return all_constant(this.properties, scope);\n        });\n        def(AST_ClassProperty, function(scope) {\n            if (typeof this.key != "string") return false;\n            var value = this.value;\n            if (!value) return true;\n            return this.static ? value.is_constant_expression(scope) : walk_scoped(value, scope);\n        });\n        def(AST_Constant, return_true);\n        def(AST_Lambda, function(scope) {\n            return walk_scoped(this, scope);\n        });\n        def(AST_Object, function(scope) {\n            return all_constant(this.properties, scope);\n        });\n        def(AST_ObjectIdentity, function(scope) {\n            return this.scope.resolve() === scope;\n        });\n        def(AST_ObjectProperty, function(scope) {\n            return typeof this.key == "string" && this.value.is_constant_expression(scope);\n        });\n        def(AST_Unary, function(scope) {\n            return this.expression.is_constant_expression(scope);\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("is_constant_expression", func);\n    });\n\n    // tell me if a statement aborts\n    function aborts(thing) {\n        return thing && thing.aborts();\n    }\n    (function(def) {\n        def(AST_Statement, return_null);\n        def(AST_Jump, return_this);\n        function block_aborts() {\n            var n = this.body.length;\n            return n > 0 && aborts(this.body[n - 1]);\n        }\n        def(AST_BlockStatement, block_aborts);\n        def(AST_SwitchBranch, block_aborts);\n        def(AST_If, function() {\n            return this.alternative && aborts(this.body) && aborts(this.alternative) && this;\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("aborts", func);\n    });\n\n    /* -----[ optimizers ]----- */\n\n    var directives = makePredicate(["use asm", "use strict"]);\n    OPT(AST_Directive, function(self, compressor) {\n        if (compressor.option("directives")\n            && (!directives[self.value] || compressor.has_directive(self.value) !== self)) {\n            return make_node(AST_EmptyStatement, self);\n        }\n        return self;\n    });\n\n    OPT(AST_Debugger, function(self, compressor) {\n        if (compressor.option("drop_debugger"))\n            return make_node(AST_EmptyStatement, self);\n        return self;\n    });\n\n    OPT(AST_LabeledStatement, function(self, compressor) {\n        if (self.body instanceof AST_If || self.body instanceof AST_Break) {\n            var body = tighten_body([ self.body ], compressor);\n            switch (body.length) {\n              case 0:\n                self.body = make_node(AST_EmptyStatement, self);\n                break;\n              case 1:\n                self.body = body[0];\n                break;\n              default:\n                self.body = make_node(AST_BlockStatement, self, { body: body });\n                break;\n            }\n        }\n        return compressor.option("unused") && self.label.references.length == 0 ? self.body : self;\n    });\n\n    OPT(AST_LoopControl, function(self, compressor) {\n        if (!compressor.option("dead_code")) return self;\n        var label = self.label;\n        if (label) {\n            var lct = compressor.loopcontrol_target(self);\n            self.label = null;\n            if (compressor.loopcontrol_target(self) === lct) {\n                remove(label.thedef.references, self);\n            } else {\n                self.label = label;\n            }\n        }\n        return self;\n    });\n\n    OPT(AST_Block, function(self, compressor) {\n        self.body = tighten_body(self.body, compressor);\n        return self;\n    });\n\n    function trim_block(node, parent, in_list) {\n        switch (node.body.length) {\n          case 0:\n            return in_list ? List.skip : make_node(AST_EmptyStatement, node);\n          case 1:\n            var stat = node.body[0];\n            if (!safe_to_trim(stat)) return node;\n            if (parent instanceof AST_IterationStatement && stat instanceof AST_LambdaDefinition) return node;\n            return stat;\n        }\n        return node;\n    }\n\n    OPT(AST_BlockStatement, function(self, compressor) {\n        self.body = tighten_body(self.body, compressor);\n        return trim_block(self, compressor.parent());\n    });\n\n    function drop_rest_farg(fn, compressor) {\n        if (!compressor.option("rests")) return;\n        if (fn.uses_arguments) return;\n        if (!(fn.rest instanceof AST_DestructuredArray)) return;\n        if (!compressor.drop_fargs(fn, compressor.parent())) return;\n        fn.argnames = fn.argnames.concat(fn.rest.elements);\n        fn.rest = fn.rest.rest;\n    }\n\n    OPT(AST_Lambda, function(self, compressor) {\n        drop_rest_farg(self, compressor);\n        self.body = tighten_body(self.body, compressor);\n        return self;\n    });\n\n    OPT(AST_Function, function(self, compressor) {\n        drop_rest_farg(self, compressor);\n        self.body = tighten_body(self.body, compressor);\n        var parent = compressor.parent();\n        if (compressor.option("inline")) for (var i = 0; i < self.body.length; i++) {\n            var stat = self.body[i];\n            if (stat instanceof AST_Directive) continue;\n            if (stat instanceof AST_Return) {\n                if (i != self.body.length - 1) break;\n                var call = stat.value;\n                if (!call || call.TYPE != "Call") break;\n                if (call.is_expr_pure(compressor)) break;\n                var exp = call.expression, fn;\n                if (!(exp instanceof AST_SymbolRef)) {\n                    fn = exp;\n                } else if (self.name && self.name.definition() === exp.definition()) {\n                    break;\n                } else {\n                    fn = exp.fixed_value();\n                }\n                if (!(fn instanceof AST_Defun || fn instanceof AST_Function)) break;\n                if (fn.rest) break;\n                if (fn.uses_arguments) break;\n                if (fn === exp) {\n                    if (fn.parent_scope !== self) break;\n                    if (!all(fn.enclosed, function(def) {\n                        return def.scope !== self;\n                    })) break;\n                }\n                if ((fn !== exp || fn.name)\n                    && (parent instanceof AST_ClassMethod || parent instanceof AST_ObjectMethod)\n                    && parent.value === compressor.self()) break;\n                if (fn.contains_this()) break;\n                var len = fn.argnames.length;\n                if (len > 0 && compressor.option("inline") < 2) break;\n                if (len > self.argnames.length) break;\n                if (!all(self.argnames, function(argname) {\n                    return argname instanceof AST_SymbolFunarg;\n                })) break;\n                if (!all(call.args, function(arg) {\n                    return !(arg instanceof AST_Spread);\n                })) break;\n                for (var j = 0; j < len; j++) {\n                    var arg = call.args[j];\n                    if (!(arg instanceof AST_SymbolRef)) break;\n                    if (arg.definition() !== self.argnames[j].definition()) break;\n                }\n                if (j < len) break;\n                for (; j < call.args.length; j++) {\n                    if (call.args[j].has_side_effects(compressor)) break;\n                }\n                if (j < call.args.length) break;\n                if (len < self.argnames.length && !compressor.drop_fargs(self, parent)) {\n                    if (!compressor.drop_fargs(fn, call)) break;\n                    do {\n                        fn.argnames.push(fn.make_var(AST_SymbolFunarg, fn, "argument_" + len));\n                    } while (++len < self.argnames.length);\n                }\n                return exp;\n            }\n            break;\n        }\n        return self;\n    });\n\n    var NO_MERGE = makePredicate("arguments await yield");\n    AST_Scope.DEFMETHOD("merge_variables", function(compressor) {\n        if (!compressor.option("merge_vars")) return;\n        var in_arg = [], in_try, root, segment = {}, self = this;\n        var first = [], last = [], index = 0;\n        var declarations = new Dictionary();\n        var references = Object.create(null);\n        var prev = Object.create(null);\n        var tw = new TreeWalker(function(node, descend) {\n            if (node instanceof AST_Assign) {\n                var lhs = node.left;\n                var rhs = node.right;\n                if (lhs instanceof AST_Destructured) {\n                    rhs.walk(tw);\n                    walk_destructured(AST_SymbolRef, mark, lhs);\n                    return true;\n                }\n                if (lazy_op[node.operator.slice(0, -1)]) {\n                    lhs.walk(tw);\n                    push();\n                    rhs.walk(tw);\n                    if (lhs instanceof AST_SymbolRef) mark(lhs);\n                    pop();\n                    return true;\n                }\n                if (lhs instanceof AST_SymbolRef) {\n                    if (node.operator != "=") mark(lhs, true);\n                    rhs.walk(tw);\n                    mark(lhs);\n                    return true;\n                }\n                return;\n            }\n            if (node instanceof AST_Binary) {\n                if (!lazy_op[node.operator]) return;\n                walk_cond(node);\n                return true;\n            }\n            if (node instanceof AST_Break) {\n                var target = tw.loopcontrol_target(node);\n                if (!(target instanceof AST_IterationStatement)) insert(target);\n                return true;\n            }\n            if (node instanceof AST_Call) {\n                var exp = node.expression;\n                if (exp instanceof AST_LambdaExpression) {\n                    node.args.forEach(function(arg) {\n                        arg.walk(tw);\n                    });\n                    exp.walk(tw);\n                } else {\n                    descend();\n                    mark_expression(exp);\n                }\n                return true;\n            }\n            if (node instanceof AST_Class) {\n                if (node.name) node.name.walk(tw);\n                if (node.extends) node.extends.walk(tw);\n                node.properties.filter(function(prop) {\n                    if (prop.key instanceof AST_Node) prop.key.walk(tw);\n                    return prop.value;\n                }).forEach(function(prop) {\n                    if (prop.static) {\n                        prop.value.walk(tw);\n                    } else {\n                        push();\n                        segment.block = node;\n                        prop.value.walk(tw);\n                        pop();\n                    }\n                });\n                return true;\n            }\n            if (node instanceof AST_Conditional) {\n                walk_cond(node.condition, node.consequent, node.alternative);\n                return true;\n            }\n            if (node instanceof AST_Continue) {\n                var target = tw.loopcontrol_target(node);\n                if (target instanceof AST_Do) insert(target);\n                return true;\n            }\n            if (node instanceof AST_Do) {\n                push();\n                segment.block = node;\n                segment.loop = true;\n                var save = segment;\n                node.body.walk(tw);\n                if (segment.inserted === node) segment = save;\n                node.condition.walk(tw);\n                pop();\n                return true;\n            }\n            if (node instanceof AST_For) {\n                if (node.init) node.init.walk(tw);\n                push();\n                segment.block = node;\n                segment.loop = true;\n                if (node.condition) node.condition.walk(tw);\n                node.body.walk(tw);\n                if (node.step) node.step.walk(tw);\n                pop();\n                return true;\n            }\n            if (node instanceof AST_ForEnumeration) {\n                node.object.walk(tw);\n                push();\n                segment.block = node;\n                segment.loop = true;\n                node.init.walk(tw);\n                node.body.walk(tw);\n                pop();\n                return true;\n            }\n            if (node instanceof AST_If) {\n                walk_cond(node.condition, node.body, node.alternative);\n                return true;\n            }\n            if (node instanceof AST_LabeledStatement) {\n                push();\n                segment.block = node;\n                var save = segment;\n                node.body.walk(tw);\n                if (segment.inserted === node) segment = save;\n                pop();\n                return true;\n            }\n            if (node instanceof AST_Scope) {\n                push();\n                segment.block = node;\n                if (node === self) root = segment;\n                if (node instanceof AST_Lambda) {\n                    if (node.name) references[node.name.definition().id] = false;\n                    var marker = node.uses_arguments && !tw.has_directive("use strict") ? function(node) {\n                        references[node.definition().id] = false;\n                    } : function(node) {\n                        mark(node);\n                    };\n                    in_arg.push(node);\n                    node.argnames.forEach(function(argname) {\n                        walk_destructured(AST_SymbolFunarg, marker, argname);\n                    });\n                    if (node.rest) walk_destructured(AST_SymbolFunarg, marker, node.rest);\n                    in_arg.pop();\n                }\n                walk_lambda(node, tw);\n                pop();\n                return true;\n            }\n            if (node instanceof AST_Sub) {\n                var exp = node.expression;\n                if (node.optional) {\n                    exp.walk(tw);\n                    push();\n                    node.property.walk(tw);\n                    pop();\n                } else {\n                    descend();\n                }\n                mark_expression(exp);\n                return true;\n            }\n            if (node instanceof AST_Switch) {\n                node.expression.walk(tw);\n                var save = segment;\n                node.body.forEach(function(branch) {\n                    if (branch instanceof AST_Default) return;\n                    branch.expression.walk(tw);\n                    if (save === segment) push();\n                });\n                segment = save;\n                node.body.forEach(function(branch) {\n                    push();\n                    segment.block = node;\n                    var save = segment;\n                    walk_body(branch, tw);\n                    if (segment.inserted === node) segment = save;\n                    pop();\n                });\n                return true;\n            }\n            if (node instanceof AST_SymbolDeclaration) {\n                references[node.definition().id] = false;\n                return true;\n            }\n            if (node instanceof AST_SymbolRef) {\n                mark(node, true);\n                return true;\n            }\n            if (node instanceof AST_Try) {\n                var save_try = in_try;\n                in_try = node;\n                walk_body(node, tw);\n                if (node.bcatch) {\n                    if (node.bcatch.argname) node.bcatch.argname.mark_symbol(function(node) {\n                        if (node instanceof AST_SymbolCatch) {\n                            var def = node.definition();\n                            references[def.id] = false;\n                            if (def = def.redefined()) references[def.id] = false;\n                        }\n                    }, tw);\n                    if (node.bfinally || (in_try = save_try)) {\n                        walk_body(node.bcatch, tw);\n                    } else {\n                        push();\n                        walk_body(node.bcatch, tw);\n                        pop();\n                    }\n                }\n                in_try = save_try;\n                if (node.bfinally) node.bfinally.walk(tw);\n                return true;\n            }\n            if (node instanceof AST_Unary) {\n                if (!UNARY_POSTFIX[node.operator]) return;\n                var sym = node.expression;\n                if (!(sym instanceof AST_SymbolRef)) return;\n                mark(sym, true);\n                return true;\n            }\n            if (node instanceof AST_VarDef) {\n                var assigned = node.value;\n                if (assigned) {\n                    assigned.walk(tw);\n                } else {\n                    assigned = segment.block instanceof AST_ForEnumeration && segment.block.init === tw.parent();\n                }\n                walk_destructured(AST_SymbolDeclaration, assigned ? function(node) {\n                    if (node instanceof AST_SymbolVar) {\n                        mark(node);\n                    } else {\n                        node.walk(tw);\n                    }\n                } : function(node) {\n                    if (node instanceof AST_SymbolVar) {\n                        var id = node.definition().id;\n                        var refs = references[id];\n                        if (refs) {\n                            refs.push(node);\n                        } else if (!(id in references)) {\n                            declarations.add(id, node);\n                        }\n                    } else {\n                        node.walk(tw);\n                    }\n                }, node.name);\n                return true;\n            }\n            if (node instanceof AST_While) {\n                push();\n                segment.block = node;\n                segment.loop = true;\n                descend();\n                pop();\n                return true;\n            }\n\n            function mark_expression(exp) {\n                if (!compressor.option("ie")) return;\n                var sym = root_expr(exp);\n                if (sym instanceof AST_SymbolRef) sym.walk(tw);\n            }\n\n            function walk_cond(condition, consequent, alternative) {\n                var save = segment;\n                var segments = scan_branches(1, condition, consequent, alternative);\n                if (consequent) {\n                    segment = segments.consequent.segment;\n                    for (var i = segments.consequent.level; --i >= 0;) pop();\n                    if (segment !== save) return;\n                }\n                if (alternative) {\n                    segment = segments.alternative.segment;\n                    for (var i = segments.alternative.level; --i >= 0;) pop();\n                    if (segment !== save) return;\n                }\n                segment = save;\n            }\n\n            function scan_branches(level, condition, consequent, alternative) {\n                var segments = {\n                    consequent: {\n                        segment: segment,\n                        level: level,\n                    },\n                    alternative: {\n                        segment: segment,\n                        level: level,\n                    },\n                }\n                if (condition instanceof AST_Binary) switch (condition.operator) {\n                  case "&&":\n                    segments.consequent = scan_branches(level + 1, condition.left, condition.right).consequent;\n                    break;\n                  case "||":\n                    segments.alternative = scan_branches(level + 1, condition.left, null, condition.right).alternative;\n                    break;\n                  case "??":\n                    segments.alternative = scan_branches(level + 1, condition.left, condition.right, condition.right).alternative;\n                    break;\n                  default:\n                    condition.walk(tw);\n                    break;\n                } else if (condition instanceof AST_Conditional) {\n                    scan_branches(level + 1, condition.condition, condition.consequent, condition.alternative);\n                } else {\n                    condition.walk(tw);\n                }\n                if (consequent) {\n                    segment = segments.consequent.segment;\n                    push();\n                    consequent.walk(tw);\n                    segments.consequent.segment = segment;\n                }\n                if (alternative) {\n                    segment = segments.alternative.segment;\n                    push();\n                    alternative.walk(tw);\n                    segments.alternative.segment = segment;\n                }\n                return segments;\n            }\n        });\n        tw.directives = Object.create(compressor.directives);\n        self.walk(tw);\n        var changed = false;\n        var merged = Object.create(null);\n        while (first.length && last.length) {\n            var tail = last.shift();\n            if (!tail) continue;\n            var def = tail.definition;\n            var tail_refs = references[def.id];\n            if (!tail_refs) continue;\n            tail_refs = { end: tail_refs.end };\n            while (def.id in merged) def = merged[def.id];\n            tail_refs.start = references[def.id].start;\n            var skipped = [];\n            do {\n                var head = first.shift();\n                if (tail.index > head.index) continue;\n                var prev_def = head.definition;\n                if (!(prev_def.id in prev)) continue;\n                var head_refs = references[prev_def.id];\n                if (!head_refs) continue;\n                if (head_refs.start.block !== tail_refs.start.block\n                    || !mergeable(head_refs, tail_refs)\n                    || (head_refs.start.loop || !same_scope(def)) && !mergeable(tail_refs, head_refs)\n                    || compressor.option("webkit") && is_funarg(def) !== is_funarg(prev_def)\n                    || prev_def.const_redefs\n                    || !all(head_refs.scopes, function(scope) {\n                        return scope.find_variable(def.name) === def;\n                    })) {\n                    skipped.push(head);\n                    continue;\n                }\n                head_refs.forEach(function(sym) {\n                    sym.thedef = def;\n                    sym.name = def.name;\n                    if (sym instanceof AST_SymbolRef) {\n                        def.references.push(sym);\n                        prev_def.replaced++;\n                    } else {\n                        def.orig.push(sym);\n                        prev_def.eliminated++;\n                    }\n                });\n                if (!prev_def.fixed) def.fixed = false;\n                merged[prev_def.id] = def;\n                changed = true;\n                break;\n            } while (first.length);\n            if (skipped.length) first = skipped.concat(first);\n        }\n        return changed;\n\n        function push() {\n            segment = Object.create(segment);\n        }\n\n        function pop() {\n            segment = Object.getPrototypeOf(segment);\n        }\n\n        function walk_destructured(symbol_type, mark, lhs) {\n            var marker = new TreeWalker(function(node) {\n                if (node instanceof AST_Destructured) return;\n                if (node instanceof AST_DefaultValue) {\n                    push();\n                    node.value.walk(tw);\n                    pop();\n                    node.name.walk(marker);\n                } else if (node instanceof AST_DestructuredKeyVal) {\n                    if (!(node.key instanceof AST_Node)) {\n                        node.value.walk(marker);\n                    } else if (node.value instanceof AST_PropAccess) {\n                        push();\n                        segment.block = node;\n                        node.key.walk(tw);\n                        node.value.walk(marker);\n                        pop();\n                    } else {\n                        node.key.walk(tw);\n                        node.value.walk(marker);\n                    }\n                } else if (node instanceof symbol_type) {\n                    mark(node);\n                } else {\n                    node.walk(tw);\n                }\n                return true;\n            });\n            lhs.walk(marker);\n        }\n\n        function mark(sym, read) {\n            var def = sym.definition(), ldef;\n            if (read && !all(in_arg, function(fn) {\n                ldef = fn.variables.get(sym.name);\n                if (!ldef) return true;\n                if (!is_funarg(ldef)) return true;\n                return ldef !== def\n                    && !def.undeclared\n                    && fn.parent_scope.find_variable(sym.name) !== def;\n            })) return references[def.id] = references[ldef.id] = false;\n            var seg = segment;\n            if (in_try) {\n                push();\n                seg = segment;\n                pop();\n            }\n            if (def.id in references) {\n                var refs = references[def.id];\n                if (!refs) return;\n                if (refs.start.block !== seg.block) return references[def.id] = false;\n                push_ref(sym);\n                refs.end = seg;\n                if (def.id in prev) {\n                    last[prev[def.id]] = null;\n                } else if (!read) {\n                    return;\n                }\n            } else if ((ldef = self.variables.get(def.name)) !== def) {\n                if (ldef && root === seg) references[ldef.id] = false;\n                return references[def.id] = false;\n            } else if (compressor.exposed(def) || NO_MERGE[sym.name]) {\n                return references[def.id] = false;\n            } else {\n                var refs = declarations.get(def.id) || [];\n                refs.scopes = [];\n                push_ref(sym);\n                references[def.id] = refs;\n                if (!read) {\n                    refs.start = seg;\n                    return first.push({\n                        index: index++,\n                        definition: def,\n                    });\n                }\n                if (seg.block !== self) return references[def.id] = false;\n                refs.start = root;\n            }\n            prev[def.id] = last.length;\n            last.push({\n                index: index++,\n                definition: def,\n            });\n\n            function push_ref(sym) {\n                refs.push(sym);\n                push_uniq(refs.scopes, sym.scope);\n                var scope = find_scope(tw);\n                if (scope !== sym.scope) push_uniq(refs.scopes, scope);\n            }\n        }\n\n        function insert(target) {\n            var stack = [];\n            while (true) {\n                if (HOP(segment, "block")) {\n                    var block = segment.block;\n                    if (block instanceof AST_LabeledStatement) block = block.body;\n                    if (block === target) break;\n                }\n                stack.push(segment);\n                pop();\n            }\n            segment.inserted = segment.block;\n            push();\n            while (stack.length) {\n                var seg = stack.pop();\n                push();\n                if (HOP(seg, "block")) segment.block = seg.block;\n                if (HOP(seg, "loop")) segment.loop = seg.loop;\n            }\n        }\n\n        function must_visit(base, segment) {\n            return base === segment || base.isPrototypeOf(segment);\n        }\n\n        function mergeable(head, tail) {\n            return must_visit(head.start, head.end) || must_visit(head.start, tail.start);\n        }\n    });\n\n    function fill_holes(orig, elements) {\n        for (var i = elements.length; --i >= 0;) {\n            if (!elements[i]) elements[i] = make_node(AST_Hole, orig);\n        }\n    }\n\n    function to_class_expr(defcl, drop_name) {\n        var cl = make_node(AST_ClassExpression, defcl);\n        if (cl.name) cl.name = drop_name ? null : make_node(AST_SymbolClass, cl.name);\n        return cl;\n    }\n\n    function to_func_expr(defun, drop_name) {\n        var ctor;\n        switch (defun.CTOR) {\n          case AST_AsyncDefun:\n            ctor = AST_AsyncFunction;\n            break;\n          case AST_AsyncGeneratorDefun:\n            ctor = AST_AsyncGeneratorFunction;\n            break;\n          case AST_Defun:\n            ctor = AST_Function;\n            break;\n          case AST_GeneratorDefun:\n            ctor = AST_GeneratorFunction;\n            break;\n        }\n        var fn = make_node(ctor, defun);\n        fn.name = drop_name ? null : make_node(AST_SymbolLambda, defun.name);\n        return fn;\n    }\n\n    AST_Scope.DEFMETHOD("drop_unused", function(compressor) {\n        if (!compressor.option("unused")) return;\n        var self = this;\n        var drop_funcs = !(self instanceof AST_Toplevel) || compressor.toplevel.funcs;\n        var drop_vars = !(self instanceof AST_Toplevel) || compressor.toplevel.vars;\n        var assign_as_unused = /keep_assign/.test(compressor.option("unused")) ? return_false : function(node, props) {\n            var sym, nested = false;\n            if (node instanceof AST_Assign) {\n                if (node.write_only || node.operator == "=") sym = extract_reference(node.left, props);\n            } else if (node instanceof AST_Unary) {\n                if (node.write_only) sym = extract_reference(node.expression, props);\n            }\n            if (!(sym instanceof AST_SymbolRef)) return;\n            var def = sym.definition();\n            if (export_defaults[def.id]) return;\n            if (compressor.exposed(def)) return;\n            if (!can_drop_symbol(sym, compressor, nested)) return;\n            return sym;\n\n            function extract_reference(node, props) {\n                if (node instanceof AST_PropAccess) {\n                    var expr = node.expression;\n                    if (!expr.may_throw_on_access(compressor, true)) {\n                        nested = true;\n                        if (props && node instanceof AST_Sub) props.unshift(node.property);\n                        return extract_reference(expr, props);\n                    }\n                } else if (node instanceof AST_Assign && node.operator == "=") {\n                    node.write_only = "p";\n                    var ref = extract_reference(node.right);\n                    if (!props) return ref;\n                    props.assign = node;\n                    return ref instanceof AST_SymbolRef ? ref : node.left;\n                }\n                return node;\n            }\n        };\n        var assign_in_use = Object.create(null);\n        var export_defaults = Object.create(null);\n        var find_variable = function(name) {\n            find_variable = compose(self, 0, noop);\n            return find_variable(name);\n\n            function compose(child, level, find) {\n                var parent = compressor.parent(level);\n                if (!parent) return find;\n                var in_arg = parent instanceof AST_Lambda && member(child, parent.argnames);\n                return compose(parent, level + 1, in_arg ? function(name) {\n                    var def = find(name);\n                    if (def) return def;\n                    def = parent.variables.get(name);\n                    if (def) {\n                        var sym = def.orig[0];\n                        if (sym instanceof AST_SymbolFunarg || sym instanceof AST_SymbolLambda) return def;\n                    }\n                } : parent.variables ? function(name) {\n                    return find(name) || parent.variables.get(name);\n                } : find);\n            }\n        };\n        var for_ins = Object.create(null);\n        var in_use = [];\n        var in_use_ids = Object.create(null); // avoid expensive linear scans of in_use\n        var lambda_ids = Object.create(null);\n        var value_read = Object.create(null);\n        var value_modified = Object.create(null);\n        var var_defs = Object.create(null);\n        if (self instanceof AST_Toplevel && compressor.top_retain) {\n            self.variables.each(function(def) {\n                if (compressor.top_retain(def) && !(def.id in in_use_ids)) {\n                    AST_Node.info("Retaining variable {name}", def);\n                    in_use_ids[def.id] = true;\n                    in_use.push(def);\n                }\n            });\n        }\n        var assignments = new Dictionary();\n        var initializations = new Dictionary();\n        // pass 1: find out which symbols are directly used in\n        // this scope (not in nested scopes).\n        var scope = this;\n        var tw = new TreeWalker(function(node, descend) {\n            if (node instanceof AST_Lambda && node.uses_arguments && !tw.has_directive("use strict")) {\n                node.each_argname(function(argname) {\n                    var def = argname.definition();\n                    if (!(def.id in in_use_ids)) {\n                        in_use_ids[def.id] = true;\n                        in_use.push(def);\n                    }\n                });\n            }\n            if (node === self) return;\n            if (scope === self) {\n                if (node instanceof AST_DefClass) {\n                    var def = node.name.definition();\n                    var drop = drop_funcs && !def.exported;\n                    if (!drop && !(def.id in in_use_ids)) {\n                        in_use_ids[def.id] = true;\n                        in_use.push(def);\n                    }\n                    var used = tw.parent() instanceof AST_ExportDefault;\n                    if (used) {\n                        export_defaults[def.id] = true;\n                    } else if (drop && !(def.id in lambda_ids)) {\n                        lambda_ids[def.id] = 1;\n                    }\n                    if (node.extends) node.extends.walk(tw);\n                    var values = [];\n                    node.properties.forEach(function(prop) {\n                        if (prop.key instanceof AST_Node) prop.key.walk(tw);\n                        var value = prop.value;\n                        if (!value) return;\n                        if (is_static_field_or_init(prop)) {\n                            if (!used && value.contains_this()) used = true;\n                            walk_class_prop(value);\n                        } else {\n                            values.push(value);\n                        }\n                    });\n                    values.forEach(drop && used ? walk_class_prop : function(value) {\n                        initializations.add(def.id, value);\n                    });\n                    return true;\n                }\n                if (node instanceof AST_LambdaDefinition) {\n                    var def = node.name.definition();\n                    var drop = drop_funcs && !def.exported;\n                    if (!drop && !(def.id in in_use_ids)) {\n                        in_use_ids[def.id] = true;\n                        in_use.push(def);\n                    }\n                    initializations.add(def.id, node);\n                    if (tw.parent() instanceof AST_ExportDefault) {\n                        export_defaults[def.id] = true;\n                        return scan_ref_scoped(node, descend, true);\n                    }\n                    if (drop && !(def.id in lambda_ids)) lambda_ids[def.id] = 1;\n                    return true;\n                }\n                if (node instanceof AST_Definitions) {\n                    node.definitions.forEach(function(defn) {\n                        var value = defn.value;\n                        var side_effects = value\n                            && (defn.name instanceof AST_Destructured || value.has_side_effects(compressor));\n                        var shared = side_effects && value.tail_node().operator == "=";\n                        defn.name.mark_symbol(function(name) {\n                            if (!(name instanceof AST_SymbolDeclaration)) return;\n                            var def = name.definition();\n                            var_defs[def.id] = (var_defs[def.id] || 0) + 1;\n                            if (node instanceof AST_Var && def.orig[0] instanceof AST_SymbolCatch) {\n                                var redef = def.redefined();\n                                if (redef) var_defs[redef.id] = (var_defs[redef.id] || 0) + 1;\n                            }\n                            if (!(def.id in in_use_ids) && (!drop_vars || def.exported\n                                || (node instanceof AST_Const ? def.redefined() : def.const_redefs)\n                                || !(node instanceof AST_Var || is_safe_lexical(def)))) {\n                                in_use_ids[def.id] = true;\n                                in_use.push(def);\n                            }\n                            if (value) {\n                                if (!side_effects) {\n                                    initializations.add(def.id, value);\n                                } else if (shared) {\n                                    verify_safe_usage(def, name, value_modified[def.id]);\n                                }\n                                assignments.add(def.id, defn);\n                            }\n                            unmark_lambda(def);\n                            return true;\n                        }, tw);\n                        if (side_effects) value.walk(tw);\n                    });\n                    return true;\n                }\n                if (node instanceof AST_SymbolFunarg) {\n                    var def = node.definition();\n                    var_defs[def.id] = (var_defs[def.id] || 0) + 1;\n                    assignments.add(def.id, node);\n                    var fixed = node.fixed_value(true);\n                    if (fixed && fixed.tail_node().operator == "=") {\n                        verify_safe_usage(def, node, value_modified[def.id]);\n                    }\n                    return true;\n                }\n                if (node instanceof AST_SymbolImport) {\n                    var def = node.definition();\n                    if (!(def.id in in_use_ids) && (!drop_vars || !is_safe_lexical(def))) {\n                        in_use_ids[def.id] = true;\n                        in_use.push(def);\n                    }\n                    return true;\n                }\n            }\n            return scan_ref_scoped(node, descend, true);\n\n            function walk_class_prop(value) {\n                var save_scope = scope;\n                scope = node;\n                value.walk(tw);\n                scope = save_scope;\n            }\n        });\n        tw.directives = Object.create(compressor.directives);\n        self.walk(tw);\n        var drop_fn_name = compressor.option("keep_fnames") ? return_false : compressor.option("ie") ? function(def) {\n            return !compressor.exposed(def) && def.references.length == def.replaced;\n        } : function(def) {\n            if (!(def.id in in_use_ids)) return true;\n            if (def.orig.length - def.eliminated < 2) return false;\n            // function argument will always overshadow its name\n            if (def.orig[1] instanceof AST_SymbolFunarg) return true;\n            // retain if referenced within destructured object of argument\n            return all(def.references, function(ref) {\n                return !ref.in_arg;\n            });\n        };\n        if (compressor.option("ie")) initializations.each(function(init, id) {\n            if (id in in_use_ids) return;\n            init.forEach(function(init) {\n                init.walk(new TreeWalker(function(node) {\n                    if (node instanceof AST_Function && node.name && !drop_fn_name(node.name.definition())) {\n                        node.walk(tw);\n                        return true;\n                    }\n                    if (node instanceof AST_Scope) return true;\n                }));\n            });\n        });\n        // pass 2: for every used symbol we need to walk its\n        // initialization code to figure out if it uses other\n        // symbols (that may not be in_use).\n        tw = new TreeWalker(scan_ref_scoped);\n        for (var i = 0; i < in_use.length; i++) {\n            var init = initializations.get(in_use[i].id);\n            if (init) init.forEach(function(init) {\n                init.walk(tw);\n            });\n        }\n        Object.keys(assign_in_use).forEach(function(id) {\n            var assigns = assign_in_use[id];\n            if (!assigns) {\n                delete assign_in_use[id];\n                return;\n            }\n            assigns = assigns.reduce(function(in_use, assigns) {\n                assigns.forEach(function(assign) {\n                    push_uniq(in_use, assign);\n                });\n                return in_use;\n            }, []);\n            var in_use = (assignments.get(id) || []).filter(function(node) {\n                return find_if(node instanceof AST_Unary ? function(assign) {\n                    return assign === node;\n                } : function(assign) {\n                    if (assign === node) return true;\n                    if (assign instanceof AST_Unary) return false;\n                    return get_rvalue(assign) === get_rvalue(node);\n                }, assigns);\n            });\n            if (assigns.length == in_use.length) {\n                assign_in_use[id] = in_use;\n            } else {\n                delete assign_in_use[id];\n            }\n        });\n        // pass 3: we should drop declarations not in_use\n        var calls_to_drop_args = [];\n        var fns_with_marked_args = [];\n        var trimmer = new TreeTransformer(function(node) {\n            if (node instanceof AST_DefaultValue) return trim_default(trimmer, node);\n            if (node instanceof AST_Destructured && node.rest) node.rest = node.rest.transform(trimmer);\n            if (node instanceof AST_DestructuredArray) {\n                var trim = !node.rest;\n                for (var i = node.elements.length; --i >= 0;) {\n                    var element = node.elements[i].transform(trimmer);\n                    if (element) {\n                        node.elements[i] = element;\n                        trim = false;\n                    } else if (trim) {\n                        node.elements.pop();\n                    } else {\n                        node.elements[i] = make_node(AST_Hole, node.elements[i]);\n                    }\n                }\n                return node;\n            }\n            if (node instanceof AST_DestructuredObject) {\n                var properties = [];\n                node.properties.forEach(function(prop) {\n                    var retain = false;\n                    if (prop.key instanceof AST_Node) {\n                        prop.key = prop.key.transform(tt);\n                        retain = prop.key.has_side_effects(compressor);\n                    }\n                    if ((retain || node.rest) && is_decl(prop.value)) {\n                        prop.value = prop.value.transform(tt);\n                        properties.push(prop);\n                    } else {\n                        var value = prop.value.transform(trimmer);\n                        if (!value && node.rest) {\n                            if (prop.value instanceof AST_DestructuredArray) {\n                                value = make_node(AST_DestructuredArray, prop.value, { elements: [] });\n                            } else {\n                                value = make_node(AST_DestructuredObject, prop.value, { properties: [] });\n                            }\n                        }\n                        if (value) {\n                            prop.value = value;\n                            properties.push(prop);\n                        }\n                    }\n                });\n                node.properties = properties;\n                return node;\n            }\n            if (node instanceof AST_SymbolDeclaration) return trim_decl(node);\n        });\n        var tt = new TreeTransformer(function(node, descend, in_list) {\n            var parent = tt.parent();\n            if (drop_vars) {\n                var props = [], sym = assign_as_unused(node, props);\n                if (sym) {\n                    var value;\n                    if (can_drop_lhs(sym, node)) {\n                        if (node instanceof AST_Assign) {\n                            value = get_rhs(node);\n                            if (node.write_only === true) value = value.drop_side_effect_free(compressor);\n                        }\n                        if (!value) value = make_node(AST_Number, node, { value: 0 });\n                    }\n                    if (value) {\n                        if (props.assign) {\n                            var assign = props.assign.drop_side_effect_free(compressor);\n                            if (assign) {\n                                assign.write_only = true;\n                                props.unshift(assign);\n                            }\n                        }\n                        if (!(parent instanceof AST_Sequence)\n                            || parent.tail_node() === node\n                            || value.has_side_effects(compressor)) {\n                            props.push(value);\n                        }\n                        switch (props.length) {\n                          case 0:\n                            return List.skip;\n                          case 1:\n                            return maintain_this_binding(parent, node, props[0].transform(tt));\n                          default:\n                            return make_sequence(node, props.map(function(prop) {\n                                return prop.transform(tt);\n                            }));\n                        }\n                    }\n                } else if (node instanceof AST_UnaryPostfix\n                    && node.expression instanceof AST_SymbolRef\n                    && indexOf_assign(node.expression.definition(), node) < 0) {\n                    return make_node(AST_UnaryPrefix, node, {\n                        operator: "+",\n                        expression: node.expression,\n                    });\n                }\n            }\n            if (node instanceof AST_Binary && node.operator == "instanceof") {\n                var sym = node.right;\n                if (!(sym instanceof AST_SymbolRef)) return;\n                if (sym.definition().id in in_use_ids) return;\n                var lhs = node.left.drop_side_effect_free(compressor);\n                var value = make_node(AST_False, node).optimize(compressor);\n                return lhs ? make_sequence(node, [ lhs, value ]) : value;\n            }\n            if (node instanceof AST_Call) {\n                calls_to_drop_args.push(node);\n                node.args = node.args.map(function(arg) {\n                    return arg.transform(tt);\n                });\n                node.expression = node.expression.transform(tt);\n                return node;\n            }\n            if (scope !== self) return;\n            if (drop_funcs && node !== self && node instanceof AST_DefClass) {\n                var def = node.name.definition();\n                if (!(def.id in in_use_ids)) {\n                    log(node.name, "Dropping unused class {name}");\n                    def.eliminated++;\n                    descend(node, tt);\n                    var trimmed = to_class_expr(node, true);\n                    if (parent instanceof AST_ExportDefault) return trimmed;\n                    trimmed = trimmed.drop_side_effect_free(compressor, true);\n                    if (trimmed) return make_node(AST_SimpleStatement, node, { body: trimmed });\n                    return in_list ? List.skip : make_node(AST_EmptyStatement, node);\n                }\n            }\n            if (node instanceof AST_ClassExpression && node.name && drop_fn_name(node.name.definition())) {\n                node.name = null;\n            }\n            if (node instanceof AST_Lambda) {\n                if (drop_funcs && node !== self && node instanceof AST_LambdaDefinition) {\n                    var def = node.name.definition();\n                    if (!(def.id in in_use_ids)) {\n                        log(node.name, "Dropping unused function {name}");\n                        def.eliminated++;\n                        if (parent instanceof AST_ExportDefault) {\n                            descend_scope();\n                            return to_func_expr(node, true);\n                        }\n                        return in_list ? List.skip : make_node(AST_EmptyStatement, node);\n                    }\n                }\n                descend_scope();\n                if (node instanceof AST_LambdaExpression && node.name && drop_fn_name(node.name.definition())) {\n                    node.name = null;\n                }\n                if (!(node instanceof AST_Accessor)) {\n                    var args, spread, trim = compressor.drop_fargs(node, parent);\n                    if (trim && parent instanceof AST_Call && parent.expression === node) {\n                        args = parent.args;\n                        for (spread = 0; spread < args.length; spread++) {\n                            if (args[spread] instanceof AST_Spread) break;\n                        }\n                    }\n                    var argnames = node.argnames;\n                    var rest = node.rest;\n                    var after = false, before = false;\n                    if (rest) {\n                        before = true;\n                        if (!args || spread < argnames.length || rest instanceof AST_SymbolFunarg) {\n                            rest = rest.transform(trimmer);\n                        } else {\n                            var trimmed = trim_destructured(rest, make_node(AST_Array, parent, {\n                                elements: args.slice(argnames.length),\n                            }), trim_decl, !node.uses_arguments, rest);\n                            rest = trimmed.name;\n                            args.length = argnames.length;\n                            if (trimmed.value.elements.length) [].push.apply(args, trimmed.value.elements);\n                        }\n                        if (rest instanceof AST_Destructured && !rest.rest) {\n                            if (rest instanceof AST_DestructuredArray) {\n                                if (rest.elements.length == 0) rest = null;\n                            } else if (rest.properties.length == 0) {\n                                rest = null;\n                            }\n                        }\n                        node.rest = rest;\n                        if (rest) {\n                            trim = false;\n                            after = true;\n                        }\n                    }\n                    var default_length = trim ? -1 : node.length();\n                    var trim_value = args && !node.uses_arguments && parent !== compressor.parent();\n                    for (var i = argnames.length; --i >= 0;) {\n                        var sym = argnames[i];\n                        if (sym instanceof AST_SymbolFunarg) {\n                            var def = sym.definition();\n                            if (def.id in in_use_ids) {\n                                trim = false;\n                                if (indexOf_assign(def, sym) < 0) sym.unused = null;\n                            } else if (trim) {\n                                log(sym, "Dropping unused function argument {name}");\n                                argnames.pop();\n                                def.eliminated++;\n                                sym.unused = true;\n                            } else {\n                                sym.unused = true;\n                            }\n                        } else {\n                            before = true;\n                            var funarg;\n                            if (!args || spread < i) {\n                                funarg = sym.transform(trimmer);\n                            } else {\n                                var trimmed = trim_destructured(sym, args[i], trim_decl, trim_value, sym);\n                                funarg = trimmed.name;\n                                if (trimmed.value) args[i] = trimmed.value;\n                            }\n                            if (funarg) {\n                                trim = false;\n                                argnames[i] = funarg;\n                                if (!after) after = !(funarg instanceof AST_SymbolFunarg);\n                            } else if (trim) {\n                                log_default(sym, "Dropping unused default argument {name}");\n                                argnames.pop();\n                            } else if (i > default_length) {\n                                log_default(sym, "Dropping unused default argument assignment {name}");\n                                if (sym.name instanceof AST_SymbolFunarg) {\n                                    sym.name.unused = true;\n                                } else {\n                                    after = true;\n                                }\n                                argnames[i] = sym.name;\n                            } else {\n                                log_default(sym, "Dropping unused default argument value {name}");\n                                argnames[i] = sym = sym.clone();\n                                sym.value = make_node(AST_Number, sym, { value: 0 });\n                                after = true;\n                            }\n                        }\n                    }\n                    if (before && !after && node.uses_arguments && !tt.has_directive("use strict")) {\n                        node.rest = make_node(AST_DestructuredArray, node, { elements: [] });\n                    }\n                    fns_with_marked_args.push(node);\n                }\n                return node;\n            }\n            if (node instanceof AST_Catch && node.argname instanceof AST_Destructured) {\n                node.argname.transform(trimmer);\n            }\n            if (node instanceof AST_Definitions && !(parent instanceof AST_ForEnumeration && parent.init === node)) {\n                // place uninitialized names at the start\n                var body = [], head = [], tail = [];\n                // for unused names whose initialization has\n                // side effects, we can cascade the init. code\n                // into the next one, or next statement.\n                var side_effects = [];\n                var duplicated = 0;\n                var is_var = node instanceof AST_Var;\n                node.definitions.forEach(function(def) {\n                    if (def.value) def.value = def.value.transform(tt);\n                    var value = def.value;\n                    if (def.name instanceof AST_Destructured) {\n                        var trimmed = trim_destructured(def.name, value, function(node) {\n                            if (!drop_vars) return node;\n                            if (node.definition().id in in_use_ids) return node;\n                            if (is_catch(node)) return node;\n                            if (is_var && !can_drop_symbol(node)) return node;\n                            return null;\n                        }, true);\n                        if (trimmed.name) {\n                            def = make_node(AST_VarDef, def, {\n                                name: trimmed.name,\n                                value: value = trimmed.value,\n                            });\n                            flush();\n                        } else if (trimmed.value) {\n                            side_effects.push(trimmed.value);\n                        }\n                        return;\n                    }\n                    var sym = def.name.definition();\n                    var drop_sym = is_var ? can_drop_symbol(def.name) : is_safe_lexical(sym);\n                    if (!drop_sym || !drop_vars || sym.id in in_use_ids) {\n                        var index;\n                        if (value && ((index = indexOf_assign(sym, def)) < 0 || self_assign(value.tail_node()))) {\n                            def = def.clone();\n                            value = value.drop_side_effect_free(compressor);\n                            if (value) AST_Node.warn("Side effects in definition of variable {name} [{start}]", def.name);\n                            if (node instanceof AST_Const) {\n                                def.value = value || make_node(AST_Number, def, { value: 0 });\n                            } else {\n                                def.value = null;\n                                if (value) side_effects.push(value);\n                            }\n                            value = null;\n                            if (index >= 0) assign_in_use[sym.id][index] = def;\n                        }\n                        var old_def, fn;\n                        if (!value && !(node instanceof AST_Let)) {\n                            if (parent instanceof AST_ExportDeclaration) {\n                                flush();\n                            } else if (drop_sym && var_defs[sym.id] > 1) {\n                                AST_Node.info("Dropping declaration of variable {name} [{start}]", def.name);\n                                var_defs[sym.id]--;\n                                sym.eliminated++;\n                            } else {\n                                head.push(def);\n                            }\n                        } else if (compressor.option("functions")\n                            && !compressor.option("ie")\n                            && drop_sym\n                            && value\n                            && var_defs[sym.id] == 1\n                            && sym.assignments == 0\n                            && (fn = value.tail_node()) instanceof AST_LambdaExpression\n                            && !is_arguments(sym)\n                            && !is_arrow(fn)\n                            && assigned_once(fn, sym.references)\n                            && can_declare_defun(fn)\n                            && (old_def = rename_def(fn, def.name.name)) !== false) {\n                            AST_Node.warn("Declaring {name} as function [{start}]", def.name);\n                            var ctor;\n                            switch (fn.CTOR) {\n                              case AST_AsyncFunction:\n                                ctor = AST_AsyncDefun;\n                                break;\n                              case AST_AsyncGeneratorFunction:\n                                ctor = AST_AsyncGeneratorDefun;\n                                break;\n                              case AST_Function:\n                                ctor = AST_Defun;\n                                break;\n                              case AST_GeneratorFunction:\n                                ctor = AST_GeneratorDefun;\n                                break;\n                            }\n                            var defun = make_node(ctor, fn);\n                            defun.name = make_node(AST_SymbolDefun, def.name);\n                            var name_def = def.name.scope.resolve().def_function(defun.name);\n                            if (old_def) old_def.forEach(function(node) {\n                                node.name = name_def.name;\n                                node.thedef = name_def;\n                                node.reference();\n                            });\n                            body.push(defun);\n                            if (value !== fn) [].push.apply(side_effects, value.expressions.slice(0, -1));\n                            sym.eliminated++;\n                        } else {\n                            if (drop_sym\n                                && var_defs[sym.id] > 1\n                                && !(parent instanceof AST_ExportDeclaration)\n                                && sym.orig.indexOf(def.name) > sym.eliminated) {\n                                var_defs[sym.id]--;\n                                duplicated++;\n                            }\n                            flush();\n                        }\n                    } else if (is_catch(def.name)) {\n                        value = value && value.drop_side_effect_free(compressor);\n                        if (value) side_effects.push(value);\n                        if (var_defs[sym.id] > 1) {\n                            AST_Node.warn("Dropping duplicated declaration of variable {name} [{start}]", def.name);\n                            var_defs[sym.id]--;\n                            sym.eliminated++;\n                        } else {\n                            def.value = null;\n                            head.push(def);\n                        }\n                    } else {\n                        value = value && value.drop_side_effect_free(compressor);\n                        if (value) {\n                            AST_Node.warn("Side effects in initialization of unused variable {name} [{start}]", def.name);\n                            side_effects.push(value);\n                        } else {\n                            log(def.name, "Dropping unused variable {name}");\n                        }\n                        sym.eliminated++;\n                    }\n\n                    function self_assign(ref) {\n                        return ref instanceof AST_SymbolRef && ref.definition() === sym;\n                    }\n\n                    function assigned_once(fn, refs) {\n                        if (refs.length == 0) return fn === def.name.fixed_value();\n                        return all(refs, function(ref) {\n                            return fn === ref.fixed_value();\n                        });\n                    }\n\n                    function can_declare_defun(fn) {\n                        if (!is_var || compressor.has_directive("use strict") || !(fn instanceof AST_Function)) {\n                            return parent instanceof AST_Scope;\n                        }\n                        return parent instanceof AST_Block\n                            || parent instanceof AST_For && parent.init === node\n                            || parent instanceof AST_If;\n                    }\n\n                    function rename_def(fn, name) {\n                        if (!fn.name) return null;\n                        var def = fn.name.definition();\n                        if (def.orig.length > 1) return null;\n                        if (def.assignments > 0) return false;\n                        if (def.name == name) return def;\n                        if (compressor.option("keep_fnames")) return false;\n                        var forbidden;\n                        switch (name) {\n                          case "await":\n                            forbidden = is_async;\n                            break;\n                          case "yield":\n                            forbidden = is_generator;\n                            break;\n                        }\n                        return all(def.references, function(ref) {\n                            var scope = ref.scope;\n                            if (scope.find_variable(name) !== sym) return false;\n                            if (forbidden) do {\n                                scope = scope.resolve();\n                                if (forbidden(scope)) return false;\n                            } while (scope !== fn && (scope = scope.parent_scope));\n                            return true;\n                        }) && def;\n                    }\n\n                    function is_catch(node) {\n                        var sym = node.definition();\n                        return sym.orig[0] instanceof AST_SymbolCatch && sym.scope.resolve() === node.scope.resolve();\n                    }\n\n                    function flush() {\n                        if (side_effects.length > 0) {\n                            if (tail.length == 0) {\n                                body.push(make_node(AST_SimpleStatement, node, {\n                                    body: make_sequence(node, side_effects),\n                                }));\n                            } else if (value) {\n                                side_effects.push(value);\n                                def.value = make_sequence(value, side_effects);\n                            } else {\n                                def.value = make_node(AST_UnaryPrefix, def, {\n                                    operator: "void",\n                                    expression: make_sequence(def, side_effects),\n                                });\n                            }\n                            side_effects = [];\n                        }\n                        tail.push(def);\n                    }\n                });\n                switch (head.length) {\n                  case 0:\n                    if (tail.length == 0) break;\n                    if (tail.length == duplicated) {\n                        [].unshift.apply(side_effects, tail.map(function(def) {\n                            AST_Node.info("Dropping duplicated definition of variable {name} [{start}]", def.name);\n                            var sym = def.name.definition();\n                            var ref = make_node(AST_SymbolRef, def.name);\n                            sym.references.push(ref);\n                            var assign = make_node(AST_Assign, def, {\n                                operator: "=",\n                                left: ref,\n                                right: def.value,\n                            });\n                            var index = indexOf_assign(sym, def);\n                            if (index >= 0) assign_in_use[sym.id][index] = assign;\n                            sym.assignments++;\n                            sym.eliminated++;\n                            return assign;\n                        }));\n                        break;\n                    }\n                  case 1:\n                    if (tail.length == 0) {\n                        var id = head[0].name.definition().id;\n                        if (id in for_ins) {\n                            node.definitions = head;\n                            for_ins[id].init = node;\n                            break;\n                        }\n                    }\n                  default:\n                    var seq;\n                    if (tail.length > 0 && (seq = tail[0].value) instanceof AST_Sequence) {\n                        tail[0].value = seq.tail_node();\n                        body.push(make_node(AST_SimpleStatement, node, {\n                            body: make_sequence(seq, seq.expressions.slice(0, -1)),\n                        }));\n                    }\n                    node.definitions = head.concat(tail);\n                    body.push(node);\n                }\n                if (side_effects.length > 0) {\n                    body.push(make_node(AST_SimpleStatement, node, { body: make_sequence(node, side_effects) }));\n                }\n                return insert_statements(body, node, in_list);\n            }\n            if (node instanceof AST_Assign) {\n                descend(node, tt);\n                if (!(node.left instanceof AST_Destructured)) return node;\n                var trimmed = trim_destructured(node.left, node.right, function(node) {\n                    return node;\n                }, node.write_only === true);\n                if (trimmed.name) return make_node(AST_Assign, node, {\n                    operator: node.operator,\n                    left: trimmed.name,\n                    right: trimmed.value,\n                });\n                if (trimmed.value) return trimmed.value;\n                if (parent instanceof AST_Sequence && parent.tail_node() !== node) return List.skip;\n                return make_node(AST_Number, node, { value: 0 });\n            }\n            if (node instanceof AST_LabeledStatement && node.body instanceof AST_For) {\n                // Certain combination of unused name + side effect leads to invalid AST:\n                //    https://github.com/mishoo/UglifyJS/issues/1830\n                // We fix it at this stage by moving the label inwards, back to the `for`.\n                descend(node, tt);\n                if (node.body instanceof AST_BlockStatement) {\n                    var block = node.body;\n                    node.body = block.body.pop();\n                    block.body.push(node);\n                    return in_list ? List.splice(block.body) : block;\n                }\n                return node;\n            }\n            if (node instanceof AST_Scope) {\n                descend_scope();\n                return node;\n            }\n            if (node instanceof AST_SymbolImport) {\n                if (!compressor.option("imports") || node.definition().id in in_use_ids) return node;\n                return in_list ? List.skip : null;\n            }\n\n            function descend_scope() {\n                var save_scope = scope;\n                scope = node;\n                descend(node, tt);\n                scope = save_scope;\n            }\n        }, function(node, in_list) {\n            if (node instanceof AST_BlockStatement) return trim_block(node, tt.parent(), in_list);\n            if (node instanceof AST_ExportDeclaration) {\n                var block = node.body;\n                if (!(block instanceof AST_BlockStatement)) return;\n                node.body = block.body.pop();\n                block.body.push(node);\n                return in_list ? List.splice(block.body) : block;\n            }\n            if (node instanceof AST_For) return patch_for_init(node, in_list);\n            if (node instanceof AST_ForIn) {\n                if (!drop_vars || !compressor.option("loops")) return;\n                if (!is_empty(node.body)) return;\n                var sym = get_init_symbol(node);\n                if (!sym) return;\n                var def = sym.definition();\n                if (def.id in in_use_ids) return;\n                log(sym, "Dropping unused loop variable {name}");\n                if (for_ins[def.id] === node) delete for_ins[def.id];\n                var body = [];\n                var value = node.object.drop_side_effect_free(compressor);\n                if (value) {\n                    AST_Node.warn("Side effects in object of for-in loop [{start}]", value);\n                    body.push(make_node(AST_SimpleStatement, node, { body: value }));\n                }\n                if (node.init instanceof AST_Definitions && def.orig[0] instanceof AST_SymbolCatch) {\n                    body.push(node.init);\n                }\n                return insert_statements(body, node, in_list);\n            }\n            if (node instanceof AST_Import) {\n                if (node.properties && node.properties.length == 0) node.properties = null;\n                return node;\n            }\n            if (node instanceof AST_Sequence) {\n                if (node.expressions.length > 1) return;\n                return maintain_this_binding(tt.parent(), node, node.expressions[0]);\n            }\n        });\n        tt.push(compressor.parent());\n        tt.directives = Object.create(compressor.directives);\n        self.transform(tt);\n        if (self instanceof AST_Lambda\n            && self.body.length == 1\n            && self.body[0] instanceof AST_Directive\n            && self.body[0].value == "use strict") {\n            self.body.length = 0;\n        }\n        calls_to_drop_args.forEach(function(call) {\n            drop_unused_call_args(call, compressor, fns_with_marked_args);\n        });\n\n        function log(sym, text) {\n            AST_Node[sym.definition().references.length > 0 ? "info" : "warn"](text + " [{start}]", sym);\n        }\n\n        function log_default(node, text) {\n            if (node.name instanceof AST_SymbolFunarg) {\n                log(node.name, text);\n            } else {\n                AST_Node.info(text + " [{start}]", node);\n            }\n        }\n\n        function get_rvalue(expr) {\n            return expr[expr instanceof AST_Assign ? "right" : "value"];\n        }\n\n        function insert_statements(body, orig, in_list) {\n            switch (body.length) {\n              case 0:\n                return in_list ? List.skip : make_node(AST_EmptyStatement, orig);\n              case 1:\n                return body[0];\n              default:\n                return in_list ? List.splice(body) : make_node(AST_BlockStatement, orig, { body: body });\n            }\n        }\n\n        function track_assigns(def, node) {\n            if (def.scope.resolve() !== self) return false;\n            if (!def.fixed || !node.fixed) assign_in_use[def.id] = false;\n            return assign_in_use[def.id] !== false;\n        }\n\n        function add_assigns(def, node) {\n            if (!assign_in_use[def.id]) assign_in_use[def.id] = [];\n            if (node.fixed.assigns) push_uniq(assign_in_use[def.id], node.fixed.assigns);\n        }\n\n        function indexOf_assign(def, node) {\n            var nodes = assign_in_use[def.id];\n            return nodes && nodes.indexOf(node);\n        }\n\n        function unmark_lambda(def) {\n            if (lambda_ids[def.id] > 1 && !(def.id in in_use_ids)) {\n                in_use_ids[def.id] = true;\n                in_use.push(def);\n            }\n            lambda_ids[def.id] = 0;\n        }\n\n        function verify_safe_usage(def, read, modified) {\n            if (def.id in in_use_ids) return;\n            if (read && modified) {\n                in_use_ids[def.id] = read;\n                in_use.push(def);\n            } else {\n                value_read[def.id] = read;\n                value_modified[def.id] = modified;\n            }\n        }\n\n        function can_drop_lhs(sym, node) {\n            var def = sym.definition();\n            var in_use = in_use_ids[def.id];\n            if (!in_use) return true;\n            if (node[node instanceof AST_Assign ? "left" : "expression"] !== sym) return false;\n            return in_use === sym && def.references.length - def.replaced == 1 || indexOf_assign(def, node) < 0;\n        }\n\n        function get_rhs(assign) {\n            var rhs = assign.right;\n            if (!assign.write_only) return rhs;\n            if (!(rhs instanceof AST_Binary && lazy_op[rhs.operator])) return rhs;\n            if (!(rhs.left instanceof AST_SymbolRef)) return rhs;\n            if (!(assign.left instanceof AST_SymbolRef)) return rhs;\n            var def = assign.left.definition();\n            if (rhs.left.definition() !== def) return rhs;\n            if (rhs.right.has_side_effects(compressor)) return rhs;\n            if (track_assigns(def, rhs.left)) add_assigns(def, rhs.left);\n            return rhs.right;\n        }\n\n        function get_init_symbol(for_in) {\n            var init = for_in.init;\n            if (init instanceof AST_Definitions) {\n                init = init.definitions[0].name;\n                return init instanceof AST_SymbolDeclaration && init;\n            }\n            while (init instanceof AST_PropAccess) init = init.expression.tail_node();\n            if (init instanceof AST_SymbolRef) return init;\n        }\n\n        function scan_ref_scoped(node, descend, init) {\n            if (node instanceof AST_Assign && node.left instanceof AST_SymbolRef) {\n                var def = node.left.definition();\n                if (def.scope.resolve() === self) assignments.add(def.id, node);\n            }\n            if (node instanceof AST_SymbolRef && node.in_arg) var_defs[node.definition().id] = 0;\n            if (node instanceof AST_Unary && node.expression instanceof AST_SymbolRef) {\n                var def = node.expression.definition();\n                if (def.scope.resolve() === self) assignments.add(def.id, node);\n            }\n            var props = [], sym = assign_as_unused(node, props);\n            if (sym) {\n                var node_def = sym.definition();\n                if (node_def.scope.resolve() !== self && self.variables.get(sym.name) !== node_def) return;\n                if (is_arguments(node_def) && !all(self.argnames, function(argname) {\n                    return !argname.match_symbol(function(node) {\n                        if (node instanceof AST_SymbolFunarg) {\n                            var def = node.definition();\n                            return def.references.length > def.replaced;\n                        }\n                    }, true);\n                })) return;\n                if (node.write_only === "p" && node.right.may_throw_on_access(compressor, true)) return;\n                var assign = props.assign;\n                if (assign) {\n                    initializations.add(node_def.id, assign.left);\n                    assign.write_only = true;\n                    assign.walk(tw);\n                }\n                props.forEach(function(prop) {\n                    prop.walk(tw);\n                });\n                if (node instanceof AST_Assign) {\n                    var fixed = sym.fixed_value();\n                    var right = get_rhs(node);\n                    var safe = fixed && fixed.is_constant();\n                    var shared = false;\n                    if (init\n                        && node.write_only === true\n                        && (safe || node.left === sym || right.equals(sym))\n                        && !right.has_side_effects(compressor)) {\n                        initializations.add(node_def.id, right);\n                    } else {\n                        right.walk(tw);\n                        shared = right.tail_node().operator == "=";\n                    }\n                    if (node.left === sym) {\n                        if (!node.write_only || shared) {\n                            verify_safe_usage(node_def, sym, value_modified[node_def.id]);\n                        }\n                    } else if (!safe) {\n                        verify_safe_usage(node_def, value_read[node_def.id], true);\n                    }\n                }\n                if (track_assigns(node_def, sym) && is_lhs(sym, node) !== sym) add_assigns(node_def, sym);\n                unmark_lambda(node_def);\n                return true;\n            }\n            if (node instanceof AST_Binary) {\n                if (node.operator != "instanceof") return;\n                var sym = node.right;\n                if (!(sym instanceof AST_SymbolRef)) return;\n                var id = sym.definition().id;\n                if (!lambda_ids[id]) return;\n                node.left.walk(tw);\n                lambda_ids[id]++;\n                return true;\n            }\n            if (node instanceof AST_ForIn) {\n                if (node.init instanceof AST_SymbolRef && scope === self) {\n                    var id = node.init.definition().id;\n                    if (!(id in for_ins)) for_ins[id] = node;\n                }\n                if (!drop_vars || !compressor.option("loops")) return;\n                if (!is_empty(node.body)) return;\n                if (node.init.has_side_effects(compressor)) return;\n                var sym = get_init_symbol(node);\n                if (!sym) return;\n                var def = sym.definition();\n                if (def.scope.resolve() !== self) {\n                    var d = find_variable(sym.name);\n                    if (d === def || d && d.redefined() === def) return;\n                }\n                node.object.walk(tw);\n                return true;\n            }\n            if (node instanceof AST_SymbolRef) {\n                var node_def = node.definition();\n                if (!(node_def.id in in_use_ids)) {\n                    in_use_ids[node_def.id] = true;\n                    in_use.push(node_def);\n                }\n                if (cross_scope(node_def.scope, node.scope)) {\n                    var redef = node_def.redefined();\n                    if (redef && !(redef.id in in_use_ids)) {\n                        in_use_ids[redef.id] = true;\n                        in_use.push(redef);\n                    }\n                }\n                if (track_assigns(node_def, node)) add_assigns(node_def, node);\n                return true;\n            }\n            if (node instanceof AST_Scope) {\n                var save_scope = scope;\n                scope = node;\n                descend();\n                scope = save_scope;\n                return true;\n            }\n        }\n\n        function is_decl(node) {\n            return (node instanceof AST_DefaultValue ? node.name : node) instanceof AST_SymbolDeclaration;\n        }\n\n        function trim_decl(node) {\n            if (node.definition().id in in_use_ids) return node;\n            if (node instanceof AST_SymbolFunarg) node.unused = true;\n            return null;\n        }\n\n        function trim_default(trimmer, node) {\n            node.value = node.value.transform(tt);\n            var name = node.name.transform(trimmer);\n            if (!name) {\n                if (node.name instanceof AST_Destructured) return null;\n                var value = node.value.drop_side_effect_free(compressor);\n                if (!value) return null;\n                log(node.name, "Side effects in default value of unused variable {name}");\n                node = node.clone();\n                node.name.unused = null;\n                node.value = value;\n            }\n            return node;\n        }\n\n        function trim_destructured(node, value, process, drop, root) {\n            var unwind = true;\n            var trimmer = new TreeTransformer(function(node) {\n                if (node instanceof AST_DefaultValue) {\n                    if (!(compressor.option("default_values") && value && value.is_defined(compressor))) {\n                        var save_drop = drop;\n                        drop = false;\n                        var trimmed = trim_default(trimmer, node);\n                        drop = save_drop;\n                        if (!trimmed && drop && value) value = value.drop_side_effect_free(compressor);\n                        return trimmed;\n                    } else if (node === root) {\n                        root = node = node.name;\n                    } else {\n                        node = node.name;\n                    }\n                }\n                if (node instanceof AST_DestructuredArray) {\n                    var save_drop = drop;\n                    var save_unwind = unwind;\n                    var save_value = value;\n                    if (value instanceof AST_SymbolRef) {\n                        drop = false;\n                        value = value.fixed_value();\n                    }\n                    var last_side_effects, native, values;\n                    if (value instanceof AST_Array) {\n                        native = true;\n                        values = value.elements;\n                        if (save_unwind) for (last_side_effects = values.length; --last_side_effects >= 0;) {\n                            if (values[last_side_effects].has_side_effects(compressor)) break;\n                        }\n                    } else {\n                        native = value && value.is_string(compressor);\n                        values = false;\n                        last_side_effects = node.elements.length;\n                    }\n                    var elements = [], newValues = drop && [], pos = 0;\n                    node.elements.forEach(function(element, index) {\n                        if (save_unwind) unwind = index >= last_side_effects;\n                        value = values && values[index];\n                        if (value instanceof AST_Hole) {\n                            value = null;\n                        } else if (value instanceof AST_Spread) {\n                            if (drop) {\n                                newValues.length = pos;\n                                fill_holes(save_value, newValues);\n                                [].push.apply(newValues, values.slice(index));\n                                save_value.elements = newValues;\n                            }\n                            value = values = false;\n                        }\n                        element = element.transform(trimmer);\n                        if (element) elements[pos] = element;\n                        if (drop && value) newValues[pos] = value;\n                        if (element || value || !drop || !values) pos++;\n                    });\n                    value = values && make_node(AST_Array, save_value, {\n                        elements: values.slice(node.elements.length),\n                    });\n                    if (node.rest) {\n                        var was_drop = drop;\n                        drop = false;\n                        node.rest = node.rest.transform(compressor.option("rests") ? trimmer : tt);\n                        drop = was_drop;\n                        if (node.rest) elements.length = pos;\n                    }\n                    if (drop) {\n                        if (value && !node.rest) value = value.drop_side_effect_free(compressor);\n                        if (value instanceof AST_Array) {\n                            value = value.elements;\n                        } else if (value instanceof AST_Sequence) {\n                            value = value.expressions;\n                        } else if (value) {\n                            value = [ value ];\n                        }\n                        if (value && value.length) {\n                            newValues.length = pos;\n                            [].push.apply(newValues, value);\n                        }\n                    }\n                    value = save_value;\n                    unwind = save_unwind;\n                    drop = save_drop;\n                    if (values && newValues) {\n                        fill_holes(value, newValues);\n                        value = value.clone();\n                        value.elements = newValues;\n                    }\n                    if (!native) {\n                        elements.length = node.elements.length;\n                    } else if (!node.rest) SHORTHAND: switch (elements.length) {\n                      case 0:\n                        if (node === root) break;\n                        if (drop) value = value.drop_side_effect_free(compressor);\n                        return null;\n                      default:\n                        if (!drop) break;\n                        if (!unwind) break;\n                        if (node === root) break;\n                        var pos = elements.length, sym;\n                        while (--pos >= 0) {\n                            var element = elements[pos];\n                            if (element) {\n                                sym = element;\n                                break;\n                            }\n                        }\n                        if (pos < 0) break;\n                        for (var i = pos; --i >= 0;) {\n                            if (elements[i]) break SHORTHAND;\n                        }\n                        if (sym.has_side_effects(compressor)) break;\n                        if (value.has_side_effects(compressor) && sym.match_symbol(function(node) {\n                            return node instanceof AST_PropAccess;\n                        })) break;\n                        value = make_node(AST_Sub, node, {\n                            expression: value,\n                            property: make_node(AST_Number, node, { value: pos }),\n                        });\n                        return sym;\n                    }\n                    fill_holes(node, elements);\n                    node.elements = elements;\n                    return node;\n                }\n                if (node instanceof AST_DestructuredObject) {\n                    var save_drop = drop;\n                    var save_unwind = unwind;\n                    var save_value = value;\n                    if (value instanceof AST_SymbolRef) {\n                        drop = false;\n                        value = value.fixed_value();\n                    }\n                    var last_side_effects, prop_keys, prop_map, values;\n                    if (value instanceof AST_Object) {\n                        last_side_effects = -1;\n                        prop_keys = [];\n                        prop_map = new Dictionary();\n                        values = value.properties.map(function(prop, index) {\n                            if (save_unwind && prop.has_side_effects(compressor)) last_side_effects = index;\n                            prop = prop.clone();\n                            if (prop instanceof AST_Spread) {\n                                prop_map = false;\n                            } else {\n                                var key = prop.key;\n                                if (key instanceof AST_Node) key = key.evaluate(compressor, true);\n                                if (key instanceof AST_Node) {\n                                    prop_map = false;\n                                } else if (prop_map && !(prop instanceof AST_ObjectSetter)) {\n                                    prop_map.set(key, prop);\n                                }\n                                prop_keys[index] = key;\n                            }\n                            return prop;\n                        });\n                    } else {\n                        last_side_effects = node.properties.length;\n                    }\n                    if (node.rest) {\n                        value = false;\n                        node.rest = node.rest.transform(compressor.option("rests") ? trimmer : tt);\n                    }\n                    var can_drop = new Dictionary();\n                    var drop_keys = drop && new Dictionary();\n                    var properties = [];\n                    node.properties.map(function(prop) {\n                        var key = prop.key;\n                        if (key instanceof AST_Node) {\n                            prop.key = key = key.transform(tt);\n                            key = key.evaluate(compressor, true);\n                        }\n                        if (key instanceof AST_Node) {\n                            drop_keys = false;\n                        } else {\n                            can_drop.set(key, !can_drop.has(key));\n                        }\n                        return key;\n                    }).forEach(function(key, index) {\n                        var prop = node.properties[index], trimmed;\n                        if (save_unwind) unwind = index >= last_side_effects;\n                        if (key instanceof AST_Node) {\n                            drop = false;\n                            value = false;\n                            trimmed = prop.value.transform(trimmer) || retain_lhs(prop.value);\n                        } else {\n                            drop = drop_keys && can_drop.get(key);\n                            var mapped = prop_map && prop_map.get(key);\n                            if (mapped) {\n                                value = mapped.value;\n                                if (value instanceof AST_Accessor) value = false;\n                            } else {\n                                value = false;\n                            }\n                            trimmed = prop.value.transform(trimmer);\n                            if (!trimmed) {\n                                if (node.rest || retain_key(prop)) trimmed = retain_lhs(prop.value);\n                                if (drop_keys && !drop_keys.has(key)) {\n                                    if (mapped) {\n                                        drop_keys.set(key, mapped);\n                                        if (value === null) {\n                                            prop_map.set(key, retain_key(mapped) && make_node(AST_ObjectKeyVal, mapped, {\n                                                key: mapped.key,\n                                                value: make_node(AST_Number, mapped, { value: 0 }),\n                                            }));\n                                        }\n                                    } else {\n                                        drop_keys.set(key, true);\n                                    }\n                                }\n                            } else if (drop_keys) {\n                                drop_keys.set(key, false);\n                            }\n                            if (value) mapped.value = value;\n                        }\n                        if (trimmed) {\n                            prop.value = trimmed;\n                            properties.push(prop);\n                        }\n                    });\n                    value = save_value;\n                    unwind = save_unwind;\n                    drop = save_drop;\n                    if (drop_keys && prop_keys) {\n                        value = value.clone();\n                        value.properties = List(values, function(prop, index) {\n                            if (prop instanceof AST_Spread) return prop;\n                            var key = prop_keys[index];\n                            if (key instanceof AST_Node) return prop;\n                            if (key === "__proto__") return prop;\n                            if (drop_keys.has(key)) {\n                                var mapped = drop_keys.get(key);\n                                if (!mapped) return prop;\n                                if (mapped === prop) return prop_map.get(key) || List.skip;\n                            } else if (node.rest) {\n                                return prop;\n                            }\n                            var trimmed = prop.value.drop_side_effect_free(compressor);\n                            if (trimmed) {\n                                prop.value = trimmed;\n                                return prop;\n                            }\n                            return retain_key(prop) ? make_node(AST_ObjectKeyVal, prop, {\n                                key: prop.key,\n                                value: make_node(AST_Number, prop, { value: 0 }),\n                            }) : List.skip;\n                        });\n                    }\n                    if (value && !node.rest) switch (properties.length) {\n                      case 0:\n                        if (node === root) break;\n                        if (value.may_throw_on_access(compressor, true)) break;\n                        if (drop) value = value.drop_side_effect_free(compressor);\n                        return null;\n                      case 1:\n                        if (!drop) break;\n                        if (!unwind) break;\n                        if (node === root) break;\n                        var prop = properties[0];\n                        if (prop.key instanceof AST_Node) break;\n                        if (prop.value.has_side_effects(compressor)) break;\n                        if (value.has_side_effects(compressor) && prop.value.match_symbol(function(node) {\n                            return node instanceof AST_PropAccess;\n                        })) break;\n                        value = is_identifier_string(prop.key) ? make_node(AST_Dot, node, {\n                            expression: value,\n                            property: prop.key,\n                        }) : make_node(AST_Sub, node, {\n                            expression: value,\n                            property: make_node_from_constant(prop.key, prop),\n                        });\n                        return prop.value;\n                    }\n                    node.properties = properties;\n                    return node;\n                }\n                if (node instanceof AST_Hole) {\n                    node = null;\n                } else {\n                    node = process(node);\n                }\n                if (!node && drop && value) value = value.drop_side_effect_free(compressor);\n                return node;\n            });\n            return {\n                name: node.transform(trimmer),\n                value: value,\n            };\n\n            function retain_key(prop) {\n                return prop.key instanceof AST_Node && prop.key.has_side_effects(compressor);\n            }\n\n            function clear_write_only(node) {\n                if (node instanceof AST_Assign) {\n                    node.write_only = false;\n                    clear_write_only(node.right);\n                } else if (node instanceof AST_Binary) {\n                    if (!lazy_op[node.operator]) return;\n                    clear_write_only(node.left);\n                    clear_write_only(node.right);\n                } else if (node instanceof AST_Conditional) {\n                    clear_write_only(node.consequent);\n                    clear_write_only(node.alternative);\n                } else if (node instanceof AST_Sequence) {\n                    clear_write_only(node.tail_node());\n                } else if (node instanceof AST_Unary) {\n                    node.write_only = false;\n                }\n            }\n\n            function retain_lhs(node) {\n                if (node instanceof AST_DefaultValue) return retain_lhs(node.name);\n                if (node instanceof AST_Destructured) {\n                    if (value === null) {\n                        value = make_node(AST_Number, node, { value: 0 });\n                    } else if (value) {\n                        if (value.may_throw_on_access(compressor, true)) {\n                            value = make_node(AST_Array, node, {\n                                elements: value instanceof AST_Sequence ? value.expressions : [ value ],\n                            });\n                        } else {\n                            clear_write_only(value);\n                        }\n                    }\n                    return make_node(AST_DestructuredObject, node, { properties: [] });\n                }\n                node.unused = null;\n                return node;\n            }\n        }\n    });\n\n    AST_Scope.DEFMETHOD("hoist_declarations", function(compressor) {\n        if (compressor.has_directive("use asm")) return;\n        var hoist_funs = compressor.option("hoist_funs");\n        var hoist_vars = compressor.option("hoist_vars");\n        var self = this;\n        if (hoist_vars) {\n            // let\'s count var_decl first, we seem to waste a lot of\n            // space if we hoist `var` when there\'s only one.\n            var var_decl = 0;\n            self.walk(new TreeWalker(function(node) {\n                if (var_decl > 1) return true;\n                if (node instanceof AST_ExportDeclaration) return true;\n                if (node instanceof AST_Scope && node !== self) return true;\n                if (node instanceof AST_Var) {\n                    var_decl++;\n                    return true;\n                }\n            }));\n            if (var_decl <= 1) hoist_vars = false;\n        }\n        if (!hoist_funs && !hoist_vars) return;\n        var consts = new Dictionary();\n        var dirs = [];\n        var hoisted = [];\n        var vars = new Dictionary();\n        var tt = new TreeTransformer(function(node, descend, in_list) {\n            if (node === self) return;\n            if (node instanceof AST_Directive) {\n                dirs.push(node);\n                return in_list ? List.skip : make_node(AST_EmptyStatement, node);\n            }\n            if (node instanceof AST_LambdaDefinition) {\n                if (!hoist_funs) return node;\n                var p = tt.parent();\n                if (p instanceof AST_ExportDeclaration) return node;\n                if (p instanceof AST_ExportDefault) return node;\n                if (p !== self && compressor.has_directive("use strict")) return node;\n                hoisted.push(node);\n                return in_list ? List.skip : make_node(AST_EmptyStatement, node);\n            }\n            if (node instanceof AST_Var) {\n                if (!hoist_vars) return node;\n                var p = tt.parent();\n                if (p instanceof AST_ExportDeclaration) return node;\n                if (!all(node.definitions, function(defn) {\n                    var sym = defn.name;\n                    return sym instanceof AST_SymbolVar\n                        && !consts.has(sym.name)\n                        && self.find_variable(sym.name) === sym.definition();\n                })) return node;\n                node.definitions.forEach(function(defn) {\n                    var name = defn.name.name;\n                    if (!vars.has(name)) vars.set(name, defn);\n                });\n                var seq = node.to_assignments();\n                if (p instanceof AST_ForEnumeration && p.init === node) {\n                    if (seq) return seq;\n                    var sym = node.definitions[0].name;\n                    return make_node(AST_SymbolRef, sym);\n                }\n                if (p instanceof AST_For && p.init === node) return seq;\n                if (!seq) return in_list ? List.skip : make_node(AST_EmptyStatement, node);\n                return make_node(AST_SimpleStatement, node, { body: seq });\n            }\n            if (node instanceof AST_Scope) return node;\n            if (node instanceof AST_SymbolConst) {\n                consts.set(node.name, true);\n                return node;\n            }\n        });\n        self.transform(tt);\n        if (vars.size() > 0) {\n            // collect only vars which don\'t show up in self\'s arguments list\n            var defns = [];\n            if (self instanceof AST_Lambda) self.each_argname(function(argname) {\n                if (all(argname.definition().references, function(ref) {\n                    return !ref.in_arg;\n                })) vars.del(argname.name);\n            });\n            vars.each(function(defn) {\n                var name = defn.name;\n                defn = defn.clone();\n                defn.name = name.clone();\n                defn.value = null;\n                defns.push(defn);\n                var orig = name.definition().orig;\n                orig.splice(orig.indexOf(name), 0, defn.name);\n            });\n            if (defns.length > 0) hoisted.push(make_node(AST_Var, self, { definitions: defns }));\n        }\n        self.body = dirs.concat(hoisted, self.body);\n    });\n\n    function scan_local_returns(fn, transform) {\n        fn.walk(new TreeWalker(function(node) {\n            if (node instanceof AST_Return) {\n                transform(node);\n                return true;\n            }\n            if (node instanceof AST_Scope && node !== fn) return true;\n        }));\n    }\n\n    function map_self_returns(fn) {\n        var map = Object.create(null);\n        scan_local_returns(fn, function(node) {\n            var value = node.value;\n            if (value) value = value.tail_node();\n            if (value instanceof AST_SymbolRef) {\n                var id = value.definition().id;\n                map[id] = (map[id] || 0) + 1;\n            }\n        });\n        return map;\n    }\n\n    function can_trim_returns(def, self_returns, compressor) {\n        if (compressor.exposed(def)) return false;\n        switch (def.references.length - def.replaced - (self_returns[def.id] || 0)) {\n          case def.drop_return:\n            return "d";\n          case def.bool_return:\n            return true;\n        }\n    }\n\n    function process_boolean_returns(fn, compressor) {\n        scan_local_returns(fn, function(node) {\n            node.in_bool = true;\n            var value = node.value;\n            if (value) {\n                var ev = fuzzy_eval(compressor, value);\n                if (!ev) {\n                    value = value.drop_side_effect_free(compressor);\n                    node.value = value ? make_sequence(node.value, [\n                        value,\n                        make_node(AST_Number, node.value, { value: 0 }),\n                    ]) : null;\n                } else if (!(ev instanceof AST_Node)) {\n                    value = value.drop_side_effect_free(compressor);\n                    node.value = value ? make_sequence(node.value, [\n                        value,\n                        make_node(AST_Number, node.value, { value: 1 }),\n                    ]) : make_node(AST_Number, node.value, { value: 1 });\n                }\n            }\n        });\n    }\n\n    AST_Scope.DEFMETHOD("process_returns", noop);\n    AST_Defun.DEFMETHOD("process_returns", function(compressor) {\n        if (!compressor.option("booleans")) return;\n        if (compressor.parent() instanceof AST_ExportDefault) return;\n        switch (can_trim_returns(this.name.definition(), map_self_returns(this), compressor)) {\n          case "d":\n            drop_returns(compressor, this, true);\n            break;\n          case true:\n            process_boolean_returns(this, compressor);\n            break;\n        }\n    });\n    AST_Function.DEFMETHOD("process_returns", function(compressor) {\n        if (!compressor.option("booleans")) return;\n        var drop = true;\n        var self_returns = map_self_returns(this);\n        if (this.name && !can_trim(this.name.definition())) return;\n        var parent = compressor.parent();\n        if (parent instanceof AST_Assign) {\n            if (parent.operator != "=") return;\n            var sym = parent.left;\n            if (!(sym instanceof AST_SymbolRef)) return;\n            if (!can_trim(sym.definition())) return;\n        } else if (parent instanceof AST_Call && parent.expression !== this) {\n            var exp = parent.expression;\n            if (exp instanceof AST_SymbolRef) exp = exp.fixed_value();\n            if (!(exp instanceof AST_Lambda)) return;\n            if (exp.uses_arguments || exp.pinned()) return;\n            var args = parent.args, sym;\n            for (var i = 0; i < args.length; i++) {\n                var arg = args[i];\n                if (arg === this) {\n                    sym = exp.argnames[i];\n                    if (!sym && exp.rest) return;\n                    break;\n                }\n                if (arg instanceof AST_Spread) return;\n            }\n            if (sym instanceof AST_DefaultValue) sym = sym.name;\n            if (sym instanceof AST_SymbolFunarg && !can_trim(sym.definition())) return;\n        } else if (parent.TYPE == "Call") {\n            compressor.pop();\n            var in_bool = compressor.in_boolean_context();\n            compressor.push(this);\n            switch (in_bool) {\n              case true:\n                drop = false;\n              case "d":\n                break;\n              default:\n                return;\n            }\n        } else return;\n        if (drop) {\n            drop_returns(compressor, this, true);\n        } else {\n            process_boolean_returns(this, compressor);\n        }\n\n        function can_trim(def) {\n            switch (can_trim_returns(def, self_returns, compressor)) {\n              case true:\n                drop = false;\n              case "d":\n                return true;\n            }\n        }\n    });\n\n    AST_BlockScope.DEFMETHOD("var_names", function() {\n        var var_names = this._var_names;\n        if (!var_names) {\n            this._var_names = var_names = new Dictionary();\n            this.enclosed.forEach(function(def) {\n                var_names.set(def.name, true);\n            });\n            this.variables.each(function(def, name) {\n                var_names.set(name, true);\n            });\n        }\n        return var_names;\n    });\n\n    AST_Scope.DEFMETHOD("make_var", function(type, orig, prefix) {\n        var scopes = [ this ];\n        if (orig instanceof AST_SymbolDeclaration) orig.definition().references.forEach(function(ref) {\n            var s = ref.scope;\n            do {\n                if (!push_uniq(scopes, s)) return;\n                s = s.parent_scope;\n            } while (s && s !== this);\n        });\n        prefix = prefix.replace(/^[^a-z_$]|[^a-z0-9_$]/gi, "_");\n        var name = prefix;\n        for (var i = 0; !all(scopes, function(scope) {\n            return !scope.var_names().has(name);\n        }); i++) name = prefix + "$" + i;\n        var sym = make_node(type, orig, {\n            name: name,\n            scope: this,\n        });\n        var def = this.def_variable(sym);\n        scopes.forEach(function(scope) {\n            scope.enclosed.push(def);\n            scope.var_names().set(name, true);\n        });\n        return sym;\n    });\n\n    AST_Scope.DEFMETHOD("hoist_properties", function(compressor) {\n        if (!compressor.option("hoist_props") || compressor.has_directive("use asm")) return;\n        var self = this;\n        if (is_arrow(self) && self.value) return;\n        var top_retain = self instanceof AST_Toplevel && compressor.top_retain || return_false;\n        var defs_by_id = Object.create(null);\n        var tt = new TreeTransformer(function(node, descend) {\n            if (node instanceof AST_Assign) {\n                if (node.operator != "=") return;\n                if (!node.write_only) return;\n                if (!can_hoist(node.left, node.right, 1)) return;\n                descend(node, tt);\n                var defs = new Dictionary();\n                var assignments = [];\n                var decls = [];\n                node.right.properties.forEach(function(prop) {\n                    var decl = make_sym(AST_SymbolVar, node.left, prop.key);\n                    decls.push(make_node(AST_VarDef, node, {\n                        name: decl,\n                        value: null,\n                    }));\n                    var sym = make_node(AST_SymbolRef, node, {\n                        name: decl.name,\n                        scope: self,\n                        thedef: decl.definition(),\n                    });\n                    sym.reference();\n                    assignments.push(make_node(AST_Assign, node, {\n                        operator: "=",\n                        left: sym,\n                        right: prop.value,\n                    }));\n                });\n                defs.value = node.right;\n                defs_by_id[node.left.definition().id] = defs;\n                self.body.splice(self.body.indexOf(tt.stack[1]) + 1, 0, make_node(AST_Var, node, {\n                    definitions: decls,\n                }));\n                return make_sequence(node, assignments);\n            }\n            if (node instanceof AST_Scope) {\n                if (node === self) return;\n                var parent = tt.parent();\n                if (parent.TYPE == "Call" && parent.expression === node) return;\n                return node;\n            }\n            if (node instanceof AST_VarDef) {\n                if (!can_hoist(node.name, node.value, 0)) return;\n                descend(node, tt);\n                var defs = new Dictionary();\n                var var_defs = [];\n                var decl = node.clone();\n                decl.value = node.name instanceof AST_SymbolConst ? make_node(AST_Number, node, { value: 0 }) : null;\n                var_defs.push(decl);\n                node.value.properties.forEach(function(prop) {\n                    var_defs.push(make_node(AST_VarDef, node, {\n                        name: make_sym(node.name.CTOR, node.name, prop.key),\n                        value: prop.value,\n                    }));\n                });\n                defs.value = node.value;\n                defs_by_id[node.name.definition().id] = defs;\n                return List.splice(var_defs);\n            }\n\n            function make_sym(type, sym, key) {\n                var new_var = self.make_var(type, sym, sym.name + "_" + key);\n                defs.set(key, new_var.definition());\n                return new_var;\n            }\n        });\n        self.transform(tt);\n        self.transform(new TreeTransformer(function(node, descend) {\n            if (node instanceof AST_PropAccess) {\n                if (!(node.expression instanceof AST_SymbolRef)) return;\n                var defs = defs_by_id[node.expression.definition().id];\n                if (!defs) return;\n                if (node.expression.fixed_value() !== defs.value) return;\n                var def = defs.get(node.get_property());\n                var sym = make_node(AST_SymbolRef, node, {\n                    name: def.name,\n                    scope: node.expression.scope,\n                    thedef: def,\n                });\n                sym.reference();\n                return sym;\n            }\n            if (node instanceof AST_SymbolRef) {\n                var defs = defs_by_id[node.definition().id];\n                if (!defs) return;\n                if (node.fixed_value() !== defs.value) return;\n                return make_node(AST_Object, node, { properties: [] });\n            }\n        }));\n\n        function can_hoist(sym, right, count) {\n            if (!(sym instanceof AST_Symbol)) return;\n            var def = sym.definition();\n            if (def.assignments != count) return;\n            if (def.references.length - def.replaced == count) return;\n            if (def.single_use) return;\n            if (self.find_variable(sym.name) !== def) return;\n            if (top_retain(def)) return;\n            if (sym.fixed_value() !== right) return;\n            var fixed = sym.fixed || def.fixed;\n            if (fixed.direct_access) return;\n            if (fixed.escaped && fixed.escaped.depth == 1) return;\n            return right instanceof AST_Object\n                && right.properties.length > 0\n                && can_drop_symbol(sym, compressor)\n                && all(right.properties, function(prop) {\n                    return can_hoist_property(prop) && prop.key !== "__proto__";\n                });\n        }\n    });\n\n    function fn_name_unused(fn, compressor) {\n        if (!fn.name || !compressor.option("ie")) return true;\n        var def = fn.name.definition();\n        if (compressor.exposed(def)) return false;\n        return all(def.references, function(sym) {\n            return !(sym instanceof AST_SymbolRef);\n        });\n    }\n\n    function drop_returns(compressor, exp, ignore_name) {\n        if (!(exp instanceof AST_Lambda)) return;\n        var arrow = is_arrow(exp);\n        var async = is_async(exp);\n        var changed = false;\n        var drop_body = false;\n        if (arrow && compressor.option("arrows")) {\n            if (!exp.value) {\n                drop_body = true;\n            } else if (!async || needs_enqueuing(compressor, exp.value)) {\n                var dropped = exp.value.drop_side_effect_free(compressor);\n                if (dropped !== exp.value) {\n                    changed = true;\n                    exp.value = dropped;\n                }\n            }\n        } else if (!is_generator(exp)) {\n            if (!ignore_name && exp.name) {\n                var def = exp.name.definition();\n                drop_body = def.references.length == def.replaced;\n            } else {\n                drop_body = true;\n            }\n        }\n        if (drop_body) {\n            exp.process_expression(false, function(node) {\n                var value = node.value;\n                if (value) {\n                    if (async && !needs_enqueuing(compressor, value)) return node;\n                    value = value.drop_side_effect_free(compressor, true);\n                }\n                changed = true;\n                if (!value) return make_node(AST_EmptyStatement, node);\n                return make_node(AST_SimpleStatement, node, { body: value });\n            });\n            scan_local_returns(exp, function(node) {\n                var value = node.value;\n                if (value) {\n                    if (async && !needs_enqueuing(compressor, value)) return;\n                    var dropped = value.drop_side_effect_free(compressor);\n                    if (dropped !== value) {\n                        changed = true;\n                        if (dropped && async && !needs_enqueuing(compressor, dropped)) {\n                            dropped = dropped.negate(compressor);\n                        }\n                        node.value = dropped;\n                    }\n                }\n            });\n        }\n        if (async && compressor.option("awaits")) {\n            if (drop_body) exp.process_expression("awaits", function(node) {\n                var body = node.body;\n                if (body instanceof AST_Await) {\n                    if (needs_enqueuing(compressor, body.expression)) {\n                        changed = true;\n                        body = body.expression.drop_side_effect_free(compressor, true);\n                        if (!body) return make_node(AST_EmptyStatement, node);\n                        node.body = body;\n                    }\n                } else if (body instanceof AST_Sequence) {\n                    var exprs = body.expressions;\n                    for (var i = exprs.length; --i >= 0;) {\n                        var tail = exprs[i];\n                        if (!(tail instanceof AST_Await)) break;\n                        var value = tail.expression;\n                        if (!needs_enqueuing(compressor, value)) break;\n                        changed = true;\n                        if (exprs[i] = value.drop_side_effect_free(compressor)) break;\n                    }\n                    switch (i) {\n                      case -1:\n                        return make_node(AST_EmptyStatement, node);\n                      case 0:\n                        node.body = exprs[0];\n                        break;\n                      default:\n                        exprs.length = i + 1;\n                        break;\n                    }\n                }\n                return node;\n            });\n            var abort = !drop_body && exp.name || arrow && exp.value && !needs_enqueuing(compressor, exp.value);\n            var tw = new TreeWalker(function(node) {\n                if (abort) return true;\n                if (tw.parent() === exp && node.may_throw(compressor)) return abort = true;\n                if (node instanceof AST_Await) return abort = true;\n                if (node instanceof AST_ForAwaitOf) return abort = true;\n                if (node instanceof AST_Return) {\n                    if (node.value && !needs_enqueuing(compressor, node.value)) return abort = true;\n                    return;\n                }\n                if (node instanceof AST_Scope && node !== exp) return true;\n            });\n            exp.walk(tw);\n            if (!abort) {\n                var ctor;\n                switch (exp.CTOR) {\n                  case AST_AsyncArrow:\n                    ctor = AST_Arrow;\n                    break;\n                  case AST_AsyncFunction:\n                    ctor = AST_Function;\n                    break;\n                  case AST_AsyncGeneratorFunction:\n                    ctor = AST_GeneratorFunction;\n                    break;\n                }\n                return make_node(ctor, exp);\n            }\n        }\n        return changed && exp.clone();\n    }\n\n    // drop_side_effect_free()\n    // remove side-effect-free parts which only affects return value\n    (function(def) {\n        // Drop side-effect-free elements from an array of expressions.\n        // Returns an array of expressions with side-effects or null\n        // if all elements were dropped. Note: original array may be\n        // returned if nothing changed.\n        function trim(nodes, compressor, first_in_statement, spread) {\n            var len = nodes.length;\n            var ret = [], changed = false;\n            for (var i = 0; i < len; i++) {\n                var node = nodes[i];\n                var trimmed;\n                if (spread && node instanceof AST_Spread) {\n                    trimmed = spread(node, compressor, first_in_statement);\n                } else {\n                    trimmed = node.drop_side_effect_free(compressor, first_in_statement);\n                }\n                if (trimmed !== node) changed = true;\n                if (trimmed) {\n                    ret.push(trimmed);\n                    first_in_statement = false;\n                }\n            }\n            return ret.length ? changed ? ret : nodes : null;\n        }\n        function array_spread(node, compressor, first_in_statement) {\n            var exp = node.expression;\n            if (!exp.is_string(compressor)) return node;\n            return exp.drop_side_effect_free(compressor, first_in_statement);\n        }\n        function convert_spread(node) {\n            return node instanceof AST_Spread ? make_node(AST_Array, node, { elements: [ node ] }) : node;\n        }\n        def(AST_Node, return_this);\n        def(AST_Accessor, return_null);\n        def(AST_Array, function(compressor, first_in_statement) {\n            var values = trim(this.elements, compressor, first_in_statement, array_spread);\n            if (!values) return null;\n            if (values === this.elements && all(values, function(node) {\n                return node instanceof AST_Spread;\n            })) return this;\n            return make_sequence(this, values.map(convert_spread));\n        });\n        def(AST_Assign, function(compressor) {\n            var left = this.left;\n            if (left instanceof AST_PropAccess) {\n                var expr = left.expression;\n                if (expr.may_throw_on_access(compressor, true)) return this;\n                if (compressor.has_directive("use strict") && expr.is_constant()) return this;\n            }\n            if (left.has_side_effects(compressor)) return this;\n            if (lazy_op[this.operator.slice(0, -1)]) return this;\n            this.write_only = true;\n            if (!root_expr(left).is_constant_expression(compressor.find_parent(AST_Scope))) return this;\n            return this.right.drop_side_effect_free(compressor);\n        });\n        def(AST_Await, function(compressor) {\n            if (!compressor.option("awaits")) return this;\n            var exp = this.expression;\n            if (!needs_enqueuing(compressor, exp)) return this;\n            if (exp instanceof AST_UnaryPrefix && exp.operator == "!") exp = exp.expression;\n            var dropped = exp.drop_side_effect_free(compressor);\n            if (dropped === exp) return this;\n            if (!dropped) {\n                dropped = make_node(AST_Number, exp, { value: 0 });\n            } else if (!needs_enqueuing(compressor, dropped)) {\n                dropped = dropped.negate(compressor);\n            }\n            var node = this.clone();\n            node.expression = dropped;\n            return node;\n        });\n        def(AST_Binary, function(compressor, first_in_statement) {\n            var left = this.left;\n            var right = this.right;\n            var op = this.operator;\n            if (!can_drop_op(this, compressor)) {\n                var lhs = left.drop_side_effect_free(compressor, first_in_statement);\n                if (lhs === left) return this;\n                var node = this.clone();\n                if (lhs) {\n                    node.left = lhs;\n                } else if (op == "instanceof" && !left.is_constant()) {\n                    node.left = make_node(AST_Array, left, { elements: [] });\n                } else {\n                    node.left = make_node(AST_Number, left, { value: 0 });\n                }\n                return node;\n            }\n            var rhs = right.drop_side_effect_free(compressor, first_in_statement);\n            if (!rhs) return left.drop_side_effect_free(compressor, first_in_statement);\n            if (lazy_op[op] && rhs.has_side_effects(compressor)) {\n                var node = this;\n                if (rhs !== right) {\n                    node = node.clone();\n                    node.right = rhs.drop_side_effect_free(compressor);\n                }\n                if (op == "??") return node;\n                var negated = node.clone();\n                negated.operator = op == "&&" ? "||" : "&&";\n                negated.left = left.negate(compressor, first_in_statement);\n                var negated_rhs = negated.right.tail_node();\n                if (negated_rhs instanceof AST_Binary && negated.operator == negated_rhs.operator) swap_chain(negated);\n                var best = first_in_statement ? best_of_statement : best_of_expression;\n                return op == "&&" ? best(node, negated) : best(negated, node);\n            }\n            var lhs = left.drop_side_effect_free(compressor, first_in_statement);\n            if (!lhs) return rhs;\n            rhs = rhs.drop_side_effect_free(compressor);\n            if (!rhs) return lhs;\n            return make_sequence(this, [ lhs, rhs ]);\n        });\n        function assign_this_only(fn, compressor) {\n            fn.new = true;\n            var result = all(fn.body, function(stat) {\n                return !stat.has_side_effects(compressor);\n            }) && all(fn.argnames, function(argname) {\n                return !argname.match_symbol(return_false);\n            }) && !(fn.rest && fn.rest.match_symbol(return_false));\n            fn.new = false;\n            return result;\n        }\n        def(AST_Call, function(compressor, first_in_statement) {\n            var self = this;\n            if (self.is_expr_pure(compressor)) {\n                if (self.pure) AST_Node.warn("Dropping __PURE__ call [{start}]", self);\n                var args = trim(self.args, compressor, first_in_statement, array_spread);\n                return args && make_sequence(self, args.map(convert_spread));\n            }\n            var exp = self.expression;\n            if (self.is_call_pure(compressor)) {\n                var exprs = self.args.slice();\n                exprs.unshift(exp.expression);\n                exprs = trim(exprs, compressor, first_in_statement, array_spread);\n                return exprs && make_sequence(self, exprs.map(convert_spread));\n            }\n            if (compressor.option("yields") && is_generator(exp) && fn_name_unused(exp, compressor)) {\n                var call = self.clone();\n                call.expression = make_node(AST_Function, exp);\n                call.expression.body = [];\n                return call;\n            }\n            var dropped = drop_returns(compressor, exp);\n            if (dropped) {\n                // always shallow clone to ensure stripping of negated IIFEs\n                self = self.clone();\n                self.expression = dropped;\n                // avoid extraneous traversal\n                if (exp._squeezed) self.expression._squeezed = true;\n            }\n            if (self instanceof AST_New) {\n                var fn = exp;\n                if (fn instanceof AST_SymbolRef) fn = fn.fixed_value();\n                if (fn instanceof AST_Lambda) {\n                    if (assign_this_only(fn, compressor)) {\n                        var exprs = self.args.slice();\n                        exprs.unshift(exp);\n                        exprs = trim(exprs, compressor, first_in_statement, array_spread);\n                        return exprs && make_sequence(self, exprs.map(convert_spread));\n                    }\n                    if (!fn.contains_this()) {\n                        self = make_node(AST_Call, self);\n                        self.expression = self.expression.clone();\n                        self.args = self.args.slice();\n                    }\n                }\n            }\n            self.call_only = true;\n            return self;\n        });\n        def(AST_ClassExpression, function(compressor, first_in_statement) {\n            var self = this;\n            var exprs = [], values = [], init = 0;\n            var props = self.properties;\n            for (var i = 0; i < props.length; i++) {\n                var prop = props[i];\n                if (prop.key instanceof AST_Node) exprs.push(prop.key);\n                if (!is_static_field_or_init(prop)) continue;\n                var value = prop.value;\n                if (!value.has_side_effects(compressor)) continue;\n                if (value.contains_this()) return self;\n                if (prop instanceof AST_ClassInit) {\n                    init++;\n                    values.push(prop);\n                } else {\n                    values.push(value);\n                }\n            }\n            var base = self.extends;\n            if (base) {\n                if (base instanceof AST_SymbolRef) base = base.fixed_value();\n                base = !safe_for_extends(base);\n                if (!base) exprs.unshift(self.extends);\n            }\n            exprs = trim(exprs, compressor, first_in_statement);\n            if (exprs) first_in_statement = false;\n            values = trim(values, compressor, first_in_statement);\n            if (!exprs) {\n                if (!base && !values && !self.name) return null;\n                exprs = [];\n            }\n            if (base || self.name || !compressor.has_directive("use strict")) {\n                var node = to_class_expr(self);\n                if (!base) node.extends = null;\n                node.properties = [];\n                if (values) {\n                    if (values.length == init) {\n                        if (exprs.length) values.unshift(make_node(AST_ClassField, self, {\n                            key: make_sequence(self, exprs),\n                            value: null,\n                        }));\n                        node.properties = values;\n                    } else node.properties.push(make_node(AST_ClassField, self, {\n                        static: true,\n                        key: exprs.length ? make_sequence(self, exprs) : "c",\n                        value: make_value(),\n                    }));\n                } else if (exprs.length) node.properties.push(make_node(AST_ClassMethod, self, {\n                    key: make_sequence(self, exprs),\n                    value: make_node(AST_Function, self, {\n                        argnames: [],\n                        body: [],\n                    }).init_vars(node),\n                }));\n                return node;\n            }\n            if (values) exprs.push(make_node(AST_Call, self, {\n                expression: make_node(AST_Arrow, self, {\n                    argnames: [],\n                    body: [],\n                    value: make_value(),\n                }).init_vars(self.parent_scope, self),\n                args: [],\n            }));\n            return make_sequence(self, exprs);\n\n            function make_value() {\n                return make_sequence(self, values.map(function(node) {\n                    if (!(node instanceof AST_ClassInit)) return node;\n                    var fn = make_node(AST_Arrow, node.value);\n                    fn.argnames = [];\n                    return make_node(AST_Call, node, {\n                        expression: fn,\n                        args: [],\n                    });\n                }));\n            }\n        });\n        def(AST_Conditional, function(compressor) {\n            var consequent = this.consequent.drop_side_effect_free(compressor);\n            var alternative = this.alternative.drop_side_effect_free(compressor);\n            if (consequent === this.consequent && alternative === this.alternative) return this;\n            var exprs;\n            if (compressor.option("ie")) {\n                exprs = [];\n                if (consequent instanceof AST_Function) {\n                    exprs.push(consequent);\n                    consequent = null;\n                }\n                if (alternative instanceof AST_Function) {\n                    exprs.push(alternative);\n                    alternative = null;\n                }\n            }\n            var node;\n            if (!consequent) {\n                node = alternative ? make_node(AST_Binary, this, {\n                    operator: "||",\n                    left: this.condition,\n                    right: alternative,\n                }) : this.condition.drop_side_effect_free(compressor);\n            } else if (!alternative) {\n                node = make_node(AST_Binary, this, {\n                    operator: "&&",\n                    left: this.condition,\n                    right: consequent,\n                });\n            } else {\n                node = this.clone();\n                node.consequent = consequent;\n                node.alternative = alternative;\n            }\n            if (!exprs) return node;\n            if (node) exprs.push(node);\n            return exprs.length == 0 ? null : make_sequence(this, exprs);\n        });\n        def(AST_Constant, return_null);\n        def(AST_Dot, function(compressor, first_in_statement) {\n            var expr = this.expression;\n            if (expr.may_throw_on_access(compressor)) return this;\n            return expr.drop_side_effect_free(compressor, first_in_statement);\n        });\n        def(AST_Function, function(compressor) {\n            return fn_name_unused(this, compressor) ? null : this;\n        });\n        def(AST_LambdaExpression, return_null);\n        def(AST_Object, function(compressor, first_in_statement) {\n            var exprs = [];\n            this.properties.forEach(function(prop) {\n                if (prop instanceof AST_Spread) {\n                    exprs.push(prop);\n                } else {\n                    if (prop.key instanceof AST_Node) exprs.push(prop.key);\n                    exprs.push(prop.value);\n                }\n            });\n            var values = trim(exprs, compressor, first_in_statement, function(node, compressor, first_in_statement) {\n                var exp = node.expression;\n                return exp.safe_to_spread() ? exp.drop_side_effect_free(compressor, first_in_statement) : node;\n            });\n            if (!values) return null;\n            if (values === exprs && !all(values, function(node) {\n                return !(node instanceof AST_Spread);\n            })) return this;\n            return make_sequence(this, values.map(function(node) {\n                return node instanceof AST_Spread ? make_node(AST_Object, node, { properties: [ node ] }) : node;\n            }));\n        });\n        def(AST_ObjectIdentity, return_null);\n        def(AST_Sequence, function(compressor, first_in_statement) {\n            var expressions = trim(this.expressions, compressor, first_in_statement);\n            if (!expressions) return null;\n            var end = expressions.length - 1;\n            var last = expressions[end];\n            if (compressor.option("awaits") && end > 0 && last instanceof AST_Await && last.expression.is_constant()) {\n                expressions = expressions.slice(0, -1);\n                end--;\n                var expr = expressions[end];\n                last.expression = needs_enqueuing(compressor, expr) ? expr : expr.negate(compressor);\n                expressions[end] = last;\n            }\n            var assign, cond, lhs;\n            if (compressor.option("conditionals")\n                && end > 0\n                && (assign = expressions[end - 1]) instanceof AST_Assign\n                && assign.operator == "="\n                && (lhs = assign.left) instanceof AST_SymbolRef\n                && (cond = to_conditional_assignment(compressor, lhs.definition(), assign.right, last))) {\n                assign = assign.clone();\n                assign.right = cond;\n                expressions = expressions.slice(0, -2);\n                expressions.push(assign.drop_side_effect_free(compressor, first_in_statement));\n            }\n            return expressions === this.expressions ? this : make_sequence(this, expressions);\n        });\n        def(AST_Sub, function(compressor, first_in_statement) {\n            var self = this;\n            var expr = self.expression;\n            if (expr.may_throw_on_access(compressor)) return self;\n            var prop = self.property;\n            if (self.optional) {\n                prop = prop.drop_side_effect_free(compressor);\n                if (!prop) return expr.drop_side_effect_free(compressor, first_in_statement);\n                self = self.clone();\n                self.property = prop;\n                return self;\n            }\n            expr = expr.drop_side_effect_free(compressor, first_in_statement);\n            if (!expr) return prop.drop_side_effect_free(compressor, first_in_statement);\n            prop = prop.drop_side_effect_free(compressor);\n            if (!prop) return expr;\n            return make_sequence(self, [ expr, prop ]);\n        });\n        def(AST_SymbolRef, function(compressor) {\n            return this.is_declared(compressor) && can_drop_symbol(this, compressor) ? null : this;\n        });\n        def(AST_Template, function(compressor, first_in_statement) {\n            var self = this;\n            if (self.is_expr_pure(compressor)) {\n                var expressions = self.expressions;\n                if (expressions.length == 0) return null;\n                return make_sequence(self, expressions).drop_side_effect_free(compressor, first_in_statement);\n            }\n            var tag = self.tag;\n            var dropped = drop_returns(compressor, tag);\n            if (dropped) {\n                // always shallow clone to signal internal changes\n                self = self.clone();\n                self.tag = dropped;\n                // avoid extraneous traversal\n                if (tag._squeezed) self.tag._squeezed = true;\n            }\n            return self;\n        });\n        def(AST_Unary, function(compressor, first_in_statement) {\n            var exp = this.expression;\n            if (unary_side_effects[this.operator]) {\n                this.write_only = !exp.has_side_effects(compressor);\n                return this;\n            }\n            if (this.operator == "typeof" && exp instanceof AST_SymbolRef && can_drop_symbol(exp, compressor)) {\n                return null;\n            }\n            var node = exp.drop_side_effect_free(compressor, first_in_statement);\n            if (first_in_statement && node && is_iife_call(node)) {\n                if (node === exp && this.operator == "!") return this;\n                return node.negate(compressor, first_in_statement);\n            }\n            return node;\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("drop_side_effect_free", func);\n    });\n\n    OPT(AST_SimpleStatement, function(self, compressor) {\n        if (compressor.option("side_effects")) {\n            var body = self.body;\n            var node = body.drop_side_effect_free(compressor, true);\n            if (!node) {\n                AST_Node.warn("Dropping side-effect-free statement [{start}]", self);\n                return make_node(AST_EmptyStatement, self);\n            }\n            if (node !== body) {\n                return make_node(AST_SimpleStatement, self, { body: node });\n            }\n        }\n        return self;\n    });\n\n    OPT(AST_While, function(self, compressor) {\n        return compressor.option("loops") ? make_node(AST_For, self).optimize(compressor) : self;\n    });\n\n    function has_loop_control(loop, parent, type) {\n        if (!type) type = AST_LoopControl;\n        var found = false;\n        var tw = new TreeWalker(function(node) {\n            if (found || node instanceof AST_Scope) return true;\n            if (node instanceof type && tw.loopcontrol_target(node) === loop) {\n                return found = true;\n            }\n        });\n        if (parent instanceof AST_LabeledStatement) tw.push(parent);\n        tw.push(loop);\n        loop.body.walk(tw);\n        return found;\n    }\n\n    OPT(AST_Do, function(self, compressor) {\n        if (!compressor.option("loops")) return self;\n        var cond = fuzzy_eval(compressor, self.condition);\n        if (!(cond instanceof AST_Node)) {\n            if (cond && !has_loop_control(self, compressor.parent(), AST_Continue)) return make_node(AST_For, self, {\n                body: make_node(AST_BlockStatement, self.body, {\n                    body: [\n                        self.body,\n                        make_node(AST_SimpleStatement, self.condition, { body: self.condition }),\n                    ],\n                }),\n            }).optimize(compressor);\n            if (!has_loop_control(self, compressor.parent())) return make_node(AST_BlockStatement, self.body, {\n                body: [\n                    self.body,\n                    make_node(AST_SimpleStatement, self.condition, { body: self.condition }),\n                ],\n            }).optimize(compressor);\n        }\n        if (self.body instanceof AST_BlockStatement && !has_loop_control(self, compressor.parent(), AST_Continue)) {\n            var body = self.body.body;\n            for (var i = body.length; --i >= 0;) {\n                var stat = body[i];\n                if (stat instanceof AST_If\n                    && !stat.alternative\n                    && stat.body instanceof AST_Break\n                    && compressor.loopcontrol_target(stat.body) === self) {\n                    if (has_block_scope_refs(stat.condition)) break;\n                    self.condition = make_node(AST_Binary, self, {\n                        operator: "&&",\n                        left: stat.condition.negate(compressor),\n                        right: self.condition,\n                    });\n                    body.splice(i, 1);\n                } else if (stat instanceof AST_SimpleStatement) {\n                    if (has_block_scope_refs(stat.body)) break;\n                    self.condition = make_sequence(self, [\n                        stat.body,\n                        self.condition,\n                    ]);\n                    body.splice(i, 1);\n                } else if (!is_declaration(stat, true)) {\n                    break;\n                }\n            }\n            self.body = trim_block(self.body, compressor.parent());\n        }\n        if (self.body instanceof AST_EmptyStatement) return make_node(AST_For, self).optimize(compressor);\n        if (self.body instanceof AST_SimpleStatement) return make_node(AST_For, self, {\n            condition: make_sequence(self.condition, [\n                self.body.body,\n                self.condition,\n            ]),\n            body: make_node(AST_EmptyStatement, self),\n        }).optimize(compressor);\n        return self;\n\n        function has_block_scope_refs(node) {\n            var found = false;\n            node.walk(new TreeWalker(function(node) {\n                if (found) return true;\n                if (node instanceof AST_SymbolRef) {\n                    if (!member(node.definition(), self.enclosed)) found = true;\n                    return true;\n                }\n            }));\n            return found;\n        }\n    });\n\n    function if_break_in_loop(self, compressor) {\n        var first = first_statement(self.body);\n        if (compressor.option("dead_code")\n            && (first instanceof AST_Break\n                || first instanceof AST_Continue && external_target(first)\n                || first instanceof AST_Exit)) {\n            var body = [];\n            if (is_statement(self.init)) {\n                body.push(self.init);\n            } else if (self.init) {\n                body.push(make_node(AST_SimpleStatement, self.init, { body: self.init }));\n            }\n            var retain = external_target(first) || first instanceof AST_Exit;\n            if (self.condition && retain) {\n                body.push(make_node(AST_If, self, {\n                    condition: self.condition,\n                    body: first,\n                    alternative: null,\n                }));\n            } else if (self.condition) {\n                body.push(make_node(AST_SimpleStatement, self.condition, { body: self.condition }));\n            } else if (retain) {\n                body.push(first);\n            }\n            extract_declarations_from_unreachable_code(compressor, self.body, body);\n            return make_node(AST_BlockStatement, self, { body: body });\n        }\n        if (first instanceof AST_If) {\n            var ab = first_statement(first.body);\n            if (ab instanceof AST_Break && !external_target(ab)) {\n                if (self.condition) {\n                    self.condition = make_node(AST_Binary, self.condition, {\n                        left: self.condition,\n                        operator: "&&",\n                        right: first.condition.negate(compressor),\n                    });\n                } else {\n                    self.condition = first.condition.negate(compressor);\n                }\n                var body = as_statement_array(first.alternative);\n                extract_declarations_from_unreachable_code(compressor, first.body, body);\n                return drop_it(body);\n            }\n            ab = first_statement(first.alternative);\n            if (ab instanceof AST_Break && !external_target(ab)) {\n                if (self.condition) {\n                    self.condition = make_node(AST_Binary, self.condition, {\n                        left: self.condition,\n                        operator: "&&",\n                        right: first.condition,\n                    });\n                } else {\n                    self.condition = first.condition;\n                }\n                var body = as_statement_array(first.body);\n                extract_declarations_from_unreachable_code(compressor, first.alternative, body);\n                return drop_it(body);\n            }\n        }\n        return self;\n\n        function first_statement(body) {\n            return body instanceof AST_BlockStatement ? body.body[0] : body;\n        }\n\n        function external_target(node) {\n            return compressor.loopcontrol_target(node) !== compressor.self();\n        }\n\n        function drop_it(rest) {\n            if (self.body instanceof AST_BlockStatement) {\n                self.body = self.body.clone();\n                self.body.body = rest.concat(self.body.body.slice(1));\n                self.body = self.body.transform(compressor);\n            } else {\n                self.body = make_node(AST_BlockStatement, self.body, { body: rest }).transform(compressor);\n            }\n            return if_break_in_loop(self, compressor);\n        }\n    }\n\n    OPT(AST_For, function(self, compressor) {\n        if (!compressor.option("loops")) return self;\n        if (compressor.option("side_effects")) {\n            if (self.init) self.init = self.init.drop_side_effect_free(compressor);\n            if (self.step) self.step = self.step.drop_side_effect_free(compressor);\n        }\n        if (self.condition) {\n            var cond = fuzzy_eval(compressor, self.condition);\n            if (!cond) {\n                if (compressor.option("dead_code")) {\n                    var body = [];\n                    if (is_statement(self.init)) {\n                        body.push(self.init);\n                    } else if (self.init) {\n                        body.push(make_node(AST_SimpleStatement, self.init, { body: self.init }));\n                    }\n                    body.push(make_node(AST_SimpleStatement, self.condition, { body: self.condition }));\n                    extract_declarations_from_unreachable_code(compressor, self.body, body);\n                    return make_node(AST_BlockStatement, self, { body: body }).optimize(compressor);\n                }\n            } else if (!(cond instanceof AST_Node)) {\n                self.body = make_node(AST_BlockStatement, self.body, {\n                    body: [\n                        make_node(AST_SimpleStatement, self.condition, { body: self.condition }),\n                        self.body,\n                    ],\n                });\n                self.condition = null;\n            }\n        }\n        return if_break_in_loop(self, compressor);\n    });\n\n    OPT(AST_ForEnumeration, function(self, compressor) {\n        if (compressor.option("varify") && is_lexical_definition(self.init)) {\n            var name = self.init.definitions[0].name;\n            if ((compressor.option("module") || name instanceof AST_Destructured || name instanceof AST_SymbolLet)\n                && !name.match_symbol(function(node) {\n                    if (node instanceof AST_SymbolDeclaration) {\n                        var def = node.definition();\n                        return !same_scope(def) || may_overlap(compressor, def);\n                    }\n                }, true)) {\n                self.init = to_var(self.init, self.resolve());\n            } else if (self.init.can_letify(compressor, true)) {\n                self.init = to_let(self.init, self);\n            }\n        }\n        return self;\n    });\n\n    function mark_locally_defined(condition, consequent, alternative) {\n        if (condition instanceof AST_Sequence) condition = condition.tail_node();\n        if (!(condition instanceof AST_Binary)) return;\n        if (!(condition.left instanceof AST_String)) {\n            switch (condition.operator) {\n              case "&&":\n                mark_locally_defined(condition.left, consequent);\n                mark_locally_defined(condition.right, consequent);\n                break;\n              case "||":\n                mark_locally_defined(negate(condition.left), alternative);\n                mark_locally_defined(negate(condition.right), alternative);\n                break;\n            }\n            return;\n        }\n        if (!(condition.right instanceof AST_UnaryPrefix)) return;\n        if (condition.right.operator != "typeof") return;\n        var sym = condition.right.expression;\n        if (!is_undeclared_ref(sym)) return;\n        var body;\n        var undef = condition.left.value == "undefined";\n        switch (condition.operator) {\n          case "==":\n            body = undef ? alternative : consequent;\n            break;\n          case "!=":\n            body = undef ? consequent : alternative;\n            break;\n          default:\n            return;\n        }\n        if (!body) return;\n        var abort = false;\n        var def = sym.definition();\n        var fn;\n        var refs = [];\n        var scanned = [];\n        var tw = new TreeWalker(function(node, descend) {\n            if (abort) return true;\n            if (node instanceof AST_Assign) {\n                var ref = node.left;\n                if (!(ref instanceof AST_SymbolRef && ref.definition() === def)) return;\n                node.right.walk(tw);\n                switch (node.operator) {\n                  case "=":\n                  case "&&=":\n                    abort = true;\n                }\n                return true;\n            }\n            if (node instanceof AST_Call) {\n                descend();\n                fn = node.expression.tail_node();\n                var save;\n                if (fn instanceof AST_SymbolRef) {\n                    fn = fn.fixed_value();\n                    save = refs.length;\n                }\n                if (!(fn instanceof AST_Lambda)) {\n                    abort = true;\n                } else if (push_uniq(scanned, fn)) {\n                    fn.walk(tw);\n                }\n                if (save >= 0) refs.length = save;\n                return true;\n            }\n            if (node instanceof AST_DWLoop) {\n                var save = refs.length;\n                descend();\n                if (abort) refs.length = save;\n                return true;\n            }\n            if (node instanceof AST_For) {\n                if (node.init) node.init.walk(tw);\n                var save = refs.length;\n                if (node.condition) node.condition.walk(tw);\n                node.body.walk(tw);\n                if (node.step) node.step.walk(tw);\n                if (abort) refs.length = save;\n                return true;\n            }\n            if (node instanceof AST_ForEnumeration) {\n                node.object.walk(tw);\n                var save = refs.length;\n                node.init.walk(tw);\n                node.body.walk(tw);\n                if (abort) refs.length = save;\n                return true;\n            }\n            if (node instanceof AST_Scope) {\n                if (node === fn) return;\n                return true;\n            }\n            if (node instanceof AST_SymbolRef) {\n                if (node.definition() === def) refs.push(node);\n                return true;\n            }\n        });\n        body.walk(tw);\n        refs.forEach(function(ref) {\n            ref.defined = true;\n        });\n\n        function negate(node) {\n            if (!(node instanceof AST_Binary)) return;\n            switch (node.operator) {\n              case "==":\n                node = node.clone();\n                node.operator = "!=";\n                return node;\n              case "!=":\n                node = node.clone();\n                node.operator = "==";\n                return node;\n            }\n        }\n    }\n\n    function fuzzy_eval(compressor, node, nullish) {\n        if (node.truthy) return true;\n        if (is_undefined(node)) return undefined;\n        if (node.falsy && !nullish) return false;\n        if (node.is_truthy()) return true;\n        return node.evaluate(compressor, true);\n    }\n\n    function mark_duplicate_condition(compressor, node) {\n        var child;\n        var level = 0;\n        var negated = false;\n        var parent = compressor.self();\n        if (!is_statement(parent)) while (true) {\n            child = parent;\n            parent = compressor.parent(level++);\n            if (parent instanceof AST_Binary) {\n                switch (child) {\n                  case parent.left:\n                    if (lazy_op[parent.operator]) continue;\n                    break;\n                  case parent.right:\n                    if (match(parent.left)) switch (parent.operator) {\n                      case "&&":\n                        node[negated ? "falsy" : "truthy"] = true;\n                        break;\n                      case "||":\n                      case "??":\n                        node[negated ? "truthy" : "falsy"] = true;\n                        break;\n                    }\n                    break;\n                }\n            } else if (parent instanceof AST_Conditional) {\n                var cond = parent.condition;\n                if (cond === child) continue;\n                if (match(cond)) switch (child) {\n                  case parent.consequent:\n                    node[negated ? "falsy" : "truthy"] = true;\n                    break;\n                  case parent.alternative:\n                    node[negated ? "truthy" : "falsy"] = true;\n                    break;\n                }\n            } else if (parent instanceof AST_Exit) {\n                break;\n            } else if (parent instanceof AST_If) {\n                break;\n            } else if (parent instanceof AST_Sequence) {\n                if (parent.expressions[0] === child) continue;\n            } else if (parent instanceof AST_SimpleStatement) {\n                break;\n            }\n            return;\n        }\n        while (true) {\n            child = parent;\n            parent = compressor.parent(level++);\n            if (parent instanceof AST_BlockStatement) {\n                if (parent.body[0] === child) continue;\n            } else if (parent instanceof AST_If) {\n                if (match(parent.condition)) switch (child) {\n                  case parent.body:\n                    node[negated ? "falsy" : "truthy"] = true;\n                    break;\n                  case parent.alternative:\n                    node[negated ? "truthy" : "falsy"] = true;\n                    break;\n                }\n            }\n            return;\n        }\n\n        function match(cond) {\n            if (node.equals(cond)) return true;\n            if (!(cond instanceof AST_UnaryPrefix)) return false;\n            if (cond.operator != "!") return false;\n            if (!node.equals(cond.expression)) return false;\n            negated = true;\n            return true;\n        }\n    }\n\n    OPT(AST_If, function(self, compressor) {\n        if (is_empty(self.alternative)) self.alternative = null;\n\n        if (!compressor.option("conditionals")) return self;\n        if (compressor.option("booleans") && !self.condition.has_side_effects(compressor)) {\n            mark_duplicate_condition(compressor, self.condition);\n        }\n        // if condition can be statically determined, warn and drop\n        // one of the blocks.  note, statically determined implies\n        // “has no side effects”; also it doesn\'t work for cases like\n        // `x && true`, though it probably should.\n        if (compressor.option("dead_code")) {\n            var cond = fuzzy_eval(compressor, self.condition);\n            if (!cond) {\n                AST_Node.warn("Condition always false [{start}]", self.condition);\n                var body = [\n                    make_node(AST_SimpleStatement, self.condition, { body: self.condition }).transform(compressor),\n                ];\n                extract_declarations_from_unreachable_code(compressor, self.body, body);\n                if (self.alternative) body.push(self.alternative);\n                return make_node(AST_BlockStatement, self, { body: body }).optimize(compressor);\n            } else if (!(cond instanceof AST_Node)) {\n                AST_Node.warn("Condition always true [{start}]", self.condition);\n                var body = [\n                    make_node(AST_SimpleStatement, self.condition, { body: self.condition }).transform(compressor),\n                    self.body,\n                ];\n                if (self.alternative) extract_declarations_from_unreachable_code(compressor, self.alternative, body);\n                return make_node(AST_BlockStatement, self, { body: body }).optimize(compressor);\n            }\n        }\n        var negated = self.condition.negate(compressor);\n        var self_condition_length = self.condition.print_to_string().length;\n        var negated_length = negated.print_to_string().length;\n        var negated_is_best = negated_length < self_condition_length;\n        if (self.alternative && negated_is_best) {\n            negated_is_best = false; // because we already do the switch here.\n            // no need to swap values of self_condition_length and negated_length\n            // here because they are only used in an equality comparison later on.\n            self.condition = negated;\n            var tmp = self.body;\n            self.body = self.alternative;\n            self.alternative = is_empty(tmp) ? null : tmp;\n        }\n        var body_defuns = [];\n        var body_var_defs = [];\n        var body_refs = [];\n        var body_exprs = sequencesize(self.body, body_defuns, body_var_defs, body_refs);\n        var alt_defuns = [];\n        var alt_var_defs = [];\n        var alt_refs = [];\n        var alt_exprs = sequencesize(self.alternative, alt_defuns, alt_var_defs, alt_refs);\n        if (body_exprs instanceof AST_BlockStatement || alt_exprs instanceof AST_BlockStatement) {\n            var body = [], var_defs = [];\n            if (body_exprs) {\n                [].push.apply(body, body_defuns);\n                [].push.apply(var_defs, body_var_defs);\n                if (body_exprs instanceof AST_BlockStatement) {\n                    self.body = body_exprs;\n                } else if (body_exprs.length == 0) {\n                    self.body = make_node(AST_EmptyStatement, self.body);\n                } else {\n                    self.body = make_node(AST_SimpleStatement, self.body, {\n                        body: make_sequence(self.body, body_exprs),\n                    });\n                }\n                body_refs.forEach(process_to_assign);\n            }\n            if (alt_exprs) {\n                [].push.apply(body, alt_defuns);\n                [].push.apply(var_defs, alt_var_defs);\n                if (alt_exprs instanceof AST_BlockStatement) {\n                    self.alternative = alt_exprs;\n                } else if (alt_exprs.length == 0) {\n                    self.alternative = null;\n                } else {\n                    self.alternative = make_node(AST_SimpleStatement, self.alternative, {\n                        body: make_sequence(self.alternative, alt_exprs),\n                    });\n                }\n                alt_refs.forEach(process_to_assign);\n            }\n            if (var_defs.length > 0) body.push(make_node(AST_Var, self, { definitions: var_defs }));\n            if (body.length > 0) {\n                body.push(self.transform(compressor));\n                return make_node(AST_BlockStatement, self, { body: body }).optimize(compressor);\n            }\n        } else if (body_exprs && alt_exprs) {\n            var body = body_defuns.concat(alt_defuns);\n            if (body_var_defs.length > 0 || alt_var_defs.length > 0) body.push(make_node(AST_Var, self, {\n                definitions: body_var_defs.concat(alt_var_defs),\n            }));\n            if (body_exprs.length == 0) {\n                body.push(make_node(AST_SimpleStatement, self.condition, {\n                    body: alt_exprs.length > 0 ? make_node(AST_Binary, self, {\n                        operator: "||",\n                        left: self.condition,\n                        right: make_sequence(self.alternative, alt_exprs),\n                    }).transform(compressor) : self.condition.clone(),\n                }).optimize(compressor));\n            } else if (alt_exprs.length == 0) {\n                if (self_condition_length === negated_length && !negated_is_best\n                    && self.condition instanceof AST_Binary && self.condition.operator == "||") {\n                    // although the code length of self.condition and negated are the same,\n                    // negated does not require additional surrounding parentheses.\n                    // see https://github.com/mishoo/UglifyJS/issues/979\n                    negated_is_best = true;\n                }\n                body.push(make_node(AST_SimpleStatement, self, {\n                    body: make_node(AST_Binary, self, {\n                        operator: negated_is_best ? "||" : "&&",\n                        left: negated_is_best ? negated : self.condition,\n                        right: make_sequence(self.body, body_exprs),\n                    }).transform(compressor),\n                }).optimize(compressor));\n            } else {\n                body.push(make_node(AST_SimpleStatement, self, {\n                    body: make_node(AST_Conditional, self, {\n                        condition: self.condition,\n                        consequent: make_sequence(self.body, body_exprs),\n                        alternative: make_sequence(self.alternative, alt_exprs),\n                    }),\n                }).optimize(compressor));\n            }\n            body_refs.forEach(process_to_assign);\n            alt_refs.forEach(process_to_assign);\n            return make_node(AST_BlockStatement, self, { body: body }).optimize(compressor);\n        }\n        if (is_empty(self.body)) self = make_node(AST_If, self, {\n            condition: negated,\n            body: self.alternative,\n            alternative: null,\n        });\n        if (self.alternative instanceof AST_Exit && self.body.TYPE == self.alternative.TYPE) {\n            var cons_value = self.body.value;\n            var alt_value = self.alternative.value;\n            if (!cons_value && !alt_value) return make_node(AST_BlockStatement, self, {\n                body: [\n                    make_node(AST_SimpleStatement, self, { body: self.condition }),\n                    self.body,\n                ],\n            }).optimize(compressor);\n            if (cons_value && alt_value || !keep_return_void()) {\n                var exit = make_node(self.body.CTOR, self, {\n                    value: make_node(AST_Conditional, self, {\n                        condition: self.condition,\n                        consequent: cons_value || make_node(AST_Undefined, self.body).transform(compressor),\n                        alternative: alt_value || make_node(AST_Undefined, self.alternative).transform(compressor),\n                    }),\n                });\n                if (exit instanceof AST_Return) exit.in_bool = self.body.in_bool || self.alternative.in_bool;\n                return exit;\n            }\n        }\n        if (self.body instanceof AST_If && !self.body.alternative && !self.alternative) {\n            self = make_node(AST_If, self, {\n                condition: make_node(AST_Binary, self.condition, {\n                    operator: "&&",\n                    left: self.condition,\n                    right: self.body.condition,\n                }),\n                body: self.body.body,\n                alternative: null,\n            });\n        }\n        if (aborts(self.body) && self.alternative) {\n            var alt = self.alternative;\n            self.alternative = null;\n            return make_node(AST_BlockStatement, self, { body: [ self, alt ] }).optimize(compressor);\n        }\n        if (aborts(self.alternative)) {\n            var body = self.body;\n            self.body = self.alternative;\n            self.condition = negated_is_best ? negated : self.condition.negate(compressor);\n            self.alternative = null;\n            return make_node(AST_BlockStatement, self, { body: [ self, body ] }).optimize(compressor);\n        }\n        if (self.alternative) {\n            var body_stats = as_array(self.body);\n            var body_index = last_index(body_stats);\n            var alt_stats = as_array(self.alternative);\n            var alt_index = last_index(alt_stats);\n            for (var stats = []; body_index >= 0 && alt_index >= 0;) {\n                var stat = body_stats[body_index];\n                var alt_stat = alt_stats[alt_index];\n                if (stat.equals(alt_stat)) {\n                    body_stats.splice(body_index--, 1);\n                    alt_stats.splice(alt_index--, 1);\n                    stats.unshift(merge_expression(stat, alt_stat));\n                } else {\n                    if (!(stat instanceof AST_SimpleStatement)) break;\n                    if (!(alt_stat instanceof AST_SimpleStatement)) break;\n                    var expr1 = stat.body.tail_node();\n                    var expr2 = alt_stat.body.tail_node();\n                    if (!expr1.equals(expr2)) break;\n                    body_index = pop_expr(body_stats, stat.body, body_index);\n                    alt_index = pop_expr(alt_stats, alt_stat.body, alt_index);\n                    stats.unshift(make_node(AST_SimpleStatement, expr1, { body: merge_expression(expr1, expr2) }));\n                }\n            }\n            if (stats.length > 0) {\n                self.body = body_stats.length > 0 ? make_node(AST_BlockStatement, self, {\n                    body: body_stats,\n                }) : make_node(AST_EmptyStatement, self);\n                self.alternative = alt_stats.length > 0 ? make_node(AST_BlockStatement, self, {\n                    body: alt_stats,\n                }) : null;\n                stats.unshift(self);\n                return make_node(AST_BlockStatement, self, { body: stats }).optimize(compressor);\n            }\n        }\n        if (compressor.option("typeofs")) mark_locally_defined(self.condition, self.body, self.alternative);\n        return self;\n\n        function as_array(node) {\n            return node instanceof AST_BlockStatement ? node.body : [ node ];\n        }\n\n        function keep_return_void() {\n            var has_finally = false, level = 0, node = compressor.self();\n            do {\n                if (node instanceof AST_Catch) {\n                    if (compressor.parent(level).bfinally) has_finally = true;\n                    level++;\n                } else if (node instanceof AST_Finally) {\n                    level++;\n                } else if (node instanceof AST_Scope) {\n                    return has_finally && in_async_generator(node);\n                } else if (node instanceof AST_Try) {\n                    if (node.bfinally) has_finally = true;\n                }\n            } while (node = compressor.parent(level++));\n        }\n\n        function last_index(stats) {\n            for (var index = stats.length; --index >= 0;) {\n                if (!is_declaration(stats[index], true)) break;\n            }\n            return index;\n        }\n\n        function pop_expr(stats, body, index) {\n            if (body instanceof AST_Sequence) {\n                stats[index] = make_node(AST_SimpleStatement, body, {\n                    body: make_sequence(body, body.expressions.slice(0, -1)),\n                });\n            } else {\n                stats.splice(index--, 1);\n            }\n            return index;\n        }\n\n        function sequencesize(stat, defuns, var_defs, refs) {\n            if (stat == null) return [];\n            if (stat instanceof AST_BlockStatement) {\n                var exprs = [];\n                for (var i = 0; i < stat.body.length; i++) {\n                    var line = stat.body[i];\n                    if (line instanceof AST_EmptyStatement) continue;\n                    if (line instanceof AST_Exit) {\n                        if (i == 0) return;\n                        if (exprs.length > 0) {\n                            line = line.clone();\n                            exprs.push(line.value || make_node(AST_Undefined, line).transform(compressor));\n                            line.value = make_sequence(stat, exprs);\n                        }\n                        var block = stat.clone();\n                        block.body = block.body.slice(i + 1);\n                        block.body.unshift(line);\n                        return block;\n                    }\n                    if (line instanceof AST_LambdaDefinition) {\n                        defuns.push(line);\n                    } else if (line instanceof AST_SimpleStatement) {\n                        if (!compressor.option("sequences") && exprs.length > 0) return;\n                        exprs.push(line.body);\n                    } else if (line instanceof AST_Var) {\n                        if (!compressor.option("sequences") && exprs.length > 0) return;\n                        line.remove_initializers(compressor, var_defs);\n                        line.definitions.forEach(process_var_def);\n                    } else {\n                        return;\n                    }\n                }\n                return exprs;\n            }\n            if (stat instanceof AST_LambdaDefinition) {\n                defuns.push(stat);\n                return [];\n            }\n            if (stat instanceof AST_EmptyStatement) return [];\n            if (stat instanceof AST_SimpleStatement) return [ stat.body ];\n            if (stat instanceof AST_Var) {\n                var exprs = [];\n                stat.remove_initializers(compressor, var_defs);\n                stat.definitions.forEach(process_var_def);\n                return exprs;\n            }\n\n            function process_var_def(var_def) {\n                if (!var_def.value) return;\n                exprs.push(make_node(AST_Assign, var_def, {\n                    operator: "=",\n                    left: var_def.name.convert_symbol(AST_SymbolRef, function(ref) {\n                        refs.push(ref);\n                    }),\n                    right: var_def.value,\n                }));\n            }\n        }\n    });\n\n    OPT(AST_Switch, function(self, compressor) {\n        if (!compressor.option("switches")) return self;\n        if (!compressor.option("dead_code")) return self;\n        var body = [];\n        var branch;\n        var decl = [];\n        var default_branch;\n        var exact_match;\n        var side_effects = [];\n        for (var i = 0, len = self.body.length; i < len; i++) {\n            branch = self.body[i];\n            if (branch instanceof AST_Default) {\n                var prev = body[body.length - 1];\n                if (default_branch || is_break(branch.body[0], compressor) && (!prev || aborts(prev))) {\n                    eliminate_branch(branch, prev);\n                    continue;\n                } else {\n                    default_branch = branch;\n                }\n            } else {\n                var exp = branch.expression;\n                var equals = make_node(AST_Binary, self, {\n                    operator: "===",\n                    left: self.expression,\n                    right: exp,\n                }).evaluate(compressor, true);\n                if (!equals) {\n                    if (exp.has_side_effects(compressor)) side_effects.push(exp);\n                    eliminate_branch(branch, body[body.length - 1]);\n                    continue;\n                }\n                if (!(equals instanceof AST_Node)) {\n                    if (default_branch) {\n                        var default_index = body.indexOf(default_branch);\n                        body.splice(default_index, 1);\n                        eliminate_branch(default_branch, body[default_index - 1]);\n                        default_branch = null;\n                    }\n                    if (exp.has_side_effects(compressor)) {\n                        exact_match = branch;\n                    } else {\n                        default_branch = branch = make_node(AST_Default, branch);\n                    }\n                    while (++i < len) eliminate_branch(self.body[i], branch);\n                }\n            }\n            if (i + 1 >= len || aborts(branch)) {\n                var prev = body[body.length - 1];\n                var statements = branch.body;\n                if (aborts(prev)) switch (prev.body.length - statements.length) {\n                  case 1:\n                    var stat = prev.body[prev.body.length - 1];\n                    if (!is_break(stat, compressor)) break;\n                    statements = statements.concat(stat);\n                  case 0:\n                    var prev_block = make_node(AST_BlockStatement, prev);\n                    var next_block = make_node(AST_BlockStatement, branch, { body: statements });\n                    if (prev_block.equals(next_block)) prev.body = [];\n                }\n            }\n            if (side_effects.length) {\n                if (branch instanceof AST_Default) {\n                    body.push(make_node(AST_Case, self, { expression: make_sequence(self, side_effects), body: [] }));\n                } else {\n                    side_effects.push(branch.expression);\n                    branch.expression = make_sequence(self, side_effects);\n                }\n                side_effects = [];\n            }\n            body.push(branch);\n        }\n        if (side_effects.length && !exact_match) {\n            body.push(make_node(AST_Case, self, { expression: make_sequence(self, side_effects), body: [] }));\n        }\n        while (branch = body[body.length - 1]) {\n            var stat = branch.body[branch.body.length - 1];\n            if (is_break(stat, compressor)) branch.body.pop();\n            if (branch === default_branch) {\n                if (!has_declarations_only(branch)) break;\n            } else if (branch.expression.has_side_effects(compressor)) {\n                break;\n            } else if (default_branch) {\n                if (!has_declarations_only(default_branch)) break;\n                if (body[body.length - 2] !== default_branch) break;\n                default_branch.body = default_branch.body.concat(branch.body);\n                branch.body = [];\n            } else if (!has_declarations_only(branch)) break;\n            eliminate_branch(branch);\n            if (body.pop() === default_branch) default_branch = null;\n        }\n        if (!branch) {\n            decl.push(make_node(AST_SimpleStatement, self.expression, { body: self.expression }));\n            if (side_effects.length) decl.push(make_node(AST_SimpleStatement, self, {\n                body: make_sequence(self, side_effects),\n            }));\n            return make_node(AST_BlockStatement, self, { body: decl }).optimize(compressor);\n        }\n        if (branch === default_branch) while (branch = body[body.length - 2]) {\n            if (branch instanceof AST_Default) break;\n            if (!has_declarations_only(branch)) break;\n            var exp = branch.expression;\n            if (exp.has_side_effects(compressor)) {\n                var prev = body[body.length - 3];\n                if (prev && !aborts(prev)) break;\n                default_branch.body.unshift(make_node(AST_SimpleStatement, self, { body: exp }));\n            }\n            eliminate_branch(branch);\n            body.splice(-2, 1);\n        }\n        body[0].body = decl.concat(body[0].body);\n        self.body = body;\n        if (compressor.option("conditionals")) switch (body.length) {\n          case 1:\n            if (!no_break(body[0])) break;\n            var exp = body[0].expression;\n            var statements = body[0].body.slice();\n            if (body[0] !== default_branch && body[0] !== exact_match) return make_node(AST_If, self, {\n                condition: make_node(AST_Binary, self, {\n                    operator: "===",\n                    left: self.expression,\n                    right: exp,\n                }),\n                body: make_node(AST_BlockStatement, self, { body: statements }),\n                alternative: null,\n            }).optimize(compressor);\n            if (exp) statements.unshift(make_node(AST_SimpleStatement, exp, { body: exp }));\n            statements.unshift(make_node(AST_SimpleStatement, self.expression, { body: self.expression }));\n            return make_node(AST_BlockStatement, self, { body: statements }).optimize(compressor);\n          case 2:\n            if (!member(default_branch, body) || !no_break(body[1])) break;\n            var statements = body[0].body.slice();\n            var exclusive = statements.length && is_break(statements[statements.length - 1], compressor);\n            if (exclusive) statements.pop();\n            if (!all(statements, no_break)) break;\n            var alternative = body[1].body.length && make_node(AST_BlockStatement, body[1]);\n            var node = make_node(AST_If, self, {\n                condition: make_node(AST_Binary, self, body[0] === default_branch ? {\n                    operator: "!==",\n                    left: self.expression,\n                    right: body[1].expression,\n                } : {\n                    operator: "===",\n                    left: self.expression,\n                    right: body[0].expression,\n                }),\n                body: make_node(AST_BlockStatement, body[0], { body: statements }),\n                alternative: exclusive && alternative || null,\n            });\n            if (!exclusive && alternative) node = make_node(AST_BlockStatement, self, { body: [ node, alternative ] });\n            return node.optimize(compressor);\n        }\n        return self;\n\n        function is_break(node, tw) {\n            return node instanceof AST_Break && tw.loopcontrol_target(node) === self;\n        }\n\n        function no_break(node) {\n            var found = false;\n            var tw = new TreeWalker(function(node) {\n                if (found\n                    || node instanceof AST_Lambda\n                    || node instanceof AST_SimpleStatement) return true;\n                if (is_break(node, tw)) found = true;\n            });\n            tw.push(self);\n            node.walk(tw);\n            return !found;\n        }\n\n        function eliminate_branch(branch, prev) {\n            if (prev && !aborts(prev)) {\n                prev.body = prev.body.concat(branch.body);\n            } else {\n                extract_declarations_from_unreachable_code(compressor, branch, decl);\n            }\n        }\n    });\n\n    OPT(AST_Try, function(self, compressor) {\n        self.body = tighten_body(self.body, compressor);\n        if (compressor.option("dead_code")) {\n            if (has_declarations_only(self)\n                && !(self.bcatch && self.bcatch.argname && self.bcatch.argname.match_symbol(function(node) {\n                    return node instanceof AST_SymbolCatch && !can_drop_symbol(node);\n                }, true))) {\n                var body = [];\n                if (self.bcatch) {\n                    extract_declarations_from_unreachable_code(compressor, self.bcatch, body);\n                    body.forEach(function(stat) {\n                        if (!(stat instanceof AST_Var)) return;\n                        stat.definitions.forEach(function(var_def) {\n                            var def = var_def.name.definition().redefined();\n                            if (!def) return;\n                            var_def.name = var_def.name.clone();\n                            var_def.name.thedef = def;\n                        });\n                    });\n                }\n                body.unshift(make_node(AST_BlockStatement, self).optimize(compressor));\n                if (self.bfinally) {\n                    body.push(make_node(AST_BlockStatement, self.bfinally).optimize(compressor));\n                }\n                return make_node(AST_BlockStatement, self, { body: body }).optimize(compressor);\n            }\n            if (self.bfinally && has_declarations_only(self.bfinally)) {\n                var body = make_node(AST_BlockStatement, self.bfinally).optimize(compressor);\n                body = self.body.concat(body);\n                if (!self.bcatch) return make_node(AST_BlockStatement, self, { body: body }).optimize(compressor);\n                self.body = body;\n                self.bfinally = null;\n            }\n        }\n        return self;\n    });\n\n    function remove_initializers(make_value) {\n        return function(compressor, defns) {\n            var dropped = false;\n            this.definitions.forEach(function(defn) {\n                if (defn.value) dropped = true;\n                defn.name.match_symbol(function(node) {\n                    if (node instanceof AST_SymbolDeclaration) defns.push(make_node(AST_VarDef, node, {\n                        name: node,\n                        value: make_value(compressor, node),\n                    }));\n                }, true);\n            });\n            return dropped;\n        };\n    }\n\n    AST_Const.DEFMETHOD("remove_initializers", remove_initializers(function(compressor, node) {\n        return make_node(AST_Undefined, node).optimize(compressor);\n    }));\n    AST_Let.DEFMETHOD("remove_initializers", remove_initializers(return_null));\n    AST_Var.DEFMETHOD("remove_initializers", remove_initializers(return_null));\n\n    AST_Definitions.DEFMETHOD("to_assignments", function() {\n        var assignments = this.definitions.reduce(function(a, defn) {\n            var def = defn.name.definition();\n            var value = defn.value;\n            if (value) {\n                if (value instanceof AST_Sequence) value = value.clone();\n                var name = make_node(AST_SymbolRef, defn.name);\n                var assign = make_node(AST_Assign, defn, {\n                    operator: "=",\n                    left: name,\n                    right: value,\n                });\n                a.push(assign);\n                var fixed = function() {\n                    return assign.right;\n                };\n                fixed.assigns = [ assign ];\n                fixed.direct_access = def.direct_access;\n                fixed.escaped = def.escaped;\n                name.fixed = fixed;\n                def.references.forEach(function(ref) {\n                    if (!ref.fixed) return;\n                    var assigns = ref.fixed.assigns;\n                    if (!assigns) return;\n                    if (assigns[0] !== defn) return;\n                    if (assigns.length > 1 || ref.fixed.to_binary || ref.fixed.to_prefix) {\n                        assigns[0] = assign;\n                    } else {\n                        ref.fixed = fixed;\n                        if (def.fixed === ref.fixed) def.fixed = fixed;\n                    }\n                });\n                def.references.push(name);\n                def.assignments++;\n            }\n            def.eliminated++;\n            return a;\n        }, []);\n        if (assignments.length == 0) return null;\n        return make_sequence(this, assignments);\n    });\n\n    function is_safe_lexical(def) {\n        return def.name != "arguments" && def.orig.length < (def.orig[0] instanceof AST_SymbolLambda ? 3 : 2);\n    }\n\n    function may_overlap(compressor, def) {\n        if (compressor.exposed(def)) return true;\n        var scope = def.scope.resolve();\n        for (var s = def.scope; s !== scope;) {\n            s = s.parent_scope;\n            if (s.var_names().has(def.name)) return true;\n        }\n    }\n\n    function to_let(stat, scope) {\n        return make_node(AST_Let, stat, {\n            definitions: stat.definitions.map(function(defn) {\n                return make_node(AST_VarDef, defn, {\n                    name: defn.name.convert_symbol(AST_SymbolLet, function(name, node) {\n                        var def = name.definition();\n                        def.orig[def.orig.indexOf(node)] = name;\n                        for (var s = scope; s !== def.scope && (s = s.parent_scope);) {\n                            remove(s.enclosed, def);\n                        }\n                        def.scope = scope;\n                        scope.variables.set(def.name, def);\n                    }),\n                    value: defn.value,\n                });\n            }),\n        });\n    }\n\n    function to_var(stat, scope) {\n        return make_node(AST_Var, stat, {\n            definitions: stat.definitions.map(function(defn) {\n                return make_node(AST_VarDef, defn, {\n                    name: defn.name.convert_symbol(AST_SymbolVar, function(name, node) {\n                        var def = name.definition();\n                        def.orig[def.orig.indexOf(node)] = name;\n                        if (def.scope === scope) return;\n                        def.scope = scope;\n                        scope.variables.set(def.name, def);\n                        scope.enclosed.push(def);\n                        scope.var_names().set(def.name, true);\n                    }),\n                    value: defn.value,\n                });\n            }),\n        });\n    }\n\n    (function(def) {\n        def(AST_Node, return_false);\n        def(AST_Const, function(compressor, assigned) {\n            assigned = assigned ? 1 : 0;\n            var defns = this.definitions;\n            if (!compressor.option("module") && all(defns, function(defn) {\n                return defn.name instanceof AST_SymbolConst;\n            })) return false;\n            return all(defns, function(defn) {\n                return !defn.name.match_symbol(function(node) {\n                    if (node instanceof AST_SymbolDeclaration) return node.definition().assignments != assigned;\n                }, true);\n            });\n        });\n        def(AST_Var, function(compressor) {\n            return all(this.definitions, function(defn) {\n                return !defn.name.match_symbol(function(node) {\n                    if (!(node instanceof AST_SymbolDeclaration)) return false;\n                    var def = node.definition();\n                    if (def.first_decl !== node) return true;\n                    if (!safe_from_tdz(compressor, node)) return true;\n                    var defn_scope = node.scope;\n                    if (defn_scope instanceof AST_Scope) return false;\n                    return !all(def.references, function(ref) {\n                        var scope = ref.scope;\n                        do {\n                            if (scope === defn_scope) return true;\n                        } while (scope = scope.parent_scope);\n                        return false;\n                    });\n                }, true);\n            });\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("can_letify", func);\n    });\n\n    function safe_from_tdz(compressor, sym) {\n        var def = sym.definition();\n        return (def.fixed || def.fixed === 0)\n            && is_safe_lexical(def)\n            && same_scope(def)\n            && !may_overlap(compressor, def);\n    }\n\n    AST_Definitions.DEFMETHOD("can_varify", function(compressor) {\n        return all(this.definitions, function(defn) {\n            return !defn.name.match_symbol(function(node) {\n                if (node instanceof AST_SymbolDeclaration) return !safe_from_tdz(compressor, node);\n            }, true);\n        });\n    });\n\n    OPT(AST_Const, function(self, compressor) {\n        if (!compressor.option("varify")) return self;\n        if (self.can_varify(compressor)) return to_var(self, compressor.find_parent(AST_Scope));\n        if (self.can_letify(compressor)) return to_let(self, find_scope(compressor));\n        return self;\n    });\n\n    OPT(AST_Let, function(self, compressor) {\n        if (!compressor.option("varify")) return self;\n        if (self.can_varify(compressor)) return to_var(self, compressor.find_parent(AST_Scope));\n        return self;\n    });\n\n    function trim_optional_chain(node, compressor) {\n        if (!compressor.option("optional_chains")) return;\n        if (node.terminal) do {\n            var expr = node.expression;\n            if (node.optional) {\n                var ev = fuzzy_eval(compressor, expr, true);\n                if (ev == null) return make_node(AST_UnaryPrefix, node, {\n                    operator: "void",\n                    expression: expr,\n                }).optimize(compressor);\n                if (!(ev instanceof AST_Node)) node.optional = false;\n            }\n            node = expr;\n        } while ((node.TYPE == "Call" || node instanceof AST_PropAccess) && !node.terminal);\n    }\n\n    function lift_sequence_in_expression(node, compressor) {\n        var exp = node.expression;\n        if (!(exp instanceof AST_Sequence)) return node;\n        var x = exp.expressions.slice();\n        var e = node.clone();\n        e.expression = x.pop();\n        x.push(e);\n        return make_sequence(node, x);\n    }\n\n    function drop_unused_call_args(call, compressor, fns_with_marked_args) {\n        var exp = call.expression;\n        var fn = exp instanceof AST_SymbolRef ? exp.fixed_value() : exp;\n        if (!(fn instanceof AST_Lambda)) return;\n        if (fn.uses_arguments) return;\n        if (fn.pinned()) return;\n        if (fns_with_marked_args && fns_with_marked_args.indexOf(fn) < 0) return;\n        var args = call.args;\n        if (!all(args, function(arg) {\n            return !(arg instanceof AST_Spread);\n        })) return;\n        var argnames = fn.argnames;\n        var is_iife = fn === exp && !fn.name;\n        if (fn.rest) {\n            if (!(is_iife && compressor.option("rests"))) return;\n            var insert = argnames.length;\n            args = args.slice(0, insert);\n            while (args.length < insert) args.push(make_node(AST_Undefined, call).optimize(compressor));\n            args.push(make_node(AST_Array, call, { elements: call.args.slice(insert) }));\n            argnames = argnames.concat(fn.rest);\n            fn.rest = null;\n        } else {\n            args = args.slice();\n            argnames = argnames.slice();\n        }\n        var pos = 0, last = 0;\n        var drop_defaults = is_iife && compressor.option("default_values");\n        var drop_fargs = is_iife && compressor.drop_fargs(fn, call) ? function(argname, arg) {\n            if (!argname) return true;\n            if (argname instanceof AST_DestructuredArray) {\n                return argname.elements.length == 0 && !argname.rest && arg instanceof AST_Array;\n            }\n            if (argname instanceof AST_DestructuredObject) {\n                return argname.properties.length == 0 && !argname.rest && arg && !arg.may_throw_on_access(compressor);\n            }\n            return argname.unused;\n        } : return_false;\n        var side_effects = [];\n        for (var i = 0; i < args.length; i++) {\n            var argname = argnames[i];\n            if (drop_defaults && argname instanceof AST_DefaultValue && args[i].is_defined(compressor)) {\n                argnames[i] = argname = argname.name;\n            }\n            if (!argname || argname.unused !== undefined) {\n                var node = args[i].drop_side_effect_free(compressor);\n                if (drop_fargs(argname)) {\n                    if (argname) argnames.splice(i, 1);\n                    args.splice(i, 1);\n                    if (node) side_effects.push(node);\n                    i--;\n                    continue;\n                } else if (node) {\n                    side_effects.push(node);\n                    args[pos++] = make_sequence(call, side_effects);\n                    side_effects = [];\n                } else if (argname) {\n                    if (side_effects.length) {\n                        args[pos++] = make_sequence(call, side_effects);\n                        side_effects = [];\n                    } else {\n                        args[pos++] = make_node(AST_Number, args[i], { value: 0 });\n                        continue;\n                    }\n                }\n            } else if (drop_fargs(argname, args[i])) {\n                var node = args[i].drop_side_effect_free(compressor);\n                argnames.splice(i, 1);\n                args.splice(i, 1);\n                if (node) side_effects.push(node);\n                i--;\n                continue;\n            } else {\n                side_effects.push(args[i]);\n                args[pos++] = make_sequence(call, side_effects);\n                side_effects = [];\n            }\n            last = pos;\n        }\n        for (; i < argnames.length; i++) {\n            if (drop_fargs(argnames[i])) argnames.splice(i--, 1);\n        }\n        fn.argnames = argnames;\n        args.length = last;\n        call.args = args;\n        if (!side_effects.length) return;\n        var arg = make_sequence(call, side_effects);\n        args.push(args.length < argnames.length ? make_node(AST_UnaryPrefix, call, {\n            operator: "void",\n            expression: arg,\n        }) : arg);\n    }\n\n    function avoid_await_yield(compressor, parent_scope) {\n        if (!parent_scope) parent_scope = compressor.find_parent(AST_Scope);\n        var avoid = [];\n        if (is_async(parent_scope) || parent_scope instanceof AST_Toplevel && compressor.option("module")) {\n            avoid.push("await");\n        }\n        if (is_generator(parent_scope)) avoid.push("yield");\n        return avoid.length && makePredicate(avoid);\n    }\n\n    function safe_from_await_yield(fn, avoid) {\n        if (!avoid) return true;\n        var safe = true;\n        var tw = new TreeWalker(function(node) {\n            if (!safe) return true;\n            if (node instanceof AST_Scope) {\n                if (node === fn) return;\n                if (is_arrow(node)) {\n                    for (var i = 0; safe && i < node.argnames.length; i++) node.argnames[i].walk(tw);\n                } else if (node instanceof AST_LambdaDefinition && avoid[node.name.name]) {\n                    safe = false;\n                }\n                return true;\n            }\n            if (node instanceof AST_Symbol && avoid[node.name] && node !== fn.name) safe = false;\n        });\n        fn.walk(tw);\n        return safe;\n    }\n\n    function safe_from_strict_mode(fn, compressor) {\n        return fn.in_strict_mode(compressor) || !compressor.has_directive("use strict");\n    }\n\n    OPT(AST_Call, function(self, compressor) {\n        var exp = self.expression;\n        var terminated = trim_optional_chain(self, compressor);\n        if (terminated) return terminated;\n        if (compressor.option("sequences")) {\n            if (exp instanceof AST_PropAccess) {\n                var seq = lift_sequence_in_expression(exp, compressor);\n                if (seq !== exp) {\n                    var call = self.clone();\n                    call.expression = seq.expressions.pop();\n                    seq.expressions.push(call);\n                    return seq.optimize(compressor);\n                }\n            } else if (!needs_unbinding(exp.tail_node())) {\n                var seq = lift_sequence_in_expression(self, compressor);\n                if (seq !== self) return seq.optimize(compressor);\n            }\n        }\n        if (compressor.option("unused")) drop_unused_call_args(self, compressor);\n        if (compressor.option("unsafe")) {\n            if (is_undeclared_ref(exp)) switch (exp.name) {\n              case "Array":\n                // Array(n) ---\x3e [ , , ... , ]\n                if (self.args.length == 1) {\n                    var first = self.args[0];\n                    if (first instanceof AST_Number) try {\n                        var length = first.value;\n                        if (length > 6) break;\n                        var elements = Array(length);\n                        for (var i = 0; i < length; i++) elements[i] = make_node(AST_Hole, self);\n                        return make_node(AST_Array, self, { elements: elements });\n                    } catch (ex) {\n                        AST_Node.warn("Invalid array length: {length} [{start}]", {\n                            length: length,\n                            start: self.start,\n                        });\n                        break;\n                    }\n                    if (!first.is_boolean(compressor) && !first.is_string(compressor)) break;\n                }\n                // Array(...) ---\x3e [ ... ]\n                return make_node(AST_Array, self, { elements: self.args });\n              case "Object":\n                // Object() ---\x3e {}\n                if (self.args.length == 0) return make_node(AST_Object, self, { properties: [] });\n                break;\n              case "String":\n                // String() ---\x3e ""\n                if (self.args.length == 0) return make_node(AST_String, self, { value: "" });\n                // String(x) ---\x3e "" + x\n                if (self.args.length == 1) return make_node(AST_Binary, self, {\n                    operator: "+",\n                    left: make_node(AST_String, self, { value: "" }),\n                    right: self.args[0],\n                }).optimize(compressor);\n                break;\n              case "Number":\n                // Number() ---\x3e 0\n                if (self.args.length == 0) return make_node(AST_Number, self, { value: 0 });\n                // Number(x) ---\x3e +("" + x)\n                if (self.args.length == 1) return make_node(AST_UnaryPrefix, self, {\n                    operator: "+",\n                    expression: make_node(AST_Binary, self, {\n                        operator: "+",\n                        left: make_node(AST_String, self, { value: "" }),\n                        right: self.args[0],\n                    }),\n                }).optimize(compressor);\n                break;\n              case "Boolean":\n                // Boolean() ---\x3e false\n                if (self.args.length == 0) return make_node(AST_False, self).optimize(compressor);\n                // Boolean(x) ---\x3e !!x\n                if (self.args.length == 1) return make_node(AST_UnaryPrefix, self, {\n                    operator: "!",\n                    expression: make_node(AST_UnaryPrefix, self, {\n                        operator: "!",\n                        expression: self.args[0],\n                    }),\n                }).optimize(compressor);\n                break;\n              case "RegExp":\n                // attempt to convert RegExp(...) to literal\n                var params = [];\n                if (all(self.args, function(arg) {\n                    var value = arg.evaluate(compressor);\n                    params.unshift(value);\n                    return arg !== value;\n                })) try {\n                    return best_of(compressor, self, make_node(AST_RegExp, self, {\n                        value: RegExp.apply(RegExp, params),\n                    }));\n                } catch (ex) {\n                    AST_Node.warn("Error converting {this} [{start}]", self);\n                }\n                break;\n            } else if (exp instanceof AST_Dot) switch (exp.property) {\n              case "toString":\n                // x.toString() ---\x3e "" + x\n                var expr = exp.expression;\n                if (self.args.length == 0 && !(expr.may_throw_on_access(compressor) || expr instanceof AST_Super)) {\n                    return make_node(AST_Binary, self, {\n                        operator: "+",\n                        left: make_node(AST_String, self, { value: "" }),\n                        right: expr,\n                    }).optimize(compressor);\n                }\n                break;\n              case "join":\n                if (exp.expression instanceof AST_Array && self.args.length < 2) EXIT: {\n                    var separator = self.args[0];\n                    // [].join() ---\x3e ""\n                    // [].join(x) ---\x3e (x, "")\n                    if (exp.expression.elements.length == 0 && !(separator instanceof AST_Spread)) {\n                        return separator ? make_sequence(self, [\n                            separator,\n                            make_node(AST_String, self, { value: "" }),\n                        ]).optimize(compressor) : make_node(AST_String, self, { value: "" });\n                    }\n                    if (separator) {\n                        separator = separator.evaluate(compressor);\n                        if (separator instanceof AST_Node) break EXIT; // not a constant\n                    }\n                    var elements = [];\n                    var consts = [];\n                    for (var i = 0; i < exp.expression.elements.length; i++) {\n                        var el = exp.expression.elements[i];\n                        var value = el.evaluate(compressor);\n                        if (value !== el) {\n                            consts.push(value);\n                        } else if (el instanceof AST_Spread) {\n                            break EXIT;\n                        } else {\n                            if (consts.length > 0) {\n                                elements.push(make_node(AST_String, self, { value: consts.join(separator) }));\n                                consts.length = 0;\n                            }\n                            elements.push(el);\n                        }\n                    }\n                    if (consts.length > 0) elements.push(make_node(AST_String, self, {\n                        value: consts.join(separator),\n                    }));\n                    // [ x ].join() ---\x3e "" + x\n                    // [ x ].join(".") ---\x3e "" + x\n                    // [ 1, 2, 3 ].join() ---\x3e "1,2,3"\n                    // [ 1, 2, 3 ].join(".") ---\x3e "1.2.3"\n                    if (elements.length == 1) {\n                        if (elements[0].is_string(compressor)) return elements[0];\n                        return make_node(AST_Binary, elements[0], {\n                            operator: "+",\n                            left: make_node(AST_String, self, { value: "" }),\n                            right: elements[0],\n                        });\n                    }\n                    // [ 1, 2, a, 3 ].join("") ---\x3e "12" + a + "3"\n                    if (separator == "") {\n                        var first;\n                        if (elements[0].is_string(compressor) || elements[1].is_string(compressor)) {\n                            first = elements.shift();\n                        } else {\n                            first = make_node(AST_String, self, { value: "" });\n                        }\n                        return elements.reduce(function(prev, el) {\n                            return make_node(AST_Binary, el, {\n                                operator: "+",\n                                left: prev,\n                                right: el,\n                            });\n                        }, first).optimize(compressor);\n                    }\n                    // [ x, "foo", "bar", y ].join() ---\x3e [ x, "foo,bar", y ].join()\n                    // [ x, "foo", "bar", y ].join("-") ---\x3e [ x, "foo-bar", y ].join("-")\n                    // need this awkward cloning to not affect original element\n                    // best_of will decide which one to get through.\n                    var node = self.clone();\n                    node.expression = node.expression.clone();\n                    node.expression.expression = node.expression.expression.clone();\n                    node.expression.expression.elements = elements;\n                    return best_of(compressor, self, node);\n                }\n                break;\n              case "charAt":\n                if (self.args.length < 2) {\n                    var node = make_node(AST_Binary, self, {\n                        operator: "||",\n                        left: make_node(AST_Sub, self, {\n                            expression: exp.expression,\n                            property: self.args.length ? make_node(AST_Binary, self.args[0], {\n                                operator: "|",\n                                left: make_node(AST_Number, self, { value: 0 }),\n                                right: self.args[0],\n                            }) : make_node(AST_Number, self, { value: 0 }),\n                        }).optimize(compressor),\n                        right: make_node(AST_String, self, { value: "" }),\n                    });\n                    node.is_string = return_true;\n                    return node.optimize(compressor);\n                }\n                break;\n              case "apply":\n                if (self.args.length == 2 && self.args[1] instanceof AST_Array) {\n                    var args = self.args[1].elements.slice();\n                    args.unshift(self.args[0]);\n                    return make_node(AST_Call, self, {\n                        expression: make_node(AST_Dot, exp, {\n                            expression: exp.expression,\n                            property: "call",\n                        }),\n                        args: args,\n                    }).optimize(compressor);\n                }\n                break;\n              case "call":\n                var func = exp.expression;\n                if (func instanceof AST_SymbolRef) {\n                    func = func.fixed_value();\n                }\n                if (func instanceof AST_Lambda && !func.contains_this()) {\n                    return (self.args.length ? make_sequence(self, [\n                        self.args[0],\n                        make_node(AST_Call, self, {\n                            expression: exp.expression,\n                            args: self.args.slice(1),\n                        }),\n                    ]) : make_node(AST_Call, self, {\n                        expression: exp.expression,\n                        args: [],\n                    })).optimize(compressor);\n                }\n                break;\n            } else if (compressor.option("side_effects")\n                && exp instanceof AST_Call\n                && exp.args.length == 1\n                && is_undeclared_ref(exp.expression)\n                && exp.expression.name == "Object") {\n                var call = self.clone();\n                call.expression = maintain_this_binding(self, exp, exp.args[0]);\n                return call.optimize(compressor);\n            }\n        }\n        if (compressor.option("unsafe_Function")\n            && is_undeclared_ref(exp)\n            && exp.name == "Function") {\n            // new Function() ---\x3e function(){}\n            if (self.args.length == 0) return make_node(AST_Function, self, {\n                argnames: [],\n                body: [],\n            }).init_vars(exp.scope);\n            if (all(self.args, function(x) {\n                return x instanceof AST_String;\n            })) {\n                // quite a corner-case, but we can handle it:\n                //   https://github.com/mishoo/UglifyJS/issues/203\n                // if the code argument is a constant, then we can minify it.\n                try {\n                    var code = "n(function(" + self.args.slice(0, -1).map(function(arg) {\n                        return arg.value;\n                    }).join() + "){" + self.args[self.args.length - 1].value + "})";\n                    var ast = parse(code);\n                    var mangle = { ie: compressor.option("ie") };\n                    ast.figure_out_scope(mangle);\n                    var comp = new Compressor(compressor.options);\n                    ast = ast.transform(comp);\n                    ast.figure_out_scope(mangle);\n                    ast.compute_char_frequency(mangle);\n                    ast.mangle_names(mangle);\n                    var fun;\n                    ast.walk(new TreeWalker(function(node) {\n                        if (fun) return true;\n                        if (node instanceof AST_Lambda) {\n                            fun = node;\n                            return true;\n                        }\n                    }));\n                    var code = OutputStream();\n                    AST_BlockStatement.prototype._codegen.call(fun, code);\n                    self.args = [\n                        make_node(AST_String, self, {\n                            value: fun.argnames.map(function(arg) {\n                                return arg.print_to_string();\n                            }).join(),\n                        }),\n                        make_node(AST_String, self.args[self.args.length - 1], {\n                            value: code.get().replace(/^\\{|\\}$/g, "")\n                        }),\n                    ];\n                    return self;\n                } catch (ex) {\n                    if (ex instanceof JS_Parse_Error) {\n                        AST_Node.warn("Error parsing code passed to new Function [{start}]", self.args[self.args.length - 1]);\n                        AST_Node.warn(ex.toString());\n                    } else {\n                        throw ex;\n                    }\n                }\n            }\n        }\n        var fn = exp instanceof AST_SymbolRef ? exp.fixed_value() : exp;\n        var parent = compressor.parent(), current = compressor.self();\n        var is_func = fn instanceof AST_Lambda\n            && (!is_async(fn) || compressor.option("awaits") && parent instanceof AST_Await)\n            && (!is_generator(fn) || compressor.option("yields") && current instanceof AST_Yield && current.nested);\n        var stat = is_func && fn.first_statement();\n        var has_default = 0, has_destructured = false;\n        var has_spread = !all(self.args, function(arg) {\n            return !(arg instanceof AST_Spread);\n        });\n        var can_drop = is_func && all(fn.argnames, function(argname, index) {\n            if (has_default == 1 && self.args[index] instanceof AST_Spread) has_default = 2;\n            if (argname instanceof AST_DefaultValue) {\n                if (!has_default) has_default = 1;\n                var arg = has_default == 1 && self.args[index];\n                if (!is_undefined(arg)) has_default = 2;\n                if (has_arg_refs(fn, argname.value)) return false;\n                argname = argname.name;\n            }\n            if (argname instanceof AST_Destructured) {\n                has_destructured = true;\n                if (has_arg_refs(fn, argname)) return false;\n            }\n            return true;\n        }) && !(fn.rest instanceof AST_Destructured && has_arg_refs(fn, fn.rest));\n        var can_inline = can_drop\n            && compressor.option("inline")\n            && !self.is_expr_pure(compressor)\n            && (exp === fn || safe_from_strict_mode(fn, compressor));\n        if (can_inline && stat instanceof AST_Return) {\n            var value = stat.value;\n            if (exp === fn\n                && !fn.name\n                && (!value || value.is_constant_expression())\n                && safe_from_await_yield(fn, avoid_await_yield(compressor))) {\n                return make_sequence(self, convert_args(value)).optimize(compressor);\n            }\n        }\n        if (is_func && !fn.contains_this()) {\n            var def, value, var_assigned = false;\n            if (can_inline\n                && !fn.uses_arguments\n                && !fn.pinned()\n                && !(fn.name && fn instanceof AST_LambdaExpression)\n                && (exp === fn || !recursive_ref(compressor, def = exp.definition(), fn)\n                    && fn.is_constant_expression(find_scope(compressor)))\n                && (value = can_flatten_body(stat))) {\n                var replacing = exp === fn || def.single_use && def.references.length - def.replaced == 1;\n                if (can_substitute_directly()) {\n                    self._optimized = true;\n                    var retValue = value.optimize(compressor).clone(true);\n                    var args = self.args.slice();\n                    var refs = [];\n                    retValue = retValue.transform(new TreeTransformer(function(node) {\n                        if (node instanceof AST_SymbolRef) {\n                            var def = node.definition();\n                            if (fn.variables.get(node.name) !== def) {\n                                refs.push(node);\n                                return node;\n                            }\n                            var index = resolve_index(def);\n                            var arg = args[index];\n                            if (!arg) return make_node(AST_Undefined, self);\n                            args[index] = null;\n                            var parent = this.parent();\n                            return parent ? maintain_this_binding(parent, node, arg) : arg;\n                        }\n                    }));\n                    var save_inlined = fn.inlined;\n                    if (exp !== fn) fn.inlined = true;\n                    var exprs = [];\n                    args.forEach(function(arg) {\n                        if (!arg) return;\n                        arg = arg.clone(true);\n                        arg.walk(new TreeWalker(function(node) {\n                            if (node instanceof AST_SymbolRef) refs.push(node);\n                        }));\n                        exprs.push(arg);\n                    }, []);\n                    exprs.push(retValue);\n                    var node = make_sequence(self, exprs).optimize(compressor);\n                    fn.inlined = save_inlined;\n                    node = maintain_this_binding(parent, current, node);\n                    self.inlined_node = node;\n                    if (replacing || best_of_expression(node, self) === node) {\n                        refs.forEach(function(ref) {\n                            ref.scope = exp === fn ? fn.parent_scope : exp.scope;\n                            ref.reference();\n                            var def = ref.definition();\n                            if (replacing) def.replaced++;\n                            def.single_use = false;\n                        });\n                        return node;\n                    } else if (!node.has_side_effects(compressor)) {\n                        self.drop_side_effect_free = function(compressor, first_in_statement) {\n                            var self = this;\n                            var exprs = self.args.slice();\n                            exprs.unshift(self.expression);\n                            return make_sequence(self, exprs).drop_side_effect_free(compressor, first_in_statement);\n                        };\n                        self.has_side_effects = function(compressor) {\n                            var self = this;\n                            var exprs = self.args.slice();\n                            exprs.unshift(self.expression);\n                            return make_sequence(self, exprs).has_side_effects(compressor);\n                        };\n                    }\n                }\n                var arg_used, insert, in_loop, scope;\n                if (replacing && can_inject_symbols()) {\n                    fn._squeezed = true;\n                    if (exp !== fn) fn.parent_scope = exp.scope;\n                    var node = make_sequence(self, flatten_fn()).optimize(compressor);\n                    return maintain_this_binding(parent, current, node);\n                }\n            }\n            if (compressor.option("side_effects")\n                && can_drop\n                && all(fn.body, is_empty)\n                && (fn === exp ? fn_name_unused(fn, compressor) : !has_default && !has_destructured && !fn.rest)\n                && !(is_arrow(fn) && fn.value)\n                && safe_from_await_yield(fn, avoid_await_yield(compressor))) {\n                return make_sequence(self, convert_args()).optimize(compressor);\n            }\n        }\n        if (compressor.option("arrows")\n            && compressor.option("module")\n            && (exp instanceof AST_AsyncFunction || exp instanceof AST_Function)\n            && !exp.name\n            && !exp.uses_arguments\n            && !exp.pinned()\n            && !exp.contains_this()) {\n            var arrow = make_node(is_async(exp) ? AST_AsyncArrow : AST_Arrow, exp, exp);\n            arrow.init_vars(exp.parent_scope, exp);\n            arrow.variables.del("arguments");\n            self.expression = arrow.transform(compressor);\n            return self;\n        }\n        if (compressor.option("drop_console")) {\n            if (exp instanceof AST_PropAccess) {\n                var name = exp.expression;\n                while (name.expression) {\n                    name = name.expression;\n                }\n                if (is_undeclared_ref(name) && name.name == "console") {\n                    return make_node(AST_Undefined, self).optimize(compressor);\n                }\n            }\n        }\n        if (compressor.option("negate_iife") && parent instanceof AST_SimpleStatement && is_iife_call(current)) {\n            return self.negate(compressor, true);\n        }\n        return try_evaluate(compressor, self);\n\n        function make_void_lhs(orig) {\n            return make_node(AST_Sub, orig, {\n                expression: make_node(AST_Array, orig, { elements: [] }),\n                property: make_node(AST_Number, orig, { value: 0 }),\n            });\n        }\n\n        function convert_args(value) {\n            var args = self.args.slice();\n            var destructured = has_default > 1 || has_destructured || fn.rest;\n            if (destructured || has_spread) args = [ make_node(AST_Array, self, { elements: args }) ];\n            if (destructured) {\n                var tt = new TreeTransformer(function(node, descend) {\n                    if (node instanceof AST_DefaultValue) return make_node(AST_DefaultValue, node, {\n                        name: node.name.transform(tt) || make_void_lhs(node),\n                        value: node.value,\n                    });\n                    if (node instanceof AST_DestructuredArray) {\n                        var elements = [];\n                        node.elements.forEach(function(node, index) {\n                            node = node.transform(tt);\n                            if (node) elements[index] = node;\n                        });\n                        fill_holes(node, elements);\n                        return make_node(AST_DestructuredArray, node, { elements: elements });\n                    }\n                    if (node instanceof AST_DestructuredObject) {\n                        var properties = [], side_effects = [];\n                        node.properties.forEach(function(prop) {\n                            var key = prop.key;\n                            var value = prop.value.transform(tt);\n                            if (value) {\n                                if (side_effects.length) {\n                                    if (!(key instanceof AST_Node)) key = make_node_from_constant(key, prop);\n                                    side_effects.push(key);\n                                    key = make_sequence(node, side_effects);\n                                    side_effects = [];\n                                }\n                                properties.push(make_node(AST_DestructuredKeyVal, prop, {\n                                    key: key,\n                                    value: value,\n                                }));\n                            } else if (key instanceof AST_Node) {\n                                side_effects.push(key);\n                            }\n                        });\n                        if (side_effects.length) properties.push(make_node(AST_DestructuredKeyVal, node, {\n                            key: make_sequence(node, side_effects),\n                            value: make_void_lhs(node),\n                        }));\n                        return make_node(AST_DestructuredObject, node, { properties: properties });\n                    }\n                    if (node instanceof AST_SymbolFunarg) return null;\n                });\n                var lhs = [];\n                fn.argnames.forEach(function(argname, index) {\n                    argname = argname.transform(tt);\n                    if (argname) lhs[index] = argname;\n                });\n                var rest = fn.rest && fn.rest.transform(tt);\n                if (rest) lhs.length = fn.argnames.length;\n                fill_holes(fn, lhs);\n                args[0] = make_node(AST_Assign, self, {\n                    operator: "=",\n                    left: make_node(AST_DestructuredArray, fn, {\n                        elements: lhs,\n                        rest: rest,\n                    }),\n                    right: args[0],\n                });\n            } else fn.argnames.forEach(function(argname) {\n                if (argname instanceof AST_DefaultValue) args.push(argname.value);\n            });\n            args.push(value || make_node(AST_Undefined, self));\n            return args;\n        }\n\n        function noop_value() {\n            return self.call_only ? make_node(AST_Number, self, { value: 0 }) : make_node(AST_Undefined, self);\n        }\n\n        function return_value(stat) {\n            if (!stat) return noop_value();\n            if (stat instanceof AST_Return) return stat.value || noop_value();\n            if (stat instanceof AST_SimpleStatement) {\n                return self.call_only ? stat.body : make_node(AST_UnaryPrefix, stat, {\n                    operator: "void",\n                    expression: stat.body,\n                });\n            }\n        }\n\n        function can_flatten_body(stat) {\n            var len = fn.body.length;\n            if (len < 2) {\n                stat = return_value(stat);\n                if (stat) return stat;\n            }\n            if (compressor.option("inline") < 3) return false;\n            stat = null;\n            for (var i = 0; i < len; i++) {\n                var line = fn.body[i];\n                if (line instanceof AST_Var) {\n                    if (var_assigned) {\n                        if (!stat) continue;\n                        if (!(stat instanceof AST_SimpleStatement)) return false;\n                        if (!declarations_only(line)) stat = null;\n                    } else if (!declarations_only(line)) {\n                        if (stat && !(stat instanceof AST_SimpleStatement)) return false;\n                        stat = null;\n                        var_assigned = true;\n                    }\n                } else if (line instanceof AST_AsyncDefun\n                    || line instanceof AST_Defun\n                    || line instanceof AST_EmptyStatement) {\n                    continue;\n                } else if (stat) {\n                    return false;\n                } else {\n                    stat = line;\n                }\n            }\n            return return_value(stat);\n        }\n\n        function resolve_index(def) {\n            for (var i = fn.argnames.length; --i >= 0;) {\n                if (fn.argnames[i].definition() === def) return i;\n            }\n        }\n\n        function can_substitute_directly() {\n            if (has_default || has_destructured || has_spread || var_assigned || fn.rest) return;\n            if (compressor.option("inline") < 2 && fn.argnames.length) return;\n            if (!fn.variables.all(function(def) {\n                return def.references.length - def.replaced < 2 && def.orig[0] instanceof AST_SymbolFunarg;\n            })) return;\n            var scope = compressor.find_parent(AST_Scope);\n            var abort = false;\n            var avoid = avoid_await_yield(compressor, scope);\n            var begin;\n            var in_order = [];\n            var side_effects = false;\n            var tw = new TreeWalker(function(node, descend) {\n                if (abort) return true;\n                if (node instanceof AST_Binary && lazy_op[node.operator]\n                    || node instanceof AST_Conditional) {\n                    in_order = null;\n                    return;\n                }\n                if (node instanceof AST_Class) return abort = true;\n                if (node instanceof AST_Destructured) {\n                    side_effects = true;\n                    return;\n                }\n                if (node instanceof AST_Scope) return abort = true;\n                if (avoid && node instanceof AST_Symbol && avoid[node.name]) return abort = true;\n                if (node instanceof AST_SymbolRef) {\n                    var def = node.definition();\n                    if (fn.variables.get(node.name) !== def) {\n                        in_order = null;\n                        return;\n                    }\n                    if (def.init instanceof AST_LambdaDefinition) return abort = true;\n                    if (is_lhs(node, tw.parent())) return abort = true;\n                    var index = resolve_index(def);\n                    if (!(begin < index)) begin = index;\n                    if (!in_order) return;\n                    if (side_effects) {\n                        in_order = null;\n                    } else {\n                        in_order.push(fn.argnames[index]);\n                    }\n                    return;\n                }\n                if (side_effects) return;\n                if (node instanceof AST_Assign && node.left instanceof AST_PropAccess) {\n                    node.left.expression.walk(tw);\n                    if (node.left instanceof AST_Sub) node.left.property.walk(tw);\n                    node.right.walk(tw);\n                    side_effects = true;\n                    return true;\n                }\n                if (node.has_side_effects(compressor)) {\n                    descend();\n                    side_effects = true;\n                    return true;\n                }\n            });\n            value.walk(tw);\n            if (abort) return;\n            var end = self.args.length;\n            if (in_order && fn.argnames.length >= end) {\n                end = fn.argnames.length;\n                while (end-- > begin && fn.argnames[end] === in_order.pop());\n                end++;\n            }\n            return end <= begin || all(self.args.slice(begin, end), side_effects && !in_order ? function(funarg) {\n                return funarg.is_constant_expression(scope);\n            } : function(funarg) {\n                return !funarg.has_side_effects(compressor);\n            });\n        }\n\n        function var_exists(defined, name) {\n            return defined.has(name) || identifier_atom[name] || scope.var_names().has(name);\n        }\n\n        function can_inject_args(defined, safe_to_inject) {\n            var abort = false;\n            fn.each_argname(function(arg) {\n                if (abort) return;\n                if (arg.unused) return;\n                if (!safe_to_inject || var_exists(defined, arg.name)) return abort = true;\n                arg_used.set(arg.name, true);\n                if (in_loop) in_loop.push(arg.definition());\n            });\n            return !abort;\n        }\n\n        function can_inject_vars(defined, safe_to_inject) {\n            for (var i = 0; i < fn.body.length; i++) {\n                var stat = fn.body[i];\n                if (stat instanceof AST_LambdaDefinition) {\n                    var name = stat.name;\n                    if (!safe_to_inject) return false;\n                    if (arg_used.has(name.name)) return false;\n                    if (var_exists(defined, name.name)) return false;\n                    if (!all(stat.enclosed, function(def) {\n                        return def.scope === scope || def.scope === stat || !defined.has(def.name);\n                    })) return false;\n                    if (in_loop) in_loop.push(name.definition());\n                    continue;\n                }\n                if (!(stat instanceof AST_Var)) continue;\n                if (!safe_to_inject) return false;\n                for (var j = stat.definitions.length; --j >= 0;) {\n                    var name = stat.definitions[j].name;\n                    if (var_exists(defined, name.name)) return false;\n                    if (in_loop) in_loop.push(name.definition());\n                }\n            }\n            return true;\n        }\n\n        function can_inject_symbols() {\n            var defined = new Dictionary();\n            var level = 0, child;\n            scope = current;\n            do {\n                if (scope.variables) scope.variables.each(function(def) {\n                    defined.set(def.name, true);\n                });\n                child = scope;\n                scope = compressor.parent(level++);\n                if (scope instanceof AST_ClassField) {\n                    if (!scope.static) return false;\n                } else if (scope instanceof AST_DWLoop) {\n                    in_loop = [];\n                } else if (scope instanceof AST_For) {\n                    if (scope.init === child) continue;\n                    in_loop = [];\n                } else if (scope instanceof AST_ForEnumeration) {\n                    if (scope.init === child) continue;\n                    if (scope.object === child) continue;\n                    in_loop = [];\n                }\n            } while (!(scope instanceof AST_Scope));\n            insert = scope.body.indexOf(child) + 1;\n            if (!insert) return false;\n            if (!safe_from_await_yield(fn, avoid_await_yield(compressor, scope))) return false;\n            var safe_to_inject = (exp !== fn || fn.parent_scope.resolve() === scope) && !scope.pinned();\n            if (scope instanceof AST_Toplevel) {\n                if (compressor.toplevel.vars) {\n                    defined.set("arguments", true);\n                } else {\n                    safe_to_inject = false;\n                }\n            }\n            arg_used = new Dictionary();\n            var inline = compressor.option("inline");\n            if (!can_inject_args(defined, inline >= 2 && safe_to_inject)) return false;\n            if (!can_inject_vars(defined, inline >= 3 && safe_to_inject)) return false;\n            return !in_loop || in_loop.length == 0 || !is_reachable(fn, in_loop);\n        }\n\n        function append_var(decls, expressions, name, value) {\n            var def = name.definition();\n            if (!scope.var_names().has(name.name)) {\n                def.first_decl = null;\n                scope.var_names().set(name.name, true);\n                decls.push(make_node(AST_VarDef, name, {\n                    name: name,\n                    value: null,\n                }));\n            }\n            scope.variables.set(name.name, def);\n            scope.enclosed.push(def);\n            if (!value) return;\n            var sym = make_node(AST_SymbolRef, name);\n            def.assignments++;\n            def.references.push(sym);\n            expressions.push(make_node(AST_Assign, self, {\n                operator: "=",\n                left: sym,\n                right: value,\n            }));\n        }\n\n        function flatten_args(decls, expressions) {\n            var len = fn.argnames.length;\n            for (var i = self.args.length; --i >= len;) {\n                expressions.push(self.args[i]);\n            }\n            var default_args = [];\n            for (i = len; --i >= 0;) {\n                var argname = fn.argnames[i];\n                var name;\n                if (argname instanceof AST_DefaultValue) {\n                    default_args.push(argname);\n                    name = argname.name;\n                } else {\n                    name = argname;\n                }\n                var value = self.args[i];\n                if (name.unused || scope.var_names().has(name.name)) {\n                    if (value) expressions.push(value);\n                } else {\n                    var symbol = make_node(AST_SymbolVar, name);\n                    var def = name.definition();\n                    def.orig.push(symbol);\n                    def.eliminated++;\n                    if (name.unused !== undefined) {\n                        append_var(decls, expressions, symbol);\n                        if (value) expressions.push(value);\n                    } else {\n                        if (!value && argname === name && (in_loop\n                            || name.name == "arguments" && !is_arrow(fn) && is_arrow(scope))) {\n                            value = make_node(AST_Undefined, self);\n                        }\n                        append_var(decls, expressions, symbol, value);\n                    }\n                }\n            }\n            decls.reverse();\n            expressions.reverse();\n            for (i = default_args.length; --i >= 0;) {\n                var node = default_args[i];\n                if (node.name.unused !== undefined) {\n                    expressions.push(node.value);\n                } else {\n                    var sym = make_node(AST_SymbolRef, node.name);\n                    node.name.definition().references.push(sym);\n                    expressions.push(make_node(AST_Assign, node, {\n                        operator: "=",\n                        left: sym,\n                        right: node.value,\n                    }));\n                }\n            }\n        }\n\n        function flatten_destructured(decls, expressions) {\n            expressions.push(make_node(AST_Assign, self, {\n                operator: "=",\n                left: make_node(AST_DestructuredArray, self, {\n                    elements: fn.argnames.map(function(argname) {\n                        if (argname.unused) return make_node(AST_Hole, argname);\n                        return argname.convert_symbol(AST_SymbolRef, process);\n                    }),\n                    rest: fn.rest && fn.rest.convert_symbol(AST_SymbolRef, process),\n                }),\n                right: make_node(AST_Array, self, { elements: self.args.slice() }),\n            }));\n\n            function process(ref, name) {\n                if (name.unused) return make_void_lhs(name);\n                var def = name.definition();\n                def.assignments++;\n                def.references.push(ref);\n                var symbol = make_node(AST_SymbolVar, name);\n                def.orig.push(symbol);\n                def.eliminated++;\n                append_var(decls, expressions, symbol);\n            }\n        }\n\n        function flatten_vars(decls, expressions) {\n            var args = [ insert, 0 ];\n            var decl_var = [], expr_fn = [], expr_var = [], expr_loop = [], exprs = [];\n            fn.body.filter(in_loop ? function(stat) {\n                if (!(stat instanceof AST_LambdaDefinition)) return true;\n                var name = make_node(AST_SymbolVar, flatten_var(stat.name));\n                var def = name.definition();\n                def.fixed = false;\n                def.orig.push(name);\n                def.eliminated++;\n                append_var(decls, expr_fn, name, to_func_expr(stat, true));\n                return false;\n            } : function(stat) {\n                if (!(stat instanceof AST_LambdaDefinition)) return true;\n                var def = stat.name.definition();\n                scope.functions.set(def.name, def);\n                scope.variables.set(def.name, def);\n                scope.enclosed.push(def);\n                scope.var_names().set(def.name, true);\n                args.push(stat);\n                return false;\n            }).forEach(function(stat) {\n                if (!(stat instanceof AST_Var)) {\n                    if (stat instanceof AST_SimpleStatement) exprs.push(stat.body);\n                    return;\n                }\n                for (var j = 0; j < stat.definitions.length; j++) {\n                    var var_def = stat.definitions[j];\n                    var name = flatten_var(var_def.name);\n                    var value = var_def.value;\n                    if (value && exprs.length > 0) {\n                        exprs.push(value);\n                        value = make_sequence(var_def, exprs);\n                        exprs = [];\n                    }\n                    append_var(decl_var, expr_var, name, value);\n                    if (!in_loop) continue;\n                    if (arg_used.has(name.name)) continue;\n                    if (name.definition().orig.length == 1 && fn.functions.has(name.name)) continue;\n                    expr_loop.push(init_ref(compressor, name));\n                }\n            });\n            [].push.apply(decls, decl_var);\n            [].push.apply(expressions, expr_loop);\n            [].push.apply(expressions, expr_fn);\n            [].push.apply(expressions, expr_var);\n            return args;\n        }\n\n        function flatten_fn() {\n            var decls = [];\n            var expressions = [];\n            if (has_default > 1 || has_destructured || has_spread || fn.rest) {\n                flatten_destructured(decls, expressions);\n            } else {\n                flatten_args(decls, expressions);\n            }\n            var args = flatten_vars(decls, expressions);\n            expressions.push(value);\n            if (decls.length) args.push(make_node(AST_Var, fn, { definitions: decls }));\n            [].splice.apply(scope.body, args);\n            fn.enclosed.forEach(function(def) {\n                if (scope.var_names().has(def.name)) return;\n                scope.enclosed.push(def);\n                scope.var_names().set(def.name, true);\n            });\n            return expressions;\n        }\n    });\n\n    OPT(AST_New, function(self, compressor) {\n        if (compressor.option("unsafe")) {\n            var exp = self.expression;\n            if (is_undeclared_ref(exp)) switch (exp.name) {\n              case "Array":\n              case "Error":\n              case "Function":\n              case "Object":\n              case "RegExp":\n                return make_node(AST_Call, self).transform(compressor);\n            }\n        }\n        if (compressor.option("sequences")) {\n            var seq = lift_sequence_in_expression(self, compressor);\n            if (seq !== self) return seq.optimize(compressor);\n        }\n        if (compressor.option("unused")) drop_unused_call_args(self, compressor);\n        return self;\n    });\n\n    // (a = b, x && a = c) ---\x3e a = x ? c : b\n    // (a = b, x || a = c) ---\x3e a = x ? b : c\n    function to_conditional_assignment(compressor, def, value, node) {\n        if (!(node instanceof AST_Binary)) return;\n        if (!(node.operator == "&&" || node.operator == "||")) return;\n        if (!(node.right instanceof AST_Assign)) return;\n        if (node.right.operator != "=") return;\n        if (!(node.right.left instanceof AST_SymbolRef)) return;\n        if (node.right.left.definition() !== def) return;\n        if (value.has_side_effects(compressor)) return;\n        if (!safe_from_assignment(node.left)) return;\n        if (!safe_from_assignment(node.right.right)) return;\n        def.replaced++;\n        return node.operator == "&&" ? make_node(AST_Conditional, node, {\n            condition: node.left,\n            consequent: node.right.right,\n            alternative: value,\n        }) : make_node(AST_Conditional, node, {\n            condition: node.left,\n            consequent: value,\n            alternative: node.right.right,\n        });\n\n        function safe_from_assignment(node) {\n            if (node.has_side_effects(compressor)) return;\n            var hit = false;\n            node.walk(new TreeWalker(function(node) {\n                if (hit) return true;\n                if (node instanceof AST_SymbolRef && node.definition() === def) return hit = true;\n            }));\n            return !hit;\n        }\n    }\n\n    OPT(AST_Sequence, function(self, compressor) {\n        var expressions = filter_for_side_effects();\n        var end = expressions.length - 1;\n        merge_assignments();\n        trim_right_for_undefined();\n        if (end == 0) {\n            self = maintain_this_binding(compressor.parent(), compressor.self(), expressions[0]);\n            if (!(self instanceof AST_Sequence)) self = self.optimize(compressor);\n            return self;\n        }\n        self.expressions = expressions;\n        return self;\n\n        function filter_for_side_effects() {\n            if (!compressor.option("side_effects")) return self.expressions;\n            var expressions = [];\n            var first = first_in_statement(compressor);\n            var last = self.expressions.length - 1;\n            self.expressions.forEach(function(expr, index) {\n                if (index < last) expr = expr.drop_side_effect_free(compressor, first);\n                if (expr) {\n                    merge_sequence(expressions, expr);\n                    first = false;\n                }\n            });\n            return expressions;\n        }\n\n        function trim_right_for_undefined() {\n            if (!compressor.option("side_effects")) return;\n            while (end > 0 && is_undefined(expressions[end], compressor)) end--;\n            if (end < expressions.length - 1) {\n                expressions[end] = make_node(AST_UnaryPrefix, self, {\n                    operator: "void",\n                    expression: expressions[end],\n                });\n                expressions.length = end + 1;\n            }\n        }\n\n        function is_simple_assign(node) {\n            return node instanceof AST_Assign\n                && node.operator == "="\n                && node.left instanceof AST_SymbolRef\n                && node.left.definition();\n        }\n\n        function merge_assignments() {\n            for (var i = 1; i < end; i++) {\n                var prev = expressions[i - 1];\n                var def = is_simple_assign(prev);\n                if (!def) continue;\n                var expr = expressions[i];\n                if (compressor.option("conditionals")) {\n                    var cond = to_conditional_assignment(compressor, def, prev.right, expr);\n                    if (cond) {\n                        prev.right = cond;\n                        expressions.splice(i--, 1);\n                        end--;\n                        continue;\n                    }\n                }\n                if (compressor.option("dead_code")\n                    && is_simple_assign(expr) === def\n                    && expr.right.is_constant_expression(def.scope.resolve())) {\n                    expressions[--i] = prev.right;\n                }\n            }\n        }\n    });\n\n    OPT(AST_UnaryPostfix, function(self, compressor) {\n        if (compressor.option("sequences")) {\n            var seq = lift_sequence_in_expression(self, compressor);\n            if (seq !== self) return seq.optimize(compressor);\n        }\n        return try_evaluate(compressor, self);\n    });\n\n    var SIGN_OPS = makePredicate("+ -");\n    var MULTIPLICATIVE_OPS = makePredicate("* / %");\n    OPT(AST_UnaryPrefix, function(self, compressor) {\n        var op = self.operator;\n        var exp = self.expression;\n        if (compressor.option("sequences") && can_lift()) {\n            var seq = lift_sequence_in_expression(self, compressor);\n            if (seq !== self) return seq.optimize(compressor);\n        }\n        switch (op) {\n          case "+":\n            if (!compressor.option("evaluate")) break;\n            if (!exp.is_number(compressor, true)) break;\n            var parent = compressor.parent();\n            if (parent instanceof AST_UnaryPrefix && parent.operator == "delete") break;\n            return exp;\n          case "-":\n            if (exp instanceof AST_Infinity) exp = exp.transform(compressor);\n            // avoids infinite recursion of numerals\n            if (exp instanceof AST_Number || exp instanceof AST_Infinity) return self;\n            break;\n          case "!":\n            if (!compressor.option("booleans")) break;\n            if (exp.is_truthy()) return make_sequence(self, [ exp, make_node(AST_False, self) ]).optimize(compressor);\n            if (compressor.in_boolean_context()) {\n                // !!foo ---\x3e foo, if we\'re in boolean context\n                if (exp instanceof AST_UnaryPrefix && exp.operator == "!") return exp.expression;\n                if (exp instanceof AST_Binary) {\n                    var first = first_in_statement(compressor);\n                    self = (first ? best_of_statement : best_of_expression)(self, exp.negate(compressor, first));\n                }\n            }\n            break;\n          case "delete":\n            if (!compressor.option("evaluate")) break;\n            if (may_not_delete(exp)) break;\n            return make_sequence(self, [ exp, make_node(AST_True, self) ]).optimize(compressor);\n          case "typeof":\n            if (!compressor.option("booleans")) break;\n            if (!compressor.in_boolean_context()) break;\n            // typeof always returns a non-empty string, thus always truthy\n            AST_Node.warn("Boolean expression always true [{start}]", self);\n            var exprs = [ make_node(AST_True, self) ];\n            if (!(exp instanceof AST_SymbolRef && can_drop_symbol(exp, compressor))) exprs.unshift(exp);\n            return make_sequence(self, exprs).optimize(compressor);\n          case "void":\n            if (!compressor.option("side_effects")) break;\n            exp = exp.drop_side_effect_free(compressor);\n            if (!exp) return make_node(AST_Undefined, self).optimize(compressor);\n            self.expression = exp;\n            return self;\n        }\n        if (compressor.option("evaluate")\n            && exp instanceof AST_Binary\n            && SIGN_OPS[op]\n            && MULTIPLICATIVE_OPS[exp.operator]\n            && (exp.left.is_constant() || !exp.right.has_side_effects(compressor))) {\n            return make_node(AST_Binary, self, {\n                operator: exp.operator,\n                left: make_node(AST_UnaryPrefix, exp.left, {\n                    operator: op,\n                    expression: exp.left,\n                }),\n                right: exp.right,\n            });\n        }\n        return try_evaluate(compressor, self);\n\n        function may_not_delete(node) {\n            return node instanceof AST_Infinity\n                || node instanceof AST_NaN\n                || node instanceof AST_NewTarget\n                || node instanceof AST_PropAccess\n                || node instanceof AST_SymbolRef\n                || node instanceof AST_Undefined;\n        }\n\n        function can_lift() {\n            switch (op) {\n              case "delete":\n                return !may_not_delete(exp.tail_node());\n              case "typeof":\n                return !is_undeclared_ref(exp.tail_node());\n              default:\n                return true;\n            }\n        }\n    });\n\n    OPT(AST_Await, function(self, compressor) {\n        if (!compressor.option("awaits")) return self;\n        if (compressor.option("sequences")) {\n            var seq = lift_sequence_in_expression(self, compressor);\n            if (seq !== self) return seq.optimize(compressor);\n        }\n        if (compressor.option("side_effects")) {\n            var exp = self.expression;\n            if (exp instanceof AST_Await) return exp.optimize(compressor);\n            if (exp instanceof AST_UnaryPrefix && exp.expression instanceof AST_Await) return exp.optimize(compressor);\n            for (var level = 0, node = self, parent; parent = compressor.parent(level++); node = parent) {\n                if (is_arrow(parent)) {\n                    if (parent.value === node) return exp.optimize(compressor);\n                } else if (parent instanceof AST_Return) {\n                    var drop = true;\n                    do {\n                        node = parent;\n                        parent = compressor.parent(level++);\n                        if (parent instanceof AST_Try && (parent.bfinally || parent.bcatch) !== node) {\n                            drop = false;\n                            break;\n                        }\n                    } while (parent && !(parent instanceof AST_Scope));\n                    if (drop) return exp.optimize(compressor);\n                } else if (parent instanceof AST_Sequence) {\n                    if (parent.tail_node() === node) continue;\n                }\n                break;\n            }\n        }\n        return self;\n    });\n\n    OPT(AST_Yield, function(self, compressor) {\n        if (!compressor.option("yields")) return self;\n        if (compressor.option("sequences")) {\n            var seq = lift_sequence_in_expression(self, compressor);\n            if (seq !== self) return seq.optimize(compressor);\n        }\n        var exp = self.expression;\n        if (self.nested && exp.TYPE == "Call") {\n            var inlined = exp.clone().optimize(compressor);\n            if (inlined.TYPE != "Call") return inlined;\n        }\n        return self;\n    });\n\n    AST_Binary.DEFMETHOD("lift_sequences", function(compressor) {\n        if (this.left instanceof AST_PropAccess) {\n            if (!(this.left.expression instanceof AST_Sequence)) return this;\n            var x = this.left.expression.expressions.slice();\n            var e = this.clone();\n            e.left = e.left.clone();\n            e.left.expression = x.pop();\n            x.push(e);\n            return make_sequence(this, x);\n        }\n        if (this.left instanceof AST_Sequence) {\n            var x = this.left.expressions.slice();\n            var e = this.clone();\n            e.left = x.pop();\n            x.push(e);\n            return make_sequence(this, x);\n        }\n        if (this.right instanceof AST_Sequence) {\n            if (this.left.has_side_effects(compressor)) return this;\n            var assign = this.operator == "=" && this.left instanceof AST_SymbolRef;\n            var x = this.right.expressions;\n            var last = x.length - 1;\n            for (var i = 0; i < last; i++) {\n                if (!assign && x[i].has_side_effects(compressor)) break;\n            }\n            if (i == last) {\n                x = x.slice();\n                var e = this.clone();\n                e.right = x.pop();\n                x.push(e);\n                return make_sequence(this, x);\n            }\n            if (i > 0) {\n                var e = this.clone();\n                e.right = make_sequence(this.right, x.slice(i));\n                x = x.slice(0, i);\n                x.push(e);\n                return make_sequence(this, x);\n            }\n        }\n        return this;\n    });\n\n    var indexFns = makePredicate("indexOf lastIndexOf");\n    var commutativeOperators = makePredicate("== === != !== * & | ^");\n    function is_object(node, plain) {\n        if (node instanceof AST_Assign) return !plain && node.operator == "=" && is_object(node.right);\n        if (node instanceof AST_New) return !plain;\n        if (node instanceof AST_Sequence) return is_object(node.tail_node(), plain);\n        if (node instanceof AST_SymbolRef) return !plain && is_object(node.fixed_value());\n        return node instanceof AST_Array\n            || node instanceof AST_Class\n            || node instanceof AST_Lambda\n            || node instanceof AST_Object;\n    }\n\n    function can_drop_op(node, compressor) {\n        var rhs = node.right;\n        switch (node.operator) {\n          case "in":\n            return is_object(rhs) || compressor && compressor.option("unsafe_comps");\n          case "instanceof":\n            if (rhs instanceof AST_SymbolRef) rhs = rhs.fixed_value();\n            if (rhs instanceof AST_Defun || rhs instanceof AST_Function || is_generator(rhs)) return true;\n            if (is_lambda(rhs) && node.left.is_constant()) return true;\n            return compressor && compressor.option("unsafe_comps");\n          default:\n            return true;\n        }\n    }\n\n    function needs_enqueuing(compressor, node) {\n        if (node.is_constant()) return true;\n        if (node instanceof AST_Assign) return node.operator != "=" || needs_enqueuing(compressor, node.right);\n        if (node instanceof AST_Binary) {\n            return !lazy_op[node.operator]\n                || needs_enqueuing(compressor, node.left) && needs_enqueuing(compressor, node.right);\n        }\n        if (node instanceof AST_Call) {\n            if (!is_async(node.expression)) return false;\n            var has_await = false;\n            walk_body(node.expression, new TreeWalker(function(expr) {\n                if (has_await) return true;\n                if (expr instanceof AST_Await) return has_await = true;\n                if (expr !== node && expr instanceof AST_Scope) return true;\n            }));\n            return !has_await;\n        }\n        if (node instanceof AST_Conditional) {\n            return needs_enqueuing(compressor, node.consequent) && needs_enqueuing(compressor, node.alternative);\n        }\n        if (node instanceof AST_Sequence) return needs_enqueuing(compressor, node.tail_node());\n        if (node instanceof AST_SymbolRef) {\n            var fixed = node.fixed_value();\n            return fixed && needs_enqueuing(compressor, fixed);\n        }\n        if (node instanceof AST_Template) return !node.tag || is_raw_tag(compressor, node.tag);\n        if (node instanceof AST_Unary) return true;\n    }\n\n    function extract_lhs(node, compressor) {\n        if (node instanceof AST_Assign) return is_lhs_read_only(node.left, compressor) ? node : node.left;\n        if (node instanceof AST_Sequence) return extract_lhs(node.tail_node(), compressor);\n        if (node instanceof AST_UnaryPrefix && UNARY_POSTFIX[node.operator]) {\n            return is_lhs_read_only(node.expression, compressor) ? node : node.expression;\n        }\n        return node;\n    }\n\n    function repeatable(compressor, node) {\n        if (node instanceof AST_Dot) return repeatable(compressor, node.expression);\n        if (node instanceof AST_Sub) {\n            return repeatable(compressor, node.expression) && repeatable(compressor, node.property);\n        }\n        if (node instanceof AST_Symbol) return true;\n        return !node.has_side_effects(compressor);\n    }\n\n    function swap_chain(self, compressor) {\n        var rhs = self.right.tail_node();\n        if (rhs !== self.right) {\n            var exprs = self.right.expressions.slice(0, -1);\n            exprs.push(rhs.left);\n            rhs = rhs.clone();\n            rhs.left = make_sequence(self.right, exprs);\n            self.right = rhs;\n        }\n        self.left = make_node(AST_Binary, self, {\n            operator: self.operator,\n            left: self.left,\n            right: rhs.left,\n            start: self.left.start,\n            end: rhs.left.end,\n        });\n        self.right = rhs.right;\n        if (compressor) {\n            var left = self.left.transform(compressor);\n            if (left !== self.left) {\n                self = self.clone();\n                self.left = left;\n            }\n            return self;\n        }\n        if (self.operator == rhs.left.operator) swap_chain(self.left);\n    }\n\n    OPT(AST_Binary, function(self, compressor) {\n        if (commutativeOperators[self.operator]\n            && self.right.is_constant()\n            && !self.left.is_constant()\n            && !(self.left instanceof AST_Binary\n                && PRECEDENCE[self.left.operator] >= PRECEDENCE[self.operator])) {\n            // if right is a constant, whatever side effects the\n            // left side might have could not influence the\n            // result.  hence, force switch.\n            reverse();\n        }\n        if (compressor.option("sequences")) {\n            var seq = self.lift_sequences(compressor);\n            if (seq !== self) return seq.optimize(compressor);\n        }\n        if (compressor.option("assignments") && lazy_op[self.operator]) {\n            var lhs = extract_lhs(self.left, compressor);\n            var right = self.right;\n            // a || (a = x) ---\x3e a = a || x\n            // (a = x) && (a = y) ---\x3e a = (a = x) && y\n            if (lhs instanceof AST_SymbolRef\n                && right instanceof AST_Assign\n                && right.operator == "="\n                && lhs.equals(right.left)) {\n                lhs = lhs.clone();\n                var assign = make_node(AST_Assign, self, {\n                    operator: "=",\n                    left: lhs,\n                    right: make_node(AST_Binary, self, {\n                        operator: self.operator,\n                        left: self.left,\n                        right: right.right,\n                    }),\n                });\n                if (lhs.fixed) {\n                    lhs.fixed = function() {\n                        return assign.right;\n                    };\n                    lhs.fixed.assigns = [ assign ];\n                }\n                var def = lhs.definition();\n                def.references.push(lhs);\n                def.replaced++;\n                return assign.optimize(compressor);\n            }\n        }\n        if (compressor.option("comparisons")) switch (self.operator) {\n          case "===":\n          case "!==":\n            if (is_undefined(self.left, compressor) && self.right.is_defined(compressor)) {\n                AST_Node.warn("Expression always defined [{start}]", self);\n                return make_sequence(self, [\n                    self.right,\n                    make_node(self.operator == "===" ? AST_False : AST_True, self),\n                ]).optimize(compressor);\n            }\n            var is_strict_comparison = true;\n            if ((self.left.is_string(compressor) && self.right.is_string(compressor)) ||\n                (self.left.is_number(compressor) && self.right.is_number(compressor)) ||\n                (self.left.is_boolean(compressor) && self.right.is_boolean(compressor)) ||\n                repeatable(compressor, self.left) && self.left.equals(self.right)) {\n                self.operator = self.operator.slice(0, 2);\n            }\n            // XXX: intentionally falling down to the next case\n          case "==":\n          case "!=":\n            // void 0 == x ---\x3e null == x\n            if (!is_strict_comparison && is_undefined(self.left, compressor)) {\n                self.left = make_node(AST_Null, self.left);\n            }\n            // "undefined" == typeof x ---\x3e undefined === x\n            else if (compressor.option("typeofs")\n                && self.left instanceof AST_String\n                && self.left.value == "undefined"\n                && self.right instanceof AST_UnaryPrefix\n                && self.right.operator == "typeof") {\n                var expr = self.right.expression;\n                if (expr instanceof AST_SymbolRef ? expr.is_declared(compressor)\n                    : !(expr instanceof AST_PropAccess && compressor.option("ie"))) {\n                    self.right = expr;\n                    self.left = make_node(AST_Undefined, self.left).optimize(compressor);\n                    if (self.operator.length == 2) self.operator += "=";\n                }\n            }\n            // obj !== obj ---\x3e false\n            else if (self.left instanceof AST_SymbolRef\n                && self.right instanceof AST_SymbolRef\n                && self.left.definition() === self.right.definition()\n                && is_object(self.left)) {\n                return make_node(self.operator[0] == "=" ? AST_True : AST_False, self).optimize(compressor);\n            }\n            break;\n          case "&&":\n          case "||":\n            // void 0 !== x && null !== x ---\x3e null != x\n            // void 0 === x.a || null === x.a ---\x3e null == x.a\n            var left = self.left;\n            if (left.inlined_node) left = left.inlined_node;\n            if (!(left instanceof AST_Binary)) break;\n            if (left.operator != (self.operator == "&&" ? "!==" : "===")) break;\n            var right = self.right;\n            if (right.inlined_node) right = right.inlined_node;\n            if (!(right instanceof AST_Binary)) break;\n            if (left.operator != right.operator) break;\n            if (is_undefined(left.left, compressor) && right.left instanceof AST_Null\n                || left.left instanceof AST_Null && is_undefined(right.left, compressor)) {\n                var expr = extract_lhs(left.right, compressor);\n                if (!repeatable(compressor, expr)) break;\n                if (!expr.equals(right.right)) break;\n                left.operator = left.operator.slice(0, -1);\n                left.left = make_node(AST_Null, self);\n                return left;\n            }\n            break;\n        }\n        var in_bool = false;\n        var parent = compressor.parent();\n        if (compressor.option("booleans")) {\n            var lhs = extract_lhs(self.left, compressor);\n            if (lazy_op[self.operator] && repeatable(compressor, lhs)) {\n                // a || a ---\x3e a\n                // (a = x) && a --\x3e a = x\n                if (lhs.equals(self.right)) {\n                    return maintain_this_binding(parent, compressor.self(), self.left).optimize(compressor);\n                }\n                mark_duplicate_condition(compressor, lhs);\n            }\n            in_bool = compressor.in_boolean_context();\n        }\n        if (in_bool) switch (self.operator) {\n          case "+":\n            var ev = self.left.evaluate(compressor, true);\n            if (ev && typeof ev == "string" || (ev = self.right.evaluate(compressor, true)) && typeof ev == "string") {\n                AST_Node.warn("+ in boolean context always true [{start}]", self);\n                var exprs = [];\n                if (self.left.evaluate(compressor) instanceof AST_Node) exprs.push(self.left);\n                if (self.right.evaluate(compressor) instanceof AST_Node) exprs.push(self.right);\n                switch (exprs.length) {\n                  case 0:\n                    return make_node(AST_True, self).optimize(compressor);\n                  case 1:\n                    exprs[0] = exprs[0].clone();\n                    exprs.push(make_node(AST_True, self));\n                    return make_sequence(self, exprs).optimize(compressor);\n                }\n                self.truthy = true;\n            }\n            break;\n          case "==":\n            if (self.left instanceof AST_String && self.left.value == "" && self.right.is_string(compressor)) {\n                return make_node(AST_UnaryPrefix, self, {\n                    operator: "!",\n                    expression: self.right,\n                }).optimize(compressor);\n            }\n            break;\n          case "!=":\n            if (self.left instanceof AST_String && self.left.value == "" && self.right.is_string(compressor)) {\n                return self.right.optimize(compressor);\n            }\n            break;\n        }\n        if (compressor.option("comparisons") && self.is_boolean(compressor)) {\n            if (parent.TYPE != "Binary") {\n                var negated = make_node(AST_UnaryPrefix, self, {\n                    operator: "!",\n                    expression: self.negate(compressor),\n                });\n                if (best_of(compressor, self, negated) === negated) return negated;\n            }\n            switch (self.operator) {\n              case ">": reverse("<"); break;\n              case ">=": reverse("<="); break;\n            }\n        }\n        if (compressor.option("conditionals") && lazy_op[self.operator]) {\n            if (self.left instanceof AST_Binary && self.operator == self.left.operator) {\n                var before = make_node(AST_Binary, self, {\n                    operator: self.operator,\n                    left: self.left.right,\n                    right: self.right,\n                });\n                var after = before.transform(compressor);\n                if (before !== after) {\n                    self.left = self.left.left;\n                    self.right = after;\n                }\n            }\n            // x && (y && z) ---\x3e x && y && z\n            // w || (x, y || z) ---\x3e w || (x, y) || z\n            var rhs = self.right.tail_node();\n            if (rhs instanceof AST_Binary && self.operator == rhs.operator) self = swap_chain(self, compressor);\n        }\n        if (compressor.option("strings") && self.operator == "+") {\n            // "foo" + 42 + "" ---\x3e "foo" + 42\n            if (self.right instanceof AST_String\n                && self.right.value == ""\n                && self.left.is_string(compressor)) {\n                return self.left.optimize(compressor);\n            }\n            // "" + ("foo" + 42) ---\x3e "foo" + 42\n            if (self.left instanceof AST_String\n                && self.left.value == ""\n                && self.right.is_string(compressor)) {\n                return self.right.optimize(compressor);\n            }\n            // "" + 42 + "foo" ---\x3e 42 + "foo"\n            if (self.left instanceof AST_Binary\n                && self.left.operator == "+"\n                && self.left.left instanceof AST_String\n                && self.left.left.value == ""\n                && self.right.is_string(compressor)\n                && (self.left.right.is_constant() || !self.right.has_side_effects(compressor))) {\n                self.left = self.left.right;\n                return self.optimize(compressor);\n            }\n            // "x" + (y + "z") ---\x3e "x" + y + "z"\n            // w + (x, "y" + z) ---\x3e w + (x, "y") + z\n            var rhs = self.right.tail_node();\n            if (rhs instanceof AST_Binary\n                && self.operator == rhs.operator\n                && (self.left.is_string(compressor) && rhs.is_string(compressor)\n                    || rhs.left.is_string(compressor)\n                        && (self.left.is_constant() || !rhs.right.has_side_effects(compressor)))) {\n                self = swap_chain(self, compressor);\n            }\n        }\n        if (compressor.option("evaluate")) {\n            var associative = true;\n            switch (self.operator) {\n              case "&&":\n                var ll = fuzzy_eval(compressor, self.left);\n                if (!ll) {\n                    AST_Node.warn("Condition left of && always false [{start}]", self);\n                    return maintain_this_binding(parent, compressor.self(), self.left).optimize(compressor);\n                } else if (!(ll instanceof AST_Node)) {\n                    AST_Node.warn("Condition left of && always true [{start}]", self);\n                    return make_sequence(self, [ self.left, self.right ]).optimize(compressor);\n                }\n                if (!self.right.evaluate(compressor, true)) {\n                    if (in_bool && !(self.right.evaluate(compressor) instanceof AST_Node)) {\n                        AST_Node.warn("Boolean && always false [{start}]", self);\n                        return make_sequence(self, [ self.left, make_node(AST_False, self) ]).optimize(compressor);\n                    } else self.falsy = true;\n                } else if ((in_bool || parent.operator == "&&" && parent.left === compressor.self())\n                    && !(self.right.evaluate(compressor) instanceof AST_Node)) {\n                    AST_Node.warn("Dropping side-effect-free && [{start}]", self);\n                    return self.left.optimize(compressor);\n                }\n                // (x || false) && y ---\x3e x ? y : false\n                if (self.left.operator == "||") {\n                    var lr = fuzzy_eval(compressor, self.left.right);\n                    if (!lr) return make_node(AST_Conditional, self, {\n                        condition: self.left.left,\n                        consequent: self.right,\n                        alternative: self.left.right,\n                    }).optimize(compressor);\n                }\n                break;\n              case "??":\n                var nullish = true;\n              case "||":\n                var ll = fuzzy_eval(compressor, self.left, nullish);\n                if (nullish ? ll == null : !ll) {\n                    AST_Node.warn("Condition left of {operator} always {value} [{start}]", {\n                        operator: self.operator,\n                        value: nullish ? "nullish" : "false",\n                        start: self.start,\n                    });\n                    return make_sequence(self, [ self.left, self.right ]).optimize(compressor);\n                } else if (!(ll instanceof AST_Node)) {\n                    AST_Node.warn("Condition left of {operator} always {value} [{start}]", {\n                        operator: self.operator,\n                        value: nullish ? "defined" : "true",\n                        start: self.start,\n                    });\n                    return maintain_this_binding(parent, compressor.self(), self.left).optimize(compressor);\n                }\n                var rr;\n                if (!nullish && (rr = self.right.evaluate(compressor, true)) && !(rr instanceof AST_Node)) {\n                    if (in_bool && !(self.right.evaluate(compressor) instanceof AST_Node)) {\n                        AST_Node.warn("Boolean || always true [{start}]", self);\n                        return make_sequence(self, [ self.left, make_node(AST_True, self) ]).optimize(compressor);\n                    } else self.truthy = true;\n                } else if ((in_bool || parent.operator == "||" && parent.left === compressor.self())\n                    && !self.right.evaluate(compressor)) {\n                    AST_Node.warn("Dropping side-effect-free {operator} [{start}]", self);\n                    return self.left.optimize(compressor);\n                }\n                // x && true || y ---\x3e x ? true : y\n                if (!nullish && self.left.operator == "&&") {\n                    var lr = fuzzy_eval(compressor, self.left.right);\n                    if (lr && !(lr instanceof AST_Node)) return make_node(AST_Conditional, self, {\n                        condition: self.left.left,\n                        consequent: self.left.right,\n                        alternative: self.right,\n                    }).optimize(compressor);\n                }\n                break;\n              case "+":\n                // "foo" + ("bar" + x) ---\x3e "foobar" + x\n                if (self.left instanceof AST_Constant\n                    && self.right instanceof AST_Binary\n                    && self.right.operator == "+"\n                    && self.right.left instanceof AST_Constant\n                    && self.right.is_string(compressor)) {\n                    self = make_node(AST_Binary, self, {\n                        operator: "+",\n                        left: make_node(AST_String, self.left, {\n                            value: "" + self.left.value + self.right.left.value,\n                            start: self.left.start,\n                            end: self.right.left.end,\n                        }),\n                        right: self.right.right,\n                    });\n                }\n                // (x + "foo") + "bar" ---\x3e x + "foobar"\n                if (self.right instanceof AST_Constant\n                    && self.left instanceof AST_Binary\n                    && self.left.operator == "+"\n                    && self.left.right instanceof AST_Constant\n                    && self.left.is_string(compressor)) {\n                    self = make_node(AST_Binary, self, {\n                        operator: "+",\n                        left: self.left.left,\n                        right: make_node(AST_String, self.right, {\n                            value: "" + self.left.right.value + self.right.value,\n                            start: self.left.right.start,\n                            end: self.right.end,\n                        }),\n                    });\n                }\n                // a + -b ---\x3e a - b\n                if (self.right instanceof AST_UnaryPrefix\n                    && self.right.operator == "-"\n                    && self.left.is_number(compressor)) {\n                    self = make_node(AST_Binary, self, {\n                        operator: "-",\n                        left: self.left,\n                        right: self.right.expression,\n                    });\n                    break;\n                }\n                // -a + b ---\x3e b - a\n                if (self.left instanceof AST_UnaryPrefix\n                    && self.left.operator == "-"\n                    && reversible()\n                    && self.right.is_number(compressor)) {\n                    self = make_node(AST_Binary, self, {\n                        operator: "-",\n                        left: self.right,\n                        right: self.left.expression,\n                    });\n                    break;\n                }\n                // (a + b) + 3 ---\x3e 3 + (a + b)\n                if (compressor.option("unsafe_math")\n                    && self.left instanceof AST_Binary\n                    && PRECEDENCE[self.left.operator] == PRECEDENCE[self.operator]\n                    && self.right.is_constant()\n                    && (self.right.is_boolean(compressor) || self.right.is_number(compressor))\n                    && self.left.is_number(compressor)\n                    && !self.left.right.is_constant()\n                    && (self.left.left.is_boolean(compressor) || self.left.left.is_number(compressor))) {\n                    self = make_node(AST_Binary, self, {\n                        operator: self.left.operator,\n                        left: make_node(AST_Binary, self, {\n                            operator: self.operator,\n                            left: self.right,\n                            right: self.left.left,\n                        }),\n                        right: self.left.right,\n                    });\n                    break;\n                }\n              case "-":\n                // a - -b ---\x3e a + b\n                if (self.right instanceof AST_UnaryPrefix\n                    && self.right.operator == "-"\n                    && self.left.is_number(compressor)\n                    && self.right.expression.is_number(compressor)) {\n                    self = make_node(AST_Binary, self, {\n                        operator: "+",\n                        left: self.left,\n                        right: self.right.expression,\n                    });\n                    break;\n                }\n              case "*":\n              case "/":\n                associative = compressor.option("unsafe_math");\n                // +a - b ---\x3e a - b\n                // a - +b ---\x3e a - b\n                if (self.operator != "+") [ "left", "right" ].forEach(function(operand) {\n                    var node = self[operand];\n                    if (node instanceof AST_UnaryPrefix && node.operator == "+") {\n                        var exp = node.expression;\n                        if (exp.is_boolean(compressor) || exp.is_number(compressor) || exp.is_string(compressor)) {\n                            self[operand] = exp;\n                        }\n                    }\n                });\n              case "&":\n              case "|":\n              case "^":\n                // a + +b ---\x3e +b + a\n                if (self.operator != "-"\n                    && self.operator != "/"\n                    && (self.left.is_boolean(compressor) || self.left.is_number(compressor))\n                    && (self.right.is_boolean(compressor) || self.right.is_number(compressor))\n                    && reversible()\n                    && !(self.left instanceof AST_Binary\n                        && self.left.operator != self.operator\n                        && PRECEDENCE[self.left.operator] >= PRECEDENCE[self.operator])) {\n                    self = best_of(compressor, self, make_node(AST_Binary, self, {\n                        operator: self.operator,\n                        left: self.right,\n                        right: self.left,\n                    }), self.right instanceof AST_Constant && !(self.left instanceof AST_Constant));\n                }\n                if (!associative || !self.is_number(compressor)) break;\n                // a + (b + c) ---\x3e (a + b) + c\n                if (self.right instanceof AST_Binary\n                    && self.right.operator != "%"\n                    && PRECEDENCE[self.right.operator] == PRECEDENCE[self.operator]\n                    && self.right.is_number(compressor)\n                    && (self.operator != "+"\n                        || self.right.left.is_boolean(compressor)\n                        || self.right.left.is_number(compressor))\n                    && (self.operator != "-" || !self.left.is_negative_zero())\n                    && (self.right.left.is_constant_expression()\n                        || !self.right.right.has_side_effects(compressor))\n                    && !is_modify_array(self.right.right)) {\n                    self = make_node(AST_Binary, self, {\n                        operator: align(self.operator, self.right.operator),\n                        left: make_node(AST_Binary, self.left, {\n                            operator: self.operator,\n                            left: self.left,\n                            right: self.right.left,\n                            start: self.left.start,\n                            end: self.right.left.end,\n                        }),\n                        right: self.right.right,\n                    });\n                    if (self.operator == "+"\n                        && !self.right.is_boolean(compressor)\n                        && !self.right.is_number(compressor)) {\n                        self.right = make_node(AST_UnaryPrefix, self.right, {\n                            operator: "+",\n                            expression: self.right,\n                        });\n                    }\n                }\n                // (2 * n) * 3 ---\x3e 6 * n\n                // (n + 2) + 3 ---\x3e n + 5\n                if (self.right instanceof AST_Constant\n                    && self.left instanceof AST_Binary\n                    && self.left.operator != "%"\n                    && PRECEDENCE[self.left.operator] == PRECEDENCE[self.operator]\n                    && self.left.is_number(compressor)) {\n                    if (self.left.left instanceof AST_Constant) {\n                        var lhs = make_binary(self.operator, self.left.left, self.right, {\n                            start: self.left.left.start,\n                            end: self.right.end,\n                        });\n                        self = make_binary(self.left.operator, try_evaluate(compressor, lhs), self.left.right, self);\n                    } else if (self.left.right instanceof AST_Constant) {\n                        var op = align(self.left.operator, self.operator);\n                        var rhs = try_evaluate(compressor, make_binary(op, self.left.right, self.right, self.left));\n                        if (rhs.is_constant()\n                            && !(self.left.operator == "-"\n                                && self.right.value != 0\n                                && +rhs.value == 0\n                                && self.left.left.is_negative_zero())) {\n                            self = make_binary(self.left.operator, self.left.left, rhs, self);\n                        }\n                    }\n                }\n                break;\n              case "instanceof":\n                if (!can_drop_op(self, compressor)) break;\n                if (is_lambda(self.right)) return make_sequence(self, [\n                    self.left,\n                    self.right,\n                    make_node(AST_False, self),\n                ]).optimize(compressor);\n                break;\n            }\n            if (!(parent instanceof AST_UnaryPrefix && parent.operator == "delete")) {\n                if (self.left instanceof AST_Number && !self.right.is_constant()) switch (self.operator) {\n                  // 0 + n ---\x3e n\n                  case "+":\n                    if (self.left.value == 0) {\n                        if (self.right.is_boolean(compressor)) return make_node(AST_UnaryPrefix, self, {\n                            operator: "+",\n                            expression: self.right,\n                        }).optimize(compressor);\n                        if (self.right.is_number(compressor) && !self.right.is_negative_zero()) return self.right;\n                    }\n                    break;\n                  // 1 * n ---\x3e n\n                  case "*":\n                    if (self.left.value == 1) return make_node(AST_UnaryPrefix, self, {\n                        operator: "+",\n                        expression: self.right,\n                    }).optimize(compressor);\n                    break;\n                }\n                if (self.right instanceof AST_Number && !self.left.is_constant()) switch (self.operator) {\n                  // n + 0 ---\x3e n\n                  case "+":\n                    if (self.right.value == 0) {\n                        if (self.left.is_boolean(compressor)) return make_node(AST_UnaryPrefix, self, {\n                            operator: "+",\n                            expression: self.left,\n                        }).optimize(compressor);\n                        if (self.left.is_number(compressor) && !self.left.is_negative_zero()) return self.left;\n                    }\n                    break;\n                  // n - 0 ---\x3e n\n                  case "-":\n                    if (self.right.value == 0) return make_node(AST_UnaryPrefix, self, {\n                        operator: "+",\n                        expression: self.left,\n                    }).optimize(compressor);\n                    break;\n                  // n / 1 ---\x3e n\n                  case "/":\n                    if (self.right.value == 1) return make_node(AST_UnaryPrefix, self, {\n                        operator: "+",\n                        expression: self.left,\n                    }).optimize(compressor);\n                    break;\n                }\n            }\n        }\n        if (compressor.option("typeofs")) switch (self.operator) {\n          case "&&":\n            mark_locally_defined(self.left, self.right, null);\n            break;\n          case "||":\n            mark_locally_defined(self.left, null, self.right);\n            break;\n        }\n        if (compressor.option("unsafe")) {\n            var indexRight = is_indexFn(self.right);\n            if (in_bool\n                && indexRight\n                && (self.operator == "==" || self.operator == "!=")\n                && self.left instanceof AST_Number\n                && self.left.value == 0) {\n                return (self.operator == "==" ? make_node(AST_UnaryPrefix, self, {\n                    operator: "!",\n                    expression: self.right,\n                }) : self.right).optimize(compressor);\n            }\n            var indexLeft = is_indexFn(self.left);\n            if (compressor.option("comparisons") && is_indexOf_match_pattern()) {\n                var node = make_node(AST_UnaryPrefix, self, {\n                    operator: "!",\n                    expression: make_node(AST_UnaryPrefix, self, {\n                        operator: "~",\n                        expression: indexLeft ? self.left : self.right,\n                    }),\n                });\n                switch (self.operator) {\n                  case "<":\n                    if (indexLeft) break;\n                  case "<=":\n                  case "!=":\n                    node = make_node(AST_UnaryPrefix, self, {\n                        operator: "!",\n                        expression: node,\n                    });\n                    break;\n                }\n                return node.optimize(compressor);\n            }\n        }\n        return try_evaluate(compressor, self);\n\n        function is_modify_array(node) {\n            var found = false;\n            node.walk(new TreeWalker(function(node) {\n                if (found) return true;\n                if (node instanceof AST_Assign) {\n                    if (node.left instanceof AST_PropAccess) return found = true;\n                } else if (node instanceof AST_Unary) {\n                    if (unary_side_effects[node.operator] && node.expression instanceof AST_PropAccess) {\n                        return found = true;\n                    }\n                }\n            }));\n            return found;\n        }\n\n        function align(ref, op) {\n            switch (ref) {\n              case "-":\n                return op == "+" ? "-" : "+";\n              case "/":\n                return op == "*" ? "/" : "*";\n              default:\n                return op;\n            }\n        }\n\n        function make_binary(op, left, right, orig) {\n            if (op == "+") {\n                if (!left.is_boolean(compressor) && !left.is_number(compressor)) {\n                    left = make_node(AST_UnaryPrefix, left, {\n                        operator: "+",\n                        expression: left,\n                    });\n                }\n                if (!right.is_boolean(compressor) && !right.is_number(compressor)) {\n                    right = make_node(AST_UnaryPrefix, right, {\n                        operator: "+",\n                        expression: right,\n                    });\n                }\n            }\n            return make_node(AST_Binary, orig, {\n                operator: op,\n                left: left,\n                right: right,\n            });\n        }\n\n        function is_indexFn(node) {\n            while (node instanceof AST_Assign && node.operator == "=") node = node.right;\n            return node.TYPE == "Call"\n                && node.expression instanceof AST_Dot\n                && indexFns[node.expression.property];\n        }\n\n        function is_indexOf_match_pattern() {\n            switch (self.operator) {\n              case "<=":\n                // 0 <= array.indexOf(string) ---\x3e !!~array.indexOf(string)\n                return indexRight && self.left instanceof AST_Number && self.left.value == 0;\n              case "<":\n                // array.indexOf(string) < 0 ---\x3e !~array.indexOf(string)\n                if (indexLeft && self.right instanceof AST_Number && self.right.value == 0) return true;\n                // -1 < array.indexOf(string) ---\x3e !!~array.indexOf(string)\n              case "==":\n              case "!=":\n                // -1 == array.indexOf(string) ---\x3e !~array.indexOf(string)\n                // -1 != array.indexOf(string) ---\x3e !!~array.indexOf(string)\n                if (!indexRight) return false;\n                return self.left instanceof AST_Number && self.left.value == -1\n                    || self.left instanceof AST_UnaryPrefix && self.left.operator == "-"\n                        && self.left.expression instanceof AST_Number && self.left.expression.value == 1;\n            }\n        }\n\n        function reversible() {\n            return self.left.is_constant()\n                || self.right.is_constant()\n                || !self.left.has_side_effects(compressor)\n                    && !self.right.has_side_effects(compressor);\n        }\n\n        function reverse(op) {\n            if (reversible()) {\n                if (op) self.operator = op;\n                var tmp = self.left;\n                self.left = self.right;\n                self.right = tmp;\n            }\n        }\n    });\n\n    OPT(AST_SymbolExport, function(self) {\n        return self;\n    });\n\n    function recursive_ref(compressor, def, fn) {\n        var level = 0, node = compressor.self();\n        do {\n            if (node === fn) return node;\n            if (is_lambda(node) && node.name && node.name.definition() === def) return node;\n        } while (node = compressor.parent(level++));\n    }\n\n    function same_scope(def) {\n        var scope = def.scope.resolve();\n        return all(def.references, function(ref) {\n            return scope === ref.scope.resolve();\n        });\n    }\n\n    OPT(AST_SymbolRef, function(self, compressor) {\n        if (!compressor.option("ie")\n            && is_undeclared_ref(self)\n            // testing against `self.scope.uses_with` is an optimization\n            && !(self.scope.resolve().uses_with && compressor.find_parent(AST_With))) {\n            switch (self.name) {\n              case "undefined":\n                return make_node(AST_Undefined, self).optimize(compressor);\n              case "NaN":\n                return make_node(AST_NaN, self).optimize(compressor);\n              case "Infinity":\n                return make_node(AST_Infinity, self).optimize(compressor);\n            }\n        }\n        var parent = compressor.parent();\n        if (compressor.option("reduce_vars") && is_lhs(compressor.self(), parent) !== compressor.self()) {\n            var def = self.definition();\n            var fixed = self.fixed_value();\n            var single_use = def.single_use && !(parent instanceof AST_Call && parent.is_expr_pure(compressor));\n            if (single_use) {\n                if (is_lambda(fixed)) {\n                    if ((def.scope !== self.scope.resolve(true) || def.in_loop)\n                        && (!compressor.option("reduce_funcs") || def.escaped.depth == 1 || fixed.inlined)) {\n                        single_use = false;\n                    } else if (def.redefined()) {\n                        single_use = false;\n                    } else if (recursive_ref(compressor, def, fixed)) {\n                        single_use = false;\n                    } else if (fixed.name && fixed.name.definition() !== def) {\n                        single_use = false;\n                    } else if (fixed.parent_scope !== self.scope || is_funarg(def)) {\n                        if (!safe_from_strict_mode(fixed, compressor)) {\n                            single_use = false;\n                        } else if ((single_use = fixed.is_constant_expression(self.scope)) == "f") {\n                            var scope = self.scope;\n                            do {\n                                if (scope instanceof AST_LambdaDefinition || scope instanceof AST_LambdaExpression) {\n                                    scope.inlined = true;\n                                }\n                            } while (scope = scope.parent_scope);\n                        }\n                    } else if (fixed.name && (fixed.name.name == "await" && is_async(fixed)\n                        || fixed.name.name == "yield" && is_generator(fixed))) {\n                        single_use = false;\n                    } else if (fixed.has_side_effects(compressor)) {\n                        single_use = false;\n                    } else if (fixed instanceof AST_Class\n                        && (compressor.option("ie") || !fixed.is_constant_expression(self.scope))) {\n                        single_use = false;\n                    }\n                    if (single_use) fixed.parent_scope = self.scope;\n                } else if (!fixed\n                    || def.recursive_refs > 0\n                    || !fixed.is_constant_expression()\n                    || fixed.drop_side_effect_free(compressor)) {\n                    single_use = false;\n                }\n            }\n            if (single_use) {\n                def.single_use = false;\n                fixed._squeezed = true;\n                fixed.single_use = true;\n                if (fixed instanceof AST_DefClass) fixed = to_class_expr(fixed);\n                if (fixed instanceof AST_LambdaDefinition) fixed = to_func_expr(fixed);\n                if (is_lambda(fixed)) {\n                    var scopes = [];\n                    var scope = self.scope;\n                    do {\n                        scopes.push(scope);\n                        if (scope === def.scope) break;\n                    } while (scope = scope.parent_scope);\n                    fixed.enclosed.forEach(function(def) {\n                        if (fixed.variables.has(def.name)) return;\n                        for (var i = 0; i < scopes.length; i++) {\n                            var scope = scopes[i];\n                            if (!push_uniq(scope.enclosed, def)) return;\n                            scope.var_names().set(def.name, true);\n                        }\n                    });\n                }\n                var value;\n                if (def.recursive_refs > 0) {\n                    value = fixed.clone(true);\n                    var defun_def = value.name.definition();\n                    var lambda_def = value.variables.get(value.name.name);\n                    var name = lambda_def && lambda_def.orig[0];\n                    var def_fn_name, symbol_type;\n                    if (value instanceof AST_Class) {\n                        def_fn_name = "def_function";\n                        symbol_type = AST_SymbolClass;\n                    } else {\n                        def_fn_name = "def_variable";\n                        symbol_type = AST_SymbolLambda;\n                    }\n                    if (!(name instanceof symbol_type)) {\n                        name = make_node(symbol_type, value.name);\n                        name.scope = value;\n                        value.name = name;\n                        lambda_def = value[def_fn_name](name);\n                        lambda_def.recursive_refs = def.recursive_refs;\n                    }\n                    value.walk(new TreeWalker(function(node) {\n                        if (node instanceof AST_SymbolDeclaration) {\n                            if (node !== name) {\n                                var def = node.definition();\n                                def.orig.push(node);\n                                def.eliminated++;\n                            }\n                            return;\n                        }\n                        if (!(node instanceof AST_SymbolRef)) return;\n                        var def = node.definition();\n                        if (def === defun_def) {\n                            node.thedef = def = lambda_def;\n                        } else {\n                            def.single_use = false;\n                            var fn = node.fixed_value();\n                            if (is_lambda(fn)\n                                && fn.name\n                                && fn.name.definition() === def\n                                && def.scope === fn.name.scope\n                                && fixed.variables.get(fn.name.name) === def) {\n                                fn.name = fn.name.clone();\n                                node.thedef = def = value.variables.get(fn.name.name) || value[def_fn_name](fn.name);\n                            }\n                        }\n                        def.references.push(node);\n                    }));\n                } else {\n                    if (fixed instanceof AST_Scope) {\n                        compressor.push(fixed);\n                        value = fixed.optimize(compressor);\n                        compressor.pop();\n                    } else {\n                        value = fixed.optimize(compressor);\n                    }\n                    value = value.transform(new TreeTransformer(function(node, descend) {\n                        if (node instanceof AST_Scope) return node;\n                        node = node.clone();\n                        descend(node, this);\n                        return node;\n                    }));\n                }\n                def.replaced++;\n                return value;\n            }\n            var state;\n            if (fixed && (state = self.fixed || def.fixed).should_replace !== false) {\n                var ev, init;\n                if (fixed instanceof AST_This) {\n                    if (!is_funarg(def) && same_scope(def) && !cross_class(def)) init = fixed;\n                } else if ((ev = fixed.evaluate(compressor, true)) !== fixed\n                    && typeof ev != "function"\n                    && (ev === null\n                        || typeof ev != "object"\n                        || compressor.option("unsafe_regexp")\n                            && ev instanceof RegExp && !def.cross_loop && same_scope(def))) {\n                    init = make_node_from_constant(ev, fixed);\n                }\n                if (init) {\n                    if (state.should_replace === undefined) {\n                        var value_length = init.optimize(compressor).print_to_string().length;\n                        if (!has_symbol_ref(fixed)) {\n                            value_length = Math.min(value_length, fixed.print_to_string().length);\n                        }\n                        var name_length = def.name.length;\n                        if (compressor.option("unused") && !compressor.exposed(def)) {\n                            var refs = def.references.length - def.replaced - def.assignments;\n                            refs = Math.min(refs, def.references.filter(function(ref) {\n                                return ref.fixed === state;\n                            }).length);\n                            name_length += (name_length + 2 + value_length) / Math.max(1, refs);\n                        }\n                        state.should_replace = value_length - Math.floor(name_length) < compressor.eval_threshold;\n                    }\n                    if (state.should_replace) {\n                        var value;\n                        if (has_symbol_ref(fixed)) {\n                            value = init.optimize(compressor);\n                            if (value === init) value = value.clone(true);\n                        } else {\n                            value = best_of_expression(init.optimize(compressor), fixed);\n                            if (value === init || value === fixed) value = value.clone(true);\n                        }\n                        def.replaced++;\n                        return value;\n                    }\n                }\n            }\n        }\n        return self;\n\n        function cross_class(def) {\n            var scope = self.scope;\n            while (scope !== def.scope) {\n                if (scope instanceof AST_Class) return true;\n                scope = scope.parent_scope;\n            }\n        }\n\n        function has_symbol_ref(value) {\n            var found;\n            value.walk(new TreeWalker(function(node) {\n                if (node instanceof AST_SymbolRef) found = true;\n                if (found) return true;\n            }));\n            return found;\n        }\n    });\n\n    function is_raw_tag(compressor, tag) {\n        return compressor.option("unsafe")\n            && tag instanceof AST_Dot\n            && tag.property == "raw"\n            && is_undeclared_ref(tag.expression)\n            && tag.expression.name == "String";\n    }\n\n    function decode_template(str) {\n        var malformed = false;\n        str = str.replace(/\\\\(u\\{[^{}]*\\}?|u[\\s\\S]{0,4}|x[\\s\\S]{0,2}|[0-9]+|[\\s\\S])/g, function(match, seq) {\n            var ch = decode_escape_sequence(seq);\n            if (typeof ch == "string") return ch;\n            malformed = true;\n        });\n        if (!malformed) return str;\n    }\n\n    OPT(AST_Template, function(self, compressor) {\n        if (!compressor.option("templates")) return self;\n        var tag = self.tag;\n        if (!tag || is_raw_tag(compressor, tag)) {\n            var exprs = [];\n            var strs = [];\n            for (var i = 0, status; i < self.strings.length; i++) {\n                var str = self.strings[i];\n                if (!tag) {\n                    var trimmed = decode_template(str);\n                    if (trimmed) str = escape_literal(trimmed);\n                }\n                if (i > 0) {\n                    var node = self.expressions[i - 1];\n                    var value = should_join(node);\n                    if (value) {\n                        var prev = strs[strs.length - 1];\n                        var joined = prev + value + str;\n                        var decoded;\n                        if (tag || typeof (decoded = decode_template(joined)) == status) {\n                            strs[strs.length - 1] = decoded ? escape_literal(decoded) : joined;\n                            continue;\n                        }\n                    }\n                    exprs.push(node);\n                }\n                strs.push(str);\n                if (!tag) status = typeof trimmed;\n            }\n            if (!tag && strs.length > 1) {\n                if (strs[strs.length - 1] == "") return make_node(AST_Binary, self, {\n                    operator: "+",\n                    left: make_node(AST_Template, self, {\n                        expressions: exprs.slice(0, -1),\n                        strings: strs.slice(0, -1),\n                    }).transform(compressor),\n                    right: exprs[exprs.length - 1],\n                }).optimize(compressor);\n                if (strs[0] == "") {\n                    var left = make_node(AST_Binary, self, {\n                        operator: "+",\n                        left: make_node(AST_String, self, { value: "" }),\n                        right: exprs[0],\n                    });\n                    for (var i = 1; strs[i] == "" && i < exprs.length; i++) {\n                        left = make_node(AST_Binary, self, {\n                            operator: "+",\n                            left: left,\n                            right: exprs[i],\n                        });\n                    }\n                    return best_of(compressor, self, make_node(AST_Binary, self, {\n                        operator: "+",\n                        left: left.transform(compressor),\n                        right: make_node(AST_Template, self, {\n                            expressions: exprs.slice(i),\n                            strings: strs.slice(i),\n                        }).transform(compressor),\n                    }).optimize(compressor));\n                }\n            }\n            self.expressions = exprs;\n            self.strings = strs;\n        }\n        return try_evaluate(compressor, self);\n\n        function escape_literal(str) {\n            return str.replace(/\\r|\\\\|`|\\${/g, function(s) {\n                return "\\\\" + (s == "\\r" ? "r" : s);\n            });\n        }\n\n        function should_join(node) {\n            var ev = node.evaluate(compressor);\n            if (ev === node) return;\n            if (tag && /\\r|\\\\|`/.test(ev)) return;\n            ev = escape_literal("" + ev);\n            if (ev.length > node.print_to_string().length + "${}".length) return;\n            return ev;\n        }\n    });\n\n    function is_atomic(lhs, self) {\n        return lhs instanceof AST_SymbolRef || lhs.TYPE === self.TYPE;\n    }\n\n    OPT(AST_Undefined, function(self, compressor) {\n        if (compressor.option("unsafe_undefined")) {\n            var undef = find_scope(compressor).find_variable("undefined");\n            if (undef) {\n                var ref = make_node(AST_SymbolRef, self, {\n                    name: "undefined",\n                    scope: undef.scope,\n                    thedef: undef,\n                });\n                ref.is_undefined = true;\n                return ref;\n            }\n        }\n        var lhs = is_lhs(compressor.self(), compressor.parent());\n        if (lhs && is_atomic(lhs, self)) return self;\n        return make_node(AST_UnaryPrefix, self, {\n            operator: "void",\n            expression: make_node(AST_Number, self, { value: 0 }),\n        });\n    });\n\n    OPT(AST_Infinity, function(self, compressor) {\n        var lhs = is_lhs(compressor.self(), compressor.parent());\n        if (lhs && is_atomic(lhs, self)) return self;\n        if (compressor.option("keep_infinity") && !lhs && !find_scope(compressor).find_variable("Infinity")) {\n            return self;\n        }\n        return make_node(AST_Binary, self, {\n            operator: "/",\n            left: make_node(AST_Number, self, { value: 1 }),\n            right: make_node(AST_Number, self, { value: 0 }),\n        });\n    });\n\n    OPT(AST_NaN, function(self, compressor) {\n        var lhs = is_lhs(compressor.self(), compressor.parent());\n        if (lhs && is_atomic(lhs, self)) return self;\n        if (!lhs && !find_scope(compressor).find_variable("NaN")) return self;\n        return make_node(AST_Binary, self, {\n            operator: "/",\n            left: make_node(AST_Number, self, { value: 0 }),\n            right: make_node(AST_Number, self, { value: 0 }),\n        });\n    });\n\n    function is_reachable(self, defs) {\n        var reachable = false;\n        var find_ref = new TreeWalker(function(node) {\n            if (reachable) return true;\n            if (node instanceof AST_SymbolRef && member(node.definition(), defs)) return reachable = true;\n        });\n        var scan_scope = new TreeWalker(function(node) {\n            if (reachable) return true;\n            if (node instanceof AST_Lambda && node !== self) {\n                if (!(node.name || is_async(node) || is_generator(node))) {\n                    var parent = scan_scope.parent();\n                    if (parent instanceof AST_Call && parent.expression === node) return;\n                }\n                node.walk(find_ref);\n                return true;\n            }\n        });\n        self.walk(scan_scope);\n        return reachable;\n    }\n\n    var ASSIGN_OPS = makePredicate("+ - * / % >> << >>> | ^ &");\n    var ASSIGN_OPS_COMMUTATIVE = makePredicate("* | ^ &");\n    OPT(AST_Assign, function(self, compressor) {\n        if (compressor.option("dead_code")) {\n            if (self.left instanceof AST_PropAccess) {\n                if (self.operator == "=") {\n                    var exp = self.left.expression;\n                    if (self.left.equals(self.right)) {\n                        var defined = exp.defined;\n                        exp.defined = false;\n                        var drop_lhs = !self.left.has_side_effects(compressor);\n                        exp.defined = defined;\n                        if (drop_lhs) return self.right;\n                    }\n                    if (exp instanceof AST_Lambda\n                        || !compressor.has_directive("use strict")\n                            && exp instanceof AST_Constant\n                            && !exp.may_throw_on_access(compressor)) {\n                        var value = self.left instanceof AST_Dot ? self.right : make_sequence(self, [\n                            self.left.property,\n                            self.right,\n                        ]);\n                        return maintain_this_binding(compressor.parent(), self, value).optimize(compressor);\n                    }\n                }\n            } else if (self.left instanceof AST_SymbolRef && can_drop_symbol(self.left, compressor)) {\n                var parent;\n                if (self.operator == "=" && self.left.equals(self.right)\n                    && !((parent = compressor.parent()) instanceof AST_UnaryPrefix && parent.operator == "delete")) {\n                    return self.right;\n                }\n                if (self.left.is_immutable()) return strip_assignment();\n                var def = self.left.definition();\n                var scope = def.scope.resolve();\n                var local = scope === compressor.find_parent(AST_Lambda);\n                var level = 0, node;\n                parent = compressor.self();\n                if (!(scope.uses_arguments && is_funarg(def)) || compressor.has_directive("use strict")) do {\n                    node = parent;\n                    parent = compressor.parent(level++);\n                    if (parent instanceof AST_Assign) {\n                        if (parent.left instanceof AST_SymbolRef && parent.left.definition() === def) {\n                            if (in_try(level, parent, !local)) break;\n                            return strip_assignment(def);\n                        }\n                        if (parent.left.match_symbol(function(node) {\n                            if (node instanceof AST_PropAccess) return true;\n                        })) break;\n                        continue;\n                    }\n                    if (parent instanceof AST_Exit) {\n                        if (!local) break;\n                        if (in_try(level, parent)) break;\n                        if (is_reachable(scope, [ def ])) break;\n                        return strip_assignment(def);\n                    }\n                    if (parent instanceof AST_SimpleStatement) {\n                        if (!local) break;\n                        if (is_reachable(scope, [ def ])) break;\n                        var stat;\n                        do {\n                            stat = parent;\n                            parent = compressor.parent(level++);\n                            if (parent === scope && is_last_statement(parent.body, stat)) return strip_assignment(def);\n                        } while (is_tail_block(stat, parent));\n                        break;\n                    }\n                    if (parent instanceof AST_VarDef) {\n                        if (!(parent.name instanceof AST_SymbolDeclaration)) continue;\n                        if (parent.name.definition() !== def) continue;\n                        if (in_try(level, parent)) break;\n                        return strip_assignment(def);\n                    }\n                } while (is_tail(node, parent));\n            }\n        }\n        if (compressor.option("sequences")) {\n            var seq = self.lift_sequences(compressor);\n            if (seq !== self) return seq.optimize(compressor);\n        }\n        if (compressor.option("assignments")) {\n            if (self.operator == "=" && self.left instanceof AST_SymbolRef && self.right instanceof AST_Binary) {\n                // x = expr1 OP expr2\n                if (self.right.left instanceof AST_SymbolRef\n                    && self.right.left.name == self.left.name\n                    && ASSIGN_OPS[self.right.operator]) {\n                    // x = x - 2 ---\x3e x -= 2\n                    return make_compound(self.right.right);\n                }\n                if (self.right.right instanceof AST_SymbolRef\n                    && self.right.right.name == self.left.name\n                    && ASSIGN_OPS_COMMUTATIVE[self.right.operator]\n                    && !self.right.left.has_side_effects(compressor)) {\n                    // x = 2 & x ---\x3e x &= 2\n                    return make_compound(self.right.left);\n                }\n            }\n            if ((self.operator == "-=" || self.operator == "+="\n                    && (self.left.is_boolean(compressor) || self.left.is_number(compressor)))\n                && self.right instanceof AST_Number\n                && self.right.value == 1) {\n                var op = self.operator.slice(0, -1);\n                return make_node(AST_UnaryPrefix, self, {\n                    operator: op + op,\n                    expression: self.left,\n                });\n            }\n        }\n        return try_evaluate(compressor, self);\n\n        function is_tail(node, parent) {\n            if (parent instanceof AST_Binary) switch (node) {\n              case parent.left:\n                return parent.right.is_constant_expression(scope);\n              case parent.right:\n                return true;\n              default:\n                return false;\n            }\n            if (parent instanceof AST_Conditional) switch (node) {\n              case parent.condition:\n                return parent.consequent.is_constant_expression(scope)\n                    && parent.alternative.is_constant_expression(scope);\n              case parent.consequent:\n              case parent.alternative:\n                return true;\n              default:\n                return false;\n            }\n            if (parent instanceof AST_Sequence) {\n                var exprs = parent.expressions;\n                var stop = exprs.indexOf(node);\n                if (stop < 0) return false;\n                for (var i = exprs.length; --i > stop;) {\n                    if (!exprs[i].is_constant_expression(scope)) return false;\n                }\n                return true;\n            }\n            return parent instanceof AST_UnaryPrefix;\n        }\n\n        function is_tail_block(stat, parent) {\n            if (parent instanceof AST_BlockStatement) return is_last_statement(parent.body, stat);\n            if (parent instanceof AST_Catch) return is_last_statement(parent.body, stat);\n            if (parent instanceof AST_Finally) return is_last_statement(parent.body, stat);\n            if (parent instanceof AST_If) return parent.body === stat || parent.alternative === stat;\n            if (parent instanceof AST_Try) return parent.bfinally ? parent.bfinally === stat : parent.bcatch === stat;\n        }\n\n        function in_try(level, node, sync) {\n            var right = self.right;\n            self.right = make_node(AST_Null, right);\n            var may_throw = node.may_throw(compressor);\n            self.right = right;\n            return find_try(compressor, level, node, scope, may_throw, sync);\n        }\n\n        function make_compound(rhs) {\n            var fixed = self.left.fixed;\n            if (fixed) fixed.to_binary = replace_ref(function(node) {\n                return node.left;\n            }, fixed);\n            return make_node(AST_Assign, self, {\n                operator: self.right.operator + "=",\n                left: self.left,\n                right: rhs,\n            });\n        }\n\n        function strip_assignment(def) {\n            if (def) def.fixed = false;\n            return (self.operator != "=" ? make_node(AST_Binary, self, {\n                operator: self.operator.slice(0, -1),\n                left: self.left,\n                right: self.right,\n            }) : maintain_this_binding(compressor.parent(), self, self.right)).optimize(compressor);\n        }\n    });\n\n    OPT(AST_Conditional, function(self, compressor) {\n        if (compressor.option("sequences") && self.condition instanceof AST_Sequence) {\n            var expressions = self.condition.expressions.slice();\n            var node = self.clone();\n            node.condition = expressions.pop();\n            expressions.push(node);\n            return make_sequence(self, expressions).optimize(compressor);\n        }\n        if (!compressor.option("conditionals")) return self;\n        var condition = self.condition;\n        if (compressor.option("booleans") && !condition.has_side_effects(compressor)) {\n            mark_duplicate_condition(compressor, condition);\n        }\n        condition = fuzzy_eval(compressor, condition);\n        if (!condition) {\n            AST_Node.warn("Condition always false [{start}]", self);\n            return make_sequence(self, [ self.condition, self.alternative ]).optimize(compressor);\n        } else if (!(condition instanceof AST_Node)) {\n            AST_Node.warn("Condition always true [{start}]", self);\n            return make_sequence(self, [ self.condition, self.consequent ]).optimize(compressor);\n        }\n        var first = first_in_statement(compressor);\n        var negated = condition.negate(compressor, first);\n        if ((first ? best_of_statement : best_of_expression)(condition, negated) === negated) {\n            self = make_node(AST_Conditional, self, {\n                condition: negated,\n                consequent: self.alternative,\n                alternative: self.consequent,\n            });\n            negated = condition;\n            condition = self.condition;\n        }\n        var consequent = self.consequent;\n        var alternative = self.alternative;\n        var cond_lhs = extract_lhs(condition, compressor);\n        if (repeatable(compressor, cond_lhs)) {\n            // x ? x : y ---\x3e x || y\n            if (cond_lhs.equals(consequent)) return make_node(AST_Binary, self, {\n                operator: "||",\n                left: condition,\n                right: alternative,\n            }).optimize(compressor);\n            // x ? y : x ---\x3e x && y\n            if (cond_lhs.equals(alternative)) return make_node(AST_Binary, self, {\n                operator: "&&",\n                left: condition,\n                right: consequent,\n            }).optimize(compressor);\n        }\n        // if (foo) exp = something; else exp = something_else;\n        //                   |\n        //                   v\n        // exp = foo ? something : something_else;\n        var seq_tail = consequent.tail_node();\n        if (seq_tail instanceof AST_Assign) {\n            var is_eq = seq_tail.operator == "=";\n            var alt_tail = is_eq ? alternative.tail_node() : alternative;\n            if ((is_eq || consequent === seq_tail)\n                && alt_tail instanceof AST_Assign\n                && seq_tail.operator == alt_tail.operator\n                && seq_tail.left.equals(alt_tail.left)\n                && (is_eq && seq_tail.left instanceof AST_SymbolRef\n                    || !condition.has_side_effects(compressor)\n                        && can_shift_lhs_of_tail(consequent)\n                        && can_shift_lhs_of_tail(alternative))) {\n                return make_node(AST_Assign, self, {\n                    operator: seq_tail.operator,\n                    left: seq_tail.left,\n                    right: make_node(AST_Conditional, self, {\n                        condition: condition,\n                        consequent: pop_lhs(consequent),\n                        alternative: pop_lhs(alternative),\n                    }),\n                });\n            }\n        }\n        var alt_tail = alternative.tail_node();\n        // x ? y : y ---\x3e x, y\n        // x ? (a, c) : (b, c) ---\x3e x ? a : b, c\n        if (seq_tail.equals(alt_tail)) return make_sequence(self, consequent.equals(alternative) ? [\n            condition,\n            consequent,\n        ] : [\n            make_node(AST_Conditional, self, {\n                condition: condition,\n                consequent: pop_seq(consequent),\n                alternative: pop_seq(alternative),\n            }),\n            alt_tail,\n        ]).optimize(compressor);\n        // x ? y.p : z.p ---\x3e (x ? y : z).p\n        // x ? y(a) : z(a) ---\x3e (x ? y : z)(a)\n        // x ? y.f(a) : z.f(a) ---\x3e (x ? y : z).f(a)\n        var combined = combine_tail(consequent, alternative, true);\n        if (combined) return combined;\n        // x ? y(a) : y(b) ---\x3e y(x ? a : b)\n        var arg_index;\n        if (consequent instanceof AST_Call\n            && alternative.TYPE == consequent.TYPE\n            && (arg_index = arg_diff(consequent, alternative)) >= 0\n            && consequent.expression.equals(alternative.expression)\n            && !condition.has_side_effects(compressor)\n            && !consequent.expression.has_side_effects(compressor)) {\n            var node = consequent.clone();\n            var arg = consequent.args[arg_index];\n            node.args[arg_index] = arg instanceof AST_Spread ? make_node(AST_Spread, self, {\n                expression: make_node(AST_Conditional, self, {\n                    condition: condition,\n                    consequent: arg.expression,\n                    alternative: alternative.args[arg_index].expression,\n                }),\n            }) : make_node(AST_Conditional, self, {\n                condition: condition,\n                consequent: arg,\n                alternative: alternative.args[arg_index],\n            });\n            return node;\n        }\n        // x ? (y ? a : b) : b ---\x3e x && y ? a : b\n        if (seq_tail instanceof AST_Conditional\n            && seq_tail.alternative.equals(alternative)) {\n            return make_node(AST_Conditional, self, {\n                condition: make_node(AST_Binary, self, {\n                    left: condition,\n                    operator: "&&",\n                    right: fuse(consequent, seq_tail, "condition"),\n                }),\n                consequent: seq_tail.consequent,\n                alternative: merge_expression(seq_tail.alternative, alternative),\n            });\n        }\n        // x ? (y ? a : b) : a ---\x3e !x || y ? a : b\n        if (seq_tail instanceof AST_Conditional\n            && seq_tail.consequent.equals(alternative)) {\n            return make_node(AST_Conditional, self, {\n                condition: make_node(AST_Binary, self, {\n                    left: negated,\n                    operator: "||",\n                    right: fuse(consequent, seq_tail, "condition"),\n                }),\n                consequent: merge_expression(seq_tail.consequent, alternative),\n                alternative: seq_tail.alternative,\n            });\n        }\n        // x ? a : (y ? a : b) ---\x3e x || y ? a : b\n        if (alt_tail instanceof AST_Conditional\n            && consequent.equals(alt_tail.consequent)) {\n            return make_node(AST_Conditional, self, {\n                condition: make_node(AST_Binary, self, {\n                    left: condition,\n                    operator: "||",\n                    right: fuse(alternative, alt_tail, "condition"),\n                }),\n                consequent: merge_expression(consequent, alt_tail.consequent),\n                alternative: alt_tail.alternative,\n            });\n        }\n        // x ? b : (y ? a : b) ---\x3e !x && y ? a : b\n        if (alt_tail instanceof AST_Conditional\n            && consequent.equals(alt_tail.alternative)) {\n            return make_node(AST_Conditional, self, {\n                condition: make_node(AST_Binary, self, {\n                    left: negated,\n                    operator: "&&",\n                    right: fuse(alternative, alt_tail, "condition"),\n                }),\n                consequent: alt_tail.consequent,\n                alternative: merge_expression(consequent, alt_tail.alternative),\n            });\n        }\n        // x ? y && a : a ---\x3e (!x || y) && a\n        if (seq_tail instanceof AST_Binary\n            && seq_tail.operator == "&&"\n            && seq_tail.right.equals(alternative)) {\n            return make_node(AST_Binary, self, {\n                operator: "&&",\n                left: make_node(AST_Binary, self, {\n                    operator: "||",\n                    left: negated,\n                    right: fuse(consequent, seq_tail, "left"),\n                }),\n                right: merge_expression(seq_tail.right, alternative),\n            }).optimize(compressor);\n        }\n        // x ? y || a : a ---\x3e x && y || a\n        if (seq_tail instanceof AST_Binary\n            && seq_tail.operator == "||"\n            && seq_tail.right.equals(alternative)) {\n            return make_node(AST_Binary, self, {\n                operator: "||",\n                left: make_node(AST_Binary, self, {\n                    operator: "&&",\n                    left: condition,\n                    right: fuse(consequent, seq_tail, "left"),\n                }),\n                right: merge_expression(seq_tail.right, alternative),\n            }).optimize(compressor);\n        }\n        // x ? a : y && a ---\x3e (x || y) && a\n        if (alt_tail instanceof AST_Binary\n            && alt_tail.operator == "&&"\n            && alt_tail.right.equals(consequent)) {\n            return make_node(AST_Binary, self, {\n                operator: "&&",\n                left: make_node(AST_Binary, self, {\n                    operator: "||",\n                    left: condition,\n                    right: fuse(alternative, alt_tail, "left"),\n                }),\n                right: merge_expression(consequent, alt_tail.right),\n            }).optimize(compressor);\n        }\n        // x ? a : y || a ---\x3e !x && y || a\n        if (alt_tail instanceof AST_Binary\n            && alt_tail.operator == "||"\n            && alt_tail.right.equals(consequent)) {\n            return make_node(AST_Binary, self, {\n                operator: "||",\n                left: make_node(AST_Binary, self, {\n                    operator: "&&",\n                    left: negated,\n                    right: fuse(alternative, alt_tail, "left"),\n                }),\n                right: merge_expression(consequent, alt_tail.right),\n            }).optimize(compressor);\n        }\n        var in_bool = compressor.option("booleans") && compressor.in_boolean_context();\n        if (is_true(consequent)) {\n            // c ? true : false ---\x3e !!c\n            if (is_false(alternative)) return booleanize(condition);\n            // c ? true : x ---\x3e !!c || x\n            return make_node(AST_Binary, self, {\n                operator: "||",\n                left: booleanize(condition),\n                right: alternative,\n            }).optimize(compressor);\n        }\n        if (is_false(consequent)) {\n            // c ? false : true ---\x3e !c\n            if (is_true(alternative)) return booleanize(condition.negate(compressor));\n            // c ? false : x ---\x3e !c && x\n            return make_node(AST_Binary, self, {\n                operator: "&&",\n                left: booleanize(condition.negate(compressor)),\n                right: alternative,\n            }).optimize(compressor);\n        }\n        // c ? x : true ---\x3e !c || x\n        if (is_true(alternative)) return make_node(AST_Binary, self, {\n            operator: "||",\n            left: booleanize(condition.negate(compressor)),\n            right: consequent,\n        }).optimize(compressor);\n        // c ? x : false ---\x3e !!c && x\n        if (is_false(alternative)) return make_node(AST_Binary, self, {\n            operator: "&&",\n            left: booleanize(condition),\n            right: consequent,\n        }).optimize(compressor);\n        if (compressor.option("typeofs")) mark_locally_defined(condition, consequent, alternative);\n        return self;\n\n        function booleanize(node) {\n            if (node.is_boolean(compressor)) return node;\n            // !!expression\n            return make_node(AST_UnaryPrefix, node, {\n                operator: "!",\n                expression: node.negate(compressor),\n            });\n        }\n\n        // AST_True or !0\n        function is_true(node) {\n            return node instanceof AST_True\n                || in_bool\n                    && node instanceof AST_Constant\n                    && node.value\n                || (node instanceof AST_UnaryPrefix\n                    && node.operator == "!"\n                    && node.expression instanceof AST_Constant\n                    && !node.expression.value);\n        }\n        // AST_False or !1 or void 0\n        function is_false(node) {\n            return node instanceof AST_False\n                || in_bool\n                    && (node instanceof AST_Constant\n                            && !node.value\n                        || node instanceof AST_UnaryPrefix\n                            && node.operator == "void"\n                            && !node.expression.has_side_effects(compressor))\n                || (node instanceof AST_UnaryPrefix\n                    && node.operator == "!"\n                    && node.expression instanceof AST_Constant\n                    && node.expression.value);\n        }\n\n        function arg_diff(consequent, alternative) {\n            var a = consequent.args;\n            var b = alternative.args;\n            var len = a.length;\n            if (len != b.length) return -2;\n            for (var i = 0; i < len; i++) {\n                if (!a[i].equals(b[i])) {\n                    if (a[i] instanceof AST_Spread !== b[i] instanceof AST_Spread) return -3;\n                    for (var j = i + 1; j < len; j++) {\n                        if (!a[j].equals(b[j])) return -2;\n                    }\n                    return i;\n                }\n            }\n            return -1;\n        }\n\n        function fuse(node, tail, prop) {\n            if (node === tail) return tail[prop];\n            var exprs = node.expressions.slice(0, -1);\n            exprs.push(tail[prop]);\n            return make_sequence(node, exprs);\n        }\n\n        function is_tail_equivalent(consequent, alternative) {\n            if (consequent.TYPE != alternative.TYPE) return;\n            if (consequent.optional != alternative.optional) return;\n            if (consequent instanceof AST_Call) {\n                if (arg_diff(consequent, alternative) != -1) return;\n                return consequent.TYPE != "Call"\n                    || !(consequent.expression instanceof AST_PropAccess\n                        || alternative.expression instanceof AST_PropAccess)\n                    || is_tail_equivalent(consequent.expression, alternative.expression);\n            }\n            if (!(consequent instanceof AST_PropAccess)) return;\n            var p = consequent.property;\n            var q = alternative.property;\n            return (p instanceof AST_Node ? p.equals(q) : p == q)\n                && !(consequent.expression instanceof AST_Super || alternative.expression instanceof AST_Super);\n        }\n\n        function combine_tail(consequent, alternative, top) {\n            var seq_tail = consequent.tail_node();\n            var alt_tail = alternative.tail_node();\n            if (!is_tail_equivalent(seq_tail, alt_tail)) return !top && make_node(AST_Conditional, self, {\n                condition: condition,\n                consequent: consequent,\n                alternative: alternative,\n            });\n            var node = seq_tail.clone();\n            var seq_expr = fuse(consequent, seq_tail, "expression");\n            var alt_expr = fuse(alternative, alt_tail, "expression");\n            var combined = combine_tail(seq_expr, alt_expr);\n            if (seq_tail.expression instanceof AST_Sequence) {\n                combined = maintain_this_binding(seq_tail, seq_tail.expression, combined);\n            }\n            node.expression = combined;\n            return node;\n        }\n\n        function can_shift_lhs_of_tail(node) {\n            return node === node.tail_node() || all(node.expressions.slice(0, -1), function(expr) {\n                return !expr.has_side_effects(compressor);\n            });\n        }\n\n        function pop_lhs(node) {\n            if (!(node instanceof AST_Sequence)) return node.right;\n            var exprs = node.expressions.slice();\n            exprs.push(exprs.pop().right);\n            return make_sequence(node, exprs);\n        }\n\n        function pop_seq(node) {\n            if (!(node instanceof AST_Sequence)) return make_node(AST_Number, node, { value: 0 });\n            return make_sequence(node, node.expressions.slice(0, -1));\n        }\n    });\n\n    OPT(AST_Boolean, function(self, compressor) {\n        if (!compressor.option("booleans")) return self;\n        if (compressor.in_boolean_context()) return make_node(AST_Number, self, { value: +self.value });\n        var p = compressor.parent();\n        if (p instanceof AST_Binary && (p.operator == "==" || p.operator == "!=")) {\n            AST_Node.warn("Non-strict equality against boolean: {operator} {value} [{start}]", {\n                operator: p.operator,\n                value: self.value,\n                start: p.start,\n            });\n            return make_node(AST_Number, self, { value: +self.value });\n        }\n        return make_node(AST_UnaryPrefix, self, {\n            operator: "!",\n            expression: make_node(AST_Number, self, { value: 1 - self.value }),\n        });\n    });\n\n    OPT(AST_Spread, function(self, compressor) {\n        var exp = self.expression;\n        if (compressor.option("spreads") && exp instanceof AST_Array && !(compressor.parent() instanceof AST_Object)) {\n            return List.splice(exp.elements.map(function(node) {\n                return node instanceof AST_Hole ? make_node(AST_Undefined, node).optimize(compressor) : node;\n            }));\n        }\n        return self;\n    });\n\n    function safe_to_flatten(value, compressor) {\n        if (!value) return false;\n        var parent = compressor.parent();\n        if (parent.TYPE != "Call") return true;\n        if (parent.expression !== compressor.self()) return true;\n        if (value instanceof AST_SymbolRef) {\n            value = value.fixed_value();\n            if (!value) return false;\n        }\n        return value instanceof AST_Lambda && !value.contains_this();\n    }\n\n    OPT(AST_Sub, function(self, compressor) {\n        var expr = self.expression;\n        var prop = self.property;\n        var terminated = trim_optional_chain(self, compressor);\n        if (terminated) return terminated;\n        if (compressor.option("properties")) {\n            var key = prop.evaluate(compressor);\n            if (key !== prop) {\n                if (typeof key == "string") {\n                    if (key == "undefined") {\n                        key = undefined;\n                    } else {\n                        var value = parseFloat(key);\n                        if (value.toString() == key) {\n                            key = value;\n                        }\n                    }\n                }\n                prop = self.property = best_of_expression(prop, make_node_from_constant(key, prop).transform(compressor));\n                var property = "" + key;\n                if (is_identifier_string(property)\n                    && property.length <= prop.print_to_string().length + 1) {\n                    return make_node(AST_Dot, self, {\n                        optional: self.optional,\n                        expression: expr,\n                        property: property,\n                        quoted: true,\n                    }).optimize(compressor);\n                }\n            }\n        }\n        var parent = compressor.parent();\n        var assigned = is_lhs(compressor.self(), parent);\n        var def, fn, fn_parent, index;\n        if (compressor.option("arguments")\n            && expr instanceof AST_SymbolRef\n            && is_arguments(def = expr.definition())\n            && !expr.in_arg\n            && prop instanceof AST_Number\n            && Math.floor(index = prop.value) == index\n            && (fn = def.scope) === find_lambda()\n            && fn.uses_arguments < (assigned ? 2 : 3)) {\n            if (parent instanceof AST_UnaryPrefix && parent.operator == "delete") {\n                if (!def.deleted) def.deleted = [];\n                def.deleted[index] = true;\n            }\n            var argname = fn.argnames[index];\n            if (def.deleted && def.deleted[index]) {\n                argname = null;\n            } else if (argname) {\n                var arg_def;\n                if (!(argname instanceof AST_SymbolFunarg)\n                    || argname.name == "await"\n                    || expr.scope.find_variable(argname.name) !== (arg_def = argname.definition())) {\n                    argname = null;\n                } else if (compressor.has_directive("use strict")\n                    || fn.name\n                    || fn.rest\n                    || !(fn_parent instanceof AST_Call\n                        && index < fn_parent.args.length\n                        && all(fn_parent.args.slice(0, index + 1), function(arg) {\n                            return !(arg instanceof AST_Spread);\n                        }))\n                    || !all(fn.argnames, function(argname) {\n                        return argname instanceof AST_SymbolFunarg;\n                    })) {\n                    if (has_reassigned() || arg_def.assignments || arg_def.orig.length > 1) argname = null;\n                }\n            } else if ((assigned || !has_reassigned())\n                && index < fn.argnames.length + 5\n                && compressor.drop_fargs(fn, fn_parent)\n                && !fn.rest) {\n                while (index >= fn.argnames.length) {\n                    argname = fn.make_var(AST_SymbolFunarg, fn, "argument_" + fn.argnames.length);\n                    fn.argnames.push(argname);\n                }\n            }\n            if (argname && find_if(function(node) {\n                return node.name === argname.name;\n            }, fn.argnames) === argname) {\n                if (assigned) def.reassigned--;\n                var sym = make_node(AST_SymbolRef, argname);\n                sym.reference();\n                argname.unused = undefined;\n                return sym;\n            }\n        }\n        if (assigned) return self;\n        if (compressor.option("sequences")\n            && parent.TYPE != "Call"\n            && !(parent instanceof AST_ForEnumeration && parent.init === self)) {\n            var seq = lift_sequence_in_expression(self, compressor);\n            if (seq !== self) return seq.optimize(compressor);\n        }\n        if (key !== prop) {\n            var sub = self.flatten_object(property, compressor);\n            if (sub) {\n                expr = self.expression = sub.expression;\n                prop = self.property = sub.property;\n            }\n        }\n        var elements;\n        if (compressor.option("properties")\n            && compressor.option("side_effects")\n            && prop instanceof AST_Number\n            && expr instanceof AST_Array\n            && all(elements = expr.elements, function(value) {\n                return !(value instanceof AST_Spread);\n            })) {\n            var index = prop.value;\n            var retValue = elements[index];\n            if (safe_to_flatten(retValue, compressor)) {\n                var is_hole = retValue instanceof AST_Hole;\n                var flatten = !is_hole;\n                var values = [];\n                for (var i = elements.length; --i > index;) {\n                    var value = elements[i].drop_side_effect_free(compressor);\n                    if (value) {\n                        values.unshift(value);\n                        if (flatten && value.has_side_effects(compressor)) flatten = false;\n                    }\n                }\n                if (!flatten) values.unshift(retValue);\n                while (--i >= 0) {\n                    var value = elements[i].drop_side_effect_free(compressor);\n                    if (value) {\n                        values.unshift(value);\n                    } else if (is_hole) {\n                        values.unshift(make_node(AST_Hole, elements[i]));\n                    } else {\n                        index--;\n                    }\n                }\n                if (flatten) {\n                    values.push(retValue);\n                    return make_sequence(self, values).optimize(compressor);\n                }\n                return make_node(AST_Sub, self, {\n                    expression: make_node(AST_Array, expr, { elements: values }),\n                    property: make_node(AST_Number, prop, { value: index }),\n                });\n            }\n        }\n        return try_evaluate(compressor, self);\n\n        function find_lambda() {\n            var i = 0, p;\n            while (p = compressor.parent(i++)) {\n                if (p instanceof AST_Lambda) {\n                    if (p instanceof AST_Accessor) return;\n                    if (is_arrow(p)) continue;\n                    fn_parent = compressor.parent(i);\n                    return p;\n                }\n            }\n        }\n\n        function has_reassigned() {\n            return !compressor.option("reduce_vars") || def.reassigned;\n        }\n    });\n\n    AST_LambdaExpression.DEFMETHOD("contains_super", function() {\n        var result = false;\n        var self = this;\n        self.walk(new TreeWalker(function(node) {\n            if (result) return true;\n            if (node instanceof AST_Super) return result = true;\n            if (node !== self && node instanceof AST_Scope && !is_arrow(node)) return true;\n        }));\n        return result;\n    });\n\n    // contains_this()\n    // returns false only if context bound by the specified scope (or scope\n    // containing the specified expression) is not referenced by `this`\n    (function(def) {\n        // scope of arrow function cannot bind to any context\n        def(AST_Arrow, return_false);\n        def(AST_AsyncArrow, return_false);\n        def(AST_Node, function() {\n            var result = false;\n            var self = this;\n            self.walk(new TreeWalker(function(node) {\n                if (result) return true;\n                if (node instanceof AST_This) return result = true;\n                if (node !== self && node instanceof AST_Scope && !is_arrow(node)) return true;\n            }));\n            return result;\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("contains_this", func);\n    });\n\n    function can_hoist_property(prop) {\n        return prop instanceof AST_ObjectKeyVal\n            && typeof prop.key == "string"\n            && !(prop instanceof AST_ObjectMethod && prop.value.contains_super());\n    }\n\n    AST_PropAccess.DEFMETHOD("flatten_object", function(key, compressor) {\n        if (!compressor.option("properties")) return;\n        if (key === "__proto__") return;\n        var self = this;\n        var expr = self.expression;\n        if (!(expr instanceof AST_Object)) return;\n        var props = expr.properties;\n        for (var i = props.length; --i >= 0;) {\n            var prop = props[i];\n            if (prop.key !== key) continue;\n            if (!all(props, can_hoist_property)) return;\n            if (!safe_to_flatten(prop.value, compressor)) return;\n            var call, scope, values = [];\n            for (var j = 0; j < props.length; j++) {\n                var value = props[j].value;\n                if (props[j] instanceof AST_ObjectMethod) {\n                    var arrow = !(value.uses_arguments || is_generator(value) || value.contains_this());\n                    if (arrow) {\n                        if (!scope) scope = compressor.find_parent(AST_Scope);\n                        var avoid = avoid_await_yield(compressor, scope);\n                        value.each_argname(function(argname) {\n                            if (avoid[argname.name]) arrow = false;\n                        });\n                    }\n                    var ctor;\n                    if (arrow) {\n                        ctor = is_async(value) ? AST_AsyncArrow : AST_Arrow;\n                    } else if (i != j\n                        || (call = compressor.parent()) instanceof AST_Call && call.expression === self) {\n                        ctor = value.CTOR;\n                    } else {\n                        return;\n                    }\n                    value = make_node(ctor, value);\n                }\n                values.push(value);\n            }\n            return make_node(AST_Sub, self, {\n                expression: make_node(AST_Array, expr, { elements: values }),\n                property: make_node(AST_Number, self, { value: i }),\n            });\n        }\n    });\n\n    OPT(AST_Dot, function(self, compressor) {\n        if (self.property == "arguments" || self.property == "caller") {\n            AST_Node.warn("Function.prototype.{property} not supported [{start}]", self);\n        }\n        var parent = compressor.parent();\n        if (is_lhs(compressor.self(), parent)) return self;\n        var terminated = trim_optional_chain(self, compressor);\n        if (terminated) return terminated;\n        if (compressor.option("sequences")\n            && parent.TYPE != "Call"\n            && !(parent instanceof AST_ForEnumeration && parent.init === self)) {\n            var seq = lift_sequence_in_expression(self, compressor);\n            if (seq !== self) return seq.optimize(compressor);\n        }\n        if (compressor.option("unsafe_proto")\n            && self.expression instanceof AST_Dot\n            && self.expression.property == "prototype") {\n            var exp = self.expression.expression;\n            if (is_undeclared_ref(exp)) switch (exp.name) {\n              case "Array":\n                self.expression = make_node(AST_Array, self.expression, { elements: [] });\n                break;\n              case "Function":\n                self.expression = make_node(AST_Function, self.expression, {\n                    argnames: [],\n                    body: [],\n                }).init_vars(exp.scope);\n                break;\n              case "Number":\n                self.expression = make_node(AST_Number, self.expression, { value: 0 });\n                break;\n              case "Object":\n                self.expression = make_node(AST_Object, self.expression, { properties: [] });\n                break;\n              case "RegExp":\n                self.expression = make_node(AST_RegExp, self.expression, { value: /t/ });\n                break;\n              case "String":\n                self.expression = make_node(AST_String, self.expression, { value: "" });\n                break;\n            }\n        }\n        var sub = self.flatten_object(self.property, compressor);\n        if (sub) return sub.optimize(compressor);\n        return try_evaluate(compressor, self);\n    });\n\n    OPT(AST_DestructuredArray, function(self, compressor) {\n        if (compressor.option("rests") && self.rest instanceof AST_DestructuredArray) {\n            return make_node(AST_DestructuredArray, self, {\n                elements: self.elements.concat(self.rest.elements),\n                rest: self.rest.rest,\n            });\n        }\n        return self;\n    });\n\n    OPT(AST_DestructuredKeyVal, function(self, compressor) {\n        if (compressor.option("objects")) {\n            var key = self.key;\n            if (key instanceof AST_Node) {\n                key = key.evaluate(compressor);\n                if (key !== self.key) self.key = "" + key;\n            }\n        }\n        return self;\n    });\n\n    OPT(AST_Object, function(self, compressor) {\n        if (!compressor.option("objects")) return self;\n        var changed = false;\n        var found = false;\n        var generated = false;\n        var keep_duplicate = compressor.has_directive("use strict");\n        var keys = [];\n        var map = new Dictionary();\n        var values = [];\n        self.properties.forEach(function(prop) {\n            if (!(prop instanceof AST_Spread)) return process(prop);\n            found = true;\n            var exp = prop.expression;\n            if (compressor.option("spreads") && exp instanceof AST_Object && all(exp.properties, function(prop) {\n                if (prop instanceof AST_ObjectGetter) return false;\n                if (prop instanceof AST_Spread) return false;\n                if (prop.key !== "__proto__") return true;\n                if (prop instanceof AST_ObjectSetter) return true;\n                return !prop.value.has_side_effects(compressor);\n            })) {\n                changed = true;\n                exp.properties.forEach(function(prop) {\n                    var key = prop.key;\n                    var setter = prop instanceof AST_ObjectSetter;\n                    if (key === "__proto__") {\n                        if (!setter) return;\n                        key = make_node_from_constant(key, prop);\n                    }\n                    process(setter ? make_node(AST_ObjectKeyVal, prop, {\n                        key: key,\n                        value: make_node(AST_Undefined, prop).optimize(compressor),\n                    }) : prop);\n                });\n            } else {\n                generated = true;\n                flush();\n                values.push(prop);\n            }\n        });\n        flush();\n        if (!changed) return self;\n        if (found && generated && values.length == 1) {\n            var value = values[0];\n            if (value instanceof AST_ObjectProperty && value.key instanceof AST_Number) {\n                value.key = "" + value.key.value;\n            }\n        }\n        return make_node(AST_Object, self, { properties: values });\n\n        function flush() {\n            keys.forEach(function(key) {\n                var props = map.get(key);\n                switch (props.length) {\n                  case 0:\n                    return;\n                  case 1:\n                    return values.push(props[0]);\n                }\n                changed = true;\n                var tail = keep_duplicate && !generated && props.pop();\n                values.push(props.length == 1 ? props[0] : make_node(AST_ObjectKeyVal, self, {\n                    key: props[0].key,\n                    value: make_sequence(self, props.map(function(prop) {\n                        return prop.value;\n                    })),\n                }));\n                if (tail) values.push(tail);\n                props.length = 0;\n            });\n            keys = [];\n            map = new Dictionary();\n        }\n\n        function process(prop) {\n            var key = prop.key;\n            if (key instanceof AST_Node) {\n                found = true;\n                key = key.evaluate(compressor);\n                if (key === prop.key || key === "__proto__") {\n                    generated = true;\n                } else {\n                    key = prop.key = "" + key;\n                }\n            }\n            if (can_hoist_property(prop)) {\n                if (prop.value.has_side_effects(compressor)) flush();\n                keys.push(key);\n                map.add(key, prop);\n            } else {\n                flush();\n                values.push(prop);\n            }\n            if (found && !generated && typeof key == "string" && RE_POSITIVE_INTEGER.test(key)) {\n                generated = true;\n                if (map.has(key)) prop = map.get(key)[0];\n                prop.key = make_node(AST_Number, prop, { value: +key });\n            }\n        }\n    });\n\n    function flatten_var(name) {\n        var redef = name.definition().redefined();\n        if (redef) {\n            name = name.clone();\n            name.thedef = redef;\n        }\n        return name;\n    }\n\n    function has_arg_refs(fn, node) {\n        var found = false;\n        node.walk(new TreeWalker(function(node) {\n            if (found) return true;\n            if (node instanceof AST_SymbolRef && fn.variables.get(node.name) === node.definition()) {\n                return found = true;\n            }\n        }));\n        return found;\n    }\n\n    function insert_assign(def, assign) {\n        var visited = [];\n        def.references.forEach(function(ref) {\n            var fixed = ref.fixed;\n            if (!fixed || !push_uniq(visited, fixed)) return;\n            if (fixed.assigns) {\n                fixed.assigns.unshift(assign);\n            } else {\n                fixed.assigns = [ assign ];\n            }\n        });\n    }\n\n    function init_ref(compressor, name) {\n        var sym = make_node(AST_SymbolRef, name);\n        var assign = make_node(AST_Assign, name, {\n            operator: "=",\n            left: sym,\n            right: make_node(AST_Undefined, name).transform(compressor),\n        });\n        var def = name.definition();\n        if (def.fixed) {\n            sym.fixed = function() {\n                return assign.right;\n            };\n            sym.fixed.assigns = [ assign ];\n            insert_assign(def, assign);\n        }\n        def.assignments++;\n        def.references.push(sym);\n        return assign;\n    }\n\n    (function(def) {\n        def(AST_Node, noop);\n        def(AST_Assign, noop);\n        def(AST_Await, function(compressor, scope, no_return, in_loop) {\n            if (!compressor.option("awaits")) return;\n            var self = this;\n            var inlined = self.expression.try_inline(compressor, scope, no_return, in_loop, true);\n            if (!inlined) return;\n            if (!no_return) scan_local_returns(inlined, function(node) {\n                node.in_bool = false;\n                var value = node.value;\n                if (value instanceof AST_Await) return;\n                node.value = make_node(AST_Await, self, {\n                    expression: value || make_node(AST_Undefined, node).transform(compressor),\n                });\n            });\n            return aborts(inlined) ? inlined : make_node(AST_BlockStatement, self, {\n                body: [ inlined, make_node(AST_SimpleStatement, self, {\n                    body: make_node(AST_Await, self, { expression: make_node(AST_Number, self, { value: 0 })}),\n                }) ],\n            });\n        });\n        def(AST_Binary, function(compressor, scope, no_return, in_loop, in_await) {\n            if (no_return === undefined) return;\n            var self = this;\n            var op = self.operator;\n            if (!lazy_op[op]) return;\n            var inlined = self.right.try_inline(compressor, scope, no_return, in_loop, in_await);\n            if (!inlined) return;\n            return make_node(AST_If, self, {\n                condition: make_condition(self.left),\n                body: inlined,\n                alternative: no_return ? null : make_node(AST_Return, self, {\n                    value: make_node(AST_Undefined, self).transform(compressor),\n                }),\n            });\n\n            function make_condition(cond) {\n                switch (op) {\n                  case "&&":\n                    return cond;\n                  case "||":\n                    return cond.negate(compressor);\n                  case "??":\n                    return make_node(AST_Binary, self, {\n                        operator: "==",\n                        left: make_node(AST_Null, self),\n                        right: cond,\n                    });\n                }\n            }\n        });\n        def(AST_BlockStatement, function(compressor, scope, no_return, in_loop) {\n            if (no_return) return;\n            if (!this.variables) return;\n            var body = this.body;\n            var last = body.length - 1;\n            if (last < 0) return;\n            var inlined = body[last].try_inline(compressor, this, no_return, in_loop);\n            if (!inlined) return;\n            body[last] = inlined;\n            return this;\n        });\n        def(AST_Call, function(compressor, scope, no_return, in_loop, in_await) {\n            if (compressor.option("inline") < 4) return;\n            var call = this;\n            if (call.is_expr_pure(compressor)) return;\n            var fn = call.expression;\n            if (!(fn instanceof AST_LambdaExpression)) return;\n            if (fn.name) return;\n            if (fn.single_use) return;\n            if (fn.uses_arguments) return;\n            if (fn.pinned()) return;\n            if (is_generator(fn)) return;\n            var arrow = is_arrow(fn);\n            var fn_body = arrow && fn.value ? [ fn.first_statement() ] : fn.body;\n            if (fn_body[0] instanceof AST_Directive) return;\n            if (fn.contains_this()) return;\n            if (!scope) scope = find_scope(compressor);\n            var defined = new Dictionary();\n            defined.set("NaN", true);\n            while (!(scope instanceof AST_Scope)) {\n                scope.variables.each(function(def) {\n                    defined.set(def.name, true);\n                });\n                scope = scope.parent_scope;\n            }\n            if (!member(scope, compressor.stack)) return;\n            if (scope.pinned() && fn.variables.size() > (arrow ? 0 : 1)) return;\n            if (scope instanceof AST_Toplevel) {\n                if (fn.variables.size() > (arrow ? 0 : 1)) {\n                    if (!compressor.toplevel.vars) return;\n                    if (fn.functions.size() > 0 && !compressor.toplevel.funcs) return;\n                }\n                defined.set("arguments", true);\n            }\n            var async = !in_await && is_async(fn);\n            if (async) {\n                if (!compressor.option("awaits")) return;\n                if (!is_async(scope)) return;\n                if (call.may_throw(compressor)) return;\n            }\n            var names = scope.var_names();\n            if (in_loop) in_loop = [];\n            if (!fn.variables.all(function(def, name) {\n                if (in_loop) in_loop.push(def);\n                if (!defined.has(name) && !names.has(name)) return true;\n                return !arrow && name == "arguments" && def.orig.length == 1;\n            })) return;\n            if (in_loop && in_loop.length > 0 && is_reachable(fn, in_loop)) return;\n            var simple_argnames = true;\n            if (!all(fn.argnames, function(argname) {\n                var abort = false;\n                var tw = new TreeWalker(function(node) {\n                    if (abort) return true;\n                    if (node instanceof AST_DefaultValue) {\n                        if (has_arg_refs(fn, node.value)) return abort = true;\n                        node.name.walk(tw);\n                        return true;\n                    }\n                    if (node instanceof AST_DestructuredKeyVal) {\n                        if (node.key instanceof AST_Node && has_arg_refs(fn, node.key)) return abort = true;\n                        node.value.walk(tw);\n                        return true;\n                    }\n                    if (node instanceof AST_SymbolFunarg && !all(node.definition().orig, function(sym) {\n                        return !(sym instanceof AST_SymbolDefun);\n                    })) return abort = true;\n                });\n                argname.walk(tw);\n                if (abort) return false;\n                if (!(argname instanceof AST_SymbolFunarg)) simple_argnames = false;\n                return true;\n            })) return;\n            if (fn.rest) {\n                if (has_arg_refs(fn, fn.rest)) return;\n                simple_argnames = false;\n            }\n            var verify_body;\n            if (no_return) {\n                verify_body = function(stat) {\n                    var abort = false;\n                    stat.walk(new TreeWalker(function(node) {\n                        if (abort) return true;\n                        if (async && (node instanceof AST_Await || node instanceof AST_ForAwaitOf)\n                            || node instanceof AST_Return) {\n                            return abort = true;\n                        }\n                        if (node instanceof AST_Scope) return true;\n                    }));\n                    return !abort;\n                };\n            } else if (in_await || is_async(fn) || in_async_generator(scope)) {\n                verify_body = function(stat) {\n                    var abort = false;\n                    var find_return = new TreeWalker(function(node) {\n                        if (abort) return true;\n                        if (node instanceof AST_Return) return abort = true;\n                        if (node instanceof AST_Scope) return true;\n                    });\n                    stat.walk(new TreeWalker(function(node) {\n                        if (abort) return true;\n                        if (node instanceof AST_Try) {\n                            if (!node.bfinally) return;\n                            if (all(node.body, function(stat) {\n                                stat.walk(find_return);\n                                return !abort;\n                            }) && node.bcatch) node.bcatch.walk(find_return);\n                            return true;\n                        }\n                        if (node instanceof AST_Scope) return true;\n                    }));\n                    return !abort;\n                };\n            }\n            if (verify_body && !all(fn_body, verify_body)) return;\n            if (!safe_from_await_yield(fn, avoid_await_yield(compressor, scope))) return;\n            fn.functions.each(function(def, name) {\n                scope.functions.set(name, def);\n            });\n            var body = [];\n            fn.variables.each(function(def, name) {\n                if (!arrow && name == "arguments" && def.orig.length == 1) return;\n                names.set(name, true);\n                scope.enclosed.push(def);\n                scope.variables.set(name, def);\n                def.single_use = false;\n                if (!in_loop) return;\n                if (def.references.length == def.replaced) return;\n                switch (def.orig.length - def.eliminated) {\n                  case 0:\n                    return;\n                  case 1:\n                    if (fn.functions.has(name)) return;\n                }\n                if (!all(def.orig, function(sym) {\n                    if (sym instanceof AST_SymbolConst) return false;\n                    if (sym instanceof AST_SymbolFunarg) return !sym.unused && def.scope.resolve() !== fn;\n                    if (sym instanceof AST_SymbolLet) return false;\n                    return true;\n                })) return;\n                var sym = def.orig[0];\n                if (sym instanceof AST_SymbolCatch) return;\n                body.push(make_node(AST_SimpleStatement, sym, { body: init_ref(compressor, flatten_var(sym)) }));\n                def.first_decl = null;\n            });\n            var defs = Object.create(null), syms = new Dictionary();\n            if (simple_argnames && all(call.args, function(arg) {\n                return !(arg instanceof AST_Spread);\n            })) {\n                var values = call.args.slice();\n                fn.argnames.forEach(function(argname) {\n                    var value = values.shift();\n                    if (argname.unused) {\n                        if (value) body.push(make_node(AST_SimpleStatement, call, { body: value }));\n                        return;\n                    }\n                    var defn = make_node(AST_VarDef, call, {\n                        name: argname.convert_symbol(AST_SymbolVar, process),\n                        value: value || make_node(AST_Undefined, call).transform(compressor),\n                    });\n                    if (argname instanceof AST_SymbolFunarg) insert_assign(argname.definition(), defn);\n                    body.push(make_node(AST_Var, call, { definitions: [ defn ] }));\n                });\n                if (values.length) body.push(make_node(AST_SimpleStatement, call, {\n                    body: make_sequence(call, values),\n                }));\n            } else {\n                body.push(make_node(AST_Var, call, {\n                    definitions: [ make_node(AST_VarDef, call, {\n                        name: make_node(AST_DestructuredArray, call, {\n                            elements: fn.argnames.map(function(argname) {\n                                if (argname.unused) return make_node(AST_Hole, argname);\n                                return argname.convert_symbol(AST_SymbolVar, process);\n                            }),\n                            rest: fn.rest && fn.rest.convert_symbol(AST_SymbolVar, process),\n                        }),\n                        value: make_node(AST_Array, call, { elements: call.args.slice() }),\n                    }) ],\n                }));\n            }\n            syms.each(function(orig, id) {\n                var def = defs[id];\n                [].unshift.apply(def.orig, orig);\n                def.eliminated += orig.length;\n            });\n            [].push.apply(body, in_loop ? fn_body.filter(function(stat) {\n                if (!(stat instanceof AST_LambdaDefinition)) return true;\n                var name = make_node(AST_SymbolVar, flatten_var(stat.name));\n                var def = name.definition();\n                def.fixed = false;\n                def.orig.push(name);\n                def.eliminated++;\n                body.push(make_node(AST_Var, stat, {\n                    definitions: [ make_node(AST_VarDef, stat, {\n                        name: name,\n                        value: to_func_expr(stat, true),\n                    }) ],\n                }));\n                return false;\n            }) : fn_body);\n            var inlined = make_node(AST_BlockStatement, call, { body: body });\n            if (!no_return) {\n                if (async) scan_local_returns(inlined, function(node) {\n                    var value = node.value;\n                    if (is_undefined(value)) return;\n                    node.value = make_node(AST_Await, call, { expression: value });\n                });\n                body.push(make_node(AST_Return, call, {\n                    value: in_async_generator(scope) ? make_node(AST_Undefined, call).transform(compressor) : null,\n                }));\n            }\n            return inlined;\n\n            function process(sym, argname) {\n                var def = argname.definition();\n                defs[def.id] = def;\n                syms.add(def.id, sym);\n            }\n        });\n        def(AST_Conditional, function(compressor, scope, no_return, in_loop, in_await) {\n            var self = this;\n            var body = self.consequent.try_inline(compressor, scope, no_return, in_loop, in_await);\n            var alt = self.alternative.try_inline(compressor, scope, no_return, in_loop, in_await);\n            if (!body && !alt) return;\n            return make_node(AST_If, self, {\n                condition: self.condition,\n                body: body || make_body(self.consequent),\n                alternative: alt || make_body(self.alternative),\n            });\n\n            function make_body(value) {\n                if (no_return) return make_node(AST_SimpleStatement, value, { body: value });\n                return make_node(AST_Return, value, { value: value });\n            }\n        });\n        def(AST_For, function(compressor, scope, no_return, in_loop) {\n            var body = this.body.try_inline(compressor, scope, true, true);\n            if (body) this.body = body;\n            var inlined = this.init;\n            if (inlined) {\n                inlined = inlined.try_inline(compressor, scope, true, in_loop);\n                if (inlined) {\n                    this.init = null;\n                    if (inlined instanceof AST_BlockStatement) {\n                        inlined.body.push(this);\n                        return inlined;\n                    }\n                    return make_node(AST_BlockStatement, inlined, { body: [ inlined, this ] });\n                }\n            }\n            return body && this;\n        });\n        def(AST_ForEnumeration, function(compressor, scope, no_return, in_loop) {\n            var body = this.body.try_inline(compressor, scope, true, true);\n            if (body) this.body = body;\n            var obj = this.object;\n            if (obj instanceof AST_Sequence) {\n                var inlined = inline_sequence(compressor, scope, true, in_loop, false, obj, 1);\n                if (inlined) {\n                    this.object = obj.tail_node();\n                    inlined.body.push(this);\n                    return inlined;\n                }\n            }\n            return body && this;\n        });\n        def(AST_If, function(compressor, scope, no_return, in_loop) {\n            var body = this.body.try_inline(compressor, scope, no_return, in_loop);\n            if (body) this.body = body;\n            var alt = this.alternative;\n            if (alt) {\n                alt = alt.try_inline(compressor, scope, no_return, in_loop);\n                if (alt) this.alternative = alt;\n            }\n            var cond = this.condition;\n            if (cond instanceof AST_Sequence) {\n                var inlined = inline_sequence(compressor, scope, true, in_loop, false, cond, 1);\n                if (inlined) {\n                    this.condition = cond.tail_node();\n                    inlined.body.push(this);\n                    return inlined;\n                }\n            }\n            return (body || alt) && this;\n        });\n        def(AST_IterationStatement, function(compressor, scope, no_return, in_loop) {\n            var body = this.body.try_inline(compressor, scope, true, true);\n            if (!body) return;\n            this.body = body;\n            return this;\n        });\n        def(AST_LabeledStatement, function(compressor, scope, no_return, in_loop) {\n            var body = this.body.try_inline(compressor, scope, no_return, in_loop);\n            if (!body) return;\n            if (this.body instanceof AST_IterationStatement && body instanceof AST_BlockStatement) {\n                var loop = body.body.pop();\n                this.body = loop;\n                body.body.push(this);\n                return body;\n            }\n            this.body = body;\n            return this;\n        });\n        def(AST_New, noop);\n        def(AST_Return, function(compressor, scope, no_return, in_loop) {\n            var value = this.value;\n            return value && value.try_inline(compressor, scope, undefined, in_loop === "try");\n        });\n        function inline_sequence(compressor, scope, no_return, in_loop, in_await, node, skip) {\n            var body = [], exprs = node.expressions, no_ret = no_return;\n            for (var i = exprs.length - (skip || 0), j = i; --i >= 0; no_ret = true, in_await = false) {\n                var inlined = exprs[i].try_inline(compressor, scope, no_ret, in_loop, in_await);\n                if (!inlined) continue;\n                flush();\n                body.push(inlined);\n            }\n            if (body.length == 0) return;\n            flush();\n            if (!no_return && body[0] instanceof AST_SimpleStatement) {\n                body[0] = make_node(AST_Return, node, { value: body[0].body });\n            }\n            return make_node(AST_BlockStatement, node, { body: body.reverse() });\n\n            function flush() {\n                if (j > i + 1) body.push(make_node(AST_SimpleStatement, node, {\n                    body: make_sequence(node, exprs.slice(i + 1, j)),\n                }));\n                j = i;\n            }\n        }\n        def(AST_Sequence, function(compressor, scope, no_return, in_loop, in_await) {\n            return inline_sequence(compressor, scope, no_return, in_loop, in_await, this);\n        });\n        def(AST_SimpleStatement, function(compressor, scope, no_return, in_loop) {\n            var body = this.body;\n            while (body instanceof AST_UnaryPrefix) {\n                var op = body.operator;\n                if (unary_side_effects[op]) break;\n                if (op == "void") break;\n                body = body.expression;\n            }\n            if (!no_return && !is_undefined(body)) body = make_node(AST_UnaryPrefix, this, {\n                operator: "void",\n                expression: body,\n            });\n            return body.try_inline(compressor, scope, no_return || false, in_loop);\n        });\n        def(AST_UnaryPrefix, function(compressor, scope, no_return, in_loop, in_await) {\n            var self = this;\n            var op = self.operator;\n            if (unary_side_effects[op]) return;\n            if (!no_return && op == "void") no_return = false;\n            var inlined = self.expression.try_inline(compressor, scope, no_return, in_loop, in_await);\n            if (!inlined) return;\n            if (!no_return) scan_local_returns(inlined, function(node) {\n                node.in_bool = false;\n                var value = node.value;\n                if (op == "void" && is_undefined(value)) return;\n                node.value = make_node(AST_UnaryPrefix, self, {\n                    operator: op,\n                    expression: value || make_node(AST_Undefined, node).transform(compressor),\n                });\n            });\n            return inlined;\n        });\n        def(AST_With, function(compressor, scope, no_return, in_loop) {\n            var body = this.body.try_inline(compressor, scope, no_return, in_loop);\n            if (body) this.body = body;\n            var exp = this.expression;\n            if (exp instanceof AST_Sequence) {\n                var inlined = inline_sequence(compressor, scope, true, in_loop, false, exp, 1);\n                if (inlined) {\n                    this.expression = exp.tail_node();\n                    inlined.body.push(this);\n                    return inlined;\n                }\n            }\n            return body && this;\n        });\n        def(AST_Yield, function(compressor, scope, no_return, in_loop) {\n            if (!compressor.option("yields")) return;\n            if (!this.nested) return;\n            var call = this.expression;\n            if (call.TYPE != "Call") return;\n            var fn = call.expression;\n            switch (fn.CTOR) {\n              case AST_AsyncGeneratorFunction:\n                fn = make_node(AST_AsyncFunction, fn);\n                break;\n              case AST_GeneratorFunction:\n                fn = make_node(AST_Function, fn);\n                break;\n              default:\n                return;\n            }\n            call = call.clone();\n            call.expression = fn;\n            return call.try_inline(compressor, scope, no_return, in_loop);\n        });\n    })(function(node, func) {\n        node.DEFMETHOD("try_inline", func);\n    });\n\n    OPT(AST_Return, function(self, compressor) {\n        var value = self.value;\n        if (value && compressor.option("side_effects")\n            && is_undefined(value, compressor)\n            && !in_async_generator(compressor.find_parent(AST_Scope))) {\n            self.value = null;\n        }\n        return self;\n    });\n})(function(node, optimizer) {\n    node.DEFMETHOD("optimize", function(compressor) {\n        var self = this;\n        if (self._optimized) return self;\n        if (compressor.has_directive("use asm")) return self;\n        var opt = optimizer(self, compressor);\n        opt._optimized = true;\n        return opt;\n    });\n});\n'},57145:(e,t,r)=>{"use strict";r.d(t,{Z:()=>n});const n='"use strict";\n\nvar to_ascii, to_base64;\nif (typeof Buffer == "undefined") {\n    to_ascii = atob;\n    to_base64 = btoa;\n} else if (typeof Buffer.alloc == "undefined") {\n    to_ascii = function(b64) {\n        return new Buffer(b64, "base64").toString();\n    };\n    to_base64 = function(str) {\n        return new Buffer(str).toString("base64");\n    };\n} else {\n    to_ascii = function(b64) {\n        return Buffer.from(b64, "base64").toString();\n    };\n    to_base64 = function(str) {\n        return Buffer.from(str).toString("base64");\n    };\n}\n\nfunction read_source_map(name, toplevel) {\n    var comments = toplevel.end.comments_after;\n    for (var i = comments.length; --i >= 0;) {\n        var comment = comments[i];\n        if (comment.type != "comment1") break;\n        var match = /^# ([^\\s=]+)=(\\S+)\\s*$/.exec(comment.value);\n        if (!match) break;\n        if (match[1] == "sourceMappingURL") {\n            match = /^data:application\\/json(;.*?)?;base64,([^,]+)$/.exec(match[2]);\n            if (!match) break;\n            return to_ascii(match[2]);\n        }\n    }\n    AST_Node.warn("inline source map not found: {name}", {\n        name: name,\n    });\n}\n\nfunction parse_source_map(content) {\n    try {\n        return JSON.parse(content);\n    } catch (ex) {\n        throw new Error("invalid input source map: " + content);\n    }\n}\n\nfunction set_shorthand(name, options, keys) {\n    keys.forEach(function(key) {\n        if (options[key]) {\n            var defs = {};\n            defs[name] = options[name];\n            options[key] = defaults(options[key], defs);\n        }\n    });\n}\n\nfunction init_cache(cache) {\n    if (!cache) return;\n    if (!("props" in cache)) {\n        cache.props = new Dictionary();\n    } else if (!(cache.props instanceof Dictionary)) {\n        cache.props = Dictionary.fromObject(cache.props);\n    }\n}\n\nfunction to_json(cache) {\n    return {\n        props: cache.props.toObject()\n    };\n}\n\nfunction minify(files, options) {\n    try {\n        options = defaults(options, {\n            annotations: undefined,\n            compress: {},\n            enclose: false,\n            expression: false,\n            ie: false,\n            ie8: false,\n            keep_fargs: false,\n            keep_fnames: false,\n            mangle: {},\n            module: undefined,\n            nameCache: null,\n            output: {},\n            parse: {},\n            rename: undefined,\n            sourceMap: false,\n            timings: false,\n            toplevel: options && !options["expression"] && options["module"] ? true : undefined,\n            v8: false,\n            validate: false,\n            warnings: false,\n            webkit: false,\n            wrap: false,\n        }, true);\n        if (options.validate) AST_Node.enable_validation();\n        var timings = options.timings && { start: Date.now() };\n        if (options.annotations !== undefined) set_shorthand("annotations", options, [ "compress", "output" ]);\n        if (options.expression) set_shorthand("expression", options, [ "compress", "parse" ]);\n        if (options.ie8) options.ie = options.ie || options.ie8;\n        if (options.ie) set_shorthand("ie", options, [ "compress", "mangle", "output", "rename" ]);\n        if (options.keep_fargs) set_shorthand("keep_fargs", options, [ "compress", "mangle", "rename" ]);\n        if (options.keep_fnames) set_shorthand("keep_fnames", options, [ "compress", "mangle", "rename" ]);\n        if (options.module === undefined && !options.ie) options.module = true;\n        if (options.module) set_shorthand("module", options, [ "compress", "output", "parse" ]);\n        if (options.toplevel !== undefined) set_shorthand("toplevel", options, [ "compress", "mangle", "rename" ]);\n        if (options.v8) set_shorthand("v8", options, [ "mangle", "output", "rename" ]);\n        if (options.webkit) set_shorthand("webkit", options, [ "compress", "mangle", "output", "rename" ]);\n        var quoted_props;\n        if (options.mangle) {\n            options.mangle = defaults(options.mangle, {\n                cache: options.nameCache && (options.nameCache.vars || {}),\n                eval: false,\n                ie: false,\n                keep_fargs: false,\n                keep_fnames: false,\n                properties: false,\n                reserved: [],\n                toplevel: false,\n                v8: false,\n                webkit: false,\n            }, true);\n            if (options.mangle.properties) {\n                if (typeof options.mangle.properties != "object") {\n                    options.mangle.properties = {};\n                }\n                if (options.mangle.properties.keep_quoted) {\n                    quoted_props = options.mangle.properties.reserved;\n                    if (!Array.isArray(quoted_props)) quoted_props = [];\n                    options.mangle.properties.reserved = quoted_props;\n                }\n                if (options.nameCache && !("cache" in options.mangle.properties)) {\n                    options.mangle.properties.cache = options.nameCache.props || {};\n                }\n            }\n            init_cache(options.mangle.cache);\n            init_cache(options.mangle.properties.cache);\n        }\n        if (options.rename === undefined) options.rename = options.compress && options.mangle;\n        if (options.sourceMap) {\n            options.sourceMap = defaults(options.sourceMap, {\n                content: null,\n                filename: null,\n                includeSources: false,\n                names: true,\n                root: null,\n                url: null,\n            }, true);\n        }\n        var warnings = [];\n        if (options.warnings) AST_Node.log_function(function(warning) {\n            warnings.push(warning);\n        }, options.warnings == "verbose");\n        if (timings) timings.parse = Date.now();\n        var toplevel;\n        options.parse = options.parse || {};\n        if (files instanceof AST_Node) {\n            toplevel = files;\n        } else {\n            if (typeof files == "string") files = [ files ];\n            options.parse.toplevel = null;\n            var source_map_content = options.sourceMap && options.sourceMap.content;\n            if (typeof source_map_content == "string" && source_map_content != "inline") {\n                source_map_content = parse_source_map(source_map_content);\n            }\n            if (source_map_content) options.sourceMap.orig = Object.create(null);\n            for (var name in files) if (HOP(files, name)) {\n                options.parse.filename = name;\n                options.parse.toplevel = toplevel = parse(files[name], options.parse);\n                if (source_map_content == "inline") {\n                    var inlined_content = read_source_map(name, toplevel);\n                    if (inlined_content) options.sourceMap.orig[name] = parse_source_map(inlined_content);\n                } else if (source_map_content) {\n                    options.sourceMap.orig[name] = source_map_content;\n                }\n            }\n        }\n        if (options.parse.expression) toplevel = toplevel.wrap_expression();\n        if (quoted_props) reserve_quoted_keys(toplevel, quoted_props);\n        [ "enclose", "wrap" ].forEach(function(action) {\n            var option = options[action];\n            if (!option) return;\n            var orig = toplevel.print_to_string().slice(0, -1);\n            toplevel = toplevel[action](option);\n            files[toplevel.start.file] = toplevel.print_to_string().replace(orig, "");\n        });\n        if (options.validate) toplevel.validate_ast();\n        if (timings) timings.rename = Date.now();\n        if (options.rename) {\n            toplevel.figure_out_scope(options.rename);\n            toplevel.expand_names(options.rename);\n        }\n        if (timings) timings.compress = Date.now();\n        if (options.compress) {\n            toplevel = new Compressor(options.compress).compress(toplevel);\n            if (options.validate) toplevel.validate_ast();\n        }\n        if (timings) timings.scope = Date.now();\n        if (options.mangle) toplevel.figure_out_scope(options.mangle);\n        if (timings) timings.mangle = Date.now();\n        if (options.mangle) {\n            toplevel.compute_char_frequency(options.mangle);\n            toplevel.mangle_names(options.mangle);\n        }\n        if (timings) timings.properties = Date.now();\n        if (quoted_props) reserve_quoted_keys(toplevel, quoted_props);\n        if (options.mangle && options.mangle.properties) mangle_properties(toplevel, options.mangle.properties);\n        if (options.parse.expression) toplevel = toplevel.unwrap_expression();\n        if (timings) timings.output = Date.now();\n        var result = {};\n        var output = defaults(options.output, {\n            ast: false,\n            code: true,\n        });\n        if (output.ast) result.ast = toplevel;\n        if (output.code) {\n            if (options.sourceMap) {\n                output.source_map = SourceMap(options.sourceMap);\n                if (options.sourceMap.includeSources) {\n                    if (files instanceof AST_Toplevel) {\n                        throw new Error("original source content unavailable");\n                    } else for (var name in files) if (HOP(files, name)) {\n                        output.source_map.setSourceContent(name, files[name]);\n                    }\n                }\n            }\n            delete output.ast;\n            delete output.code;\n            var stream = OutputStream(output);\n            toplevel.print(stream);\n            result.code = stream.get();\n            if (options.sourceMap) {\n                result.map = output.source_map.toString();\n                var url = options.sourceMap.url;\n                if (url) {\n                    result.code = result.code.replace(/\\n\\/\\/# sourceMappingURL=\\S+\\s*$/, "");\n                    if (url == "inline") {\n                        result.code += "\\n//# sourceMappingURL=data:application/json;charset=utf-8;base64," + to_base64(result.map);\n                    } else {\n                        result.code += "\\n//# sourceMappingURL=" + url;\n                    }\n                }\n            }\n        }\n        if (options.nameCache && options.mangle) {\n            if (options.mangle.cache) options.nameCache.vars = to_json(options.mangle.cache);\n            if (options.mangle.properties && options.mangle.properties.cache) {\n                options.nameCache.props = to_json(options.mangle.properties.cache);\n            }\n        }\n        if (timings) {\n            timings.end = Date.now();\n            result.timings = {\n                parse: 1e-3 * (timings.rename - timings.parse),\n                rename: 1e-3 * (timings.compress - timings.rename),\n                compress: 1e-3 * (timings.scope - timings.compress),\n                scope: 1e-3 * (timings.mangle - timings.scope),\n                mangle: 1e-3 * (timings.properties - timings.mangle),\n                properties: 1e-3 * (timings.output - timings.properties),\n                output: 1e-3 * (timings.end - timings.output),\n                total: 1e-3 * (timings.end - timings.start)\n            };\n        }\n        if (warnings.length) {\n            result.warnings = warnings;\n        }\n        return result;\n    } catch (ex) {\n        return { error: ex };\n    } finally {\n        AST_Node.log_function();\n        AST_Node.disable_validation();\n    }\n}\n'},78387:(e,t,r)=>{"use strict";r.d(t,{Z:()=>n});const n='/***********************************************************************\n\n  A JavaScript tokenizer / parser / beautifier / compressor.\n  https://github.com/mishoo/UglifyJS\n\n  -------------------------------- (C) ---------------------------------\n\n                           Author: Mihai Bazon\n                         <mihai.bazon@gmail.com>\n                       http://mihai.bazon.net/blog\n\n  Distributed under the BSD license:\n\n    Copyright 2012 (c) Mihai Bazon <mihai.bazon@gmail.com>\n\n    Redistribution and use in source and binary forms, with or without\n    modification, are permitted provided that the following conditions\n    are met:\n\n        * Redistributions of source code must retain the above\n          copyright notice, this list of conditions and the following\n          disclaimer.\n\n        * Redistributions in binary form must reproduce the above\n          copyright notice, this list of conditions and the following\n          disclaimer in the documentation and/or other materials\n          provided with the distribution.\n\n    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY\n    EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE\n    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,\n    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR\n    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF\n    THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n    SUCH DAMAGE.\n\n ***********************************************************************/\n\n"use strict";\n\n(function() {\n    var MOZ_TO_ME = {\n        Program: function(M) {\n            return new AST_Toplevel({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                body: normalize_directives(M.body.map(from_moz)),\n            });\n        },\n        ArrowFunctionExpression: function(M) {\n            var argnames = [], rest = null;\n            M.params.forEach(function(param) {\n                if (param.type == "RestElement") {\n                    rest = from_moz(param.argument);\n                } else {\n                    argnames.push(from_moz(param));\n                }\n            });\n            var fn = new (M.async ? AST_AsyncArrow : AST_Arrow)({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                argnames: argnames,\n                rest: rest,\n            });\n            var node = from_moz(M.body);\n            if (node instanceof AST_BlockStatement) {\n                fn.body = normalize_directives(node.body);\n                fn.value = null;\n            } else {\n                fn.body = [];\n                fn.value = node;\n            }\n            return fn;\n        },\n        FunctionDeclaration: function(M) {\n            var ctor;\n            if (M.async) {\n                ctor = M.generator ? AST_AsyncGeneratorDefun : AST_AsyncDefun;\n            } else {\n                ctor = M.generator ? AST_GeneratorDefun : AST_Defun;\n            }\n            var argnames = [], rest = null;\n            M.params.forEach(function(param) {\n                if (param.type == "RestElement") {\n                    rest = from_moz(param.argument);\n                } else {\n                    argnames.push(from_moz(param));\n                }\n            });\n            return new ctor({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                name: from_moz(M.id),\n                argnames: argnames,\n                rest: rest,\n                body: normalize_directives(from_moz(M.body).body),\n            });\n        },\n        FunctionExpression: function(M) {\n            var ctor;\n            if (M.async) {\n                ctor = M.generator ? AST_AsyncGeneratorFunction : AST_AsyncFunction;\n            } else {\n                ctor = M.generator ? AST_GeneratorFunction : AST_Function;\n            }\n            var argnames = [], rest = null;\n            M.params.forEach(function(param) {\n                if (param.type == "RestElement") {\n                    rest = from_moz(param.argument);\n                } else {\n                    argnames.push(from_moz(param));\n                }\n            });\n            return new ctor({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                name: from_moz(M.id),\n                argnames: argnames,\n                rest: rest,\n                body: normalize_directives(from_moz(M.body).body),\n            });\n        },\n        CallExpression: function(M) {\n            return new AST_Call({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                expression: from_moz(M.callee),\n                args: M.arguments.map(from_moz),\n                optional: M.optional,\n                pure: M.pure,\n            });\n        },\n        ClassDeclaration: function(M) {\n            return new AST_DefClass({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                name: from_moz(M.id),\n                extends: from_moz(M.superClass),\n                properties: M.body.body.map(from_moz),\n            });\n        },\n        ClassExpression: function(M) {\n            return new AST_ClassExpression({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                name: from_moz(M.id),\n                extends: from_moz(M.superClass),\n                properties: M.body.body.map(from_moz),\n            });\n        },\n        MethodDefinition: function(M) {\n            var key = M.key, internal = false;\n            if (M.computed) {\n                key = from_moz(key);\n            } else if (key.type == "PrivateIdentifier") {\n                internal = true;\n                key = "#" + key.name;\n            } else {\n                key = read_name(key);\n            }\n            var ctor = AST_ClassMethod, value = from_moz(M.value);\n            switch (M.kind) {\n              case "get":\n                ctor = AST_ClassGetter;\n                value = new AST_Accessor(value);\n                break;\n              case "set":\n                ctor = AST_ClassSetter;\n                value = new AST_Accessor(value);\n                break;\n            }\n            return new ctor({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                key: key,\n                private: internal,\n                static: M.static,\n                value: value,\n            });\n        },\n        PropertyDefinition: function(M) {\n            var key = M.key, internal = false;\n            if (M.computed) {\n                key = from_moz(key);\n            } else if (key.type == "PrivateIdentifier") {\n                internal = true;\n                key = "#" + key.name;\n            } else {\n                key = read_name(key);\n            }\n            return new AST_ClassField({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                key: key,\n                private: internal,\n                static: M.static,\n                value: from_moz(M.value),\n            });\n        },\n        StaticBlock: function(M) {\n            var start = my_start_token(M);\n            var end = my_end_token(M);\n            return new AST_ClassInit({\n                start: start,\n                end: end,\n                value: new AST_ClassInitBlock({\n                    start: start,\n                    end: end,\n                    body: normalize_directives(M.body.map(from_moz)),\n                }),\n            });\n        },\n        ForOfStatement: function(M) {\n            return new (M.await ? AST_ForAwaitOf : AST_ForOf)({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                init: from_moz(M.left),\n                object: from_moz(M.right),\n                body: from_moz(M.body),\n            });\n        },\n        TryStatement: function(M) {\n            var handlers = M.handlers || [M.handler];\n            if (handlers.length > 1 || M.guardedHandlers && M.guardedHandlers.length) {\n                throw new Error("Multiple catch clauses are not supported.");\n            }\n            return new AST_Try({\n                start    : my_start_token(M),\n                end      : my_end_token(M),\n                body     : from_moz(M.block).body,\n                bcatch   : from_moz(handlers[0]),\n                bfinally : M.finalizer ? new AST_Finally(from_moz(M.finalizer)) : null,\n            });\n        },\n        Property: function(M) {\n            var key = M.computed ? from_moz(M.key) : read_name(M.key);\n            var args = {\n                start: my_start_token(M),\n                end: my_end_token(M),\n                key: key,\n                value: from_moz(M.value),\n            };\n            if (M.kind == "init") return new (M.method ? AST_ObjectMethod : AST_ObjectKeyVal)(args);\n            args.value = new AST_Accessor(args.value);\n            if (M.kind == "get") return new AST_ObjectGetter(args);\n            if (M.kind == "set") return new AST_ObjectSetter(args);\n        },\n        ArrayExpression: function(M) {\n            return new AST_Array({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                elements: M.elements.map(function(elem) {\n                    return elem === null ? new AST_Hole() : from_moz(elem);\n                }),\n            });\n        },\n        ArrayPattern: function(M) {\n            var elements = [], rest = null;\n            M.elements.forEach(function(el) {\n                if (el === null) {\n                    elements.push(new AST_Hole());\n                } else if (el.type == "RestElement") {\n                    rest = from_moz(el.argument);\n                } else {\n                    elements.push(from_moz(el));\n                }\n            });\n            return new AST_DestructuredArray({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                elements: elements,\n                rest: rest,\n            });\n        },\n        ObjectPattern: function(M) {\n            var props = [], rest = null;\n            M.properties.forEach(function(prop) {\n                if (prop.type == "RestElement") {\n                    rest = from_moz(prop.argument);\n                } else {\n                    props.push(new AST_DestructuredKeyVal(from_moz(prop)));\n                }\n            });\n            return new AST_DestructuredObject({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                properties: props,\n                rest: rest,\n            });\n        },\n        MemberExpression: function(M) {\n            return new (M.computed ? AST_Sub : AST_Dot)({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                optional: M.optional,\n                expression: from_moz(M.object),\n                property: M.computed ? from_moz(M.property) : M.property.name,\n            });\n        },\n        MetaProperty: function(M) {\n            var expr = from_moz(M.meta);\n            var prop = read_name(M.property);\n            if (expr.name == "new" && prop == "target") return new AST_NewTarget({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                name: "new.target",\n            });\n            return new AST_Dot({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                expression: expr,\n                property: prop,\n            });\n        },\n        SwitchCase: function(M) {\n            return new (M.test ? AST_Case : AST_Default)({\n                start      : my_start_token(M),\n                end        : my_end_token(M),\n                expression : from_moz(M.test),\n                body       : M.consequent.map(from_moz),\n            });\n        },\n        ExportAllDeclaration: function(M) {\n            var start = my_start_token(M);\n            var end = my_end_token(M);\n            return new AST_ExportForeign({\n                start: start,\n                end: end,\n                aliases: [ M.exported ? from_moz_alias(M.exported) : new AST_String({\n                    start: start,\n                    value: "*",\n                    end: end,\n                }) ],\n                keys: [ new AST_String({\n                    start: start,\n                    value: "*",\n                    end: end,\n                }) ],\n                path: from_moz(M.source),\n            });\n        },\n        ExportDefaultDeclaration: function(M) {\n            var decl = from_moz(M.declaration);\n            if (!decl.name) switch (decl.CTOR) {\n              case AST_AsyncDefun:\n                decl = new AST_AsyncFunction(decl);\n                break;\n              case AST_AsyncGeneratorDefun:\n                decl = new AST_AsyncGeneratorFunction(decl);\n                break;\n              case AST_DefClass:\n                decl = new AST_ClassExpression(decl);\n                break;\n              case AST_Defun:\n                decl = new AST_Function(decl);\n                break;\n              case AST_GeneratorDefun:\n                decl = new AST_GeneratorFunction(decl);\n                break;\n            }\n            return new AST_ExportDefault({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                body: decl,\n            });\n        },\n        ExportNamedDeclaration: function(M) {\n            if (M.declaration) return new AST_ExportDeclaration({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                body: from_moz(M.declaration),\n            });\n            if (M.source) {\n                var aliases = [], keys = [];\n                M.specifiers.forEach(function(prop) {\n                    aliases.push(from_moz_alias(prop.exported));\n                    keys.push(from_moz_alias(prop.local));\n                });\n                return new AST_ExportForeign({\n                    start: my_start_token(M),\n                    end: my_end_token(M),\n                    aliases: aliases,\n                    keys: keys,\n                    path: from_moz(M.source),\n                });\n            }\n            return new AST_ExportReferences({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                properties: M.specifiers.map(function(prop) {\n                    var sym = new AST_SymbolExport(from_moz(prop.local));\n                    sym.alias = from_moz_alias(prop.exported);\n                    return sym;\n                }),\n            });\n        },\n        ImportDeclaration: function(M) {\n            var start = my_start_token(M);\n            var end = my_end_token(M);\n            var all = null, def = null, props = null;\n            M.specifiers.forEach(function(prop) {\n                var sym = new AST_SymbolImport(from_moz(prop.local));\n                switch (prop.type) {\n                  case "ImportDefaultSpecifier":\n                    def = sym;\n                    def.key = new AST_String({\n                        start: start,\n                        value: "",\n                        end: end,\n                    });\n                    break;\n                  case "ImportNamespaceSpecifier":\n                    all = sym;\n                    all.key = new AST_String({\n                        start: start,\n                        value: "*",\n                        end: end,\n                    });\n                    break;\n                  default:\n                    sym.key = from_moz_alias(prop.imported);\n                    if (!props) props = [];\n                    props.push(sym);\n                    break;\n                }\n            });\n            return new AST_Import({\n                start: start,\n                end: end,\n                all: all,\n                default: def,\n                properties: props,\n                path: from_moz(M.source),\n            });\n        },\n        ImportExpression: function(M) {\n            var start = my_start_token(M);\n            var arg = from_moz(M.source);\n            return new AST_Call({\n                start: start,\n                end: my_end_token(M),\n                expression: new AST_SymbolRef({\n                    start: start,\n                    end: arg.start,\n                    name: "import",\n                }),\n                args: [ arg ],\n            });\n        },\n        VariableDeclaration: function(M) {\n            return new ({\n                const: AST_Const,\n                let: AST_Let,\n            }[M.kind] || AST_Var)({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                definitions: M.declarations.map(from_moz),\n            });\n        },\n        Literal: function(M) {\n            var args = {\n                start: my_start_token(M),\n                end: my_end_token(M),\n            };\n            if (M.bigint) {\n                args.value = M.bigint.toLowerCase();\n                return new AST_BigInt(args);\n            }\n            var val = M.value;\n            if (val === null) return new AST_Null(args);\n            var rx = M.regex;\n            if (rx && rx.pattern) {\n                // RegExpLiteral as per ESTree AST spec\n                args.value = new RegExp(rx.pattern, rx.flags);\n                args.value.raw_source = rx.pattern;\n                return new AST_RegExp(args);\n            } else if (rx) {\n                // support legacy RegExp\n                args.value = M.regex && M.raw ? M.raw : val;\n                return new AST_RegExp(args);\n            }\n            switch (typeof val) {\n              case "string":\n                args.value = val;\n                return new AST_String(args);\n              case "number":\n                if (isNaN(val)) return new AST_NaN(args);\n                var negate, node;\n                if (isFinite(val)) {\n                    negate = 1 / val < 0;\n                    args.value = negate ? -val : val;\n                    node = new AST_Number(args);\n                } else {\n                    negate = val < 0;\n                    node = new AST_Infinity(args);\n                }\n                return negate ? new AST_UnaryPrefix({\n                    start: args.start,\n                    end: args.end,\n                    operator: "-",\n                    expression: node,\n                }) : node;\n              case "boolean":\n                return new (val ? AST_True : AST_False)(args);\n            }\n        },\n        TemplateLiteral: function(M) {\n            return new AST_Template({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                expressions: M.expressions.map(from_moz),\n                strings: M.quasis.map(function(el) {\n                    return el.value.raw;\n                }),\n            });\n        },\n        TaggedTemplateExpression: function(M) {\n            var tmpl = from_moz(M.quasi);\n            tmpl.start = my_start_token(M);\n            tmpl.end = my_end_token(M);\n            tmpl.tag = from_moz(M.tag);\n            return tmpl;\n        },\n        Identifier: function(M) {\n            var p, level = FROM_MOZ_STACK.length - 1;\n            do {\n                p = FROM_MOZ_STACK[--level];\n            } while (p.type == "ArrayPattern"\n                || p.type == "AssignmentPattern" && p.left === FROM_MOZ_STACK[level + 1]\n                || p.type == "ObjectPattern"\n                || p.type == "Property" && p.value === FROM_MOZ_STACK[level + 1]\n                || p.type == "VariableDeclarator" && p.id === FROM_MOZ_STACK[level + 1]);\n            var ctor = AST_SymbolRef;\n            switch (p.type) {\n              case "ArrowFunctionExpression":\n                if (p.body !== FROM_MOZ_STACK[level + 1]) ctor = AST_SymbolFunarg;\n                break;\n              case "BreakStatement":\n              case "ContinueStatement":\n                ctor = AST_LabelRef;\n                break;\n              case "CatchClause":\n                ctor = AST_SymbolCatch;\n                break;\n              case "ClassDeclaration":\n                if (p.id === FROM_MOZ_STACK[level + 1]) ctor = AST_SymbolDefClass;\n                break;\n              case "ClassExpression":\n                if (p.id === FROM_MOZ_STACK[level + 1]) ctor = AST_SymbolClass;\n                break;\n              case "FunctionDeclaration":\n                ctor = p.id === FROM_MOZ_STACK[level + 1] ? AST_SymbolDefun : AST_SymbolFunarg;\n                break;\n              case "FunctionExpression":\n                ctor = p.id === FROM_MOZ_STACK[level + 1] ? AST_SymbolLambda : AST_SymbolFunarg;\n                break;\n              case "LabeledStatement":\n                ctor = AST_Label;\n                break;\n              case "VariableDeclaration":\n                ctor = {\n                    const: AST_SymbolConst,\n                    let: AST_SymbolLet,\n                }[p.kind] || AST_SymbolVar;\n                break;\n            }\n            return new ctor({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                name: M.name,\n            });\n        },\n        Super: function(M) {\n            return new AST_Super({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                name: "super",\n            });\n        },\n        ThisExpression: function(M) {\n            return new AST_This({\n                start: my_start_token(M),\n                end: my_end_token(M),\n                name: "this",\n            });\n        },\n        ParenthesizedExpression: function(M) {\n            var node = from_moz(M.expression);\n            if (!node.start.parens) node.start.parens = [];\n            node.start.parens.push(my_start_token(M));\n            if (!node.end.parens) node.end.parens = [];\n            node.end.parens.push(my_end_token(M));\n            return node;\n        },\n        ChainExpression: function(M) {\n            var node = from_moz(M.expression);\n            node.terminal = true;\n            return node;\n        },\n    };\n\n    MOZ_TO_ME.UpdateExpression =\n    MOZ_TO_ME.UnaryExpression = function To_Moz_Unary(M) {\n        var prefix = "prefix" in M ? M.prefix\n            : M.type == "UnaryExpression" ? true : false;\n        return new (prefix ? AST_UnaryPrefix : AST_UnaryPostfix)({\n            start      : my_start_token(M),\n            end        : my_end_token(M),\n            operator   : M.operator,\n            expression : from_moz(M.argument)\n        });\n    };\n\n    map("EmptyStatement", AST_EmptyStatement);\n    map("ExpressionStatement", AST_SimpleStatement, "expression>body");\n    map("BlockStatement", AST_BlockStatement, "body@body");\n    map("IfStatement", AST_If, "test>condition, consequent>body, alternate>alternative");\n    map("LabeledStatement", AST_LabeledStatement, "label>label, body>body");\n    map("BreakStatement", AST_Break, "label>label");\n    map("ContinueStatement", AST_Continue, "label>label");\n    map("WithStatement", AST_With, "object>expression, body>body");\n    map("SwitchStatement", AST_Switch, "discriminant>expression, cases@body");\n    map("ReturnStatement", AST_Return, "argument>value");\n    map("ThrowStatement", AST_Throw, "argument>value");\n    map("WhileStatement", AST_While, "test>condition, body>body");\n    map("DoWhileStatement", AST_Do, "test>condition, body>body");\n    map("ForStatement", AST_For, "init>init, test>condition, update>step, body>body");\n    map("ForInStatement", AST_ForIn, "left>init, right>object, body>body");\n    map("DebuggerStatement", AST_Debugger);\n    map("VariableDeclarator", AST_VarDef, "id>name, init>value");\n    map("CatchClause", AST_Catch, "param>argname, body%body");\n\n    map("BinaryExpression", AST_Binary, "operator=operator, left>left, right>right");\n    map("LogicalExpression", AST_Binary, "operator=operator, left>left, right>right");\n    map("AssignmentExpression", AST_Assign, "operator=operator, left>left, right>right");\n    map("AssignmentPattern", AST_DefaultValue, "left>name, right>value");\n    map("ConditionalExpression", AST_Conditional, "test>condition, consequent>consequent, alternate>alternative");\n    map("NewExpression", AST_New, "callee>expression, arguments@args, pure=pure");\n    map("SequenceExpression", AST_Sequence, "expressions@expressions");\n    map("SpreadElement", AST_Spread, "argument>expression");\n    map("ObjectExpression", AST_Object, "properties@properties");\n    map("AwaitExpression", AST_Await, "argument>expression");\n    map("YieldExpression", AST_Yield, "argument>expression, delegate=nested");\n\n    def_to_moz(AST_Toplevel, function To_Moz_Program(M) {\n        return to_moz_scope("Program", M);\n    });\n\n    def_to_moz(AST_LambdaDefinition, function To_Moz_FunctionDeclaration(M) {\n        var params = M.argnames.map(to_moz);\n        if (M.rest) params.push({\n            type: "RestElement",\n            argument: to_moz(M.rest),\n        });\n        return {\n            type: "FunctionDeclaration",\n            id: to_moz(M.name),\n            async: is_async(M),\n            generator: is_generator(M),\n            params: params,\n            body: to_moz_scope("BlockStatement", M),\n        };\n    });\n\n    def_to_moz(AST_Lambda, function To_Moz_FunctionExpression(M) {\n        var params = M.argnames.map(to_moz);\n        if (M.rest) params.push({\n            type: "RestElement",\n            argument: to_moz(M.rest),\n        });\n        if (is_arrow(M)) return {\n            type: "ArrowFunctionExpression",\n            async: is_async(M),\n            params: params,\n            expression: !!M.value,\n            body: M.value ? to_moz(M.value) : to_moz_scope("BlockStatement", M),\n        };\n        return {\n            type: "FunctionExpression",\n            id: to_moz(M.name),\n            async: is_async(M),\n            generator: is_generator(M),\n            params: params,\n            body: to_moz_scope("BlockStatement", M),\n        };\n    });\n\n    def_to_moz(AST_Call, function To_Moz_CallExpression(M) {\n        var expr = M.expression;\n        if (M.args.length == 1 && expr instanceof AST_SymbolRef && expr.name == "import") return {\n            type: "ImportExpression",\n            source: to_moz(M.args[0]),\n        };\n        return {\n            type: "CallExpression",\n            callee: to_moz(expr),\n            arguments: M.args.map(to_moz),\n            optional: M.optional,\n            pure: M.pure,\n        };\n    });\n\n    def_to_moz(AST_DefClass, function To_Moz_ClassDeclaration(M) {\n        return {\n            type: "ClassDeclaration",\n            id: to_moz(M.name),\n            superClass: to_moz(M.extends),\n            body: {\n                type: "ClassBody",\n                body: M.properties.map(to_moz),\n            },\n        };\n    });\n\n    def_to_moz(AST_ClassExpression, function To_Moz_ClassExpression(M) {\n        return {\n            type: "ClassExpression",\n            id: to_moz(M.name),\n            superClass: to_moz(M.extends),\n            body: {\n                type: "ClassBody",\n                body: M.properties.map(to_moz),\n            },\n        };\n    });\n\n    function To_Moz_MethodDefinition(kind) {\n        return function(M) {\n            var computed = M.key instanceof AST_Node;\n            var key = computed ? to_moz(M.key) : M.private ? {\n                type: "PrivateIdentifier",\n                name: M.key.slice(1),\n            } : {\n                type: "Literal",\n                value: M.key,\n            };\n            return {\n                type: "MethodDefinition",\n                kind: kind,\n                computed: computed,\n                key: key,\n                static: M.static,\n                value: to_moz(M.value),\n            };\n        };\n    }\n    def_to_moz(AST_ClassGetter, To_Moz_MethodDefinition("get"));\n    def_to_moz(AST_ClassSetter, To_Moz_MethodDefinition("set"));\n    def_to_moz(AST_ClassMethod, To_Moz_MethodDefinition("method"));\n\n    def_to_moz(AST_ClassField, function To_Moz_PropertyDefinition(M) {\n        var computed = M.key instanceof AST_Node;\n        var key = computed ? to_moz(M.key) : M.private ? {\n            type: "PrivateIdentifier",\n            name: M.key.slice(1),\n        } : {\n            type: "Literal",\n            value: M.key,\n        };\n        return {\n            type: "PropertyDefinition",\n            computed: computed,\n            key: key,\n            static: M.static,\n            value: to_moz(M.value),\n        };\n    });\n\n    def_to_moz(AST_ClassInit, function To_Moz_StaticBlock(M) {\n        return to_moz_scope("StaticBlock", M.value);\n    });\n\n    function To_Moz_ForOfStatement(is_await) {\n        return function(M) {\n            return {\n                type: "ForOfStatement",\n                await: is_await,\n                left: to_moz(M.init),\n                right: to_moz(M.object),\n                body: to_moz(M.body),\n            };\n        };\n    }\n    def_to_moz(AST_ForAwaitOf, To_Moz_ForOfStatement(true));\n    def_to_moz(AST_ForOf, To_Moz_ForOfStatement(false));\n\n    def_to_moz(AST_Directive, function To_Moz_Directive(M) {\n        return {\n            type: "ExpressionStatement",\n            directive: M.value,\n            expression: set_moz_loc(M, {\n                type: "Literal",\n                value: M.value,\n            }),\n        };\n    });\n\n    def_to_moz(AST_SwitchBranch, function To_Moz_SwitchCase(M) {\n        return {\n            type: "SwitchCase",\n            test: to_moz(M.expression),\n            consequent: M.body.map(to_moz),\n        };\n    });\n\n    def_to_moz(AST_Try, function To_Moz_TryStatement(M) {\n        return {\n            type: "TryStatement",\n            block: to_moz_block(M),\n            handler: to_moz(M.bcatch),\n            finalizer: to_moz(M.bfinally),\n        };\n    });\n\n    def_to_moz(AST_Catch, function To_Moz_CatchClause(M) {\n        return {\n            type: "CatchClause",\n            param: to_moz(M.argname),\n            body: to_moz_block(M),\n        };\n    });\n\n    def_to_moz(AST_ExportDeclaration, function To_Moz_ExportNamedDeclaration_declaration(M) {\n        return {\n            type: "ExportNamedDeclaration",\n            declaration: to_moz(M.body),\n            specifiers: [],\n        };\n    });\n\n    def_to_moz(AST_ExportDefault, function To_Moz_ExportDefaultDeclaration(M) {\n        return {\n            type: "ExportDefaultDeclaration",\n            declaration: to_moz(M.body),\n        };\n    });\n\n    def_to_moz(AST_ExportForeign, function To_Moz_ExportAllDeclaration_ExportNamedDeclaration(M) {\n        if (M.keys[0].value == "*") return {\n            type: "ExportAllDeclaration",\n            exported: M.aliases[0].value == "*" ? null : to_moz_alias(M.aliases[0]),\n            source: to_moz(M.path),\n        };\n        var specifiers = [];\n        for (var i = 0; i < M.aliases.length; i++) {\n            specifiers.push(set_moz_loc({\n                start: M.keys[i].start,\n                end: M.aliases[i].end,\n            }, {\n                type: "ExportSpecifier",\n                local: to_moz_alias(M.keys[i]),\n                exported: to_moz_alias(M.aliases[i]),\n            }));\n        }\n        return {\n            type: "ExportNamedDeclaration",\n            specifiers: specifiers,\n            source: to_moz(M.path),\n        };\n    });\n\n    def_to_moz(AST_ExportReferences, function To_Moz_ExportNamedDeclaration_specifiers(M) {\n        return {\n            type: "ExportNamedDeclaration",\n            specifiers: M.properties.map(function(prop) {\n                return set_moz_loc({\n                    start: prop.start,\n                    end: prop.alias.end,\n                }, {\n                    type: "ExportSpecifier",\n                    local: to_moz(prop),\n                    exported: to_moz_alias(prop.alias),\n                });\n            }),\n        };\n    });\n\n    def_to_moz(AST_Import, function To_Moz_ImportDeclaration(M) {\n        var specifiers = M.properties ? M.properties.map(function(prop) {\n            return set_moz_loc({\n                start: prop.key.start,\n                end: prop.end,\n            }, {\n                type: "ImportSpecifier",\n                local: to_moz(prop),\n                imported: to_moz_alias(prop.key),\n            });\n        }) : [];\n        if (M.all) specifiers.unshift(set_moz_loc(M.all, {\n            type: "ImportNamespaceSpecifier",\n            local: to_moz(M.all),\n        }));\n        if (M.default) specifiers.unshift(set_moz_loc(M.default, {\n            type: "ImportDefaultSpecifier",\n            local: to_moz(M.default),\n        }));\n        return {\n            type: "ImportDeclaration",\n            specifiers: specifiers,\n            source: to_moz(M.path),\n        };\n    });\n\n    def_to_moz(AST_Definitions, function To_Moz_VariableDeclaration(M) {\n        return {\n            type: "VariableDeclaration",\n            kind: M.TYPE.toLowerCase(),\n            declarations: M.definitions.map(to_moz),\n        };\n    });\n\n    def_to_moz(AST_PropAccess, function To_Moz_MemberExpression(M) {\n        var computed = M instanceof AST_Sub;\n        var expr = {\n            type: "MemberExpression",\n            object: to_moz(M.expression),\n            computed: computed,\n            optional: M.optional,\n            property: computed ? to_moz(M.property) : {\n                type: "Identifier",\n                name: M.property,\n            },\n        };\n        return M.terminal ? {\n            type: "ChainExpression",\n            expression: expr,\n        } : expr;\n    });\n\n    def_to_moz(AST_Unary, function To_Moz_Unary(M) {\n        return {\n            type: M.operator == "++" || M.operator == "--" ? "UpdateExpression" : "UnaryExpression",\n            operator: M.operator,\n            prefix: M instanceof AST_UnaryPrefix,\n            argument: to_moz(M.expression)\n        };\n    });\n\n    def_to_moz(AST_Binary, function To_Moz_BinaryExpression(M) {\n        return {\n            type: M.operator == "&&" || M.operator == "||" ? "LogicalExpression" : "BinaryExpression",\n            left: to_moz(M.left),\n            operator: M.operator,\n            right: to_moz(M.right)\n        };\n    });\n\n    def_to_moz(AST_Array, function To_Moz_ArrayExpression(M) {\n        return {\n            type: "ArrayExpression",\n            elements: M.elements.map(to_moz),\n        };\n    });\n\n    def_to_moz(AST_DestructuredArray, function To_Moz_ArrayPattern(M) {\n        var elements = M.elements.map(to_moz);\n        if (M.rest) elements.push({\n            type: "RestElement",\n            argument: to_moz(M.rest),\n        });\n        return {\n            type: "ArrayPattern",\n            elements: elements,\n        };\n    });\n\n    def_to_moz(AST_DestructuredKeyVal, function To_Moz_Property(M) {\n        var computed = M.key instanceof AST_Node;\n        var key = computed ? to_moz(M.key) : {\n            type: "Literal",\n            value: M.key,\n        };\n        return {\n            type: "Property",\n            kind: "init",\n            computed: computed,\n            method: false,\n            shorthand: false,\n            key: key,\n            value: to_moz(M.value),\n        };\n    });\n\n    def_to_moz(AST_DestructuredObject, function To_Moz_ObjectPattern(M) {\n        var props = M.properties.map(to_moz);\n        if (M.rest) props.push({\n            type: "RestElement",\n            argument: to_moz(M.rest),\n        });\n        return {\n            type: "ObjectPattern",\n            properties: props,\n        };\n    });\n\n    def_to_moz(AST_ObjectProperty, function To_Moz_Property(M) {\n        var computed = M.key instanceof AST_Node;\n        var key = computed ? to_moz(M.key) : {\n            type: "Literal",\n            value: M.key,\n        };\n        var kind;\n        if (M instanceof AST_ObjectKeyVal) {\n            kind = "init";\n        } else if (M instanceof AST_ObjectGetter) {\n            kind = "get";\n        } else if (M instanceof AST_ObjectSetter) {\n            kind = "set";\n        }\n        return {\n            type: "Property",\n            kind: kind,\n            computed: computed,\n            method: M instanceof AST_ObjectMethod,\n            shorthand: false,\n            key: key,\n            value: to_moz(M.value),\n        };\n    });\n\n    def_to_moz(AST_Symbol, function To_Moz_Identifier(M) {\n        var def = M.definition();\n        return {\n            type: "Identifier",\n            name: def && def.mangled_name || M.name,\n        };\n    });\n\n    def_to_moz(AST_Super, function To_Moz_Super() {\n        return { type: "Super" };\n    });\n\n    def_to_moz(AST_This, function To_Moz_ThisExpression() {\n        return { type: "ThisExpression" };\n    });\n\n    def_to_moz(AST_NewTarget, function To_Moz_MetaProperty() {\n        return {\n            type: "MetaProperty",\n            meta: {\n                type: "Identifier",\n                name: "new",\n            },\n            property: {\n                type: "Identifier",\n                name: "target",\n            },\n        };\n    });\n\n    def_to_moz(AST_RegExp, function To_Moz_RegExpLiteral(M) {\n        var flags = M.value.toString().match(/\\/([gimuy]*)$/)[1];\n        var value = "/" + M.value.raw_source + "/" + flags;\n        return {\n            type: "Literal",\n            value: value,\n            raw: value,\n            regex: {\n                pattern: M.value.raw_source,\n                flags: flags,\n            },\n        };\n    });\n\n    def_to_moz(AST_BigInt, function To_Moz_BigInt(M) {\n        var value = M.value;\n        return {\n            type: "Literal",\n            bigint: value,\n            raw: value + "n",\n        };\n    });\n\n    function To_Moz_Literal(M) {\n        var value = M.value;\n        if (typeof value === "number" && (value < 0 || (value === 0 && 1 / value < 0))) {\n            return {\n                type: "UnaryExpression",\n                operator: "-",\n                prefix: true,\n                argument: {\n                    type: "Literal",\n                    value: -value,\n                    raw: M.start.raw,\n                },\n            };\n        }\n        return {\n            type: "Literal",\n            value: value,\n            raw: M.start.raw,\n        };\n    }\n    def_to_moz(AST_Boolean, To_Moz_Literal);\n    def_to_moz(AST_Constant, To_Moz_Literal);\n    def_to_moz(AST_Null, To_Moz_Literal);\n\n    def_to_moz(AST_Atom, function To_Moz_Atom(M) {\n        return {\n            type: "Identifier",\n            name: String(M.value),\n        };\n    });\n\n    def_to_moz(AST_Template, function To_Moz_TemplateLiteral_TaggedTemplateExpression(M) {\n        var last = M.strings.length - 1;\n        var tmpl = {\n            type: "TemplateLiteral",\n            expressions: M.expressions.map(to_moz),\n            quasis: M.strings.map(function(str, index) {\n                return {\n                    type: "TemplateElement",\n                    tail: index == last,\n                    value: { raw: str },\n                };\n            }),\n        };\n        if (!M.tag) return tmpl;\n        return {\n            type: "TaggedTemplateExpression",\n            tag: to_moz(M.tag),\n            quasi: tmpl,\n        };\n    });\n\n    AST_Block.DEFMETHOD("to_mozilla_ast", AST_BlockStatement.prototype.to_mozilla_ast);\n    AST_Hole.DEFMETHOD("to_mozilla_ast", return_null);\n    AST_Node.DEFMETHOD("to_mozilla_ast", function() {\n        throw new Error("Cannot convert AST_" + this.TYPE);\n    });\n\n    /* -----[ tools ]----- */\n\n    function normalize_directives(body) {\n        for (var i = 0; i < body.length; i++) {\n            var stat = body[i];\n            if (!(stat instanceof AST_SimpleStatement)) break;\n            var node = stat.body;\n            if (!(node instanceof AST_String)) break;\n            if (stat.start.pos !== node.start.pos) break;\n            body[i] = new AST_Directive(node);\n        }\n        return body;\n    }\n\n    function raw_token(moznode) {\n        if (moznode.type == "Literal") {\n            return moznode.raw != null ? moznode.raw : moznode.value + "";\n        }\n    }\n\n    function my_start_token(moznode) {\n        var loc = moznode.loc, start = loc && loc.start;\n        var range = moznode.range;\n        return new AST_Token({\n            file    : loc && loc.source,\n            line    : start && start.line,\n            col     : start && start.column,\n            pos     : range ? range[0] : moznode.start,\n            endline : start && start.line,\n            endcol  : start && start.column,\n            endpos  : range ? range[0] : moznode.start,\n            raw     : raw_token(moznode),\n        });\n    }\n\n    function my_end_token(moznode) {\n        var loc = moznode.loc, end = loc && loc.end;\n        var range = moznode.range;\n        return new AST_Token({\n            file    : loc && loc.source,\n            line    : end && end.line,\n            col     : end && end.column,\n            pos     : range ? range[1] : moznode.end,\n            endline : end && end.line,\n            endcol  : end && end.column,\n            endpos  : range ? range[1] : moznode.end,\n            raw     : raw_token(moznode),\n        });\n    }\n\n    function read_name(M) {\n        return "" + M[M.type == "Identifier" ? "name" : "value"];\n    }\n\n    function map(moztype, mytype, propmap) {\n        var moz_to_me = [\n            "start: my_start_token(M)",\n            "end: my_end_token(M)",\n        ];\n        var me_to_moz = [\n            "type: " + JSON.stringify(moztype),\n        ];\n\n        if (propmap) propmap.split(/\\s*,\\s*/).forEach(function(prop) {\n            var m = /([a-z0-9$_]+)(=|@|>|%)([a-z0-9$_]+)/i.exec(prop);\n            if (!m) throw new Error("Can\'t understand property map: " + prop);\n            var moz = m[1], how = m[2], my = m[3];\n            switch (how) {\n              case "@":\n                moz_to_me.push(my + ": M." + moz + ".map(from_moz)");\n                me_to_moz.push(moz + ": M." +  my + ".map(to_moz)");\n                break;\n              case ">":\n                moz_to_me.push(my + ": from_moz(M." + moz + ")");\n                me_to_moz.push(moz + ": to_moz(M." + my + ")");\n                break;\n              case "=":\n                moz_to_me.push(my + ": M." + moz);\n                me_to_moz.push(moz + ": M." + my);\n                break;\n              case "%":\n                moz_to_me.push(my + ": from_moz(M." + moz + ").body");\n                me_to_moz.push(moz + ": to_moz_block(M)");\n                break;\n              default:\n                throw new Error("Can\'t understand operator in propmap: " + prop);\n            }\n        });\n\n        MOZ_TO_ME[moztype] = new Function("U2", "my_start_token", "my_end_token", "from_moz", [\n            "return function From_Moz_" + moztype + "(M) {",\n            "    return new U2.AST_" + mytype.TYPE + "({",\n            moz_to_me.join(",\\n"),\n            "    });",\n            "};",\n        ].join("\\n"))(exports, my_start_token, my_end_token, from_moz);\n        def_to_moz(mytype, new Function("to_moz", "to_moz_block", "to_moz_scope", [\n            "return function To_Moz_" + moztype + "(M) {",\n            "    return {",\n            me_to_moz.join(",\\n"),\n            "    };",\n            "};",\n        ].join("\\n"))(to_moz, to_moz_block, to_moz_scope));\n    }\n\n    var FROM_MOZ_STACK = null;\n\n    function from_moz(moz) {\n        FROM_MOZ_STACK.push(moz);\n        var node = null;\n        if (moz) {\n            if (!HOP(MOZ_TO_ME, moz.type)) throw new Error("Unsupported type: " + moz.type);\n            node = MOZ_TO_ME[moz.type](moz);\n        }\n        FROM_MOZ_STACK.pop();\n        return node;\n    }\n\n    function from_moz_alias(moz) {\n        return new AST_String({\n            start: my_start_token(moz),\n            value: read_name(moz),\n            end: my_end_token(moz),\n        });\n    }\n\n    AST_Node.from_mozilla_ast = function(node) {\n        var save_stack = FROM_MOZ_STACK;\n        FROM_MOZ_STACK = [];\n        var ast = from_moz(node);\n        FROM_MOZ_STACK = save_stack;\n        ast.walk(new TreeWalker(function(node) {\n            if (node instanceof AST_LabelRef) {\n                for (var level = 0, parent; parent = this.parent(level); level++) {\n                    if (parent instanceof AST_Scope) break;\n                    if (parent instanceof AST_LabeledStatement && parent.label.name == node.name) {\n                        node.thedef = parent.label;\n                        break;\n                    }\n                }\n                if (!node.thedef) {\n                    var s = node.start;\n                    js_error("Undefined label " + node.name, s.file, s.line, s.col, s.pos);\n                }\n            }\n        }));\n        return ast;\n    };\n\n    function set_moz_loc(mynode, moznode) {\n        var start = mynode.start;\n        var end = mynode.end;\n        if (start.pos != null && end.endpos != null) {\n            moznode.range = [start.pos, end.endpos];\n        }\n        if (start.line) {\n            moznode.loc = {\n                start: {line: start.line, column: start.col},\n                end: end.endline ? {line: end.endline, column: end.endcol} : null,\n            };\n            if (start.file) {\n                moznode.loc.source = start.file;\n            }\n        }\n        return moznode;\n    }\n\n    function def_to_moz(mytype, handler) {\n        mytype.DEFMETHOD("to_mozilla_ast", function() {\n            return set_moz_loc(this, handler(this));\n        });\n    }\n\n    function to_moz(node) {\n        return node != null ? node.to_mozilla_ast() : null;\n    }\n\n    function to_moz_alias(alias) {\n        return is_identifier_string(alias.value) ? set_moz_loc(alias, {\n            type: "Identifier",\n            name: alias.value,\n        }) : to_moz(alias);\n    }\n\n    function to_moz_block(node) {\n        return {\n            type: "BlockStatement",\n            body: node.body.map(to_moz),\n        };\n    }\n\n    function to_moz_scope(type, node) {\n        var body = node.body.map(to_moz);\n        if (node.body[0] instanceof AST_SimpleStatement && node.body[0].body instanceof AST_String) {\n            body.unshift(to_moz(new AST_EmptyStatement(node.body[0])));\n        }\n        return {\n            type: type,\n            body: body,\n        };\n    }\n})();\n'},94087:(e,t,r)=>{"use strict";r.d(t,{Z:()=>n});const n='/***********************************************************************\n\n  A JavaScript tokenizer / parser / beautifier / compressor.\n  https://github.com/mishoo/UglifyJS\n\n  -------------------------------- (C) ---------------------------------\n\n                           Author: Mihai Bazon\n                         <mihai.bazon@gmail.com>\n                       http://mihai.bazon.net/blog\n\n  Distributed under the BSD license:\n\n    Copyright 2012 (c) Mihai Bazon <mihai.bazon@gmail.com>\n\n    Redistribution and use in source and binary forms, with or without\n    modification, are permitted provided that the following conditions\n    are met:\n\n        * Redistributions of source code must retain the above\n          copyright notice, this list of conditions and the following\n          disclaimer.\n\n        * Redistributions in binary form must reproduce the above\n          copyright notice, this list of conditions and the following\n          disclaimer in the documentation and/or other materials\n          provided with the distribution.\n\n    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY\n    EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE\n    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,\n    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR\n    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF\n    THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n    SUCH DAMAGE.\n\n ***********************************************************************/\n\n"use strict";\n\nfunction is_some_comments(comment) {\n    // multiline comment\n    return comment.type == "comment2" && /@preserve|@license|@cc_on/i.test(comment.value);\n}\n\nfunction OutputStream(options) {\n    options = defaults(options, {\n        annotations      : false,\n        ascii_only       : false,\n        beautify         : false,\n        braces           : false,\n        comments         : false,\n        extendscript     : false,\n        galio            : false,\n        ie               : false,\n        indent_level     : 4,\n        indent_start     : 0,\n        inline_script    : true,\n        keep_quoted_props: false,\n        max_line_len     : false,\n        module           : false,\n        preamble         : null,\n        preserve_line    : false,\n        quote_keys       : false,\n        quote_style      : 0,\n        semicolons       : true,\n        shebang          : true,\n        source_map       : null,\n        v8               : false,\n        webkit           : false,\n        width            : 80,\n        wrap_iife        : false,\n    }, true);\n\n    // Convert comment option to RegExp if necessary and set up comments filter\n    var comment_filter = return_false; // Default case, throw all comments away\n    if (options.comments) {\n        var comments = options.comments;\n        if (typeof options.comments === "string" && /^\\/.*\\/[a-zA-Z]*$/.test(options.comments)) {\n            var regex_pos = options.comments.lastIndexOf("/");\n            comments = new RegExp(\n                options.comments.substr(1, regex_pos - 1),\n                options.comments.substr(regex_pos + 1)\n            );\n        }\n        if (comments instanceof RegExp) {\n            comment_filter = function(comment) {\n                return comment.type != "comment5" && comments.test(comment.value);\n            };\n        } else if (typeof comments === "function") {\n            comment_filter = function(comment) {\n                return comment.type != "comment5" && comments(this, comment);\n            };\n        } else if (comments === "some") {\n            comment_filter = is_some_comments;\n        } else { // NOTE includes "all" option\n            comment_filter = return_true;\n        }\n    }\n\n    function make_indent(value) {\n        if (typeof value == "number") return new Array(value + 1).join(" ");\n        if (!value) return "";\n        if (!/^\\s*$/.test(value)) throw new Error("unsupported indentation: " + JSON.stringify("" + value));\n        return value;\n    }\n\n    var current_col = 0;\n    var current_line = 1;\n    var current_indent = make_indent(options.indent_start);\n    var full_indent = make_indent(options.indent_level);\n    var half_indent = full_indent.length + 1 >> 1;\n    var last;\n    var line_end = 0;\n    var line_fixed = true;\n    var mappings = options.source_map && [];\n    var mapping_name;\n    var mapping_token;\n    var might_need_space;\n    var might_need_semicolon;\n    var need_newline_indented = false;\n    var need_space = false;\n    var output;\n    var stack;\n    var stored = "";\n\n    function reset() {\n        last = "";\n        might_need_space = false;\n        might_need_semicolon = false;\n        stack = [];\n        var str = output;\n        output = "";\n        return str;\n    }\n\n    reset();\n    var to_utf8 = options.ascii_only ? function(str, identifier) {\n        if (identifier || options.module) str = str.replace(/[\\ud800-\\udbff][\\udc00-\\udfff]/g, function(ch) {\n            return "\\\\u{" + (ch.charCodeAt(0) - 0xd7c0 << 10 | ch.charCodeAt(1) - 0xdc00).toString(16) + "}";\n        });\n        return str.replace(/[\\u0000-\\u001f\\u007f-\\uffff]/g, function(s, i) {\n            var code = s.charCodeAt(0).toString(16);\n            if (code.length <= 2 && !identifier) {\n                switch (s) {\n                  case "\\n": return "\\\\n";\n                  case "\\r": return "\\\\r";\n                  case "\\t": return "\\\\t";\n                  case "\\b": return "\\\\b";\n                  case "\\f": return "\\\\f";\n                  case "\\x0B": return options.ie ? "\\\\x0B" : "\\\\v";\n                  case "\\0":\n                    return /[0-9]/.test(str.charAt(i+1)) ? "\\\\x00" : "\\\\0";\n                }\n                while (code.length < 2) code = "0" + code;\n                return "\\\\x" + code;\n            } else {\n                while (code.length < 4) code = "0" + code;\n                return "\\\\u" + code;\n            }\n        });\n    } : function(str) {\n        var s = "";\n        for (var i = 0, j = 0; i < str.length; i++) {\n            var code = str.charCodeAt(i);\n            if (is_surrogate_pair_head(code)) {\n                if (is_surrogate_pair_tail(str.charCodeAt(i + 1))) {\n                    i++;\n                    continue;\n                }\n            } else if (!is_surrogate_pair_tail(code)) {\n                continue;\n            }\n            s += str.slice(j, i) + "\\\\u" + code.toString(16);\n            j = i + 1;\n        }\n        return j == 0 ? str : s + str.slice(j);\n    };\n\n    function quote_single(str) {\n        return "\'" + str.replace(/\\x27/g, "\\\\\'") + "\'";\n    }\n\n    function quote_double(str) {\n        return \'"\' + str.replace(/\\x22/g, \'\\\\"\') + \'"\';\n    }\n\n    var quote_string = [\n        null,\n        quote_single,\n        quote_double,\n        function(str, quote) {\n            return quote == "\'" ? quote_single(str) : quote_double(str);\n        },\n    ][options.quote_style] || function(str, quote, dq, sq) {\n        return dq > sq ? quote_single(str) : quote_double(str);\n    };\n\n    function make_string(str, quote) {\n        var dq = 0, sq = 0;\n        str = str.replace(/[\\\\\\b\\f\\n\\r\\v\\t\\x22\\x27\\u2028\\u2029\\0\\ufeff]/g, function(s, i) {\n            switch (s) {\n              case \'"\': ++dq; return \'"\';\n              case "\'": ++sq; return "\'";\n              case "\\\\": return "\\\\\\\\";\n              case "\\n": return "\\\\n";\n              case "\\r": return "\\\\r";\n              case "\\t": return "\\\\t";\n              case "\\b": return "\\\\b";\n              case "\\f": return "\\\\f";\n              case "\\x0B": return options.ie ? "\\\\x0B" : "\\\\v";\n              case "\\u2028": return "\\\\u2028";\n              case "\\u2029": return "\\\\u2029";\n              case "\\ufeff": return "\\\\ufeff";\n              case "\\0":\n                  return /[0-9]/.test(str.charAt(i+1)) ? "\\\\x00" : "\\\\0";\n            }\n            return s;\n        });\n        return quote_string(to_utf8(str), quote, dq, sq);\n    }\n\n    /* -----[ beautification/minification ]----- */\n\n    var adjust_mappings = mappings ? function(line, col) {\n        mappings.forEach(function(mapping) {\n            mapping.line += line;\n            mapping.col += col;\n        });\n    } : noop;\n\n    var flush_mappings = mappings ? function() {\n        mappings.forEach(function(mapping) {\n            options.source_map.add(\n                mapping.token.file,\n                mapping.line, mapping.col,\n                mapping.token.line, mapping.token.col,\n                !mapping.name && mapping.token.type == "name" ? mapping.token.value : mapping.name\n            );\n        });\n        mappings = [];\n    } : noop;\n\n    function insert_newlines(count) {\n        stored += output.slice(0, line_end);\n        output = output.slice(line_end);\n        var new_col = output.length;\n        adjust_mappings(count, new_col - current_col);\n        current_line += count;\n        current_col = new_col;\n        while (count--) stored += "\\n";\n    }\n\n    var fix_line = options.max_line_len ? function(flush) {\n        if (line_fixed) {\n            if (current_col > options.max_line_len) {\n                AST_Node.warn("Output exceeds {max_line_len} characters", options);\n            }\n            return;\n        }\n        if (current_col > options.max_line_len) {\n            insert_newlines(1);\n            line_fixed = true;\n        }\n        if (line_fixed || flush) flush_mappings();\n    } : noop;\n\n    var stat_end_chars = makePredicate("; }");\n    var asi_skip_chars = makePredicate("( [ + * / - , . `");\n    var asi_skip_words = makePredicate("in instanceof");\n\n    function require_space(prev, ch, str) {\n        return is_identifier_char(prev) && (is_identifier_char(ch) || ch == "\\\\")\n            || (ch == "/" && ch == prev)\n            || ((ch == "+" || ch == "-") && ch == last)\n            || last == "--" && ch == ">"\n            || last == "!" && str == "--"\n            || prev == "/" && (str == "in" || str == "instanceof");\n    }\n\n    var print = options.beautify\n        || options.comments\n        || options.max_line_len\n        || options.preserve_line\n        || options.shebang\n        || !options.semicolons\n        || options.source_map\n        || options.width ? function(str) {\n        var ch = str.charAt(0);\n        if (need_newline_indented && ch) {\n            need_newline_indented = false;\n            if (ch != "\\n") {\n                print("\\n");\n                indent();\n            }\n        }\n        if (need_space && ch) {\n            need_space = false;\n            if (!/[\\s;})]/.test(ch)) {\n                space();\n            }\n        }\n        var prev = last.slice(-1);\n        if (might_need_semicolon) {\n            might_need_semicolon = false;\n            if (prev != ";" && !stat_end_chars[ch]) {\n                var need_semicolon = asi_skip_chars[ch] || asi_skip_words[str];\n                if (need_semicolon || options.semicolons) {\n                    output += ";";\n                    current_col++;\n                    if (!line_fixed) {\n                        fix_line();\n                        if (line_fixed && !need_semicolon && output == ";") {\n                            output = "";\n                            current_col = 0;\n                        }\n                    }\n                    if (line_end == output.length - 1) line_end++;\n                } else {\n                    fix_line();\n                    output += "\\n";\n                    current_line++;\n                    current_col = 0;\n                    // reset the semicolon flag, since we didn\'t print one\n                    // now and might still have to later\n                    if (/^\\s+$/.test(str)) might_need_semicolon = true;\n                }\n                if (!options.beautify) might_need_space = false;\n            }\n        }\n\n        if (might_need_space) {\n            if (require_space(prev, ch, str)) {\n                output += " ";\n                current_col++;\n            }\n            if (prev != "<" || str != "!") might_need_space = false;\n        }\n\n        if (mapping_token) {\n            mappings.push({\n                token: mapping_token,\n                name: mapping_name,\n                line: current_line,\n                col: current_col,\n            });\n            mapping_token = false;\n            if (line_fixed) flush_mappings();\n        }\n\n        output += str;\n        var a = str.split(/\\r?\\n/), n = a.length - 1;\n        current_line += n;\n        current_col += a[0].length;\n        if (n > 0) {\n            fix_line();\n            current_col = a[n].length;\n        }\n        last = str;\n    } : function(str) {\n        var ch = str.charAt(0);\n        var prev = last.slice(-1);\n        if (might_need_semicolon) {\n            might_need_semicolon = false;\n            if (prev == ":" && ch == "}" || (!ch || ";}".indexOf(ch) < 0) && prev != ";") {\n                output += ";";\n                might_need_space = false;\n            }\n        }\n        if (might_need_space) {\n            if (require_space(prev, ch, str)) output += " ";\n            if (prev != "<" || str != "!") might_need_space = false;\n        }\n        output += str;\n        last = str;\n    };\n\n    var space = options.beautify ? function() {\n        print(" ");\n    } : function() {\n        might_need_space = true;\n    };\n\n    var indent = options.beautify ? function(half) {\n        if (need_newline_indented) print("\\n");\n        print(half ? current_indent.slice(0, -half_indent) : current_indent);\n    } : noop;\n\n    var with_indent = options.beautify ? function(cont) {\n        var save_indentation = current_indent;\n        current_indent += full_indent;\n        cont();\n        current_indent = save_indentation;\n    } : function(cont) { cont() };\n\n    var may_add_newline = options.max_line_len || options.preserve_line ? function() {\n        fix_line();\n        line_end = output.length;\n        line_fixed = false;\n    } : noop;\n\n    var newline = options.beautify ? function() {\n        print("\\n");\n        line_end = output.length;\n    } : may_add_newline;\n\n    var semicolon = options.beautify ? function() {\n        print(";");\n    } : function() {\n        might_need_semicolon = true;\n    };\n\n    function force_semicolon() {\n        if (might_need_semicolon) print(";");\n        print(";");\n    }\n\n    function with_block(cont, end) {\n        print("{");\n        newline();\n        with_indent(cont);\n        add_mapping(end);\n        indent();\n        print("}");\n    }\n\n    function with_parens(cont) {\n        print("(");\n        may_add_newline();\n        cont();\n        may_add_newline();\n        print(")");\n    }\n\n    function with_square(cont) {\n        print("[");\n        may_add_newline();\n        cont();\n        may_add_newline();\n        print("]");\n    }\n\n    function comma() {\n        may_add_newline();\n        print(",");\n        may_add_newline();\n        space();\n    }\n\n    function colon() {\n        print(":");\n        space();\n    }\n\n    var add_mapping = mappings ? function(token, name) {\n        mapping_token = token;\n        mapping_name = name;\n    } : noop;\n\n    function get() {\n        if (!line_fixed) fix_line(true);\n        return stored + output;\n    }\n\n    function has_nlb() {\n        return /(^|\\n) *$/.test(output);\n    }\n\n    function pad_comment(token, force) {\n        if (need_newline_indented) return;\n        if (token.nlb && (force || !has_nlb())) {\n            need_newline_indented = true;\n        } else if (force) {\n            need_space = true;\n        }\n    }\n\n    function print_comment(comment) {\n        var value = comment.value.replace(/[@#]__PURE__/g, " ");\n        if (/^\\s*$/.test(value) && !/^\\s*$/.test(comment.value)) return false;\n        if (/comment[134]/.test(comment.type)) {\n            print("//" + value);\n            need_newline_indented = true;\n        } else if (comment.type == "comment2") {\n            print("/*" + value + "*/");\n        }\n        return true;\n    }\n\n    function should_merge_comments(node, parent) {\n        if (parent instanceof AST_Binary) return parent.left === node;\n        if (parent.TYPE == "Call") return parent.expression === node;\n        if (parent instanceof AST_Conditional) return parent.condition === node;\n        if (parent instanceof AST_Dot) return parent.expression === node;\n        if (parent instanceof AST_Exit) return true;\n        if (parent instanceof AST_Sequence) return parent.expressions[0] === node;\n        if (parent instanceof AST_Sub) return parent.expression === node;\n        if (parent instanceof AST_UnaryPostfix) return true;\n        if (parent instanceof AST_Yield) return true;\n    }\n\n    function prepend_comments(node) {\n        var self = this;\n        var scan;\n        if (node instanceof AST_Exit) {\n            scan = node.value;\n        } else if (node instanceof AST_Yield) {\n            scan = node.expression;\n        }\n        var comments = dump(node);\n        if (!comments) comments = [];\n\n        if (scan) {\n            var tw = new TreeWalker(function(node) {\n                if (!should_merge_comments(node, tw.parent())) return true;\n                var before = dump(node);\n                if (before) comments = comments.concat(before);\n            });\n            tw.push(node);\n            scan.walk(tw);\n        }\n\n        if (current_line == 1 && current_col == 0) {\n            if (comments.length > 0 && options.shebang && comments[0].type == "comment5") {\n                print("#!" + comments.shift().value + "\\n");\n                indent();\n            }\n            var preamble = options.preamble;\n            if (preamble) print(preamble.replace(/\\r\\n?|\\u2028|\\u2029|(^|\\S)\\s*$/g, "$1\\n"));\n        }\n\n        comments = comments.filter(comment_filter, node);\n        var printed = false;\n        comments.forEach(function(comment, index) {\n            pad_comment(comment, index);\n            if (print_comment(comment)) printed = true;\n        });\n        if (printed) pad_comment(node.start, true);\n\n        function dump(node) {\n            var token = node.start;\n            if (!token) {\n                if (!scan) return;\n                node.start = token = new AST_Token();\n            }\n            var comments = token.comments_before;\n            if (!comments) {\n                if (!scan) return;\n                token.comments_before = comments = [];\n            }\n            if (comments._dumped === self) return;\n            comments._dumped = self;\n            return comments;\n        }\n    }\n\n    function append_comments(node, tail) {\n        var self = this;\n        var token = node.end;\n        if (!token) return;\n        var comments = token[tail ? "comments_before" : "comments_after"];\n        if (!comments || comments._dumped === self) return;\n        if (!(node instanceof AST_Statement || all(comments, function(c) {\n            return !/comment[134]/.test(c.type);\n        }))) return;\n        comments._dumped = self;\n        comments.filter(comment_filter, node).forEach(function(comment, index) {\n            pad_comment(comment, index || !tail);\n            print_comment(comment);\n        });\n    }\n\n    return {\n        get             : get,\n        reset           : reset,\n        indent          : indent,\n        should_break    : options.beautify && options.width ? function() {\n            return current_col >= options.width;\n        } : return_false,\n        has_parens      : function() { return last.slice(-1) == "(" },\n        newline         : newline,\n        print           : print,\n        space           : space,\n        comma           : comma,\n        colon           : colon,\n        last            : function() { return last },\n        semicolon       : semicolon,\n        force_semicolon : force_semicolon,\n        to_utf8         : to_utf8,\n        print_name      : function(name) { print(to_utf8(name.toString(), true)) },\n        print_string    : options.inline_script ? function(str, quote) {\n            str = make_string(str, quote).replace(/<\\x2f(script)([>\\/\\t\\n\\f\\r ])/gi, "<\\\\/$1$2");\n            print(str.replace(/\\x3c!--/g, "\\\\x3c!--").replace(/--\\x3e/g, "--\\\\x3e"));\n        } : function(str, quote) {\n            print(make_string(str, quote));\n        },\n        with_indent     : with_indent,\n        with_block      : with_block,\n        with_parens     : with_parens,\n        with_square     : with_square,\n        add_mapping     : add_mapping,\n        option          : function(opt) { return options[opt] },\n        prepend_comments: options.comments || options.shebang ? prepend_comments : noop,\n        append_comments : options.comments ? append_comments : noop,\n        push_node       : function(node) { stack.push(node) },\n        pop_node        : options.preserve_line ? function() {\n            var node = stack.pop();\n            if (node.start && node.start.line > current_line) {\n                insert_newlines(node.start.line - current_line);\n            }\n        } : function() {\n            stack.pop();\n        },\n        parent          : function(n) {\n            return stack[stack.length - 2 - (n || 0)];\n        },\n    };\n}\n\n/* -----[ code generators ]----- */\n\n(function() {\n\n    /* -----[ utils ]----- */\n\n    function DEFPRINT(nodetype, generator) {\n        nodetype.DEFMETHOD("_codegen", generator);\n    }\n\n    var use_asm = false;\n\n    AST_Node.DEFMETHOD("print", function(stream, force_parens) {\n        var self = this;\n        stream.push_node(self);\n        if (force_parens || self.needs_parens(stream)) {\n            stream.with_parens(doit);\n        } else {\n            doit();\n        }\n        stream.pop_node();\n\n        function doit() {\n            stream.prepend_comments(self);\n            self.add_source_map(stream);\n            self._codegen(stream);\n            stream.append_comments(self);\n        }\n    });\n    var readonly = OutputStream({\n        inline_script: false,\n        shebang: false,\n        width: false,\n    });\n    AST_Node.DEFMETHOD("print_to_string", function(options) {\n        if (options) {\n            var stream = OutputStream(options);\n            this.print(stream);\n            return stream.get();\n        }\n        this.print(readonly);\n        return readonly.reset();\n    });\n\n    /* -----[ PARENTHESES ]----- */\n\n    function PARENS(nodetype, func) {\n        nodetype.DEFMETHOD("needs_parens", func);\n    }\n\n    PARENS(AST_Node, return_false);\n\n    // a function expression needs parens around it when it\'s provably\n    // the first token to appear in a statement.\n    function needs_parens_function(output) {\n        var p = output.parent();\n        if (!output.has_parens() && first_in_statement(output, false, true)) {\n            // export default function() {}\n            // export default (function foo() {});\n            // export default (function() {})(foo);\n            // export default (function() {})`foo`;\n            // export default (function() {}) ? foo : bar;\n            return this.name || !(p instanceof AST_ExportDefault);\n        }\n        if (output.option("webkit") && p instanceof AST_PropAccess && p.expression === this) return true;\n        if (output.option("wrap_iife") && p instanceof AST_Call && p.expression === this) return true;\n    }\n    PARENS(AST_AsyncFunction, needs_parens_function);\n    PARENS(AST_AsyncGeneratorFunction, needs_parens_function);\n    PARENS(AST_ClassExpression, needs_parens_function);\n    PARENS(AST_Function, needs_parens_function);\n    PARENS(AST_GeneratorFunction, needs_parens_function);\n\n    // same goes for an object literal, because otherwise it would be\n    // interpreted as a block of code.\n    function needs_parens_obj(output) {\n        return !output.has_parens() && first_in_statement(output, true);\n    }\n    PARENS(AST_Object, needs_parens_obj);\n\n    function needs_parens_unary(output) {\n        var p = output.parent();\n        // (-x) ** y\n        if (p instanceof AST_Binary) return p.operator == "**" && p.left === this;\n        // (await x)(y)\n        // new (await x)\n        if (p instanceof AST_Call) return p.expression === this;\n        // class extends (x++) {}\n        // class x extends (typeof y) {}\n        if (p instanceof AST_Class) return true;\n        // (x++)[y]\n        // (typeof x).y\n        // https://github.com/mishoo/UglifyJS/issues/115\n        if (p instanceof AST_PropAccess) return p.expression === this;\n        // (~x)`foo`\n        if (p instanceof AST_Template) return p.tag === this;\n    }\n    PARENS(AST_Await, needs_parens_unary);\n    PARENS(AST_Unary, needs_parens_unary);\n\n    PARENS(AST_Sequence, function(output) {\n        var p = output.parent();\n            // [ 1, (2, 3), 4 ] ---\x3e [ 1, 3, 4 ]\n        return p instanceof AST_Array\n            // () ---\x3e (foo, bar)\n            || is_arrow(p) && p.value === this\n            // await (foo, bar)\n            || p instanceof AST_Await\n            // 1 + (2, 3) + 4 ---\x3e 8\n            || p instanceof AST_Binary\n            // new (foo, bar) or foo(1, (2, 3), 4)\n            || p instanceof AST_Call\n            // class extends (foo, bar) {}\n            // class foo extends (bar, baz) {}\n            || p instanceof AST_Class\n            // class { foo = (bar, baz) }\n            // class { [(foo, bar)]() {} }\n            || p instanceof AST_ClassProperty\n            // (false, true) ? (a = 10, b = 20) : (c = 30)\n            // ---\x3e 20 (side effect, set a := 10 and b := 20)\n            || p instanceof AST_Conditional\n            // [ a = (1, 2) ] = [] ---\x3e a == 2\n            || p instanceof AST_DefaultValue\n            // { [(1, 2)]: foo } = bar\n            // { 1: (2, foo) } = bar\n            || p instanceof AST_DestructuredKeyVal\n            // export default (foo, bar)\n            || p instanceof AST_ExportDefault\n            // for (foo of (bar, baz));\n            || p instanceof AST_ForOf\n            // { [(1, 2)]: 3 }[2] ---\x3e 3\n            // { foo: (1, 2) }.foo ---\x3e 2\n            || p instanceof AST_ObjectProperty\n            // (1, {foo:2}).foo or (1, {foo:2})["foo"] ---\x3e 2\n            || p instanceof AST_PropAccess && p.expression === this\n            // ...(foo, bar, baz)\n            || p instanceof AST_Spread\n            // (foo, bar)`baz`\n            || p instanceof AST_Template && p.tag === this\n            // !(foo, bar, baz)\n            || p instanceof AST_Unary\n            // var a = (1, 2), b = a + a; ---\x3e b == 4\n            || p instanceof AST_VarDef\n            // yield (foo, bar)\n            || p instanceof AST_Yield;\n    });\n\n    PARENS(AST_Binary, function(output) {\n        var p = output.parent();\n        // await (foo && bar)\n        if (p instanceof AST_Await) return true;\n        // this deals with precedence:\n        //   3 * (2 + 1)\n        //   3 - (2 - 1)\n        //   (1 ** 2) ** 3\n        if (p instanceof AST_Binary) {\n            var po = p.operator, pp = PRECEDENCE[po];\n            var so = this.operator, sp = PRECEDENCE[so];\n            return pp > sp\n                || po == "??" && (so == "&&" || so == "||")\n                || (pp == sp && this === p[po == "**" ? "left" : "right"]);\n        }\n        // (foo && bar)()\n        if (p instanceof AST_Call) return p.expression === this;\n        // class extends (foo && bar) {}\n        // class foo extends (bar || null) {}\n        if (p instanceof AST_Class) return true;\n        // (foo && bar)["prop"], (foo && bar).prop\n        if (p instanceof AST_PropAccess) return p.expression === this;\n        // (foo && bar)``\n        if (p instanceof AST_Template) return p.tag === this;\n        // typeof (foo && bar)\n        if (p instanceof AST_Unary) return true;\n    });\n\n    function need_chain_parens(node, parent) {\n        if (!node.terminal) return false;\n        if (!(parent instanceof AST_Call || parent instanceof AST_PropAccess)) return false;\n        return parent.expression === node;\n    }\n\n    PARENS(AST_PropAccess, function(output) {\n        var node = this;\n        var p = output.parent();\n        // i.e. new (foo().bar)\n        //\n        // if there\'s one call into this subtree, then we need\n        // parens around it too, otherwise the call will be\n        // interpreted as passing the arguments to the upper New\n        // expression.\n        if (p instanceof AST_New && p.expression === node && root_expr(node).TYPE == "Call") return true;\n        // (foo?.bar)()\n        // (foo?.bar).baz\n        // new (foo?.bar)()\n        return need_chain_parens(node, p);\n    });\n\n    PARENS(AST_Call, function(output) {\n        var node = this;\n        var p = output.parent();\n        if (p instanceof AST_New) return p.expression === node;\n        // https://bugs.webkit.org/show_bug.cgi?id=123506\n        if (output.option("webkit")\n            && node.expression instanceof AST_Function\n            && p instanceof AST_PropAccess\n            && p.expression === node) {\n            var g = output.parent(1);\n            if (g instanceof AST_Assign && g.left === p) return true;\n        }\n        // (foo?.())()\n        // (foo?.()).bar\n        // new (foo?.())()\n        return need_chain_parens(node, p);\n    });\n\n    PARENS(AST_New, function(output) {\n        if (need_constructor_parens(this, output)) return false;\n        var p = output.parent();\n        // (new foo)(bar)\n        if (p instanceof AST_Call) return p.expression === this;\n        // (new Date).getTime(), (new Date)["getTime"]()\n        if (p instanceof AST_PropAccess) return true;\n        // (new foo)`bar`\n        if (p instanceof AST_Template) return p.tag === this;\n    });\n\n    PARENS(AST_Number, function(output) {\n        if (!output.option("galio")) return false;\n        // https://github.com/mishoo/UglifyJS/pull/1009\n        var p = output.parent();\n        return p instanceof AST_PropAccess && p.expression === this && /^0/.test(make_num(this.value));\n    });\n\n    function needs_parens_assign_cond(self, output) {\n        var p = output.parent();\n        // await (a = foo)\n        if (p instanceof AST_Await) return true;\n        // 1 + (a = 2) + 3 → 6, side effect setting a = 2\n        if (p instanceof AST_Binary) return !(p instanceof AST_Assign);\n        // (a = func)() —or— new (a = Object)()\n        if (p instanceof AST_Call) return p.expression === self;\n        // class extends (a = foo) {}\n        // class foo extends (bar ? baz : moo) {}\n        if (p instanceof AST_Class) return true;\n        // (a = foo) ? bar : baz\n        if (p instanceof AST_Conditional) return p.condition === self;\n        // (a = foo)["prop"] —or— (a = foo).prop\n        if (p instanceof AST_PropAccess) return p.expression === self;\n        // (a = foo)`bar`\n        if (p instanceof AST_Template) return p.tag === self;\n        // !(a = false) → true\n        if (p instanceof AST_Unary) return true;\n    }\n    PARENS(AST_Arrow, function(output) {\n        return needs_parens_assign_cond(this, output);\n    });\n    PARENS(AST_Assign, function(output) {\n        if (needs_parens_assign_cond(this, output)) return true;\n        //  v8 parser bug   ---\x3e     workaround\n        // f([1], [a] = []) ---\x3e f([1], ([a] = []))\n        if (output.option("v8")) return this.left instanceof AST_Destructured;\n        // ({ p: a } = o);\n        if (this.left instanceof AST_DestructuredObject) return needs_parens_obj(output);\n    });\n    PARENS(AST_AsyncArrow, function(output) {\n        return needs_parens_assign_cond(this, output);\n    });\n    PARENS(AST_Conditional, function(output) {\n        return needs_parens_assign_cond(this, output)\n            // https://github.com/mishoo/UglifyJS/issues/1144\n            || output.option("extendscript") && output.parent() instanceof AST_Conditional;\n    });\n    PARENS(AST_Yield, function(output) {\n        return needs_parens_assign_cond(this, output);\n    });\n\n    /* -----[ PRINTERS ]----- */\n\n    DEFPRINT(AST_Directive, function(output) {\n        var quote = this.quote;\n        var value = this.value;\n        switch (output.option("quote_style")) {\n          case 0:\n          case 2:\n            if (value.indexOf(\'"\') == -1) quote = \'"\';\n            break;\n          case 1:\n            if (value.indexOf("\'") == -1) quote = "\'";\n            break;\n        }\n        output.print(quote + value + quote);\n        output.semicolon();\n    });\n    DEFPRINT(AST_Debugger, function(output) {\n        output.print("debugger");\n        output.semicolon();\n    });\n\n    /* -----[ statements ]----- */\n\n    function display_body(body, is_toplevel, output, allow_directives) {\n        var last = body.length - 1;\n        var in_directive = allow_directives;\n        var was_asm = use_asm;\n        body.forEach(function(stmt, i) {\n            if (in_directive) {\n                if (stmt instanceof AST_Directive) {\n                    if (stmt.value == "use asm") use_asm = true;\n                } else if (!(stmt instanceof AST_EmptyStatement)) {\n                    if (stmt instanceof AST_SimpleStatement && stmt.body instanceof AST_String) {\n                        output.force_semicolon();\n                    }\n                    in_directive = false;\n                }\n            }\n            if (stmt instanceof AST_EmptyStatement) return;\n            output.indent();\n            stmt.print(output);\n            if (i == last && is_toplevel) return;\n            output.newline();\n            if (is_toplevel) output.newline();\n        });\n        use_asm = was_asm;\n    }\n\n    DEFPRINT(AST_Toplevel, function(output) {\n        display_body(this.body, true, output, true);\n        output.print("");\n    });\n    DEFPRINT(AST_LabeledStatement, function(output) {\n        this.label.print(output);\n        output.colon();\n        var body = this.body;\n        if (body instanceof AST_EmptyStatement) {\n            output.force_semicolon();\n        } else {\n            body.print(output);\n        }\n    });\n    DEFPRINT(AST_SimpleStatement, function(output) {\n        this.body.print(output);\n        output.semicolon();\n    });\n    function print_braced_empty(self, output) {\n        output.print("{");\n        output.with_indent(function() {\n            output.append_comments(self, true);\n        });\n        output.print("}");\n    }\n    function print_braced(self, output, allow_directives) {\n        if (self.body.length > 0) {\n            output.with_block(function() {\n                display_body(self.body, false, output, allow_directives);\n            }, self.end);\n        } else print_braced_empty(self, output);\n    }\n    DEFPRINT(AST_BlockStatement, function(output) {\n        print_braced(this, output);\n    });\n    DEFPRINT(AST_EmptyStatement, function(output) {\n        output.semicolon();\n    });\n    DEFPRINT(AST_Do, function(output) {\n        var self = this;\n        output.print("do");\n        make_block(self.body, output);\n        output.space();\n        output.print("while");\n        output.space();\n        output.with_parens(function() {\n            self.condition.print(output);\n        });\n        output.semicolon();\n    });\n    DEFPRINT(AST_While, function(output) {\n        var self = this;\n        output.print("while");\n        output.space();\n        output.with_parens(function() {\n            self.condition.print(output);\n        });\n        force_statement(self.body, output);\n    });\n    DEFPRINT(AST_For, function(output) {\n        var self = this;\n        output.print("for");\n        output.space();\n        output.with_parens(function() {\n            if (self.init) {\n                if (self.init instanceof AST_Definitions) {\n                    self.init.print(output);\n                } else {\n                    parenthesize_for_no_in(self.init, output, true);\n                }\n                output.print(";");\n                output.space();\n            } else {\n                output.print(";");\n            }\n            if (self.condition) {\n                self.condition.print(output);\n                output.print(";");\n                output.space();\n            } else {\n                output.print(";");\n            }\n            if (self.step) {\n                self.step.print(output);\n            }\n        });\n        force_statement(self.body, output);\n    });\n    function print_for_enum(prefix, infix) {\n        return function(output) {\n            var self = this;\n            output.print(prefix);\n            output.space();\n            output.with_parens(function() {\n                self.init.print(output);\n                output.space();\n                output.print(infix);\n                output.space();\n                self.object.print(output);\n            });\n            force_statement(self.body, output);\n        };\n    }\n    DEFPRINT(AST_ForAwaitOf, print_for_enum("for await", "of"));\n    DEFPRINT(AST_ForIn, print_for_enum("for", "in"));\n    DEFPRINT(AST_ForOf, print_for_enum("for", "of"));\n    DEFPRINT(AST_With, function(output) {\n        var self = this;\n        output.print("with");\n        output.space();\n        output.with_parens(function() {\n            self.expression.print(output);\n        });\n        force_statement(self.body, output);\n    });\n    DEFPRINT(AST_ExportDeclaration, function(output) {\n        output.print("export");\n        output.space();\n        this.body.print(output);\n    });\n    DEFPRINT(AST_ExportDefault, function(output) {\n        output.print("export");\n        output.space();\n        output.print("default");\n        output.space();\n        var body = this.body;\n        body.print(output);\n        if (body instanceof AST_ClassExpression) {\n            if (!body.name) return;\n        }\n        if (body instanceof AST_DefClass) return;\n        if (body instanceof AST_LambdaDefinition) return;\n        if (body instanceof AST_LambdaExpression) {\n            if (!body.name && !is_arrow(body)) return;\n        }\n        output.semicolon();\n    });\n    function print_alias(alias, output) {\n        var value = alias.value;\n        if (value == "*" || is_identifier_string(value)) {\n            output.print_name(value);\n        } else {\n            output.print_string(value, alias.quote);\n        }\n    }\n    DEFPRINT(AST_ExportForeign, function(output) {\n        var self = this;\n        output.print("export");\n        output.space();\n        var len = self.keys.length;\n        if (len == 0) {\n            print_braced_empty(self, output);\n        } else if (self.keys[0].value == "*") {\n            print_entry(0);\n        } else output.with_block(function() {\n            output.indent();\n            print_entry(0);\n            for (var i = 1; i < len; i++) {\n                output.print(",");\n                output.newline();\n                output.indent();\n                print_entry(i);\n            }\n            output.newline();\n        }, self.end);\n        output.space();\n        output.print("from");\n        output.space();\n        self.path.print(output);\n        output.semicolon();\n\n        function print_entry(index) {\n            var alias = self.aliases[index];\n            var key = self.keys[index];\n            print_alias(key, output);\n            if (alias.value != key.value) {\n                output.space();\n                output.print("as");\n                output.space();\n                print_alias(alias, output);\n            }\n        }\n    });\n    DEFPRINT(AST_ExportReferences, function(output) {\n        var self = this;\n        output.print("export");\n        output.space();\n        print_properties(self, output);\n        output.semicolon();\n    });\n    DEFPRINT(AST_Import, function(output) {\n        var self = this;\n        output.print("import");\n        output.space();\n        if (self.default) self.default.print(output);\n        if (self.all) {\n            if (self.default) output.comma();\n            self.all.print(output);\n        }\n        if (self.properties) {\n            if (self.default) output.comma();\n            print_properties(self, output);\n        }\n        if (self.all || self.default || self.properties) {\n            output.space();\n            output.print("from");\n            output.space();\n        }\n        self.path.print(output);\n        output.semicolon();\n    });\n\n    /* -----[ functions ]----- */\n    function print_funargs(self, output) {\n        output.with_parens(function() {\n            self.argnames.forEach(function(arg, i) {\n                if (i) output.comma();\n                arg.print(output);\n            });\n            if (self.rest) {\n                if (self.argnames.length) output.comma();\n                output.print("...");\n                self.rest.print(output);\n            }\n        });\n    }\n    function print_arrow(self, output) {\n        var argname = self.argnames.length == 1 && !self.rest && self.argnames[0];\n        if (argname instanceof AST_SymbolFunarg && argname.name != "yield") {\n            argname.print(output);\n        } else {\n            print_funargs(self, output);\n        }\n        output.space();\n        output.print("=>");\n        output.space();\n        if (self.value) {\n            self.value.print(output);\n        } else {\n            print_braced(self, output, true);\n        }\n    }\n    DEFPRINT(AST_Arrow, function(output) {\n        print_arrow(this, output);\n    });\n    DEFPRINT(AST_AsyncArrow, function(output) {\n        output.print("async");\n        output.space();\n        print_arrow(this, output);\n    });\n    function print_lambda(self, output) {\n        if (self.name) {\n            output.space();\n            self.name.print(output);\n        }\n        print_funargs(self, output);\n        output.space();\n        print_braced(self, output, true);\n    }\n    DEFPRINT(AST_Lambda, function(output) {\n        output.print("function");\n        print_lambda(this, output);\n    });\n    function print_async(output) {\n        output.print("async");\n        output.space();\n        output.print("function");\n        print_lambda(this, output);\n    }\n    DEFPRINT(AST_AsyncDefun, print_async);\n    DEFPRINT(AST_AsyncFunction, print_async);\n    function print_async_generator(output) {\n        output.print("async");\n        output.space();\n        output.print("function*");\n        print_lambda(this, output);\n    }\n    DEFPRINT(AST_AsyncGeneratorDefun, print_async_generator);\n    DEFPRINT(AST_AsyncGeneratorFunction, print_async_generator);\n    function print_generator(output) {\n        output.print("function*");\n        print_lambda(this, output);\n    }\n    DEFPRINT(AST_GeneratorDefun, print_generator);\n    DEFPRINT(AST_GeneratorFunction, print_generator);\n\n    /* -----[ classes ]----- */\n    DEFPRINT(AST_Class, function(output) {\n        var self = this;\n        output.print("class");\n        if (self.name) {\n            output.space();\n            self.name.print(output);\n        }\n        if (self.extends) {\n            output.space();\n            output.print("extends");\n            output.space();\n            self.extends.print(output);\n        }\n        output.space();\n        print_properties(self, output, true);\n    });\n    DEFPRINT(AST_ClassField, function(output) {\n        var self = this;\n        if (self.static) {\n            output.print("static");\n            output.space();\n        }\n        print_property_key(self, output);\n        if (self.value) {\n            output.space();\n            output.print("=");\n            output.space();\n            self.value.print(output);\n        } else switch (self.key) {\n          case "get":\n          case "set":\n          case "static":\n            output.force_semicolon();\n            return;\n        }\n        output.semicolon();\n    });\n    DEFPRINT(AST_ClassGetter, print_accessor("get"));\n    DEFPRINT(AST_ClassSetter, print_accessor("set"));\n    function print_method(self, output) {\n        var fn = self.value;\n        if (is_async(fn)) {\n            output.print("async");\n            output.space();\n        }\n        if (is_generator(fn)) output.print("*");\n        print_property_key(self, output);\n        print_lambda(self.value, output);\n    }\n    DEFPRINT(AST_ClassMethod, function(output) {\n        var self = this;\n        if (self.static) {\n            output.print("static");\n            output.space();\n        }\n        print_method(self, output);\n    });\n    DEFPRINT(AST_ClassInit, function(output) {\n        output.print("static");\n        output.space();\n        print_braced(this.value, output);\n    });\n\n    /* -----[ jumps ]----- */\n    function print_jump(kind, prop) {\n        return function(output) {\n            output.print(kind);\n            var target = this[prop];\n            if (target) {\n                output.space();\n                target.print(output);\n            }\n            output.semicolon();\n        };\n    }\n    DEFPRINT(AST_Return, print_jump("return", "value"));\n    DEFPRINT(AST_Throw, print_jump("throw", "value"));\n    DEFPRINT(AST_Break, print_jump("break", "label"));\n    DEFPRINT(AST_Continue, print_jump("continue", "label"));\n\n    /* -----[ if ]----- */\n    function make_then(self, output) {\n        var b = self.body;\n        if (output.option("braces") && !(b instanceof AST_Const || b instanceof AST_Let)\n            || output.option("ie") && b instanceof AST_Do)\n            return make_block(b, output);\n        // The squeezer replaces "block"-s that contain only a single\n        // statement with the statement itself; technically, the AST\n        // is correct, but this can create problems when we output an\n        // IF having an ELSE clause where the THEN clause ends in an\n        // IF *without* an ELSE block (then the outer ELSE would refer\n        // to the inner IF).  This function checks for this case and\n        // adds the block braces if needed.\n        if (!b) return output.force_semicolon();\n        while (true) {\n            if (b instanceof AST_If) {\n                if (!b.alternative) {\n                    make_block(self.body, output);\n                    return;\n                }\n                b = b.alternative;\n            } else if (b instanceof AST_StatementWithBody) {\n                b = b.body;\n            } else break;\n        }\n        force_statement(self.body, output);\n    }\n    DEFPRINT(AST_If, function(output) {\n        var self = this;\n        output.print("if");\n        output.space();\n        output.with_parens(function() {\n            self.condition.print(output);\n        });\n        if (self.alternative) {\n            make_then(self, output);\n            output.space();\n            output.print("else");\n            if (self.alternative instanceof AST_If) {\n                output.space();\n                self.alternative.print(output);\n            } else {\n                force_statement(self.alternative, output);\n            }\n        } else {\n            force_statement(self.body, output);\n        }\n    });\n\n    /* -----[ switch ]----- */\n    DEFPRINT(AST_Switch, function(output) {\n        var self = this;\n        output.print("switch");\n        output.space();\n        output.with_parens(function() {\n            self.expression.print(output);\n        });\n        output.space();\n        var last = self.body.length - 1;\n        if (last < 0) print_braced_empty(self, output);\n        else output.with_block(function() {\n            self.body.forEach(function(branch, i) {\n                output.indent(true);\n                branch.print(output);\n                if (i < last && branch.body.length > 0)\n                    output.newline();\n            });\n        }, self.end);\n    });\n    function print_branch_body(self, output) {\n        output.newline();\n        self.body.forEach(function(stmt) {\n            output.indent();\n            stmt.print(output);\n            output.newline();\n        });\n    }\n    DEFPRINT(AST_Default, function(output) {\n        output.print("default:");\n        print_branch_body(this, output);\n    });\n    DEFPRINT(AST_Case, function(output) {\n        var self = this;\n        output.print("case");\n        output.space();\n        self.expression.print(output);\n        output.print(":");\n        print_branch_body(self, output);\n    });\n\n    /* -----[ exceptions ]----- */\n    DEFPRINT(AST_Try, function(output) {\n        var self = this;\n        output.print("try");\n        output.space();\n        print_braced(self, output);\n        if (self.bcatch) {\n            output.space();\n            self.bcatch.print(output);\n        }\n        if (self.bfinally) {\n            output.space();\n            self.bfinally.print(output);\n        }\n    });\n    DEFPRINT(AST_Catch, function(output) {\n        var self = this;\n        output.print("catch");\n        if (self.argname) {\n            output.space();\n            output.with_parens(function() {\n                self.argname.print(output);\n            });\n        }\n        output.space();\n        print_braced(self, output);\n    });\n    DEFPRINT(AST_Finally, function(output) {\n        output.print("finally");\n        output.space();\n        print_braced(this, output);\n    });\n\n    function print_definitions(type) {\n        return function(output) {\n            var self = this;\n            output.print(type);\n            output.space();\n            self.definitions.forEach(function(def, i) {\n                if (i) output.comma();\n                def.print(output);\n            });\n            var p = output.parent();\n            if (!(p instanceof AST_IterationStatement && p.init === self)) output.semicolon();\n        };\n    }\n    DEFPRINT(AST_Const, print_definitions("const"));\n    DEFPRINT(AST_Let, print_definitions("let"));\n    DEFPRINT(AST_Var, print_definitions("var"));\n\n    function parenthesize_for_no_in(node, output, no_in) {\n        var parens = false;\n        // need to take some precautions here:\n        //    https://github.com/mishoo/UglifyJS/issues/60\n        if (no_in) node.walk(new TreeWalker(function(node) {\n            if (parens) return true;\n            if (node instanceof AST_Binary && node.operator == "in") return parens = true;\n            if (node instanceof AST_Scope && !(is_arrow(node) && node.value)) return true;\n        }));\n        node.print(output, parens);\n    }\n\n    DEFPRINT(AST_VarDef, function(output) {\n        var self = this;\n        self.name.print(output);\n        if (self.value) {\n            output.space();\n            output.print("=");\n            output.space();\n            var p = output.parent(1);\n            var no_in = p instanceof AST_For || p instanceof AST_ForEnumeration;\n            parenthesize_for_no_in(self.value, output, no_in);\n        }\n    });\n\n    DEFPRINT(AST_DefaultValue, function(output) {\n        var self = this;\n        self.name.print(output);\n        output.space();\n        output.print("=");\n        output.space();\n        self.value.print(output);\n    });\n\n    /* -----[ other expressions ]----- */\n    function print_annotation(self, output) {\n        if (!output.option("annotations")) return;\n        if (!self.pure) return;\n        var level = 0, parent = self, node;\n        do {\n            node = parent;\n            parent = output.parent(level++);\n            if (parent instanceof AST_Call && parent.expression === node) return;\n        } while (parent instanceof AST_PropAccess && parent.expression === node);\n        output.print("/*@__PURE__*/");\n    }\n    function print_call_args(self, output) {\n        output.with_parens(function() {\n            self.args.forEach(function(expr, i) {\n                if (i) output.comma();\n                expr.print(output);\n            });\n            output.add_mapping(self.end);\n        });\n    }\n    DEFPRINT(AST_Call, function(output) {\n        var self = this;\n        print_annotation(self, output);\n        self.expression.print(output);\n        if (self.optional) output.print("?.");\n        print_call_args(self, output);\n    });\n    DEFPRINT(AST_New, function(output) {\n        var self = this;\n        print_annotation(self, output);\n        output.print("new");\n        output.space();\n        self.expression.print(output);\n        if (need_constructor_parens(self, output)) print_call_args(self, output);\n    });\n    DEFPRINT(AST_Sequence, function(output) {\n        this.expressions.forEach(function(node, index) {\n            if (index > 0) {\n                output.comma();\n                if (output.should_break()) {\n                    output.newline();\n                    output.indent();\n                }\n            }\n            node.print(output);\n        });\n    });\n    DEFPRINT(AST_Dot, function(output) {\n        var self = this;\n        var expr = self.expression;\n        expr.print(output);\n        var prop = self.property;\n        if (output.option("ie") && RESERVED_WORDS[prop] || self.quoted && output.option("keep_quoted_props")) {\n            if (self.optional) output.print("?.");\n            output.with_square(function() {\n                output.add_mapping(self.end);\n                output.print_string(prop);\n            });\n        } else {\n            if (expr instanceof AST_Number && !/[ex.)]/i.test(output.last())) output.print(".");\n            output.print(self.optional ? "?." : ".");\n            // the name after dot would be mapped about here.\n            output.add_mapping(self.end);\n            output.print_name(prop);\n        }\n    });\n    DEFPRINT(AST_Sub, function(output) {\n        var self = this;\n        self.expression.print(output);\n        if (self.optional) output.print("?.");\n        output.with_square(function() {\n            self.property.print(output);\n        });\n    });\n    DEFPRINT(AST_Spread, function(output) {\n        output.print("...");\n        this.expression.print(output);\n    });\n    DEFPRINT(AST_UnaryPrefix, function(output) {\n        var op = this.operator;\n        var exp = this.expression;\n        output.print(op);\n        if (/^[a-z]/i.test(op)\n            || (/[+-]$/.test(op)\n                && exp instanceof AST_UnaryPrefix\n                && /^[+-]/.test(exp.operator))) {\n            output.space();\n        }\n        exp.print(output);\n    });\n    DEFPRINT(AST_UnaryPostfix, function(output) {\n        var self = this;\n        self.expression.print(output);\n        output.add_mapping(self.end);\n        output.print(self.operator);\n    });\n    DEFPRINT(AST_Binary, function(output) {\n        var self = this;\n        self.left.print(output);\n        output.space();\n        output.print(self.operator);\n        output.space();\n        self.right.print(output);\n    });\n    DEFPRINT(AST_Conditional, function(output) {\n        var self = this;\n        self.condition.print(output);\n        output.space();\n        output.print("?");\n        output.space();\n        self.consequent.print(output);\n        output.space();\n        output.colon();\n        self.alternative.print(output);\n    });\n    DEFPRINT(AST_Await, function(output) {\n        output.print("await");\n        output.space();\n        this.expression.print(output);\n    });\n    DEFPRINT(AST_Yield, function(output) {\n        output.print(this.nested ? "yield*" : "yield");\n        if (this.expression) {\n            output.space();\n            this.expression.print(output);\n        }\n    });\n\n    /* -----[ literals ]----- */\n    DEFPRINT(AST_Array, function(output) {\n        var a = this.elements, len = a.length;\n        output.with_square(len > 0 ? function() {\n            output.space();\n            a.forEach(function(exp, i) {\n                if (i) output.comma();\n                exp.print(output);\n                // If the final element is a hole, we need to make sure it\n                // doesn\'t look like a trailing comma, by inserting an actual\n                // trailing comma.\n                if (i === len - 1 && exp instanceof AST_Hole)\n                  output.comma();\n            });\n            output.space();\n        } : noop);\n    });\n    DEFPRINT(AST_DestructuredArray, function(output) {\n        var a = this.elements, len = a.length, rest = this.rest;\n        output.with_square(len || rest ? function() {\n            output.space();\n            a.forEach(function(exp, i) {\n                if (i) output.comma();\n                exp.print(output);\n            });\n            if (rest) {\n                if (len) output.comma();\n                output.print("...");\n                rest.print(output);\n            } else if (a[len - 1] instanceof AST_Hole) {\n                // If the final element is a hole, we need to make sure it\n                // doesn\'t look like a trailing comma, by inserting an actual\n                // trailing comma.\n                output.comma();\n            }\n            output.space();\n        } : noop);\n    });\n    DEFPRINT(AST_DestructuredKeyVal, function(output) {\n        var self = this;\n        var key = print_property_key(self, output);\n        var value = self.value;\n        if (key) {\n            if (value instanceof AST_DefaultValue) {\n                if (value.name instanceof AST_Symbol && key == get_symbol_name(value.name)) {\n                    output.space();\n                    output.print("=");\n                    output.space();\n                    value.value.print(output);\n                    return;\n                }\n            } else if (value instanceof AST_Symbol) {\n                if (key == get_symbol_name(value)) return;\n            }\n        }\n        output.colon();\n        value.print(output);\n    });\n    DEFPRINT(AST_DestructuredObject, function(output) {\n        var self = this;\n        var props = self.properties, len = props.length, rest = self.rest;\n        if (len || rest) output.with_block(function() {\n            props.forEach(function(prop, i) {\n                if (i) {\n                    output.print(",");\n                    output.newline();\n                }\n                output.indent();\n                prop.print(output);\n            });\n            if (rest) {\n                if (len) {\n                    output.print(",");\n                    output.newline();\n                }\n                output.indent();\n                output.print("...");\n                rest.print(output);\n            }\n            output.newline();\n        }, self.end);\n        else print_braced_empty(self, output);\n    });\n    function print_properties(self, output, no_comma) {\n        var props = self.properties;\n        if (props.length > 0) output.with_block(function() {\n            props.forEach(function(prop, i) {\n                if (i) {\n                    if (!no_comma) output.print(",");\n                    output.newline();\n                }\n                output.indent();\n                prop.print(output);\n            });\n            output.newline();\n        }, self.end);\n        else print_braced_empty(self, output);\n    }\n    DEFPRINT(AST_Object, function(output) {\n        print_properties(this, output);\n    });\n\n    function print_property_key(self, output) {\n        var key = self.key;\n        if (key instanceof AST_Node) return output.with_square(function() {\n            key.print(output);\n        });\n        var quote = self.start && self.start.quote;\n        if (output.option("quote_keys") || quote && output.option("keep_quoted_props")) {\n            output.print_string(key, quote);\n        } else if ("" + +key == key && key >= 0) {\n            output.print(make_num(key));\n        } else if (self.private) {\n            output.print_name(key);\n        } else if (RESERVED_WORDS[key] ? !output.option("ie") : is_identifier_string(key)) {\n            output.print_name(key);\n            return key;\n        } else {\n            output.print_string(key, quote);\n        }\n    }\n    DEFPRINT(AST_ObjectKeyVal, function(output) {\n        var self = this;\n        print_property_key(self, output);\n        output.colon();\n        self.value.print(output);\n    });\n    DEFPRINT(AST_ObjectMethod, function(output) {\n        print_method(this, output);\n    });\n    function print_accessor(type) {\n        return function(output) {\n            var self = this;\n            if (self.static) {\n                output.print("static");\n                output.space();\n            }\n            output.print(type);\n            output.space();\n            print_property_key(self, output);\n            print_lambda(self.value, output);\n        };\n    }\n    DEFPRINT(AST_ObjectGetter, print_accessor("get"));\n    DEFPRINT(AST_ObjectSetter, print_accessor("set"));\n    function get_symbol_name(sym) {\n        var def = sym.definition();\n        return def && def.mangled_name || sym.name;\n    }\n    DEFPRINT(AST_Symbol, function(output) {\n        output.print_name(get_symbol_name(this));\n    });\n    DEFPRINT(AST_SymbolExport, function(output) {\n        var self = this;\n        var name = get_symbol_name(self);\n        output.print_name(name);\n        var alias = self.alias;\n        if (alias.value != name) {\n            output.space();\n            output.print("as");\n            output.space();\n            print_alias(alias, output);\n        }\n    });\n    DEFPRINT(AST_SymbolImport, function(output) {\n        var self = this;\n        var name = get_symbol_name(self);\n        var key = self.key;\n        if (key.value && key.value != name) {\n            print_alias(key, output);\n            output.space();\n            output.print("as");\n            output.space();\n        }\n        output.print_name(name);\n    });\n    DEFPRINT(AST_Hole, noop);\n    DEFPRINT(AST_Template, function(output) {\n        var self = this;\n        if (self.tag) self.tag.print(output);\n        output.print("`");\n        for (var i = 0; i < self.expressions.length; i++) {\n            output.print(output.to_utf8(self.strings[i]));\n            output.print("${");\n            self.expressions[i].print(output);\n            output.print("}");\n        }\n        output.print(output.to_utf8(self.strings[i]));\n        output.print("`");\n    });\n    DEFPRINT(AST_BigInt, function(output) {\n        output.print(this.value + "n");\n    });\n    DEFPRINT(AST_Constant, function(output) {\n        output.print("" + this.value);\n    });\n    DEFPRINT(AST_String, function(output) {\n        output.print_string(this.value, this.quote);\n    });\n    DEFPRINT(AST_Number, function(output) {\n        var start = this.start;\n        if (use_asm && start && start.raw != null) {\n            output.print(start.raw);\n        } else {\n            output.print(make_num(this.value));\n        }\n    });\n\n    DEFPRINT(AST_RegExp, function(output) {\n        var regexp = this.value;\n        var str = regexp.toString();\n        var end = str.lastIndexOf("/");\n        if (regexp.raw_source) {\n            str = "/" + regexp.raw_source + str.slice(end);\n        } else if (end == 1) {\n            str = "/(?:)" + str.slice(end);\n        } else if (str.indexOf("/", 1) < end) {\n            str = "/" + str.slice(1, end).replace(/\\\\\\\\|[^/]?\\//g, function(match) {\n                return match[0] == "\\\\" ? match : match.slice(0, -1) + "\\\\/";\n            }) + str.slice(end);\n        }\n        output.print(output.to_utf8(str).replace(/\\\\(?:\\0(?![0-9])|[^\\0])/g, function(match) {\n            switch (match[1]) {\n              case "\\n": return "\\\\n";\n              case "\\r": return "\\\\r";\n              case "\\t": return "\\t";\n              case "\\b": return "\\b";\n              case "\\f": return "\\f";\n              case "\\0": return "\\0";\n              case "\\x0B": return "\\v";\n              case "\\u2028": return "\\\\u2028";\n              case "\\u2029": return "\\\\u2029";\n              default: return match;\n            }\n        }).replace(/[\\n\\r\\u2028\\u2029]/g, function(c) {\n            switch (c) {\n              case "\\n": return "\\\\n";\n              case "\\r": return "\\\\r";\n              case "\\u2028": return "\\\\u2028";\n              case "\\u2029": return "\\\\u2029";\n            }\n        }));\n    });\n\n    function force_statement(stat, output) {\n        if (output.option("braces") && !(stat instanceof AST_Const || stat instanceof AST_Let)) {\n            make_block(stat, output);\n        } else if (stat instanceof AST_EmptyStatement) {\n            output.force_semicolon();\n        } else {\n            output.space();\n            stat.print(output);\n        }\n    }\n\n    // self should be AST_New.  decide if we want to show parens or not.\n    function need_constructor_parens(self, output) {\n        // Always print parentheses with arguments\n        if (self.args.length > 0) return true;\n\n        return output.option("beautify");\n    }\n\n    function best_of(a) {\n        var best = a[0], len = best.length;\n        for (var i = 1; i < a.length; ++i) {\n            if (a[i].length < len) {\n                best = a[i];\n                len = best.length;\n            }\n        }\n        return best;\n    }\n\n    function make_num(num) {\n        var str = num.toString(10).replace(/^0\\./, ".").replace("e+", "e");\n        var candidates = [ str ];\n        if (Math.floor(num) === num) {\n            if (num < 0) {\n                candidates.push("-0x" + (-num).toString(16).toLowerCase());\n            } else {\n                candidates.push("0x" + num.toString(16).toLowerCase());\n            }\n        }\n        var match, len, digits;\n        if (match = /^\\.0+/.exec(str)) {\n            len = match[0].length;\n            digits = str.slice(len);\n            candidates.push(digits + "e-" + (digits.length + len - 1));\n        } else if (match = /[^0]0+$/.exec(str)) {\n            len = match[0].length - 1;\n            candidates.push(str.slice(0, -len) + "e" + len);\n        } else if (match = /^(\\d)\\.(\\d+)e(-?\\d+)$/.exec(str)) {\n            candidates.push(match[1] + match[2] + "e" + (match[3] - match[2].length));\n        }\n        return best_of(candidates);\n    }\n\n    function make_block(stmt, output) {\n        output.space();\n        if (stmt instanceof AST_EmptyStatement) {\n            print_braced_empty(stmt, output);\n        } else if (stmt instanceof AST_BlockStatement) {\n            stmt.print(output);\n        } else output.with_block(function() {\n            output.indent();\n            stmt.print(output);\n            output.newline();\n        }, stmt.end);\n    }\n\n    /* -----[ source map generators ]----- */\n\n    function DEFMAP(nodetype, generator) {\n        nodetype.forEach(function(nodetype) {\n            nodetype.DEFMETHOD("add_source_map", generator);\n        });\n    }\n\n    DEFMAP([\n        // We could easily add info for ALL nodes, but it seems to me that\n        // would be quite wasteful, hence this noop in the base class.\n        AST_Node,\n        // since the label symbol will mark it\n        AST_LabeledStatement,\n    ], noop);\n\n    // XXX: I\'m not exactly sure if we need it for all of these nodes,\n    // or if we should add even more.\n    DEFMAP([\n        AST_Array,\n        AST_Await,\n        AST_BlockStatement,\n        AST_Catch,\n        AST_Constant,\n        AST_Debugger,\n        AST_Definitions,\n        AST_Destructured,\n        AST_Directive,\n        AST_Finally,\n        AST_Jump,\n        AST_Lambda,\n        AST_New,\n        AST_Object,\n        AST_Spread,\n        AST_StatementWithBody,\n        AST_Symbol,\n        AST_Switch,\n        AST_SwitchBranch,\n        AST_Try,\n        AST_UnaryPrefix,\n        AST_Yield,\n    ], function(output) {\n        output.add_mapping(this.start);\n    });\n\n    DEFMAP([\n        AST_ClassProperty,\n        AST_DestructuredKeyVal,\n        AST_ObjectProperty,\n    ], function(output) {\n        if (typeof this.key == "string") output.add_mapping(this.start, this.key);\n    });\n})();\n'},2849:(e,t,r)=>{"use strict";r.d(t,{Z:()=>n});const n='/***********************************************************************\n\n  A JavaScript tokenizer / parser / beautifier / compressor.\n  https://github.com/mishoo/UglifyJS\n\n  -------------------------------- (C) ---------------------------------\n\n                           Author: Mihai Bazon\n                         <mihai.bazon@gmail.com>\n                       http://mihai.bazon.net/blog\n\n  Distributed under the BSD license:\n\n    Copyright 2012 (c) Mihai Bazon <mihai.bazon@gmail.com>\n    Parser based on parse-js (http://marijn.haverbeke.nl/parse-js/).\n\n    Redistribution and use in source and binary forms, with or without\n    modification, are permitted provided that the following conditions\n    are met:\n\n        * Redistributions of source code must retain the above\n          copyright notice, this list of conditions and the following\n          disclaimer.\n\n        * Redistributions in binary form must reproduce the above\n          copyright notice, this list of conditions and the following\n          disclaimer in the documentation and/or other materials\n          provided with the distribution.\n\n    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY\n    EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE\n    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,\n    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR\n    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF\n    THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n    SUCH DAMAGE.\n\n ***********************************************************************/\n\n"use strict";\n\nvar KEYWORDS = "break case catch class const continue debugger default delete do else extends finally for function if in instanceof new return switch throw try typeof var void while with";\nvar KEYWORDS_ATOM = "false null true";\nvar RESERVED_WORDS = [\n    "abstract async await boolean byte char double enum export final float goto implements import int interface let long native package private protected public short static super synchronized this throws transient volatile yield",\n    KEYWORDS_ATOM,\n    KEYWORDS,\n].join(" ");\nvar KEYWORDS_BEFORE_EXPRESSION = "return new delete throw else case";\n\nKEYWORDS = makePredicate(KEYWORDS);\nRESERVED_WORDS = makePredicate(RESERVED_WORDS);\nKEYWORDS_BEFORE_EXPRESSION = makePredicate(KEYWORDS_BEFORE_EXPRESSION);\nKEYWORDS_ATOM = makePredicate(KEYWORDS_ATOM);\n\nvar RE_BIN_NUMBER = /^0b([01]+)$/i;\nvar RE_HEX_NUMBER = /^0x([0-9a-f]+)$/i;\nvar RE_OCT_NUMBER = /^0o?([0-7]+)$/i;\n\nvar OPERATORS = makePredicate([\n    "in",\n    "instanceof",\n    "typeof",\n    "new",\n    "void",\n    "delete",\n    "++",\n    "--",\n    "+",\n    "-",\n    "!",\n    "~",\n    "&",\n    "|",\n    "^",\n    "*",\n    "/",\n    "%",\n    "**",\n    ">>",\n    "<<",\n    ">>>",\n    "<",\n    ">",\n    "<=",\n    ">=",\n    "==",\n    "===",\n    "!=",\n    "!==",\n    "?",\n    "=",\n    "+=",\n    "-=",\n    "/=",\n    "*=",\n    "%=",\n    "**=",\n    ">>=",\n    "<<=",\n    ">>>=",\n    "&=",\n    "|=",\n    "^=",\n    "&&",\n    "||",\n    "??",\n    "&&=",\n    "||=",\n    "??=",\n]);\n\nvar NEWLINE_CHARS = "\\n\\r\\u2028\\u2029";\nvar OPERATOR_CHARS = "+-*&%=<>!?|~^";\nvar PUNC_OPENERS = "[{(";\nvar PUNC_SEPARATORS = ",;:";\nvar PUNC_CLOSERS = ")}]";\nvar PUNC_AFTER_EXPRESSION = PUNC_SEPARATORS + PUNC_CLOSERS;\nvar PUNC_BEFORE_EXPRESSION = PUNC_OPENERS + PUNC_SEPARATORS;\nvar PUNC_CHARS = PUNC_BEFORE_EXPRESSION + "`" + PUNC_CLOSERS;\nvar WHITESPACE_CHARS = NEWLINE_CHARS + " \\u00a0\\t\\f\\u000b\\u200b\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000\\uFEFF";\nvar NON_IDENTIFIER_CHARS = makePredicate(characters("./\'\\"#" + OPERATOR_CHARS + PUNC_CHARS + WHITESPACE_CHARS));\n\nNEWLINE_CHARS = makePredicate(characters(NEWLINE_CHARS));\nOPERATOR_CHARS = makePredicate(characters(OPERATOR_CHARS));\nPUNC_AFTER_EXPRESSION = makePredicate(characters(PUNC_AFTER_EXPRESSION));\nPUNC_BEFORE_EXPRESSION = makePredicate(characters(PUNC_BEFORE_EXPRESSION));\nPUNC_CHARS = makePredicate(characters(PUNC_CHARS));\nWHITESPACE_CHARS = makePredicate(characters(WHITESPACE_CHARS));\n\n/* -----[ Tokenizer ]----- */\n\nfunction is_surrogate_pair_head(code) {\n    return code >= 0xd800 && code <= 0xdbff;\n}\n\nfunction is_surrogate_pair_tail(code) {\n    return code >= 0xdc00 && code <= 0xdfff;\n}\n\nfunction is_digit(code) {\n    return code >= 48 && code <= 57;\n}\n\nfunction is_identifier_char(ch) {\n    return !NON_IDENTIFIER_CHARS[ch];\n}\n\nfunction is_identifier_string(str) {\n    return /^[a-z_$][a-z0-9_$]*$/i.test(str);\n}\n\nfunction decode_escape_sequence(seq) {\n    switch (seq[0]) {\n      case "b": return "\\b";\n      case "f": return "\\f";\n      case "n": return "\\n";\n      case "r": return "\\r";\n      case "t": return "\\t";\n      case "u":\n        var code;\n        if (seq[1] == "{" && seq.slice(-1) == "}") {\n            code = seq.slice(2, -1);\n        } else if (seq.length == 5) {\n            code = seq.slice(1);\n        } else {\n            return;\n        }\n        var num = parseInt(code, 16);\n        if (num < 0 || isNaN(num)) return;\n        if (num < 0x10000) return String.fromCharCode(num);\n        if (num > 0x10ffff) return;\n        return String.fromCharCode((num >> 10) + 0xd7c0) + String.fromCharCode((num & 0x03ff) + 0xdc00);\n      case "v": return "\\u000b";\n      case "x":\n        if (seq.length != 3) return;\n        var num = parseInt(seq.slice(1), 16);\n        if (num < 0 || isNaN(num)) return;\n        return String.fromCharCode(num);\n      case "\\r":\n      case "\\n":\n        return "";\n      default:\n        if (seq == "0") return "\\0";\n        if (seq[0] >= "0" && seq[0] <= "9") return;\n        return seq;\n    }\n}\n\nfunction parse_js_number(num) {\n    var match;\n    if (match = RE_BIN_NUMBER.exec(num)) return parseInt(match[1], 2);\n    if (match = RE_HEX_NUMBER.exec(num)) return parseInt(match[1], 16);\n    if (match = RE_OCT_NUMBER.exec(num)) return parseInt(match[1], 8);\n    var val = parseFloat(num);\n    if (val == num) return val;\n}\n\nfunction JS_Parse_Error(message, filename, line, col, pos) {\n    this.message = message;\n    this.filename = filename;\n    this.line = line;\n    this.col = col;\n    this.pos = pos;\n    try {\n        throw new SyntaxError(message, filename, line, col);\n    } catch (cause) {\n        configure_error_stack(this, cause);\n    }\n}\nJS_Parse_Error.prototype = Object.create(SyntaxError.prototype);\nJS_Parse_Error.prototype.constructor = JS_Parse_Error;\n\nfunction js_error(message, filename, line, col, pos) {\n    throw new JS_Parse_Error(message, filename, line, col, pos);\n}\n\nfunction is_token(token, type, val) {\n    return token.type == type && (val == null || token.value == val);\n}\n\nvar EX_EOF = {};\n\nfunction tokenizer($TEXT, filename, html5_comments, shebang) {\n\n    var S = {\n        text            : $TEXT,\n        filename        : filename,\n        pos             : 0,\n        tokpos          : 0,\n        line            : 1,\n        tokline         : 0,\n        col             : 0,\n        tokcol          : 0,\n        newline_before  : false,\n        regex_allowed   : false,\n        comments_before : [],\n        directives      : Object.create(null),\n        read_template   : with_eof_error("Unterminated template literal", function(strings) {\n            var s = "";\n            for (;;) {\n                var ch = read();\n                switch (ch) {\n                  case "\\\\":\n                    ch += read();\n                    break;\n                  case "`":\n                    strings.push(s);\n                    return;\n                  case "$":\n                    if (peek() == "{") {\n                        next();\n                        strings.push(s);\n                        S.regex_allowed = true;\n                        return true;\n                    }\n                }\n                s += ch;\n            }\n\n            function read() {\n                var ch = next(true, true);\n                return ch == "\\r" ? "\\n" : ch;\n            }\n        }),\n    };\n    var prev_was_dot = false;\n\n    function peek() {\n        return S.text.charAt(S.pos);\n    }\n\n    function next(signal_eof, in_string) {\n        var ch = S.text.charAt(S.pos++);\n        if (signal_eof && !ch)\n            throw EX_EOF;\n        if (NEWLINE_CHARS[ch]) {\n            S.col = 0;\n            S.line++;\n            if (!in_string) S.newline_before = true;\n            if (ch == "\\r" && peek() == "\\n") {\n                // treat `\\r\\n` as `\\n`\n                S.pos++;\n                ch = "\\n";\n            }\n        } else {\n            S.col++;\n        }\n        return ch;\n    }\n\n    function forward(i) {\n        while (i-- > 0) next();\n    }\n\n    function looking_at(str) {\n        return S.text.substr(S.pos, str.length) == str;\n    }\n\n    function find_eol() {\n        var text = S.text;\n        for (var i = S.pos; i < S.text.length; ++i) {\n            if (NEWLINE_CHARS[text[i]]) return i;\n        }\n        return -1;\n    }\n\n    function find(what, signal_eof) {\n        var pos = S.text.indexOf(what, S.pos);\n        if (signal_eof && pos == -1) throw EX_EOF;\n        return pos;\n    }\n\n    function start_token() {\n        S.tokline = S.line;\n        S.tokcol = S.col;\n        S.tokpos = S.pos;\n    }\n\n    function token(type, value, is_comment) {\n        S.regex_allowed = type == "operator" && !UNARY_POSTFIX[value]\n            || type == "keyword" && KEYWORDS_BEFORE_EXPRESSION[value]\n            || type == "punc" && PUNC_BEFORE_EXPRESSION[value];\n        if (type == "punc" && value == ".") prev_was_dot = true;\n        else if (!is_comment) prev_was_dot = false;\n        var ret = {\n            type    : type,\n            value   : value,\n            line    : S.tokline,\n            col     : S.tokcol,\n            pos     : S.tokpos,\n            endline : S.line,\n            endcol  : S.col,\n            endpos  : S.pos,\n            nlb     : S.newline_before,\n            file    : filename\n        };\n        if (/^(?:num|string|regexp)$/i.test(type)) {\n            ret.raw = $TEXT.substring(ret.pos, ret.endpos);\n        }\n        if (!is_comment) {\n            ret.comments_before = S.comments_before;\n            ret.comments_after = S.comments_before = [];\n        }\n        S.newline_before = false;\n        return new AST_Token(ret);\n    }\n\n    function skip_whitespace() {\n        while (WHITESPACE_CHARS[peek()])\n            next();\n    }\n\n    function read_while(pred) {\n        var ret = "", ch;\n        while ((ch = peek()) && pred(ch, ret)) ret += next();\n        return ret;\n    }\n\n    function parse_error(err) {\n        js_error(err, filename, S.tokline, S.tokcol, S.tokpos);\n    }\n\n    function is_octal(num) {\n        return /^0[0-7_]+$/.test(num);\n    }\n\n    function read_num(prefix) {\n        var has_e = false, after_e = false, has_x = false, has_dot = prefix == ".";\n        var num = read_while(function(ch, str) {\n            switch (ch) {\n              case "x": case "X":\n                return has_x ? false : (has_x = true);\n              case "e": case "E":\n                return has_x ? true : has_e ? false : (has_e = after_e = true);\n              case "+": case "-":\n                return after_e;\n              case (after_e = false, "."):\n                return has_dot || has_e || has_x || is_octal(str) ? false : (has_dot = true);\n            }\n            return /[_0-9a-dfo]/i.test(ch);\n        });\n        if (prefix) num = prefix + num;\n        if (is_octal(num)) {\n            if (next_token.has_directive("use strict")) parse_error("Legacy octal literals are not allowed in strict mode");\n        } else {\n            num = num.replace(has_x ? /([1-9a-f]|.0)_(?=[0-9a-f])/gi : /([1-9]|.0)_(?=[0-9])/gi, "$1");\n        }\n        var valid = parse_js_number(num);\n        if (isNaN(valid)) parse_error("Invalid syntax: " + num);\n        if (has_dot || has_e || peek() != "n") return token("num", valid);\n        next();\n        return token("bigint", num.toLowerCase());\n    }\n\n    function read_escaped_char(in_string) {\n        var seq = next(true, in_string);\n        if (seq >= "0" && seq <= "7") return read_octal_escape_sequence(seq);\n        if (seq == "u") {\n            var ch = next(true, in_string);\n            seq += ch;\n            if (ch != "{") {\n                seq += next(true, in_string) + next(true, in_string) + next(true, in_string);\n            } else do {\n                ch = next(true, in_string);\n                seq += ch;\n            } while (ch != "}");\n        } else if (seq == "x") {\n            seq += next(true, in_string) + next(true, in_string);\n        }\n        var str = decode_escape_sequence(seq);\n        if (typeof str != "string") parse_error("Invalid escape sequence: \\\\" + seq);\n        return str;\n    }\n\n    function read_octal_escape_sequence(ch) {\n        // Read\n        var p = peek();\n        if (p >= "0" && p <= "7") {\n            ch += next(true);\n            if (ch[0] <= "3" && (p = peek()) >= "0" && p <= "7")\n                ch += next(true);\n        }\n\n        // Parse\n        if (ch === "0") return "\\0";\n        if (ch.length > 0 && next_token.has_directive("use strict"))\n            parse_error("Legacy octal escape sequences are not allowed in strict mode");\n        return String.fromCharCode(parseInt(ch, 8));\n    }\n\n    var read_string = with_eof_error("Unterminated string constant", function(quote_char) {\n        var quote = next(), ret = "";\n        for (;;) {\n            var ch = next(true, true);\n            if (ch == "\\\\") ch = read_escaped_char(true);\n            else if (NEWLINE_CHARS[ch]) parse_error("Unterminated string constant");\n            else if (ch == quote) break;\n            ret += ch;\n        }\n        var tok = token("string", ret);\n        tok.quote = quote_char;\n        return tok;\n    });\n\n    function skip_line_comment(type) {\n        var regex_allowed = S.regex_allowed;\n        var i = find_eol(), ret;\n        if (i == -1) {\n            ret = S.text.substr(S.pos);\n            S.pos = S.text.length;\n        } else {\n            ret = S.text.substring(S.pos, i);\n            S.pos = i;\n        }\n        S.col = S.tokcol + (S.pos - S.tokpos);\n        S.comments_before.push(token(type, ret, true));\n        S.regex_allowed = regex_allowed;\n        return next_token;\n    }\n\n    var skip_multiline_comment = with_eof_error("Unterminated multiline comment", function() {\n        var regex_allowed = S.regex_allowed;\n        var i = find("*/", true);\n        var text = S.text.substring(S.pos, i).replace(/\\r\\n|\\r|\\u2028|\\u2029/g, "\\n");\n        // update stream position\n        forward(text.length /* doesn\'t count \\r\\n as 2 char while S.pos - i does */ + 2);\n        S.comments_before.push(token("comment2", text, true));\n        S.regex_allowed = regex_allowed;\n        return next_token;\n    });\n\n    function read_name() {\n        var backslash = false, ch, escaped = false, name = peek() == "#" ? next() : "";\n        while (ch = peek()) {\n            if (!backslash) {\n                if (ch == "\\\\") escaped = backslash = true, next();\n                else if (is_identifier_char(ch)) name += next();\n                else break;\n            } else {\n                if (ch != "u") parse_error("Expecting UnicodeEscapeSequence -- uXXXX");\n                ch = read_escaped_char();\n                if (!is_identifier_char(ch)) parse_error("Unicode char: " + ch.charCodeAt(0) + " is not valid in identifier");\n                name += ch;\n                backslash = false;\n            }\n        }\n        if (KEYWORDS[name] && escaped) {\n            var hex = name.charCodeAt(0).toString(16).toUpperCase();\n            name = "\\\\u" + "0000".substr(hex.length) + hex + name.slice(1);\n        }\n        return name;\n    }\n\n    var read_regexp = with_eof_error("Unterminated regular expression", function(source) {\n        var prev_backslash = false, ch, in_class = false;\n        while ((ch = next(true))) if (NEWLINE_CHARS[ch]) {\n            parse_error("Unexpected line terminator");\n        } else if (prev_backslash) {\n            source += "\\\\" + ch;\n            prev_backslash = false;\n        } else if (ch == "[") {\n            in_class = true;\n            source += ch;\n        } else if (ch == "]" && in_class) {\n            in_class = false;\n            source += ch;\n        } else if (ch == "/" && !in_class) {\n            break;\n        } else if (ch == "\\\\") {\n            prev_backslash = true;\n        } else {\n            source += ch;\n        }\n        var mods = read_name();\n        try {\n            var regexp = new RegExp(source, mods);\n            regexp.raw_source = source;\n            return token("regexp", regexp);\n        } catch (e) {\n            parse_error(e.message);\n        }\n    });\n\n    function read_operator(prefix) {\n        function grow(op) {\n            if (!peek()) return op;\n            var bigger = op + peek();\n            if (OPERATORS[bigger]) {\n                next();\n                return grow(bigger);\n            } else {\n                return op;\n            }\n        }\n        return token("operator", grow(prefix || next()));\n    }\n\n    function handle_slash() {\n        next();\n        switch (peek()) {\n          case "/":\n            next();\n            return skip_line_comment("comment1");\n          case "*":\n            next();\n            return skip_multiline_comment();\n        }\n        return S.regex_allowed ? read_regexp("") : read_operator("/");\n    }\n\n    function handle_dot() {\n        next();\n        if (looking_at("..")) return token("operator", "." + next() + next());\n        return is_digit(peek().charCodeAt(0)) ? read_num(".") : token("punc", ".");\n    }\n\n    function read_word() {\n        var word = read_name();\n        if (prev_was_dot) return token("name", word);\n        return KEYWORDS_ATOM[word] ? token("atom", word)\n            : !KEYWORDS[word] ? token("name", word)\n            : OPERATORS[word] ? token("operator", word)\n            : token("keyword", word);\n    }\n\n    function with_eof_error(eof_error, cont) {\n        return function(x) {\n            try {\n                return cont(x);\n            } catch (ex) {\n                if (ex === EX_EOF) parse_error(eof_error);\n                else throw ex;\n            }\n        };\n    }\n\n    function next_token(force_regexp) {\n        if (force_regexp != null)\n            return read_regexp(force_regexp);\n        if (shebang && S.pos == 0 && looking_at("#!")) {\n            start_token();\n            forward(2);\n            skip_line_comment("comment5");\n        }\n        for (;;) {\n            skip_whitespace();\n            start_token();\n            if (html5_comments) {\n                if (looking_at("\x3c!--")) {\n                    forward(4);\n                    skip_line_comment("comment3");\n                    continue;\n                }\n                if (looking_at("--\x3e") && S.newline_before) {\n                    forward(3);\n                    skip_line_comment("comment4");\n                    continue;\n                }\n            }\n            var ch = peek();\n            if (!ch) return token("eof");\n            var code = ch.charCodeAt(0);\n            switch (code) {\n              case 34: case 39: return read_string(ch);\n              case 46: return handle_dot();\n              case 47:\n                var tok = handle_slash();\n                if (tok === next_token) continue;\n                return tok;\n            }\n            if (is_digit(code)) return read_num();\n            if (PUNC_CHARS[ch]) return token("punc", next());\n            if (looking_at("=>")) return token("punc", next() + next());\n            if (OPERATOR_CHARS[ch]) return read_operator();\n            if (code == 35 || code == 92 || !NON_IDENTIFIER_CHARS[ch]) return read_word();\n            break;\n        }\n        parse_error("Unexpected character \'" + ch + "\'");\n    }\n\n    next_token.context = function(nc) {\n        if (nc) S = nc;\n        return S;\n    };\n\n    next_token.add_directive = function(directive) {\n        S.directives[directive] = true;\n    }\n\n    next_token.push_directives_stack = function() {\n        S.directives = Object.create(S.directives);\n    }\n\n    next_token.pop_directives_stack = function() {\n        S.directives = Object.getPrototypeOf(S.directives);\n    }\n\n    next_token.has_directive = function(directive) {\n        return !!S.directives[directive];\n    }\n\n    return next_token;\n}\n\n/* -----[ Parser (constants) ]----- */\n\nvar UNARY_PREFIX = makePredicate("typeof void delete -- ++ ! ~ - +");\n\nvar UNARY_POSTFIX = makePredicate("-- ++");\n\nvar ASSIGNMENT = makePredicate("= += -= /= *= %= **= >>= <<= >>>= &= |= ^= &&= ||= ??=");\n\nvar PRECEDENCE = function(a, ret) {\n    for (var i = 0; i < a.length;) {\n        var b = a[i++];\n        for (var j = 0; j < b.length; j++) {\n            ret[b[j]] = i;\n        }\n    }\n    return ret;\n}([\n    ["??"],\n    ["||"],\n    ["&&"],\n    ["|"],\n    ["^"],\n    ["&"],\n    ["==", "===", "!=", "!=="],\n    ["<", ">", "<=", ">=", "in", "instanceof"],\n    [">>", "<<", ">>>"],\n    ["+", "-"],\n    ["*", "/", "%"],\n    ["**"],\n], {});\n\nvar ATOMIC_START_TOKEN = makePredicate("atom bigint num regexp string");\n\n/* -----[ Parser ]----- */\n\nfunction parse($TEXT, options) {\n    options = defaults(options, {\n        bare_returns   : false,\n        expression     : false,\n        filename       : null,\n        html5_comments : true,\n        module         : false,\n        shebang        : true,\n        strict         : false,\n        toplevel       : null,\n    }, true);\n\n    var S = {\n        input         : typeof $TEXT == "string"\n                        ? tokenizer($TEXT, options.filename, options.html5_comments, options.shebang)\n                        : $TEXT,\n        in_async      : false,\n        in_directives : true,\n        in_funarg     : -1,\n        in_function   : 0,\n        in_generator  : false,\n        in_loop       : 0,\n        labels        : [],\n        peeked        : null,\n        prev          : null,\n        token         : null,\n    };\n\n    S.token = next();\n\n    function is(type, value) {\n        return is_token(S.token, type, value);\n    }\n\n    function peek() {\n        return S.peeked || (S.peeked = S.input());\n    }\n\n    function next() {\n        S.prev = S.token;\n        if (S.peeked) {\n            S.token = S.peeked;\n            S.peeked = null;\n        } else {\n            S.token = S.input();\n        }\n        S.in_directives = S.in_directives && (\n            S.token.type == "string" || is("punc", ";")\n        );\n        return S.token;\n    }\n\n    function prev() {\n        return S.prev;\n    }\n\n    function croak(msg, line, col, pos) {\n        var ctx = S.input.context();\n        js_error(msg,\n                 ctx.filename,\n                 line != null ? line : ctx.tokline,\n                 col != null ? col : ctx.tokcol,\n                 pos != null ? pos : ctx.tokpos);\n    }\n\n    function token_error(token, msg) {\n        croak(msg, token.line, token.col);\n    }\n\n    function token_to_string(type, value) {\n        return type + (value === undefined ? "" : " «" + value + "»");\n    }\n\n    function unexpected(token) {\n        if (token == null) token = S.token;\n        token_error(token, "Unexpected token: " + token_to_string(token.type, token.value));\n    }\n\n    function expect_token(type, val) {\n        if (is(type, val)) return next();\n        token_error(S.token, "Unexpected token: " + token_to_string(S.token.type, S.token.value) + ", expected: " + token_to_string(type, val));\n    }\n\n    function expect(punc) {\n        return expect_token("punc", punc);\n    }\n\n    function has_newline_before(token) {\n        return token.nlb || !all(token.comments_before, function(comment) {\n            return !comment.nlb;\n        });\n    }\n\n    function can_insert_semicolon() {\n        return !options.strict\n            && (is("eof") || is("punc", "}") || has_newline_before(S.token));\n    }\n\n    function semicolon(optional) {\n        if (is("punc", ";")) next();\n        else if (!optional && !can_insert_semicolon()) expect(";");\n    }\n\n    function parenthesized() {\n        expect("(");\n        var exp = expression();\n        expect(")");\n        return exp;\n    }\n\n    function embed_tokens(parser) {\n        return function() {\n            var start = S.token;\n            var expr = parser.apply(null, arguments);\n            var end = prev();\n            expr.start = start;\n            expr.end = end;\n            return expr;\n        };\n    }\n\n    function handle_regexp() {\n        if (is("operator", "/") || is("operator", "/=")) {\n            S.peeked = null;\n            S.token = S.input(S.token.value.substr(1)); // force regexp\n        }\n    }\n\n    var statement = embed_tokens(function(toplevel) {\n        handle_regexp();\n        switch (S.token.type) {\n          case "string":\n            var dir = S.in_directives;\n            var body = expression();\n            if (dir) {\n                if (body instanceof AST_String) {\n                    var value = body.start.raw.slice(1, -1);\n                    S.input.add_directive(value);\n                    body.value = value;\n                } else {\n                    S.in_directives = dir = false;\n                }\n            }\n            semicolon();\n            return dir ? new AST_Directive(body) : new AST_SimpleStatement({ body: body });\n          case "num":\n          case "bigint":\n          case "regexp":\n          case "operator":\n          case "atom":\n            return simple_statement();\n\n          case "name":\n            switch (S.token.value) {\n              case "async":\n                if (is_token(peek(), "keyword", "function")) {\n                    next();\n                    next();\n                    if (!is("operator", "*")) return function_(AST_AsyncDefun);\n                    next();\n                    return function_(AST_AsyncGeneratorDefun);\n                }\n                break;\n              case "await":\n                if (S.in_async) return simple_statement();\n                break;\n              case "export":\n                if (!toplevel && options.module !== "") unexpected();\n                next();\n                return export_();\n              case "import":\n                var token = peek();\n                if (token.type == "punc" && /^[(.]$/.test(token.value)) break;\n                if (!toplevel && options.module !== "") unexpected();\n                next();\n                return import_();\n              case "let":\n                if (is_vardefs()) {\n                    next();\n                    var node = let_();\n                    semicolon();\n                    return node;\n                }\n                break;\n              case "yield":\n                if (S.in_generator) return simple_statement();\n                break;\n            }\n            return is_token(peek(), "punc", ":")\n                ? labeled_statement()\n                : simple_statement();\n\n          case "punc":\n            switch (S.token.value) {\n              case "{":\n                return new AST_BlockStatement({\n                    start : S.token,\n                    body  : block_(),\n                    end   : prev()\n                });\n              case "[":\n              case "(":\n              case "`":\n                return simple_statement();\n              case ";":\n                S.in_directives = false;\n                next();\n                return new AST_EmptyStatement();\n              default:\n                unexpected();\n            }\n\n          case "keyword":\n            switch (S.token.value) {\n              case "break":\n                next();\n                return break_cont(AST_Break);\n\n              case "class":\n                next();\n                return class_(AST_DefClass);\n\n              case "const":\n                next();\n                var node = const_();\n                semicolon();\n                return node;\n\n              case "continue":\n                next();\n                return break_cont(AST_Continue);\n\n              case "debugger":\n                next();\n                semicolon();\n                return new AST_Debugger();\n\n              case "do":\n                next();\n                var body = in_loop(statement);\n                expect_token("keyword", "while");\n                var condition = parenthesized();\n                semicolon(true);\n                return new AST_Do({\n                    body      : body,\n                    condition : condition,\n                });\n\n              case "while":\n                next();\n                return new AST_While({\n                    condition : parenthesized(),\n                    body      : in_loop(statement),\n                });\n\n              case "for":\n                next();\n                return for_();\n\n              case "function":\n                next();\n                if (!is("operator", "*")) return function_(AST_Defun);\n                next();\n                return function_(AST_GeneratorDefun);\n\n              case "if":\n                next();\n                return if_();\n\n              case "return":\n                if (S.in_function == 0 && !options.bare_returns)\n                    croak("\'return\' outside of function");\n                next();\n                var value = null;\n                if (is("punc", ";")) {\n                    next();\n                } else if (!can_insert_semicolon()) {\n                    value = expression();\n                    semicolon();\n                }\n                return new AST_Return({ value: value });\n\n              case "switch":\n                next();\n                return new AST_Switch({\n                    expression : parenthesized(),\n                    body       : in_loop(switch_body_),\n                });\n\n              case "throw":\n                next();\n                if (has_newline_before(S.token))\n                    croak("Illegal newline after \'throw\'");\n                var value = expression();\n                semicolon();\n                return new AST_Throw({ value: value });\n\n              case "try":\n                next();\n                return try_();\n\n              case "var":\n                next();\n                var node = var_();\n                semicolon();\n                return node;\n\n              case "with":\n                if (S.input.has_directive("use strict")) {\n                    croak("Strict mode may not include a with statement");\n                }\n                next();\n                return new AST_With({\n                    expression : parenthesized(),\n                    body       : statement(),\n                });\n            }\n        }\n        unexpected();\n    });\n\n    function labeled_statement() {\n        var label = as_symbol(AST_Label);\n        if (!all(S.labels, function(l) {\n            return l.name != label.name;\n        })) {\n            // ECMA-262, 12.12: An ECMAScript program is considered\n            // syntactically incorrect if it contains a\n            // LabelledStatement that is enclosed by a\n            // LabelledStatement with the same Identifier as label.\n            croak("Label " + label.name + " defined twice");\n        }\n        expect(":");\n        S.labels.push(label);\n        var stat = statement();\n        S.labels.pop();\n        if (!(stat instanceof AST_IterationStatement)) {\n            // check for `continue` that refers to this label.\n            // those should be reported as syntax errors.\n            // https://github.com/mishoo/UglifyJS/issues/287\n            label.references.forEach(function(ref) {\n                if (ref instanceof AST_Continue) {\n                    token_error(ref.label.start, "Continue label `" + label.name + "` must refer to IterationStatement");\n                }\n            });\n        }\n        return new AST_LabeledStatement({ body: stat, label: label });\n    }\n\n    function simple_statement() {\n        var body = expression();\n        semicolon();\n        return new AST_SimpleStatement({ body: body });\n    }\n\n    function break_cont(type) {\n        var label = null, ldef;\n        if (!can_insert_semicolon()) {\n            label = as_symbol(AST_LabelRef, true);\n        }\n        if (label != null) {\n            ldef = find_if(function(l) {\n                return l.name == label.name;\n            }, S.labels);\n            if (!ldef) token_error(label.start, "Undefined label " + label.name);\n            label.thedef = ldef;\n        } else if (S.in_loop == 0) croak(type.TYPE + " not inside a loop or switch");\n        semicolon();\n        var stat = new type({ label: label });\n        if (ldef) ldef.references.push(stat);\n        return stat;\n    }\n\n    function has_modifier(name, no_nlb) {\n        if (!is("name", name)) return;\n        var token = peek();\n        if (!token) return;\n        if (is_token(token, "operator", "=")) return;\n        if (token.type == "punc" && /^[(;}]$/.test(token.value)) return;\n        if (no_nlb && has_newline_before(token)) return;\n        return next();\n    }\n\n    function class_(ctor) {\n        var was_async = S.in_async;\n        var was_gen = S.in_generator;\n        S.input.push_directives_stack();\n        S.input.add_directive("use strict");\n        var name;\n        if (ctor === AST_DefClass) {\n            name = as_symbol(AST_SymbolDefClass);\n        } else {\n            name = as_symbol(AST_SymbolClass, true);\n        }\n        var parent = null;\n        if (is("keyword", "extends")) {\n            next();\n            handle_regexp();\n            parent = expr_atom(true);\n        }\n        expect("{");\n        var props = [];\n        while (!is("punc", "}")) {\n            if (is("punc", ";")) {\n                next();\n                continue;\n            }\n            var start = S.token;\n            var fixed = !!has_modifier("static");\n            var async = has_modifier("async", true);\n            if (is("operator", "*")) {\n                next();\n                var internal = is("name") && /^#/.test(S.token.value);\n                var key = as_property_key();\n                var gen_start = S.token;\n                var gen = function_(async ? AST_AsyncGeneratorFunction : AST_GeneratorFunction);\n                gen.start = gen_start;\n                gen.end = prev();\n                props.push(new AST_ClassMethod({\n                    start: start,\n                    static: fixed,\n                    private: internal,\n                    key: key,\n                    value: gen,\n                    end: prev(),\n                }));\n                continue;\n            }\n            if (fixed && is("punc", "{")) {\n                props.push(new AST_ClassInit({\n                    start: start,\n                    value: new AST_ClassInitBlock({\n                        start: start,\n                        body: block_(),\n                        end: prev(),\n                    }),\n                    end: prev(),\n                }));\n                continue;\n            }\n            var internal = is("name") && /^#/.test(S.token.value);\n            var key = as_property_key();\n            if (is("punc", "(")) {\n                var func_start = S.token;\n                var func = function_(async ? AST_AsyncFunction : AST_Function);\n                func.start = func_start;\n                func.end = prev();\n                props.push(new AST_ClassMethod({\n                    start: start,\n                    static: fixed,\n                    private: internal,\n                    key: key,\n                    value: func,\n                    end: prev(),\n                }));\n                continue;\n            }\n            if (async) unexpected(async);\n            var value = null;\n            if (is("operator", "=")) {\n                next();\n                S.in_async = false;\n                S.in_generator = false;\n                value = maybe_assign();\n                S.in_generator = was_gen;\n                S.in_async = was_async;\n            } else if (!(is("punc", ";") || is("punc", "}"))) {\n                var type = null;\n                switch (key) {\n                  case "get":\n                    type = AST_ClassGetter;\n                    break;\n                  case "set":\n                    type = AST_ClassSetter;\n                    break;\n                }\n                if (type) {\n                    props.push(new type({\n                        start: start,\n                        static: fixed,\n                        private: is("name") && /^#/.test(S.token.value),\n                        key: as_property_key(),\n                        value: create_accessor(),\n                        end: prev(),\n                    }));\n                    continue;\n                }\n            }\n            semicolon();\n            props.push(new AST_ClassField({\n                start: start,\n                static: fixed,\n                private: internal,\n                key: key,\n                value: value,\n                end: prev(),\n            }));\n        }\n        next();\n        S.input.pop_directives_stack();\n        S.in_generator = was_gen;\n        S.in_async = was_async;\n        return new ctor({\n            extends: parent,\n            name: name,\n            properties: props,\n        });\n    }\n\n    function for_() {\n        var await_token = is("name", "await") && next();\n        expect("(");\n        var init = null;\n        if (await_token || !is("punc", ";")) {\n            init = is("keyword", "const")\n                ? (next(), const_(true))\n                : is("name", "let") && is_vardefs()\n                ? (next(), let_(true))\n                : is("keyword", "var")\n                ? (next(), var_(true))\n                : expression(true);\n            var ctor;\n            if (await_token) {\n                expect_token("name", "of");\n                ctor = AST_ForAwaitOf;\n            } else if (is("operator", "in")) {\n                next();\n                ctor = AST_ForIn;\n            } else if (is("name", "of")) {\n                next();\n                ctor = AST_ForOf;\n            }\n            if (ctor) {\n                if (init instanceof AST_Definitions) {\n                    if (init.definitions.length > 1) {\n                        token_error(init.start, "Only one variable declaration allowed in for..in/of loop");\n                    }\n                    if (ctor !== AST_ForIn && init.definitions[0].value) {\n                        token_error(init.definitions[0].value.start, "No initializers allowed in for..of loop");\n                    }\n                } else if (!(is_assignable(init) || (init = to_destructured(init)) instanceof AST_Destructured)) {\n                    token_error(init.start, "Invalid left-hand side in for..in/of loop");\n                }\n                return for_enum(ctor, init);\n            }\n        }\n        return regular_for(init);\n    }\n\n    function regular_for(init) {\n        expect(";");\n        var test = is("punc", ";") ? null : expression();\n        expect(";");\n        var step = is("punc", ")") ? null : expression();\n        expect(")");\n        return new AST_For({\n            init      : init,\n            condition : test,\n            step      : step,\n            body      : in_loop(statement)\n        });\n    }\n\n    function for_enum(ctor, init) {\n        handle_regexp();\n        var obj = expression();\n        expect(")");\n        return new ctor({\n            init   : init,\n            object : obj,\n            body   : in_loop(statement)\n        });\n    }\n\n    function to_funarg(node) {\n        if (node instanceof AST_Array) {\n            var rest = null;\n            if (node.elements[node.elements.length - 1] instanceof AST_Spread) {\n                rest = to_funarg(node.elements.pop().expression);\n            }\n            return new AST_DestructuredArray({\n                start: node.start,\n                elements: node.elements.map(to_funarg),\n                rest: rest,\n                end: node.end,\n            });\n        }\n        if (node instanceof AST_Assign) return new AST_DefaultValue({\n            start: node.start,\n            name: to_funarg(node.left),\n            value: node.right,\n            end: node.end,\n        });\n        if (node instanceof AST_DefaultValue) {\n            node.name = to_funarg(node.name);\n            return node;\n        }\n        if (node instanceof AST_DestructuredArray) {\n            node.elements = node.elements.map(to_funarg);\n            if (node.rest) node.rest = to_funarg(node.rest);\n            return node;\n        }\n        if (node instanceof AST_DestructuredObject) {\n            node.properties.forEach(function(prop) {\n                prop.value = to_funarg(prop.value);\n            });\n            if (node.rest) node.rest = to_funarg(node.rest);\n            return node;\n        }\n        if (node instanceof AST_Hole) return node;\n        if (node instanceof AST_Object) {\n            var rest = null;\n            if (node.properties[node.properties.length - 1] instanceof AST_Spread) {\n                rest = to_funarg(node.properties.pop().expression);\n            }\n            return new AST_DestructuredObject({\n                start: node.start,\n                properties: node.properties.map(function(prop) {\n                    if (!(prop instanceof AST_ObjectKeyVal)) token_error(prop.start, "Invalid destructuring assignment");\n                    return new AST_DestructuredKeyVal({\n                        start: prop.start,\n                        key: prop.key,\n                        value: to_funarg(prop.value),\n                        end: prop.end,\n                    });\n                }),\n                rest: rest,\n                end: node.end,\n            });\n        }\n        if (node instanceof AST_SymbolFunarg) return node;\n        if (node instanceof AST_SymbolRef) return new AST_SymbolFunarg(node);\n        if (node instanceof AST_Yield) return new AST_SymbolFunarg({\n            start: node.start,\n            name: "yield",\n            end: node.end,\n        });\n        token_error(node.start, "Invalid arrow parameter");\n    }\n\n    function arrow(exprs, start, async) {\n        var was_async = S.in_async;\n        var was_gen = S.in_generator;\n        S.in_async = async;\n        S.in_generator = false;\n        var was_funarg = S.in_funarg;\n        S.in_funarg = S.in_function;\n        var argnames = exprs.map(to_funarg);\n        var rest = exprs.rest || null;\n        if (rest) rest = to_funarg(rest);\n        S.in_funarg = was_funarg;\n        expect("=>");\n        var body, value;\n        var loop = S.in_loop;\n        var labels = S.labels;\n        ++S.in_function;\n        S.input.push_directives_stack();\n        S.in_loop = 0;\n        S.labels = [];\n        if (is("punc", "{")) {\n            S.in_directives = true;\n            body = block_();\n            value = null;\n        } else {\n            body = [];\n            handle_regexp();\n            value = maybe_assign();\n        }\n        var is_strict = S.input.has_directive("use strict");\n        S.input.pop_directives_stack();\n        --S.in_function;\n        S.in_loop = loop;\n        S.labels = labels;\n        S.in_generator = was_gen;\n        S.in_async = was_async;\n        var node = new (async ? AST_AsyncArrow : AST_Arrow)({\n            start: start,\n            argnames: argnames,\n            rest: rest,\n            body: body,\n            value: value,\n            end: prev(),\n        });\n        if (is_strict) node.each_argname(strict_verify_symbol);\n        return node;\n    }\n\n    var function_ = function(ctor) {\n        var was_async = S.in_async;\n        var was_gen = S.in_generator;\n        var name;\n        if (/Defun$/.test(ctor.TYPE)) {\n            name = as_symbol(AST_SymbolDefun);\n            S.in_async = /^Async/.test(ctor.TYPE);\n            S.in_generator = /Generator/.test(ctor.TYPE);\n        } else {\n            S.in_async = /^Async/.test(ctor.TYPE);\n            S.in_generator = /Generator/.test(ctor.TYPE);\n            name = as_symbol(AST_SymbolLambda, true);\n        }\n        if (name && ctor !== AST_Accessor && !(name instanceof AST_SymbolDeclaration))\n            unexpected(prev());\n        expect("(");\n        var was_funarg = S.in_funarg;\n        S.in_funarg = S.in_function;\n        var argnames = expr_list(")", !options.strict, false, function() {\n            return maybe_default(AST_SymbolFunarg);\n        });\n        S.in_funarg = was_funarg;\n        var loop = S.in_loop;\n        var labels = S.labels;\n        ++S.in_function;\n        S.in_directives = true;\n        S.input.push_directives_stack();\n        S.in_loop = 0;\n        S.labels = [];\n        var body = block_();\n        var is_strict = S.input.has_directive("use strict");\n        S.input.pop_directives_stack();\n        --S.in_function;\n        S.in_loop = loop;\n        S.labels = labels;\n        S.in_generator = was_gen;\n        S.in_async = was_async;\n        var node = new ctor({\n            name: name,\n            argnames: argnames,\n            rest: argnames.rest || null,\n            body: body,\n        });\n        if (is_strict) {\n            if (name) strict_verify_symbol(name);\n            node.each_argname(strict_verify_symbol);\n        }\n        return node;\n    };\n\n    function if_() {\n        var cond = parenthesized(), body = statement(), alt = null;\n        if (is("keyword", "else")) {\n            next();\n            alt = statement();\n        }\n        return new AST_If({\n            condition   : cond,\n            body        : body,\n            alternative : alt,\n        });\n    }\n\n    function is_alias() {\n        return is("name") || is("string") || is_identifier_string(S.token.value);\n    }\n\n    function make_string(token) {\n        return new AST_String({\n            start: token,\n            quote: token.quote,\n            value: token.value,\n            end: token,\n        });\n    }\n\n    function as_path() {\n        var path = S.token;\n        expect_token("string");\n        semicolon();\n        return make_string(path);\n    }\n\n    function export_() {\n        if (is("operator", "*")) {\n            var key = S.token;\n            var alias = key;\n            next();\n            if (is("name", "as")) {\n                next();\n                if (!is_alias()) expect_token("name");\n                alias = S.token;\n                next();\n            }\n            expect_token("name", "from");\n            return new AST_ExportForeign({\n                aliases: [ make_string(alias) ],\n                keys: [ make_string(key) ],\n                path: as_path(),\n            });\n        }\n        if (is("punc", "{")) {\n            next();\n            var aliases = [];\n            var keys = [];\n            while (is_alias()) {\n                var key = S.token;\n                next();\n                keys.push(key);\n                if (is("name", "as")) {\n                    next();\n                    if (!is_alias()) expect_token("name");\n                    aliases.push(S.token);\n                    next();\n                } else {\n                    aliases.push(key);\n                }\n                if (!is("punc", "}")) expect(",");\n            }\n            expect("}");\n            if (is("name", "from")) {\n                next();\n                return new AST_ExportForeign({\n                    aliases: aliases.map(make_string),\n                    keys: keys.map(make_string),\n                    path: as_path(),\n                });\n            }\n            semicolon();\n            return new AST_ExportReferences({\n                properties: keys.map(function(token, index) {\n                    if (!is_token(token, "name")) token_error(token, "Name expected");\n                    var sym = _make_symbol(AST_SymbolExport, token);\n                    sym.alias = make_string(aliases[index]);\n                    return sym;\n                }),\n            });\n        }\n        if (is("keyword", "default")) {\n            next();\n            var start = S.token;\n            var body = export_default_decl();\n            if (body) {\n                body.start = start;\n                body.end = prev();\n            } else {\n                handle_regexp();\n                body = expression();\n                semicolon();\n            }\n            return new AST_ExportDefault({ body: body });\n        }\n        return new AST_ExportDeclaration({ body: export_decl() });\n    }\n\n    function maybe_named(def, expr) {\n        if (expr.name) {\n            expr = new def(expr);\n            expr.name = new (def === AST_DefClass ? AST_SymbolDefClass : AST_SymbolDefun)(expr.name);\n        }\n        return expr;\n    }\n\n    function export_default_decl() {\n        if (is("name", "async")) {\n            if (!is_token(peek(), "keyword", "function")) return;\n            next();\n            next();\n            if (!is("operator", "*")) return maybe_named(AST_AsyncDefun, function_(AST_AsyncFunction));\n            next();\n            return maybe_named(AST_AsyncGeneratorDefun, function_(AST_AsyncGeneratorFunction));\n        } else if (is("keyword")) switch (S.token.value) {\n          case "class":\n            next();\n            return maybe_named(AST_DefClass, class_(AST_ClassExpression));\n          case "function":\n            next();\n            if (!is("operator", "*")) return maybe_named(AST_Defun, function_(AST_Function));\n            next();\n            return maybe_named(AST_GeneratorDefun, function_(AST_GeneratorFunction));\n        }\n    }\n\n    var export_decl = embed_tokens(function() {\n        if (is("name")) switch (S.token.value) {\n          case "async":\n            next();\n            expect_token("keyword", "function");\n            if (!is("operator", "*")) return function_(AST_AsyncDefun);\n            next();\n            return function_(AST_AsyncGeneratorDefun);\n          case "let":\n            next();\n            var node = let_();\n            semicolon();\n            return node;\n        } else if (is("keyword")) switch (S.token.value) {\n          case "class":\n            next();\n            return class_(AST_DefClass);\n          case "const":\n            next();\n            var node = const_();\n            semicolon();\n            return node;\n          case "function":\n            next();\n            if (!is("operator", "*")) return function_(AST_Defun);\n            next();\n            return function_(AST_GeneratorDefun);\n          case "var":\n            next();\n            var node = var_();\n            semicolon();\n            return node;\n        }\n        unexpected();\n    });\n\n    function import_() {\n        var all = null;\n        var def = as_symbol(AST_SymbolImport, true);\n        var props = null;\n        var cont;\n        if (def) {\n            def.key = new AST_String({\n                start: def.start,\n                value: "",\n                end: def.end,\n            });\n            if (cont = is("punc", ",")) next();\n        } else {\n            cont = !is("string");\n        }\n        if (cont) {\n            if (is("operator", "*")) {\n                var key = S.token;\n                next();\n                expect_token("name", "as");\n                all = as_symbol(AST_SymbolImport);\n                all.key = make_string(key);\n            } else {\n                expect("{");\n                props = [];\n                while (is_alias()) {\n                    var alias;\n                    if (is_token(peek(), "name", "as")) {\n                        var key = S.token;\n                        next();\n                        next();\n                        alias = as_symbol(AST_SymbolImport);\n                        alias.key = make_string(key);\n                    } else {\n                        alias = as_symbol(AST_SymbolImport);\n                        alias.key = new AST_String({\n                            start: alias.start,\n                            value: alias.name,\n                            end: alias.end,\n                        });\n                    }\n                    props.push(alias);\n                    if (!is("punc", "}")) expect(",");\n                }\n                expect("}");\n            }\n        }\n        if (all || def || props) expect_token("name", "from");\n        return new AST_Import({\n            all: all,\n            default: def,\n            path: as_path(),\n            properties: props,\n        });\n    }\n\n    function block_() {\n        expect("{");\n        var a = [];\n        while (!is("punc", "}")) {\n            if (is("eof")) expect("}");\n            a.push(statement());\n        }\n        next();\n        return a;\n    }\n\n    function switch_body_() {\n        expect("{");\n        var a = [], branch, cur, default_branch, tmp;\n        while (!is("punc", "}")) {\n            if (is("eof")) expect("}");\n            if (is("keyword", "case")) {\n                if (branch) branch.end = prev();\n                cur = [];\n                branch = new AST_Case({\n                    start      : (tmp = S.token, next(), tmp),\n                    expression : expression(),\n                    body       : cur\n                });\n                a.push(branch);\n                expect(":");\n            } else if (is("keyword", "default")) {\n                if (branch) branch.end = prev();\n                if (default_branch) croak("More than one default clause in switch statement");\n                cur = [];\n                branch = new AST_Default({\n                    start : (tmp = S.token, next(), expect(":"), tmp),\n                    body  : cur\n                });\n                a.push(branch);\n                default_branch = branch;\n            } else {\n                if (!cur) unexpected();\n                cur.push(statement());\n            }\n        }\n        if (branch) branch.end = prev();\n        next();\n        return a;\n    }\n\n    function try_() {\n        var body = block_(), bcatch = null, bfinally = null;\n        if (is("keyword", "catch")) {\n            var start = S.token;\n            next();\n            var name = null;\n            if (is("punc", "(")) {\n                next();\n                name = maybe_destructured(AST_SymbolCatch);\n                expect(")");\n            }\n            bcatch = new AST_Catch({\n                start   : start,\n                argname : name,\n                body    : block_(),\n                end     : prev()\n            });\n        }\n        if (is("keyword", "finally")) {\n            var start = S.token;\n            next();\n            bfinally = new AST_Finally({\n                start : start,\n                body  : block_(),\n                end   : prev()\n            });\n        }\n        if (!bcatch && !bfinally)\n            croak("Missing catch/finally blocks");\n        return new AST_Try({\n            body     : body,\n            bcatch   : bcatch,\n            bfinally : bfinally\n        });\n    }\n\n    function vardefs(type, no_in) {\n        var a = [];\n        for (;;) {\n            var start = S.token;\n            var name = maybe_destructured(type);\n            var value = null;\n            if (is("operator", "=")) {\n                next();\n                value = maybe_assign(no_in);\n            } else if (!no_in && (type === AST_SymbolConst || name instanceof AST_Destructured)) {\n                croak("Missing initializer in declaration");\n            }\n            a.push(new AST_VarDef({\n                start : start,\n                name  : name,\n                value : value,\n                end   : prev()\n            }));\n            if (!is("punc", ","))\n                break;\n            next();\n        }\n        return a;\n    }\n\n    function is_vardefs() {\n        var token = peek();\n        return is_token(token, "name") || is_token(token, "punc", "[") || is_token(token, "punc", "{");\n    }\n\n    var const_ = function(no_in) {\n        return new AST_Const({\n            start       : prev(),\n            definitions : vardefs(AST_SymbolConst, no_in),\n            end         : prev()\n        });\n    };\n\n    var let_ = function(no_in) {\n        return new AST_Let({\n            start       : prev(),\n            definitions : vardefs(AST_SymbolLet, no_in),\n            end         : prev()\n        });\n    };\n\n    var var_ = function(no_in) {\n        return new AST_Var({\n            start       : prev(),\n            definitions : vardefs(AST_SymbolVar, no_in),\n            end         : prev()\n        });\n    };\n\n    var new_ = function(allow_calls) {\n        var start = S.token;\n        expect_token("operator", "new");\n        var call;\n        if (is("punc", ".") && is_token(peek(), "name", "target")) {\n            next();\n            next();\n            call = new AST_NewTarget();\n        } else {\n            var exp = expr_atom(false), args;\n            if (is("punc", "(")) {\n                next();\n                args = expr_list(")", !options.strict);\n            } else {\n                args = [];\n            }\n            call = new AST_New({ expression: exp, args: args });\n        }\n        call.start = start;\n        call.end = prev();\n        return subscripts(call, allow_calls);\n    };\n\n    function as_atom_node() {\n        var ret, tok = S.token, value = tok.value;\n        switch (tok.type) {\n          case "num":\n            if (isFinite(value)) {\n                ret = new AST_Number({ value: value });\n            } else {\n                ret = new AST_Infinity();\n                if (value < 0) ret = new AST_UnaryPrefix({ operator: "-", expression: ret });\n            }\n            break;\n          case "bigint":\n            ret = new AST_BigInt({ value: value });\n            break;\n          case "string":\n            ret = new AST_String({ value: value, quote: tok.quote });\n            break;\n          case "regexp":\n            ret = new AST_RegExp({ value: value });\n            break;\n          case "atom":\n            switch (value) {\n              case "false":\n                ret = new AST_False();\n                break;\n              case "true":\n                ret = new AST_True();\n                break;\n              case "null":\n                ret = new AST_Null();\n                break;\n              default:\n                unexpected();\n            }\n            break;\n          default:\n            unexpected();\n        }\n        next();\n        ret.start = ret.end = tok;\n        return ret;\n    }\n\n    var expr_atom = function(allow_calls) {\n        if (is("operator", "new")) {\n            return new_(allow_calls);\n        }\n        var start = S.token;\n        if (is("punc")) {\n            switch (start.value) {\n              case "`":\n                return subscripts(template(null), allow_calls);\n              case "(":\n                next();\n                if (is("punc", ")")) {\n                    next();\n                    return arrow([], start);\n                }\n                var ex = expression(false, true);\n                var len = start.comments_before.length;\n                [].unshift.apply(ex.start.comments_before, start.comments_before);\n                start.comments_before.length = 0;\n                start.comments_before = ex.start.comments_before;\n                start.comments_before_length = len;\n                if (len == 0 && start.comments_before.length > 0) {\n                    var comment = start.comments_before[0];\n                    if (!comment.nlb) {\n                        comment.nlb = start.nlb;\n                        start.nlb = false;\n                    }\n                }\n                start.comments_after = ex.start.comments_after;\n                ex.start = start;\n                expect(")");\n                var end = prev();\n                end.comments_before = ex.end.comments_before;\n                end.comments_after.forEach(function(comment) {\n                    ex.end.comments_after.push(comment);\n                    if (comment.nlb) S.token.nlb = true;\n                });\n                end.comments_after.length = 0;\n                end.comments_after = ex.end.comments_after;\n                ex.end = end;\n                if (is("punc", "=>")) return arrow(ex instanceof AST_Sequence ? ex.expressions : [ ex ], start);\n                return subscripts(ex, allow_calls);\n              case "[":\n                return subscripts(array_(), allow_calls);\n              case "{":\n                return subscripts(object_(), allow_calls);\n            }\n            unexpected();\n        }\n        if (is("keyword")) switch (start.value) {\n          case "class":\n            next();\n            var clazz = class_(AST_ClassExpression);\n            clazz.start = start;\n            clazz.end = prev();\n            return subscripts(clazz, allow_calls);\n          case "function":\n            next();\n            var func;\n            if (is("operator", "*")) {\n                next();\n                func = function_(AST_GeneratorFunction);\n            } else {\n                func = function_(AST_Function);\n            }\n            func.start = start;\n            func.end = prev();\n            return subscripts(func, allow_calls);\n        }\n        if (is("name")) {\n            var sym = _make_symbol(AST_SymbolRef, start);\n            next();\n            if (sym.name == "async") {\n                if (is("keyword", "function")) {\n                    next();\n                    var func;\n                    if (is("operator", "*")) {\n                        next();\n                        func = function_(AST_AsyncGeneratorFunction);\n                    } else {\n                        func = function_(AST_AsyncFunction);\n                    }\n                    func.start = start;\n                    func.end = prev();\n                    return subscripts(func, allow_calls);\n                }\n                if (is("name") && is_token(peek(), "punc", "=>")) {\n                    start = S.token;\n                    sym = _make_symbol(AST_SymbolRef, start);\n                    next();\n                    return arrow([ sym ], start, true);\n                }\n                if (is("punc", "(")) {\n                    var call = subscripts(sym, allow_calls);\n                    if (!is("punc", "=>")) return call;\n                    var args = call.args;\n                    if (args[args.length - 1] instanceof AST_Spread) {\n                        args.rest = args.pop().expression;\n                    }\n                    return arrow(args, start, true);\n                }\n            }\n            return is("punc", "=>") ? arrow([ sym ], start) : subscripts(sym, allow_calls);\n        }\n        if (ATOMIC_START_TOKEN[S.token.type]) {\n            return subscripts(as_atom_node(), allow_calls);\n        }\n        unexpected();\n    };\n\n    function expr_list(closing, allow_trailing_comma, allow_empty, parser) {\n        if (!parser) parser = maybe_assign;\n        var first = true, a = [];\n        while (!is("punc", closing)) {\n            if (first) first = false; else expect(",");\n            if (allow_trailing_comma && is("punc", closing)) break;\n            if (allow_empty && is("punc", ",")) {\n                a.push(new AST_Hole({ start: S.token, end: S.token }));\n            } else if (!is("operator", "...")) {\n                a.push(parser());\n            } else if (parser === maybe_assign) {\n                a.push(new AST_Spread({\n                    start: S.token,\n                    expression: (next(), parser()),\n                    end: prev(),\n                }));\n            } else {\n                next();\n                a.rest = parser();\n                if (a.rest instanceof AST_DefaultValue) token_error(a.rest.start, "Invalid rest parameter");\n                break;\n            }\n        }\n        expect(closing);\n        return a;\n    }\n\n    var array_ = embed_tokens(function() {\n        expect("[");\n        return new AST_Array({\n            elements: expr_list("]", !options.strict, true)\n        });\n    });\n\n    var create_accessor = embed_tokens(function() {\n        return function_(AST_Accessor);\n    });\n\n    var object_ = embed_tokens(function() {\n        expect("{");\n        var first = true, a = [];\n        while (!is("punc", "}")) {\n            if (first) first = false; else expect(",");\n            // allow trailing comma\n            if (!options.strict && is("punc", "}")) break;\n            var start = S.token;\n            if (is("operator", "*")) {\n                next();\n                var key = as_property_key();\n                var gen_start = S.token;\n                var gen = function_(AST_GeneratorFunction);\n                gen.start = gen_start;\n                gen.end = prev();\n                a.push(new AST_ObjectMethod({\n                    start: start,\n                    key: key,\n                    value: gen,\n                    end: prev(),\n                }));\n                continue;\n            }\n            if (is("operator", "...")) {\n                next();\n                a.push(new AST_Spread({\n                    start: start,\n                    expression: maybe_assign(),\n                    end: prev(),\n                }));\n                continue;\n            }\n            if (is_token(peek(), "operator", "=")) {\n                var name = as_symbol(AST_SymbolRef);\n                next();\n                a.push(new AST_ObjectKeyVal({\n                    start: start,\n                    key: start.value,\n                    value: new AST_Assign({\n                        start: start,\n                        left: name,\n                        operator: "=",\n                        right: maybe_assign(),\n                        end: prev(),\n                    }),\n                    end: prev(),\n                }));\n                continue;\n            }\n            if (is_token(peek(), "punc", ",") || is_token(peek(), "punc", "}")) {\n                a.push(new AST_ObjectKeyVal({\n                    start: start,\n                    key: start.value,\n                    value: as_symbol(AST_SymbolRef),\n                    end: prev(),\n                }));\n                continue;\n            }\n            var key = as_property_key();\n            if (is("punc", "(")) {\n                var func_start = S.token;\n                var func = function_(AST_Function);\n                func.start = func_start;\n                func.end = prev();\n                a.push(new AST_ObjectMethod({\n                    start: start,\n                    key: key,\n                    value: func,\n                    end: prev(),\n                }));\n                continue;\n            }\n            if (is("punc", ":")) {\n                next();\n                a.push(new AST_ObjectKeyVal({\n                    start: start,\n                    key: key,\n                    value: maybe_assign(),\n                    end: prev(),\n                }));\n                continue;\n            }\n            if (start.type == "name") switch (key) {\n              case "async":\n                var is_gen = is("operator", "*") && next();\n                key = as_property_key();\n                var func_start = S.token;\n                var func = function_(is_gen ? AST_AsyncGeneratorFunction : AST_AsyncFunction);\n                func.start = func_start;\n                func.end = prev();\n                a.push(new AST_ObjectMethod({\n                    start: start,\n                    key: key,\n                    value: func,\n                    end: prev(),\n                }));\n                continue;\n              case "get":\n                a.push(new AST_ObjectGetter({\n                    start: start,\n                    key: as_property_key(),\n                    value: create_accessor(),\n                    end: prev(),\n                }));\n                continue;\n              case "set":\n                a.push(new AST_ObjectSetter({\n                    start: start,\n                    key: as_property_key(),\n                    value: create_accessor(),\n                    end: prev(),\n                }));\n                continue;\n            }\n            unexpected();\n        }\n        next();\n        return new AST_Object({ properties: a });\n    });\n\n    function as_property_key() {\n        var tmp = S.token;\n        switch (tmp.type) {\n          case "operator":\n            if (!KEYWORDS[tmp.value]) unexpected();\n          case "num":\n          case "string":\n          case "name":\n          case "keyword":\n          case "atom":\n            next();\n            return "" + tmp.value;\n          case "punc":\n            expect("[");\n            var key = maybe_assign();\n            expect("]");\n            return key;\n          default:\n            unexpected();\n        }\n    }\n\n    function as_name() {\n        var name = S.token.value;\n        expect_token("name");\n        return name;\n    }\n\n    function _make_symbol(type, token) {\n        var name = token.value;\n        switch (name) {\n          case "await":\n            if (S.in_async) unexpected(token);\n            break;\n          case "super":\n            type = AST_Super;\n            break;\n          case "this":\n            type = AST_This;\n            break;\n          case "yield":\n            if (S.in_generator) unexpected(token);\n            break;\n        }\n        return new type({\n            name: "" + name,\n            start: token,\n            end: token,\n        });\n    }\n\n    function strict_verify_symbol(sym) {\n        if (sym.name == "arguments" || sym.name == "eval" || sym.name == "let")\n            token_error(sym.start, "Unexpected " + sym.name + " in strict mode");\n    }\n\n    function as_symbol(type, no_error) {\n        if (!is("name")) {\n            if (!no_error) croak("Name expected");\n            return null;\n        }\n        var sym = _make_symbol(type, S.token);\n        if (S.input.has_directive("use strict") && sym instanceof AST_SymbolDeclaration) {\n            strict_verify_symbol(sym);\n        }\n        next();\n        return sym;\n    }\n\n    function maybe_destructured(type) {\n        var start = S.token;\n        if (is("punc", "[")) {\n            next();\n            var elements = expr_list("]", !options.strict, true, function() {\n                return maybe_default(type);\n            });\n            return new AST_DestructuredArray({\n                start: start,\n                elements: elements,\n                rest: elements.rest || null,\n                end: prev(),\n            });\n        }\n        if (is("punc", "{")) {\n            next();\n            var first = true, a = [], rest = null;\n            while (!is("punc", "}")) {\n                if (first) first = false; else expect(",");\n                // allow trailing comma\n                if (!options.strict && is("punc", "}")) break;\n                var key_start = S.token;\n                if (is("punc", "[") || is_token(peek(), "punc", ":")) {\n                    var key = as_property_key();\n                    expect(":");\n                    a.push(new AST_DestructuredKeyVal({\n                        start: key_start,\n                        key: key,\n                        value: maybe_default(type),\n                        end: prev(),\n                    }));\n                    continue;\n                }\n                if (is("operator", "...")) {\n                    next();\n                    rest = maybe_destructured(type);\n                    break;\n                }\n                var name = as_symbol(type);\n                if (is("operator", "=")) {\n                    next();\n                    name = new AST_DefaultValue({\n                        start: name.start,\n                        name: name,\n                        value: maybe_assign(),\n                        end: prev(),\n                    });\n                }\n                a.push(new AST_DestructuredKeyVal({\n                    start: key_start,\n                    key: key_start.value,\n                    value: name,\n                    end: prev(),\n                }));\n            }\n            expect("}");\n            return new AST_DestructuredObject({\n                start: start,\n                properties: a,\n                rest: rest,\n                end: prev(),\n            });\n        }\n        return as_symbol(type);\n    }\n\n    function maybe_default(type) {\n        var start = S.token;\n        var name = maybe_destructured(type);\n        if (!is("operator", "=")) return name;\n        next();\n        return new AST_DefaultValue({\n            start: start,\n            name: name,\n            value: maybe_assign(),\n            end: prev(),\n        });\n    }\n\n    function template(tag) {\n        var start = tag ? tag.start : S.token;\n        var read = S.input.context().read_template;\n        var strings = [];\n        var expressions = [];\n        while (read(strings)) {\n            next();\n            expressions.push(expression());\n            if (!is("punc", "}")) unexpected();\n        }\n        next();\n        return new AST_Template({\n            start: start,\n            expressions: expressions,\n            strings: strings,\n            tag: tag,\n            end: prev(),\n        });\n    }\n\n    function subscripts(expr, allow_calls) {\n        var start = expr.start;\n        var optional = null;\n        while (true) {\n            if (is("operator", "?") && is_token(peek(), "punc", ".")) {\n                next();\n                next();\n                optional = expr;\n            }\n            if (is("punc", "[")) {\n                next();\n                var prop = expression();\n                expect("]");\n                expr = new AST_Sub({\n                    start: start,\n                    optional: optional === expr,\n                    expression: expr,\n                    property: prop,\n                    end: prev(),\n                });\n            } else if (allow_calls && is("punc", "(")) {\n                next();\n                expr = new AST_Call({\n                    start: start,\n                    optional: optional === expr,\n                    expression: expr,\n                    args: expr_list(")", !options.strict),\n                    end: prev(),\n                });\n            } else if (optional === expr || is("punc", ".")) {\n                if (optional !== expr) next();\n                expr = new AST_Dot({\n                    start: start,\n                    optional: optional === expr,\n                    expression: expr,\n                    property: as_name(),\n                    end: prev(),\n                });\n            } else if (is("punc", "`")) {\n                if (optional) croak("Invalid template on optional chain");\n                expr = template(expr);\n            } else {\n                break;\n            }\n        }\n        if (optional) expr.terminal = true;\n        if (expr instanceof AST_Call && !expr.pure) {\n            var start = expr.start;\n            var comments = start.comments_before;\n            var i = HOP(start, "comments_before_length") ? start.comments_before_length : comments.length;\n            while (--i >= 0) {\n                if (/[@#]__PURE__/.test(comments[i].value)) {\n                    expr.pure = true;\n                    break;\n                }\n            }\n        }\n        return expr;\n    }\n\n    function maybe_unary(no_in) {\n        var start = S.token;\n        if (S.in_async && is("name", "await")) {\n            if (S.in_funarg === S.in_function) croak("Invalid use of await in function argument");\n            S.input.context().regex_allowed = true;\n            next();\n            return new AST_Await({\n                start: start,\n                expression: maybe_unary(no_in),\n                end: prev(),\n            });\n        }\n        if (S.in_generator && is("name", "yield")) {\n            if (S.in_funarg === S.in_function) croak("Invalid use of yield in function argument");\n            S.input.context().regex_allowed = true;\n            next();\n            var exp = null;\n            var nested = false;\n            if (is("operator", "*")) {\n                next();\n                exp = maybe_assign(no_in);\n                nested = true;\n            } else if (is("punc") ? !PUNC_AFTER_EXPRESSION[S.token.value] : !can_insert_semicolon()) {\n                exp = maybe_assign(no_in);\n            }\n            return new AST_Yield({\n                start: start,\n                expression: exp,\n                nested: nested,\n                end: prev(),\n            });\n        }\n        if (is("operator") && UNARY_PREFIX[start.value]) {\n            next();\n            handle_regexp();\n            var ex = make_unary(AST_UnaryPrefix, start, maybe_unary(no_in));\n            ex.start = start;\n            ex.end = prev();\n            return ex;\n        }\n        var val = expr_atom(true);\n        while (is("operator") && UNARY_POSTFIX[S.token.value] && !has_newline_before(S.token)) {\n            val = make_unary(AST_UnaryPostfix, S.token, val);\n            val.start = start;\n            val.end = S.token;\n            next();\n        }\n        return val;\n    }\n\n    function make_unary(ctor, token, expr) {\n        var op = token.value;\n        switch (op) {\n          case "++":\n          case "--":\n            if (!is_assignable(expr))\n                token_error(token, "Invalid use of " + op + " operator");\n            break;\n          case "delete":\n            if (expr instanceof AST_SymbolRef && S.input.has_directive("use strict"))\n                token_error(expr.start, "Calling delete on expression not allowed in strict mode");\n            break;\n        }\n        return new ctor({ operator: op, expression: expr });\n    }\n\n    var expr_op = function(left, min_precision, no_in) {\n        var op = is("operator") ? S.token.value : null;\n        if (op == "in" && no_in) op = null;\n        var precision = op != null ? PRECEDENCE[op] : null;\n        if (precision != null && precision > min_precision) {\n            next();\n            var right = expr_op(maybe_unary(no_in), op == "**" ? precision - 1 : precision, no_in);\n            return expr_op(new AST_Binary({\n                start    : left.start,\n                left     : left,\n                operator : op,\n                right    : right,\n                end      : right.end,\n            }), min_precision, no_in);\n        }\n        return left;\n    };\n\n    function expr_ops(no_in) {\n        return expr_op(maybe_unary(no_in), 0, no_in);\n    }\n\n    var maybe_conditional = function(no_in) {\n        var start = S.token;\n        var expr = expr_ops(no_in);\n        if (is("operator", "?")) {\n            next();\n            var yes = maybe_assign();\n            expect(":");\n            return new AST_Conditional({\n                start       : start,\n                condition   : expr,\n                consequent  : yes,\n                alternative : maybe_assign(no_in),\n                end         : prev()\n            });\n        }\n        return expr;\n    };\n\n    function is_assignable(expr) {\n        return expr instanceof AST_PropAccess && !expr.optional || expr instanceof AST_SymbolRef;\n    }\n\n    function to_destructured(node) {\n        if (node instanceof AST_Array) {\n            var rest = null;\n            if (node.elements[node.elements.length - 1] instanceof AST_Spread) {\n                rest = to_destructured(node.elements.pop().expression);\n                if (!(rest instanceof AST_Destructured || is_assignable(rest))) return node;\n            }\n            var elements = node.elements.map(to_destructured);\n            return all(elements, function(node) {\n                return node instanceof AST_DefaultValue\n                    || node instanceof AST_Destructured\n                    || node instanceof AST_Hole\n                    || is_assignable(node);\n            }) ? new AST_DestructuredArray({\n                start: node.start,\n                elements: elements,\n                rest: rest,\n                end: node.end,\n            }) : node;\n        }\n        if (node instanceof AST_Assign) {\n            var name = to_destructured(node.left);\n            return name instanceof AST_Destructured || is_assignable(name) ? new AST_DefaultValue({\n                start: node.start,\n                name: name,\n                value: node.right,\n                end: node.end,\n            }) : node;\n        }\n        if (!(node instanceof AST_Object)) return node;\n        var rest = null;\n        if (node.properties[node.properties.length - 1] instanceof AST_Spread) {\n            rest = to_destructured(node.properties.pop().expression);\n            if (!(rest instanceof AST_Destructured || is_assignable(rest))) return node;\n        }\n        var props = [];\n        for (var i = 0; i < node.properties.length; i++) {\n            var prop = node.properties[i];\n            if (!(prop instanceof AST_ObjectKeyVal)) return node;\n            var value = to_destructured(prop.value);\n            if (!(value instanceof AST_DefaultValue || value instanceof AST_Destructured || is_assignable(value))) {\n                return node;\n            }\n            props.push(new AST_DestructuredKeyVal({\n                start: prop.start,\n                key: prop.key,\n                value: value,\n                end: prop.end,\n            }));\n        }\n        return new AST_DestructuredObject({\n            start: node.start,\n            properties: props,\n            rest: rest,\n            end: node.end,\n        });\n    }\n\n    function maybe_assign(no_in) {\n        var start = S.token;\n        var left = maybe_conditional(no_in), val = S.token.value;\n        if (is("operator") && ASSIGNMENT[val]) {\n            if (is_assignable(left) || val == "=" && (left = to_destructured(left)) instanceof AST_Destructured) {\n                next();\n                return new AST_Assign({\n                    start    : start,\n                    left     : left,\n                    operator : val,\n                    right    : maybe_assign(no_in),\n                    end      : prev()\n                });\n            }\n            croak("Invalid assignment");\n        }\n        return left;\n    }\n\n    function expression(no_in, maybe_arrow) {\n        var start = S.token;\n        var exprs = [];\n        while (true) {\n            if (maybe_arrow && is("operator", "...")) {\n                next();\n                exprs.rest = maybe_destructured(AST_SymbolFunarg);\n                break;\n            }\n            exprs.push(maybe_assign(no_in));\n            if (!is("punc", ",")) break;\n            next();\n            if (maybe_arrow && is("punc", ")") && is_token(peek(), "punc", "=>")) break;\n        }\n        return exprs.length == 1 && !exprs.rest ? exprs[0] : new AST_Sequence({\n            start: start,\n            expressions: exprs,\n            end: prev(),\n        });\n    }\n\n    function in_loop(cont) {\n        ++S.in_loop;\n        var ret = cont();\n        --S.in_loop;\n        return ret;\n    }\n\n    if (options.expression) {\n        handle_regexp();\n        var exp = expression();\n        expect_token("eof");\n        return exp;\n    }\n\n    return function() {\n        var start = S.token;\n        var body = [];\n        if (options.module) {\n            S.in_async = true;\n            S.input.add_directive("use strict");\n        }\n        S.input.push_directives_stack();\n        while (!is("eof"))\n            body.push(statement(true));\n        S.input.pop_directives_stack();\n        var end = prev() || start;\n        var toplevel = options.toplevel;\n        if (toplevel) {\n            toplevel.body = toplevel.body.concat(body);\n            toplevel.end = end;\n        } else {\n            toplevel = new AST_Toplevel({ start: start, body: body, end: end });\n        }\n        return toplevel;\n    }();\n}\n'},19653:(e,t,r)=>{"use strict";r.d(t,{Z:()=>n});const n='/***********************************************************************\n\n  A JavaScript tokenizer / parser / beautifier / compressor.\n  https://github.com/mishoo/UglifyJS\n\n  -------------------------------- (C) ---------------------------------\n\n                           Author: Mihai Bazon\n                         <mihai.bazon@gmail.com>\n                       http://mihai.bazon.net/blog\n\n  Distributed under the BSD license:\n\n    Copyright 2012 (c) Mihai Bazon <mihai.bazon@gmail.com>\n\n    Redistribution and use in source and binary forms, with or without\n    modification, are permitted provided that the following conditions\n    are met:\n\n        * Redistributions of source code must retain the above\n          copyright notice, this list of conditions and the following\n          disclaimer.\n\n        * Redistributions in binary form must reproduce the above\n          copyright notice, this list of conditions and the following\n          disclaimer in the documentation and/or other materials\n          provided with the distribution.\n\n    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY\n    EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE\n    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,\n    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR\n    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF\n    THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n    SUCH DAMAGE.\n\n ***********************************************************************/\n\n"use strict";\n\nfunction get_builtins() {\n    var names = new Dictionary();\n    // constants\n    [\n        "NaN",\n        "null",\n        "true",\n        "false",\n        "Infinity",\n        "-Infinity",\n        "undefined",\n    ].forEach(add);\n    // global functions\n    [\n        "encodeURI",\n        "encodeURIComponent",\n        "escape",\n        "eval",\n        "decodeURI",\n        "decodeURIComponent",\n        "isFinite",\n        "isNaN",\n        "parseFloat",\n        "parseInt",\n        "unescape",\n    ].forEach(add);\n    // global constructors & objects\n    var global = Function("return this")();\n    [\n        "Array",\n        "ArrayBuffer",\n        "Atomics",\n        "BigInt",\n        "Boolean",\n        "console",\n        "DataView",\n        "Date",\n        "Error",\n        "Function",\n        "Int8Array",\n        "Intl",\n        "JSON",\n        "Map",\n        "Math",\n        "Number",\n        "Object",\n        "Promise",\n        "Proxy",\n        "Reflect",\n        "RegExp",\n        "Set",\n        "String",\n        "Symbol",\n        "WebAssembly",\n    ].forEach(function(name) {\n        add(name);\n        var ctor = global[name];\n        if (!ctor) return;\n        Object.getOwnPropertyNames(ctor).map(add);\n        if (typeof ctor != "function") return;\n        if (ctor.__proto__) Object.getOwnPropertyNames(ctor.__proto__).map(add);\n        if (ctor.prototype) Object.getOwnPropertyNames(ctor.prototype).map(add);\n        try {\n            Object.getOwnPropertyNames(new ctor()).map(add);\n        } catch (e) {\n            try {\n                Object.getOwnPropertyNames(ctor()).map(add);\n            } catch (e) {}\n        }\n    });\n    return (get_builtins = function() {\n        return names.clone();\n    })();\n\n    function add(name) {\n        names.set(name, true);\n    }\n}\n\nfunction reserve_quoted_keys(ast, reserved) {\n    ast.walk(new TreeWalker(function(node) {\n        if (node instanceof AST_ClassProperty\n            || node instanceof AST_DestructuredKeyVal\n            || node instanceof AST_ObjectProperty) {\n            if (node.key instanceof AST_Node) {\n                addStrings(node.key, add);\n            } else if (node.start && node.start.quote) {\n                add(node.key);\n            }\n        } else if (node instanceof AST_Dot) {\n            if (node.quoted) add(node.property);\n        } else if (node instanceof AST_Sub) {\n            addStrings(node.property, add);\n        }\n    }));\n\n    function add(name) {\n        push_uniq(reserved, name);\n    }\n}\n\nfunction addStrings(node, add) {\n    if (node instanceof AST_Conditional) {\n        addStrings(node.consequent, add);\n        addStrings(node.alternative, add);\n    } else if (node instanceof AST_Sequence) {\n        addStrings(node.tail_node(), add);\n    } else if (node instanceof AST_String) {\n        add(node.value);\n    }\n}\n\nfunction mangle_properties(ast, options) {\n    options = defaults(options, {\n        builtins: false,\n        cache: null,\n        debug: false,\n        domprops: false,\n        keep_quoted: false,\n        regex: null,\n        reserved: null,\n    }, true);\n\n    var reserved = options.builtins ? new Dictionary() : get_builtins();\n    if (!options.domprops && typeof domprops !== "undefined") domprops.forEach(function(name) {\n        reserved.set(name, true);\n    });\n    if (Array.isArray(options.reserved)) options.reserved.forEach(function(name) {\n        reserved.set(name, true);\n    });\n\n    var cname = -1;\n    var cache;\n    if (options.cache) {\n        cache = options.cache.props;\n        cache.each(function(name) {\n            reserved.set(name, true);\n        });\n    } else {\n        cache = new Dictionary();\n    }\n\n    var regex = options.regex;\n\n    // note debug is either false (disabled), or a string of the debug suffix to use (enabled).\n    // note debug may be enabled as an empty string, which is falsy. Also treat passing \'true\'\n    // the same as passing an empty string.\n    var debug = options.debug !== false;\n    var debug_suffix;\n    if (debug) debug_suffix = options.debug === true ? "" : options.debug;\n\n    var names_to_mangle = new Dictionary();\n    var unmangleable = reserved.clone();\n\n    // step 1: find candidates to mangle\n    ast.walk(new TreeWalker(function(node) {\n        if (node.TYPE == "Call") {\n            var exp = node.expression;\n            if (exp instanceof AST_Dot) switch (exp.property) {\n              case "defineProperty":\n              case "getOwnPropertyDescriptor":\n                if (node.args.length < 2) break;\n                exp = exp.expression;\n                if (!(exp instanceof AST_SymbolRef)) break;\n                if (exp.name != "Object") break;\n                if (!exp.definition().undeclared) break;\n                addStrings(node.args[1], add);\n                break;\n              case "hasOwnProperty":\n                if (node.args.length < 1) break;\n                addStrings(node.args[0], add);\n                break;\n            }\n        } else if (node instanceof AST_ClassProperty\n            || node instanceof AST_DestructuredKeyVal\n            || node instanceof AST_ObjectProperty) {\n            if (node.key instanceof AST_Node) {\n                addStrings(node.key, add);\n            } else {\n                add(node.key);\n            }\n        } else if (node instanceof AST_Dot) {\n            if (is_lhs(node, this.parent())) add(node.property);\n        } else if (node instanceof AST_Sub) {\n            if (is_lhs(node, this.parent())) addStrings(node.property, add);\n        }\n    }));\n\n    // step 2: renaming properties\n    ast.walk(new TreeWalker(function(node) {\n        if (node instanceof AST_Binary) {\n            if (node.operator == "in") mangleStrings(node.left);\n        } else if (node.TYPE == "Call") {\n            var exp = node.expression;\n            if (exp instanceof AST_Dot) switch (exp.property) {\n              case "defineProperty":\n              case "getOwnPropertyDescriptor":\n                if (node.args.length < 2) break;\n                exp = exp.expression;\n                if (!(exp instanceof AST_SymbolRef)) break;\n                if (exp.name != "Object") break;\n                if (!exp.definition().undeclared) break;\n                mangleStrings(node.args[1]);\n                break;\n              case "hasOwnProperty":\n                if (node.args.length < 1) break;\n                mangleStrings(node.args[0]);\n                break;\n            }\n        } else if (node instanceof AST_ClassProperty\n            || node instanceof AST_DestructuredKeyVal\n            || node instanceof AST_ObjectProperty) {\n            if (node.key instanceof AST_Node) {\n                mangleStrings(node.key);\n            } else {\n                node.key = mangle(node.key);\n            }\n        } else if (node instanceof AST_Dot) {\n            node.property = mangle(node.property);\n        } else if (node instanceof AST_Sub) {\n            if (!options.keep_quoted) mangleStrings(node.property);\n        }\n    }));\n\n    // only function declarations after this line\n\n    function can_mangle(name) {\n        if (unmangleable.has(name)) return false;\n        if (/^-?[0-9]+(\\.[0-9]+)?(e[+-][0-9]+)?$/.test(name)) return false;\n        return true;\n    }\n\n    function should_mangle(name) {\n        if (reserved.has(name)) {\n            AST_Node.info("Preserving reserved property {this}", name);\n            return false;\n        }\n        if (regex && !regex.test(name)) {\n            AST_Node.info("Preserving excluded property {this}", name);\n            return false;\n        }\n        return cache.has(name) || names_to_mangle.has(name);\n    }\n\n    function add(name) {\n        if (can_mangle(name)) names_to_mangle.set(name, true);\n        if (!should_mangle(name)) unmangleable.set(name, true);\n    }\n\n    function mangle(name) {\n        if (!should_mangle(name)) return name;\n        var mangled = cache.get(name);\n        if (!mangled) {\n            if (debug) {\n                // debug mode: use a prefix and suffix to preserve readability, e.g. o.foo ---\x3e o._$foo$NNN_.\n                var debug_mangled = "_$" + name + "$" + debug_suffix + "_";\n                if (can_mangle(debug_mangled)) mangled = debug_mangled;\n            }\n            // either debug mode is off, or it is on and we could not use the mangled name\n            if (!mangled) do {\n                mangled = base54(++cname);\n            } while (!can_mangle(mangled));\n            if (/^#/.test(name)) mangled = "#" + mangled;\n            cache.set(name, mangled);\n        }\n        AST_Node.info("Mapping property {name} to {mangled}", {\n            mangled: mangled,\n            name: name,\n        });\n        return mangled;\n    }\n\n    function mangleStrings(node) {\n        if (node instanceof AST_Sequence) {\n            mangleStrings(node.tail_node());\n        } else if (node instanceof AST_String) {\n            node.value = mangle(node.value);\n        } else if (node instanceof AST_Conditional) {\n            mangleStrings(node.consequent);\n            mangleStrings(node.alternative);\n        }\n    }\n}\n'},43223:(e,t,r)=>{"use strict";r.d(t,{Z:()=>n});const n='/***********************************************************************\n\n  A JavaScript tokenizer / parser / beautifier / compressor.\n  https://github.com/mishoo/UglifyJS\n\n  -------------------------------- (C) ---------------------------------\n\n                           Author: Mihai Bazon\n                         <mihai.bazon@gmail.com>\n                       http://mihai.bazon.net/blog\n\n  Distributed under the BSD license:\n\n    Copyright 2012 (c) Mihai Bazon <mihai.bazon@gmail.com>\n\n    Redistribution and use in source and binary forms, with or without\n    modification, are permitted provided that the following conditions\n    are met:\n\n        * Redistributions of source code must retain the above\n          copyright notice, this list of conditions and the following\n          disclaimer.\n\n        * Redistributions in binary form must reproduce the above\n          copyright notice, this list of conditions and the following\n          disclaimer in the documentation and/or other materials\n          provided with the distribution.\n\n    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER “AS IS” AND ANY\n    EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE\n    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR\n    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER BE\n    LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,\n    OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,\n    PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR\n    PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\n    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR\n    TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF\n    THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF\n    SUCH DAMAGE.\n\n ***********************************************************************/\n\n"use strict";\n\nfunction SymbolDef(id, scope, orig, init) {\n    this._bits = 0;\n    this.defun = undefined;\n    this.eliminated = 0;\n    this.id = id;\n    this.init = init;\n    this.mangled_name = null;\n    this.name = orig.name;\n    this.orig = [ orig ];\n    this.references = [];\n    this.replaced = 0;\n    this.safe_ids = undefined;\n    this.scope = scope;\n}\n\nSymbolDef.prototype = {\n    forEach: function(fn) {\n        this.orig.forEach(fn);\n        this.references.forEach(fn);\n    },\n    mangle: function(options) {\n        if (this.mangled_name) return;\n        var cache = this.global && options.cache && options.cache.props;\n        if (cache && cache.has(this.name)) {\n            this.mangled_name = cache.get(this.name);\n        } else if (!this.unmangleable(options)) {\n            var def = this.redefined();\n            if (def) {\n                this.mangled_name = def.mangled_name || def.name;\n            } else {\n                this.mangled_name = next_mangled_name(this, options);\n            }\n            if (cache) cache.set(this.name, this.mangled_name);\n        }\n    },\n    redefined: function() {\n        var self = this;\n        var scope = self.defun;\n        if (!scope) return;\n        var name = self.name;\n        var def = scope.variables.get(name)\n            || scope instanceof AST_Toplevel && scope.globals.get(name)\n            || self.orig[0] instanceof AST_SymbolConst && find_if(function(def) {\n                return def.name == name;\n            }, scope.enclosed);\n        if (def && def !== self) return def.redefined() || def;\n    },\n    unmangleable: function(options) {\n        if (this.exported) return true;\n        if (this.undeclared) return true;\n        if (!options.eval && this.scope.pinned()) return true;\n        if (options.keep_fargs && is_funarg(this)) return true;\n        if (options.keep_fnames) {\n            var sym = this.orig[0];\n            if (sym instanceof AST_SymbolClass) return true;\n            if (sym instanceof AST_SymbolDefClass) return true;\n            if (sym instanceof AST_SymbolDefun) return true;\n            if (sym instanceof AST_SymbolLambda) return true;\n        }\n        if (!options.toplevel && this.global) return true;\n        return false;\n    },\n};\n\nDEF_BITPROPS(SymbolDef, [\n    "const_redefs",\n    "cross_loop",\n    "direct_access",\n    "exported",\n    "global",\n    "undeclared",\n]);\n\nfunction is_funarg(def) {\n    return def.orig[0] instanceof AST_SymbolFunarg || def.orig[1] instanceof AST_SymbolFunarg;\n}\n\nvar unary_side_effects = makePredicate("delete ++ --");\n\nfunction is_lhs(node, parent) {\n    if (parent instanceof AST_Assign) return parent.left === node && node;\n    if (parent instanceof AST_DefaultValue) return parent.name === node && node;\n    if (parent instanceof AST_Destructured) return node;\n    if (parent instanceof AST_DestructuredKeyVal) return node;\n    if (parent instanceof AST_ForEnumeration) return parent.init === node && node;\n    if (parent instanceof AST_Unary) return unary_side_effects[parent.operator] && parent.expression;\n}\n\nAST_Toplevel.DEFMETHOD("figure_out_scope", function(options) {\n    options = defaults(options, {\n        cache: null,\n        ie: false,\n    });\n\n    // pass 1: setup scope chaining and handle definitions\n    var self = this;\n    var defun = null;\n    var exported = false;\n    var next_def_id = 0;\n    var scope = self.parent_scope = null;\n    var tw = new TreeWalker(function(node, descend) {\n        if (node instanceof AST_DefClass) {\n            var save_exported = exported;\n            exported = tw.parent() instanceof AST_ExportDeclaration;\n            node.name.walk(tw);\n            exported = save_exported;\n            walk_scope(function() {\n                if (node.extends) node.extends.walk(tw);\n                node.properties.forEach(function(prop) {\n                    prop.walk(tw);\n                });\n            });\n            return true;\n        }\n        if (node instanceof AST_Definitions) {\n            var save_exported = exported;\n            exported = tw.parent() instanceof AST_ExportDeclaration;\n            descend();\n            exported = save_exported;\n            return true;\n        }\n        if (node instanceof AST_LambdaDefinition) {\n            var save_exported = exported;\n            exported = tw.parent() instanceof AST_ExportDeclaration;\n            node.name.walk(tw);\n            exported = save_exported;\n            walk_scope(function() {\n                node.argnames.forEach(function(argname) {\n                    argname.walk(tw);\n                });\n                if (node.rest) node.rest.walk(tw);\n                walk_body(node, tw);\n            });\n            return true;\n        }\n        if (node instanceof AST_Switch) {\n            node.expression.walk(tw);\n            walk_scope(function() {\n                walk_body(node, tw);\n            });\n            return true;\n        }\n        if (node instanceof AST_SwitchBranch) {\n            node.init_vars(scope);\n            descend();\n            return true;\n        }\n        if (node instanceof AST_Try) {\n            walk_scope(function() {\n                walk_body(node, tw);\n            });\n            if (node.bcatch) node.bcatch.walk(tw);\n            if (node.bfinally) node.bfinally.walk(tw);\n            return true;\n        }\n        if (node instanceof AST_With) {\n            var s = scope;\n            do {\n                s = s.resolve();\n                if (s.uses_with) break;\n                s.uses_with = true;\n            } while (s = s.parent_scope);\n            walk_scope(descend);\n            return true;\n        }\n        if (node instanceof AST_BlockScope) {\n            walk_scope(descend);\n            return true;\n        }\n        if (node instanceof AST_Symbol) {\n            node.scope = scope;\n        }\n        if (node instanceof AST_Label) {\n            node.thedef = node;\n            node.references = [];\n        }\n        if (node instanceof AST_SymbolCatch) {\n            scope.def_variable(node).defun = defun;\n        } else if (node instanceof AST_SymbolConst) {\n            var def = scope.def_variable(node);\n            def.defun = defun;\n            if (exported) def.exported = true;\n        } else if (node instanceof AST_SymbolDefun) {\n            var def = defun.def_function(node, tw.parent());\n            if (exported) def.exported = true;\n        } else if (node instanceof AST_SymbolFunarg) {\n            defun.def_variable(node);\n        } else if (node instanceof AST_SymbolLambda) {\n            var def = defun.def_function(node, node.name == "arguments" ? undefined : defun);\n            if (options.ie && node.name != "arguments") def.defun = defun.parent_scope.resolve();\n        } else if (node instanceof AST_SymbolLet) {\n            var def = scope.def_variable(node);\n            if (exported) def.exported = true;\n        } else if (node instanceof AST_SymbolVar) {\n            var def = defun.def_variable(node, node instanceof AST_SymbolImport ? undefined : null);\n            if (exported) def.exported = true;\n        }\n\n        function walk_scope(descend) {\n            node.init_vars(scope);\n            var save_defun = defun;\n            var save_scope = scope;\n            if (node instanceof AST_Scope) defun = node;\n            scope = node;\n            descend();\n            scope = save_scope;\n            defun = save_defun;\n        }\n    });\n    self.make_def = function(orig, init) {\n        return new SymbolDef(++next_def_id, this, orig, init);\n    };\n    self.walk(tw);\n\n    // pass 2: find back references and eval\n    self.globals = new Dictionary();\n    var in_arg = [];\n    var tw = new TreeWalker(function(node) {\n        if (node instanceof AST_Catch) {\n            if (!(node.argname instanceof AST_Destructured)) return;\n            in_arg.push(node);\n            node.argname.walk(tw);\n            in_arg.pop();\n            walk_body(node, tw);\n            return true;\n        }\n        if (node instanceof AST_Lambda) {\n            in_arg.push(node);\n            if (node.name) node.name.walk(tw);\n            node.argnames.forEach(function(argname) {\n                argname.walk(tw);\n            });\n            if (node.rest) node.rest.walk(tw);\n            in_arg.pop();\n            walk_lambda(node, tw);\n            return true;\n        }\n        if (node instanceof AST_LoopControl) {\n            if (node.label) node.label.thedef.references.push(node);\n            return true;\n        }\n        if (node instanceof AST_SymbolDeclaration) {\n            var def = node.definition();\n            def.preinit = def.references.length;\n            if (node instanceof AST_SymbolCatch) {\n                // ensure mangling works if `catch` reuses a scope variable\n                var redef = def.redefined();\n                if (redef) for (var s = node.scope; s; s = s.parent_scope) {\n                    if (!push_uniq(s.enclosed, redef)) break;\n                    if (s === redef.scope) break;\n                }\n            } else if (node instanceof AST_SymbolConst) {\n                // ensure compression works if `const` reuses a scope variable\n                var redef = def.redefined();\n                if (redef) redef.const_redefs = true;\n            } else if (def.scope !== node.scope && (node instanceof AST_SymbolDefun\n                || node instanceof AST_SymbolFunarg\n                || node instanceof AST_SymbolVar)) {\n                node.mark_enclosed(options);\n                var redef = node.scope.find_variable(node.name);\n                if (node.thedef !== redef) {\n                    node.thedef = redef;\n                    redef.orig.push(node);\n                    node.mark_enclosed(options);\n                }\n            }\n            if (node.name != "arguments") return true;\n            var parent = node instanceof AST_SymbolVar && tw.parent();\n            if (parent instanceof AST_VarDef && !parent.value) return true;\n            var sym = node.scope.resolve().find_variable("arguments");\n            if (sym && is_arguments(sym)) sym.scope.uses_arguments = 3;\n            return true;\n        }\n        if (node instanceof AST_SymbolRef) {\n            var name = node.name;\n            var sym = node.scope.find_variable(name);\n            for (var i = in_arg.length; i > 0 && sym;) {\n                i = in_arg.lastIndexOf(sym.scope, i - 1);\n                if (i < 0) break;\n                var decl = sym.orig[0];\n                if (decl instanceof AST_SymbolCatch\n                    || decl instanceof AST_SymbolFunarg\n                    || decl instanceof AST_SymbolLambda) {\n                    node.in_arg = true;\n                    break;\n                }\n                sym = sym.scope.parent_scope.find_variable(name);\n            }\n            if (!sym) {\n                sym = self.def_global(node);\n            } else if (name == "arguments" && is_arguments(sym)) {\n                var parent = tw.parent();\n                if (is_lhs(node, parent)) {\n                    sym.scope.uses_arguments = 3;\n                } else if (sym.scope.uses_arguments < 2\n                    && !(parent instanceof AST_PropAccess && parent.expression === node)) {\n                    sym.scope.uses_arguments = 2;\n                } else if (!sym.scope.uses_arguments) {\n                    sym.scope.uses_arguments = true;\n                }\n            }\n            if (name == "eval") {\n                var parent = tw.parent();\n                if (parent.TYPE == "Call" && parent.expression === node) {\n                    var s = node.scope;\n                    do {\n                        s = s.resolve();\n                        if (s.uses_eval) break;\n                        s.uses_eval = true;\n                    } while (s = s.parent_scope);\n                } else if (sym.undeclared) {\n                    self.uses_eval = true;\n                }\n            }\n            if (sym.init instanceof AST_LambdaDefinition && sym.scope !== sym.init.name.scope) {\n                var scope = node.scope;\n                do {\n                    if (scope === sym.init.name.scope) break;\n                } while (scope = scope.parent_scope);\n                if (!scope) sym.init = undefined;\n            }\n            node.thedef = sym;\n            node.reference(options);\n            return true;\n        }\n    });\n    self.walk(tw);\n\n    // pass 3: fix up any scoping issue with IE8\n    if (options.ie) self.walk(new TreeWalker(function(node) {\