--
-- PostgreSQL database dump
--

-- Dumped from database version 14.7
-- Dumped by pg_dump version 14.9 (Homebrew)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: cache; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.cache (
    env text,
    type text,
    value jsonb,
    ts text
);


ALTER TABLE public.cache OWNER TO postgres;

--
-- Name: clients; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.clients (
    id text,
    siteid text,
    blocked boolean,
    config jsonb,
    name text,
    wired boolean DEFAULT false
);


ALTER TABLE public.clients OWNER TO postgres;

--
-- Name: config; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.config (
    env text NOT NULL,
    config jsonb,
    "corsExceptions" jsonb,
    ver text
);


ALTER TABLE public.config OWNER TO postgres;

--
-- Name: ddns; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ddns (
    ddnsid text,
    ip text,
    auth text,
    ts timestamp without time zone
);


ALTER TABLE public.ddns OWNER TO postgres;

--
-- Name: devices; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.devices (
    id text NOT NULL,
    ip text,
    version text,
    "connectedTime" bigint,
    "lastConnectedTime" text,
    siteid text,
    pubkey text,
    mid text,
    model text,
    name text,
    type integer,
    cfg text,
    hash text,
    "pauseUntil" integer,
    env text,
    ip6 text,
    colors text[],
    chan2 integer,
    width2 integer,
    chan5 integer,
    width5 integer,
    lanip text,
    network text,
    subnet text,
    gateway text,
    dns1 text,
    dns2 text,
    fallback boolean,
    "lanipNow" text,
    vlan integer,
    "detectedSiteids" text[],
    "detectedKey" text,
    "detectedTime" bigint,
    "confirmedSiteids" text[],
    ddnsid text,
    "resetPubkey" text,
    requested jsonb,
    "alwaysOn" boolean,
    leds text,
    bssids text,
    "portsCfg" jsonb,
    radius text,
    txp2 text,
    txp5 text,
    mesh boolean,
    "linkLeds" text,
    "notifiedDiscon" boolean
);


ALTER TABLE public.devices OWNER TO postgres;

--
-- Name: emails; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emails (
    email text NOT NULL,
    passwd text,
    tokens jsonb[],
    name text,
    "lastLogin" timestamp without time zone
);


ALTER TABLE public.emails OWNER TO postgres;

--
-- Name: emails_blobs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.emails_blobs (
    email text NOT NULL,
    "avatarOrig" bytea,
    avatar bytea,
    "avatarType" text,
    "avatarId" text,
    "avatarOrigType" text
);


ALTER TABLE public.emails_blobs OWNER TO postgres;

--
-- Name: events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.events (
    id text NOT NULL,
    siteid text,
    ts timestamp without time zone,
    expires timestamp without time zone,
    type text,
    data jsonb,
    ssidid text,
    handled boolean,
    token text
);


ALTER TABLE public.events OWNER TO postgres;

--
-- Name: iot; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.iot (
    "clientId" text NOT NULL,
    env text
);


ALTER TABLE public.iot OWNER TO postgres;

--
-- Name: mfg; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mfg (
    id text NOT NULL,
    genuine text,
    ts timestamp without time zone,
    mfgname text,
    mfgpassword text,
    claimed boolean,
    model integer,
    x text,
    done timestamp without time zone,
    processing timestamp without time zone
);


ALTER TABLE public.mfg OWNER TO postgres;

--
-- Name: mfgs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.mfgs (
    name text NOT NULL,
    passwords text[]
);


ALTER TABLE public.mfgs OWNER TO postgres;

--
-- Name: oldjwts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.oldjwts (
    token text NOT NULL,
    email text,
    ts timestamp without time zone
);


ALTER TABLE public.oldjwts OWNER TO postgres;

--
-- Name: oldmids; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.oldmids (
    mid text NOT NULL,
    deleted timestamp without time zone,
    emails text[],
    ip text,
    ip6 text,
    id text,
    siteid text,
    "full" boolean
);


ALTER TABLE public.oldmids OWNER TO postgres;

--
-- Name: oops; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.oops (
    ts timestamp without time zone,
    deviceid text,
    type text,
    crash text,
    devicets timestamp without time zone,
    dump bytea
);


ALTER TABLE public.oops OWNER TO postgres;

--
-- Name: sitenames; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sitenames (
    id text NOT NULL,
    email text NOT NULL,
    name text,
    icon text
);


ALTER TABLE public.sitenames OWNER TO postgres;

--
-- Name: sites; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sites (
    id text NOT NULL,
    emails text[],
    "blockedHosts" text[],
    tz text,
    "sshKeys" text[],
    iappkey text,
    meshid text,
    meshpw text,
    "blockedApps" jsonb,
    leds text,
    viewers text[],
    vlans jsonb,
    "portColors" jsonb,
    radii jsonb,
    update boolean,
    "switchLeds" text,
    "syslogHost" text,
    backnet text,
    "dpiEngine" boolean,
    notifications jsonb
);


ALTER TABLE public.sites OWNER TO postgres;

--
-- Name: ssids; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ssids (
    ssid text,
    sites text[],
    emails text[],
    id text NOT NULL,
    config jsonb,
    ftkey text
);


ALTER TABLE public.ssids OWNER TO postgres;

--
-- Name: ssids_blobs; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.ssids_blobs (
    id text NOT NULL,
    hotspotlogo bytea,
    hotspotlogo_ts timestamp without time zone,
    hotspotlogo_type text
);


ALTER TABLE public.ssids_blobs OWNER TO postgres;

--
-- Name: viewers; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.viewers (
    clientid text NOT NULL,
    ip text,
    ip6 text,
    "connectedTime" bigint,
    "lastConnectedTime" bigint
);


ALTER TABLE public.viewers OWNER TO postgres;

--
-- Name: wifiauth; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.wifiauth (
    id text NOT NULL,
    eventid text,
    mac text,
    sched boolean,
    siteid text,
    ssidid text,
    net text,
    expires timestamp without time zone
);


ALTER TABLE public.wifiauth OWNER TO postgres;

--
-- Name: clients clients_id_siteid_idx; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.clients
    ADD CONSTRAINT clients_id_siteid_idx UNIQUE (id, siteid);


--
-- Name: config config_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.config
    ADD CONSTRAINT config_pkey PRIMARY KEY (env);


--
-- Name: ddns ddns_ip; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ddns
    ADD CONSTRAINT ddns_ip UNIQUE (ddnsid, ip);


--
-- Name: devices devices_mid_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.devices
    ADD CONSTRAINT devices_mid_key UNIQUE (mid);


--
-- Name: devices devices_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.devices
    ADD CONSTRAINT devices_pkey PRIMARY KEY (id);


--
-- Name: emails_blobs emails_blobs_avatarId_key; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emails_blobs
    ADD CONSTRAINT "emails_blobs_avatarId_key" UNIQUE ("avatarId");


--
-- Name: emails_blobs emails_blobs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emails_blobs
    ADD CONSTRAINT emails_blobs_pkey PRIMARY KEY (email);


--
-- Name: emails emails_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.emails
    ADD CONSTRAINT emails_pkey PRIMARY KEY (email);


--
-- Name: cache env_type; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.cache
    ADD CONSTRAINT env_type UNIQUE (env, type);


--
-- Name: events events_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.events
    ADD CONSTRAINT events_pkey PRIMARY KEY (id);


--
-- Name: sitenames id_email; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sitenames
    ADD CONSTRAINT id_email UNIQUE (id, email);


--
-- Name: iot iot_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.iot
    ADD CONSTRAINT iot_pkey PRIMARY KEY ("clientId");


--
-- Name: mfg mfg_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mfg
    ADD CONSTRAINT mfg_pkey PRIMARY KEY (id);


--
-- Name: mfgs mfgs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.mfgs
    ADD CONSTRAINT mfgs_pkey PRIMARY KEY (name);


--
-- Name: oldjwts oldjwts_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.oldjwts
    ADD CONSTRAINT oldjwts_pkey PRIMARY KEY (token);


--
-- Name: oldmids oldmids_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.oldmids
    ADD CONSTRAINT oldmids_pkey PRIMARY KEY (mid);


--
-- Name: oops oops_deviceid_ts; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.oops
    ADD CONSTRAINT oops_deviceid_ts UNIQUE (deviceid, ts);


--
-- Name: sites sites_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.sites
    ADD CONSTRAINT sites_pkey PRIMARY KEY (id);


--
-- Name: ssids_blobs ssids_blobs_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ssids_blobs
    ADD CONSTRAINT ssids_blobs_pkey PRIMARY KEY (id);


--
-- Name: ssids ssids_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.ssids
    ADD CONSTRAINT ssids_pkey PRIMARY KEY (id);


--
-- Name: viewers viewers_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.viewers
    ADD CONSTRAINT viewers_pkey PRIMARY KEY (clientid);


--
-- Name: wifiauth wifiauth_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.wifiauth
    ADD CONSTRAINT wifiauth_pkey PRIMARY KEY (id);


--
-- Name: clients_id_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX clients_id_idx ON public.clients USING btree (id);


--
-- Name: clients_siteid_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX clients_siteid_idx ON public.clients USING btree (siteid);


--
-- Name: connectedTime_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "connectedTime_idx" ON public.viewers USING btree ("connectedTime");


--
-- Name: deleted_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX deleted_idx ON public.oldmids USING btree (deleted);


--
-- Name: email_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX email_idx ON public.sitenames USING btree (email);


--
-- Name: emails_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX emails_idx ON public.sites USING btree (emails);


--
-- Name: events_expires; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX events_expires ON public.events USING btree (expires);


--
-- Name: events_handled; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX events_handled ON public.events USING btree (handled);


--
-- Name: events_siteid; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX events_siteid ON public.events USING btree (siteid);


--
-- Name: events_ssidid; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX events_ssidid ON public.events USING btree (ssidid);


--
-- Name: events_token; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX events_token ON public.events USING btree (token);


--
-- Name: events_type; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX events_type ON public.events USING btree (type);


--
-- Name: ip6_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX ip6_idx ON public.viewers USING btree (ip6);


--
-- Name: ip_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX ip_idx ON public.viewers USING btree (ip);


--
-- Name: lastConnectedTime_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "lastConnectedTime_idx" ON public.viewers USING btree ("lastConnectedTime");


--
-- Name: mid_key; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX mid_key ON public.devices USING btree (mid);


--
-- Name: notifiedDiscon_key; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX "notifiedDiscon_key" ON public.devices USING btree ("notifiedDiscon");


--
-- Name: oldmids_emails_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX oldmids_emails_idx ON public.oldmids USING btree (emails);


--
-- Name: oldmids_id_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX oldmids_id_idx ON public.oldmids USING btree (id);


--
-- Name: oldmids_siteid_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX oldmids_siteid_idx ON public.oldmids USING btree (siteid);


--
-- Name: oops_deviceid_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX oops_deviceid_idx ON public.oops USING btree (deviceid);


--
-- Name: oops_devicets_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX oops_devicets_idx ON public.oops USING btree (devicets);


--
-- Name: oops_ts_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX oops_ts_idx ON public.oops USING btree (ts);


--
-- Name: oops_type_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX oops_type_idx ON public.oops USING btree (type);


--
-- Name: siteid_key; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX siteid_key ON public.devices USING btree (siteid);


--
-- Name: ssids_config_colors_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX ssids_config_colors_idx ON public.ssids USING gin (config);


--
-- Name: ssids_emails_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX ssids_emails_idx ON public.ssids USING btree (emails);


--
-- Name: ssids_sites_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX ssids_sites_idx ON public.ssids USING btree (sites);


--
-- Name: ts_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX ts_idx ON public.cache USING btree (ts);


--
-- Name: viewers_idx; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX viewers_idx ON public.sites USING btree (viewers);


--
-- Name: wifiauth_expires; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX wifiauth_expires ON public.wifiauth USING btree (expires);


--
-- Name: wifiauth_sched; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX wifiauth_sched ON public.wifiauth USING btree (sched);


--
-- Name: wifiauth_siteid; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX wifiauth_siteid ON public.wifiauth USING btree (siteid);


--
-- Name: wifiauth_ssidid; Type: INDEX; Schema: public; Owner: postgres
--

CREATE INDEX wifiauth_ssidid ON public.wifiauth USING btree (ssidid);


--
-- Name: SCHEMA public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM rdsadmin;
REVOKE ALL ON SCHEMA public FROM PUBLIC;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

