#!/bin/sh

LOCK_FILE=/var/run/.ssh-setup.lock

finish() {
  rm -f "$LOCK_FILE"
  flock -u 9
}

trap finish EXIT
trap finish INT

exec 9>"$LOCK_FILE"
flock 9

BANNER="# Auto-generated - DO NOT EDIT BELOW HERE"

mkdir -p "$HOME"/.ssh

KEYFILE="$HOME"/.ssh/authorized_keys
if [ ! -e "$KEYFILE" ]; then
  touch "$KEYFILE"
  chmod go-rwx "$KEYFILE"
fi

if grep -q "$BANNER" "$KEYFILE"; then
  sed -i -n "/${BANNER}/q;p" "$KEYFILE"
fi

echo "$BANNER" >> "$KEYFILE"
cat ~alta/authorized_keys >> "$KEYFILE"
