#!/bin/sh

ACCESS_DIR=/usr/share/access
ACCESS_CFG=/etc/default/access
ACCESS_DATA=/var/lib/access
ALTA_USER=alta

if [ -e "$ACCESS_CFG" ]; then
  . "$ACCESS_CFG"
fi

# Only run one at a time
NAME=access-setup
if pidof "$NAME"; then exit 1; fi
printf "$NAME" >/proc/self/comm

LOCK_FILE=/var/run/.access-setup.lock

finish() {
  rm -f "$LOCK_FILE"
  flock -u 9
}

trap finish EXIT
trap finish INT

exec 9>"$LOCK_FILE"
flock 9

newpass() {
  dd if=/dev/random bs=8 count=1 2>/dev/null | base64 | sed -e "s/=$//" \
    -e "s/\//_/g" -e "s/\+/-/g"
}

if [ ! "$mambaAuth" ]; then echo mambaAuth=$(newpass) >>"$ACCESS_CFG"; fi
if [ ! "$jwtKey" ]; then echo jwtKey=$(newpass) >>"$ACCESS_CFG"; fi

if [ ! "$devicePassword" ]; then echo devicePassword=2c4a2691da415db91d >>"$ACCESS_CFG"; fi
if [ ! "$emailFrom" ]; then echo emailFrom=noreply@alta.inc >>"$ACCESS_CFG"; fi

if [ ! "$DBNAME" ]; then echo DBNAME=suave >>"$ACCESS_CFG"; fi
if [ ! "$PGUSER" ]; then echo PGUSER=suave >>"$ACCESS_CFG"; fi
if [ ! "$PGPASSWORD" ]; then echo PGPASSWORD=$(newpass) >>"$ACCESS_CFG"; fi

. "$ACCESS_CFG"

if ! id "$ALTA_USER" >/dev/null 2>&1; then
  useradd "$ALTA_USER" -d "$ACCESS_DATA" -s /bin/bash
fi

if grep -q "^\(local\s*all\s*all\s*\)peer" /etc/postgresql/15/main/pg_hba.conf; then
  sed -i -e "s/^\(local\s*all\s*all\s*\)peer/\1md5/" /etc/postgresql/15/main/pg_hba.conf
  if service postgresql status; then
    service postgresql restart
  fi
fi

_DBNAME=$DBNAME
_PGUSER=$PGUSER
_PGPASSWORD=$PGPASSWORD
unset DBNAME
unset PGUSER
unset PGPASSWORD

if ! su postgres -c 'psql -lqt' 2>/dev/null | grep -q "^\s$_DBNAME"; then
  echo "create user $_PGUSER password '$_PGPASSWORD'" | su postgres -c psql
  echo "create database $_DBNAME owner $_PGUSER" | su postgres -c psql
fi

. "$ACCESS_CFG"

mkdir -p "$ACCESS_DATA"

DOMAIN_FILE="$ACCESS_DATA"/domain.txt
if [ ! -e "$DOMAIN_FILE" ]; then
  echo manage.alta.inc >"$DOMAIN_FILE"
fi

if [ ! -e "$ACCESS_DATA"/server.pem ]; then
  ln -s /etc/ssl/private/ssl-cert-snakeoil.key "$ACCESS_DATA"/server.key
  ln -s /etc/ssl/certs/ssl-cert-snakeoil.pem "$ACCESS_DATA"/server.pem
  chown -h "$ALTA_USER":"$ALTA_USER" "$ACCESS_DATA"/server.*
fi

chown "$ALTA_USER":"$ALTA_USER" -R /sys/bus/i2c/devices/0-0030/

if ! grep -q -e local.manage.alta.inc /etc/hosts; then
  echo 0.0.0.255 local.manage.alta.inc >>/etc/hosts
fi

ACCESS_NGINX=/etc/nginx/sites-available/access

cat "$ACCESS_DIR"/be/nginx.conf | sed -e "s/\$mambaAuth/$mambaAuth/g" > "$ACCESS_NGINX".tmp

if [ -L /etc/nginx/sites-enabled/default -a ! -e "$ACCESS_DATA"/.no-nginx-def ]; then
  rm /etc/nginx/sites-enabled/default
  touch "$ACCESS_DATA"/.no-nginx-def
fi
ln -s ../sites-available/access /etc/nginx/sites-enabled/access 2>/dev/null

if diff -q "$ACCESS_NGINX".tmp "$ACCESS_NGINX"; then
  rm "$ACCESS_NGINX".tmp
else
  mv "$ACCESS_NGINX".tmp "$ACCESS_NGINX"
  service nginx restart
fi

if [ -e /proc/mac -a -e /dev/ttyMSM1 ]; then
  chown "$ALTA_USER":"$ALTA_USER" /dev/ttyMSM1
  GPIO=490
  if [ ! -d /sys/class/gpio/gpio${GPIO} ]; then
    echo "$GPIO" > /sys/class/gpio/export
  fi
  echo out > /sys/class/gpio/gpio${GPIO}/direction
  echo 0 > /sys/class/gpio/gpio${GPIO}/value
  echo 1 > /sys/class/gpio/gpio${GPIO}/value
  chown "$ALTA_USER":"$ALTA_USER" /sys/class/gpio/gpio${GPIO}/value
  echo /sys/class/gpio/gpio${GPIO}/value >"$ACCESS_DATA"/bt_gpio
fi

chown -R "$ALTA_USER":"$ALTA_USER" "$ACCESS_DATA"
chmod go-rwx "$ACCESS_DATA"

sync

systemctl daemon-reload
