#!/bin/sh

. $(dirname $0)/env.sh

if [ "$1" != begin ]; then
  exit 1
fi

if [ "$2" != dns-01 ]; then
  exit 1
fi

if [ ! "$MID" ]; then
  logger uacme-hook: Not set up yet
  exit
fi

NETIF=$(ip r | grep "^default" | sed -e "s/.*dev //" -e "s/ .*//")
IPADDR=$(ip a s dev "$NETIF" | grep "^\s*inet " | head -n 1 | sed -e "s/\s*inet //" -e "s/\/.*//")
IPDASH=$(echo "$IPADDR" | sed -e "s/\./-/g")
IP6LL=$(ip -6 a | grep "^\s*inet6 .*scope link" | head -n 1 | sed -e "s,\s*inet6 ,," -e "s,\/.*,,")
IP6=$(ip -6 a s | grep "^\s*inet6 .*scope global" | grep -v "inet6 f\(c\|d\)" | head -n 1 | sed -e "s,\s*inet6 ,," -e "s,\/.*,,")

IPS_HASH_FILE="$CFGDIR"/.ips.hash
IPS_HASH=$(echo "${IPADDR}${IP6}${IP6LL}" | md5sum)
OLD_IPS_HASH=$(cat "$IPS_HASH_FILE" 2>/dev/null)

if [ ! "$5" -a "$IPS_HASH" = "$OLD_IPS_HASH" ]; then
  exit
fi
echo "$IPS_HASH" >"$IPS_HASH_FILE"

JSON="{\"mid\":\"$MID\",\"ip\":\"$IPDASH\",\"ip6\":\"$IP6\",\"ip6ll\":\"$IP6LL\",\"auth\":\"$5\",\"replace\":true}"
curl -L --retry 3 -m 7 -X POST https://$API_PREFIX/device/cert \
  -H 'Content-Type: application/json' -d "$JSON"
