#!/bin/bash

. $(dirname $0)/env.sh

LOCK_FILE=/tmp/.uacme.lock

exec 1000>"$LOCK_FILE"

flock 1000

finish() {
  flock -u 1000
}
trap finish EXIT

UACMELOG=/tmp/uacme.log

ddnsid=$(cat "$CFGDIR"/ddnsid.txt)

_FQDN="$ddnsid".ddns."$DOMAIN"
FQDN=*."$_FQDN"
mkdir -p "$CERTS"

if [ ! -e "$CERTS"/"$ddnsid"/private/key.pem ]; then
  uacme -v -c "$CERTS"/"$ddnsid" -y new 2>&1 | tee -a "$UACMELOG"
fi
logger "Updating cert for $FQDN"
echo "$(date): Updating cert for $FQDN" >>"$UACMELOG"

issue() {
  uacme -v -c "$CERTS"/"$ddnsid" -h $(pwd)/uacme-hook.sh issue "$_FQDN" "$FQDN" 2>&1 | tee -a "$UACMELOG"
}

# Sometimes LE takes multiple attempts...
TO=0
while [ "$TO" -lt 3 ]; do
  if issue; then
    ln -sf "$CERTS"/"$ddnsid"/"$_FQDN"/cert.pem "$CERTS"/server.pem
    ln -sf "$CERTS"/"$ddnsid"/private/"$_FQDN"/key.pem "$CERTS"/server.key
    ln -sf "$CERTS"/server.pem "$CFGDIR"/server.pem
    ln -sf "$CERTS"/server.key "$CFGDIR"/server.key
    sudo "$ACCESS_BE_DIR"/restart-nginx.sh
  fi
  if [ -e "$CERTS"/"$ddnsid"/"$_FQDN"/cert.pem ]; then
    break
  fi
  sleep 10
  TO=$((TO+1))
done
