const connCheckPeriod = 15000;
const domain = 'alta.inc';

const domainEsc = domain.replace(/\./g, '\\.');
const fetchers = {};

const ACCESS_MODEL = '6';

const fetchJson = async (url, options) => {
  let retries = 1;

  doFetch = async () => {
    const aborter = new AbortController();
    const { signal } = aborter;
    let ret;
    fetchers[aborter] = true;

    try {
      ret = await (await fetch(`${url}`, {
        headers: { 'Content-Type': 'application/json' },
        signal,
        ...options
      })).json();
    } catch (e) {
      console.error(e);
      e.error = true;
      ret = e;
    }
    delete fetchers[aborter];
    return ret;
  };

  while (retries-- > 0) {
    const resp = await doFetch();
    if (!resp.error)
      return resp;
  }
  return {};
};

let plainOk;
let plainOkTimes = 0;
let secureOk;
let backend;

const tryAccess = async url => {
  try {
    const resp = await fetchJson(`${url}?isAccess=true`);
    return resp?.isAccess;
  } catch (e) {
    return false;
  }
};

const tryProtocol = async protocol => {
  const statusAPI = '/api/status';
  let url = `${protocol}://local.${backend}`;
  if (await tryAccess(`${url}${statusAPI}`)) {
    return url;
  } else {
    url = `${protocol}://${backend}`;
    if (await tryAccess(`${url}${statusAPI}`)) {
      return url;
    }
  }
};

const checkBackend = async () => {
  let url;

  if (!plainOk)
    plainOk = await tryProtocol('http');

  if (plainOk)
    plainOkTimes++;

  if (!secureOk)
    secureOk = await tryProtocol('https');

  if (secureOk) {
    window.location = secureOk;
  } else if (plainOk && plainOkTimes >= 60) {
    // Give Let's encrypt one minute in addition to DDNS setup
    window.location = plainOk;
  } else if (!plainOk || !secureOk) {
    setTimeout(checkBackend, 1000);
  }
};

const checkDdns = async () => {
  const resp = await fetchJson(`../api/activated`);
  if (resp.success === false && !resp.id)
    $('#activate-code').slideDown();
  if (!resp?.success || !resp.ddns) {
    setTimeout(checkDdns, 1000);
  } else {
    backend = resp.ddns;
    setTimeout(checkBackend, 0);
  }
};

$(document).ready(async function () {
  $('#activate-form').on('submit', async function (e) {
    e.preventDefault();
    const body = {
      code: $('#code').val(),
      email: $('#email').val(),
      model: ACCESS_MODEL,
    };
    const ret = await fetchJson(`../api/activate`,
      { method: 'POST', body: JSON.stringify(body) });

    console.log('ret', ret);

    if (ret && ret.success) {
      console.log('success');
      if (ret.id)
        $('#activate-ok2').slideDown();
      else $('#activate-ok').slideDown();
      $('#activate-fail').slideUp();
      $('#connect-div').slideUp();
      $('#code, #email').attr('disabled', true);
    } else {
      $('#activate-ok').slideUp();
      $('#activate-fail').slideDown();
    }
  });

  setTimeout(checkDdns, 50);

  $('#loader').toggle(false);
  $('#access-box').toggle(true);
  $('#password-div').toggle(true);

  $('#logo-div').toggle(true);
  $('#logo').attr('src', `img/alta.svg`);

  $('#connect').text('Activate');
});
